/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.CheckstyleRefactorVisitor;
import org.openrewrite.checkstyle.policy.ParenthesesToken;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@AutoConfigure
public class UnnecessaryParentheses
extends CheckstyleRefactorVisitor {
    private static final Set<ParenthesesToken> DEFAULT_TOKENS = Stream.of(ParenthesesToken.EXPR, ParenthesesToken.IDENT, ParenthesesToken.NUM_DOUBLE, ParenthesesToken.NUM_FLOAT, ParenthesesToken.NUM_INT, ParenthesesToken.NUM_LONG, ParenthesesToken.STRING_LITERAL, ParenthesesToken.LITERAL_NULL, ParenthesesToken.LITERAL_FALSE, ParenthesesToken.LITERAL_TRUE, ParenthesesToken.ASSIGN, ParenthesesToken.BAND_ASSIGN, ParenthesesToken.BOR_ASSIGN, ParenthesesToken.BSR_ASSIGN, ParenthesesToken.BXOR_ASSIGN, ParenthesesToken.DIV_ASSIGN, ParenthesesToken.MINUS_ASSIGN, ParenthesesToken.MOD_ASSIGN, ParenthesesToken.PLUS_ASSIGN, ParenthesesToken.SL_ASSIGN, ParenthesesToken.SR_ASSIGN, ParenthesesToken.STAR_ASSIGN, ParenthesesToken.LAMBDA).collect(Collectors.toSet());
    private Set<ParenthesesToken> tokens;

    public UnnecessaryParentheses() {
        this.setCursoringOn();
    }

    @Override
    protected void configure(CheckstyleRefactorVisitor.Module m) {
        this.tokens = m.propAsTokens(ParenthesesToken.class, DEFAULT_TOKENS);
    }

    public <T extends J> J visitParentheses(J.Parentheses<T> parens) {
        if (parens.getTree() instanceof J.Ident && this.tokens.contains((Object)ParenthesesToken.IDENT)) {
            this.maybeUnwrapParentheses(this.getCursor());
        }
        return super.visitParentheses(parens);
    }

    public J visitLiteral(J.Literal literal) {
        JavaType.Primitive type = literal.getType();
        if (this.tokens.contains((Object)ParenthesesToken.NUM_INT) && type == JavaType.Primitive.Int || this.tokens.contains((Object)ParenthesesToken.NUM_DOUBLE) && type == JavaType.Primitive.Double || this.tokens.contains((Object)ParenthesesToken.NUM_LONG) && type == JavaType.Primitive.Long || this.tokens.contains((Object)ParenthesesToken.NUM_FLOAT) && type == JavaType.Primitive.Float || this.tokens.contains((Object)ParenthesesToken.STRING_LITERAL) && type == JavaType.Primitive.String || this.tokens.contains((Object)ParenthesesToken.LITERAL_FALSE) && type == JavaType.Primitive.Boolean && literal.getValue() == Boolean.valueOf(false) || this.tokens.contains((Object)ParenthesesToken.LITERAL_TRUE) && type == JavaType.Primitive.Boolean && literal.getValue() == Boolean.valueOf(true)) {
            this.maybeUnwrapParentheses(this.getCursor());
        }
        return super.visitLiteral(literal);
    }

    public J visitAssignOp(J.AssignOp assignOp) {
        Expression assignment = assignOp.getAssignment();
        J.AssignOp.Operator op = assignOp.getOperator();
        if (assignment instanceof J.Parentheses && (this.tokens.contains((Object)ParenthesesToken.BAND_ASSIGN) && op instanceof J.AssignOp.Operator.BitAnd || this.tokens.contains((Object)ParenthesesToken.BOR_ASSIGN) && op instanceof J.AssignOp.Operator.BitOr || this.tokens.contains((Object)ParenthesesToken.BSR_ASSIGN) && op instanceof J.AssignOp.Operator.UnsignedRightShift || this.tokens.contains((Object)ParenthesesToken.BXOR_ASSIGN) && op instanceof J.AssignOp.Operator.BitXor || this.tokens.contains((Object)ParenthesesToken.SR_ASSIGN) && op instanceof J.AssignOp.Operator.RightShift || this.tokens.contains((Object)ParenthesesToken.SL_ASSIGN) && op instanceof J.AssignOp.Operator.LeftShift || this.tokens.contains((Object)ParenthesesToken.MINUS_ASSIGN) && op instanceof J.AssignOp.Operator.Subtraction || this.tokens.contains((Object)ParenthesesToken.DIV_ASSIGN) && op instanceof J.AssignOp.Operator.Division || this.tokens.contains((Object)ParenthesesToken.PLUS_ASSIGN) && op instanceof J.AssignOp.Operator.Addition || this.tokens.contains((Object)ParenthesesToken.STAR_ASSIGN) && op instanceof J.AssignOp.Operator.Multiplication || this.tokens.contains((Object)ParenthesesToken.MOD_ASSIGN) && op instanceof J.AssignOp.Operator.Modulo)) {
            this.maybeUnwrapParentheses(new Cursor(this.getCursor(), (Tree)assignment));
        }
        return super.visitAssignOp(assignOp);
    }

    public J visitAssign(J.Assign assign) {
        if (this.tokens.contains((Object)ParenthesesToken.ASSIGN)) {
            this.maybeUnwrapParentheses(this.getCursor());
        }
        return super.visitAssign(assign);
    }

    public J visitVariable(J.VariableDecls.NamedVar variable) {
        if (this.tokens.contains((Object)ParenthesesToken.ASSIGN) && variable.getInitializer() != null) {
            this.maybeUnwrapParentheses(new Cursor(this.getCursor(), (Tree)variable.getInitializer()));
        }
        return super.visitVariable(variable);
    }

    public J visitLambda(J.Lambda lambda) {
        J.Lambda l = (J.Lambda)this.refactor((Tree)lambda, x$0 -> super.visitLambda(x$0));
        if (lambda.getParamSet().getParams().size() == 1 && lambda.getParamSet().isParenthesized() && lambda.getParamSet().getParams().get(0) instanceof J.VariableDecls && ((J.VariableDecls)lambda.getParamSet().getParams().get(0)).getTypeExpr() == null) {
            l = l.withParamSet(lambda.getParamSet().withParenthesized(false));
        }
        return l;
    }
}

