/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.CheckstyleRefactorVisitor;
import org.openrewrite.checkstyle.policy.LeftCurlyPolicy;
import org.openrewrite.checkstyle.policy.Token;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.utilities.SpansMultipleLines;

@AutoConfigure
public class LeftCurly
extends CheckstyleRefactorVisitor {
    private static final Set<Token> DEFAULT_TOKENS = Stream.of(Token.ANNOTATION_DEF, Token.CLASS_DEF, Token.CTOR_DEF, Token.ENUM_CONSTANT_DEF, Token.ENUM_DEF, Token.INTERFACE_DEF, Token.LAMBDA, Token.LITERAL_CASE, Token.LITERAL_CATCH, Token.LITERAL_DEFAULT, Token.LITERAL_DO, Token.LITERAL_ELSE, Token.LITERAL_FINALLY, Token.LITERAL_FOR, Token.LITERAL_IF, Token.LITERAL_SWITCH, Token.LITERAL_SYNCHRONIZED, Token.LITERAL_TRY, Token.LITERAL_WHILE, Token.METHOD_DEF, Token.OBJBLOCK, Token.STATIC_INIT).collect(Collectors.toSet());
    private LeftCurlyPolicy option;
    private boolean ignoreEnums;
    private Set<Token> tokens;

    public LeftCurly() {
        this.setCursoringOn();
    }

    @Override
    protected void configure(CheckstyleRefactorVisitor.Module m) {
        this.option = m.propAsOptionValue(LeftCurlyPolicy::valueOf, LeftCurlyPolicy.EOL);
        this.ignoreEnums = m.prop("ignoreEnums", false);
        this.tokens = m.propAsTokens(Token.class, DEFAULT_TOKENS);
    }

    public J visitBlock(J.Block<J> block) {
        boolean spansMultipleLines;
        J.Block<J> b = (J.Block<J>)this.refactor((Tree)block, x$0 -> super.visitBlock(x$0));
        Cursor containing = this.getCursor().getParentOrThrow();
        boolean bl = spansMultipleLines = LeftCurlyPolicy.NLOW.equals((Object)this.option) ? (Boolean)new SpansMultipleLines((J)containing.getTree(), block).visit(containing.getTree()) : false;
        if (!this.satisfiesPolicy(this.option, block, containing.getTree(), spansMultipleLines)) {
            b = LeftCurly.formatCurly(this.option, b, spansMultipleLines, containing);
        }
        return b;
    }

    private boolean satisfiesPolicy(LeftCurlyPolicy option, J.Block<J> block, Tree containing, boolean spansMultipleLines) {
        switch (option) {
            case EOL: {
                if (this.ignoreEnums && containing instanceof J.Case) {
                    return true;
                }
                if (block.getStatic() == null) {
                    return !block.getFormatting().getPrefix().contains("\n");
                }
                return !block.getStatic().getFormatting().getSuffix().contains("\n");
            }
            case NL: {
                if (block.getStatic() == null) {
                    return block.getFormatting().getPrefix().contains("\n");
                }
                return block.getStatic().getFormatting().getSuffix().contains("\n");
            }
        }
        return spansMultipleLines && this.satisfiesPolicy(LeftCurlyPolicy.NL, block, containing, true) || !spansMultipleLines && this.satisfiesPolicy(LeftCurlyPolicy.EOL, block, containing, false);
    }

    private static J.Block<J> formatCurly(LeftCurlyPolicy option, J.Block<J> block, boolean spansMultipleLines, Cursor containing) {
        switch (option) {
            case EOL: {
                Tree parent = containing.getParentOrThrow().getTree();
                if ((parent instanceof J.ClassDecl || parent instanceof J.NewClass) && block.getStatic() == null) {
                    return block;
                }
                return block.getStatic() == null ? (J.Block)block.withPrefix(" ") : block.withStatic((J.Empty)block.getStatic().withSuffix(" "));
            }
            case NL: {
                return block.getStatic() == null ? (J.Block)block.withPrefix(block.getEnd().getPrefix()) : block.withStatic((J.Empty)block.getStatic().withSuffix(block.getEnd().getPrefix()));
            }
        }
        return LeftCurly.formatCurly(spansMultipleLines ? LeftCurlyPolicy.NL : LeftCurlyPolicy.EOL, block, spansMultipleLines, containing);
    }
}

