/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.circleci;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.MergeYamlVisitor;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class InstallOrb
extends Recipe {
    @Option(displayName="Orb key", description="The orb key to be followed by an orb slug identifying a specific orb version.", example="kube")
    private final String orbKey;
    @Option(displayName="Slug", description="A specific orb to install, in the form `<namespace>/<orb-name>@1.2.3`.", example="circleci/kubernetes@0.11.0")
    private final String slug;

    public String getDisplayName() {
        return "Install an orb";
    }

    public String getDescription() {
        return "Install a CircleCI [orb](https://circleci.com/docs/2.0/orb-intro/) if it is not already installed.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final JsonPathMatcher orbs = new JsonPathMatcher("$.orbs");
        return Preconditions.check((Recipe)new FindSourceFiles(".circleci/config.yml"), (TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Document visitDocument(Yaml.Document document, ExecutionContext ctx) {
                Yaml.Document d = super.visitDocument(document, (Object)ctx);
                if (!orbs.find(this.getCursor()).isPresent() || Boolean.TRUE.equals(this.getCursor().getMessage("INSERT_ORB"))) {
                    String yaml = "orbs:\n  " + InstallOrb.this.orbKey + ": " + InstallOrb.this.slug;
                    this.doAfterVisit((TreeVisitor)new MergeYamlVisitor((Yaml)document.getBlock(), yaml, false, null, null, null));
                }
                return d;
            }

            public Yaml.Mapping visitMapping(Yaml.Mapping mapping, ExecutionContext ctx) {
                if (orbs.matches(this.getCursor().getParentOrThrow())) {
                    for (Yaml.Mapping.Entry entry : mapping.getEntries()) {
                        if (!(entry.getValue() instanceof Yaml.Scalar)) continue;
                        String existingSlug = ((Yaml.Scalar)entry.getValue()).getValue();
                        if (!InstallOrb.this.slug.split("@")[0].equals(existingSlug.split("@")[0])) continue;
                        return mapping;
                    }
                    this.getCursor().putMessageOnFirstEnclosing(Yaml.Document.class, "INSERT_ORB", (Object)true);
                }
                return super.visitMapping(mapping, (Object)ctx);
            }
        });
    }

    @Generated
    public InstallOrb(String orbKey, String slug) {
        this.orbKey = orbKey;
        this.slug = slug;
    }

    @Generated
    public String getOrbKey() {
        return this.orbKey;
    }

    @Generated
    public String getSlug() {
        return this.slug;
    }

    @Generated
    public String toString() {
        return "InstallOrb(orbKey=" + this.getOrbKey() + ", slug=" + this.getSlug() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstallOrb)) {
            return false;
        }
        InstallOrb other = (InstallOrb)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$orbKey = this.getOrbKey();
        String other$orbKey = other.getOrbKey();
        if (this$orbKey == null ? other$orbKey != null : !this$orbKey.equals(other$orbKey)) {
            return false;
        }
        String this$slug = this.getSlug();
        String other$slug = other.getSlug();
        return !(this$slug == null ? other$slug != null : !this$slug.equals(other$slug));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InstallOrb;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $orbKey = this.getOrbKey();
        result = result * 59 + ($orbKey == null ? 43 : $orbKey.hashCode());
        String $slug = this.getSlug();
        result = result * 59 + ($slug == null ? 43 : $slug.hashCode());
        return result;
    }
}

