/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cloudsuitability;

import java.time.Duration;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.SearchResult;

public class FindJni
extends Recipe {
    public String getDisplayName() {
        return "Find uses of JNI";
    }

    public String getDescription() {
        return "A few conditions have to be met to make JNI calls.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                if (method.hasModifier(J.Modifier.Type.Native)) {
                    m = (J.MethodDeclaration)SearchResult.found((Tree)m);
                }
                return m;
            }
        };
    }
}

