/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { SIGNAL_NODE, signalSetFn } from '@angular/core/primitives/signals';
export const REQUIRED_UNSET_VALUE = /* @__PURE__ */ Symbol('InputSignalNode#UNSET');
// Note: Using an IIFE here to ensure that the spread assignment is not considered
// a side-effect, ending up preserving `COMPUTED_NODE` and `REACTIVE_NODE`.
// TODO: remove when https://github.com/evanw/esbuild/issues/3392 is resolved.
export const INPUT_SIGNAL_NODE = /* @__PURE__ */ (() => {
    return {
        ...SIGNAL_NODE,
        transformFn: undefined,
        applyValueToInputSignal(node, value) {
            signalSetFn(node, value);
        }
    };
})();
//# sourceMappingURL=data:application/json;base64,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