/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { REQUIRED_UNSET_VALUE } from '../input/input_signal_node';
import { createModelSignal } from './model_signal';
export function modelFunction(initialValue) {
    return createModelSignal(initialValue);
}
export function modelRequiredFunction() {
    return createModelSignal(REQUIRED_UNSET_VALUE);
}
/**
 * `model` declares a writeable signal that is exposed as an input/output pair on the containing
 * directive. The input name is taken either from the class member or from the `alias` option.
 * The output name is generated by taking the input name and appending `Change`.
 *
 * Initializes a model with an initial value. If no explicit value
 * is specified, Angular will use `undefined`.
 *
 * Consider using `model.required` for models that don't need an
 * initial value.
 *
 * @usageNotes
 * Initialize a model in your directive or component by declaring a
 * class field and initializing it with the `model()` or `model.required()`
 * function.
 *
 * ```ts
 * @Directive({..})
 * export class MyDir {
 *   firstName = model<string>();            // string|undefined
 *   lastName = model.required<string>();    // string
 *   age = model(0);                         // number
 * }
 * ```
 *
 * @developerPreview
 */
export const model = (() => {
    // Note: This may be considered a side-effect, but nothing will depend on
    // this assignment, unless this `model` constant export is accessed. It's a
    // self-contained side effect that is local to the user facing `model` export.
    modelFunction.required = modelRequiredFunction;
    return modelFunction;
})();
//# sourceMappingURL=data:application/json;base64,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