/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * Public Test Library for unit testing Angular applications. Assumes that you are running
 * with Jasmine, Mocha, or a similar framework which exports a beforeEach function and
 * allows tests to be asynchronous by either returning a promise or using a 'done' parameter.
 */
import { resetFakeAsyncZone } from './fake_async';
import { TestBedImpl } from './test_bed';
// Reset the test providers and the fake async zone before each test.
// We keep a guard because somehow this file can make it into a bundle and be executed
// beforeEach is only defined when executing the tests
globalThis.beforeEach?.(getCleanupHook(false));
// We provide both a `beforeEach` and `afterEach`, because the updated behavior for
// tearing down the module is supposed to run after the test so that we can associate
// teardown errors with the correct test.
// We keep a guard because somehow this file can make it into a bundle and be executed
// afterEach is only defined when executing the tests
globalThis.afterEach?.(getCleanupHook(true));
function getCleanupHook(expectedTeardownValue) {
    return () => {
        const testBed = TestBedImpl.INSTANCE;
        if (testBed.shouldTearDownTestingModule() === expectedTeardownValue) {
            testBed.resetTestingModule();
            resetFakeAsyncZone();
        }
    };
}
/**
 * This API should be removed. But doing so seems to break `google3` and so it requires a bit of
 * investigation.
 *
 * A work around is to mark it as `@codeGenApi` for now and investigate later.
 *
 * @codeGenApi
 */
// TODO(iminar): Remove this code in a safe way.
export const __core_private_testing_placeholder__ = '';
//# sourceMappingURL=data:application/json;base64,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