/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.codemods.migrate.angular;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public class NodeUtils {
    public static Optional<Path> findGlobalNpmrc() {
        Path globalNpmrc;
        String envUserConfig = System.getenv("NPM_CONFIG_USERCONFIG");
        if (envUserConfig != null && new File(envUserConfig).exists()) {
            return Optional.of(Paths.get(envUserConfig, new String[0]));
        }
        Path projectNpmrc = Paths.get(System.getProperty("user.dir"), ".npmrc");
        if (projectNpmrc.toFile().exists()) {
            return Optional.of(projectNpmrc);
        }
        Path userNpmrc = Paths.get(System.getProperty("user.home"), ".npmrc");
        if (userNpmrc.toFile().exists()) {
            return Optional.of(userNpmrc);
        }
        String prefix = NodeUtils.getNpmPrefix();
        if (prefix != null && (globalNpmrc = Paths.get(prefix, "etc", "npmrc")).toFile().exists()) {
            return Optional.of(globalNpmrc);
        }
        return Optional.empty();
    }

    private static @Nullable String getNpmPrefix() {
        ProcessBuilder builder = new ProcessBuilder("npm", "config", "get", "prefix");
        builder.redirectErrorStream(true);
        try {
            Process process = builder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine();
            process.waitFor();
            return line != null ? line.trim() : null;
        }
        catch (IOException | InterruptedException e) {
            return null;
        }
    }
}

