// For Library Version: 1.120.12

declare module "sap/zen/crosstab/library" {}

declare module "sap/zen/crosstab/Crosstab" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { CSSSize } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Add your documentation for the new Crosstab
   *
   * @deprecated (since 1.89.0) - Please use the WD Grid control instead.
   */
  export default class Crosstab extends Control {
    /**
     * Constructor for a new Crosstab.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $CrosstabSettings
    );
    /**
     * Constructor for a new Crosstab.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $CrosstabSettings
    );

    /**
     * Creates a new subclass of class sap.zen.crosstab.Crosstab with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Crosstab>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.zen.crosstab.Crosstab.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Height of the Crosstab.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Width of the Crosstab.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * Height of the Crosstab.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Width of the Crosstab.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Crosstab constructor.
   *
   * @deprecated (since 1.89.0) - Please use the WD Grid control instead.
   */
  export interface $CrosstabSettings extends $ControlSettings {
    /**
     * Width of the Crosstab.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Height of the Crosstab.
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/zen/crosstab/DataCell" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Add your documentation for the new DataCell
   *
   * @deprecated (since 1.89.0) - Please use the WD Grid control instead.
   */
  export default class DataCell extends Control {
    /**
     * Constructor for a new DataCell.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $DataCellSettings
    );
    /**
     * Constructor for a new DataCell.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $DataCellSettings
    );

    /**
     * Creates a new subclass of class sap.zen.crosstab.DataCell with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DataCell>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.zen.crosstab.DataCell.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;

    addStyle(sSStyle: string): void;
    /**
     * Gets current value of property {@link #getArea area}.
     *
     * the area of the data cell
     *
     *
     * @returns Value of property `area`
     */
    getArea(): object;
    /**
     * Gets current value of property {@link #getCol col}.
     *
     * the column of the data cell
     *
     *
     * @returns Value of property `col`
     */
    getCol(): int;
    /**
     * Gets current value of property {@link #getRow row}.
     *
     * the row of the data cell
     *
     *
     * @returns Value of property `row`
     */
    getRow(): int;
    /**
     * Gets current value of property {@link #getTableCol tableCol}.
     *
     * the table column of the data cell
     *
     *
     * @returns Value of property `tableCol`
     */
    getTableCol(): int;
    /**
     * Gets current value of property {@link #getTableRow tableRow}.
     *
     * the table row of the data cell
     *
     *
     * @returns Value of property `tableRow`
     */
    getTableRow(): int;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * the text of the data cell
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Sets a new value for property {@link #getArea area}.
     *
     * the area of the data cell
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setArea(
      /**
       * New value for property `area`
       */
      oArea?: object
    ): this;
    /**
     * Sets a new value for property {@link #getCol col}.
     *
     * the column of the data cell
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCol(
      /**
       * New value for property `col`
       */
      iCol?: int
    ): this;
    /**
     * Sets a new value for property {@link #getRow row}.
     *
     * the row of the data cell
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRow(
      /**
       * New value for property `row`
       */
      iRow?: int
    ): this;
    /**
     * Sets a new value for property {@link #getTableCol tableCol}.
     *
     * the table column of the data cell
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTableCol(
      /**
       * New value for property `tableCol`
       */
      iTableCol?: int
    ): this;
    /**
     * Sets a new value for property {@link #getTableRow tableRow}.
     *
     * the table row of the data cell
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTableRow(
      /**
       * New value for property `tableRow`
       */
      iTableRow?: int
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * the text of the data cell
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DataCell constructor.
   *
   * @deprecated (since 1.89.0) - Please use the WD Grid control instead.
   */
  export interface $DataCellSettings extends $ControlSettings {
    /**
     * the text of the data cell
     */
    text?: string | PropertyBindingInfo;

    /**
     * the area of the data cell
     */
    area?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * the row of the data cell
     */
    row?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * the column of the data cell
     */
    col?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * the table row of the data cell
     */
    tableRow?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * the table column of the data cell
     */
    tableCol?: int | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/zen/crosstab/HeaderCell" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Add your documentation for the new HeaderCell
   *
   * @deprecated (since 1.89.0) - Please use the WD Grid control instead.
   */
  export default class HeaderCell extends Control {
    /**
     * Constructor for a new HeaderCell.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $HeaderCellSettings
    );
    /**
     * Constructor for a new HeaderCell.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $HeaderCellSettings
    );

    /**
     * Creates a new subclass of class sap.zen.crosstab.HeaderCell with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, HeaderCell>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.zen.crosstab.HeaderCell.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getAlignment alignment}.
     *
     * the alignment of the cell
     *
     *
     * @returns Value of property `alignment`
     */
    getAlignment(): string;
    /**
     * Gets current value of property {@link #getArea area}.
     *
     * area of the cell
     *
     *
     * @returns Value of property `area`
     */
    getArea(): object;
    /**
     * Gets current value of property {@link #getCol col}.
     *
     * the column of the cell in the crosstab
     *
     *
     * @returns Value of property `col`
     */
    getCol(): int;
    /**
     * Gets current value of property {@link #getColSpan colSpan}.
     *
     * Colspan of the cell
     *
     *
     * @returns Value of property `colSpan`
     */
    getColSpan(): int;
    /**
     * Gets current value of property {@link #getDrillState drillState}.
     *
     * the drillstate of the cell
     *
     *
     * @returns Value of property `drillState`
     */
    getDrillState(): string;
    /**
     * Gets current value of property {@link #getEffectiveColSpan effectiveColSpan}.
     *
     * the effective col span
     *
     *
     * @returns Value of property `effectiveColSpan`
     */
    getEffectiveColSpan(): int;
    /**
     * Gets current value of property {@link #getEffectiveRowSpan effectiveRowSpan}.
     *
     * the effective row span
     *
     *
     * @returns Value of property `effectiveRowSpan`
     */
    getEffectiveRowSpan(): int;
    /**
     * Gets current value of property {@link #getFormatter formatter}.
     *
     * helper to format the cell
     *
     *
     * @returns Value of property `formatter`
     */
    getFormatter(): object;
    /**
     * Gets current value of property {@link #getHierarchyAction hierarchyAction}.
     *
     * the hierarchy action of the cell
     *
     *
     * @returns Value of property `hierarchyAction`
     */
    getHierarchyAction(): string;
    /**
     * Gets current value of property {@link #getHierarchyTooltip hierarchyTooltip}.
     *
     * the hierarchy tooltip
     *
     *
     * @returns Value of property `hierarchyTooltip`
     */
    getHierarchyTooltip(): string;
    /**
     * Gets current value of property {@link #getHtmlIE8RowSpan htmlIE8RowSpan}.
     *
     * the IE8 row span
     *
     * Default value is `1`.
     *
     * @deprecated (since 1.89.0)
     *
     * @returns Value of property `htmlIE8RowSpan`
     */
    getHtmlIE8RowSpan(): int;
    /**
     * Gets current value of property {@link #getLevel level}.
     *
     * the level of the cell
     *
     *
     * @returns Value of property `level`
     */
    getLevel(): int;
    /**
     * Gets current value of property {@link #getMemberId memberId}.
     *
     * the id of the associated member
     *
     *
     * @returns Value of property `memberId`
     */
    getMemberId(): string;
    /**
     * Gets current value of property {@link #getMergeKey mergeKey}.
     *
     * whether to merge the cell if the keys are equal
     *
     *
     * @returns Value of property `mergeKey`
     */
    getMergeKey(): string;
    /**
     * Gets current value of property {@link #getNodeAlignment nodeAlignment}.
     *
     * the node alignment
     *
     *
     * @returns Value of property `nodeAlignment`
     */
    getNodeAlignment(): string;
    /**
     * Gets current value of property {@link #getParentMemberId parentMemberId}.
     *
     * the id of the parent of the associated member
     *
     *
     * @returns Value of property `parentMemberId`
     */
    getParentMemberId(): string;
    /**
     * Gets current value of property {@link #getRow row}.
     *
     * the row of the cell in the crosstab
     *
     *
     * @returns Value of property `row`
     */
    getRow(): int;
    /**
     * Gets current value of property {@link #getRowSpan rowSpan}.
     *
     * Rowspan of the cell
     *
     *
     * @returns Value of property `rowSpan`
     */
    getRowSpan(): int;
    /**
     * Gets current value of property {@link #getSort sort}.
     *
     * sorting
     *
     *
     * @returns Value of property `sort`
     */
    getSort(): string;
    /**
     * Gets current value of property {@link #getSortAction sortAction}.
     *
     * sort action
     *
     *
     * @returns Value of property `sortAction`
     */
    getSortAction(): string;
    /**
     * Gets current value of property {@link #getSortTextIndex sortTextIndex}.
     *
     * the text sort index
     *
     *
     * @returns Value of property `sortTextIndex`
     */
    getSortTextIndex(): int;
    /**
     * Gets current value of property {@link #getTableCol tableCol}.
     *
     * the column of the table
     *
     *
     * @returns Value of property `tableCol`
     */
    getTableCol(): int;
    /**
     * Gets current value of property {@link #getTableRow tableRow}.
     *
     * the row of the tabe
     *
     *
     * @returns Value of property `tableRow`
     */
    getTableRow(): int;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Text of the cell
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Sets a new value for property {@link #getAlignment alignment}.
     *
     * the alignment of the cell
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAlignment(
      /**
       * New value for property `alignment`
       */
      sAlignment?: string
    ): this;
    /**
     * Sets a new value for property {@link #getArea area}.
     *
     * area of the cell
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setArea(
      /**
       * New value for property `area`
       */
      oArea?: object
    ): this;
    /**
     * Sets a new value for property {@link #getCol col}.
     *
     * the column of the cell in the crosstab
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCol(
      /**
       * New value for property `col`
       */
      iCol?: int
    ): this;
    /**
     * Sets a new value for property {@link #getColSpan colSpan}.
     *
     * Colspan of the cell
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColSpan(
      /**
       * New value for property `colSpan`
       */
      iColSpan?: int
    ): this;
    /**
     * Sets a new value for property {@link #getDrillState drillState}.
     *
     * the drillstate of the cell
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDrillState(
      /**
       * New value for property `drillState`
       */
      sDrillState?: string
    ): this;
    /**
     * Sets a new value for property {@link #getEffectiveColSpan effectiveColSpan}.
     *
     * the effective col span
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEffectiveColSpan(
      /**
       * New value for property `effectiveColSpan`
       */
      iEffectiveColSpan?: int
    ): this;
    /**
     * Sets a new value for property {@link #getEffectiveRowSpan effectiveRowSpan}.
     *
     * the effective row span
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEffectiveRowSpan(
      /**
       * New value for property `effectiveRowSpan`
       */
      iEffectiveRowSpan?: int
    ): this;
    /**
     * Sets a new value for property {@link #getFormatter formatter}.
     *
     * helper to format the cell
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFormatter(
      /**
       * New value for property `formatter`
       */
      oFormatter?: object
    ): this;
    /**
     * Sets a new value for property {@link #getHierarchyAction hierarchyAction}.
     *
     * the hierarchy action of the cell
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHierarchyAction(
      /**
       * New value for property `hierarchyAction`
       */
      sHierarchyAction?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHierarchyTooltip hierarchyTooltip}.
     *
     * the hierarchy tooltip
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHierarchyTooltip(
      /**
       * New value for property `hierarchyTooltip`
       */
      sHierarchyTooltip?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHtmlIE8RowSpan htmlIE8RowSpan}.
     *
     * the IE8 row span
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     * @deprecated (since 1.89.0)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHtmlIE8RowSpan(
      /**
       * New value for property `htmlIE8RowSpan`
       */
      iHtmlIE8RowSpan?: int
    ): this;
    /**
     * Sets a new value for property {@link #getLevel level}.
     *
     * the level of the cell
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLevel(
      /**
       * New value for property `level`
       */
      iLevel?: int
    ): this;
    /**
     * Sets a new value for property {@link #getMemberId memberId}.
     *
     * the id of the associated member
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMemberId(
      /**
       * New value for property `memberId`
       */
      sMemberId?: string
    ): this;
    /**
     * Sets a new value for property {@link #getMergeKey mergeKey}.
     *
     * whether to merge the cell if the keys are equal
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMergeKey(
      /**
       * New value for property `mergeKey`
       */
      sMergeKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getNodeAlignment nodeAlignment}.
     *
     * the node alignment
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNodeAlignment(
      /**
       * New value for property `nodeAlignment`
       */
      sNodeAlignment?: string
    ): this;
    /**
     * Sets a new value for property {@link #getParentMemberId parentMemberId}.
     *
     * the id of the parent of the associated member
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setParentMemberId(
      /**
       * New value for property `parentMemberId`
       */
      sParentMemberId?: string
    ): this;
    /**
     * Sets a new value for property {@link #getRow row}.
     *
     * the row of the cell in the crosstab
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRow(
      /**
       * New value for property `row`
       */
      iRow?: int
    ): this;
    /**
     * Sets a new value for property {@link #getRowSpan rowSpan}.
     *
     * Rowspan of the cell
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRowSpan(
      /**
       * New value for property `rowSpan`
       */
      iRowSpan?: int
    ): this;
    /**
     * Sets a new value for property {@link #getSort sort}.
     *
     * sorting
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSort(
      /**
       * New value for property `sort`
       */
      sSort?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSortAction sortAction}.
     *
     * sort action
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSortAction(
      /**
       * New value for property `sortAction`
       */
      sSortAction?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSortTextIndex sortTextIndex}.
     *
     * the text sort index
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSortTextIndex(
      /**
       * New value for property `sortTextIndex`
       */
      iSortTextIndex?: int
    ): this;
    /**
     * Sets a new value for property {@link #getTableCol tableCol}.
     *
     * the column of the table
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTableCol(
      /**
       * New value for property `tableCol`
       */
      iTableCol?: int
    ): this;
    /**
     * Sets a new value for property {@link #getTableRow tableRow}.
     *
     * the row of the tabe
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTableRow(
      /**
       * New value for property `tableRow`
       */
      iTableRow?: int
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Text of the cell
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the HeaderCell constructor.
   *
   * @deprecated (since 1.89.0) - Please use the WD Grid control instead.
   */
  export interface $HeaderCellSettings extends $ControlSettings {
    /**
     * Rowspan of the cell
     */
    rowSpan?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Colspan of the cell
     */
    colSpan?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Text of the cell
     */
    text?: string | PropertyBindingInfo;

    /**
     * helper to format the cell
     */
    formatter?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * whether to merge the cell if the keys are equal
     */
    mergeKey?: string | PropertyBindingInfo;

    /**
     * sorting
     */
    sort?: string | PropertyBindingInfo;

    /**
     * sort action
     */
    sortAction?: string | PropertyBindingInfo;

    /**
     * area of the cell
     */
    area?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * the effective col span
     */
    effectiveColSpan?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * the effective row span
     */
    effectiveRowSpan?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * the row of the cell in the crosstab
     */
    row?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * the column of the cell in the crosstab
     */
    col?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * the level of the cell
     */
    level?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * the drillstate of the cell
     */
    drillState?: string | PropertyBindingInfo;

    /**
     * the hierarchy action of the cell
     */
    hierarchyAction?: string | PropertyBindingInfo;

    /**
     * the hierarchy tooltip
     */
    hierarchyTooltip?: string | PropertyBindingInfo;

    /**
     * the IE8 row span
     *
     * @deprecated (since 1.89.0)
     */
    htmlIE8RowSpan?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * the text sort index
     */
    sortTextIndex?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * the row of the tabe
     */
    tableRow?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * the column of the table
     */
    tableCol?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * the alignment of the cell
     */
    alignment?: string | PropertyBindingInfo;

    /**
     * the id of the associated member
     */
    memberId?: string | PropertyBindingInfo;

    /**
     * the id of the parent of the associated member
     */
    parentMemberId?: string | PropertyBindingInfo;

    /**
     * the node alignment
     */
    nodeAlignment?: string | PropertyBindingInfo;
  }
}

declare namespace sap {
  interface IUI5DefineDependencyNames {
    "sap/zen/crosstab/Crosstab": undefined;

    "sap/zen/crosstab/DataCell": undefined;

    "sap/zen/crosstab/HeaderCell": undefined;

    "sap/zen/crosstab/library": undefined;
  }
}
