import { EncodedSourceMap } from "@jridgewell/trace-mapping";
import { Position } from "../Parser.js";
export default class Writer {
    #private;
    lineOffset: number;
    columnOffset: number;
    constructor(targetName: string, sourceName: string);
    write(str: string, start?: Position, end?: Position): void;
    writeln(str: string, start?: Position, end?: Position): void;
    prependln(str: string, start?: Position, end?: Position): void;
    getString(): string;
    /**
     * Generate the final source map for the generated code.
     *
     * Important notes:
     * * Default aggregations will be mapped to the control that started it
     */
    getSourceMap(): EncodedSourceMap;
    getLength(): number;
}
