import ts from "typescript";
import LinterContext, { CoverageInfo, FixHints } from "../LinterContext.js";
import { MESSAGE } from "../messages.js";
import { MessageArgs } from "../MessageArgs.js";
interface ReporterCoverageInfo extends CoverageInfo {
    node: ts.Node;
}
export default class SourceFileReporter {
    #private;
    constructor(context: LinterContext, sourceFile: ts.SourceFile, sourceMap: string | undefined);
    addMessage<M extends MESSAGE>(id: M, args: MessageArgs[M], node: ts.Node, fixHints?: FixHints): void;
    addMessage<M extends MESSAGE>(id: M, node: ts.Node, fixHints?: FixHints): void;
    addCoverageInfo({ node, message, messageDetails, category }: ReporterCoverageInfo): void;
    addMessagesToContext(): void;
}
export {};
