import ts from "typescript";
export class AmbientModuleCache {
    modules;
    cache = new Map();
    constructor(modules) {
        this.modules = modules;
    }
    findAndCacheEntry(moduleName) {
        for (const module of this.modules) {
            if (!module.valueDeclaration || !ts.isModuleDeclaration(module.valueDeclaration)) {
                continue;
            }
            const found = module.valueDeclaration.name.text === moduleName;
            if (found) {
                this.cache.set(moduleName, module);
                return module;
            }
        }
        // Add negative cache entry
        this.cache.set(moduleName, null);
        return null;
    }
    getModule(moduleName) {
        const module = this.cache.get(moduleName);
        if (module !== undefined) {
            return module;
        }
        else {
            return this.findAndCacheEntry(moduleName);
        }
    }
}
//# sourceMappingURL=AmbientModuleCache.js.map