/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.codemods;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.scheduling.WorkingDirectoryExecutionContextView;

public final class RecipeResources {
    private final String nodeModulesKey;

    private RecipeResources(String keyPrefix) {
        this.nodeModulesKey = keyPrefix + ".NODE_MODULES";
    }

    public static RecipeResources from(Class<? extends Recipe> recipeClass) {
        String recipeClassPath = recipeClass.getName().replace('.', '/') + ".class";
        URL resource = recipeClass.getClassLoader().getResource(recipeClassPath);
        assert (resource != null);
        String key = resource.toString().substring(0, resource.toString().length() - recipeClassPath.length());
        return new RecipeResources(key);
    }

    Path init(ExecutionContext ctx) {
        Path nodeModules = (Path)ctx.getMessage(this.nodeModulesKey);
        if (nodeModules == null) {
            nodeModules = RecipeResources.extractNodeModules(() -> {
                try {
                    WorkingDirectoryExecutionContextView view = WorkingDirectoryExecutionContextView.view((ExecutionContext)ctx);
                    return Files.createDirectory(view.getWorkingDirectory().resolve("npm-registry"), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).resolve("node_modules");
            ctx.putMessage(this.nodeModulesKey, (Object)nodeModules);
        }
        return nodeModules;
    }

    private static Path extractNodeModules(Supplier<Path> dir) {
        try {
            Path result = RecipeResources.extractResources("codemods", dir);
            RecipeResources.recreateBinSymlinks(result);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Path extractResources(String resource, String dir, ExecutionContext ctx) {
        return RecipeResources.extractResources(resource, () -> {
            try {
                WorkingDirectoryExecutionContextView view = WorkingDirectoryExecutionContextView.view((ExecutionContext)ctx);
                return Files.createDirectory(view.getWorkingDirectory().resolve(dir), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized Path extractResources(String resource, Supplier<Path> dir) {
        try {
            FileSystem fileSystem;
            URI uri = Objects.requireNonNull(RecipeResources.class.getClassLoader().getResource(resource)).toURI();
            if (!"jar".equals(uri.getScheme())) {
                if (!"file".equals(uri.getScheme())) throw new IllegalArgumentException("Unsupported scheme: " + uri.getScheme());
                return Paths.get(uri);
            }
            try {
                fileSystem = FileSystems.getFileSystem(uri);
            }
            catch (FileSystemNotFoundException e) {
                fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap(), null);
            }
            try (FileSystem localFileSystem = fileSystem;){
                Path codemodsPath = localFileSystem.getPath("/" + resource, new String[0]);
                Path target = dir.get();
                RecipeResources.copyRecursively(codemodsPath, target);
                Path path = target;
                return path;
            }
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static void copyRecursively(Path sourceDir, Path targetDir) throws IOException, InterruptedException {
        try (Stream<Path> stream = Files.walk(sourceDir, new FileVisitOption[0]);){
            stream.forEach(source -> {
                try {
                    Files.copy(source, targetDir.resolve(sourceDir.relativize((Path)source).toString()), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            });
        }
    }

    private static void recreateBinSymlinks(Path target) throws IOException, InterruptedException {
        Path binDir = target.resolve("node_modules/.bin");
        try (Stream<Path> files = Files.list(binDir);){
            files.forEach(f -> {
                try {
                    Files.delete(f);
                }
                catch (NoSuchFileException noSuchFileException) {
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        try (Stream<Path> packageJsonFiles = Files.walk(target.resolve("node_modules"), 2, new FileVisitOption[0]).filter(p -> p.getFileName().toString().equals("package.json"));){
            ObjectMapper mapper = new ObjectMapper();
            packageJsonFiles.forEach(p -> {
                try {
                    Path binScript;
                    JsonNode jsonNode = mapper.readTree(p.toFile());
                    JsonNode bin = jsonNode.get("bin");
                    if (bin instanceof ObjectNode) {
                        Iterator it = bin.fields();
                        while (it.hasNext()) {
                            Path binScript2;
                            Map.Entry entry = (Map.Entry)it.next();
                            if (!(entry.getValue() instanceof TextNode) || !Files.exists(binScript2 = p.resolveSibling(((JsonNode)entry.getValue()).asText()), new LinkOption[0])) continue;
                            binScript2.toFile().setExecutable(true);
                            Path symlink = binDir.resolve((String)entry.getKey());
                            Files.createSymbolicLink(symlink, binDir.relativize(binScript2), new FileAttribute[0]);
                        }
                    } else if (bin instanceof TextNode && Files.exists(binScript = p.resolveSibling(bin.asText()), new LinkOption[0])) {
                        Path symlink = binDir.resolve(bin.asText());
                        Files.createSymbolicLink(symlink, binDir.relativize(binScript), new FileAttribute[0]);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }
}

