// For Library Version: 1.120.4

declare module "sap/esh/search/ui/library" {}

declare module "sap/esh/search/ui/SearchCompositeControl" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * This is the SAPUI5 composite control by the Enterprise Search Team which helps to make full use of the
   * Enterprise Search Engine features built into ABAP and HANA. It includes a search input box including
   * a suggestion dropdown, a result list which can have different styles including tiles and table, result
   * facets and more. This control is ready to use with an enterprise search backend service but also allows
   * deep modifications to match requirements of adopting applications.
   *
   * @since 1.93.0
   */
  export default class SearchCompositeControl extends Control {
    /**
     * Constructs a new `SearchCompositeControl` to interact with SAP Enterprise Search Services.
     * See:
     * 	https://help.sap.com/viewer/691cb949c1034198800afde3e5be6570/2.0.05/en-US/ce86ef2fd97610149eaaaa0244ca4d36.html
     * 	https://help.sap.com/viewer/6522d0462aeb4909a79c3462b090ec51/1709%20002/en-US
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $SearchCompositeControlSettings
    );
    /**
     * Constructs a new `SearchCompositeControl` to interact with SAP Enterprise Search Services.
     * See:
     * 	https://help.sap.com/viewer/691cb949c1034198800afde3e5be6570/2.0.05/en-US/ce86ef2fd97610149eaaaa0244ca4d36.html
     * 	https://help.sap.com/viewer/6522d0462aeb4909a79c3462b090ec51/1709%20002/en-US
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $SearchCompositeControlSettings
    );

    /**
     * Creates a new subclass of class sap.esh.search.ui.SearchCompositeControl with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SearchCompositeControl>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.esh.search.ui.SearchCompositeControl.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some content to the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted
       */
      oContent: Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:searchFinished searchFinished} event of this
     * `sap.esh.search.ui.SearchCompositeControl`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.esh.search.ui.SearchCompositeControl` itself.
     *
     * Event is fired when search is finished.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSearchFinished(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.esh.search.ui.SearchCompositeControl`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:searchFinished searchFinished} event of this
     * `sap.esh.search.ui.SearchCompositeControl`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.esh.search.ui.SearchCompositeControl` itself.
     *
     * Event is fired when search is finished.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSearchFinished(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.esh.search.ui.SearchCompositeControl`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:searchStarted searchStarted} event of this `sap.esh.search.ui.SearchCompositeControl`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.esh.search.ui.SearchCompositeControl` itself.
     *
     * Event is fired when search is started.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSearchStarted(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.esh.search.ui.SearchCompositeControl`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:searchStarted searchStarted} event of this `sap.esh.search.ui.SearchCompositeControl`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.esh.search.ui.SearchCompositeControl` itself.
     *
     * Event is fired when search is started.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSearchStarted(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.esh.search.ui.SearchCompositeControl`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:searchFinished searchFinished} event of this
     * `sap.esh.search.ui.SearchCompositeControl`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSearchFinished(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:searchStarted searchStarted} event of this
     * `sap.esh.search.ui.SearchCompositeControl`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSearchStarted(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:searchFinished searchFinished} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSearchFinished(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:searchStarted searchStarted} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSearchStarted(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getApplicationComponent applicationComponent}.
     *
     * Relevant for SAP partners and SAP, the "Application Component" you expect customers to create incidents.
     *
     * Default value is `"HAN-AS-INA-UI"`.
     *
     * @since 1.108.0
     *
     * @returns Value of property `applicationComponent`
     */
    getApplicationComponent(): string;
    /**
     * Gets current value of property {@link #getAutoAdjustResultViewTypeInFolderMode autoAdjustResultViewTypeInFolderMode}.
     *
     * In case folder mode is active: Automatically switch result view type to list in search mode and to table
     * in folder mode.
     *
     * Default value is `false`.
     *
     * @since 1.106.0
     *
     * @returns Value of property `autoAdjustResultViewTypeInFolderMode`
     */
    getAutoAdjustResultViewTypeInFolderMode(): boolean;
    /**
     * Gets current value of property {@link #getBoSuggestions boSuggestions}.
     *
     * A boolean for enabling (business) object suggestions.
     *
     * Default value is `false`.
     *
     * @since 1.113.0
     *
     * @returns Value of property `boSuggestions`
     */
    getBoSuggestions(): boolean;
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * Control instances which are part of this composite control.
     */
    getContent(): Control[];
    /**
     * Gets current value of property {@link #getCssClass cssClass}.
     *
     * An additional CSS class to add to this control
     *
     * @since 1.93.0
     *
     * @returns Value of property `cssClass`
     */
    getCssClass(): string;
    /**
     * Gets current value of property {@link #getDataSource dataSource}.
     *
     * The id of the data source in which it will search right after initialization.
     *
     * @since 1.98.0
     *
     * @returns Value of property `dataSource`
     */
    getDataSource(): string;
    /**
     * Gets current value of property {@link #getDefaultDataSource defaultDataSource}.
     *
     * Data source id which is set when the UI is loaded or filter is reset. If dataSource is also set, dataSource
     * will be used during UI load and this parameter will used only after filter is reset.
     *
     * @since 1.93.0
     *
     * @returns Value of property `defaultDataSource`
     */
    getDefaultDataSource(): string;
    /**
     * Gets current value of property {@link #getDisplayFacetPanelInCaseOfNoResults displayFacetPanelInCaseOfNoResults}.
     *
     * When set to true the facet panel is displayed also in case there are no search results.
     *
     * Default value is `false`.
     *
     * @since 1.113.0
     *
     * @returns Value of property `displayFacetPanelInCaseOfNoResults`
     */
    getDisplayFacetPanelInCaseOfNoResults(): boolean;
    /**
     * Gets current value of property {@link #getEnableMultiSelectionResultItems enableMultiSelectionResultItems}.
     *
     * Enables the multiselection mode of search result items. A checkbox is provided for each result item if
     * the value is true.
     *
     * Default value is `false`.
     *
     * @since 1.96.0
     *
     * @returns Value of property `enableMultiSelectionResultItems`
     */
    getEnableMultiSelectionResultItems(): boolean;
    /**
     * Gets current value of property {@link #getEnableQueryLanguage enableQueryLanguage}.
     *
     * Enables the query language for the hana_odata provider. With query language it is possible for the end
     * user to enter complex search queries with logical operators.
     *
     * Default value is `false`.
     *
     * @since 1.107.0
     *
     * @returns Value of property `enableQueryLanguage`
     */
    getEnableQueryLanguage(): boolean;
    /**
     * Gets current value of property {@link #getEventConsumers eventConsumers}.
     *
     * Adds a callback function which is called whenever there is a user triggered event.
     *
     * @since 1.120
     *
     * @returns Value of property `eventConsumers`
     */
    getEventConsumers(): string;
    /**
     * Gets current value of property {@link #getFacetPanelResizable facetPanelResizable}.
     *
     * Display a splitter bar to resize the left hand panel, containing all facets and filter criteria.
     *
     * Default value is `false`.
     *
     * @since 1.108.0
     *
     * @returns Value of property `facetPanelResizable`
     */
    getFacetPanelResizable(): boolean;
    /**
     * Gets current value of property {@link #getFacetPanelWidthInPercent facetPanelWidthInPercent}.
     *
     * Default size (percent) of the left hand panel, containing all facets and filter criteria. If "facetPanelResizable"
     * is true, the width of the facet panel can be changed by the user.
     *
     * Default value is `25`.
     *
     * @since 1.108.0
     *
     * @returns Value of property `facetPanelWidthInPercent`
     */
    getFacetPanelWidthInPercent(): float;
    /**
     * Gets current value of property {@link #getFacetVisibility facetVisibility}.
     *
     * A boolean which indicates whether the facet panel is initially openend or closed. This affects only the
     * initial state of the facet panel. When not setting facetVisibility the initial state of the facet panel
     * typically is taken from the user personalization storage.
     *
     * @since 1.113.0
     *
     * @returns Value of property `facetVisibility`
     */
    getFacetVisibility(): boolean;
    /**
     * Gets current value of property {@link #getFilterDataSources filterDataSources}.
     *
     * Callback for filtering the datasources displayed in the datasource dropdown listbox. The callback gets
     * a list of datsources and returns the filtered list of datasources.
     *
     * @since 1.112.0
     *
     * @returns Value of property `filterDataSources`
     */
    getFilterDataSources(): Function;
    /**
     * Gets current value of property {@link #getFilterRootCondition filterRootCondition}.
     *
     * Defines the filter root condition of a filter tree which shall be applied to the search request. This
     * control only allows filter trees which have a the following structure: complex condition (root level)
     * \ complex condition (attribute level) \ simple condition (attribute value level) Filter root conditions
     * which do not follow this structure won't be accepted and an error will be thrown. Please see the below
     * for a more in-depth example.
     *
     * @since 1.98.0
     *
     * @returns Value of property `filterRootCondition`
     */
    getFilterRootCondition(): object;
    /**
     * Gets current value of property {@link #getFolderMode folderMode}.
     *
     * Activates the folder mode. Precondition for folder mode is 1) Search model: In the search model for the
     * current datasource a hierarchy attribute (representing the folders) is defined 1.1) the hierarchy attribute
     * is annotated with displayType=TREE and for the hierarchy there is a helper connector representing the
     * hierarchy or 1.2) the current datasource is the helper datasource representing the folder hierarchy.
     * The hierarchy attribute is annotated with displayType=FLAT 2) Search query: The folder mode is only active
     * in case the search query has an empty search term and no filter conditions (except the hierarchy attribute)
     * are set.
     *
     * In folder mode and in case a folder filter is set the result view only shows direct children of a folder.
     * In contrast the counts in the facets are calculated by counting direct and not direct children. In case
     * the folder mode is not active the UI uses the search mode: The result list shows direct and not direct
     * children of a folder.
     *
     * @since 1.106.0
     *
     * @returns Value of property `folderMode`
     */
    getFolderMode(): boolean;
    /**
     * Gets current value of property {@link #getFolderModeForInitialSearch folderModeForInitialSearch}.
     *
     * In case folderMode is set to true this boolean indicates whether for the initial search the folder mode
     * is enabled.
     *
     * Default value is `false`.
     *
     * @since 1.114.0
     *
     * @returns Value of property `folderModeForInitialSearch`
     */
    getFolderModeForInitialSearch(): boolean;
    /**
     * Gets current value of property {@link #getFormatFilterBarText formatFilterBarText}.
     *
     * Callback for formatting the filter string to be displayed in the filter bar (for closed facet panel).
     *
     * @since 1.120
     *
     * @returns Value of property `formatFilterBarText`
     */
    getFormatFilterBarText(): Function;
    /**
     * Gets current value of property {@link #getGetCustomNoResultScreen getCustomNoResultScreen}.
     *
     * Whenever a search has no results, a 'No Results Page' is displayed. You can provide a custom page to
     * be more specific and add some hints, links, buttons or other content.
     *
     * @since 1.94.0
     *
     * @returns Value of property `getCustomNoResultScreen`
     */
    getGetCustomNoResultScreen(): Function;
    /**
     * Gets current value of property {@link #getGetSearchInputPlaceholderLabel getSearchInputPlaceholderLabel}.
     *
     * A callback which returns customized "label" for placeholder text of search box, in case there is no search
     * term. The placeholder text (en) will be "Search In: ".
     *
     *
     * @returns Value of property `getSearchInputPlaceholderLabel`
     */
    getGetSearchInputPlaceholderLabel(): Function;
    /**
     * Gets current value of property {@link #getInitAsync initAsync}.
     *
     * A callback which is called after the initialization of the search composite control.
     *
     * @since 1.113.0
     *
     * @returns Value of property `initAsync`
     */
    getInitAsync(): Function;
    /**
     * Gets current value of property {@link #getIsFilterBarVisible isFilterBarVisible}.
     *
     * Callback for checking whether the filter bar is visible.
     *
     * @since 1.120
     *
     * @returns Value of property `isFilterBarVisible`
     */
    getIsFilterBarVisible(): Function;
    /**
     * Gets current value of property {@link #getIsSearchUrl isSearchUrl}.
     *
     * A callback for checking whether a URL is a search URL. The callback receives a URL and returns true in
     * case the URL is a search URL. Typically you need to register this callback in case updateUrl=true.
     *
     * @since 1.113.0
     *
     * @returns Value of property `isSearchUrl`
     */
    getIsSearchUrl(): Function;
    /**
     * Gets current value of property {@link #getOptimizeForValueHelp optimizeForValueHelp}.
     *
     * The layout is optimized for object selection / value help (narrow view w/o facet panel).
     *
     * @since 1.111.0
     *
     * @returns Value of property `optimizeForValueHelp`
     */
    getOptimizeForValueHelp(): boolean;
    /**
     * Gets current value of property {@link #getOverwriteBrowserTitle overwriteBrowserTitle}.
     *
     * Shall the window title be overwritten by this control? If true, the control will set the current search
     * condition as window title. If false, it will not set or update the window title.
     *
     * @since 1.93.0
     *
     * @returns Value of property `overwriteBrowserTitle`
     */
    getOverwriteBrowserTitle(): boolean;
    /**
     * Gets current value of property {@link #getPageSize pageSize}.
     *
     * The maximal count of search result items displayed on a page after a search. By clicking Show More button,
     * another page of result items of the same count (if available) will be displayed.
     *
     * Default value is `10`.
     *
     * @since 1.96.0
     *
     * @returns Value of property `pageSize`
     */
    getPageSize(): int;
    /**
     * Gets current value of property {@link #getParseSearchUrlParameters parseSearchUrlParameters}.
     *
     * A callback for parsing URL parameters. The callback receices URL parameters and returns modified URL
     * parameters. This is an optional callback. Also in case you set updateUrl=true typcically this callback
     * is not needed.
     *
     * @since 1.113.0
     *
     * @returns Value of property `parseSearchUrlParameters`
     */
    getParseSearchUrlParameters(): Function;
    /**
     * Gets current value of property {@link #getQuickSelectDataSources quickSelectDataSources}.
     *
     * A list of datasources to be displayed in the facet panel in the collection area.
     *
     * @since 1.113.0
     *
     * @returns Value of property `quickSelectDataSources`
     */
    getQuickSelectDataSources(): object;
    /**
     * Gets current value of property {@link #getRenderSearchUrl renderSearchUrl}.
     *
     * A callback for rendering the search URL. The callback gets a list of url encoded parameters and returns
     * the URL string. Typically you need to register this callback in case updateUrl=true.
     *
     * @since 1.113.0
     *
     * @returns Value of property `renderSearchUrl`
     */
    getRenderSearchUrl(): Function;
    /**
     * Gets current value of property {@link #getResultViewSettings resultViewSettings}.
     *
     * Defines a pair of search result view settings. The value is an object of properties `resultViewTypes`
     * and `resultViewType`. An example: `{resultViewTypes: ["searchResultList", "searchResultTable"], resultViewType:
     * "searchResultList"}` Find more detail in the definition of each child property. The value can be set/get
     * in attached event "searchFinished". Function `setResultViewSettings` prevents incompatibility of sequential
     * execution of functions `setResultViewTypes` and `setResultViewType`. Note: The value of `resultViewTypes`
     * and `resultViewType` must be compatible to each other.
     *
     * Default value is `...see text or source`.
     *
     * @since 1.100.0
     *
     * @returns Value of property `resultViewSettings`
     */
    getResultViewSettings(): string;
    /**
     * Gets current value of property {@link #getResultViewType resultViewType}.
     *
     * Defines active search result view type. The value can be set/get in attach event "searchFinished", and
     * it must be contained in resultViewTypes. Case 1, Search in Apps: result is displayed in a mandatory view
     * type `"appSearchResult"`. Case 2.1, Search in All or other Category (configuration.isUshell !== true):
     * result is switchable between different view types. Possible value is `"searchResultList"`, or `"searchResultGrid"`.
     * Case 2.2, Search in All or other Category (configuration.isUshell === true): result is displayed in a
     * mandatory view type `"searchResultList"`. Case 3, Search in Business Object: result is switchable between
     * different view types. Possible value is `"searchResultList"`, `"searchResultTable"` or `"searchResultGrid"`.
     * Note: The value of `resultViewTypes` and `resultViewType` must be compatible to each other.
     *
     * Default value is `"searchResultList"`.
     *
     * @since 1.98.0
     *
     * @returns Value of property `resultViewType`
     */
    getResultViewType(): string;
    /**
     * Gets current value of property {@link #getResultViewTypes resultViewTypes}.
     *
     * Defines selectable search result view types. The value can be set/get in attach event "searchFinished".
     * Case 1: Search in Apps: result is displayed in a mandatory view type `["appSearchResult"]`, and it is
     * not switchable. Case 2: Search in All or other Category: result is switchable between different view
     * types. Possible values for the array items are `"searchResultList"` and `"searchResultGrid"`. Case 3,
     * Search in Business Object: result is switchable between different view types. Possible values for the
     * array items are `"searchResultList"`, `"searchResultTable"` and `"searchResultGrid"`. Note: The value
     * of `resultViewTypes` and `resultViewType` must be compatible to each other.
     *
     * Default value is `["searchResultList", "searchResultTable"]`.
     *
     * @since 1.98.0
     *
     * @returns Value of property `resultViewTypes`
     */
    getResultViewTypes(): string[];
    /**
     * Gets current value of property {@link #getSearchOnStart searchOnStart}.
     *
     * Defines if the search composite control will send a search request after loading for the given term,
     * data source and filter root condition settings.
     *
     * Default value is `true`.
     *
     * @since 1.93.0
     *
     * @returns Value of property `searchOnStart`
     */
    getSearchOnStart(): boolean;
    /**
     * Gets current value of property {@link #getSearchTerm searchTerm}.
     *
     * Defines the initial search term for the search input.
     *
     * Default value is `empty string`.
     *
     * @since 1.93.0
     *
     * @returns Value of property `searchTerm`
     */
    getSearchTerm(): string;
    /**
     * Gets current value of property {@link #getSelectionChange selectionChange}.
     *
     * A callback which is called whenever the selection of result list items changes.
     *
     * @since 1.113.0
     *
     * @returns Value of property `selectionChange`
     */
    getSelectionChange(): Function;
    /**
     * Gets current value of property {@link #getSinaConfiguration sinaConfiguration}.
     *
     * Configuration for the Enterprise Search Client API.
     *
     * @since 1.93.0
     *
     * @returns Value of property `sinaConfiguration`
     */
    getSinaConfiguration(): object;
    /**
     * Gets current value of property {@link #getTabStripsFormatter tabStripsFormatter}.
     *
     * Function callback for formatting the datasource tabstrips in the top toolbar. To the callback function
     * a list of datasources is passed. The callback functions return a modified list of datasources to be displayed
     * in the tabstrips.
     *
     * @since 1.103.0
     *
     * @returns Value of property `tabStripsFormatter`
     */
    getTabStripsFormatter(): Function;
    /**
     * Gets current value of property {@link #getUpdateUrl updateUrl}.
     *
     * A boolean indicating that the search state is written to the URL.
     *
     * Default value is `true`.
     *
     * @since 1.113.0
     *
     * @returns Value of property `updateUrl`
     */
    getUpdateUrl(): boolean;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContent content}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: Control
    ): int;
    /**
     * Inserts a content into the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: Control,
      /**
       * The `0`-based index the content should be inserted at; for a negative value of `iIndex`, the content
       * is inserted at position 0; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): Control[];
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | Control
    ): Control | null;
    /**
     * Sets a new value for property {@link #getApplicationComponent applicationComponent}.
     *
     * Relevant for SAP partners and SAP, the "Application Component" you expect customers to create incidents.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"HAN-AS-INA-UI"`.
     *
     * @since 1.108.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setApplicationComponent(
      /**
       * New value for property `applicationComponent`
       */
      sApplicationComponent?: string
    ): this;
    /**
     * Sets a new value for property {@link #getAutoAdjustResultViewTypeInFolderMode autoAdjustResultViewTypeInFolderMode}.
     *
     * In case folder mode is active: Automatically switch result view type to list in search mode and to table
     * in folder mode.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.106.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAutoAdjustResultViewTypeInFolderMode(
      /**
       * New value for property `autoAdjustResultViewTypeInFolderMode`
       */
      bAutoAdjustResultViewTypeInFolderMode?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getBoSuggestions boSuggestions}.
     *
     * A boolean for enabling (business) object suggestions.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.113.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBoSuggestions(
      /**
       * New value for property `boSuggestions`
       */
      bBoSuggestions?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getCssClass cssClass}.
     *
     * An additional CSS class to add to this control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.93.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCssClass(
      /**
       * New value for property `cssClass`
       */
      sCssClass: string
    ): this;
    /**
     * Sets a new value for property {@link #getDataSource dataSource}.
     *
     * The id of the data source in which it will search right after initialization.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.98.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataSource(
      /**
       * New value for property `dataSource`
       */
      sDataSource: string
    ): this;
    /**
     * Sets a new value for property {@link #getDefaultDataSource defaultDataSource}.
     *
     * Data source id which is set when the UI is loaded or filter is reset. If dataSource is also set, dataSource
     * will be used during UI load and this parameter will used only after filter is reset.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.93.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDefaultDataSource(
      /**
       * New value for property `defaultDataSource`
       */
      sDefaultDataSource: string
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayFacetPanelInCaseOfNoResults displayFacetPanelInCaseOfNoResults}.
     *
     * When set to true the facet panel is displayed also in case there are no search results.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.113.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayFacetPanelInCaseOfNoResults(
      /**
       * New value for property `displayFacetPanelInCaseOfNoResults`
       */
      bDisplayFacetPanelInCaseOfNoResults?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnableMultiSelectionResultItems enableMultiSelectionResultItems}.
     *
     * Enables the multiselection mode of search result items. A checkbox is provided for each result item if
     * the value is true.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.96.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableMultiSelectionResultItems(
      /**
       * New value for property `enableMultiSelectionResultItems`
       */
      bEnableMultiSelectionResultItems?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnableQueryLanguage enableQueryLanguage}.
     *
     * Enables the query language for the hana_odata provider. With query language it is possible for the end
     * user to enter complex search queries with logical operators.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.107.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableQueryLanguage(
      /**
       * New value for property `enableQueryLanguage`
       */
      bEnableQueryLanguage?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEventConsumers eventConsumers}.
     *
     * Adds a callback function which is called whenever there is a user triggered event.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.120
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEventConsumers(
      /**
       * New value for property `eventConsumers`
       */
      sEventConsumers: string
    ): this;
    /**
     * Sets a new value for property {@link #getFacetPanelResizable facetPanelResizable}.
     *
     * Display a splitter bar to resize the left hand panel, containing all facets and filter criteria.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.108.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFacetPanelResizable(
      /**
       * New value for property `facetPanelResizable`
       */
      bFacetPanelResizable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getFacetPanelWidthInPercent facetPanelWidthInPercent}.
     *
     * Default size (percent) of the left hand panel, containing all facets and filter criteria. If "facetPanelResizable"
     * is true, the width of the facet panel can be changed by the user.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `25`.
     *
     * @since 1.108.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFacetPanelWidthInPercent(
      /**
       * New value for property `facetPanelWidthInPercent`
       */
      fFacetPanelWidthInPercent?: float
    ): this;
    /**
     * Sets a new value for property {@link #getFacetVisibility facetVisibility}.
     *
     * A boolean which indicates whether the facet panel is initially openend or closed. This affects only the
     * initial state of the facet panel. When not setting facetVisibility the initial state of the facet panel
     * typically is taken from the user personalization storage.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.113.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFacetVisibility(
      /**
       * New value for property `facetVisibility`
       */
      bFacetVisibility: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getFilterDataSources filterDataSources}.
     *
     * Callback for filtering the datasources displayed in the datasource dropdown listbox. The callback gets
     * a list of datsources and returns the filtered list of datasources.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.112.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFilterDataSources(
      /**
       * New value for property `filterDataSources`
       */
      fnFilterDataSources: Function
    ): this;
    /**
     * Sets a new value for property {@link #getFilterRootCondition filterRootCondition}.
     *
     * Defines the filter root condition of a filter tree which shall be applied to the search request. This
     * control only allows filter trees which have a the following structure: complex condition (root level)
     * \ complex condition (attribute level) \ simple condition (attribute value level) Filter root conditions
     * which do not follow this structure won't be accepted and an error will be thrown. Please see the below
     * for a more in-depth example.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.98.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFilterRootCondition(
      /**
       * New value for property `filterRootCondition`
       */
      oFilterRootCondition: object
    ): this;
    /**
     * Sets a new value for property {@link #getFolderMode folderMode}.
     *
     * Activates the folder mode. Precondition for folder mode is 1) Search model: In the search model for the
     * current datasource a hierarchy attribute (representing the folders) is defined 1.1) the hierarchy attribute
     * is annotated with displayType=TREE and for the hierarchy there is a helper connector representing the
     * hierarchy or 1.2) the current datasource is the helper datasource representing the folder hierarchy.
     * The hierarchy attribute is annotated with displayType=FLAT 2) Search query: The folder mode is only active
     * in case the search query has an empty search term and no filter conditions (except the hierarchy attribute)
     * are set.
     *
     * In folder mode and in case a folder filter is set the result view only shows direct children of a folder.
     * In contrast the counts in the facets are calculated by counting direct and not direct children. In case
     * the folder mode is not active the UI uses the search mode: The result list shows direct and not direct
     * children of a folder.
     *
     * @since 1.106.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFolderMode(
      /**
       * New value for property `folderMode`
       */
      bFolderMode?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getFolderModeForInitialSearch folderModeForInitialSearch}.
     *
     * In case folderMode is set to true this boolean indicates whether for the initial search the folder mode
     * is enabled.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.114.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFolderModeForInitialSearch(
      /**
       * New value for property `folderModeForInitialSearch`
       */
      bFolderModeForInitialSearch?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getFormatFilterBarText formatFilterBarText}.
     *
     * Callback for formatting the filter string to be displayed in the filter bar (for closed facet panel).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.120
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFormatFilterBarText(
      /**
       * New value for property `formatFilterBarText`
       */
      fnFormatFilterBarText: Function
    ): this;
    /**
     * Sets a new value for property {@link #getGetCustomNoResultScreen getCustomNoResultScreen}.
     *
     * Whenever a search has no results, a 'No Results Page' is displayed. You can provide a custom page to
     * be more specific and add some hints, links, buttons or other content.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.94.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGetCustomNoResultScreen(
      /**
       * New value for property `getCustomNoResultScreen`
       */
      fnGetCustomNoResultScreen: Function
    ): this;
    /**
     * Sets a new value for property {@link #getGetSearchInputPlaceholderLabel getSearchInputPlaceholderLabel}.
     *
     * A callback which returns customized "label" for placeholder text of search box, in case there is no search
     * term. The placeholder text (en) will be "Search In: ".
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGetSearchInputPlaceholderLabel(
      /**
       * New value for property `getSearchInputPlaceholderLabel`
       */
      fnGetSearchInputPlaceholderLabel: Function
    ): this;
    /**
     * Sets a new value for property {@link #getInitAsync initAsync}.
     *
     * A callback which is called after the initialization of the search composite control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.113.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInitAsync(
      /**
       * New value for property `initAsync`
       */
      fnInitAsync: Function
    ): this;
    /**
     * Sets a new value for property {@link #getIsFilterBarVisible isFilterBarVisible}.
     *
     * Callback for checking whether the filter bar is visible.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.120
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsFilterBarVisible(
      /**
       * New value for property `isFilterBarVisible`
       */
      fnIsFilterBarVisible: Function
    ): this;
    /**
     * Sets a new value for property {@link #getIsSearchUrl isSearchUrl}.
     *
     * A callback for checking whether a URL is a search URL. The callback receives a URL and returns true in
     * case the URL is a search URL. Typically you need to register this callback in case updateUrl=true.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.113.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsSearchUrl(
      /**
       * New value for property `isSearchUrl`
       */
      fnIsSearchUrl: Function
    ): this;
    /**
     * Sets a new value for property {@link #getOptimizeForValueHelp optimizeForValueHelp}.
     *
     * The layout is optimized for object selection / value help (narrow view w/o facet panel).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.111.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOptimizeForValueHelp(
      /**
       * New value for property `optimizeForValueHelp`
       */
      bOptimizeForValueHelp: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getOverwriteBrowserTitle overwriteBrowserTitle}.
     *
     * Shall the window title be overwritten by this control? If true, the control will set the current search
     * condition as window title. If false, it will not set or update the window title.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.93.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOverwriteBrowserTitle(
      /**
       * New value for property `overwriteBrowserTitle`
       */
      bOverwriteBrowserTitle: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getPageSize pageSize}.
     *
     * The maximal count of search result items displayed on a page after a search. By clicking Show More button,
     * another page of result items of the same count (if available) will be displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `10`.
     *
     * @since 1.96.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPageSize(
      /**
       * New value for property `pageSize`
       */
      iPageSize?: int
    ): this;
    /**
     * Sets a new value for property {@link #getParseSearchUrlParameters parseSearchUrlParameters}.
     *
     * A callback for parsing URL parameters. The callback receices URL parameters and returns modified URL
     * parameters. This is an optional callback. Also in case you set updateUrl=true typcically this callback
     * is not needed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.113.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setParseSearchUrlParameters(
      /**
       * New value for property `parseSearchUrlParameters`
       */
      fnParseSearchUrlParameters: Function
    ): this;
    /**
     * Sets a new value for property {@link #getQuickSelectDataSources quickSelectDataSources}.
     *
     * A list of datasources to be displayed in the facet panel in the collection area.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.113.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setQuickSelectDataSources(
      /**
       * New value for property `quickSelectDataSources`
       */
      oQuickSelectDataSources: object
    ): this;
    /**
     * Sets a new value for property {@link #getRenderSearchUrl renderSearchUrl}.
     *
     * A callback for rendering the search URL. The callback gets a list of url encoded parameters and returns
     * the URL string. Typically you need to register this callback in case updateUrl=true.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.113.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRenderSearchUrl(
      /**
       * New value for property `renderSearchUrl`
       */
      fnRenderSearchUrl: Function
    ): this;
    /**
     * Sets a new value for property {@link #getResultViewSettings resultViewSettings}.
     *
     * Defines a pair of search result view settings. The value is an object of properties `resultViewTypes`
     * and `resultViewType`. An example: `{resultViewTypes: ["searchResultList", "searchResultTable"], resultViewType:
     * "searchResultList"}` Find more detail in the definition of each child property. The value can be set/get
     * in attached event "searchFinished". Function `setResultViewSettings` prevents incompatibility of sequential
     * execution of functions `setResultViewTypes` and `setResultViewType`. Note: The value of `resultViewTypes`
     * and `resultViewType` must be compatible to each other.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `...see text or source`.
     *
     * @since 1.100.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setResultViewSettings(
      /**
       * New value for property `resultViewSettings`
       */
      sResultViewSettings?: string
    ): this;
    /**
     * Sets a new value for property {@link #getResultViewType resultViewType}.
     *
     * Defines active search result view type. The value can be set/get in attach event "searchFinished", and
     * it must be contained in resultViewTypes. Case 1, Search in Apps: result is displayed in a mandatory view
     * type `"appSearchResult"`. Case 2.1, Search in All or other Category (configuration.isUshell !== true):
     * result is switchable between different view types. Possible value is `"searchResultList"`, or `"searchResultGrid"`.
     * Case 2.2, Search in All or other Category (configuration.isUshell === true): result is displayed in a
     * mandatory view type `"searchResultList"`. Case 3, Search in Business Object: result is switchable between
     * different view types. Possible value is `"searchResultList"`, `"searchResultTable"` or `"searchResultGrid"`.
     * Note: The value of `resultViewTypes` and `resultViewType` must be compatible to each other.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"searchResultList"`.
     *
     * @since 1.98.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setResultViewType(
      /**
       * New value for property `resultViewType`
       */
      sResultViewType?: string
    ): this;
    /**
     * Sets a new value for property {@link #getResultViewTypes resultViewTypes}.
     *
     * Defines selectable search result view types. The value can be set/get in attach event "searchFinished".
     * Case 1: Search in Apps: result is displayed in a mandatory view type `["appSearchResult"]`, and it is
     * not switchable. Case 2: Search in All or other Category: result is switchable between different view
     * types. Possible values for the array items are `"searchResultList"` and `"searchResultGrid"`. Case 3,
     * Search in Business Object: result is switchable between different view types. Possible values for the
     * array items are `"searchResultList"`, `"searchResultTable"` and `"searchResultGrid"`. Note: The value
     * of `resultViewTypes` and `resultViewType` must be compatible to each other.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `["searchResultList", "searchResultTable"]`.
     *
     * @since 1.98.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setResultViewTypes(
      /**
       * New value for property `resultViewTypes`
       */
      sResultViewTypes?: string[]
    ): this;
    /**
     * Sets a new value for property {@link #getSearchOnStart searchOnStart}.
     *
     * Defines if the search composite control will send a search request after loading for the given term,
     * data source and filter root condition settings.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.93.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSearchOnStart(
      /**
       * New value for property `searchOnStart`
       */
      bSearchOnStart?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSearchTerm searchTerm}.
     *
     * Defines the initial search term for the search input.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     * @since 1.93.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSearchTerm(
      /**
       * New value for property `searchTerm`
       */
      sSearchTerm?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSelectionChange selectionChange}.
     *
     * A callback which is called whenever the selection of result list items changes.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.113.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelectionChange(
      /**
       * New value for property `selectionChange`
       */
      fnSelectionChange: Function
    ): this;
    /**
     * Sets a new value for property {@link #getSinaConfiguration sinaConfiguration}.
     *
     * Configuration for the Enterprise Search Client API.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.93.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSinaConfiguration(
      /**
       * New value for property `sinaConfiguration`
       */
      oSinaConfiguration: object
    ): this;
    /**
     * Sets a new value for property {@link #getTabStripsFormatter tabStripsFormatter}.
     *
     * Function callback for formatting the datasource tabstrips in the top toolbar. To the callback function
     * a list of datasources is passed. The callback functions return a modified list of datasources to be displayed
     * in the tabstrips.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.103.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTabStripsFormatter(
      /**
       * New value for property `tabStripsFormatter`
       */
      fnTabStripsFormatter: Function
    ): this;
    /**
     * Sets a new value for property {@link #getUpdateUrl updateUrl}.
     *
     * A boolean indicating that the search state is written to the URL.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.113.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUpdateUrl(
      /**
       * New value for property `updateUrl`
       */
      bUpdateUrl?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the SearchCompositeControl constructor.
   */
  export interface $SearchCompositeControlSettings extends $ControlSettings {
    /**
     * An additional CSS class to add to this control
     *
     * @since 1.93.0
     */
    cssClass?: string | PropertyBindingInfo;

    /**
     * Defines the initial search term for the search input.
     *
     * @since 1.93.0
     */
    searchTerm?: string | PropertyBindingInfo;

    /**
     * Defines if the search composite control will send a search request after loading for the given term,
     * data source and filter root condition settings.
     *
     * @since 1.93.0
     */
    searchOnStart?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the filter root condition of a filter tree which shall be applied to the search request. This
     * control only allows filter trees which have a the following structure: complex condition (root level)
     * \ complex condition (attribute level) \ simple condition (attribute value level) Filter root conditions
     * which do not follow this structure won't be accepted and an error will be thrown. Please see the below
     * for a more in-depth example.
     *
     * @since 1.98.0
     */
    filterRootCondition?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Configuration for the Enterprise Search Client API.
     *
     * @since 1.93.0
     */
    sinaConfiguration?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * The id of the data source in which it will search right after initialization.
     *
     * @since 1.98.0
     */
    dataSource?: string | PropertyBindingInfo;

    /**
     * Defines selectable search result view types. The value can be set/get in attach event "searchFinished".
     * Case 1: Search in Apps: result is displayed in a mandatory view type `["appSearchResult"]`, and it is
     * not switchable. Case 2: Search in All or other Category: result is switchable between different view
     * types. Possible values for the array items are `"searchResultList"` and `"searchResultGrid"`. Case 3,
     * Search in Business Object: result is switchable between different view types. Possible values for the
     * array items are `"searchResultList"`, `"searchResultTable"` and `"searchResultGrid"`. Note: The value
     * of `resultViewTypes` and `resultViewType` must be compatible to each other.
     *
     * @since 1.98.0
     */
    resultViewTypes?: string[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines active search result view type. The value can be set/get in attach event "searchFinished", and
     * it must be contained in resultViewTypes. Case 1, Search in Apps: result is displayed in a mandatory view
     * type `"appSearchResult"`. Case 2.1, Search in All or other Category (configuration.isUshell !== true):
     * result is switchable between different view types. Possible value is `"searchResultList"`, or `"searchResultGrid"`.
     * Case 2.2, Search in All or other Category (configuration.isUshell === true): result is displayed in a
     * mandatory view type `"searchResultList"`. Case 3, Search in Business Object: result is switchable between
     * different view types. Possible value is `"searchResultList"`, `"searchResultTable"` or `"searchResultGrid"`.
     * Note: The value of `resultViewTypes` and `resultViewType` must be compatible to each other.
     *
     * @since 1.98.0
     */
    resultViewType?: string | PropertyBindingInfo;

    /**
     * Defines a pair of search result view settings. The value is an object of properties `resultViewTypes`
     * and `resultViewType`. An example: `{resultViewTypes: ["searchResultList", "searchResultTable"], resultViewType:
     * "searchResultList"}` Find more detail in the definition of each child property. The value can be set/get
     * in attached event "searchFinished". Function `setResultViewSettings` prevents incompatibility of sequential
     * execution of functions `setResultViewTypes` and `setResultViewType`. Note: The value of `resultViewTypes`
     * and `resultViewType` must be compatible to each other.
     *
     * @since 1.100.0
     */
    resultViewSettings?: string | PropertyBindingInfo;

    /**
     * Function callback for formatting the datasource tabstrips in the top toolbar. To the callback function
     * a list of datasources is passed. The callback functions return a modified list of datasources to be displayed
     * in the tabstrips.
     *
     * @since 1.103.0
     */
    tabStripsFormatter?: Function | PropertyBindingInfo | `{${string}}`;

    /**
     * Activates the folder mode. Precondition for folder mode is 1) Search model: In the search model for the
     * current datasource a hierarchy attribute (representing the folders) is defined 1.1) the hierarchy attribute
     * is annotated with displayType=TREE and for the hierarchy there is a helper connector representing the
     * hierarchy or 1.2) the current datasource is the helper datasource representing the folder hierarchy.
     * The hierarchy attribute is annotated with displayType=FLAT 2) Search query: The folder mode is only active
     * in case the search query has an empty search term and no filter conditions (except the hierarchy attribute)
     * are set.
     *
     * In folder mode and in case a folder filter is set the result view only shows direct children of a folder.
     * In contrast the counts in the facets are calculated by counting direct and not direct children. In case
     * the folder mode is not active the UI uses the search mode: The result list shows direct and not direct
     * children of a folder. * @since 1.106.0
     */
    folderMode?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * In case folderMode is set to true this boolean indicates whether for the initial search the folder mode
     * is enabled.
     *
     * @since 1.114.0
     */
    folderModeForInitialSearch?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * In case folder mode is active: Automatically switch result view type to list in search mode and to table
     * in folder mode.
     *
     * @since 1.106.0
     */
    autoAdjustResultViewTypeInFolderMode?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Enables the query language for the hana_odata provider. With query language it is possible for the end
     * user to enter complex search queries with logical operators.
     *
     * @since 1.107.0
     */
    enableQueryLanguage?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Relevant for SAP partners and SAP, the "Application Component" you expect customers to create incidents.
     *
     * @since 1.108.0
     */
    applicationComponent?: string | PropertyBindingInfo;

    /**
     * Display a splitter bar to resize the left hand panel, containing all facets and filter criteria.
     *
     * @since 1.108.0
     */
    facetPanelResizable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Default size (percent) of the left hand panel, containing all facets and filter criteria. If "facetPanelResizable"
     * is true, the width of the facet panel can be changed by the user.
     *
     * @since 1.108.0
     */
    facetPanelWidthInPercent?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Whenever a search has no results, a 'No Results Page' is displayed. You can provide a custom page to
     * be more specific and add some hints, links, buttons or other content.
     *
     * @since 1.94.0
     */
    getCustomNoResultScreen?: Function | PropertyBindingInfo | `{${string}}`;

    /**
     * A callback which returns customized "label" for placeholder text of search box, in case there is no search
     * term. The placeholder text (en) will be "Search In: ".
     */
    getSearchInputPlaceholderLabel?:
      | Function
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Shall the window title be overwritten by this control? If true, the control will set the current search
     * condition as window title. If false, it will not set or update the window title.
     *
     * @since 1.93.0
     */
    overwriteBrowserTitle?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Data source id which is set when the UI is loaded or filter is reset. If dataSource is also set, dataSource
     * will be used during UI load and this parameter will used only after filter is reset.
     *
     * @since 1.93.0
     */
    defaultDataSource?: string | PropertyBindingInfo;

    /**
     * The layout is optimized for object selection / value help (narrow view w/o facet panel).
     *
     * @since 1.111.0
     */
    optimizeForValueHelp?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Callback for filtering the datasources displayed in the datasource dropdown listbox. The callback gets
     * a list of datsources and returns the filtered list of datasources.
     *
     * @since 1.112.0
     */
    filterDataSources?: Function | PropertyBindingInfo | `{${string}}`;

    /**
     * A boolean which indicates whether the facet panel is initially openend or closed. This affects only the
     * initial state of the facet panel. When not setting facetVisibility the initial state of the facet panel
     * typically is taken from the user personalization storage.
     *
     * @since 1.113.0
     */
    facetVisibility?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * A boolean for enabling (business) object suggestions.
     *
     * @since 1.113.0
     */
    boSuggestions?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * When set to true the facet panel is displayed also in case there are no search results.
     *
     * @since 1.113.0
     */
    displayFacetPanelInCaseOfNoResults?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * A boolean indicating that the search state is written to the URL.
     *
     * @since 1.113.0
     */
    updateUrl?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * A callback for rendering the search URL. The callback gets a list of url encoded parameters and returns
     * the URL string. Typically you need to register this callback in case updateUrl=true.
     *
     * @since 1.113.0
     */
    renderSearchUrl?: Function | PropertyBindingInfo | `{${string}}`;

    /**
     * A callback for checking whether a URL is a search URL. The callback receives a URL and returns true in
     * case the URL is a search URL. Typically you need to register this callback in case updateUrl=true.
     *
     * @since 1.113.0
     */
    isSearchUrl?: Function | PropertyBindingInfo | `{${string}}`;

    /**
     * A callback for parsing URL parameters. The callback receices URL parameters and returns modified URL
     * parameters. This is an optional callback. Also in case you set updateUrl=true typcically this callback
     * is not needed.
     *
     * @since 1.113.0
     */
    parseSearchUrlParameters?: Function | PropertyBindingInfo | `{${string}}`;

    /**
     * A list of datasources to be displayed in the facet panel in the collection area.
     *
     * @since 1.113.0
     */
    quickSelectDataSources?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * A callback which is called whenever the selection of result list items changes.
     *
     * @since 1.113.0
     */
    selectionChange?: Function | PropertyBindingInfo | `{${string}}`;

    /**
     * A callback which is called after the initialization of the search composite control.
     *
     * @since 1.113.0
     */
    initAsync?: Function | PropertyBindingInfo | `{${string}}`;

    /**
     * Enables the multiselection mode of search result items. A checkbox is provided for each result item if
     * the value is true.
     *
     * @since 1.96.0
     */
    enableMultiSelectionResultItems?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The maximal count of search result items displayed on a page after a search. By clicking Show More button,
     * another page of result items of the same count (if available) will be displayed.
     *
     * @since 1.96.0
     */
    pageSize?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Callback for formatting the filter string to be displayed in the filter bar (for closed facet panel).
     *
     * @since 1.120
     */
    formatFilterBarText?: Function | PropertyBindingInfo | `{${string}}`;

    /**
     * Callback for checking whether the filter bar is visible.
     *
     * @since 1.120
     */
    isFilterBarVisible?: Function | PropertyBindingInfo | `{${string}}`;

    /**
     * Adds a callback function which is called whenever there is a user triggered event.
     *
     * @since 1.120
     */
    eventConsumers?: string | PropertyBindingInfo;

    /**
     * Control instances which are part of this composite control.
     */
    content?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * Event is fired when search is started.
     */
    searchStarted?: (oEvent: Event) => void;

    /**
     * Event is fired when search is finished.
     */
    searchFinished?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the SearchCompositeControl#searchFinished event.
   */
  export interface SearchCompositeControl$SearchFinishedEventParameters {}

  /**
   * Event object of the SearchCompositeControl#searchFinished event.
   */
  export type SearchCompositeControl$SearchFinishedEvent = Event<
    SearchCompositeControl$SearchFinishedEventParameters,
    SearchCompositeControl
  >;

  /**
   * Parameters of the SearchCompositeControl#searchStarted event.
   */
  export interface SearchCompositeControl$SearchStartedEventParameters {}

  /**
   * Event object of the SearchCompositeControl#searchStarted event.
   */
  export type SearchCompositeControl$SearchStartedEvent = Event<
    SearchCompositeControl$SearchStartedEventParameters,
    SearchCompositeControl
  >;
}

declare namespace sap {
  interface IUI5DefineDependencyNames {
    "sap/esh/search/ui/library": undefined;

    "sap/esh/search/ui/SearchCompositeControl": undefined;
  }
}
