import { AbstractAdapter, AbstractReader } from "@ui5/fs";
import { LintMessageSeverity, MESSAGE } from "./messages.js";
import { MessageArgs } from "./MessageArgs.js";
import { Directive } from "./ui5Types/directives.js";
import ts from "typescript";
export type FilePattern = string;
export type FilePath = string;
export type ResourcePath = string;
export interface FixHints {
    moduleName?: string;
    exportName?: string;
    propertyAccess?: string;
    conditional?: boolean;
}
export interface LintResult {
    filePath: FilePath;
    messages: LintMessage[];
    coverageInfo: CoverageInfo[];
    errorCount: number;
    fatalErrorCount: number;
    warningCount: number;
}
export interface RawLintResult {
    filePath: FilePath;
    rawMessages: RawLintMessage[];
}
export interface RawLintMessage<M extends MESSAGE = MESSAGE> {
    id: M;
    args: MessageArgs[M];
    position?: PositionInfo;
    fixHints?: FixHints;
}
export interface LintMessage {
    ruleId: string;
    severity: LintMessageSeverity;
    message: string;
    messageDetails?: string;
    fatal?: boolean | undefined;
    line?: number | undefined;
    column?: number | undefined;
    endLine?: number | undefined;
    endColumn?: number | undefined;
}
export declare enum CoverageCategory {
    CallExpressionUnknownType = 1
}
export interface CoverageInfo {
    category: CoverageCategory;
    message: string;
    messageDetails?: string;
    line?: number | undefined;
    column?: number | undefined;
    endLine?: number | undefined;
    endColumn?: number | undefined;
}
export interface TranspileResult {
    source: string;
    map: string;
}
export interface LinterOptions {
    rootDir: string;
    filePatterns?: FilePattern[];
    ignorePatterns?: FilePattern[];
    coverage?: boolean;
    details?: boolean;
    fix?: boolean;
    configPath?: string;
    noConfig?: boolean;
    ui5Config?: string | object;
    namespace?: string;
}
export interface LinterParameters {
    workspace: AbstractAdapter;
    filePathsWorkspace: AbstractAdapter;
    context: LinterContext;
}
export interface PositionInfo {
    line: number;
    column: number;
}
export interface PositionRange {
    start: PositionInfo;
    end?: PositionInfo;
}
export interface LintMetadata {
    directives: Set<Directive>;
    transformedImports: Map<string, Set<string>>;
    xmlCompiledResource: string;
    jsToXmlPosMapping: {
        pos: ts.LineAndCharacter;
        originalPath: string;
    };
}
export default class LinterContext {
    #private;
    constructor(options: LinterOptions);
    getRootDir(): string;
    setRootReader(rootReader: AbstractReader): void;
    getRootReader(): AbstractReader;
    getNamespace(): string | undefined;
    getReportCoverage(): boolean;
    getIncludeMessageDetails(): boolean;
    getApplyAutofix(): boolean;
    getMetadata(resourcePath: ResourcePath): LintMetadata;
    getRawLintingMessages(resourcePath: ResourcePath): RawLintMessage[];
    addLintingMessage<M extends MESSAGE>(resourcePath: ResourcePath, id: M, args: MessageArgs[M]): void;
    addLintingMessage<M extends MESSAGE>(resourcePath: ResourcePath, id: M, args: MessageArgs[M], position: PositionInfo): void;
    addLintingMessages<M extends MESSAGE>(resourcePath: ResourcePath, rawMessages: RawLintMessage<M>[]): void;
    getCoverageInfo(resourcePath: ResourcePath): CoverageInfo[];
    addCoverageInfo(resourcePath: ResourcePath, coverageInfo: CoverageInfo): void;
    generateLintResult(resourcePath: ResourcePath): LintResult;
    generateLintResults(): LintResult[];
    generateRawLintResults(): RawLintResult[];
}
