import ts from "typescript";
import { CONTROLLER_BY_ID_DTS_PATH } from "../xmlTemplate/linter.js";
export default class LanguageServiceHostProxy {
    emptyLanguageServiceHost;
    languageServiceHost;
    scriptSnapshots = {};
    constructor() {
        this.emptyLanguageServiceHost = this.languageServiceHost = new EmptyLanguageServiceHost();
    }
    setHost(languageServiceHostImpl) {
        this.languageServiceHost = languageServiceHostImpl ?? this.emptyLanguageServiceHost;
    }
    isSharedTypesFile(filePath) {
        // ControllerById.d.ts file is generated per project and should not be treated as a shared file
        return filePath.startsWith("/types/") && filePath !== CONTROLLER_BY_ID_DTS_PATH;
    }
    // ts.LanguageServiceHost implementation:
    getCompilationSettings() {
        return this.languageServiceHost.getCompilationSettings();
    }
    getScriptFileNames() {
        return this.languageServiceHost.getScriptFileNames();
    }
    getScriptVersion(fileName) {
        if (this.isSharedTypesFile(fileName)) {
            // All types should be cached forever as they can be shared across projects
            return "1";
        }
        return this.languageServiceHost.getScriptVersion(fileName);
    }
    getScriptSnapshot(fileName) {
        if (this.scriptSnapshots[fileName]) {
            return this.scriptSnapshots[fileName];
        }
        const scriptSnapshot = this.languageServiceHost.getScriptSnapshot(fileName);
        if (this.isSharedTypesFile(fileName)) {
            this.scriptSnapshots[fileName] = scriptSnapshot;
        }
        return scriptSnapshot;
    }
    fileExists(filePath) {
        return this.languageServiceHost.fileExists(filePath);
    }
    readFile(filePath) {
        return this.languageServiceHost.readFile(filePath);
    }
    getDefaultLibFileName(options) {
        return this.languageServiceHost.getDefaultLibFileName(options);
    }
    getCurrentDirectory() {
        return this.languageServiceHost.getCurrentDirectory();
    }
}
export class EmptyLanguageServiceHost {
    getCompilationSettings() {
        return {};
    }
    getScriptFileNames() {
        return [];
    }
    getScriptVersion() {
        return "0";
    }
    getScriptSnapshot() {
        return undefined;
    }
    fileExists() {
        return false;
    }
    readFile() {
        return undefined;
    }
    getCurrentDirectory() {
        return "/";
    }
    getDefaultLibFileName(options) {
        return ts.getDefaultLibFileName(options);
    }
}
//# sourceMappingURL=LanguageServiceHostProxy.js.map