// For Library Version: 1.120.26

declare module "sap/ui/webc/main/library" {
  /**
   * Different types of AvatarColorScheme.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum AvatarColorScheme {
    Accent1 = "Accent1",

    Accent10 = "Accent10",

    Accent2 = "Accent2",

    Accent3 = "Accent3",

    Accent4 = "Accent4",

    Accent5 = "Accent5",

    Accent6 = "Accent6",

    Accent7 = "Accent7",

    Accent8 = "Accent8",

    Accent9 = "Accent9",

    Placeholder = "Placeholder",
  }
  /**
   * Different types of AvatarGroupType.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum AvatarGroupType {
    /**
     * The avatars are displayed as partially overlapped on top of each other and the entire group has one click
     * or tap area.
     */
    Group = "Group",
    /**
     * The avatars are displayed side-by-side and each avatar has its own click or tap area.
     */
    Individual = "Individual",
  }
  /**
   * Different types of AvatarShape.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum AvatarShape {
    /**
     * Circular shape.
     */
    Circle = "Circle",
    /**
     * Square shape.
     */
    Square = "Square",
  }
  /**
   * Different types of AvatarSize.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum AvatarSize {
    /**
     * component size - 5rem font size - 2.5rem
     */
    L = "L",
    /**
     * component size - 4rem font size - 2rem
     */
    M = "M",
    /**
     * component size - 3rem font size - 1.5rem
     */
    S = "S",
    /**
     * component size - 7rem font size - 3rem
     */
    XL = "XL",
    /**
     * component size - 2rem font size - 1rem
     */
    XS = "XS",
  }
  /**
   * Defines background designs.
   *
   * @since 1.115.0
   * @experimental (since 1.115.0) - This API is experimental and might change significantly.
   */
  export enum BackgroundDesign {
    /**
     * A solid background color dependent on the theme.
     */
    Solid = "Solid",
    /**
     * A translucent background depending on the opacity value of the theme.
     */
    Translucent = "Translucent",
    /**
     * Transparent background.
     */
    Transparent = "Transparent",
  }
  /**
   * Defines border designs.
   *
   * @since 1.115.0
   * @experimental (since 1.115.0) - This API is experimental and might change significantly.
   */
  export enum BorderDesign {
    /**
     * Specifies no border.
     */
    None = "None",
    /**
     * A solid border color dependent on the theme.
     */
    Solid = "Solid",
  }
  /**
   * Different Breadcrumbs designs.
   *
   * @since 1.95.0
   * @experimental (since 1.95.0) - This API is experimental and might change significantly.
   */
  export enum BreadcrumbsDesign {
    /**
     * All items are displayed as links.
     */
    NoCurrentPage = "NoCurrentPage",
    /**
     * Shows the current page as the last item in the trail. The last item contains only plain text and is not
     * a link.
     */
    Standard = "Standard",
  }
  /**
   * Different Breadcrumbs separator styles.
   *
   * @since 1.95.0
   * @experimental (since 1.95.0) - This API is experimental and might change significantly.
   */
  export enum BreadcrumbsSeparatorStyle {
    /**
     * The separator appears as "\".
     */
    BackSlash = "BackSlash",
    /**
     * The separator appears as "\\".
     */
    DoubleBackSlash = "DoubleBackSlash",
    /**
     * The separator appears as ">>".
     */
    DoubleGreaterThan = "DoubleGreaterThan",
    /**
     * The separator appears as "//" .
     */
    DoubleSlash = "DoubleSlash",
    /**
     * The separator appears as ">".
     */
    GreaterThan = "GreaterThan",
    /**
     * The separator appears as "/".
     */
    Slash = "Slash",
  }
  /**
   * Different BusyIndicator sizes.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum BusyIndicatorSize {
    /**
     * large size
     */
    Large = "Large",
    /**
     * medium size
     */
    Medium = "Medium",
    /**
     * small size
     */
    Small = "Small",
  }
  /**
   * Different Button designs.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum ButtonDesign {
    /**
     * attention type
     */
    Attention = "Attention",
    /**
     * default type (no special styling)
     */
    Default = "Default",
    /**
     * emphasized type
     */
    Emphasized = "Emphasized",
    /**
     * reject style (red button)
     */
    Negative = "Negative",
    /**
     * accept type (green button)
     */
    Positive = "Positive",
    /**
     * transparent type
     */
    Transparent = "Transparent",
  }
  /**
   * Determines if the button has special form-related functionality.
   *
   * @since 1.120.0
   * @experimental (since 1.120.0) - This API is experimental and might change significantly.
   */
  export enum ButtonType {
    /**
     * The button does not do anything special when inside a form
     */
    Button = "Button",
    /**
     * The button acts as a reset button (resets a form)
     */
    Reset = "Reset",
    /**
     * The button acts as a submit button (submits a form)
     */
    Submit = "Submit",
  }
  /**
   * Different Calendar selection mode.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum CalendarSelectionMode {
    /**
     * Several dates can be selected
     */
    Multiple = "Multiple",
    /**
     * A range defined by a start date and an end date can be selected
     */
    Range = "Range",
    /**
     * Only one date can be selected at a time
     */
    Single = "Single",
  }
  /**
   * Different Carousel arrows placement.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum CarouselArrowsPlacement {
    /**
     * Carousel arrows are placed on the sides of the current Carousel page.
     */
    Content = "Content",
    /**
     * Carousel arrows are placed on the sides of the page indicator of the Carousel.
     */
    Navigation = "Navigation",
  }
  /**
   * Different Carousel page indicator styles.
   *
   * @since 1.115.0
   * @experimental (since 1.115.0) - This API is experimental and might change significantly.
   */
  export enum CarouselPageIndicatorStyle {
    /**
     * The page indicator will be visualized as dots if there are fewer than 9 pages. If there are more pages,
     * the page indicator will switch to displaying the current page and the total number of pages. (e.g. X
     * of Y)
     */
    Default = "Default",
    /**
     * The page indicator will display the current page and the total number of pages. (e.g. X of Y)
     */
    Numeric = "Numeric",
  }
  /**
   * Different filtering types of the ComboBox.
   *
   * @since 1.115.0
   * @experimental (since 1.115.0) - This API is experimental and might change significantly.
   */
  export enum ComboBoxFilter {
    /**
     * Defines contains filtering.
     */
    Contains = "Contains",
    /**
     * Removes any filtering applied while typing
     */
    None = "None",
    /**
     * Defines filtering by starting symbol of item's text.
     */
    StartsWith = "StartsWith",
    /**
     * Defines filtering by first symbol of each word of item's text.
     */
    StartsWithPerTerm = "StartsWithPerTerm",
  }
  /**
   * Different types of HasPopup.
   *
   * @since 1.99.0
   * @experimental (since 1.99.0) - This API is experimental and might change significantly.
   */
  export enum HasPopup {
    /**
     * Dialog popup type.
     */
    Dialog = "Dialog",
    /**
     * Grid popup type.
     */
    Grid = "Grid",
    /**
     * ListBox popup type.
     */
    ListBox = "ListBox",
    /**
     * Menu popup type.
     */
    Menu = "Menu",
    /**
     * Tree popup type.
     */
    Tree = "Tree",
  }
  /**
   * Interface for components that represent an avatar and may be slotted in numerous higher-order components
   * such as `ui5-avatar-group`
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export interface IAvatar {
    __implements__sap_ui_webc_main_IAvatar: boolean;
  }

  /**
   * Interface for components that may be slotted inside `ui5-breadcrumbs` as options
   *
   * @since 1.95.0
   * @experimental (since 1.95.0) - This API is experimental and might change significantly.
   */
  export interface IBreadcrumbsItem {
    __implements__sap_ui_webc_main_IBreadcrumbsItem: boolean;
  }

  /**
   * Interface for components that may be used as a button inside numerous higher-order components
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export interface IButton {
    __implements__sap_ui_webc_main_IButton: boolean;
  }

  /**
   * Interface for components that may be used as dates inside `ui5-calendar`
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export interface ICalendarDate {
    __implements__sap_ui_webc_main_ICalendarDate: boolean;
  }

  /**
   * Interface for components that may be slotted inside `ui5-card` as header
   *
   * @since 1.115.0
   * @experimental (since 1.115.0) - This API is experimental and might change significantly.
   */
  export interface ICardHeader {
    __implements__sap_ui_webc_main_ICardHeader: boolean;
  }

  /**
   * Interface for components that may be used inside a `ui5-color-palette` or `ui5-color-palette-popover`
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export interface IColorPaletteItem {
    __implements__sap_ui_webc_main_IColorPaletteItem: boolean;
  }

  /**
   * Interface for components that may be slotted inside a `ui5-combobox`
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export interface IComboBoxItem {
    __implements__sap_ui_webc_main_IComboBoxItem: boolean;
  }

  /**
   * Different Icon semantic designs.
   *
   * @since 1.115.0
   * @experimental (since 1.115.0) - This API is experimental and might change significantly.
   */
  export enum IconDesign {
    /**
     * Contrast design
     */
    Contrast = "Contrast",
    /**
     * Critical design
     */
    Critical = "Critical",
    /**
     * Default design (brand design)
     */
    Default = "Default",
    /**
     * info type
     */
    Information = "Information",
    /**
     * Negative design
     */
    Negative = "Negative",
    /**
     * Neutral design
     */
    Neutral = "Neutral",
    /**
     * Design that indicates an icon which isn't interactive
     */
    NonInteractive = "NonInteractive",
    /**
     * Positive design
     */
    Positive = "Positive",
  }
  /**
   * Interface for components that represent an icon, usable in numerous higher-order components
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export interface IIcon {
    __implements__sap_ui_webc_main_IIcon: boolean;
  }

  /**
   * Interface for components that represent an input, usable in numerous higher-order components
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export interface IInput {
    __implements__sap_ui_webc_main_IInput: boolean;
  }

  /**
   * Interface for components that represent a suggestion item, usable in `ui5-input`
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export interface IInputSuggestionItem {
    __implements__sap_ui_webc_main_IInputSuggestionItem: boolean;
  }

  /**
   * Interface for components that may be slotted inside a `ui5-list` as items
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export interface IListItem {
    __implements__sap_ui_webc_main_IListItem: boolean;
  }

  /**
   * Interface for components that may be slotted inside `ui5-menu` as items
   *
   * @since 1.102.0
   * @experimental (since 1.102.0) - This API is experimental and might change significantly.
   */
  export interface IMenuItem {
    __implements__sap_ui_webc_main_IMenuItem: boolean;
  }

  /**
   * Interface for components that may be slotted inside a `ui5-multi-combobox` as items
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export interface IMultiComboBoxItem {
    __implements__sap_ui_webc_main_IMultiComboBoxItem: boolean;
  }

  /**
   * Different input types.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum InputType {
    /**
     * Used for input fields that must contain an e-mail address.
     */
    Email = "Email",
    /**
     * Defines a numeric input field.
     */
    Number = "Number",
    /**
     * Defines a password field.
     */
    Password = "Password",
    /**
     * Used for input fields that should contain a telephone number.
     */
    Tel = "Tel",
    /**
     * Defines a one-line text input field:
     */
    Text = "Text",
    /**
     * Used for input fields that should contain a URL address.
     */
    URL = "URL",
  }
  /**
   * Interface for components that may be slotted inside `ui5-segmented-button` as items
   *
   * @since 1.95.0
   * @experimental (since 1.95.0) - This API is experimental and might change significantly.
   */
  export interface ISegmentedButtonItem {
    __implements__sap_ui_webc_main_ISegmentedButtonItem: boolean;
  }

  /**
   * Interface for components that may be slotted inside `ui5-select-menu` as options
   *
   * @since 1.120.0
   * @experimental (since 1.120.0) - This API is experimental and might change significantly.
   */
  export interface ISelectMenuOption {
    __implements__sap_ui_webc_main_ISelectMenuOption: boolean;
  }

  /**
   * Interface for components that may be slotted inside `ui5-select` as options
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export interface ISelectOption {
    __implements__sap_ui_webc_main_ISelectOption: boolean;
  }

  /**
   * Interface for components that may be slotted inside `ui5-tabcontainer`
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export interface ITab {
    __implements__sap_ui_webc_main_ITab: boolean;
  }

  /**
   * Interface for components that may be slotted inside a `ui5-table-row` as cells
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export interface ITableCell {
    __implements__sap_ui_webc_main_ITableCell: boolean;
  }

  /**
   * Interface for components that may be slotted inside a `ui5-table` as columns
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export interface ITableColumn {
    __implements__sap_ui_webc_main_ITableColumn: boolean;
  }

  /**
   * Interface for components that may be slotted inside a `ui5-table` as rows
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export interface ITableRow {
    __implements__sap_ui_webc_main_ITableRow: boolean;
  }

  /**
   * Interface for components that represent a token and are usable in components such as `ui5-multi-input`
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export interface IToken {
    __implements__sap_ui_webc_main_IToken: boolean;
  }

  /**
   * Interface for toolbar items for the purpose of `ui5-toolbar`
   *
   * @since 1.120.0
   * @experimental (since 1.120.0) - This API is experimental and might change significantly.
   */
  export interface IToolbarItem {
    __implements__sap_ui_webc_main_IToolbarItem: boolean;
  }

  /**
   * Interface for toolbar select items for the purpose of `ui5-toolbar-select`
   *
   * @since 1.120.0
   * @experimental (since 1.120.0) - This API is experimental and might change significantly.
   */
  export interface IToolbarSelectOption {
    __implements__sap_ui_webc_main_IToolbarSelectOption: boolean;
  }

  /**
   * Interface for tree items for the purpose of `ui5-tree`
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export interface ITreeItem {
    __implements__sap_ui_webc_main_ITreeItem: boolean;
  }

  /**
   * Different link designs.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum LinkDesign {
    /**
     * default type (no special styling)
     */
    Default = "Default",
    /**
     * emphasized type
     */
    Emphasized = "Emphasized",
    /**
     * subtle type (appears as regular text, rather than a link)
     */
    Subtle = "Subtle",
  }
  /**
   * Different list growing modes.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum ListGrowingMode {
    /**
     * Component's "load-more" is fired upon pressing a "More" button. at the bottom.
     */
    Button = "Button",
    /**
     * Component's growing is not enabled.
     */
    None = "None",
    /**
     * Component's "load-more" is fired upon scroll.
     */
    Scroll = "Scroll",
  }
  /**
   * Different list item types.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum ListItemType {
    /**
     * Indicates that the item is clickable via active feedback when item is pressed.
     */
    Active = "Active",
    /**
     * Enables detail button of the list item that fires detail-click event.
     */
    Detail = "Detail",
    /**
     * Indicates the list item does not have any active feedback when item is pressed.
     */
    Inactive = "Inactive",
    /**
     * Enables the type of navigation, which is specified to add an arrow at the end of the items and fires
     * navigate-click event.
     */
    Navigation = "Navigation",
  }
  /**
   * Different list modes.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum ListMode {
    /**
     * Delete mode (only one list item can be deleted via provided delete button)
     */
    Delete = "Delete",
    /**
     * Multi selection mode (more than one list item can be selected).
     */
    MultiSelect = "MultiSelect",
    /**
     * Default mode (no selection).
     */
    None = "None",
    /**
     * Right-positioned single selection mode (only one list item can be selected).
     */
    SingleSelect = "SingleSelect",
    /**
     * Selected item is highlighted and selection is changed upon arrow navigation (only one list item can be
     * selected - this is always the focused item).
     */
    SingleSelectAuto = "SingleSelectAuto",
    /**
     * Left-positioned single selection mode (only one list item can be selected).
     */
    SingleSelectBegin = "SingleSelectBegin",
    /**
     * Selected item is highlighted but no selection element is visible (only one list item can be selected).
     */
    SingleSelectEnd = "SingleSelectEnd",
  }
  /**
   * Different types of list items separators.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum ListSeparators {
    /**
     * Separators between the items including the last and the first one.
     */
    All = "All",
    /**
     * Separators between the items. Note: This enumeration depends on the theme.
     */
    Inner = "Inner",
    /**
     * No item separators.
     */
    None = "None",
  }
  /**
   * MessageStrip designs.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum MessageStripDesign {
    /**
     * Message should be just an information
     */
    Information = "Information",
    /**
     * Message is an error
     */
    Negative = "Negative",
    /**
     * Message is a success message
     */
    Positive = "Positive",
    /**
     * Message is a warning
     */
    Warning = "Warning",
  }
  /**
   * Panel accessible roles.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum PanelAccessibleRole {
    /**
     * Represents the ARIA role "complementary". A section of the page, designed to be complementary to the
     * main content at a similar level in the DOM hierarchy.
     */
    Complementary = "Complementary",
    /**
     * Represents the ARIA role "Form". A landmark region that contains a collection of items and objects that,
     * as a whole, create a form.
     */
    Form = "Form",
    /**
     * Represents the ARIA role "Region". A section of a page, that is important enough to be included in a
     * page summary or table of contents.
     */
    Region = "Region",
  }
  /**
   * Popover horizontal align types.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum PopoverHorizontalAlign {
    /**
     * Popover is centered.
     */
    Center = "Center",
    /**
     * Popover is aligned with the left side of the target. When direction is RTL, it is right aligned.
     */
    Left = "Left",
    /**
     * Popover is aligned with the right side of the target. When direction is RTL, it is left aligned.
     */
    Right = "Right",
    /**
     * Popover is stretched.
     */
    Stretch = "Stretch",
  }
  /**
   * Popover placement types.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum PopoverPlacementType {
    /**
     * Popover will be placed at the bottom of the reference element.
     */
    Bottom = "Bottom",
    /**
     * Popover will be placed at the left side of the reference element.
     */
    Left = "Left",
    /**
     * Popover will be placed at the right side of the reference element.
     */
    Right = "Right",
    /**
     * Popover will be placed at the top of the reference element.
     */
    Top = "Top",
  }
  /**
   * Popover vertical align types.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum PopoverVerticalAlign {
    /**
     * Popover will be placed at the bottom of the reference control.
     */
    Bottom = "Bottom",

    Center = "Center",
    /**
     * Popover will be streched
     */
    Stretch = "Stretch",
    /**
     * Popover will be placed at the top of the reference control.
     */
    Top = "Top",
  }
  /**
   * Popup accessible roles.
   *
   * @since 1.115.0
   * @experimental (since 1.115.0) - This API is experimental and might change significantly.
   */
  export enum PopupAccessibleRole {
    /**
     * Represents the ARIA role "alertdialog".
     */
    AlertDialog = "AlertDialog",
    /**
     * Represents the ARIA role "dialog".
     */
    Dialog = "Dialog",
    /**
     * Represents no ARIA role.
     */
    None = "None",
  }
  /**
   * Different types of Priority.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum Priority {
    /**
     * High priority.
     */
    High = "High",
    /**
     * Low priority.
     */
    Low = "Low",
    /**
     * Medium priority.
     */
    Medium = "Medium",
    /**
     * Default, none priority.
     */
    None = "None",
  }
  /**
   * Different SegmentedButton modes.
   *
   * @since 1.115.0
   * @experimental (since 1.115.0) - This API is experimental and might change significantly.
   */
  export enum SegmentedButtonMode {
    /**
     * Multiple items can be selected at a time. All items can be deselected.
     */
    MultiSelect = "MultiSelect",
    /**
     * There is always one selected. Selecting one deselects the previous one.
     */
    SingleSelect = "SingleSelect",
  }
  /**
   * Different types of SemanticColor.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum SemanticColor {
    /**
     * Critical color
     */
    Critical = "Critical",
    /**
     * Default color (brand color)
     */
    Default = "Default",
    /**
     * Negative color
     */
    Negative = "Negative",
    /**
     * Neutral color.
     */
    Neutral = "Neutral",
    /**
     * Positive color
     */
    Positive = "Positive",
  }
  /**
   * Different types of Switch designs.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum SwitchDesign {
    /**
     * Defines the Switch as Graphical
     */
    Graphical = "Graphical",
    /**
     * Defines the Switch as Textual
     */
    Textual = "Textual",
  }
  /**
   * Background design for the header and content of TabContainer.
   *
   * @since 1.115.0
   * @experimental (since 1.115.0) - This API is experimental and might change significantly.
   */
  export enum TabContainerBackgroundDesign {
    /**
     * A Solid background color.
     */
    Solid = "Solid",
    /**
     * A Translucent background color.
     */
    Translucent = "Translucent",
    /**
     * A Transparent background color.
     */
    Transparent = "Transparent",
  }
  /**
   * Tab layout of TabContainer.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum TabLayout {
    /**
     * Inline type, the tab "main text" and "additionalText" are displayed horizotally.
     */
    Inline = "Inline",
    /**
     * Standard type, the tab "main text" and "additionalText" are displayed vertically.
     */
    Standard = "Standard",
  }
  /**
   * Table cell popin display.
   *
   * @since 1.115.0
   * @experimental (since 1.115.0) - This API is experimental and might change significantly.
   */
  export enum TableColumnPopinDisplay {
    /**
     * default type
     */
    Block = "Block",
    /**
     * inline type (the title and value are displayed on the same line)
     */
    Inline = "Inline",
  }
  /**
   * Different table growing modes.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum TableGrowingMode {
    /**
     * Component `load-more` is fired upon pressing a "More" button at the bottom.
     */
    Button = "Button",
    /**
     * Component growing is not enabled.
     */
    None = "None",
    /**
     * Component `load-more` is fired upon scroll.
     */
    Scroll = "Scroll",
  }
  /**
   * Different table modes.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum TableMode {
    /**
     * Multi selection mode (more than one table row can be selected).
     */
    MultiSelect = "MultiSelect",
    /**
     * Default mode (no selection).
     */
    None = "None",
    /**
     * Single selection mode (only one table row can be selected).
     */
    SingleSelect = "SingleSelect",
  }
  /**
   * Different table row types.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum TableRowType {
    /**
     * Indicates that the table row is clickable via active feedback when item is pressed.
     */
    Active = "Active",
    /**
     * Indicates that the table row does not have any active feedback when item is pressed.
     */
    Inactive = "Inactive",
  }
  /**
   * Tabs overflow mode in TabContainer.
   *
   * @since 1.99.0
   * @experimental (since 1.99.0) - This API is experimental and might change significantly.
   */
  export enum TabsOverflowMode {
    /**
     * End type is used if there should be only one overflow with hidden the tabs at the end of the tab container.
     */
    End = "End",
    /**
     * StartAndEnd type is used if there should be two overflows on both ends of the tab container.
     */
    StartAndEnd = "StartAndEnd",
  }
  /**
   * Different types of Title level.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum TitleLevel {
    /**
     * Renders `h1` tag.
     */
    H1 = "H1",
    /**
     * Renders `h2` tag.
     */
    H2 = "H2",
    /**
     * Renders `h3` tag.
     */
    H3 = "H3",
    /**
     * Renders `h4` tag.
     */
    H4 = "H4",
    /**
     * Renders `h5` tag.
     */
    H5 = "H5",
    /**
     * Renders `h6` tag.
     */
    H6 = "H6",
  }
  /**
   * Toast placement.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum ToastPlacement {
    /**
     * Toast is placed at the `BottomCenter` position of its container. Default placement (no selection)
     */
    BottomCenter = "BottomCenter",
    /**
     * Toast is placed at the `BottomEnd` position of its container.
     */
    BottomEnd = "BottomEnd",
    /**
     * Toast is placed at the `BottomStart` position of its container.
     */
    BottomStart = "BottomStart",
    /**
     * Toast is placed at the `MiddleCenter` position of its container.
     */
    MiddleCenter = "MiddleCenter",
    /**
     * Toast is placed at the `MiddleEnd` position of its container.
     */
    MiddleEnd = "MiddleEnd",
    /**
     * Toast is placed at the `MiddleStart` position of its container.
     */
    MiddleStart = "MiddleStart",
    /**
     * Toast is placed at the `TopCenter` position of its container.
     */
    TopCenter = "TopCenter",
    /**
     * Toast is placed at the `TopEnd` position of its container.
     */
    TopEnd = "TopEnd",
    /**
     * Toast is placed at the `TopStart` position of its container.
     */
    TopStart = "TopStart",
  }
  /**
   * Defines which direction the items of ui5-toolbar will be aligned.
   *
   * @since 1.120.0
   * @experimental (since 1.120.0) - This API is experimental and might change significantly.
   */
  export enum ToolbarAlign {
    /**
     * Toolbar items are situated at the `end` of the Toolbar
     */
    End = "End",
    /**
     * Toolbar items are situated at the `start` of the Toolbar
     */
    Start = "Start",
  }
  /**
   * Defines the priority of the toolbar item to go inside overflow popover.
   *
   * @since 1.120.0
   * @experimental (since 1.120.0) - This API is experimental and might change significantly.
   */
  export enum ToolbarItemOverflowBehavior {
    AlwaysOverflow = "AlwaysOverflow",
    /**
     * The item is presented inside the toolbar and goes in the popover, when there is not enough space.
     */
    Default = "Default",
    /**
     * When set, the item will never go to the overflow popover.
     */
    NeverOverflow = "NeverOverflow",
  }
  /**
   * Different types of wrapping.
   *
   * @since 1.92.0
   * @experimental (since 1.92.0) - This API is experimental and might change significantly.
   */
  export enum WrappingType {
    /**
     * The text will be truncated with an ellipsis.
     */
    None = "None",
    /**
     * The text will wrap. The words will not be broken based on hyphenation.
     */
    Normal = "Normal",
  }
}

declare module "sap/ui/webc/main/Avatar" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import {
    IAvatar,
    AvatarColorScheme,
    AvatarShape,
    AvatarSize,
  } from "sap/ui/webc/main/library";

  import Event from "sap/ui/base/Event";

  import Control from "sap/ui/core/Control";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * An image-like component that has different display options for representing images and icons in different
   * shapes and sizes, depending on the use case.
   *
   * The shape can be circular or square. There are several predefined sizes, as well as an option to set
   * a custom size.
   *
   *
   *
   *  Keyboard Handling:
   *
   *
   * 	 - [SPACE, ENTER, RETURN] - Fires the `click` event if the `interactive` property is set to true.
   * 	 - [SHIFT] - If [SPACE] is pressed, pressing [SHIFT] releases the component without triggering the click
   *     event.
   *
   *
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class Avatar extends WebComponent implements IAvatar {
    __implements__sap_ui_webc_main_IAvatar: boolean;
    /**
     * Constructor for a new `Avatar`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $AvatarSettings
    );
    /**
     * Constructor for a new `Avatar`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $AvatarSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.Avatar with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Avatar>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.Avatar.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.webc.main.Avatar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Avatar` itself.
     *
     * Fired when the user clicks the control
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Avatar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.webc.main.Avatar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Avatar` itself.
     *
     * Fired when the user clicks the control
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Avatar` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the badge in the aggregation {@link #getBadge badge}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyBadge(): this;
    /**
     * Destroys the image in the aggregation {@link #getImage image}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyImage(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:click click} event of this `sap.ui.webc.main.Avatar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:click click} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the text alternative of the component. If not provided a default text alternative will be set,
     * if present.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Gets content of aggregation {@link #getBadge badge}.
     *
     * Defines the optional badge that will be used for visual affordance. **Note:** While the slot allows for
     * custom badges, to achieve the Fiori design, please use `sap.ui.webc.main.Badge` with `sap.ui.webc.main.Icon`
     * in the corresponding `icon` slot, without text nodes.
     *
     *  Example:
     *
     *  <ui5-avatar>
     *  <ui5-badge slot="badge">
     *  <ui5-icon slot="icon" name="employee"></ui5-icon>
     *  </ui5-badge>
     *  </ui5-avatar>
     */
    getBadge(): Control;
    /**
     * Gets current value of property {@link #getColorScheme colorScheme}.
     *
     * Defines the background color of the desired image.
     *
     *  Available options are:
     * 	 - `Accent1`
     * 	 - `Accent2`
     * 	 - `Accent3`
     * 	 - `Accent4`
     * 	 - `Accent5`
     * 	 - `Accent6`
     * 	 - `Accent7`
     * 	 - `Accent8`
     * 	 - `Accent9`
     * 	 - `Accent10`
     * 	 - `Placeholder`
     *
     * Default value is `Accent6`.
     *
     *
     * @returns Value of property `colorScheme`
     */
    getColorScheme(): AvatarColorScheme | keyof typeof AvatarColorScheme;
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getFallbackIcon fallbackIcon}.
     *
     * Defines the name of the fallback icon, which should be displayed in the following cases:
     * 	 - If the initials are not valid (more than 3 letters, unsupported languages or empty initials).
     * 	 - If there are three initials and they do not fit in the shape (e.g. WWW for some of the sizes).
     * 	 - If the image src is wrong.
     *
     *
     *  **Note:** If not set, a default fallback icon "employee" is displayed.
     *  **Note:** You should import the desired icon first, then use its name as "fallback-icon".
     *
     *  import "@ui5/webcomponents-icons/dist/{icon_name}.js"
     *
     * ```javascript
     * <ui5-avatar fallback-icon="alert">```
     *
     *
     *
     * See all the available icons in the {@link demo:sap/m/demokit/iconExplorer/webapp/index.html Icon Explorer}.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `fallbackIcon`
     */
    getFallbackIcon(): string;
    /**
     * Gets current value of property {@link #getIcon icon}.
     *
     * Defines the name of the UI5 Icon, that will be displayed.
     *  **Note:** If `image` slot is provided, the property will be ignored.
     *  **Note:** You should import the desired icon first, then use its name as "icon".
     *
     *  import "@ui5/webcomponents-icons/dist/{icon_name}.js"
     *
     * ```javascript
     * <ui5-avatar icon="employee">```
     *
     *  **Note:** If no icon or an empty one is provided, by default the "employee" icon should be displayed.
     *
     * See all the available icons in the {@link demo:sap/m/demokit/iconExplorer/webapp/index.html Icon Explorer}.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `icon`
     */
    getIcon(): string;
    /**
     * Gets content of aggregation {@link #getImage image}.
     *
     * Receives the desired `<img>` tag
     *
     * **Note:** If you experience flickering of the provided image, you can hide the component until it is
     * being defined with the following CSS:   ` ui5-avatar:not(:defined) {  visibility: hidden;
     *  }  `
     */
    getImage(): Control;
    /**
     * Gets current value of property {@link #getInitials initials}.
     *
     * Defines the displayed initials.
     *  Up to three Latin letters can be displayed as initials.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `initials`
     */
    getInitials(): string;
    /**
     * Gets current value of property {@link #getInteractive interactive}.
     *
     * Defines if the avatar is interactive (focusable and pressable). **Note:** This property won't have effect
     * if the `disabled` property is set to `true`.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `interactive`
     */
    getInteractive(): boolean;
    /**
     * Gets current value of property {@link #getShape shape}.
     *
     * Defines the shape of the component.
     *
     *  Available options are:
     * 	 - `Circle`
     * 	 - `Square`
     *
     * Default value is `Circle`.
     *
     *
     * @returns Value of property `shape`
     */
    getShape(): AvatarShape | keyof typeof AvatarShape;
    /**
     * Gets current value of property {@link #getSize size}.
     *
     * Defines predefined size of the component.
     *
     *  Available options are:
     * 	 - `XS`
     * 	 - `S`
     * 	 - `M`
     * 	 - `L`
     * 	 - `XL`
     *
     * Default value is `S`.
     *
     *
     * @returns Value of property `size`
     */
    getSize(): AvatarSize | keyof typeof AvatarSize;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the text alternative of the component. If not provided a default text alternative will be set,
     * if present.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName?: string
    ): this;
    /**
     * Sets the aggregated {@link #getBadge badge}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBadge(
      /**
       * The badge to set
       */
      oBadge: Control
    ): this;
    /**
     * Sets a new value for property {@link #getColorScheme colorScheme}.
     *
     * Defines the background color of the desired image.
     *
     *  Available options are:
     * 	 - `Accent1`
     * 	 - `Accent2`
     * 	 - `Accent3`
     * 	 - `Accent4`
     * 	 - `Accent5`
     * 	 - `Accent6`
     * 	 - `Accent7`
     * 	 - `Accent8`
     * 	 - `Accent9`
     * 	 - `Accent10`
     * 	 - `Placeholder`
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Accent6`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColorScheme(
      /**
       * New value for property `colorScheme`
       */
      sColorScheme?: AvatarColorScheme | keyof typeof AvatarColorScheme
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getFallbackIcon fallbackIcon}.
     *
     * Defines the name of the fallback icon, which should be displayed in the following cases:
     * 	 - If the initials are not valid (more than 3 letters, unsupported languages or empty initials).
     * 	 - If there are three initials and they do not fit in the shape (e.g. WWW for some of the sizes).
     * 	 - If the image src is wrong.
     *
     *
     *  **Note:** If not set, a default fallback icon "employee" is displayed.
     *  **Note:** You should import the desired icon first, then use its name as "fallback-icon".
     *
     *  import "@ui5/webcomponents-icons/dist/{icon_name}.js"
     *
     * ```javascript
     * <ui5-avatar fallback-icon="alert">```
     *
     *
     *
     * See all the available icons in the {@link demo:sap/m/demokit/iconExplorer/webapp/index.html Icon Explorer}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFallbackIcon(
      /**
       * New value for property `fallbackIcon`
       */
      sFallbackIcon?: string
    ): this;
    /**
     * Sets a new value for property {@link #getIcon icon}.
     *
     * Defines the name of the UI5 Icon, that will be displayed.
     *  **Note:** If `image` slot is provided, the property will be ignored.
     *  **Note:** You should import the desired icon first, then use its name as "icon".
     *
     *  import "@ui5/webcomponents-icons/dist/{icon_name}.js"
     *
     * ```javascript
     * <ui5-avatar icon="employee">```
     *
     *  **Note:** If no icon or an empty one is provided, by default the "employee" icon should be displayed.
     *
     * See all the available icons in the {@link demo:sap/m/demokit/iconExplorer/webapp/index.html Icon Explorer}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIcon(
      /**
       * New value for property `icon`
       */
      sIcon?: string
    ): this;
    /**
     * Sets the aggregated {@link #getImage image}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setImage(
      /**
       * The image to set
       */
      oImage: Control
    ): this;
    /**
     * Sets a new value for property {@link #getInitials initials}.
     *
     * Defines the displayed initials.
     *  Up to three Latin letters can be displayed as initials.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInitials(
      /**
       * New value for property `initials`
       */
      sInitials?: string
    ): this;
    /**
     * Sets a new value for property {@link #getInteractive interactive}.
     *
     * Defines if the avatar is interactive (focusable and pressable). **Note:** This property won't have effect
     * if the `disabled` property is set to `true`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInteractive(
      /**
       * New value for property `interactive`
       */
      bInteractive?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShape shape}.
     *
     * Defines the shape of the component.
     *
     *  Available options are:
     * 	 - `Circle`
     * 	 - `Square`
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Circle`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShape(
      /**
       * New value for property `shape`
       */
      sShape?: AvatarShape | keyof typeof AvatarShape
    ): this;
    /**
     * Sets a new value for property {@link #getSize size}.
     *
     * Defines predefined size of the component.
     *
     *  Available options are:
     * 	 - `XS`
     * 	 - `S`
     * 	 - `M`
     * 	 - `L`
     * 	 - `XL`
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `S`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSize(
      /**
       * New value for property `size`
       */
      sSize?: AvatarSize | keyof typeof AvatarSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Avatar constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $AvatarSettings extends $WebComponentSettings {
    /**
     * Defines the text alternative of the component. If not provided a default text alternative will be set,
     * if present.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * Defines the background color of the desired image.
     *
     *  Available options are:
     * 	 - `Accent1`
     * 	 - `Accent2`
     * 	 - `Accent3`
     * 	 - `Accent4`
     * 	 - `Accent5`
     * 	 - `Accent6`
     * 	 - `Accent7`
     * 	 - `Accent8`
     * 	 - `Accent9`
     * 	 - `Accent10`
     * 	 - `Placeholder`
     */
    colorScheme?:
      | (AvatarColorScheme | keyof typeof AvatarColorScheme)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the name of the fallback icon, which should be displayed in the following cases:
     * 	 - If the initials are not valid (more than 3 letters, unsupported languages or empty initials).
     * 	 - If there are three initials and they do not fit in the shape (e.g. WWW for some of the sizes).
     * 	 - If the image src is wrong.
     *
     *
     *  **Note:** If not set, a default fallback icon "employee" is displayed.
     *  **Note:** You should import the desired icon first, then use its name as "fallback-icon".
     *
     *  import "@ui5/webcomponents-icons/dist/{icon_name}.js"
     *
     * ```javascript
     * <ui5-avatar fallback-icon="alert">```
     *
     *
     *
     * See all the available icons in the {@link demo:sap/m/demokit/iconExplorer/webapp/index.html Icon Explorer}.
     */
    fallbackIcon?: string | PropertyBindingInfo;

    /**
     * Defines the name of the UI5 Icon, that will be displayed.
     *  **Note:** If `image` slot is provided, the property will be ignored.
     *  **Note:** You should import the desired icon first, then use its name as "icon".
     *
     *  import "@ui5/webcomponents-icons/dist/{icon_name}.js"
     *
     * ```javascript
     * <ui5-avatar icon="employee">```
     *
     *  **Note:** If no icon or an empty one is provided, by default the "employee" icon should be displayed.
     *
     * See all the available icons in the {@link demo:sap/m/demokit/iconExplorer/webapp/index.html Icon Explorer}.
     */
    icon?: string | PropertyBindingInfo;

    /**
     * Defines the displayed initials.
     *  Up to three Latin letters can be displayed as initials.
     */
    initials?: string | PropertyBindingInfo;

    /**
     * Defines if the avatar is interactive (focusable and pressable). **Note:** This property won't have effect
     * if the `disabled` property is set to `true`.
     */
    interactive?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the shape of the component.
     *
     *  Available options are:
     * 	 - `Circle`
     * 	 - `Square`
     */
    shape?:
      | (AvatarShape | keyof typeof AvatarShape)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines predefined size of the component.
     *
     *  Available options are:
     * 	 - `XS`
     * 	 - `S`
     * 	 - `M`
     * 	 - `L`
     * 	 - `XL`
     */
    size?:
      | (AvatarSize | keyof typeof AvatarSize)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the optional badge that will be used for visual affordance. **Note:** While the slot allows for
     * custom badges, to achieve the Fiori design, please use `sap.ui.webc.main.Badge` with `sap.ui.webc.main.Icon`
     * in the corresponding `icon` slot, without text nodes.
     *
     *  Example:
     *
     *  <ui5-avatar>
     *  <ui5-badge slot="badge">
     *  <ui5-icon slot="icon" name="employee"></ui5-icon>
     *  </ui5-badge>
     *  </ui5-avatar>
     */
    badge?: Control;

    /**
     * Receives the desired `<img>` tag
     *
     * **Note:** If you experience flickering of the provided image, you can hide the component until it is
     * being defined with the following CSS:   ` ui5-avatar:not(:defined) {  visibility: hidden;
     *  }  `
     */
    image?: Control;

    /**
     * Fired when the user clicks the control
     */
    click?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Avatar#click event.
   */
  export interface Avatar$ClickEventParameters {}

  /**
   * Event object of the Avatar#click event.
   */
  export type Avatar$ClickEvent = Event<Avatar$ClickEventParameters, Avatar>;
}

declare module "sap/ui/webc/main/AvatarGroup" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IAvatar, AvatarGroupType } from "sap/ui/webc/main/library";

  import Event from "sap/ui/base/Event";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import Control from "sap/ui/core/Control";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * Displays a group of avatars arranged horizontally. It is useful to visually showcase a group of related
   * avatars, such as, project team members or employees.
   *
   * The component allows you to display the avatars in different sizes, depending on your use case.
   *
   * The `AvatarGroup` component has two group types:
   * 	 - `Group` type: The avatars are displayed as partially overlapped on top of each other and the entire
   *     group has one click/tap area.
   * 	 - `Individual` type: The avatars are displayed side-by-side and each avatar has its own click/tap area.
   *
   *
   * Responsive Behavior:
   *
   * When the available space is less than the width required to display all avatars, an overflow visualization
   * appears as a button placed at the end with the same shape and size as the avatars. The visualization
   * displays the number of avatars that have overflowed and are not currently visible.
   *
   * Usage:
   *
   * Use the `AvatarGroup` if:
   * 	 - You want to display a group of avatars.
   * 	 - You want to display several avatars which have something in common.
   *
   * Do not use the `AvatarGroup` if:
   * 	 - You want to display a single avatar.
   * 	 - You want to display a gallery for simple images.
   * 	 - You want to use it for other visual content than avatars.
   *
   * Keyboard Handling: The component provides advanced keyboard handling. When focused, the user can use
   * the following keyboard shortcuts in order to perform a navigation:
   *
   *
   *  `type` Individual:
   *
   *
   *
   * 	 - [TAB] - Move focus to the overflow button
   * 	 - [LEFT] - Navigate one avatar to the left
   * 	 - [RIGHT] - Navigate one avatar to the right
   * 	 - [HOME] - Navigate to the first avatar
   * 	 - [END] - Navigate to the last avatar
   * 	 - [SPACE],[ENTER],[RETURN] - Trigger `ui5-click` event
   *  `type` Group:
   *
   *
   *
   * 	 - [TAB] - Move focus to the next interactive element after the component
   * 	 - [SPACE],[ENTER],[RETURN] - Trigger `ui5-click` event
   *
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class AvatarGroup extends WebComponent {
    /**
     * Constructor for a new `AvatarGroup`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $AvatarGroupSettings
    );
    /**
     * Constructor for a new `AvatarGroup`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $AvatarGroupSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.AvatarGroup with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, AvatarGroup>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.AvatarGroup.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: IAvatar
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.webc.main.AvatarGroup`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.AvatarGroup` itself.
     *
     * Fired when the component is activated either with a click/tap or by using the Enter or Space key.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AvatarGroup$ClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.AvatarGroup` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.webc.main.AvatarGroup`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.AvatarGroup` itself.
     *
     * Fired when the component is activated either with a click/tap or by using the Enter or Space key.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AvatarGroup$ClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.AvatarGroup` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:overflow overflow} event of this `sap.ui.webc.main.AvatarGroup`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.AvatarGroup` itself.
     *
     * Fired when the count of visible `sap.ui.webc.main.Avatar` elements in the component has changed
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachOverflow(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.AvatarGroup` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:overflow overflow} event of this `sap.ui.webc.main.AvatarGroup`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.AvatarGroup` itself.
     *
     * Fired when the count of visible `sap.ui.webc.main.Avatar` elements in the component has changed
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachOverflow(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.AvatarGroup` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Destroys the overflowButton in the aggregation {@link #getOverflowButton overflowButton}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyOverflowButton(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:click click} event of this `sap.ui.webc.main.AvatarGroup`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: AvatarGroup$ClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:overflow overflow} event of this `sap.ui.webc.main.AvatarGroup`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachOverflow(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:click click} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: AvatarGroup$ClickEventParameters
    ): this;
    /**
     * Fires event {@link #event:overflow overflow} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireOverflow(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Returns an array containing the `AvatarColorScheme` values that correspond to the avatars in the component.
     */
    getColorScheme(): void;
    /**
     * Returns an array containing the `ui5-avatar` instances that are currently not displayed due to lack of
     * space.
     */
    getHiddenItems(): void;
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * Defines the items of the component. Use the `sap.ui.webc.main.Avatar` component as an item.
     *
     *  **Note:** The UX guidelines recommends using avatars with "Circle" shape. Moreover, if you use avatars
     * with "Square" shape, there will be visual inconsistency as the built-in overflow action has "Circle"
     * shape.
     */
    getItems(): IAvatar[];
    /**
     * Gets content of aggregation {@link #getOverflowButton overflowButton}.
     *
     * Defines the overflow button of the component. **Note:** We recommend using the `sap.ui.webc.main.Button`
     * component.
     *
     *  **Note:** If this slot is not used, the component will display the built-in overflow button.
     */
    getOverflowButton(): Control;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * Defines the mode of the `AvatarGroup`.
     *
     *  Available options are:
     * 	 - `Group`
     * 	 - `Individual`
     *
     * Default value is `Group`.
     *
     *
     * @returns Value of property `type`
     */
    getType(): AvatarGroupType | keyof typeof AvatarGroupType;
    /**
     * Checks for the provided `sap.ui.webc.main.IAvatar` in the aggregation {@link #getItems items}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: IAvatar
    ): int;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: IAvatar,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): IAvatar[];
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | IAvatar
    ): IAvatar | null;
    /**
     * Sets the aggregated {@link #getOverflowButton overflowButton}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOverflowButton(
      /**
       * The overflowButton to set
       */
      oOverflowButton: Control
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * Defines the mode of the `AvatarGroup`.
     *
     *  Available options are:
     * 	 - `Group`
     * 	 - `Individual`
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Group`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: AvatarGroupType | keyof typeof AvatarGroupType
    ): this;
  }
  /**
   * Describes the settings that can be provided to the AvatarGroup constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $AvatarGroupSettings extends $WebComponentSettings {
    /**
     * Defines the mode of the `AvatarGroup`.
     *
     *  Available options are:
     * 	 - `Group`
     * 	 - `Individual`
     */
    type?:
      | (AvatarGroupType | keyof typeof AvatarGroupType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the items of the component. Use the `sap.ui.webc.main.Avatar` component as an item.
     *
     *  **Note:** The UX guidelines recommends using avatars with "Circle" shape. Moreover, if you use avatars
     * with "Square" shape, there will be visual inconsistency as the built-in overflow action has "Circle"
     * shape.
     */
    items?: IAvatar[] | IAvatar | AggregationBindingInfo | `{${string}}`;

    /**
     * Defines the overflow button of the component. **Note:** We recommend using the `sap.ui.webc.main.Button`
     * component.
     *
     *  **Note:** If this slot is not used, the component will display the built-in overflow button.
     */
    overflowButton?: Control;

    /**
     * Fired when the component is activated either with a click/tap or by using the Enter or Space key.
     */
    click?: (oEvent: AvatarGroup$ClickEvent) => void;

    /**
     * Fired when the count of visible `sap.ui.webc.main.Avatar` elements in the component has changed
     */
    overflow?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the AvatarGroup#click event.
   */
  export interface AvatarGroup$ClickEventParameters {
    /**
     * The DOM ref of the clicked item.
     */
    targetRef?: HTMLElement;

    /**
     * indicates if the overflow button is clicked
     */
    overflowButtonClicked?: boolean;
  }

  /**
   * Event object of the AvatarGroup#click event.
   */
  export type AvatarGroup$ClickEvent = Event<
    AvatarGroup$ClickEventParameters,
    AvatarGroup
  >;

  /**
   * Parameters of the AvatarGroup#overflow event.
   */
  export interface AvatarGroup$OverflowEventParameters {}

  /**
   * Event object of the AvatarGroup#overflow event.
   */
  export type AvatarGroup$OverflowEvent = Event<
    AvatarGroup$OverflowEventParameters,
    AvatarGroup
  >;
}

declare module "sap/ui/webc/main/Badge" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IIcon } from "sap/ui/webc/main/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * The `sap.ui.webc.main.Badge` is a small non-interactive component which contains text information and
   * color chosen from a list of predefined color schemes. It serves the purpose to attract the user attention
   * to some piece of information (state, quantity, condition, etc.).
   *
   * Usage Guidelines:
   * 	 - If the text is longer than the width of the component, it doesn’t wrap, it shows ellipsis.
   * 	 - When truncated, the full text is not visible, therefore, it’s recommended to make more space for
   *     longer texts to be fully displayed.
   * 	 - Colors are not semantic and have no visual representation in High Contrast Black (sap_belize_hcb)
   *     theme.
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class Badge extends WebComponent {
    /**
     * Constructor for a new `Badge`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $BadgeSettings
    );
    /**
     * Constructor for a new `Badge`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $BadgeSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.Badge with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Badge>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.Badge.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some icon to the aggregation {@link #getIcon icon}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addIcon(
      /**
       * The icon to add; if empty, nothing is inserted
       */
      oIcon: IIcon
    ): this;
    /**
     * Destroys all the icon in the aggregation {@link #getIcon icon}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyIcon(): this;
    /**
     * Gets current value of property {@link #getColorScheme colorScheme}.
     *
     * Defines the color scheme of the component. There are 10 predefined schemes. To use one you can set a
     * number from `"1"` to `"10"`. The `colorScheme` `"1"` will be set by default.
     *
     *  **Note:** Color schemes have no visual representation in High Contrast Black (sap_belize_hcb) theme.
     *
     * Default value is `"1"`.
     *
     *
     * @returns Value of property `colorScheme`
     */
    getColorScheme(): string;
    /**
     * Gets content of aggregation {@link #getIcon icon}.
     *
     * Defines the icon to be displayed in the component.
     */
    getIcon(): IIcon[];
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Defines the content of the control
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Checks for the provided `sap.ui.webc.main.IIcon` in the aggregation {@link #getIcon icon}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfIcon(
      /**
       * The icon whose index is looked for
       */
      oIcon: IIcon
    ): int;
    /**
     * Inserts a icon into the aggregation {@link #getIcon icon}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertIcon(
      /**
       * The icon to insert; if empty, nothing is inserted
       */
      oIcon: IIcon,
      /**
       * The `0`-based index the icon should be inserted at; for a negative value of `iIndex`, the icon is inserted
       * at position 0; for a value greater than the current size of the aggregation, the icon is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getIcon icon}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllIcon(): IIcon[];
    /**
     * Removes a icon from the aggregation {@link #getIcon icon}.
     *
     *
     * @returns The removed icon or `null`
     */
    removeIcon(
      /**
       * The icon to remove or its index or id
       */
      vIcon: int | string | IIcon
    ): IIcon | null;
    /**
     * Sets a new value for property {@link #getColorScheme colorScheme}.
     *
     * Defines the color scheme of the component. There are 10 predefined schemes. To use one you can set a
     * number from `"1"` to `"10"`. The `colorScheme` `"1"` will be set by default.
     *
     *  **Note:** Color schemes have no visual representation in High Contrast Black (sap_belize_hcb) theme.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"1"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColorScheme(
      /**
       * New value for property `colorScheme`
       */
      sColorScheme?: string
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Defines the content of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Badge constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $BadgeSettings extends $WebComponentSettings {
    /**
     * Defines the color scheme of the component. There are 10 predefined schemes. To use one you can set a
     * number from `"1"` to `"10"`. The `colorScheme` `"1"` will be set by default.
     *
     *  **Note:** Color schemes have no visual representation in High Contrast Black (sap_belize_hcb) theme.
     */
    colorScheme?: string | PropertyBindingInfo;

    /**
     * Defines the content of the control
     */
    text?: string | PropertyBindingInfo;

    /**
     * Defines the icon to be displayed in the component.
     */
    icon?: IIcon[] | IIcon | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/webc/main/Breadcrumbs" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import {
    IBreadcrumbsItem,
    BreadcrumbsDesign,
    BreadcrumbsSeparatorStyle,
  } from "sap/ui/webc/main/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Overview: Enables users to navigate between items by providing a list of links to previous steps in the
   * user's navigation path. It helps the user to be aware of their location within the application and allows
   * faster navigation.
   *
   *  The last three steps can be accessed as links directly, while the remaining links prior to them are
   * available in a drop-down menu.
   *
   *  You can choose the type of separator to be used from a number of predefined options.
   *
   * Keyboard Handling: The `sap.ui.webc.main.Breadcrumbs` provides advanced keyboard handling.
   *
   *
   *
   * 	 - [F4, ALT+UP, ALT+DOWN, SPACE, ENTER] - If the dropdown arrow is focused - opens/closes the drop-down.
   *
   * 	 - [SPACE, ENTER] - Activates the focused item and triggers the `item-click` event.
   * 	 - [ESC] - Closes the drop-down.
   * 	 - [LEFT] - If the drop-down is closed - navigates one item to the left.
   * 	 - [RIGHT] - If the drop-down is closed - navigates one item to the right.
   * 	 - [UP] - If the drop-down is open - moves focus to the next item.
   * 	 - [DOWN] - If the drop-down is open - moves focus to the previous item.
   * 	 - [HOME] - Navigates to the first item.
   * 	 - [END] - Navigates to the last item.
   *
   *
   * @since 1.95.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.95.0) - This control is experimental and its API might change significantly.
   */
  export default class Breadcrumbs extends WebComponent {
    /**
     * Constructor for a new `Breadcrumbs`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $BreadcrumbsSettings
    );
    /**
     * Constructor for a new `Breadcrumbs`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $BreadcrumbsSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.Breadcrumbs with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Breadcrumbs>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.Breadcrumbs.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: IBreadcrumbsItem
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemClick itemClick} event of this `sap.ui.webc.main.Breadcrumbs`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Breadcrumbs` itself.
     *
     * Fires when a `BreadcrumbsItem` is clicked. **Note:** You can prevent browser location change by calling
     * `event.preventDefault()`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Breadcrumbs$ItemClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Breadcrumbs` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemClick itemClick} event of this `sap.ui.webc.main.Breadcrumbs`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Breadcrumbs` itself.
     *
     * Fires when a `BreadcrumbsItem` is clicked. **Note:** You can prevent browser location change by calling
     * `event.preventDefault()`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Breadcrumbs$ItemClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Breadcrumbs` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:itemClick itemClick} event of this `sap.ui.webc.main.Breadcrumbs`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachItemClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Breadcrumbs$ItemClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:itemClick itemClick} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireItemClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Breadcrumbs$ItemClickEventParameters
    ): boolean;
    /**
     * Gets current value of property {@link #getDesign design}.
     *
     * Defines the visual indication and behavior of the breadcrumbs. Available options are `Standard` (by default)
     * and `NoCurrentPage`.
     *
     *  **Note:** The `Standard` breadcrumbs show the current page as the last item in the trail. The last item
     * contains only plain text and is not a link.
     *
     * Default value is `Standard`.
     *
     *
     * @returns Value of property `design`
     */
    getDesign(): BreadcrumbsDesign | keyof typeof BreadcrumbsDesign;
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * Defines the component items.
     *
     *
     *
     *  **Note:** Use the `sap.ui.webc.main.BreadcrumbsItem` component to define the desired items.
     */
    getItems(): IBreadcrumbsItem[];
    /**
     * Gets current value of property {@link #getSeparatorStyle separatorStyle}.
     *
     * Determines the visual style of the separator between the breadcrumb items.
     *
     *
     *
     *  Available options are:
     * 	 - `Slash`
     * 	 - `BackSlash`
     * 	 - `DoubleBackSlash`
     * 	 - `DoubleGreaterThan`
     * 	 - `DoubleSlash`
     * 	 - `GreaterThan`
     *
     * Default value is `Slash`.
     *
     *
     * @returns Value of property `separatorStyle`
     */
    getSeparatorStyle():
      | BreadcrumbsSeparatorStyle
      | keyof typeof BreadcrumbsSeparatorStyle;
    /**
     * Checks for the provided `sap.ui.webc.main.IBreadcrumbsItem` in the aggregation {@link #getItems items}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: IBreadcrumbsItem
    ): int;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: IBreadcrumbsItem,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): IBreadcrumbsItem[];
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | IBreadcrumbsItem
    ): IBreadcrumbsItem | null;
    /**
     * Sets a new value for property {@link #getDesign design}.
     *
     * Defines the visual indication and behavior of the breadcrumbs. Available options are `Standard` (by default)
     * and `NoCurrentPage`.
     *
     *  **Note:** The `Standard` breadcrumbs show the current page as the last item in the trail. The last item
     * contains only plain text and is not a link.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Standard`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDesign(
      /**
       * New value for property `design`
       */
      sDesign?: BreadcrumbsDesign | keyof typeof BreadcrumbsDesign
    ): this;
    /**
     * Sets a new value for property {@link #getSeparatorStyle separatorStyle}.
     *
     * Determines the visual style of the separator between the breadcrumb items.
     *
     *
     *
     *  Available options are:
     * 	 - `Slash`
     * 	 - `BackSlash`
     * 	 - `DoubleBackSlash`
     * 	 - `DoubleGreaterThan`
     * 	 - `DoubleSlash`
     * 	 - `GreaterThan`
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Slash`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSeparatorStyle(
      /**
       * New value for property `separatorStyle`
       */
      sSeparatorStyle?:
        | BreadcrumbsSeparatorStyle
        | keyof typeof BreadcrumbsSeparatorStyle
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Breadcrumbs constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.95.0) - This control is experimental and its API might change significantly.
   */
  export interface $BreadcrumbsSettings extends $WebComponentSettings {
    /**
     * Defines the visual indication and behavior of the breadcrumbs. Available options are `Standard` (by default)
     * and `NoCurrentPage`.
     *
     *  **Note:** The `Standard` breadcrumbs show the current page as the last item in the trail. The last item
     * contains only plain text and is not a link.
     */
    design?:
      | (BreadcrumbsDesign | keyof typeof BreadcrumbsDesign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Determines the visual style of the separator between the breadcrumb items.
     *
     *
     *
     *  Available options are:
     * 	 - `Slash`
     * 	 - `BackSlash`
     * 	 - `DoubleBackSlash`
     * 	 - `DoubleGreaterThan`
     * 	 - `DoubleSlash`
     * 	 - `GreaterThan`
     */
    separatorStyle?:
      | (BreadcrumbsSeparatorStyle | keyof typeof BreadcrumbsSeparatorStyle)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the component items.
     *
     *
     *
     *  **Note:** Use the `sap.ui.webc.main.BreadcrumbsItem` component to define the desired items.
     */
    items?:
      | IBreadcrumbsItem[]
      | IBreadcrumbsItem
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Fires when a `BreadcrumbsItem` is clicked. **Note:** You can prevent browser location change by calling
     * `event.preventDefault()`.
     */
    itemClick?: (oEvent: Breadcrumbs$ItemClickEvent) => void;
  }

  /**
   * Parameters of the Breadcrumbs#itemClick event.
   */
  export interface Breadcrumbs$ItemClickEventParameters {
    /**
     * The clicked item.
     */
    item?: HTMLElement;

    /**
     * Returns whether the "ALT" key was pressed when the event was triggered.
     */
    altKey?: boolean;

    /**
     * Returns whether the "CTRL" key was pressed when the event was triggered.
     */
    ctrlKey?: boolean;

    /**
     * Returns whether the "META" key was pressed when the event was triggered.
     */
    metaKey?: boolean;

    /**
     * Returns whether the "SHIFT" key was pressed when the event was triggered.
     */
    shiftKey?: boolean;
  }

  /**
   * Event object of the Breadcrumbs#itemClick event.
   */
  export type Breadcrumbs$ItemClickEvent = Event<
    Breadcrumbs$ItemClickEventParameters,
    Breadcrumbs
  >;
}

declare module "sap/ui/webc/main/BreadcrumbsItem" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IBreadcrumbsItem } from "sap/ui/webc/main/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * The `sap.ui.webc.main.BreadcrumbsItem` component defines the content of an item in `sap.ui.webc.main.Breadcrumbs`.
   *
   * @since 1.95.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.95.0) - This control is experimental and its API might change significantly.
   */
  export default class BreadcrumbsItem
    extends WebComponent
    implements IBreadcrumbsItem {
    __implements__sap_ui_webc_main_IBreadcrumbsItem: boolean;
    /**
     * Constructor for a new `BreadcrumbsItem`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $BreadcrumbsItemSettings
    );
    /**
     * Constructor for a new `BreadcrumbsItem`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $BreadcrumbsItemSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.BreadcrumbsItem with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, BreadcrumbsItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.BreadcrumbsItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the item.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Gets current value of property {@link #getHref href}.
     *
     * Defines the link href.
     *
     *  **Note:** Standard hyperlink behavior is supported.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `href`
     */
    getHref(): string;
    /**
     * Gets current value of property {@link #getTarget target}.
     *
     * Defines the link target.
     *
     *  Available options are:
     * 	 - `_self`
     * 	 - `_top`
     * 	 - `_blank`
     * 	 - `_parent`
     * 	 - `_search`
     *
     *  Note: This property must only be used when the `href` property is set.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Value of property `target`
     */
    getTarget(): string;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Defines the content of the control
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the item.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHref href}.
     *
     * Defines the link href.
     *
     *  **Note:** Standard hyperlink behavior is supported.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHref(
      /**
       * New value for property `href`
       */
      sHref?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTarget target}.
     *
     * Defines the link target.
     *
     *  Available options are:
     * 	 - `_self`
     * 	 - `_top`
     * 	 - `_blank`
     * 	 - `_parent`
     * 	 - `_search`
     *
     *  Note: This property must only be used when the `href` property is set.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTarget(
      /**
       * New value for property `target`
       */
      sTarget?: string
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Defines the content of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the BreadcrumbsItem constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.95.0) - This control is experimental and its API might change significantly.
   */
  export interface $BreadcrumbsItemSettings extends $WebComponentSettings {
    /**
     * Defines the accessible ARIA name of the item.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * Defines the link href.
     *
     *  **Note:** Standard hyperlink behavior is supported.
     */
    href?: string | PropertyBindingInfo;

    /**
     * Defines the link target.
     *
     *  Available options are:
     * 	 - `_self`
     * 	 - `_top`
     * 	 - `_blank`
     * 	 - `_parent`
     * 	 - `_search`
     *
     *  Note: This property must only be used when the `href` property is set.
     */
    target?: string | PropertyBindingInfo;

    /**
     * Defines the content of the control
     */
    text?: string | PropertyBindingInfo;
  }
}

declare module "sap/ui/webc/main/BusyIndicator" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import Control from "sap/ui/core/Control";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { BusyIndicatorSize } from "sap/ui/webc/main/library";

  import { CSSSize } from "sap/ui/core/library";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * The `sap.ui.webc.main.BusyIndicator` signals that some operation is going on and that the user must wait.
   * It does not block the current UI screen so other operations could be triggered in parallel. It displays
   * 3 dots and each dot expands and shrinks at a different rate, resulting in a cascading flow of animation.
   *
   * Usage: For the `sap.ui.webc.main.BusyIndicator` you can define the size, the text and whether it is shown
   * or hidden. In order to hide it, use the "active" property.
   *
   *  In order to show busy state over an HTML element, simply nest the HTML element in a `sap.ui.webc.main.BusyIndicator`
   * instance.
   *  **Note:** Since `sap.ui.webc.main.BusyIndicator` has `display: inline-block;` by default and no width
   * of its own, whenever you need to wrap a block-level element, you should set `display: block` to the busy
   * indicator as well.
   *
   * When to use::
   * 	 - The user needs to be able to cancel the operation.
   * 	 - Only part of the application or a particular component is affected.
   *
   * When not to use::
   * 	 - The operation takes less than one second.
   * 	 - You need to block the screen and prevent the user from starting another activity.
   * 	 - Do not show multiple busy indicators at once.
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class BusyIndicator extends WebComponent {
    /**
     * Constructor for a new `BusyIndicator`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $BusyIndicatorSettings
    );
    /**
     * Constructor for a new `BusyIndicator`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $BusyIndicatorSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.BusyIndicator with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, BusyIndicator>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.BusyIndicator.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some content to the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted
       */
      oContent: Control
    ): this;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Gets current value of property {@link #getActive active}.
     *
     * Defines if the busy indicator is visible on the screen. By default it is not.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `active`
     */
    getActive(): boolean;
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * Determines the content over which the component will appear.
     */
    getContent(): Control[];
    /**
     * Gets current value of property {@link #getDelay delay}.
     *
     * Defines the delay in milliseconds, after which the busy indicator will be visible on the screen.
     *
     * Default value is `1000`.
     *
     *
     * @returns Value of property `delay`
     */
    getDelay(): int;
    /**
     * Gets current value of property {@link #getDisplay display}.
     *
     * Defines whether the control will be rendered as a block or inline HTML element
     *
     * Default value is `"inline-block"`.
     *
     *
     * @returns Value of property `display`
     */
    getDisplay(): string;
    /**
     * Gets current value of property {@link #getSize size}.
     *
     * Defines the size of the component.
     *
     * Default value is `Medium`.
     *
     *
     * @returns Value of property `size`
     */
    getSize(): BusyIndicatorSize | keyof typeof BusyIndicatorSize;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Defines text to be displayed below the component. It can be used to inform the user of the current operation.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContent content}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: Control
    ): int;
    /**
     * Inserts a content into the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: Control,
      /**
       * The `0`-based index the content should be inserted at; for a negative value of `iIndex`, the content
       * is inserted at position 0; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): Control[];
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | Control
    ): Control | null;
    /**
     * Sets a new value for property {@link #getActive active}.
     *
     * Defines if the busy indicator is visible on the screen. By default it is not.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setActive(
      /**
       * New value for property `active`
       */
      bActive?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getDelay delay}.
     *
     * Defines the delay in milliseconds, after which the busy indicator will be visible on the screen.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1000`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDelay(
      /**
       * New value for property `delay`
       */
      iDelay?: int
    ): this;
    /**
     * Sets a new value for property {@link #getDisplay display}.
     *
     * Defines whether the control will be rendered as a block or inline HTML element
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"inline-block"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplay(
      /**
       * New value for property `display`
       */
      sDisplay?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSize size}.
     *
     * Defines the size of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Medium`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSize(
      /**
       * New value for property `size`
       */
      sSize?: BusyIndicatorSize | keyof typeof BusyIndicatorSize
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Defines text to be displayed below the component. It can be used to inform the user of the current operation.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the BusyIndicator constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $BusyIndicatorSettings extends $WebComponentSettings {
    /**
     * Defines if the busy indicator is visible on the screen. By default it is not.
     */
    active?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the delay in milliseconds, after which the busy indicator will be visible on the screen.
     */
    delay?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the control will be rendered as a block or inline HTML element
     */
    display?: string | PropertyBindingInfo;

    /**
     * Defines the size of the component.
     */
    size?:
      | (BusyIndicatorSize | keyof typeof BusyIndicatorSize)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines text to be displayed below the component. It can be used to inform the user of the current operation.
     */
    text?: string | PropertyBindingInfo;

    /**
     * Defines the width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines the content over which the component will appear.
     */
    content?: Control[] | Control | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/webc/main/Button" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IButton, ButtonDesign, ButtonType } from "sap/ui/webc/main/library";

  import {
    IFormContent,
    ID,
    TextDirection,
    CSSSize,
  } from "sap/ui/core/library";

  import Control from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * The `sap.ui.webc.main.Button` component represents a simple push button. It enables users to trigger
   * actions by clicking or tapping the `sap.ui.webc.main.Button`, or by pressing certain keyboard keys, such
   * as Enter.
   *
   * Usage:
   *
   * For the `sap.ui.webc.main.Button` UI, you can define text, icon, or both. You can also specify whether
   * the text or the icon is displayed first.
   *
   *  You can choose from a set of predefined types that offer different styling to correspond to the triggered
   * action.
   *
   *  You can set the `sap.ui.webc.main.Button` as enabled or disabled. An enabled `sap.ui.webc.main.Button`
   * can be pressed by clicking or tapping it. The button changes its style to provide visual feedback to
   * the user that it is pressed or hovered over with the mouse cursor. A disabled `sap.ui.webc.main.Button`
   * appears inactive and cannot be pressed.
   *
   * CSS Shadow Parts:
   *
   * {@link https://developer.mozilla.org/en-US/docs/Web/CSS/::part CSS Shadow Parts} allow developers to
   * style elements inside the Shadow DOM.
   *  The `sap.ui.webc.main.Button` exposes the following CSS Shadow Parts:
   * 	 - button - Used to style the native button element
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class Button
    extends WebComponent
    implements IButton, IFormContent {
    __implements__sap_ui_webc_main_IButton: boolean;
    __implements__sap_ui_core_IFormContent: boolean;
    /**
     * Constructor for a new `Button`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ButtonSettings
    );
    /**
     * Constructor for a new `Button`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ButtonSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.Button with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Button>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.Button.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.webc.main.Button`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Button` itself.
     *
     * Fired when the component is activated either with a mouse/tap or by using the Enter or Space key.
     *
     *  **Note:** The event will not be fired if the `disabled` property is set to `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Button` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.webc.main.Button`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Button` itself.
     *
     * Fired when the component is activated either with a mouse/tap or by using the Enter or Space key.
     *
     *  **Note:** The event will not be fired if the `disabled` property is set to `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Button` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:click click} event of this `sap.ui.webc.main.Button`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:click click} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getAccessibilityAttributes accessibilityAttributes}.
     *
     * An object of strings that defines several additional accessibility attribute values for customization
     * depending on the use case.
     *
     * It supports the following fields:
     *
     *
     * 	 - `expanded`: Indicates whether the button, or another grouping element it controls, is currently expanded
     *     or collapsed. Accepts the following string values:
     * 	`true`
     * 	 - `false`
     * 	 - `hasPopup`: Indicates the availability and type of interactive popup element, such as menu or dialog,
     *     that can be triggered by the button. Accepts the following string values:
     * 	`Dialog`
     * 	 - `Grid`
     * 	 - `ListBox`
     * 	 - `Menu`
     * 	 - `Tree`
     * 	 - `controls`: Identifies the element (or elements) whose contents or presence are controlled by the
     *     button element. Accepts a string value.
     *
     * Default value is `{}`.
     *
     *
     * @returns Value of property `accessibilityAttributes`
     */
    getAccessibilityAttributes(): object;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getDesign design}.
     *
     * Defines the component design.
     *
     * Default value is `Default`.
     *
     *
     * @returns Value of property `design`
     */
    getDesign(): ButtonDesign | keyof typeof ButtonDesign;
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getIcon icon}.
     *
     * Defines the icon, displayed as graphical element within the component. The SAP-icons font provides numerous
     * options.
     *
     *  Example:
     *
     * See all the available icons within the {@link demo:sap/m/demokit/iconExplorer/webapp/index.html Icon Explorer}.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `icon`
     */
    getIcon(): string;
    /**
     * Gets current value of property {@link #getIconEnd iconEnd}.
     *
     * Defines whether the icon should be displayed after the component text.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `iconEnd`
     */
    getIconEnd(): boolean;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Defines the content of the control
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets current value of property {@link #getTextDirection textDirection}.
     *
     * Specifies the element's text directionality with enumerated options. By default, the control inherits
     * text direction from the DOM.
     *
     * Default value is `Inherit`.
     *
     *
     * @returns Value of property `textDirection`
     */
    getTextDirection(): TextDirection | keyof typeof TextDirection;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * Defines whether the button has special form-related functionality.
     *
     * Default value is `Button`.
     *
     *
     * @returns Value of property `type`
     */
    getType(): ButtonType | keyof typeof ButtonType;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Sets a new value for property {@link #getAccessibilityAttributes accessibilityAttributes}.
     *
     * An object of strings that defines several additional accessibility attribute values for customization
     * depending on the use case.
     *
     * It supports the following fields:
     *
     *
     * 	 - `expanded`: Indicates whether the button, or another grouping element it controls, is currently expanded
     *     or collapsed. Accepts the following string values:
     * 	`true`
     * 	 - `false`
     * 	 - `hasPopup`: Indicates the availability and type of interactive popup element, such as menu or dialog,
     *     that can be triggered by the button. Accepts the following string values:
     * 	`Dialog`
     * 	 - `Grid`
     * 	 - `ListBox`
     * 	 - `Menu`
     * 	 - `Tree`
     * 	 - `controls`: Identifies the element (or elements) whose contents or presence are controlled by the
     *     button element. Accepts a string value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `{}`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibilityAttributes(
      /**
       * New value for property `accessibilityAttributes`
       */
      oAccessibilityAttributes?: object
    ): this;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDesign design}.
     *
     * Defines the component design.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Default`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDesign(
      /**
       * New value for property `design`
       */
      sDesign?: ButtonDesign | keyof typeof ButtonDesign
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIcon icon}.
     *
     * Defines the icon, displayed as graphical element within the component. The SAP-icons font provides numerous
     * options.
     *
     *  Example:
     *
     * See all the available icons within the {@link demo:sap/m/demokit/iconExplorer/webapp/index.html Icon Explorer}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIcon(
      /**
       * New value for property `icon`
       */
      sIcon?: string
    ): this;
    /**
     * Sets a new value for property {@link #getIconEnd iconEnd}.
     *
     * Defines whether the icon should be displayed after the component text.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIconEnd(
      /**
       * New value for property `iconEnd`
       */
      bIconEnd?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Defines the content of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTextDirection textDirection}.
     *
     * Specifies the element's text directionality with enumerated options. By default, the control inherits
     * text direction from the DOM.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Inherit`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextDirection(
      /**
       * New value for property `textDirection`
       */
      sTextDirection?: TextDirection | keyof typeof TextDirection
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * Defines whether the button has special form-related functionality.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Button`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: ButtonType | keyof typeof ButtonType
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Button constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $ButtonSettings extends $WebComponentSettings {
    /**
     * An object of strings that defines several additional accessibility attribute values for customization
     * depending on the use case.
     *
     * It supports the following fields:
     *
     *
     * 	 - `expanded`: Indicates whether the button, or another grouping element it controls, is currently expanded
     *     or collapsed. Accepts the following string values:
     * 	`true`
     * 	 - `false`
     * 	 - `hasPopup`: Indicates the availability and type of interactive popup element, such as menu or dialog,
     *     that can be triggered by the button. Accepts the following string values:
     * 	`Dialog`
     * 	 - `Grid`
     * 	 - `ListBox`
     * 	 - `Menu`
     * 	 - `Tree`
     * 	 - `controls`: Identifies the element (or elements) whose contents or presence are controlled by the
     *     button element. Accepts a string value.
     */
    accessibilityAttributes?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the accessible ARIA name of the component.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * Defines the component design.
     */
    design?:
      | (ButtonDesign | keyof typeof ButtonDesign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the icon, displayed as graphical element within the component. The SAP-icons font provides numerous
     * options.
     *
     *  Example:
     *
     * See all the available icons within the {@link demo:sap/m/demokit/iconExplorer/webapp/index.html Icon Explorer}.
     */
    icon?: string | PropertyBindingInfo;

    /**
     * Defines whether the icon should be displayed after the component text.
     */
    iconEnd?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the content of the control
     */
    text?: string | PropertyBindingInfo;

    /**
     * Specifies the element's text directionality with enumerated options. By default, the control inherits
     * text direction from the DOM.
     */
    textDirection?:
      | (TextDirection | keyof typeof TextDirection)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines whether the button has special form-related functionality.
     */
    type?:
      | (ButtonType | keyof typeof ButtonType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Receives id(or many ids) of the controls that label this control.
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Fired when the component is activated either with a mouse/tap or by using the Enter or Space key.
     *
     *  **Note:** The event will not be fired if the `disabled` property is set to `true`.
     */
    click?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Button#click event.
   */
  export interface Button$ClickEventParameters {}

  /**
   * Event object of the Button#click event.
   */
  export type Button$ClickEvent = Event<Button$ClickEventParameters, Button>;
}

declare module "sap/ui/webc/main/Calendar" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import {
    ICalendarDate,
    CalendarSelectionMode,
  } from "sap/ui/webc/main/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import CalendarType from "sap/ui/core/CalendarType";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Overview:
   *
   * The `sap.ui.webc.main.Calendar` component allows users to select one or more dates.
   *
   *  Currently selected dates are represented with instances of `sap.ui.webc.main.CalendarDate` as children
   * of the `sap.ui.webc.main.Calendar`. The value property of each `sap.ui.webc.main.CalendarDate` must be
   * a date string, correctly formatted according to the `sap.ui.webc.main.Calendar`'s `formatPattern` property.
   * Whenever the user changes the date selection, `sap.ui.webc.main.Calendar` will automatically create/remove
   * instances of `sap.ui.webc.main.CalendarDate` in itself, unless you prevent this behavior by calling `preventDefault()`
   * for the `selected-dates-change` event. This is useful if you want to control the selected dates externally.
   *
   *
   *
   *
   * Usage:
   *
   * The user can navigate to a particular date by:
   *
   *
   *
   * 	 - Pressing over a month inside the months view
   * 	 - Pressing over an year inside the years view
   *  The user can confirm a date selection by pressing over a date inside the days view.
   *
   *
   *
   * Keyboard Handling: The `sap.ui.webc.main.Calendar` provides advanced keyboard handling. When a picker
   * is showed and focused the user can use the following keyboard shortcuts in order to perform a navigation:
   *
   *  - Day picker:
   *
   *
   *
   * 	 - [F4] - Shows month picker
   * 	 - [SHIFT] + [F4] - Shows year picker
   * 	 - [PAGEUP] - Navigate to the previous month
   * 	 - [PAGEDOWN] - Navigate to the next month
   * 	 - [SHIFT] + [PAGEUP] - Navigate to the previous year
   * 	 - [SHIFT] + [PAGEDOWN] - Navigate to the next year
   * 	 - [CTRL] + [SHIFT] + [PAGEUP] - Navigate ten years backwards
   * 	 - [CTRL] + [SHIFT] + [PAGEDOWN] - Navigate ten years forwards
   * 	 - [HOME] - Navigate to the first day of the week
   * 	 - [END] - Navigate to the last day of the week
   * 	 - [CTRL] + [HOME] - Navigate to the first day of the month
   * 	 - [CTRL] + [END] - Navigate to the last day of the month
   *  - Month picker:
   *
   *
   *
   * 	 - [PAGEUP] - Navigate to the previous year
   * 	 - [PAGEDOWN] - Navigate to the next year
   * 	 - [HOME] - Navigate to the first month of the current row
   * 	 - [END] - Navigate to the last month of the current row
   * 	 - [CTRL] + [HOME] - Navigate to the first month of the current year
   * 	 - [CTRL] + [END] - Navigate to the last month of the year
   *  - Year picker:
   *
   *
   *
   * 	 - [PAGEUP] - Navigate to the previous year range
   * 	 - [PAGEDOWN] - Navigate the next year range
   * 	 - [HOME] - Navigate to the first year of the current row
   * 	 - [END] - Navigate to the last year of the current row
   * 	 - [CTRL] + [HOME] - Navigate to the first year of the current year range
   * 	 - [CTRL] + [END] - Navigate to the last year of the current year range
   *
   *
   * Calendar types: The component supports several calendar types - Gregorian, Buddhist, Islamic, Japanese
   * and Persian. By default the Gregorian Calendar is used. In order to use the Buddhist, Islamic, Japanese
   * or Persian calendar, you need to set the `primaryCalendarType` property and import one or more of the
   * following modules:
   *
   *
   *
   * Or, you can use the global configuration and set the `calendarType` key:
   *  ` <script data-id="sap-ui-config" type="application/json"> { "calendarType": "Japanese" } </script>
   * `
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class Calendar extends WebComponent {
    /**
     * Constructor for a new `Calendar`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $CalendarSettings
    );
    /**
     * Constructor for a new `Calendar`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $CalendarSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.Calendar with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Calendar>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.Calendar.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some date to the aggregation {@link #getDates dates}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addDate(
      /**
       * The date to add; if empty, nothing is inserted
       */
      oDate: ICalendarDate
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectedDatesChange selectedDatesChange} event
     * of this `sap.ui.webc.main.Calendar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Calendar` itself.
     *
     * Fired when the selected dates change. **Note:** If you call `preventDefault()` for this event, the component
     * will not create instances of `sap.ui.webc.main.CalendarDate` for the newly selected dates. In that case
     * you should do this manually.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectedDatesChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Calendar$SelectedDatesChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Calendar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectedDatesChange selectedDatesChange} event
     * of this `sap.ui.webc.main.Calendar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Calendar` itself.
     *
     * Fired when the selected dates change. **Note:** If you call `preventDefault()` for this event, the component
     * will not create instances of `sap.ui.webc.main.CalendarDate` for the newly selected dates. In that case
     * you should do this manually.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectedDatesChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Calendar$SelectedDatesChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Calendar` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the dates in the aggregation {@link #getDates dates}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDates(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectedDatesChange selectedDatesChange} event
     * of this `sap.ui.webc.main.Calendar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectedDatesChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Calendar$SelectedDatesChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:selectedDatesChange selectedDatesChange} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireSelectedDatesChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Calendar$SelectedDatesChangeEventParameters
    ): boolean;
    /**
     * Gets content of aggregation {@link #getDates dates}.
     *
     * Defines the selected date or dates (depending on the `selectionMode` property) for this calendar as instances
     * of `sap.ui.webc.main.CalendarDate`.
     */
    getDates(): ICalendarDate[];
    /**
     * Gets current value of property {@link #getFormatPattern formatPattern}.
     *
     * Determines the format, displayed in the input field.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `formatPattern`
     */
    getFormatPattern(): string;
    /**
     * Gets current value of property {@link #getHideWeekNumbers hideWeekNumbers}.
     *
     * Defines the visibility of the week numbers column.
     *
     *
     *
     * **Note:** For calendars other than Gregorian, the week numbers are not displayed regardless of what is
     * set.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `hideWeekNumbers`
     */
    getHideWeekNumbers(): boolean;
    /**
     * Gets current value of property {@link #getMaxDate maxDate}.
     *
     * Determines the maximum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the maxDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `maxDate`
     */
    getMaxDate(): string;
    /**
     * Gets current value of property {@link #getMinDate minDate}.
     *
     * Determines the minimum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the minDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `minDate`
     */
    getMinDate(): string;
    /**
     * Gets current value of property {@link #getPrimaryCalendarType primaryCalendarType}.
     *
     * Sets a calendar type used for display. If not set, the calendar type of the global configuration is used.
     *
     *
     * @returns Value of property `primaryCalendarType`
     */
    getPrimaryCalendarType(): CalendarType;
    /**
     * Gets current value of property {@link #getSecondaryCalendarType secondaryCalendarType}.
     *
     * Defines the secondary calendar type. If not set, the calendar will only show the primary calendar type.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Value of property `secondaryCalendarType`
     */
    getSecondaryCalendarType(): CalendarType;
    /**
     * Gets current value of property {@link #getSelectionMode selectionMode}.
     *
     * Defines the type of selection used in the calendar component. Accepted property values are:
     *
     *
     *
     * 	 - `CalendarSelectionMode.Single` - enables a single date selection.(default value)
     * 	 - `CalendarSelectionMode.Range` - enables selection of a date range.
     * 	 - `CalendarSelectionMode.Multiple` - enables selection of multiple dates.
     *
     * Default value is `Single`.
     *
     *
     * @returns Value of property `selectionMode`
     */
    getSelectionMode():
      | CalendarSelectionMode
      | keyof typeof CalendarSelectionMode;
    /**
     * Checks for the provided `sap.ui.webc.main.ICalendarDate` in the aggregation {@link #getDates dates}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfDate(
      /**
       * The date whose index is looked for
       */
      oDate: ICalendarDate
    ): int;
    /**
     * Inserts a date into the aggregation {@link #getDates dates}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertDate(
      /**
       * The date to insert; if empty, nothing is inserted
       */
      oDate: ICalendarDate,
      /**
       * The `0`-based index the date should be inserted at; for a negative value of `iIndex`, the date is inserted
       * at position 0; for a value greater than the current size of the aggregation, the date is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getDates dates}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllDates(): ICalendarDate[];
    /**
     * Removes a date from the aggregation {@link #getDates dates}.
     *
     *
     * @returns The removed date or `null`
     */
    removeDate(
      /**
       * The date to remove or its index or id
       */
      vDate: int | string | ICalendarDate
    ): ICalendarDate | null;
    /**
     * Sets a new value for property {@link #getFormatPattern formatPattern}.
     *
     * Determines the format, displayed in the input field.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFormatPattern(
      /**
       * New value for property `formatPattern`
       */
      sFormatPattern?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHideWeekNumbers hideWeekNumbers}.
     *
     * Defines the visibility of the week numbers column.
     *
     *
     *
     * **Note:** For calendars other than Gregorian, the week numbers are not displayed regardless of what is
     * set.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideWeekNumbers(
      /**
       * New value for property `hideWeekNumbers`
       */
      bHideWeekNumbers?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getMaxDate maxDate}.
     *
     * Determines the maximum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the maxDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxDate(
      /**
       * New value for property `maxDate`
       */
      sMaxDate?: string
    ): this;
    /**
     * Sets a new value for property {@link #getMinDate minDate}.
     *
     * Determines the minimum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the minDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMinDate(
      /**
       * New value for property `minDate`
       */
      sMinDate?: string
    ): this;
    /**
     * Sets a new value for property {@link #getPrimaryCalendarType primaryCalendarType}.
     *
     * Sets a calendar type used for display. If not set, the calendar type of the global configuration is used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPrimaryCalendarType(
      /**
       * New value for property `primaryCalendarType`
       */
      sPrimaryCalendarType: CalendarType
    ): this;
    /**
     * Sets a new value for property {@link #getSecondaryCalendarType secondaryCalendarType}.
     *
     * Defines the secondary calendar type. If not set, the calendar will only show the primary calendar type.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSecondaryCalendarType(
      /**
       * New value for property `secondaryCalendarType`
       */
      sSecondaryCalendarType?: CalendarType
    ): this;
    /**
     * Sets a new value for property {@link #getSelectionMode selectionMode}.
     *
     * Defines the type of selection used in the calendar component. Accepted property values are:
     *
     *
     *
     * 	 - `CalendarSelectionMode.Single` - enables a single date selection.(default value)
     * 	 - `CalendarSelectionMode.Range` - enables selection of a date range.
     * 	 - `CalendarSelectionMode.Multiple` - enables selection of multiple dates.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Single`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelectionMode(
      /**
       * New value for property `selectionMode`
       */
      sSelectionMode?:
        | CalendarSelectionMode
        | keyof typeof CalendarSelectionMode
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Calendar constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $CalendarSettings extends $WebComponentSettings {
    /**
     * Determines the format, displayed in the input field.
     */
    formatPattern?: string | PropertyBindingInfo;

    /**
     * Defines the visibility of the week numbers column.
     *
     *
     *
     * **Note:** For calendars other than Gregorian, the week numbers are not displayed regardless of what is
     * set.
     */
    hideWeekNumbers?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines the maximum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the maxDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     */
    maxDate?: string | PropertyBindingInfo;

    /**
     * Determines the minimum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the minDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     */
    minDate?: string | PropertyBindingInfo;

    /**
     * Sets a calendar type used for display. If not set, the calendar type of the global configuration is used.
     */
    primaryCalendarType?: CalendarType | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the secondary calendar type. If not set, the calendar will only show the primary calendar type.
     */
    secondaryCalendarType?: CalendarType | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the type of selection used in the calendar component. Accepted property values are:
     *
     *
     *
     * 	 - `CalendarSelectionMode.Single` - enables a single date selection.(default value)
     * 	 - `CalendarSelectionMode.Range` - enables selection of a date range.
     * 	 - `CalendarSelectionMode.Multiple` - enables selection of multiple dates.
     */
    selectionMode?:
      | (CalendarSelectionMode | keyof typeof CalendarSelectionMode)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the selected date or dates (depending on the `selectionMode` property) for this calendar as instances
     * of `sap.ui.webc.main.CalendarDate`.
     */
    dates?:
      | ICalendarDate[]
      | ICalendarDate
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Fired when the selected dates change. **Note:** If you call `preventDefault()` for this event, the component
     * will not create instances of `sap.ui.webc.main.CalendarDate` for the newly selected dates. In that case
     * you should do this manually.
     */
    selectedDatesChange?: (oEvent: Calendar$SelectedDatesChangeEvent) => void;
  }

  /**
   * Parameters of the Calendar#selectedDatesChange event.
   */
  export interface Calendar$SelectedDatesChangeEventParameters {
    /**
     * The selected dates
     */
    values?: any[];

    /**
     * The selected dates as UTC timestamps
     */
    dates?: any[];
  }

  /**
   * Event object of the Calendar#selectedDatesChange event.
   */
  export type Calendar$SelectedDatesChangeEvent = Event<
    Calendar$SelectedDatesChangeEventParameters,
    Calendar
  >;
}

declare module "sap/ui/webc/main/CalendarDate" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { ICalendarDate } from "sap/ui/webc/main/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * The `sap.ui.webc.main.CalendarDate` component defines a calendar date to be used inside `sap.ui.webc.main.Calendar`
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class CalendarDate
    extends WebComponent
    implements ICalendarDate {
    __implements__sap_ui_webc_main_ICalendarDate: boolean;
    /**
     * Constructor for a new `CalendarDate`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $CalendarDateSettings
    );
    /**
     * Constructor for a new `CalendarDate`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $CalendarDateSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.CalendarDate with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, CalendarDate>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.CalendarDate.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * The date formatted according to the `formatPattern` property of the `sap.ui.webc.main.Calendar` that
     * hosts the component.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): string;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * The date formatted according to the `formatPattern` property of the `sap.ui.webc.main.Calendar` that
     * hosts the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      sValue: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the CalendarDate constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $CalendarDateSettings extends $WebComponentSettings {
    /**
     * The date formatted according to the `formatPattern` property of the `sap.ui.webc.main.Calendar` that
     * hosts the component.
     */
    value?: string | PropertyBindingInfo;
  }
}

declare module "sap/ui/webc/main/Card" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { ID, CSSSize } from "sap/ui/core/library";

  import Control from "sap/ui/core/Control";

  import { ICardHeader } from "sap/ui/webc/main/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * The `sap.ui.webc.main.Card` is a component that represents information in the form of a tile with separate
   * header and content areas. The content area of a `sap.ui.webc.main.Card` can be arbitrary HTML content.
   * The header can be used through slot `header`. For which there is a `sap.ui.webc.main.CardHeader` component
   * to achieve the card look and feel.
   *
   * Note: We recommend the usage of `sap.ui.webc.main.CardHeader` for the header slot, so advantage can be
   * taken for keyboard handling, styling and accessibility.
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class Card extends WebComponent {
    /**
     * Constructor for a new `Card`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $CardSettings
    );
    /**
     * Constructor for a new `Card`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $CardSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.Card with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Card>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.Card.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some content to the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted
       */
      oContent: Control
    ): this;
    /**
     * Adds some header to the aggregation {@link #getHeader header}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addHeader(
      /**
       * The header to add; if empty, nothing is inserted
       */
      oHeader: ICardHeader
    ): this;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Destroys all the header in the aggregation {@link #getHeader header}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyHeader(): this;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible name of the component, which is used as the name of the card region and should
     * be unique per card. **Note:** `accessibleName` should be always set, unless `ariaLabelledBy` is set.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * Defines the content of the component.
     */
    getContent(): Control[];
    /**
     * Gets content of aggregation {@link #getHeader header}.
     *
     * Defines the header of the component.
     *
     *  **Note:** Use `sap.ui.webc.main.CardHeader` for the intended design.
     */
    getHeader(): ICardHeader[];
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Defines the height of the control
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContent content}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: Control
    ): int;
    /**
     * Checks for the provided `sap.ui.webc.main.ICardHeader` in the aggregation {@link #getHeader header}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfHeader(
      /**
       * The header whose index is looked for
       */
      oHeader: ICardHeader
    ): int;
    /**
     * Inserts a content into the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: Control,
      /**
       * The `0`-based index the content should be inserted at; for a negative value of `iIndex`, the content
       * is inserted at position 0; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a header into the aggregation {@link #getHeader header}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertHeader(
      /**
       * The header to insert; if empty, nothing is inserted
       */
      oHeader: ICardHeader,
      /**
       * The `0`-based index the header should be inserted at; for a negative value of `iIndex`, the header is
       * inserted at position 0; for a value greater than the current size of the aggregation, the header is inserted
       * at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): Control[];
    /**
     * Removes all the controls from the aggregation {@link #getHeader header}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllHeader(): ICardHeader[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | Control
    ): Control | null;
    /**
     * Removes a header from the aggregation {@link #getHeader header}.
     *
     *
     * @returns The removed header or `null`
     */
    removeHeader(
      /**
       * The header to remove or its index or id
       */
      vHeader: int | string | ICardHeader
    ): ICardHeader | null;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible name of the component, which is used as the name of the card region and should
     * be unique per card. **Note:** `accessibleName` should be always set, unless `ariaLabelledBy` is set.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * Defines the height of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Card constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $CardSettings extends $WebComponentSettings {
    /**
     * Defines the accessible name of the component, which is used as the name of the card region and should
     * be unique per card. **Note:** `accessibleName` should be always set, unless `ariaLabelledBy` is set.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * Defines the height of the control
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the content of the component.
     */
    content?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * Defines the header of the component.
     *
     *  **Note:** Use `sap.ui.webc.main.CardHeader` for the intended design.
     */
    header?:
      | ICardHeader[]
      | ICardHeader
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Receives id(or many ids) of the controls that label this control.
     */
    ariaLabelledBy?: Array<Control | string>;
  }
}

declare module "sap/ui/webc/main/CardHeader" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { ICardHeader } from "sap/ui/webc/main/library";

  import Control from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * The `sap.ui.webc.main.CardHeader` is a component, meant to be used as a header of the `sap.ui.webc.main.Card`
   * component. It displays valuable information, that can be defined with several properties, such as: `titleText`,
   * `subtitleText`, `status` and two slots: `avatar` and `action`.
   *
   * Keyboard handling: In case you enable `interactive` property, you can press the `sap.ui.webc.main.CardHeader`
   * by Space and Enter keys.
   *
   * CSS Shadow Parts:
   *
   * {@link https://developer.mozilla.org/en-US/docs/Web/CSS/::part CSS Shadow Parts} allow developers to
   * style elements inside the Shadow DOM.
   *  The `sap.ui.webc.main.CardHeader` exposes the following CSS Shadow Parts:
   * 	 - root - Used to style the root DOM element of the CardHeader
   * 	 - title - Used to style the title of the CardHeader
   * 	 - subtitle - Used to style the subtitle of the CardHeader
   * 	 - status - Used to style the status of the CardHeader
   *
   * @since 1.95.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.95.0) - This control is experimental and its API might change significantly.
   */
  export default class CardHeader extends WebComponent implements ICardHeader {
    __implements__sap_ui_webc_main_ICardHeader: boolean;
    /**
     * Constructor for a new `CardHeader`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $CardHeaderSettings
    );
    /**
     * Constructor for a new `CardHeader`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $CardHeaderSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.CardHeader with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, CardHeader>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.CardHeader.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some action to the aggregation {@link #getAction action}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAction(
      /**
       * The action to add; if empty, nothing is inserted
       */
      oAction: Control
    ): this;
    /**
     * Adds some avatar to the aggregation {@link #getAvatar avatar}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAvatar(
      /**
       * The avatar to add; if empty, nothing is inserted
       */
      oAvatar: Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.webc.main.CardHeader`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.CardHeader` itself.
     *
     * Fired when the component is activated by mouse/tap or by using the Enter or Space key.
     *
     *  **Note:** The event would be fired only if the `interactive` property is set to true.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.CardHeader` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.webc.main.CardHeader`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.CardHeader` itself.
     *
     * Fired when the component is activated by mouse/tap or by using the Enter or Space key.
     *
     *  **Note:** The event would be fired only if the `interactive` property is set to true.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.CardHeader` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the action in the aggregation {@link #getAction action}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyAction(): this;
    /**
     * Destroys all the avatar in the aggregation {@link #getAvatar avatar}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyAvatar(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:click click} event of this `sap.ui.webc.main.CardHeader`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:click click} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getAction action}.
     *
     * Defines an action, displayed in the right most part of the header.
     */
    getAction(): Control[];
    /**
     * Gets content of aggregation {@link #getAvatar avatar}.
     *
     * Defines an avatar image, displayed in the left most part of the header.
     */
    getAvatar(): Control[];
    /**
     * Gets current value of property {@link #getInteractive interactive}.
     *
     * Defines if the component would be interactive, e.g gets hover effect, gets focus outline and `click`
     * event is fired, when pressed.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `interactive`
     */
    getInteractive(): boolean;
    /**
     * Gets current value of property {@link #getStatus status}.
     *
     * Defines the status text.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `status`
     */
    getStatus(): string;
    /**
     * Gets current value of property {@link #getSubtitleText subtitleText}.
     *
     * Defines the subtitle text.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `subtitleText`
     */
    getSubtitleText(): string;
    /**
     * Gets current value of property {@link #getTitleText titleText}.
     *
     * Defines the title text.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `titleText`
     */
    getTitleText(): string;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getAction action}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfAction(
      /**
       * The action whose index is looked for
       */
      oAction: Control
    ): int;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getAvatar avatar}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfAvatar(
      /**
       * The avatar whose index is looked for
       */
      oAvatar: Control
    ): int;
    /**
     * Inserts a action into the aggregation {@link #getAction action}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertAction(
      /**
       * The action to insert; if empty, nothing is inserted
       */
      oAction: Control,
      /**
       * The `0`-based index the action should be inserted at; for a negative value of `iIndex`, the action is
       * inserted at position 0; for a value greater than the current size of the aggregation, the action is inserted
       * at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a avatar into the aggregation {@link #getAvatar avatar}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertAvatar(
      /**
       * The avatar to insert; if empty, nothing is inserted
       */
      oAvatar: Control,
      /**
       * The `0`-based index the avatar should be inserted at; for a negative value of `iIndex`, the avatar is
       * inserted at position 0; for a value greater than the current size of the aggregation, the avatar is inserted
       * at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes a action from the aggregation {@link #getAction action}.
     *
     *
     * @returns The removed action or `null`
     */
    removeAction(
      /**
       * The action to remove or its index or id
       */
      vAction: int | string | Control
    ): Control | null;
    /**
     * Removes all the controls from the aggregation {@link #getAction action}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAction(): Control[];
    /**
     * Removes all the controls from the aggregation {@link #getAvatar avatar}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAvatar(): Control[];
    /**
     * Removes a avatar from the aggregation {@link #getAvatar avatar}.
     *
     *
     * @returns The removed avatar or `null`
     */
    removeAvatar(
      /**
       * The avatar to remove or its index or id
       */
      vAvatar: int | string | Control
    ): Control | null;
    /**
     * Sets a new value for property {@link #getInteractive interactive}.
     *
     * Defines if the component would be interactive, e.g gets hover effect, gets focus outline and `click`
     * event is fired, when pressed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInteractive(
      /**
       * New value for property `interactive`
       */
      bInteractive?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getStatus status}.
     *
     * Defines the status text.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStatus(
      /**
       * New value for property `status`
       */
      sStatus?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSubtitleText subtitleText}.
     *
     * Defines the subtitle text.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSubtitleText(
      /**
       * New value for property `subtitleText`
       */
      sSubtitleText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTitleText titleText}.
     *
     * Defines the title text.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitleText(
      /**
       * New value for property `titleText`
       */
      sTitleText?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the CardHeader constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.95.0) - This control is experimental and its API might change significantly.
   */
  export interface $CardHeaderSettings extends $WebComponentSettings {
    /**
     * Defines if the component would be interactive, e.g gets hover effect, gets focus outline and `click`
     * event is fired, when pressed.
     */
    interactive?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the status text.
     */
    status?: string | PropertyBindingInfo;

    /**
     * Defines the subtitle text.
     */
    subtitleText?: string | PropertyBindingInfo;

    /**
     * Defines the title text.
     */
    titleText?: string | PropertyBindingInfo;

    /**
     * Defines an action, displayed in the right most part of the header.
     */
    action?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * Defines an avatar image, displayed in the left most part of the header.
     */
    avatar?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * Fired when the component is activated by mouse/tap or by using the Enter or Space key.
     *
     *  **Note:** The event would be fired only if the `interactive` property is set to true.
     */
    click?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the CardHeader#click event.
   */
  export interface CardHeader$ClickEventParameters {}

  /**
   * Event object of the CardHeader#click event.
   */
  export type CardHeader$ClickEvent = Event<
    CardHeader$ClickEventParameters,
    CardHeader
  >;
}

declare module "sap/ui/webc/main/Carousel" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import Control from "sap/ui/core/Control";

  import {
    CarouselArrowsPlacement,
    BackgroundDesign,
    BorderDesign,
    CarouselPageIndicatorStyle,
  } from "sap/ui/webc/main/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Overview: The Carousel allows the user to browse through a set of items. The component is mostly used
   * for showing a gallery of images, but can hold any other HTML element.
   *  There are several ways to perform navigation:
   * 	 - on desktop - the user can navigate using the navigation arrows or with keyboard shorcuts.
   * 	 - on mobile - the user can use swipe gestures.
   *
   * Usage:
   *
   * When to use::
   *
   *
   * 	 - The items you want to display are very different from each other.
   * 	 - You want to display the items one after the other.
   *
   * When not to use::
   *
   *
   * 	 - The items you want to display need to be visible at the same time.
   * 	 - The items you want to display are uniform and very similar.
   *
   * Keyboard Handling:
   *
   * Basic Navigation: When the `sap.ui.webc.main.Carousel` is focused the user can navigate between the items
   * with the following keyboard shortcuts:
   *
   *
   *
   * 	 - [UP/DOWN] - Navigates to previous and next item
   * 	 - [LEFT/RIGHT] - Navigates to previous and next item
   *
   * CSS Shadow Parts:
   *
   * {@link https://developer.mozilla.org/en-US/docs/Web/CSS/::part CSS Shadow Parts} allow developers to
   * style elements inside the Shadow DOM.
   *  The `sap.ui.webc.main.Carousel` exposes the following CSS Shadow Parts:
   * 	 - content - Used to style the content of the component
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class Carousel extends WebComponent {
    /**
     * Constructor for a new `Carousel`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $CarouselSettings
    );
    /**
     * Constructor for a new `Carousel`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $CarouselSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.Carousel with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Carousel>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.Carousel.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some content to the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted
       */
      oContent: Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:navigate navigate} event of this `sap.ui.webc.main.Carousel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Carousel` itself.
     *
     * Fired whenever the page changes due to user interaction, when the user clicks on the navigation arrows
     * or while resizing, based on the `items-per-page-l`, `items-per-page-m` and `items-per-page-s` properties.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNavigate(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Carousel$NavigateEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Carousel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:navigate navigate} event of this `sap.ui.webc.main.Carousel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Carousel` itself.
     *
     * Fired whenever the page changes due to user interaction, when the user clicks on the navigation arrows
     * or while resizing, based on the `items-per-page-l`, `items-per-page-m` and `items-per-page-s` properties.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNavigate(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Carousel$NavigateEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Carousel` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:navigate navigate} event of this `sap.ui.webc.main.Carousel`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachNavigate(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Carousel$NavigateEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:navigate navigate} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireNavigate(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Carousel$NavigateEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getArrowsPlacement arrowsPlacement}.
     *
     * Defines the position of arrows.
     *
     *  Available options are:
     * 	 - `Content` - the arrows are placed on the sides of the current page.
     * 	 - `Navigation` - the arrows are placed on the sides of the page indicator.
     *
     * Default value is `Content`.
     *
     *
     * @returns Value of property `arrowsPlacement`
     */
    getArrowsPlacement():
      | CarouselArrowsPlacement
      | keyof typeof CarouselArrowsPlacement;
    /**
     * Gets current value of property {@link #getBackgroundDesign backgroundDesign}.
     *
     * Defines the carousel's background design.
     *
     * Default value is `Translucent`.
     *
     *
     * @returns Value of property `backgroundDesign`
     */
    getBackgroundDesign(): BackgroundDesign | keyof typeof BackgroundDesign;
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * Defines the content of the component.
     */
    getContent(): Control[];
    /**
     * Gets current value of property {@link #getCyclic cyclic}.
     *
     * Defines whether the carousel should loop, i.e show the first page after the last page is reached and
     * vice versa.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `cyclic`
     */
    getCyclic(): boolean;
    /**
     * Gets current value of property {@link #getHideNavigationArrows hideNavigationArrows}.
     *
     * Defines the visibility of the navigation arrows. If set to true the navigation arrows will be hidden.
     *
     *
     *  **Note:** The navigation arrows are never displayed on touch devices. In this case, the user can swipe
     * to navigate through the items.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `hideNavigationArrows`
     */
    getHideNavigationArrows(): boolean;
    /**
     * Gets current value of property {@link #getHidePageIndicator hidePageIndicator}.
     *
     * Defines the visibility of the page indicator. If set to true the page indicator will be hidden.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `hidePageIndicator`
     */
    getHidePageIndicator(): boolean;
    /**
     * Gets current value of property {@link #getItemsPerPageL itemsPerPageL}.
     *
     * Defines the number of items per page on large size (more than 1024px). One item per page shown by default.
     *
     * Default value is `1`.
     *
     *
     * @returns Value of property `itemsPerPageL`
     */
    getItemsPerPageL(): int;
    /**
     * Gets current value of property {@link #getItemsPerPageM itemsPerPageM}.
     *
     * Defines the number of items per page on medium size (from 640px to 1024px). One item per page shown by
     * default.
     *
     * Default value is `1`.
     *
     *
     * @returns Value of property `itemsPerPageM`
     */
    getItemsPerPageM(): int;
    /**
     * Gets current value of property {@link #getItemsPerPageS itemsPerPageS}.
     *
     * Defines the number of items per page on small size (up to 640px). One item per page shown by default.
     *
     * Default value is `1`.
     *
     *
     * @returns Value of property `itemsPerPageS`
     */
    getItemsPerPageS(): int;
    /**
     * Gets current value of property {@link #getPageIndicatorBackgroundDesign pageIndicatorBackgroundDesign}.
     *
     * Defines the page indicator background design.
     *
     * Default value is `Solid`.
     *
     *
     * @returns Value of property `pageIndicatorBackgroundDesign`
     */
    getPageIndicatorBackgroundDesign():
      | BackgroundDesign
      | keyof typeof BackgroundDesign;
    /**
     * Gets current value of property {@link #getPageIndicatorBorderDesign pageIndicatorBorderDesign}.
     *
     * Defines the page indicator border design.
     *
     * Default value is `Solid`.
     *
     *
     * @returns Value of property `pageIndicatorBorderDesign`
     */
    getPageIndicatorBorderDesign(): BorderDesign | keyof typeof BorderDesign;
    /**
     * Gets current value of property {@link #getPageIndicatorStyle pageIndicatorStyle}.
     *
     * Defines the style of the page indicator. Available options are:
     * 	 - `Default` - The page indicator will be visualized as dots if there are fewer than 9 pages. If there
     *     are more pages, the page indicator will switch to displaying the current page and the total number of
     *     pages. (e.g. X of Y)
     * 	 - `Numeric` - The page indicator will display the current page and the total number of pages. (e.g.
     *     X of Y)
     *
     * Default value is `Default`.
     *
     *
     * @returns Value of property `pageIndicatorStyle`
     */
    getPageIndicatorStyle():
      | CarouselPageIndicatorStyle
      | keyof typeof CarouselPageIndicatorStyle;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContent content}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: Control
    ): int;
    /**
     * Inserts a content into the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: Control,
      /**
       * The `0`-based index the content should be inserted at; for a negative value of `iIndex`, the content
       * is inserted at position 0; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Changes the currently displayed page.
     */
    navigateTo(
      /**
       * The index of the target page
       */
      itemIndex: int
    ): void;
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): Control[];
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | Control
    ): Control | null;
    /**
     * Sets a new value for property {@link #getArrowsPlacement arrowsPlacement}.
     *
     * Defines the position of arrows.
     *
     *  Available options are:
     * 	 - `Content` - the arrows are placed on the sides of the current page.
     * 	 - `Navigation` - the arrows are placed on the sides of the page indicator.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Content`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setArrowsPlacement(
      /**
       * New value for property `arrowsPlacement`
       */
      sArrowsPlacement?:
        | CarouselArrowsPlacement
        | keyof typeof CarouselArrowsPlacement
    ): this;
    /**
     * Sets a new value for property {@link #getBackgroundDesign backgroundDesign}.
     *
     * Defines the carousel's background design.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Translucent`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackgroundDesign(
      /**
       * New value for property `backgroundDesign`
       */
      sBackgroundDesign?: BackgroundDesign | keyof typeof BackgroundDesign
    ): this;
    /**
     * Sets a new value for property {@link #getCyclic cyclic}.
     *
     * Defines whether the carousel should loop, i.e show the first page after the last page is reached and
     * vice versa.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCyclic(
      /**
       * New value for property `cyclic`
       */
      bCyclic?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHideNavigationArrows hideNavigationArrows}.
     *
     * Defines the visibility of the navigation arrows. If set to true the navigation arrows will be hidden.
     *
     *
     *  **Note:** The navigation arrows are never displayed on touch devices. In this case, the user can swipe
     * to navigate through the items.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideNavigationArrows(
      /**
       * New value for property `hideNavigationArrows`
       */
      bHideNavigationArrows?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHidePageIndicator hidePageIndicator}.
     *
     * Defines the visibility of the page indicator. If set to true the page indicator will be hidden.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHidePageIndicator(
      /**
       * New value for property `hidePageIndicator`
       */
      bHidePageIndicator?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getItemsPerPageL itemsPerPageL}.
     *
     * Defines the number of items per page on large size (more than 1024px). One item per page shown by default.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setItemsPerPageL(
      /**
       * New value for property `itemsPerPageL`
       */
      iItemsPerPageL?: int
    ): this;
    /**
     * Sets a new value for property {@link #getItemsPerPageM itemsPerPageM}.
     *
     * Defines the number of items per page on medium size (from 640px to 1024px). One item per page shown by
     * default.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setItemsPerPageM(
      /**
       * New value for property `itemsPerPageM`
       */
      iItemsPerPageM?: int
    ): this;
    /**
     * Sets a new value for property {@link #getItemsPerPageS itemsPerPageS}.
     *
     * Defines the number of items per page on small size (up to 640px). One item per page shown by default.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setItemsPerPageS(
      /**
       * New value for property `itemsPerPageS`
       */
      iItemsPerPageS?: int
    ): this;
    /**
     * Sets a new value for property {@link #getPageIndicatorBackgroundDesign pageIndicatorBackgroundDesign}.
     *
     * Defines the page indicator background design.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Solid`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPageIndicatorBackgroundDesign(
      /**
       * New value for property `pageIndicatorBackgroundDesign`
       */
      sPageIndicatorBackgroundDesign?:
        | BackgroundDesign
        | keyof typeof BackgroundDesign
    ): this;
    /**
     * Sets a new value for property {@link #getPageIndicatorBorderDesign pageIndicatorBorderDesign}.
     *
     * Defines the page indicator border design.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Solid`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPageIndicatorBorderDesign(
      /**
       * New value for property `pageIndicatorBorderDesign`
       */
      sPageIndicatorBorderDesign?: BorderDesign | keyof typeof BorderDesign
    ): this;
    /**
     * Sets a new value for property {@link #getPageIndicatorStyle pageIndicatorStyle}.
     *
     * Defines the style of the page indicator. Available options are:
     * 	 - `Default` - The page indicator will be visualized as dots if there are fewer than 9 pages. If there
     *     are more pages, the page indicator will switch to displaying the current page and the total number of
     *     pages. (e.g. X of Y)
     * 	 - `Numeric` - The page indicator will display the current page and the total number of pages. (e.g.
     *     X of Y)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Default`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPageIndicatorStyle(
      /**
       * New value for property `pageIndicatorStyle`
       */
      sPageIndicatorStyle?:
        | CarouselPageIndicatorStyle
        | keyof typeof CarouselPageIndicatorStyle
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Carousel constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $CarouselSettings extends $WebComponentSettings {
    /**
     * Defines the position of arrows.
     *
     *  Available options are:
     * 	 - `Content` - the arrows are placed on the sides of the current page.
     * 	 - `Navigation` - the arrows are placed on the sides of the page indicator.
     */
    arrowsPlacement?:
      | (CarouselArrowsPlacement | keyof typeof CarouselArrowsPlacement)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the carousel's background design.
     */
    backgroundDesign?:
      | (BackgroundDesign | keyof typeof BackgroundDesign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines whether the carousel should loop, i.e show the first page after the last page is reached and
     * vice versa.
     */
    cyclic?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the visibility of the navigation arrows. If set to true the navigation arrows will be hidden.
     *
     *
     *  **Note:** The navigation arrows are never displayed on touch devices. In this case, the user can swipe
     * to navigate through the items.
     */
    hideNavigationArrows?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the visibility of the page indicator. If set to true the page indicator will be hidden.
     */
    hidePageIndicator?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the number of items per page on large size (more than 1024px). One item per page shown by default.
     */
    itemsPerPageL?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the number of items per page on medium size (from 640px to 1024px). One item per page shown by
     * default.
     */
    itemsPerPageM?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the number of items per page on small size (up to 640px). One item per page shown by default.
     */
    itemsPerPageS?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the page indicator background design.
     */
    pageIndicatorBackgroundDesign?:
      | (BackgroundDesign | keyof typeof BackgroundDesign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the page indicator border design.
     */
    pageIndicatorBorderDesign?:
      | (BorderDesign | keyof typeof BorderDesign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the style of the page indicator. Available options are:
     * 	 - `Default` - The page indicator will be visualized as dots if there are fewer than 9 pages. If there
     *     are more pages, the page indicator will switch to displaying the current page and the total number of
     *     pages. (e.g. X of Y)
     * 	 - `Numeric` - The page indicator will display the current page and the total number of pages. (e.g.
     *     X of Y)
     */
    pageIndicatorStyle?:
      | (CarouselPageIndicatorStyle | keyof typeof CarouselPageIndicatorStyle)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the content of the component.
     */
    content?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * Fired whenever the page changes due to user interaction, when the user clicks on the navigation arrows
     * or while resizing, based on the `items-per-page-l`, `items-per-page-m` and `items-per-page-s` properties.
     */
    navigate?: (oEvent: Carousel$NavigateEvent) => void;
  }

  /**
   * Parameters of the Carousel#navigate event.
   */
  export interface Carousel$NavigateEventParameters {
    /**
     * the current selected index
     */
    selectedIndex?: int;
  }

  /**
   * Event object of the Carousel#navigate event.
   */
  export type Carousel$NavigateEvent = Event<
    Carousel$NavigateEventParameters,
    Carousel
  >;
}

declare module "sap/ui/webc/main/CheckBox" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IFormContent, ID, ValueState, CSSSize } from "sap/ui/core/library";

  import Control from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { WrappingType } from "sap/ui/webc/main/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * Allows the user to set a binary value, such as true/false or yes/no for an item.
   *
   *  The `sap.ui.webc.main.CheckBox` component consists of a box and a label that describes its purpose.
   * If it's checked, an indicator is displayed inside the box. To check/uncheck the `sap.ui.webc.main.CheckBox`,
   * the user has to click or tap the square box or its label.
   *
   *  The `sap.ui.webc.main.CheckBox` component only has 2 states - checked and unchecked. Clicking or tapping
   * toggles the `sap.ui.webc.main.CheckBox` between checked and unchecked state.
   *
   * Usage:
   *
   * You can define the checkbox text with via the `text` property. If the text exceeds the available width,
   * it is truncated by default. In case you prefer text to wrap, set the `wrappingType` property to "Normal".
   * The touchable area for toggling the `sap.ui.webc.main.CheckBox` ends where the text ends.
   *
   *  You can disable the `sap.ui.webc.main.CheckBox` by setting the `disabled` property to `true`, or use
   * the `sap.ui.webc.main.CheckBox` in read-only mode by setting the `readonly` property to `true`.
   *
   *
   *
   *  CSS Shadow Parts:
   *
   * {@link https://developer.mozilla.org/en-US/docs/Web/CSS/::part CSS Shadow Parts} allow developers to
   * style elements inside the Shadow DOM.
   *  The `sap.ui.webc.main.CheckBox` exposes the following CSS Shadow Parts:
   * 	 - root - Used to style the outermost wrapper of the `sap.ui.webc.main.CheckBox`
   *
   *
   *
   *  Keyboard Handling:
   *
   * The user can use the following keyboard shortcuts to toggle the checked state of the `sap.ui.webc.main.CheckBox`.
   *
   * 	 - [SPACE, ENTER] - Toggles between different states: checked, not checked.
   *
   *
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class CheckBox extends WebComponent implements IFormContent {
    __implements__sap_ui_core_IFormContent: boolean;
    /**
     * Constructor for a new `CheckBox`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $CheckBoxSettings
    );
    /**
     * Constructor for a new `CheckBox`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $CheckBoxSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.CheckBox with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, CheckBox>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.CheckBox.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.CheckBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.CheckBox` itself.
     *
     * Fired when the component checked state changes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.CheckBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.CheckBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.CheckBox` itself.
     *
     * Fired when the component checked state changes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.CheckBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:change change} event of this `sap.ui.webc.main.CheckBox`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:change change} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getChecked checked}.
     *
     * Defines if the component is checked.
     *
     *  **Note:** The property can be changed with user interaction, either by cliking/tapping on the component,
     * or by pressing the Enter or Space key.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `checked`
     */
    getChecked(): boolean;
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getIndeterminate indeterminate}.
     *
     * Defines whether the component is displayed as partially checked.
     *
     *  **Note:** The indeterminate state can be set only programmatically and can’t be achieved by user interaction
     * and the resulting visual state depends on the values of the `indeterminate` and `checked` properties:
     *
     * 	 If the component is checked and indeterminate, it will be displayed as partially checked  If the
     * component is checked and it is not indeterminate, it will be displayed as checked  If the component
     * is not checked, it will be displayed as not checked regardless value of the indeterminate attribute
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `indeterminate`
     */
    getIndeterminate(): boolean;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * Determines the name with which the component will be submitted in an HTML form.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form. Do not use this property unless you need to submit a form.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getReadonly readonly}.
     *
     * Defines whether the component is read-only.
     *
     *  **Note:** A read-only component is not editable, but still provides visual feedback upon user interaction.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `readonly`
     */
    getReadonly(): boolean;
    /**
     * Gets current value of property {@link #getRequired required}.
     *
     * Defines whether the component is required.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `required`
     */
    getRequired(): boolean;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Defines the text of the component.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets current value of property {@link #getValueState valueState}.
     *
     * Defines the value state of the component.
     *
     *
     *
     *  **Note:**
     *
     *
     * 	 - `Warning`
     * 	 - `Error`
     * 	 - `None`(default)
     * 	 - `Success`
     * 	 - `Information`
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `valueState`
     */
    getValueState(): ValueState | keyof typeof ValueState;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Gets current value of property {@link #getWrappingType wrappingType}.
     *
     * Defines whether the component text wraps when there is not enough space.
     *  **Note:** for option "Normal" the text will wrap and the words will not be broken based on hyphenation.
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `wrappingType`
     */
    getWrappingType(): WrappingType | keyof typeof WrappingType;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getChecked checked}.
     *
     * Defines if the component is checked.
     *
     *  **Note:** The property can be changed with user interaction, either by cliking/tapping on the component,
     * or by pressing the Enter or Space key.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setChecked(
      /**
       * New value for property `checked`
       */
      bChecked?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIndeterminate indeterminate}.
     *
     * Defines whether the component is displayed as partially checked.
     *
     *  **Note:** The indeterminate state can be set only programmatically and can’t be achieved by user interaction
     * and the resulting visual state depends on the values of the `indeterminate` and `checked` properties:
     *
     * 	 If the component is checked and indeterminate, it will be displayed as partially checked  If the
     * component is checked and it is not indeterminate, it will be displayed as checked  If the component
     * is not checked, it will be displayed as not checked regardless value of the indeterminate attribute
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIndeterminate(
      /**
       * New value for property `indeterminate`
       */
      bIndeterminate?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * Determines the name with which the component will be submitted in an HTML form.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form. Do not use this property unless you need to submit a form.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getReadonly readonly}.
     *
     * Defines whether the component is read-only.
     *
     *  **Note:** A read-only component is not editable, but still provides visual feedback upon user interaction.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setReadonly(
      /**
       * New value for property `readonly`
       */
      bReadonly?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getRequired required}.
     *
     * Defines whether the component is required.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRequired(
      /**
       * New value for property `required`
       */
      bRequired?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Defines the text of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValueState valueState}.
     *
     * Defines the value state of the component.
     *
     *
     *
     *  **Note:**
     *
     *
     * 	 - `Warning`
     * 	 - `Error`
     * 	 - `None`(default)
     * 	 - `Success`
     * 	 - `Information`
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueState(
      /**
       * New value for property `valueState`
       */
      sValueState?: ValueState | keyof typeof ValueState
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getWrappingType wrappingType}.
     *
     * Defines whether the component text wraps when there is not enough space.
     *  **Note:** for option "Normal" the text will wrap and the words will not be broken based on hyphenation.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWrappingType(
      /**
       * New value for property `wrappingType`
       */
      sWrappingType?: WrappingType | keyof typeof WrappingType
    ): this;
  }
  /**
   * Describes the settings that can be provided to the CheckBox constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $CheckBoxSettings extends $WebComponentSettings {
    /**
     * Defines the accessible ARIA name of the component.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * Defines if the component is checked.
     *
     *  **Note:** The property can be changed with user interaction, either by cliking/tapping on the component,
     * or by pressing the Enter or Space key.
     */
    checked?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the component is displayed as partially checked.
     *
     *  **Note:** The indeterminate state can be set only programmatically and can’t be achieved by user interaction
     * and the resulting visual state depends on the values of the `indeterminate` and `checked` properties:
     *
     * 	 If the component is checked and indeterminate, it will be displayed as partially checked  If the
     * component is checked and it is not indeterminate, it will be displayed as checked  If the component
     * is not checked, it will be displayed as not checked regardless value of the indeterminate attribute
     */
    indeterminate?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines the name with which the component will be submitted in an HTML form.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form. Do not use this property unless you need to submit a form.
     */
    name?: string | PropertyBindingInfo;

    /**
     * Defines whether the component is read-only.
     *
     *  **Note:** A read-only component is not editable, but still provides visual feedback upon user interaction.
     */
    readonly?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the component is required.
     */
    required?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the text of the component.
     */
    text?: string | PropertyBindingInfo;

    /**
     * Defines the value state of the component.
     *
     *
     *
     *  **Note:**
     *
     *
     * 	 - `Warning`
     * 	 - `Error`
     * 	 - `None`(default)
     * 	 - `Success`
     * 	 - `Information`
     */
    valueState?:
      | (ValueState | keyof typeof ValueState)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the component text wraps when there is not enough space.
     *  **Note:** for option "Normal" the text will wrap and the words will not be broken based on hyphenation.
     */
    wrappingType?:
      | (WrappingType | keyof typeof WrappingType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Receives id(or many ids) of the controls that label this control.
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Fired when the component checked state changes.
     */
    change?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the CheckBox#change event.
   */
  export interface CheckBox$ChangeEventParameters {}

  /**
   * Event object of the CheckBox#change event.
   */
  export type CheckBox$ChangeEvent = Event<
    CheckBox$ChangeEventParameters,
    CheckBox
  >;
}

declare module "sap/ui/webc/main/ColorPalette" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IColorPaletteItem } from "sap/ui/webc/main/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { AggregationBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Overview: The `sap.ui.webc.main.ColorPalette` provides the users with a range of predefined colors. The
   * colors are fixed and do not change with the theme.
   *
   * Usage:
   *
   * The `sap.ui.webc.main.ColorPalette` is meant for users that need to select a color from a predefined
   * set. To define the colors, use the `sap.ui.webc.main.ColorPaletteItem` component inside the default slot
   * of the `sap.ui.webc.main.ColorPalette`.
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class ColorPalette extends WebComponent {
    /**
     * Constructor for a new `ColorPalette`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ColorPaletteSettings
    );
    /**
     * Constructor for a new `ColorPalette`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ColorPaletteSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.ColorPalette with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ColorPalette>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.ColorPalette.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some color to the aggregation {@link #getColors colors}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addColor(
      /**
       * The color to add; if empty, nothing is inserted
       */
      oColor: IColorPaletteItem
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemClick itemClick} event of this `sap.ui.webc.main.ColorPalette`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.ColorPalette` itself.
     *
     * Fired when the user selects a color.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ColorPalette$ItemClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.ColorPalette` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemClick itemClick} event of this `sap.ui.webc.main.ColorPalette`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.ColorPalette` itself.
     *
     * Fired when the user selects a color.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ColorPalette$ItemClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.ColorPalette` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the colors in the aggregation {@link #getColors colors}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyColors(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:itemClick itemClick} event of this `sap.ui.webc.main.ColorPalette`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachItemClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ColorPalette$ItemClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:itemClick itemClick} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireItemClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ColorPalette$ItemClickEventParameters
    ): this;
    /**
     * Gets content of aggregation {@link #getColors colors}.
     *
     * Defines the `sap.ui.webc.main.ColorPaletteItem` elements.
     */
    getColors(): IColorPaletteItem[];
    /**
     * Checks for the provided `sap.ui.webc.main.IColorPaletteItem` in the aggregation {@link #getColors colors}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfColor(
      /**
       * The color whose index is looked for
       */
      oColor: IColorPaletteItem
    ): int;
    /**
     * Inserts a color into the aggregation {@link #getColors colors}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertColor(
      /**
       * The color to insert; if empty, nothing is inserted
       */
      oColor: IColorPaletteItem,
      /**
       * The `0`-based index the color should be inserted at; for a negative value of `iIndex`, the color is inserted
       * at position 0; for a value greater than the current size of the aggregation, the color is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getColors colors}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllColors(): IColorPaletteItem[];
    /**
     * Removes a color from the aggregation {@link #getColors colors}.
     *
     *
     * @returns The removed color or `null`
     */
    removeColor(
      /**
       * The color to remove or its index or id
       */
      vColor: int | string | IColorPaletteItem
    ): IColorPaletteItem | null;
  }
  /**
   * Describes the settings that can be provided to the ColorPalette constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $ColorPaletteSettings extends $WebComponentSettings {
    /**
     * Defines the `sap.ui.webc.main.ColorPaletteItem` elements.
     */
    colors?:
      | IColorPaletteItem[]
      | IColorPaletteItem
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Fired when the user selects a color.
     */
    itemClick?: (oEvent: ColorPalette$ItemClickEvent) => void;
  }

  /**
   * Parameters of the ColorPalette#itemClick event.
   */
  export interface ColorPalette$ItemClickEventParameters {
    /**
     * the selected color
     */
    color?: string;
  }

  /**
   * Event object of the ColorPalette#itemClick event.
   */
  export type ColorPalette$ItemClickEvent = Event<
    ColorPalette$ItemClickEventParameters,
    ColorPalette
  >;
}

declare module "sap/ui/webc/main/ColorPaletteItem" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IColorPaletteItem } from "sap/ui/webc/main/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { CSSColor } from "sap/ui/core/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * The `sap.ui.webc.main.ColorPaletteItem` component represents a color in the the `sap.ui.webc.main.ColorPalette`.
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class ColorPaletteItem
    extends WebComponent
    implements IColorPaletteItem {
    __implements__sap_ui_webc_main_IColorPaletteItem: boolean;
    /**
     * Constructor for a new `ColorPaletteItem`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ColorPaletteItemSettings
    );
    /**
     * Constructor for a new `ColorPaletteItem`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ColorPaletteItemSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.ColorPaletteItem with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ColorPaletteItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.ColorPaletteItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * Defines the colour of the component.
     *
     *  **Note:** The value should be a valid CSS color.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): CSSColor;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * Defines the colour of the component.
     *
     *  **Note:** The value should be a valid CSS color.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      sValue: CSSColor
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ColorPaletteItem constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $ColorPaletteItemSettings extends $WebComponentSettings {
    /**
     * Defines the colour of the component.
     *
     *  **Note:** The value should be a valid CSS color.
     */
    value?: CSSColor | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/webc/main/ColorPalettePopover" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IColorPaletteItem } from "sap/ui/webc/main/library";

  import { CSSColor } from "sap/ui/core/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Overview: Represents a predefined range of colors for easier selection.
   *
   * Overview The ColorPalettePopover provides the users with a slot to predefine colors.
   *
   * You can customize them with the use of the colors property. You can specify a defaultColor and display
   * a "Default color" button for the user to choose directly. You can display a "More colors..." button that
   * opens an additional color picker for the user to choose specific colors that are not present in the predefined
   * range.
   *
   * Usage:
   *
   * The palette is intended for users, who don't want to check and remember the different values of the colors
   * and spend large amount of time to configure the right color through the color picker.
   *
   * @since 1.97.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.97.0) - This control is experimental and its API might change significantly.
   */
  export default class ColorPalettePopover extends WebComponent {
    /**
     * Constructor for a new `ColorPalettePopover`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ColorPalettePopoverSettings
    );
    /**
     * Constructor for a new `ColorPalettePopover`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ColorPalettePopoverSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.ColorPalettePopover with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ColorPalettePopover>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.ColorPalettePopover.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some color to the aggregation {@link #getColors colors}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addColor(
      /**
       * The color to add; if empty, nothing is inserted
       */
      oColor: IColorPaletteItem
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemClick itemClick} event of this `sap.ui.webc.main.ColorPalettePopover`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.ColorPalettePopover` itself.
     *
     * Fired when the user selects a color.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ColorPalettePopover$ItemClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.ColorPalettePopover`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemClick itemClick} event of this `sap.ui.webc.main.ColorPalettePopover`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.ColorPalettePopover` itself.
     *
     * Fired when the user selects a color.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ColorPalettePopover$ItemClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.ColorPalettePopover`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the colors in the aggregation {@link #getColors colors}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyColors(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:itemClick itemClick} event of this `sap.ui.webc.main.ColorPalettePopover`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachItemClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ColorPalettePopover$ItemClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:itemClick itemClick} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireItemClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ColorPalettePopover$ItemClickEventParameters
    ): this;
    /**
     * Gets content of aggregation {@link #getColors colors}.
     *
     * Defines the content of the component.
     */
    getColors(): IColorPaletteItem[];
    /**
     * Gets current value of property {@link #getDefaultColor defaultColor}.
     *
     * Defines the default color of the component. **Note:** The default color should be a part of the ColorPalette
     * colors
     *
     *
     * @returns Value of property `defaultColor`
     */
    getDefaultColor(): CSSColor;
    /**
     * Gets current value of property {@link #getShowDefaultColor showDefaultColor}.
     *
     * Defines whether the user can choose the default color from a button.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showDefaultColor`
     */
    getShowDefaultColor(): boolean;
    /**
     * Gets current value of property {@link #getShowMoreColors showMoreColors}.
     *
     * Defines whether the user can choose a custom color from a component. **Note:** In order to use this property
     * you need to import the following module: `"@ui5/webcomponents/dist/features/ColorPaletteMoreColors.js"`
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showMoreColors`
     */
    getShowMoreColors(): boolean;
    /**
     * Gets current value of property {@link #getShowRecentColors showRecentColors}.
     *
     * Defines whether the user can see the last used colors in the bottom of the component
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showRecentColors`
     */
    getShowRecentColors(): boolean;
    /**
     * Checks for the provided `sap.ui.webc.main.IColorPaletteItem` in the aggregation {@link #getColors colors}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfColor(
      /**
       * The color whose index is looked for
       */
      oColor: IColorPaletteItem
    ): int;
    /**
     * Inserts a color into the aggregation {@link #getColors colors}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertColor(
      /**
       * The color to insert; if empty, nothing is inserted
       */
      oColor: IColorPaletteItem,
      /**
       * The `0`-based index the color should be inserted at; for a negative value of `iIndex`, the color is inserted
       * at position 0; for a value greater than the current size of the aggregation, the color is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getColors colors}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllColors(): IColorPaletteItem[];
    /**
     * Removes a color from the aggregation {@link #getColors colors}.
     *
     *
     * @returns The removed color or `null`
     */
    removeColor(
      /**
       * The color to remove or its index or id
       */
      vColor: int | string | IColorPaletteItem
    ): IColorPaletteItem | null;
    /**
     * Sets a new value for property {@link #getDefaultColor defaultColor}.
     *
     * Defines the default color of the component. **Note:** The default color should be a part of the ColorPalette
     * colors
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDefaultColor(
      /**
       * New value for property `defaultColor`
       */
      sDefaultColor: CSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getShowDefaultColor showDefaultColor}.
     *
     * Defines whether the user can choose the default color from a button.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowDefaultColor(
      /**
       * New value for property `showDefaultColor`
       */
      bShowDefaultColor?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowMoreColors showMoreColors}.
     *
     * Defines whether the user can choose a custom color from a component. **Note:** In order to use this property
     * you need to import the following module: `"@ui5/webcomponents/dist/features/ColorPaletteMoreColors.js"`
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowMoreColors(
      /**
       * New value for property `showMoreColors`
       */
      bShowMoreColors?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowRecentColors showRecentColors}.
     *
     * Defines whether the user can see the last used colors in the bottom of the component
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowRecentColors(
      /**
       * New value for property `showRecentColors`
       */
      bShowRecentColors?: boolean
    ): this;
    /**
     * Shows the ColorPalettePopover.
     */
    showAt(
      /**
       * the element that the popover is shown at
       */
      opener: HTMLElement
    ): void;
  }
  /**
   * Describes the settings that can be provided to the ColorPalettePopover constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.97.0) - This control is experimental and its API might change significantly.
   */
  export interface $ColorPalettePopoverSettings extends $WebComponentSettings {
    /**
     * Defines the default color of the component. **Note:** The default color should be a part of the ColorPalette
     * colors
     */
    defaultColor?: CSSColor | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the user can choose the default color from a button.
     */
    showDefaultColor?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the user can choose a custom color from a component. **Note:** In order to use this property
     * you need to import the following module: `"@ui5/webcomponents/dist/features/ColorPaletteMoreColors.js"`
     */
    showMoreColors?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the user can see the last used colors in the bottom of the component
     */
    showRecentColors?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the content of the component.
     */
    colors?:
      | IColorPaletteItem[]
      | IColorPaletteItem
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Fired when the user selects a color.
     */
    itemClick?: (oEvent: ColorPalettePopover$ItemClickEvent) => void;
  }

  /**
   * Parameters of the ColorPalettePopover#itemClick event.
   */
  export interface ColorPalettePopover$ItemClickEventParameters {
    /**
     * the selected color
     */
    color?: string;
  }

  /**
   * Event object of the ColorPalettePopover#itemClick event.
   */
  export type ColorPalettePopover$ItemClickEvent = Event<
    ColorPalettePopover$ItemClickEventParameters,
    ColorPalettePopover
  >;
}

declare module "sap/ui/webc/main/ColorPicker" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import Event from "sap/ui/base/Event";

  import { CSSColor } from "sap/ui/core/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Overview: The `sap.ui.webc.main.ColorPicker` allows users to choose any color and provides different
   * input options for selecting colors.
   *
   * Usage:
   *
   * When to use:
   * 	 -  users need to select any color freely.
   *
   * When not to use::
   * 	 -  Users need to select one color from a predefined set of colors. Use the ColorPalette component instead.
   *
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class ColorPicker extends WebComponent {
    /**
     * Constructor for a new `ColorPicker`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ColorPickerSettings
    );
    /**
     * Constructor for a new `ColorPicker`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ColorPickerSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.ColorPicker with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ColorPicker>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.ColorPicker.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.ColorPicker`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.ColorPicker` itself.
     *
     * Fired when the the selected color is changed
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.ColorPicker` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.ColorPicker`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.ColorPicker` itself.
     *
     * Fired when the the selected color is changed
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.ColorPicker` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:change change} event of this `sap.ui.webc.main.ColorPicker`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:change change} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * Defines the currently selected color of the component.
     *
     *  **Note**: use HEX, RGB, RGBA, HSV formats or a CSS color name when modifying this property.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): CSSColor;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * Defines the currently selected color of the component.
     *
     *  **Note**: use HEX, RGB, RGBA, HSV formats or a CSS color name when modifying this property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor: CSSColor
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ColorPicker constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $ColorPickerSettings extends $WebComponentSettings {
    /**
     * Defines the currently selected color of the component.
     *
     *  **Note**: use HEX, RGB, RGBA, HSV formats or a CSS color name when modifying this property.
     */
    color?: CSSColor | PropertyBindingInfo | `{${string}}`;

    /**
     * Fired when the the selected color is changed
     */
    change?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the ColorPicker#change event.
   */
  export interface ColorPicker$ChangeEventParameters {}

  /**
   * Event object of the ColorPicker#change event.
   */
  export type ColorPicker$ChangeEvent = Event<
    ColorPicker$ChangeEventParameters,
    ColorPicker
  >;
}

declare module "sap/ui/webc/main/ComboBox" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IFormContent, ID, ValueState, CSSSize } from "sap/ui/core/library";

  import Control from "sap/ui/core/Control";

  import {
    IIcon,
    IComboBoxItem,
    ComboBoxFilter,
  } from "sap/ui/webc/main/library";

  import Event from "sap/ui/base/Event";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * The `sap.ui.webc.main.ComboBox` component represents a drop-down menu with a list of the available options
   * and a text input field to narrow down the options.
   *
   * It is commonly used to enable users to select an option from a predefined list.
   *
   * Structure: The `sap.ui.webc.main.ComboBox` consists of the following elements:
   *
   *
   * 	 -  Input field - displays the selected option or a custom user entry. Users can type to narrow down
   *     the list or enter their own value.
   * 	 -  Drop-down arrow - expands\collapses the option list.
   * 	 -  Option list - the list of available options.
   *
   * Keyboard Handling:
   *
   * The `sap.ui.webc.main.ComboBox` provides advanced keyboard handling.
   *
   *
   *
   * 	 - [F4], [ALT]+[UP], or [ALT]+[DOWN] - Toggles the picker.
   * 	 - [ESC] - Closes the picker, if open. If closed, cancels changes and reverts the typed in value.
   * 	 - [ENTER] or [RETURN] - If picker is open, takes over the currently selected item and closes it.
   * 	 - [DOWN] - Selects the next matching item in the picker.
   * 	 - [UP] - Selects the previous matching item in the picker.
   * 	 - [PAGEDOWN] - Moves selection down by page size (10 items by default).
   * 	 - [PAGEUP] - Moves selection up by page size (10 items by default).
   * 	 - [HOME] - If focus is in the ComboBox, moves cursor at the beginning of text. If focus is in the picker,
   *     selects the first item.
   * 	 - [END] - If focus is in the ComboBox, moves cursor at the end of text. If focus is in the picker,
   *     selects the last item.
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class ComboBox extends WebComponent implements IFormContent {
    __implements__sap_ui_core_IFormContent: boolean;
    /**
     * Constructor for a new `ComboBox`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ComboBoxSettings
    );
    /**
     * Constructor for a new `ComboBox`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ComboBoxSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.ComboBox with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ComboBox>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.ComboBox.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some icon to the aggregation {@link #getIcon icon}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addIcon(
      /**
       * The icon to add; if empty, nothing is inserted
       */
      oIcon: IIcon
    ): this;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: IComboBoxItem
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.ComboBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.ComboBox` itself.
     *
     * Fired when the input operation has finished by pressing Enter, focusout or an item is selected.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.ComboBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.ComboBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.ComboBox` itself.
     *
     * Fired when the input operation has finished by pressing Enter, focusout or an item is selected.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.ComboBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:input input} event of this `sap.ui.webc.main.ComboBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.ComboBox` itself.
     *
     * Fired when typing in input.
     *
     *  **Note:** filterValue property is updated, input is changed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInput(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.ComboBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:input input} event of this `sap.ui.webc.main.ComboBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.ComboBox` itself.
     *
     * Fired when typing in input.
     *
     *  **Note:** filterValue property is updated, input is changed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInput(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.ComboBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionChange selectionChange} event of this
     * `sap.ui.webc.main.ComboBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.ComboBox` itself.
     *
     * Fired when selection is changed by user interaction
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ComboBox$SelectionChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.ComboBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionChange selectionChange} event of this
     * `sap.ui.webc.main.ComboBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.ComboBox` itself.
     *
     * Fired when selection is changed by user interaction
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ComboBox$SelectionChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.ComboBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the icon in the aggregation {@link #getIcon icon}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyIcon(): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:change change} event of this `sap.ui.webc.main.ComboBox`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:input input} event of this `sap.ui.webc.main.ComboBox`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInput(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectionChange selectionChange} event of
     * this `sap.ui.webc.main.ComboBox`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectionChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ComboBox$SelectionChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:change change} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:input input} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInput(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectionChange selectionChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectionChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ComboBox$SelectionChangeEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getFilter filter}.
     *
     * Defines the filter type of the component.
     *
     * Default value is `StartsWithPerTerm`.
     *
     *
     * @returns Value of property `filter`
     */
    getFilter(): ComboBoxFilter | keyof typeof ComboBoxFilter;
    /**
     * Gets content of aggregation {@link #getIcon icon}.
     *
     * Defines the icon to be displayed in the input field.
     */
    getIcon(): IIcon[];
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * Defines the component items.
     */
    getItems(): IComboBoxItem[];
    /**
     * Gets current value of property {@link #getLoading loading}.
     *
     * Indicates whether a loading indicator should be shown in the picker.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `loading`
     */
    getLoading(): boolean;
    /**
     * Gets current value of property {@link #getPlaceholder placeholder}.
     *
     * Defines a short hint intended to aid the user with data entry when the component has no value.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `placeholder`
     */
    getPlaceholder(): string;
    /**
     * Gets current value of property {@link #getReadonly readonly}.
     *
     * Defines whether the component is read-only.
     *
     *  **Note:** A read-only component is not editable, but still provides visual feedback upon user interaction.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `readonly`
     */
    getReadonly(): boolean;
    /**
     * Gets current value of property {@link #getRequired required}.
     *
     * Defines whether the component is required.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `required`
     */
    getRequired(): boolean;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * Defines the value of the component.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): string;
    /**
     * Gets current value of property {@link #getValueState valueState}.
     *
     * Defines the value state of the component.
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `valueState`
     */
    getValueState(): ValueState | keyof typeof ValueState;
    /**
     * Gets current value of property {@link #getValueStateMessage valueStateMessage}.
     *
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `valueStateMessage`
     */
    getValueStateMessage(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.ui.webc.main.IIcon` in the aggregation {@link #getIcon icon}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfIcon(
      /**
       * The icon whose index is looked for
       */
      oIcon: IIcon
    ): int;
    /**
     * Checks for the provided `sap.ui.webc.main.IComboBoxItem` in the aggregation {@link #getItems items}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: IComboBoxItem
    ): int;
    /**
     * Inserts a icon into the aggregation {@link #getIcon icon}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertIcon(
      /**
       * The icon to insert; if empty, nothing is inserted
       */
      oIcon: IIcon,
      /**
       * The `0`-based index the icon should be inserted at; for a negative value of `iIndex`, the icon is inserted
       * at position 0; for a value greater than the current size of the aggregation, the icon is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: IComboBoxItem,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getIcon icon}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllIcon(): IIcon[];
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): IComboBoxItem[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a icon from the aggregation {@link #getIcon icon}.
     *
     *
     * @returns The removed icon or `null`
     */
    removeIcon(
      /**
       * The icon to remove or its index or id
       */
      vIcon: int | string | IIcon
    ): IIcon | null;
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | IComboBoxItem
    ): IComboBoxItem | null;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getFilter filter}.
     *
     * Defines the filter type of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `StartsWithPerTerm`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFilter(
      /**
       * New value for property `filter`
       */
      sFilter?: ComboBoxFilter | keyof typeof ComboBoxFilter
    ): this;
    /**
     * Sets a new value for property {@link #getLoading loading}.
     *
     * Indicates whether a loading indicator should be shown in the picker.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLoading(
      /**
       * New value for property `loading`
       */
      bLoading?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getPlaceholder placeholder}.
     *
     * Defines a short hint intended to aid the user with data entry when the component has no value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlaceholder(
      /**
       * New value for property `placeholder`
       */
      sPlaceholder?: string
    ): this;
    /**
     * Sets a new value for property {@link #getReadonly readonly}.
     *
     * Defines whether the component is read-only.
     *
     *  **Note:** A read-only component is not editable, but still provides visual feedback upon user interaction.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setReadonly(
      /**
       * New value for property `readonly`
       */
      bReadonly?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getRequired required}.
     *
     * Defines whether the component is required.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRequired(
      /**
       * New value for property `required`
       */
      bRequired?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * Defines the value of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      sValue?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValueState valueState}.
     *
     * Defines the value state of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueState(
      /**
       * New value for property `valueState`
       */
      sValueState?: ValueState | keyof typeof ValueState
    ): this;
    /**
     * Sets a new value for property {@link #getValueStateMessage valueStateMessage}.
     *
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueStateMessage(
      /**
       * New value for property `valueStateMessage`
       */
      sValueStateMessage?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ComboBox constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $ComboBoxSettings extends $WebComponentSettings {
    /**
     * Defines the accessible ARIA name of the component.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the filter type of the component.
     */
    filter?:
      | (ComboBoxFilter | keyof typeof ComboBoxFilter)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Indicates whether a loading indicator should be shown in the picker.
     */
    loading?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines a short hint intended to aid the user with data entry when the component has no value.
     */
    placeholder?: string | PropertyBindingInfo;

    /**
     * Defines whether the component is read-only.
     *
     *  **Note:** A read-only component is not editable, but still provides visual feedback upon user interaction.
     */
    readonly?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the component is required.
     */
    required?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the value of the component.
     */
    value?: string | PropertyBindingInfo;

    /**
     * Defines the value state of the component.
     */
    valueState?:
      | (ValueState | keyof typeof ValueState)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     */
    valueStateMessage?: string | PropertyBindingInfo;

    /**
     * Defines the width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the icon to be displayed in the input field.
     */
    icon?: IIcon[] | IIcon | AggregationBindingInfo | `{${string}}`;

    /**
     * Defines the component items.
     */
    items?:
      | IComboBoxItem[]
      | IComboBoxItem
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Receives id(or many ids) of the controls that label this control.
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Fired when the input operation has finished by pressing Enter, focusout or an item is selected.
     */
    change?: (oEvent: Event) => void;

    /**
     * Fired when typing in input.
     *
     *  **Note:** filterValue property is updated, input is changed.
     */
    input?: (oEvent: Event) => void;

    /**
     * Fired when selection is changed by user interaction
     */
    selectionChange?: (oEvent: ComboBox$SelectionChangeEvent) => void;
  }

  /**
   * Parameters of the ComboBox#change event.
   */
  export interface ComboBox$ChangeEventParameters {}

  /**
   * Event object of the ComboBox#change event.
   */
  export type ComboBox$ChangeEvent = Event<
    ComboBox$ChangeEventParameters,
    ComboBox
  >;

  /**
   * Parameters of the ComboBox#input event.
   */
  export interface ComboBox$InputEventParameters {}

  /**
   * Event object of the ComboBox#input event.
   */
  export type ComboBox$InputEvent = Event<
    ComboBox$InputEventParameters,
    ComboBox
  >;

  /**
   * Parameters of the ComboBox#selectionChange event.
   */
  export interface ComboBox$SelectionChangeEventParameters {
    /**
     * item to be selected.
     */
    item?: IComboBoxItem;
  }

  /**
   * Event object of the ComboBox#selectionChange event.
   */
  export type ComboBox$SelectionChangeEvent = Event<
    ComboBox$SelectionChangeEventParameters,
    ComboBox
  >;
}

declare module "sap/ui/webc/main/ComboBoxGroupItem" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IComboBoxItem } from "sap/ui/webc/main/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The `sap.ui.webc.main.ComboBoxGroupItem` is type of suggestion item, that can be used to split the `sap.ui.webc.main.ComboBox`
   * suggestions into groups.
   *
   * @since 1.95.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.95.0) - This control is experimental and its API might change significantly.
   */
  export default class ComboBoxGroupItem
    extends WebComponent
    implements IComboBoxItem {
    __implements__sap_ui_webc_main_IComboBoxItem: boolean;
    /**
     * Constructor for a new `ComboBoxGroupItem`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ComboBoxGroupItemSettings
    );
    /**
     * Constructor for a new `ComboBoxGroupItem`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ComboBoxGroupItemSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.ComboBoxGroupItem with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ComboBoxGroupItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.ComboBoxGroupItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Defines the text of the component.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Defines the text of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ComboBoxGroupItem constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.95.0) - This control is experimental and its API might change significantly.
   */
  export interface $ComboBoxGroupItemSettings extends $WebComponentSettings {
    /**
     * Defines the text of the component.
     */
    text?: string | PropertyBindingInfo;
  }
}

declare module "sap/ui/webc/main/ComboBoxItem" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IComboBoxItem } from "sap/ui/webc/main/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The `sap.ui.webc.main.ComboBoxItem` represents the item for a `sap.ui.webc.main.ComboBox`.
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class ComboBoxItem
    extends WebComponent
    implements IComboBoxItem {
    __implements__sap_ui_webc_main_IComboBoxItem: boolean;
    /**
     * Constructor for a new `ComboBoxItem`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ComboBoxItemSettings
    );
    /**
     * Constructor for a new `ComboBoxItem`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ComboBoxItemSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.ComboBoxItem with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ComboBoxItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.ComboBoxItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Gets current value of property {@link #getAdditionalText additionalText}.
     *
     * Defines the additional text of the component.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `additionalText`
     */
    getAdditionalText(): string;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Defines the text of the component.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Sets a new value for property {@link #getAdditionalText additionalText}.
     *
     * Defines the additional text of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAdditionalText(
      /**
       * New value for property `additionalText`
       */
      sAdditionalText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Defines the text of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ComboBoxItem constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $ComboBoxItemSettings extends $WebComponentSettings {
    /**
     * Defines the additional text of the component.
     */
    additionalText?: string | PropertyBindingInfo;

    /**
     * Defines the text of the component.
     */
    text?: string | PropertyBindingInfo;
  }
}

declare module "sap/ui/webc/main/CustomListItem" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IListItem, IButton, ListItemType } from "sap/ui/webc/main/library";

  import Control from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * A component to be used as custom list item within the `sap.ui.webc.main.List` the same way as the standard
   * `sap.ui.webc.main.StandardListItem`.
   *
   * The component accepts arbitrary HTML content to allow full customization.
   *
   * CSS Shadow Parts:
   *
   * {@link https://developer.mozilla.org/en-US/docs/Web/CSS/::part CSS Shadow Parts} allow developers to
   * style elements inside the Shadow DOM.
   *  The `sap.ui.webc.main.CustomListItem` exposes the following CSS Shadow Parts:
   * 	 - native-li - Used to style the main li tag of the list item
   * 	 - content - Used to style the content area of the list item
   * 	 - detail-button - Used to style the button rendered when the list item is of type detail
   * 	 - delete-button - Used to style the button rendered when the list item is in delete mode
   * 	 - radio - Used to style the radio button rendered when the list item is in single selection mode
   * 	 - checkbox - Used to style the checkbox rendered when the list item is in multiple selection mode
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class CustomListItem
    extends WebComponent
    implements IListItem {
    __implements__sap_ui_webc_main_IListItem: boolean;
    /**
     * Constructor for a new `CustomListItem`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $CustomListItemSettings
    );
    /**
     * Constructor for a new `CustomListItem`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $CustomListItemSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.CustomListItem with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, CustomListItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.CustomListItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some content to the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted
       */
      oContent: Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:detailClick detailClick} event of this `sap.ui.webc.main.CustomListItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.CustomListItem` itself.
     *
     * Fired when the user clicks on the detail button when type is `Detail`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDetailClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.CustomListItem` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:detailClick detailClick} event of this `sap.ui.webc.main.CustomListItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.CustomListItem` itself.
     *
     * Fired when the user clicks on the detail button when type is `Detail`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDetailClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.CustomListItem` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Destroys the deleteButton in the aggregation {@link #getDeleteButton deleteButton}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDeleteButton(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:detailClick detailClick} event of this `sap.ui.webc.main.CustomListItem`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDetailClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:detailClick detailClick} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDetailClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getAccessibilityAttributes accessibilityAttributes}.
     *
     * An object of strings that defines several additional accessibility attribute values for customization
     * depending on the use case.
     *
     * It supports the following fields:
     *
     *
     * 	 - `ariaSetsize`: Defines the number of items in the current set of listitems or treeitems when not
     *     all items in the set are present in the DOM. The value of each `aria-setsize` is an integer reflecting
     *     number of items in the complete set. **Note: ** If the size of the entire set is unknown, set `aria-setsize="-1"`.
     *
     * 	 - `ariaPosinset`: Defines an element's number or position in the current set of listitems or treeitems
     *     when not all items are present in the DOM. The value of each `aria-posinset` is an integer greater than
     *     or equal to 1, and less than or equal to the size of the set when that size is known.
     *
     * Default value is `{}`.
     *
     *
     * @returns Value of property `accessibilityAttributes`
     */
    getAccessibilityAttributes(): object;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the text alternative of the component. Note: If not provided a default text alternative will
     * be set, if present.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * Defines the content of the component.
     */
    getContent(): Control[];
    /**
     * Gets content of aggregation {@link #getDeleteButton deleteButton}.
     *
     * Defines the delete button, displayed in "Delete" mode. **Note:** While the slot allows custom buttons,
     * to match design guidelines, please use the `sap.ui.webc.main.Button` component. **Note:** When the slot
     * is not present, a built-in delete button will be displayed.
     */
    getDeleteButton(): IButton;
    /**
     * Gets current value of property {@link #getNavigated navigated}.
     *
     * The navigated state of the list item. If set to `true`, a navigation indicator is displayed at the end
     * of the list item.
     *
     *
     * @returns Value of property `navigated`
     */
    getNavigated(): boolean;
    /**
     * Gets current value of property {@link #getSelected selected}.
     *
     * Defines the selected state of the `ListItem`.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `selected`
     */
    getSelected(): boolean;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * Defines the visual indication and behavior of the list items. Available options are `Active` (by default),
     * `Inactive`, `Detail` and `Navigation`.
     *
     *  **Note:** When set to `Active` or `Navigation`, the item will provide visual response upon press and
     * hover, while with type `Inactive` and `Detail` - will not.
     *
     * Default value is `Active`.
     *
     *
     * @returns Value of property `type`
     */
    getType(): ListItemType | keyof typeof ListItemType;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContent content}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: Control
    ): int;
    /**
     * Inserts a content into the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: Control,
      /**
       * The `0`-based index the content should be inserted at; for a negative value of `iIndex`, the content
       * is inserted at position 0; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): Control[];
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | Control
    ): Control | null;
    /**
     * Sets a new value for property {@link #getAccessibilityAttributes accessibilityAttributes}.
     *
     * An object of strings that defines several additional accessibility attribute values for customization
     * depending on the use case.
     *
     * It supports the following fields:
     *
     *
     * 	 - `ariaSetsize`: Defines the number of items in the current set of listitems or treeitems when not
     *     all items in the set are present in the DOM. The value of each `aria-setsize` is an integer reflecting
     *     number of items in the complete set. **Note: ** If the size of the entire set is unknown, set `aria-setsize="-1"`.
     *
     * 	 - `ariaPosinset`: Defines an element's number or position in the current set of listitems or treeitems
     *     when not all items are present in the DOM. The value of each `aria-posinset` is an integer greater than
     *     or equal to 1, and less than or equal to the size of the set when that size is known.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `{}`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibilityAttributes(
      /**
       * New value for property `accessibilityAttributes`
       */
      oAccessibilityAttributes?: object
    ): this;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the text alternative of the component. Note: If not provided a default text alternative will
     * be set, if present.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName?: string
    ): this;
    /**
     * Sets the aggregated {@link #getDeleteButton deleteButton}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDeleteButton(
      /**
       * The deleteButton to set
       */
      oDeleteButton: IButton
    ): this;
    /**
     * Sets a new value for property {@link #getNavigated navigated}.
     *
     * The navigated state of the list item. If set to `true`, a navigation indicator is displayed at the end
     * of the list item.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNavigated(
      /**
       * New value for property `navigated`
       */
      bNavigated: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSelected selected}.
     *
     * Defines the selected state of the `ListItem`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelected(
      /**
       * New value for property `selected`
       */
      bSelected?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * Defines the visual indication and behavior of the list items. Available options are `Active` (by default),
     * `Inactive`, `Detail` and `Navigation`.
     *
     *  **Note:** When set to `Active` or `Navigation`, the item will provide visual response upon press and
     * hover, while with type `Inactive` and `Detail` - will not.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Active`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: ListItemType | keyof typeof ListItemType
    ): this;
  }
  /**
   * Describes the settings that can be provided to the CustomListItem constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $CustomListItemSettings extends $WebComponentSettings {
    /**
     * An object of strings that defines several additional accessibility attribute values for customization
     * depending on the use case.
     *
     * It supports the following fields:
     *
     *
     * 	 - `ariaSetsize`: Defines the number of items in the current set of listitems or treeitems when not
     *     all items in the set are present in the DOM. The value of each `aria-setsize` is an integer reflecting
     *     number of items in the complete set. **Note: ** If the size of the entire set is unknown, set `aria-setsize="-1"`.
     *
     * 	 - `ariaPosinset`: Defines an element's number or position in the current set of listitems or treeitems
     *     when not all items are present in the DOM. The value of each `aria-posinset` is an integer greater than
     *     or equal to 1, and less than or equal to the size of the set when that size is known.
     */
    accessibilityAttributes?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the text alternative of the component. Note: If not provided a default text alternative will
     * be set, if present.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * The navigated state of the list item. If set to `true`, a navigation indicator is displayed at the end
     * of the list item.
     */
    navigated?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the selected state of the `ListItem`.
     */
    selected?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the visual indication and behavior of the list items. Available options are `Active` (by default),
     * `Inactive`, `Detail` and `Navigation`.
     *
     *  **Note:** When set to `Active` or `Navigation`, the item will provide visual response upon press and
     * hover, while with type `Inactive` and `Detail` - will not.
     */
    type?:
      | (ListItemType | keyof typeof ListItemType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the content of the component.
     */
    content?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * Defines the delete button, displayed in "Delete" mode. **Note:** While the slot allows custom buttons,
     * to match design guidelines, please use the `sap.ui.webc.main.Button` component. **Note:** When the slot
     * is not present, a built-in delete button will be displayed.
     */
    deleteButton?: IButton;

    /**
     * Fired when the user clicks on the detail button when type is `Detail`.
     */
    detailClick?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the CustomListItem#detailClick event.
   */
  export interface CustomListItem$DetailClickEventParameters {}

  /**
   * Event object of the CustomListItem#detailClick event.
   */
  export type CustomListItem$DetailClickEvent = Event<
    CustomListItem$DetailClickEventParameters,
    CustomListItem
  >;
}

declare module "sap/ui/webc/main/DatePicker" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IFormContent, ID, ValueState, CSSSize } from "sap/ui/core/library";

  import Control from "sap/ui/core/Control";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import CalendarType from "sap/ui/core/CalendarType";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Overview:
   *
   * The `sap.ui.webc.main.DatePicker` component provides an input field with assigned calendar which opens
   * on user action. The `sap.ui.webc.main.DatePicker` allows users to select a localized date using touch,
   * mouse, or keyboard input. It consists of two parts: the date input field and the date picker.
   *
   * Usage:
   *
   * The user can enter a date by:
   * 	 - Using the calendar that opens in a popup
   * 	 - Typing it in directly in the input field
   *
   *  When the user makes an entry and presses the enter key, the calendar shows the corresponding date. When
   * the user directly triggers the calendar display, the actual date is displayed.
   *
   * Formatting:
   *
   * If a date is entered by typing it into the input field, it must fit to the used date format.
   *
   *  Supported format options are pattern-based on Unicode LDML Date Format notation. For more information,
   * see {@link http://unicode.org/reports/tr35/#Date_Field_Symbol_Table UTS #35: Unicode Locale Data Markup Language}.
   *
   *
   *  For example, if the `format-pattern` is "yyyy-MM-dd", a valid value string is "2015-07-30" and the same
   * is displayed in the input.
   *
   * Keyboard Handling: The `sap.ui.webc.main.DatePicker` provides advanced keyboard handling. If the `sap.ui.webc.main.DatePicker`
   * is focused, you can open or close the drop-down by pressing `F4`, `ALT+UP` or `ALT+DOWN` keys. Once the
   * drop-down is opened, you can use the `UP`, `DOWN`, `LEFT`, `RIGHT` arrow keys to navigate through the
   * dates and select one by pressing the `Space` or `Enter` keys. Moreover you can use TAB to reach the buttons
   * for changing month and year.
   *
   *
   * If the `sap.ui.webc.main.DatePicker` input field is focused and its corresponding picker dialog is not
   * opened, then users can increment or decrement the date referenced by `dateValue` property by using the
   * following shortcuts:
   *
   *
   *
   * 	 - [PAGEDOWN] - Decrements the corresponding day of the month by one
   * 	 - [SHIFT] + [PAGEDOWN] - Decrements the corresponding month by one
   * 	 - [SHIFT] + [CTRL] + [PAGEDOWN] - Decrements the corresponding year by one
   * 	 - [PAGEUP] - Increments the corresponding day of the month by one
   * 	 - [SHIFT] + [PAGEUP] - Increments the corresponding month by one
   * 	 - [SHIFT] + [CTRL] + [PAGEUP] - Increments the corresponding year by one
   *
   * Calendar types: The component supports several calendar types - Gregorian, Buddhist, Islamic, Japanese
   * and Persian. By default the Gregorian Calendar is used. In order to use the Buddhist, Islamic, Japanese
   * or Persian calendar, you need to set the `primaryCalendarType` property and import one or more of the
   * following modules:
   *
   *
   *
   * Or, you can use the global configuration and set the `calendarType` key:
   *
   * ```javascript
   * <script data-id="sap-ui-config" type="application/json">
   * {
   * 	"calendarType": "Japanese"
   * }
   * </script>```
   *
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class DatePicker extends WebComponent implements IFormContent {
    __implements__sap_ui_core_IFormContent: boolean;
    /**
     * Constructor for a new `DatePicker`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $DatePickerSettings
    );
    /**
     * Constructor for a new `DatePicker`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $DatePickerSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.DatePicker with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DatePicker>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.DatePicker.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.DatePicker`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.DatePicker` itself.
     *
     * Fired when the input operation has finished by pressing Enter or on focusout.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DatePicker$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.DatePicker` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.DatePicker`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.DatePicker` itself.
     *
     * Fired when the input operation has finished by pressing Enter or on focusout.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DatePicker$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.DatePicker` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:input input} event of this `sap.ui.webc.main.DatePicker`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.DatePicker` itself.
     *
     * Fired when the value of the component is changed at each key stroke.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInput(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DatePicker$InputEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.DatePicker` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:input input} event of this `sap.ui.webc.main.DatePicker`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.DatePicker` itself.
     *
     * Fired when the value of the component is changed at each key stroke.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInput(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DatePicker$InputEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.DatePicker` itself
       */
      oListener?: object
    ): this;
    /**
     * Closes the picker.
     */
    closePicker(): void;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:change change} event of this `sap.ui.webc.main.DatePicker`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: DatePicker$ChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:input input} event of this `sap.ui.webc.main.DatePicker`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInput(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: DatePicker$InputEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:change change} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: DatePicker$ChangeEventParameters
    ): boolean;
    /**
     * Fires event {@link #event:input input} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireInput(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: DatePicker$InputEventParameters
    ): boolean;
    /**
     * Formats a Java Script date object into a string representing a locale date according to the `formatPattern`
     * property of the DatePicker instance
     */
    formatValue(
      /**
       * A Java Script date object to be formatted as string
       */
      date: Date
    ): void;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the aria-label attribute for the component.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Returns the currently selected date represented as a Local JavaScript Date instance.
     */
    getDateValue(): void;
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getFormatPattern formatPattern}.
     *
     * Determines the format, displayed in the input field.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `formatPattern`
     */
    getFormatPattern(): string;
    /**
     * Gets current value of property {@link #getHideWeekNumbers hideWeekNumbers}.
     *
     * Defines the visibility of the week numbers column.
     *
     *
     *
     * **Note:** For calendars other than Gregorian, the week numbers are not displayed regardless of what is
     * set.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `hideWeekNumbers`
     */
    getHideWeekNumbers(): boolean;
    /**
     * Gets current value of property {@link #getMaxDate maxDate}.
     *
     * Determines the maximum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the maxDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `maxDate`
     */
    getMaxDate(): string;
    /**
     * Gets current value of property {@link #getMinDate minDate}.
     *
     * Determines the minimum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the minDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `minDate`
     */
    getMinDate(): string;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * Determines the name with which the component will be submitted in an HTML form.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form. Do not use this property unless you need to submit a form.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getPlaceholder placeholder}.
     *
     * Defines a short hint, intended to aid the user with data entry when the component has no value.
     *
     *
     *
     *  **Note:** When no placeholder is set, the format pattern is displayed as a placeholder. Passing an empty
     * string as the value of this property will make the component appear empty - without placeholder or format
     * pattern.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Value of property `placeholder`
     */
    getPlaceholder(): string;
    /**
     * Gets current value of property {@link #getPrimaryCalendarType primaryCalendarType}.
     *
     * Sets a calendar type used for display. If not set, the calendar type of the global configuration is used.
     *
     *
     * @returns Value of property `primaryCalendarType`
     */
    getPrimaryCalendarType(): CalendarType;
    /**
     * Gets current value of property {@link #getReadonly readonly}.
     *
     * Determines whether the component is displayed as read-only.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `readonly`
     */
    getReadonly(): boolean;
    /**
     * Gets current value of property {@link #getRequired required}.
     *
     * Defines whether the component is required.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `required`
     */
    getRequired(): boolean;
    /**
     * Gets current value of property {@link #getSecondaryCalendarType secondaryCalendarType}.
     *
     * Defines the secondary calendar type. If not set, the calendar will only show the primary calendar type.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Value of property `secondaryCalendarType`
     */
    getSecondaryCalendarType(): CalendarType;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * Defines a formatted date value.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): string;
    /**
     * Gets current value of property {@link #getValueState valueState}.
     *
     * Defines the value state of the component.
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `valueState`
     */
    getValueState(): ValueState | keyof typeof ValueState;
    /**
     * Gets current value of property {@link #getValueStateMessage valueStateMessage}.
     *
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `valueStateMessage`
     */
    getValueStateMessage(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks if a date is between the minimum and maximum date.
     */
    isInValidRange(
      /**
       * A value to be checked
       */
      value: string
    ): void;
    /**
     * Checks if the picker is open.
     */
    isOpen(): void;
    /**
     * Checks if a value is valid against the current date format of the DatePicker.
     */
    isValid(
      /**
       * A value to be tested against the current date format
       */
      value: string
    ): void;
    /**
     * Opens the picker.
     */
    openPicker(): void;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the aria-label attribute for the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getFormatPattern formatPattern}.
     *
     * Determines the format, displayed in the input field.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFormatPattern(
      /**
       * New value for property `formatPattern`
       */
      sFormatPattern?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHideWeekNumbers hideWeekNumbers}.
     *
     * Defines the visibility of the week numbers column.
     *
     *
     *
     * **Note:** For calendars other than Gregorian, the week numbers are not displayed regardless of what is
     * set.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideWeekNumbers(
      /**
       * New value for property `hideWeekNumbers`
       */
      bHideWeekNumbers?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getMaxDate maxDate}.
     *
     * Determines the maximum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the maxDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxDate(
      /**
       * New value for property `maxDate`
       */
      sMaxDate?: string
    ): this;
    /**
     * Sets a new value for property {@link #getMinDate minDate}.
     *
     * Determines the minimum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the minDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMinDate(
      /**
       * New value for property `minDate`
       */
      sMinDate?: string
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * Determines the name with which the component will be submitted in an HTML form.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form. Do not use this property unless you need to submit a form.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getPlaceholder placeholder}.
     *
     * Defines a short hint, intended to aid the user with data entry when the component has no value.
     *
     *
     *
     *  **Note:** When no placeholder is set, the format pattern is displayed as a placeholder. Passing an empty
     * string as the value of this property will make the component appear empty - without placeholder or format
     * pattern.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlaceholder(
      /**
       * New value for property `placeholder`
       */
      sPlaceholder?: string
    ): this;
    /**
     * Sets a new value for property {@link #getPrimaryCalendarType primaryCalendarType}.
     *
     * Sets a calendar type used for display. If not set, the calendar type of the global configuration is used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPrimaryCalendarType(
      /**
       * New value for property `primaryCalendarType`
       */
      sPrimaryCalendarType: CalendarType
    ): this;
    /**
     * Sets a new value for property {@link #getReadonly readonly}.
     *
     * Determines whether the component is displayed as read-only.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setReadonly(
      /**
       * New value for property `readonly`
       */
      bReadonly?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getRequired required}.
     *
     * Defines whether the component is required.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRequired(
      /**
       * New value for property `required`
       */
      bRequired?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSecondaryCalendarType secondaryCalendarType}.
     *
     * Defines the secondary calendar type. If not set, the calendar will only show the primary calendar type.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSecondaryCalendarType(
      /**
       * New value for property `secondaryCalendarType`
       */
      sSecondaryCalendarType?: CalendarType
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * Defines a formatted date value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      sValue?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValueState valueState}.
     *
     * Defines the value state of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueState(
      /**
       * New value for property `valueState`
       */
      sValueState?: ValueState | keyof typeof ValueState
    ): this;
    /**
     * Sets a new value for property {@link #getValueStateMessage valueStateMessage}.
     *
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueStateMessage(
      /**
       * New value for property `valueStateMessage`
       */
      sValueStateMessage?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DatePicker constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $DatePickerSettings extends $WebComponentSettings {
    /**
     * Defines the aria-label attribute for the component.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines the format, displayed in the input field.
     */
    formatPattern?: string | PropertyBindingInfo;

    /**
     * Defines the visibility of the week numbers column.
     *
     *
     *
     * **Note:** For calendars other than Gregorian, the week numbers are not displayed regardless of what is
     * set.
     */
    hideWeekNumbers?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines the maximum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the maxDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     */
    maxDate?: string | PropertyBindingInfo;

    /**
     * Determines the minimum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the minDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     */
    minDate?: string | PropertyBindingInfo;

    /**
     * Determines the name with which the component will be submitted in an HTML form.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form. Do not use this property unless you need to submit a form.
     */
    name?: string | PropertyBindingInfo;

    /**
     * Defines a short hint, intended to aid the user with data entry when the component has no value.
     *
     *
     *
     *  **Note:** When no placeholder is set, the format pattern is displayed as a placeholder. Passing an empty
     * string as the value of this property will make the component appear empty - without placeholder or format
     * pattern.
     */
    placeholder?: string | PropertyBindingInfo;

    /**
     * Sets a calendar type used for display. If not set, the calendar type of the global configuration is used.
     */
    primaryCalendarType?: CalendarType | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the component is displayed as read-only.
     */
    readonly?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the component is required.
     */
    required?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the secondary calendar type. If not set, the calendar will only show the primary calendar type.
     */
    secondaryCalendarType?: CalendarType | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines a formatted date value.
     */
    value?: string | PropertyBindingInfo;

    /**
     * Defines the value state of the component.
     */
    valueState?:
      | (ValueState | keyof typeof ValueState)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     */
    valueStateMessage?: string | PropertyBindingInfo;

    /**
     * Defines the width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Receives id(or many ids) of the controls that label this control.
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Fired when the input operation has finished by pressing Enter or on focusout.
     */
    change?: (oEvent: DatePicker$ChangeEvent) => void;

    /**
     * Fired when the value of the component is changed at each key stroke.
     */
    input?: (oEvent: DatePicker$InputEvent) => void;
  }

  /**
   * Parameters of the DatePicker#change event.
   */
  export interface DatePicker$ChangeEventParameters {
    /**
     * The submitted value.
     */
    value?: string;

    /**
     * Indicator if the value is in correct format pattern and in valid range.
     */
    valid?: boolean;
  }

  /**
   * Event object of the DatePicker#change event.
   */
  export type DatePicker$ChangeEvent = Event<
    DatePicker$ChangeEventParameters,
    DatePicker
  >;

  /**
   * Parameters of the DatePicker#input event.
   */
  export interface DatePicker$InputEventParameters {
    /**
     * The submitted value.
     */
    value?: string;

    /**
     * Indicator if the value is in correct format pattern and in valid range.
     */
    valid?: boolean;
  }

  /**
   * Event object of the DatePicker#input event.
   */
  export type DatePicker$InputEvent = Event<
    DatePicker$InputEventParameters,
    DatePicker
  >;
}

declare module "sap/ui/webc/main/DateRangePicker" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IFormContent, ID, ValueState, CSSSize } from "sap/ui/core/library";

  import Control from "sap/ui/core/Control";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import CalendarType from "sap/ui/core/CalendarType";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Overview: The DateRangePicker enables the users to enter a localized date range using touch, mouse, keyboard
   * input, or by selecting a date range in the calendar.
   *
   * Keyboard Handling: The `sap.ui.webc.main.DateRangePicker` provides advanced keyboard handling.
   *
   *
   * When the `sap.ui.webc.main.DateRangePicker` input field is focused the user can increment or decrement
   * respectively the range start or end date, depending on where the cursor is. The following shortcuts are
   * available:
   *
   *
   *
   * 	 - [PAGEDOWN] - Decrements the corresponding day of the month by one
   * 	 - [SHIFT] + [PAGEDOWN] - Decrements the corresponding month by one
   * 	 - [SHIFT] + [CTRL] + [PAGEDOWN] - Decrements the corresponding year by one
   * 	 - [PAGEUP] - Increments the corresponding day of the month by one
   * 	 - [SHIFT] + [PAGEUP] - Increments the corresponding month by one
   * 	 - [SHIFT] + [CTRL] + [PAGEUP] - Increments the corresponding year by one
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class DateRangePicker
    extends WebComponent
    implements IFormContent {
    __implements__sap_ui_core_IFormContent: boolean;
    /**
     * Constructor for a new `DateRangePicker`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $DateRangePickerSettings
    );
    /**
     * Constructor for a new `DateRangePicker`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $DateRangePickerSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.DateRangePicker with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DateRangePicker>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.DateRangePicker.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.DateRangePicker`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.DateRangePicker` itself.
     *
     * Fired when the input operation has finished by pressing Enter or on focusout.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DateRangePicker$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.DateRangePicker` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.DateRangePicker`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.DateRangePicker` itself.
     *
     * Fired when the input operation has finished by pressing Enter or on focusout.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DateRangePicker$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.DateRangePicker` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:input input} event of this `sap.ui.webc.main.DateRangePicker`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.DateRangePicker` itself.
     *
     * Fired when the value of the component is changed at each key stroke.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInput(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DateRangePicker$InputEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.DateRangePicker` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:input input} event of this `sap.ui.webc.main.DateRangePicker`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.DateRangePicker` itself.
     *
     * Fired when the value of the component is changed at each key stroke.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInput(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DateRangePicker$InputEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.DateRangePicker` itself
       */
      oListener?: object
    ): this;
    /**
     * Closes the picker.
     */
    closePicker(): void;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:change change} event of this `sap.ui.webc.main.DateRangePicker`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: DateRangePicker$ChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:input input} event of this `sap.ui.webc.main.DateRangePicker`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInput(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: DateRangePicker$InputEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:change change} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: DateRangePicker$ChangeEventParameters
    ): boolean;
    /**
     * Fires event {@link #event:input input} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireInput(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: DateRangePicker$InputEventParameters
    ): boolean;
    /**
     * Formats a Java Script date object into a string representing a locale date according to the `formatPattern`
     * property of the DatePicker instance
     */
    formatValue(
      /**
       * A Java Script date object to be formatted as string
       */
      date: Date
    ): void;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the aria-label attribute for the component.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Returns the **Note:** The getter method is inherited and not supported. If called it will return an empty
     * value.
     */
    getDateValue(): void;
    /**
     * Returns the **Note:** The getter method is inherited and not supported. If called it will return an empty
     * value.
     */
    getDateValueUTC(): void;
    /**
     * Gets current value of property {@link #getDelimiter delimiter}.
     *
     * Determines the symbol which separates the dates. If not supplied, the default time interval delimiter
     * for the current locale will be used.
     *
     * Default value is `"-"`.
     *
     *
     * @returns Value of property `delimiter`
     */
    getDelimiter(): string;
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Returns the end date of the currently selected range as JavaScript Date instance.
     */
    getEndDateValue(): void;
    /**
     * Gets current value of property {@link #getFormatPattern formatPattern}.
     *
     * Determines the format, displayed in the input field.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `formatPattern`
     */
    getFormatPattern(): string;
    /**
     * Gets current value of property {@link #getHideWeekNumbers hideWeekNumbers}.
     *
     * Defines the visibility of the week numbers column.
     *
     *
     *
     * **Note:** For calendars other than Gregorian, the week numbers are not displayed regardless of what is
     * set.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `hideWeekNumbers`
     */
    getHideWeekNumbers(): boolean;
    /**
     * Gets current value of property {@link #getMaxDate maxDate}.
     *
     * Determines the maximum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the maxDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `maxDate`
     */
    getMaxDate(): string;
    /**
     * Gets current value of property {@link #getMinDate minDate}.
     *
     * Determines the minimum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the minDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `minDate`
     */
    getMinDate(): string;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * Determines the name with which the component will be submitted in an HTML form.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form. Do not use this property unless you need to submit a form.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getPlaceholder placeholder}.
     *
     * Defines a short hint, intended to aid the user with data entry when the component has no value.
     *
     *
     *
     *  **Note:** When no placeholder is set, the format pattern is displayed as a placeholder. Passing an empty
     * string as the value of this property will make the component appear empty - without placeholder or format
     * pattern.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Value of property `placeholder`
     */
    getPlaceholder(): string;
    /**
     * Gets current value of property {@link #getPrimaryCalendarType primaryCalendarType}.
     *
     * Sets a calendar type used for display. If not set, the calendar type of the global configuration is used.
     *
     *
     * @returns Value of property `primaryCalendarType`
     */
    getPrimaryCalendarType(): CalendarType;
    /**
     * Gets current value of property {@link #getReadonly readonly}.
     *
     * Determines whether the component is displayed as read-only.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `readonly`
     */
    getReadonly(): boolean;
    /**
     * Gets current value of property {@link #getRequired required}.
     *
     * Defines whether the component is required.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `required`
     */
    getRequired(): boolean;
    /**
     * Gets current value of property {@link #getSecondaryCalendarType secondaryCalendarType}.
     *
     * Defines the secondary calendar type. If not set, the calendar will only show the primary calendar type.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Value of property `secondaryCalendarType`
     */
    getSecondaryCalendarType(): CalendarType;
    /**
     * Returns the start date of the currently selected range as JavaScript Date instance.
     */
    getStartDateValue(): void;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * Defines a formatted date value.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): string;
    /**
     * Gets current value of property {@link #getValueState valueState}.
     *
     * Defines the value state of the component.
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `valueState`
     */
    getValueState(): ValueState | keyof typeof ValueState;
    /**
     * Gets current value of property {@link #getValueStateMessage valueStateMessage}.
     *
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `valueStateMessage`
     */
    getValueStateMessage(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks if a date is between the minimum and maximum date.
     */
    isInValidRange(
      /**
       * A value to be checked
       */
      value: string
    ): void;
    /**
     * Checks if the picker is open.
     */
    isOpen(): void;
    /**
     * Checks if a value is valid against the current date format of the DatePicker.
     */
    isValid(
      /**
       * A value to be tested against the current date format
       */
      value: string
    ): void;
    /**
     * Opens the picker.
     */
    openPicker(): void;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the aria-label attribute for the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDelimiter delimiter}.
     *
     * Determines the symbol which separates the dates. If not supplied, the default time interval delimiter
     * for the current locale will be used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"-"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDelimiter(
      /**
       * New value for property `delimiter`
       */
      sDelimiter?: string
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getFormatPattern formatPattern}.
     *
     * Determines the format, displayed in the input field.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFormatPattern(
      /**
       * New value for property `formatPattern`
       */
      sFormatPattern?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHideWeekNumbers hideWeekNumbers}.
     *
     * Defines the visibility of the week numbers column.
     *
     *
     *
     * **Note:** For calendars other than Gregorian, the week numbers are not displayed regardless of what is
     * set.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideWeekNumbers(
      /**
       * New value for property `hideWeekNumbers`
       */
      bHideWeekNumbers?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getMaxDate maxDate}.
     *
     * Determines the maximum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the maxDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxDate(
      /**
       * New value for property `maxDate`
       */
      sMaxDate?: string
    ): this;
    /**
     * Sets a new value for property {@link #getMinDate minDate}.
     *
     * Determines the minimum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the minDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMinDate(
      /**
       * New value for property `minDate`
       */
      sMinDate?: string
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * Determines the name with which the component will be submitted in an HTML form.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form. Do not use this property unless you need to submit a form.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getPlaceholder placeholder}.
     *
     * Defines a short hint, intended to aid the user with data entry when the component has no value.
     *
     *
     *
     *  **Note:** When no placeholder is set, the format pattern is displayed as a placeholder. Passing an empty
     * string as the value of this property will make the component appear empty - without placeholder or format
     * pattern.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlaceholder(
      /**
       * New value for property `placeholder`
       */
      sPlaceholder?: string
    ): this;
    /**
     * Sets a new value for property {@link #getPrimaryCalendarType primaryCalendarType}.
     *
     * Sets a calendar type used for display. If not set, the calendar type of the global configuration is used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPrimaryCalendarType(
      /**
       * New value for property `primaryCalendarType`
       */
      sPrimaryCalendarType: CalendarType
    ): this;
    /**
     * Sets a new value for property {@link #getReadonly readonly}.
     *
     * Determines whether the component is displayed as read-only.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setReadonly(
      /**
       * New value for property `readonly`
       */
      bReadonly?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getRequired required}.
     *
     * Defines whether the component is required.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRequired(
      /**
       * New value for property `required`
       */
      bRequired?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSecondaryCalendarType secondaryCalendarType}.
     *
     * Defines the secondary calendar type. If not set, the calendar will only show the primary calendar type.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSecondaryCalendarType(
      /**
       * New value for property `secondaryCalendarType`
       */
      sSecondaryCalendarType?: CalendarType
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * Defines a formatted date value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      sValue?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValueState valueState}.
     *
     * Defines the value state of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueState(
      /**
       * New value for property `valueState`
       */
      sValueState?: ValueState | keyof typeof ValueState
    ): this;
    /**
     * Sets a new value for property {@link #getValueStateMessage valueStateMessage}.
     *
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueStateMessage(
      /**
       * New value for property `valueStateMessage`
       */
      sValueStateMessage?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DateRangePicker constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $DateRangePickerSettings extends $WebComponentSettings {
    /**
     * Defines the aria-label attribute for the component.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * Determines the symbol which separates the dates. If not supplied, the default time interval delimiter
     * for the current locale will be used.
     */
    delimiter?: string | PropertyBindingInfo;

    /**
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines the format, displayed in the input field.
     */
    formatPattern?: string | PropertyBindingInfo;

    /**
     * Defines the visibility of the week numbers column.
     *
     *
     *
     * **Note:** For calendars other than Gregorian, the week numbers are not displayed regardless of what is
     * set.
     */
    hideWeekNumbers?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines the maximum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the maxDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     */
    maxDate?: string | PropertyBindingInfo;

    /**
     * Determines the minimum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the minDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     */
    minDate?: string | PropertyBindingInfo;

    /**
     * Determines the name with which the component will be submitted in an HTML form.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form. Do not use this property unless you need to submit a form.
     */
    name?: string | PropertyBindingInfo;

    /**
     * Defines a short hint, intended to aid the user with data entry when the component has no value.
     *
     *
     *
     *  **Note:** When no placeholder is set, the format pattern is displayed as a placeholder. Passing an empty
     * string as the value of this property will make the component appear empty - without placeholder or format
     * pattern.
     */
    placeholder?: string | PropertyBindingInfo;

    /**
     * Sets a calendar type used for display. If not set, the calendar type of the global configuration is used.
     */
    primaryCalendarType?: CalendarType | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the component is displayed as read-only.
     */
    readonly?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the component is required.
     */
    required?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the secondary calendar type. If not set, the calendar will only show the primary calendar type.
     */
    secondaryCalendarType?: CalendarType | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines a formatted date value.
     */
    value?: string | PropertyBindingInfo;

    /**
     * Defines the value state of the component.
     */
    valueState?:
      | (ValueState | keyof typeof ValueState)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     */
    valueStateMessage?: string | PropertyBindingInfo;

    /**
     * Defines the width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Receives id(or many ids) of the controls that label this control.
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Fired when the input operation has finished by pressing Enter or on focusout.
     */
    change?: (oEvent: DateRangePicker$ChangeEvent) => void;

    /**
     * Fired when the value of the component is changed at each key stroke.
     */
    input?: (oEvent: DateRangePicker$InputEvent) => void;
  }

  /**
   * Parameters of the DateRangePicker#change event.
   */
  export interface DateRangePicker$ChangeEventParameters {
    /**
     * The submitted value.
     */
    value?: string;

    /**
     * Indicator if the value is in correct format pattern and in valid range.
     */
    valid?: boolean;
  }

  /**
   * Event object of the DateRangePicker#change event.
   */
  export type DateRangePicker$ChangeEvent = Event<
    DateRangePicker$ChangeEventParameters,
    DateRangePicker
  >;

  /**
   * Parameters of the DateRangePicker#input event.
   */
  export interface DateRangePicker$InputEventParameters {
    /**
     * The submitted value.
     */
    value?: string;

    /**
     * Indicator if the value is in correct format pattern and in valid range.
     */
    valid?: boolean;
  }

  /**
   * Event object of the DateRangePicker#input event.
   */
  export type DateRangePicker$InputEvent = Event<
    DateRangePicker$InputEventParameters,
    DateRangePicker
  >;
}

declare module "sap/ui/webc/main/DateTimePicker" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IFormContent, ID, ValueState, CSSSize } from "sap/ui/core/library";

  import Control from "sap/ui/core/Control";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import CalendarType from "sap/ui/core/CalendarType";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Overview: The `DateTimePicker` component alows users to select both date (day, month and year) and time
   * (hours, minutes and seconds) and for the purpose it consists of input field and Date/Time picker.
   *
   * Usage:
   *
   * Use the `DateTimePicker` if you need a combined date and time input component. Don't use it if you want
   * to use either date, or time value. In this case, use the `DatePicker` or the `TimePicker` components
   * instead.
   *
   *  The user can set date/time by:
   * 	 - using the calendar and the time selectors
   * 	 - typing in the input field
   *
   * Programmatically, to set date/time for the `DateTimePicker`, use the `value` property
   *
   * Formatting:
   *
   * The value entered by typing into the input field must fit to the used date/time format.
   *
   *  Supported format options are pattern-based on Unicode LDML Date Format notation. For more information,
   * see {@link https://unicode.org/reports/tr35/tr35-dates.html#Date_Field_Symbol_Table UTS #35: Unicode Locale Data Markup Language}.
   *
   *
   *  **Example:** the following format `dd/MM/yyyy, hh:mm:ss aa` corresponds the `13/04/2020, 03:16:16 AM`
   * value.
   *  The small 'h' defines "12" hours format and the "aa" symbols - "AM/PM" time periods.
   *
   *
   *
   *  **Example:** the following format `dd/MM/yyyy, HH:mm:ss` corresponds the `13/04/2020, 15:16:16` value.
   *
   *  The capital 'H' indicates "24" hours format.
   *
   *
   *
   *  **Note:** If the `formatPattern` does NOT include time, the `DateTimePicker` will fallback to the default
   * time format according to the locale.
   *
   *
   *
   *  **Note:** If no placeholder is set to the `DateTimePicker`, the current `formatPattern` is displayed
   * as a placeholder. If another placeholder is needed, it must be set or in case no placeholder is needed
   * - it can be set to an empty string.
   *
   *
   *
   *  **Note:** If the user input does NOT match the `formatPattern`, the `DateTimePicker` makes an attempt
   * to parse it based on the locale settings.
   *
   * Responsive behavior:
   *
   * The `DateTimePicker` is responsive and fully adapts to all devices. For larger screens, such as tablet
   * or desktop, it is displayed as a popover, while on phone devices, it is displayed full screen.
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class DateTimePicker
    extends WebComponent
    implements IFormContent {
    __implements__sap_ui_core_IFormContent: boolean;
    /**
     * Constructor for a new `DateTimePicker`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $DateTimePickerSettings
    );
    /**
     * Constructor for a new `DateTimePicker`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $DateTimePickerSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.DateTimePicker with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DateTimePicker>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.DateTimePicker.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.DateTimePicker`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.DateTimePicker` itself.
     *
     * Fired when the input operation has finished by pressing Enter or on focusout.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DateTimePicker$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.DateTimePicker` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.DateTimePicker`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.DateTimePicker` itself.
     *
     * Fired when the input operation has finished by pressing Enter or on focusout.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DateTimePicker$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.DateTimePicker` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:input input} event of this `sap.ui.webc.main.DateTimePicker`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.DateTimePicker` itself.
     *
     * Fired when the value of the component is changed at each key stroke.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInput(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DateTimePicker$InputEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.DateTimePicker` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:input input} event of this `sap.ui.webc.main.DateTimePicker`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.DateTimePicker` itself.
     *
     * Fired when the value of the component is changed at each key stroke.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInput(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DateTimePicker$InputEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.DateTimePicker` itself
       */
      oListener?: object
    ): this;
    /**
     * Closes the picker.
     */
    closePicker(): void;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:change change} event of this `sap.ui.webc.main.DateTimePicker`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: DateTimePicker$ChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:input input} event of this `sap.ui.webc.main.DateTimePicker`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInput(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: DateTimePicker$InputEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:change change} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: DateTimePicker$ChangeEventParameters
    ): boolean;
    /**
     * Fires event {@link #event:input input} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireInput(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: DateTimePicker$InputEventParameters
    ): boolean;
    /**
     * Formats a Java Script date object into a string representing a locale date according to the `formatPattern`
     * property of the DatePicker instance
     */
    formatValue(
      /**
       * A Java Script date object to be formatted as string
       */
      date: Date
    ): void;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the aria-label attribute for the component.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Returns the currently selected date represented as a Local JavaScript Date instance.
     */
    getDateValue(): void;
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getFormatPattern formatPattern}.
     *
     * Determines the format, displayed in the input field.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `formatPattern`
     */
    getFormatPattern(): string;
    /**
     * Gets current value of property {@link #getHideWeekNumbers hideWeekNumbers}.
     *
     * Defines the visibility of the week numbers column.
     *
     *
     *
     * **Note:** For calendars other than Gregorian, the week numbers are not displayed regardless of what is
     * set.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `hideWeekNumbers`
     */
    getHideWeekNumbers(): boolean;
    /**
     * Gets current value of property {@link #getMaxDate maxDate}.
     *
     * Determines the maximum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the maxDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `maxDate`
     */
    getMaxDate(): string;
    /**
     * Gets current value of property {@link #getMinDate minDate}.
     *
     * Determines the minimum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the minDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `minDate`
     */
    getMinDate(): string;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * Determines the name with which the component will be submitted in an HTML form.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form. Do not use this property unless you need to submit a form.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getPlaceholder placeholder}.
     *
     * Defines a short hint, intended to aid the user with data entry when the component has no value.
     *
     *
     *
     *  **Note:** When no placeholder is set, the format pattern is displayed as a placeholder. Passing an empty
     * string as the value of this property will make the component appear empty - without placeholder or format
     * pattern.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Value of property `placeholder`
     */
    getPlaceholder(): string;
    /**
     * Gets current value of property {@link #getPrimaryCalendarType primaryCalendarType}.
     *
     * Sets a calendar type used for display. If not set, the calendar type of the global configuration is used.
     *
     *
     * @returns Value of property `primaryCalendarType`
     */
    getPrimaryCalendarType(): CalendarType;
    /**
     * Gets current value of property {@link #getReadonly readonly}.
     *
     * Determines whether the component is displayed as read-only.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `readonly`
     */
    getReadonly(): boolean;
    /**
     * Gets current value of property {@link #getRequired required}.
     *
     * Defines whether the component is required.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `required`
     */
    getRequired(): boolean;
    /**
     * Gets current value of property {@link #getSecondaryCalendarType secondaryCalendarType}.
     *
     * Defines the secondary calendar type. If not set, the calendar will only show the primary calendar type.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Value of property `secondaryCalendarType`
     */
    getSecondaryCalendarType(): CalendarType;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * Defines a formatted date value.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): string;
    /**
     * Gets current value of property {@link #getValueState valueState}.
     *
     * Defines the value state of the component.
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `valueState`
     */
    getValueState(): ValueState | keyof typeof ValueState;
    /**
     * Gets current value of property {@link #getValueStateMessage valueStateMessage}.
     *
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `valueStateMessage`
     */
    getValueStateMessage(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks if a date is between the minimum and maximum date.
     */
    isInValidRange(
      /**
       * A value to be checked
       */
      value: string
    ): void;
    /**
     * Checks if the picker is open.
     */
    isOpen(): void;
    /**
     * Checks if a value is valid against the current date format of the DatePicker.
     */
    isValid(
      /**
       * A value to be tested against the current date format
       */
      value: string
    ): void;
    /**
     * Opens the picker.
     */
    openPicker(): void;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the aria-label attribute for the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getFormatPattern formatPattern}.
     *
     * Determines the format, displayed in the input field.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFormatPattern(
      /**
       * New value for property `formatPattern`
       */
      sFormatPattern?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHideWeekNumbers hideWeekNumbers}.
     *
     * Defines the visibility of the week numbers column.
     *
     *
     *
     * **Note:** For calendars other than Gregorian, the week numbers are not displayed regardless of what is
     * set.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideWeekNumbers(
      /**
       * New value for property `hideWeekNumbers`
       */
      bHideWeekNumbers?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getMaxDate maxDate}.
     *
     * Determines the maximum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the maxDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxDate(
      /**
       * New value for property `maxDate`
       */
      sMaxDate?: string
    ): this;
    /**
     * Sets a new value for property {@link #getMinDate minDate}.
     *
     * Determines the minimum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the minDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMinDate(
      /**
       * New value for property `minDate`
       */
      sMinDate?: string
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * Determines the name with which the component will be submitted in an HTML form.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form. Do not use this property unless you need to submit a form.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getPlaceholder placeholder}.
     *
     * Defines a short hint, intended to aid the user with data entry when the component has no value.
     *
     *
     *
     *  **Note:** When no placeholder is set, the format pattern is displayed as a placeholder. Passing an empty
     * string as the value of this property will make the component appear empty - without placeholder or format
     * pattern.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlaceholder(
      /**
       * New value for property `placeholder`
       */
      sPlaceholder?: string
    ): this;
    /**
     * Sets a new value for property {@link #getPrimaryCalendarType primaryCalendarType}.
     *
     * Sets a calendar type used for display. If not set, the calendar type of the global configuration is used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPrimaryCalendarType(
      /**
       * New value for property `primaryCalendarType`
       */
      sPrimaryCalendarType: CalendarType
    ): this;
    /**
     * Sets a new value for property {@link #getReadonly readonly}.
     *
     * Determines whether the component is displayed as read-only.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setReadonly(
      /**
       * New value for property `readonly`
       */
      bReadonly?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getRequired required}.
     *
     * Defines whether the component is required.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRequired(
      /**
       * New value for property `required`
       */
      bRequired?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSecondaryCalendarType secondaryCalendarType}.
     *
     * Defines the secondary calendar type. If not set, the calendar will only show the primary calendar type.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSecondaryCalendarType(
      /**
       * New value for property `secondaryCalendarType`
       */
      sSecondaryCalendarType?: CalendarType
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * Defines a formatted date value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      sValue?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValueState valueState}.
     *
     * Defines the value state of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueState(
      /**
       * New value for property `valueState`
       */
      sValueState?: ValueState | keyof typeof ValueState
    ): this;
    /**
     * Sets a new value for property {@link #getValueStateMessage valueStateMessage}.
     *
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueStateMessage(
      /**
       * New value for property `valueStateMessage`
       */
      sValueStateMessage?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DateTimePicker constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $DateTimePickerSettings extends $WebComponentSettings {
    /**
     * Defines the aria-label attribute for the component.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines the format, displayed in the input field.
     */
    formatPattern?: string | PropertyBindingInfo;

    /**
     * Defines the visibility of the week numbers column.
     *
     *
     *
     * **Note:** For calendars other than Gregorian, the week numbers are not displayed regardless of what is
     * set.
     */
    hideWeekNumbers?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines the maximum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the maxDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     */
    maxDate?: string | PropertyBindingInfo;

    /**
     * Determines the minimum date available for selection.
     *
     * **Note:** If the formatPattern property is not set, the minDate value must be provided in the ISO date
     * format (YYYY-MM-dd).
     */
    minDate?: string | PropertyBindingInfo;

    /**
     * Determines the name with which the component will be submitted in an HTML form.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form. Do not use this property unless you need to submit a form.
     */
    name?: string | PropertyBindingInfo;

    /**
     * Defines a short hint, intended to aid the user with data entry when the component has no value.
     *
     *
     *
     *  **Note:** When no placeholder is set, the format pattern is displayed as a placeholder. Passing an empty
     * string as the value of this property will make the component appear empty - without placeholder or format
     * pattern.
     */
    placeholder?: string | PropertyBindingInfo;

    /**
     * Sets a calendar type used for display. If not set, the calendar type of the global configuration is used.
     */
    primaryCalendarType?: CalendarType | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the component is displayed as read-only.
     */
    readonly?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the component is required.
     */
    required?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the secondary calendar type. If not set, the calendar will only show the primary calendar type.
     */
    secondaryCalendarType?: CalendarType | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines a formatted date value.
     */
    value?: string | PropertyBindingInfo;

    /**
     * Defines the value state of the component.
     */
    valueState?:
      | (ValueState | keyof typeof ValueState)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     */
    valueStateMessage?: string | PropertyBindingInfo;

    /**
     * Defines the width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Receives id(or many ids) of the controls that label this control.
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Fired when the input operation has finished by pressing Enter or on focusout.
     */
    change?: (oEvent: DateTimePicker$ChangeEvent) => void;

    /**
     * Fired when the value of the component is changed at each key stroke.
     */
    input?: (oEvent: DateTimePicker$InputEvent) => void;
  }

  /**
   * Parameters of the DateTimePicker#change event.
   */
  export interface DateTimePicker$ChangeEventParameters {
    /**
     * The submitted value.
     */
    value?: string;

    /**
     * Indicator if the value is in correct format pattern and in valid range.
     */
    valid?: boolean;
  }

  /**
   * Event object of the DateTimePicker#change event.
   */
  export type DateTimePicker$ChangeEvent = Event<
    DateTimePicker$ChangeEventParameters,
    DateTimePicker
  >;

  /**
   * Parameters of the DateTimePicker#input event.
   */
  export interface DateTimePicker$InputEventParameters {
    /**
     * The submitted value.
     */
    value?: string;

    /**
     * Indicator if the value is in correct format pattern and in valid range.
     */
    valid?: boolean;
  }

  /**
   * Event object of the DateTimePicker#input event.
   */
  export type DateTimePicker$InputEvent = Event<
    DateTimePicker$InputEventParameters,
    DateTimePicker
  >;
}

declare module "sap/ui/webc/main/Dialog" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { ID, CSSSize, ValueState } from "sap/ui/core/library";

  import Control from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import { PopupAccessibleRole } from "sap/ui/webc/main/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Overview: The `sap.ui.webc.main.Dialog` component is used to temporarily display some information in
   * a size-limited window in front of the regular app screen. It is used to prompt the user for an action
   * or a confirmation. The `sap.ui.webc.main.Dialog` interrupts the current app processing as it is the only
   * focused UI element and the main screen is dimmed/blocked. The dialog combines concepts known from other
   * technologies where the windows have names such as dialog box, dialog window, pop-up, pop-up window, alert
   * box, or message box.
   *
   *  The `sap.ui.webc.main.Dialog` is modal, which means that an user action is required before it is possible
   * to return to the parent window. To open multiple dialogs, each dialog element should be separate in the
   * markup. This will ensure the correct modal behavior. Avoid nesting dialogs within each other. The content
   * of the `sap.ui.webc.main.Dialog` is fully customizable.
   *
   * Structure: A `sap.ui.webc.main.Dialog` consists of a header, content, and a footer for action buttons.
   * The `sap.ui.webc.main.Dialog` is usually displayed at the center of the screen. Its position can be changed
   * by the user. To enable this, you need to set the property `draggable` accordingly.
   *
   * Responsive Behavior: The `stretch` property can be used to stretch the `sap.ui.webc.main.Dialog` on full
   * screen.
   *
   * CSS Shadow Parts:
   *
   * {@link https://developer.mozilla.org/en-US/docs/Web/CSS/::part CSS Shadow Parts} allow developers to
   * style elements inside the Shadow DOM.
   *  The `sap.ui.webc.main.Dialog` exposes the following CSS Shadow Parts:
   * 	 - header - Used to style the header of the component
   * 	 - content - Used to style the content of the component
   * 	 - footer - Used to style the footer of the component  **Note:** When a `ui5-bar` is used in the
   *     header or in the footer, you should remove the default dialog's paddings.
   *  For more information see the sample "Bar in Header/Footer".
   *
   * **Note:** We don't recommend nesting popup-like components (`sap.ui.webc.main.Dialog`, `sap.ui.webc.main.Popover`)
   * inside `sap.ui.webc.main.Dialog`. Ideally you should create all popups on the same level inside your
   * HTML page and just open them from one another, rather than nesting them.
   *
   * **Note:** We don't recommend nesting popup-like components (`sap.ui.webc.main.Dialog`, `sap.ui.webc.main.Popover`)
   * inside other components containing z-index. This might break z-index management.
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class Dialog extends WebComponent {
    /**
     * Constructor for a new `Dialog`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $DialogSettings
    );
    /**
     * Constructor for a new `Dialog`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $DialogSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.Dialog with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Dialog>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.Dialog.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some content to the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted
       */
      oContent: Control
    ): this;
    /**
     * Adds some footer to the aggregation {@link #getFooter footer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addFooter(
      /**
       * The footer to add; if empty, nothing is inserted
       */
      oFooter: Control
    ): this;
    /**
     * Adds some header to the aggregation {@link #getHeader header}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addHeader(
      /**
       * The header to add; if empty, nothing is inserted
       */
      oHeader: Control
    ): this;
    /**
     * Focuses the element denoted by `initialFocus`, if provided, or the first focusable element otherwise.
     */
    applyFocus(): void;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterClose afterClose} event of this `sap.ui.webc.main.Dialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Dialog` itself.
     *
     * Fired after the component is closed. **This event does not bubble.**
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterClose(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Dialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterClose afterClose} event of this `sap.ui.webc.main.Dialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Dialog` itself.
     *
     * Fired after the component is closed. **This event does not bubble.**
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterClose(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Dialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterOpen afterOpen} event of this `sap.ui.webc.main.Dialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Dialog` itself.
     *
     * Fired after the component is opened. **This event does not bubble.**
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterOpen(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Dialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterOpen afterOpen} event of this `sap.ui.webc.main.Dialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Dialog` itself.
     *
     * Fired after the component is opened. **This event does not bubble.**
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterOpen(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Dialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeClose beforeClose} event of this `sap.ui.webc.main.Dialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Dialog` itself.
     *
     * Fired before the component is closed. This event can be cancelled, which will prevent the popup from
     * closing. **This event does not bubble.**
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeClose(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Dialog$BeforeCloseEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Dialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeClose beforeClose} event of this `sap.ui.webc.main.Dialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Dialog` itself.
     *
     * Fired before the component is closed. This event can be cancelled, which will prevent the popup from
     * closing. **This event does not bubble.**
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeClose(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Dialog$BeforeCloseEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Dialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeOpen beforeOpen} event of this `sap.ui.webc.main.Dialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Dialog` itself.
     *
     * Fired before the component is opened. This event can be cancelled, which will prevent the popup from
     * opening. **This event does not bubble.**
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeOpen(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Dialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeOpen beforeOpen} event of this `sap.ui.webc.main.Dialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Dialog` itself.
     *
     * Fired before the component is opened. This event can be cancelled, which will prevent the popup from
     * opening. **This event does not bubble.**
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeOpen(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Dialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Closes the popup.
     */
    close(): void;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Destroys all the footer in the aggregation {@link #getFooter footer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyFooter(): this;
    /**
     * Destroys all the header in the aggregation {@link #getHeader header}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyHeader(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:afterClose afterClose} event of this `sap.ui.webc.main.Dialog`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAfterClose(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:afterOpen afterOpen} event of this `sap.ui.webc.main.Dialog`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAfterOpen(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:beforeClose beforeClose} event of this `sap.ui.webc.main.Dialog`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachBeforeClose(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Dialog$BeforeCloseEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:beforeOpen beforeOpen} event of this `sap.ui.webc.main.Dialog`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachBeforeOpen(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:afterClose afterClose} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAfterClose(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:afterOpen afterOpen} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAfterOpen(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:beforeClose beforeClose} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireBeforeClose(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Dialog$BeforeCloseEventParameters
    ): boolean;
    /**
     * Fires event {@link #event:beforeOpen beforeOpen} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireBeforeOpen(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): boolean;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible name of the component.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Gets current value of property {@link #getAccessibleRole accessibleRole}.
     *
     * Allows setting a custom role.
     *
     * Default value is `Dialog`.
     *
     *
     * @returns Value of property `accessibleRole`
     */
    getAccessibleRole(): PopupAccessibleRole | keyof typeof PopupAccessibleRole;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * Defines the content of the Popup.
     */
    getContent(): Control[];
    /**
     * Gets current value of property {@link #getDraggable draggable}.
     *
     * Determines whether the component is draggable. If this property is set to true, the Dialog will be draggable
     * by its header.
     *
     *  **Note:** The component can be draggable only in desktop mode.
     *
     *  **Note:** This property overrides the default HTML "draggable" attribute native behavior. When "draggable"
     * is set to true, the native browser "draggable" behavior is prevented and only the Dialog custom logic
     * ("draggable by its header") works.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `draggable`
     */
    getDraggable(): boolean;
    /**
     * Gets content of aggregation {@link #getFooter footer}.
     *
     * Defines the footer HTML Element.
     *
     *  **Note:** When a `ui5-bar` is used in the footer, you should remove the default dialog's paddings.
     */
    getFooter(): Control[];
    /**
     * Gets content of aggregation {@link #getHeader header}.
     *
     * Defines the header HTML Element.
     *
     *  **Note:** When a `ui5-bar` is used in the header, you should remove the default dialog's paddings.
     *
     *  **Note:** If `header` slot is provided, the labelling of the dialog is a responsibility of the application
     * developer. `accessibleName` should be used.
     */
    getHeader(): Control[];
    /**
     * Gets current value of property {@link #getHeaderText headerText}.
     *
     * Defines the header text.
     *
     *  **Note:** If `header` slot is provided, the `headerText` is ignored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `headerText`
     */
    getHeaderText(): string;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Defines the height of the control
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * ID of the element which is the current target of the association {@link #getInitialFocus initialFocus},
     * or `null`.
     */
    getInitialFocus(): ID;
    /**
     * Gets current value of property {@link #getOpen open}.
     *
     * Indicates if the element is open
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `open`
     */
    getOpen(): boolean;
    /**
     * Gets current value of property {@link #getPreventFocusRestore preventFocusRestore}.
     *
     * Defines if the focus should be returned to the previously focused element, when the popup closes.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `preventFocusRestore`
     */
    getPreventFocusRestore(): boolean;
    /**
     * Gets current value of property {@link #getResizable resizable}.
     *
     * Configures the component to be resizable. If this property is set to true, the Dialog will have a resize
     * handle in its bottom right corner in LTR languages. In RTL languages, the resize handle will be placed
     * in the bottom left corner.
     *
     *  **Note:** The component can be resizable only in desktop mode.
     *  **Note:** Upon resizing, externally defined height and width styling will be ignored.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `resizable`
     */
    getResizable(): boolean;
    /**
     * Gets current value of property {@link #getState state}.
     *
     * Defines the state of the `Dialog`.
     *  **Note:** If `"Error"` and `"Warning"` state is set, it will change the accessibility role to "alertdialog",
     * if the accessibleRole property is set to `"Dialog"`.
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `state`
     */
    getState(): ValueState | keyof typeof ValueState;
    /**
     * Gets current value of property {@link #getStretch stretch}.
     *
     * Determines whether the component should be stretched to fullscreen.
     *
     *  **Note:** The component will be stretched to approximately 90% of the viewport.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `stretch`
     */
    getStretch(): boolean;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContent content}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: Control
    ): int;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getFooter footer}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfFooter(
      /**
       * The footer whose index is looked for
       */
      oFooter: Control
    ): int;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getHeader header}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfHeader(
      /**
       * The header whose index is looked for
       */
      oHeader: Control
    ): int;
    /**
     * Inserts a content into the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: Control,
      /**
       * The `0`-based index the content should be inserted at; for a negative value of `iIndex`, the content
       * is inserted at position 0; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a footer into the aggregation {@link #getFooter footer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertFooter(
      /**
       * The footer to insert; if empty, nothing is inserted
       */
      oFooter: Control,
      /**
       * The `0`-based index the footer should be inserted at; for a negative value of `iIndex`, the footer is
       * inserted at position 0; for a value greater than the current size of the aggregation, the footer is inserted
       * at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a header into the aggregation {@link #getHeader header}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertHeader(
      /**
       * The header to insert; if empty, nothing is inserted
       */
      oHeader: Control,
      /**
       * The `0`-based index the header should be inserted at; for a negative value of `iIndex`, the header is
       * inserted at position 0; for a value greater than the current size of the aggregation, the header is inserted
       * at the last position
       */
      iIndex: int
    ): this;
    /**
     * Tells if the component is opened
     */
    isOpen(): void;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): Control[];
    /**
     * Removes all the controls from the aggregation {@link #getFooter footer}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllFooter(): Control[];
    /**
     * Removes all the controls from the aggregation {@link #getHeader header}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllHeader(): Control[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | Control
    ): Control | null;
    /**
     * Removes a footer from the aggregation {@link #getFooter footer}.
     *
     *
     * @returns The removed footer or `null`
     */
    removeFooter(
      /**
       * The footer to remove or its index or id
       */
      vFooter: int | string | Control
    ): Control | null;
    /**
     * Removes a header from the aggregation {@link #getHeader header}.
     *
     *
     * @returns The removed header or `null`
     */
    removeHeader(
      /**
       * The header to remove or its index or id
       */
      vHeader: int | string | Control
    ): Control | null;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible name of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getAccessibleRole accessibleRole}.
     *
     * Allows setting a custom role.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Dialog`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleRole(
      /**
       * New value for property `accessibleRole`
       */
      sAccessibleRole?: PopupAccessibleRole | keyof typeof PopupAccessibleRole
    ): this;
    /**
     * Sets a new value for property {@link #getDraggable draggable}.
     *
     * Determines whether the component is draggable. If this property is set to true, the Dialog will be draggable
     * by its header.
     *
     *  **Note:** The component can be draggable only in desktop mode.
     *
     *  **Note:** This property overrides the default HTML "draggable" attribute native behavior. When "draggable"
     * is set to true, the native browser "draggable" behavior is prevented and only the Dialog custom logic
     * ("draggable by its header") works.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDraggable(
      /**
       * New value for property `draggable`
       */
      bDraggable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHeaderText headerText}.
     *
     * Defines the header text.
     *
     *  **Note:** If `header` slot is provided, the `headerText` is ignored.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeaderText(
      /**
       * New value for property `headerText`
       */
      sHeaderText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * Defines the height of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight: CSSSize
    ): this;
    /**
     * Sets the associated {@link #getInitialFocus initialFocus}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInitialFocus(
      /**
       * ID of an element which becomes the new target of this initialFocus association; alternatively, an element
       * instance may be given
       */
      oInitialFocus: ID | Control
    ): this;
    /**
     * Sets a new value for property {@link #getOpen open}.
     *
     * Indicates if the element is open
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOpen(
      /**
       * New value for property `open`
       */
      bOpen?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getPreventFocusRestore preventFocusRestore}.
     *
     * Defines if the focus should be returned to the previously focused element, when the popup closes.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPreventFocusRestore(
      /**
       * New value for property `preventFocusRestore`
       */
      bPreventFocusRestore?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getResizable resizable}.
     *
     * Configures the component to be resizable. If this property is set to true, the Dialog will have a resize
     * handle in its bottom right corner in LTR languages. In RTL languages, the resize handle will be placed
     * in the bottom left corner.
     *
     *  **Note:** The component can be resizable only in desktop mode.
     *  **Note:** Upon resizing, externally defined height and width styling will be ignored.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setResizable(
      /**
       * New value for property `resizable`
       */
      bResizable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getState state}.
     *
     * Defines the state of the `Dialog`.
     *  **Note:** If `"Error"` and `"Warning"` state is set, it will change the accessibility role to "alertdialog",
     * if the accessibleRole property is set to `"Dialog"`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setState(
      /**
       * New value for property `state`
       */
      sState?: ValueState | keyof typeof ValueState
    ): this;
    /**
     * Sets a new value for property {@link #getStretch stretch}.
     *
     * Determines whether the component should be stretched to fullscreen.
     *
     *  **Note:** The component will be stretched to approximately 90% of the viewport.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStretch(
      /**
       * New value for property `stretch`
       */
      bStretch?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
    /**
     * Shows the dialog.
     */
    show(
      /**
       * Prevents applying the focus inside the popup
       */
      preventInitialFocus: boolean
    ): void;
  }
  /**
   * Describes the settings that can be provided to the Dialog constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $DialogSettings extends $WebComponentSettings {
    /**
     * Defines the accessible name of the component.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * Allows setting a custom role.
     */
    accessibleRole?:
      | (PopupAccessibleRole | keyof typeof PopupAccessibleRole)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Determines whether the component is draggable. If this property is set to true, the Dialog will be draggable
     * by its header.
     *
     *  **Note:** The component can be draggable only in desktop mode.
     *
     *  **Note:** This property overrides the default HTML "draggable" attribute native behavior. When "draggable"
     * is set to true, the native browser "draggable" behavior is prevented and only the Dialog custom logic
     * ("draggable by its header") works.
     */
    draggable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the header text.
     *
     *  **Note:** If `header` slot is provided, the `headerText` is ignored.
     */
    headerText?: string | PropertyBindingInfo;

    /**
     * Defines the height of the control
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates if the element is open
     */
    open?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines if the focus should be returned to the previously focused element, when the popup closes.
     */
    preventFocusRestore?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Configures the component to be resizable. If this property is set to true, the Dialog will have a resize
     * handle in its bottom right corner in LTR languages. In RTL languages, the resize handle will be placed
     * in the bottom left corner.
     *
     *  **Note:** The component can be resizable only in desktop mode.
     *  **Note:** Upon resizing, externally defined height and width styling will be ignored.
     */
    resizable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the state of the `Dialog`.
     *  **Note:** If `"Error"` and `"Warning"` state is set, it will change the accessibility role to "alertdialog",
     * if the accessibleRole property is set to `"Dialog"`.
     */
    state?:
      | (ValueState | keyof typeof ValueState)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Determines whether the component should be stretched to fullscreen.
     *
     *  **Note:** The component will be stretched to approximately 90% of the viewport.
     */
    stretch?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the content of the Popup.
     */
    content?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * Defines the footer HTML Element.
     *
     *  **Note:** When a `ui5-bar` is used in the footer, you should remove the default dialog's paddings.
     */
    footer?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * Defines the header HTML Element.
     *
     *  **Note:** When a `ui5-bar` is used in the header, you should remove the default dialog's paddings.
     *
     *  **Note:** If `header` slot is provided, the labelling of the dialog is a responsibility of the application
     * developer. `accessibleName` should be used.
     */
    header?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * Receives id(or many ids) of the controls that label this control.
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Defines the ID of the HTML Element, which will get the initial focus.
     */
    initialFocus?: Control | string;

    /**
     * Fired after the component is closed. **This event does not bubble.**
     */
    afterClose?: (oEvent: Event) => void;

    /**
     * Fired after the component is opened. **This event does not bubble.**
     */
    afterOpen?: (oEvent: Event) => void;

    /**
     * Fired before the component is closed. This event can be cancelled, which will prevent the popup from
     * closing. **This event does not bubble.**
     */
    beforeClose?: (oEvent: Dialog$BeforeCloseEvent) => void;

    /**
     * Fired before the component is opened. This event can be cancelled, which will prevent the popup from
     * opening. **This event does not bubble.**
     */
    beforeOpen?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Dialog#afterClose event.
   */
  export interface Dialog$AfterCloseEventParameters {}

  /**
   * Event object of the Dialog#afterClose event.
   */
  export type Dialog$AfterCloseEvent = Event<
    Dialog$AfterCloseEventParameters,
    Dialog
  >;

  /**
   * Parameters of the Dialog#afterOpen event.
   */
  export interface Dialog$AfterOpenEventParameters {}

  /**
   * Event object of the Dialog#afterOpen event.
   */
  export type Dialog$AfterOpenEvent = Event<
    Dialog$AfterOpenEventParameters,
    Dialog
  >;

  /**
   * Parameters of the Dialog#beforeClose event.
   */
  export interface Dialog$BeforeCloseEventParameters {
    /**
     * Indicates that `ESC` key has triggered the event.
     */
    escPressed?: boolean;
  }

  /**
   * Event object of the Dialog#beforeClose event.
   */
  export type Dialog$BeforeCloseEvent = Event<
    Dialog$BeforeCloseEventParameters,
    Dialog
  >;

  /**
   * Parameters of the Dialog#beforeOpen event.
   */
  export interface Dialog$BeforeOpenEventParameters {}

  /**
   * Event object of the Dialog#beforeOpen event.
   */
  export type Dialog$BeforeOpenEvent = Event<
    Dialog$BeforeOpenEventParameters,
    Dialog
  >;
}

declare module "sap/ui/webc/main/FileUploader" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IFormContent, ValueState, CSSSize } from "sap/ui/core/library";

  import Control from "sap/ui/core/Control";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Overview:
   *
   * The `sap.ui.webc.main.FileUploader` opens a file explorer dialog and enables users to upload files. The
   * component consists of input field, but you can provide an HTML element by your choice to trigger the
   * file upload, by using the default slot. Furthermore, you can set the property "hideInput" to "true" to
   * hide the input field.
   *  To get all selected files, you can simply use the read-only "files" property. To restrict the types
   * of files the user can select, you can use the "accept" property.
   *  And, similar to all input based components, the FileUploader supports "valueState", "placeholder", "name",
   * and "disabled" properties.
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class FileUploader
    extends WebComponent
    implements IFormContent {
    __implements__sap_ui_core_IFormContent: boolean;
    /**
     * Constructor for a new `FileUploader`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $FileUploaderSettings
    );
    /**
     * Constructor for a new `FileUploader`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $FileUploaderSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.FileUploader with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FileUploader>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.FileUploader.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some content to the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted
       */
      oContent: Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.FileUploader`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.FileUploader` itself.
     *
     * Event is fired when the value of the file path has been changed. **Note:** Keep in mind that because
     * of the HTML input element of type file, the event is also fired in Chrome browser when the Cancel button
     * of the uploads window is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FileUploader$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.FileUploader` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.FileUploader`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.FileUploader` itself.
     *
     * Event is fired when the value of the file path has been changed. **Note:** Keep in mind that because
     * of the HTML input element of type file, the event is also fired in Chrome browser when the Cancel button
     * of the uploads window is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FileUploader$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.FileUploader` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:change change} event of this `sap.ui.webc.main.FileUploader`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: FileUploader$ChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:change change} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: FileUploader$ChangeEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getAccept accept}.
     *
     * Comma-separated list of file types that the component should accept.
     *
     *  **Note:** Please make sure you are adding the `.` in front on the file type, e.g. `.png` in case you
     * want to accept png's only.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `accept`
     */
    getAccept(): string;
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * By default the component contains a single input field. With this slot you can pass any content that
     * you wish to add. See the samples for more information.
     *  **Note:** If no content is provided in this slot, the component will only consist of an input field
     * and will not be interactable using the keyboard.
     *  Also it is not recommended to use any non-interactable components, as it may lead to poor accessibility
     * experience.
     */
    getContent(): Control[];
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Returns the fileList of all selected files.
     */
    getFiles(): void;
    /**
     * Gets current value of property {@link #getHideInput hideInput}.
     *
     * If set to "true", the input field of component will not be rendered. Only the default slot that is passed
     * will be rendered.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `hideInput`
     */
    getHideInput(): boolean;
    /**
     * Gets current value of property {@link #getMultiple multiple}.
     *
     * Allows multiple files to be chosen.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `multiple`
     */
    getMultiple(): boolean;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * Determines the name with which the component will be submitted in an HTML form.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form. Do not use this property unless you need to submit a form.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getPlaceholder placeholder}.
     *
     * Defines a short hint intended to aid the user with data entry when the component has no value.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `placeholder`
     */
    getPlaceholder(): string;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * Defines the name/names of the file/files to upload.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): string;
    /**
     * Gets current value of property {@link #getValueState valueState}.
     *
     * Defines the value state of the component.
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `valueState`
     */
    getValueState(): ValueState | keyof typeof ValueState;
    /**
     * Gets current value of property {@link #getValueStateMessage valueStateMessage}.
     *
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `valueStateMessage`
     */
    getValueStateMessage(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContent content}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: Control
    ): int;
    /**
     * Inserts a content into the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: Control,
      /**
       * The `0`-based index the content should be inserted at; for a negative value of `iIndex`, the content
       * is inserted at position 0; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): Control[];
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | Control
    ): Control | null;
    /**
     * Sets a new value for property {@link #getAccept accept}.
     *
     * Comma-separated list of file types that the component should accept.
     *
     *  **Note:** Please make sure you are adding the `.` in front on the file type, e.g. `.png` in case you
     * want to accept png's only.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccept(
      /**
       * New value for property `accept`
       */
      sAccept?: string
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHideInput hideInput}.
     *
     * If set to "true", the input field of component will not be rendered. Only the default slot that is passed
     * will be rendered.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideInput(
      /**
       * New value for property `hideInput`
       */
      bHideInput?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getMultiple multiple}.
     *
     * Allows multiple files to be chosen.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMultiple(
      /**
       * New value for property `multiple`
       */
      bMultiple?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * Determines the name with which the component will be submitted in an HTML form.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form. Do not use this property unless you need to submit a form.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getPlaceholder placeholder}.
     *
     * Defines a short hint intended to aid the user with data entry when the component has no value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlaceholder(
      /**
       * New value for property `placeholder`
       */
      sPlaceholder?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * Defines the name/names of the file/files to upload.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      sValue?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValueState valueState}.
     *
     * Defines the value state of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueState(
      /**
       * New value for property `valueState`
       */
      sValueState?: ValueState | keyof typeof ValueState
    ): this;
    /**
     * Sets a new value for property {@link #getValueStateMessage valueStateMessage}.
     *
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueStateMessage(
      /**
       * New value for property `valueStateMessage`
       */
      sValueStateMessage?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the FileUploader constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $FileUploaderSettings extends $WebComponentSettings {
    /**
     * Comma-separated list of file types that the component should accept.
     *
     *  **Note:** Please make sure you are adding the `.` in front on the file type, e.g. `.png` in case you
     * want to accept png's only.
     */
    accept?: string | PropertyBindingInfo;

    /**
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to "true", the input field of component will not be rendered. Only the default slot that is passed
     * will be rendered.
     */
    hideInput?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Allows multiple files to be chosen.
     */
    multiple?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines the name with which the component will be submitted in an HTML form.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form. Do not use this property unless you need to submit a form.
     */
    name?: string | PropertyBindingInfo;

    /**
     * Defines a short hint intended to aid the user with data entry when the component has no value.
     */
    placeholder?: string | PropertyBindingInfo;

    /**
     * Defines the name/names of the file/files to upload.
     */
    value?: string | PropertyBindingInfo;

    /**
     * Defines the value state of the component.
     */
    valueState?:
      | (ValueState | keyof typeof ValueState)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     */
    valueStateMessage?: string | PropertyBindingInfo;

    /**
     * Defines the width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * By default the component contains a single input field. With this slot you can pass any content that
     * you wish to add. See the samples for more information.
     *  **Note:** If no content is provided in this slot, the component will only consist of an input field
     * and will not be interactable using the keyboard.
     *  Also it is not recommended to use any non-interactable components, as it may lead to poor accessibility
     * experience.
     */
    content?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * Event is fired when the value of the file path has been changed. **Note:** Keep in mind that because
     * of the HTML input element of type file, the event is also fired in Chrome browser when the Cancel button
     * of the uploads window is pressed.
     */
    change?: (oEvent: FileUploader$ChangeEvent) => void;
  }

  /**
   * Parameters of the FileUploader#change event.
   */
  export interface FileUploader$ChangeEventParameters {
    /**
     * The current files.
     */
    files?: FileList;
  }

  /**
   * Event object of the FileUploader#change event.
   */
  export type FileUploader$ChangeEvent = Event<
    FileUploader$ChangeEventParameters,
    FileUploader
  >;
}

declare module "sap/ui/webc/main/GroupHeaderListItem" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IListItem } from "sap/ui/webc/main/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The `sap.ui.webc.main.GroupHeaderListItem` is a special list item, used only to separate other list items
   * into logical groups.
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class GroupHeaderListItem
    extends WebComponent
    implements IListItem {
    __implements__sap_ui_webc_main_IListItem: boolean;
    /**
     * Constructor for a new `GroupHeaderListItem`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $GroupHeaderListItemSettings
    );
    /**
     * Constructor for a new `GroupHeaderListItem`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $GroupHeaderListItemSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.GroupHeaderListItem with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, GroupHeaderListItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.GroupHeaderListItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the text alternative of the component. Note: If not provided a default text alternative will
     * be set, if present.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Gets current value of property {@link #getSelected selected}.
     *
     * Defines the selected state of the `ListItem`.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `selected`
     */
    getSelected(): boolean;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Defines the content of the control
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the text alternative of the component. Note: If not provided a default text alternative will
     * be set, if present.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSelected selected}.
     *
     * Defines the selected state of the `ListItem`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelected(
      /**
       * New value for property `selected`
       */
      bSelected?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Defines the content of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the GroupHeaderListItem constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $GroupHeaderListItemSettings extends $WebComponentSettings {
    /**
     * Defines the text alternative of the component. Note: If not provided a default text alternative will
     * be set, if present.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * Defines the selected state of the `ListItem`.
     */
    selected?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the content of the control
     */
    text?: string | PropertyBindingInfo;
  }
}

declare module "sap/ui/webc/main/Icon" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IIcon, IconDesign } from "sap/ui/webc/main/library";

  import Event from "sap/ui/base/Event";

  import { CSSColor, CSSSize } from "sap/ui/core/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * The `sap.ui.webc.main.Icon` component represents an SVG icon. There are two main scenarios how the `sap.ui.webc.main.Icon`
   * component is used: as a purely decorative element,
   *  or as an interactive element that can be focused and clicked.
   *
   * Usage:
   *
   * 1. **Get familiar with the icons collections.**
   *  Before displaying an icon, you need to explore the icons collections to find and import the desired
   * icon.
   *  Currently there are 3 icons collection, available as 3 npm packages:
   *
   *
   *
   * 	 -  {@link https://www.npmjs.com/package/@ui5/webcomponents-icons @ui5/webcomponents-icons} represents
   *     the "SAP-icons" collection and includes the following {@link demo:sap/m/demokit/iconExplorer/webapp/index.html#/overview/SAP-icons icons}.
   *
   * 	 -  {@link https://www.npmjs.com/package/@ui5/webcomponents-icons-tnt @ui5/webcomponents-icons-tnt }
   *     represents the "tnt" collection and includes the following {@link demo:sap/m/demokit/iconExplorer/webapp/index.html#/overview/SAP-icons-TNT icons}.
   *
   * 	 -  {@link https://www.npmjs.com/package/@ui5/webcomponents-icons-business-suite @ui5/webcomponents-icons-icons-business-suite }
   *     represents the "business-suite" collection and includes the following {@link https://ui5.sap.com/test-resources/sap/m/demokit/iconExplorer/webapp/index.html#/overview/BusinessSuiteInAppSymbols icons}.
   *
   *
   * 2. **After exploring the icons collections, add one or more of the packages as dependencies to your project.**
   *
   *  `npm i @ui5/webcomponents-icons`
   *  `npm i @ui5/webcomponents-icons-tnt`
   *  `npm i @ui5/webcomponents-icons-business-suite`
   *
   *
   *
   * **For Example**:
   *
   *
   * 4. **Display the icon using the `sap.ui.webc.main.Icon` web component.**
   *  Set the icon collection ("SAP-icons", "tnt" or "business-suite" - "SAP-icons" is the default icon collection
   * and can be skipped)
   *  and the icon name to the `name` property.
   *
   *
   *
   * `<ui5-icon name="employee"></ui5-icon>`
   *  `<ui5-icon name="tnt/antenna"></ui5-icon>`
   *  `<ui5-icon name="business-suite/ab-testing"></ui5-icon>`
   *
   *
   *
   *  CSS Shadow Parts:
   *
   * {@link https://developer.mozilla.org/en-US/docs/Web/CSS/::part CSS Shadow Parts} allow developers to
   * style elements inside the Shadow DOM.
   *  The `sap.ui.webc.main.Icon` exposes the following CSS Shadow Parts:
   * 	 - root - Used to style the outermost wrapper of the `sap.ui.webc.main.Icon`
   *
   *
   *
   *  Keyboard Handling:
   *
   *
   * 	 - [SPACE, ENTER, RETURN] - Fires the `click` event if the `interactive` property is set to true.
   * 	 - [SHIFT] - If [SPACE] or [ENTER],[RETURN] is pressed, pressing [SHIFT] releases the ui5-icon without
   *     triggering the click event.
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class Icon extends WebComponent implements IIcon {
    __implements__sap_ui_webc_main_IIcon: boolean;
    /**
     * Constructor for a new `Icon`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $IconSettings
    );
    /**
     * Constructor for a new `Icon`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $IconSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.Icon with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Icon>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.Icon.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.webc.main.Icon`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Icon` itself.
     *
     * Fired when the user clicks the control
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Icon` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.webc.main.Icon`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Icon` itself.
     *
     * Fired when the user clicks the control
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Icon` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:click click} event of this `sap.ui.webc.main.Icon`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:click click} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the text alternative of the component. If not provided a default text alternative will be set,
     * if present.
     *
     *  **Note:** Every icon should have a text alternative in order to calculate its accessible name.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Gets current value of property {@link #getAccessibleRole accessibleRole}.
     *
     * Defines the accessibility role of the component.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `accessibleRole`
     */
    getAccessibleRole(): string;
    /**
     * Gets current value of property {@link #getBackgroundColor backgroundColor}.
     *
     * Defines the background color of the control
     *
     *
     * @returns Value of property `backgroundColor`
     */
    getBackgroundColor(): CSSColor;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * Defines the color of the control
     *
     *
     * @returns Value of property `color`
     */
    getColor(): CSSColor;
    /**
     * Gets current value of property {@link #getDesign design}.
     *
     * Defines the component semantic design.
     *
     *
     *
     *  **The available values are:**
     *
     *
     * 	 - `Contrast`
     * 	 - `Critical`
     * 	 - `Default`
     * 	 - `Information`
     * 	 - `Negative`
     * 	 - `Neutral`
     * 	 - `NonInteractive`
     * 	 - `Positive`
     *
     * Default value is `Default`.
     *
     *
     * @returns Value of property `design`
     */
    getDesign(): IconDesign | keyof typeof IconDesign;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Defines the height of the control
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getInteractive interactive}.
     *
     * Defines if the icon is interactive (focusable and pressable)
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `interactive`
     */
    getInteractive(): boolean;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * Defines the unique identifier (icon name) of the component.
     *
     *
     * To browse all available icons, see the {@link demo:sap/m/demokit/iconExplorer/webapp/index.html SAP Icons},
     * {@link demo:sap/m/demokit/iconExplorer/webapp/index.html#/overview/SAP-icons-TNT SAP Fiori Tools} and
     * {@link demo:sap/m/demokit/iconExplorer/webapp/index.html SAP Business Suite} collections.
     *
     *
     * Example:
     *  `name='add'`, `name='delete'`, `name='employee'`.
     *
     *
     *
     * **Note:** To use the SAP Fiori Tools icons, you need to set the `tnt` prefix in front of the icon's name.
     *
     *
     *
     * Example:
     *  `name='tnt/antenna'`, `name='tnt/actor'`, `name='tnt/api'`.
     *
     *
     *
     * **Note:** To use the SAP Business Suite icons, you need to set the `business-suite` prefix in front of
     * the icon's name.
     *
     *
     * Example:
     *  `name='business-suite/3d'`, `name='business-suite/1x2-grid-layout'`, `name='business-suite/4x4-grid-layout'`.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getShowTooltip showTooltip}.
     *
     * Defines whether the component should have a tooltip.
     *
     *  **Note:** The tooltip text should be provided via the `accessible-name` property.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showTooltip`
     */
    getShowTooltip(): boolean;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the text alternative of the component. If not provided a default text alternative will be set,
     * if present.
     *
     *  **Note:** Every icon should have a text alternative in order to calculate its accessible name.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getAccessibleRole accessibleRole}.
     *
     * Defines the accessibility role of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleRole(
      /**
       * New value for property `accessibleRole`
       */
      sAccessibleRole?: string
    ): this;
    /**
     * Sets a new value for property {@link #getBackgroundColor backgroundColor}.
     *
     * Defines the background color of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackgroundColor(
      /**
       * New value for property `backgroundColor`
       */
      sBackgroundColor: CSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * Defines the color of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor: CSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getDesign design}.
     *
     * Defines the component semantic design.
     *
     *
     *
     *  **The available values are:**
     *
     *
     * 	 - `Contrast`
     * 	 - `Critical`
     * 	 - `Default`
     * 	 - `Information`
     * 	 - `Negative`
     * 	 - `Neutral`
     * 	 - `NonInteractive`
     * 	 - `Positive`
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Default`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDesign(
      /**
       * New value for property `design`
       */
      sDesign?: IconDesign | keyof typeof IconDesign
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * Defines the height of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getInteractive interactive}.
     *
     * Defines if the icon is interactive (focusable and pressable)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInteractive(
      /**
       * New value for property `interactive`
       */
      bInteractive?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * Defines the unique identifier (icon name) of the component.
     *
     *
     * To browse all available icons, see the {@link demo:sap/m/demokit/iconExplorer/webapp/index.html SAP Icons},
     * {@link demo:sap/m/demokit/iconExplorer/webapp/index.html#/overview/SAP-icons-TNT SAP Fiori Tools} and
     * {@link demo:sap/m/demokit/iconExplorer/webapp/index.html SAP Business Suite} collections.
     *
     *
     * Example:
     *  `name='add'`, `name='delete'`, `name='employee'`.
     *
     *
     *
     * **Note:** To use the SAP Fiori Tools icons, you need to set the `tnt` prefix in front of the icon's name.
     *
     *
     *
     * Example:
     *  `name='tnt/antenna'`, `name='tnt/actor'`, `name='tnt/api'`.
     *
     *
     *
     * **Note:** To use the SAP Business Suite icons, you need to set the `business-suite` prefix in front of
     * the icon's name.
     *
     *
     * Example:
     *  `name='business-suite/3d'`, `name='business-suite/1x2-grid-layout'`, `name='business-suite/4x4-grid-layout'`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getShowTooltip showTooltip}.
     *
     * Defines whether the component should have a tooltip.
     *
     *  **Note:** The tooltip text should be provided via the `accessible-name` property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowTooltip(
      /**
       * New value for property `showTooltip`
       */
      bShowTooltip?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Icon constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $IconSettings extends $WebComponentSettings {
    /**
     * Defines the text alternative of the component. If not provided a default text alternative will be set,
     * if present.
     *
     *  **Note:** Every icon should have a text alternative in order to calculate its accessible name.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * Defines the accessibility role of the component.
     */
    accessibleRole?: string | PropertyBindingInfo;

    /**
     * Defines the background color of the control
     */
    backgroundColor?: CSSColor | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the color of the control
     */
    color?: CSSColor | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the component semantic design.
     *
     *
     *
     *  **The available values are:**
     *
     *
     * 	 - `Contrast`
     * 	 - `Critical`
     * 	 - `Default`
     * 	 - `Information`
     * 	 - `Negative`
     * 	 - `Neutral`
     * 	 - `NonInteractive`
     * 	 - `Positive`
     */
    design?:
      | (IconDesign | keyof typeof IconDesign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the height of the control
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines if the icon is interactive (focusable and pressable)
     */
    interactive?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the unique identifier (icon name) of the component.
     *
     *
     * To browse all available icons, see the {@link demo:sap/m/demokit/iconExplorer/webapp/index.html SAP Icons},
     * {@link demo:sap/m/demokit/iconExplorer/webapp/index.html#/overview/SAP-icons-TNT SAP Fiori Tools} and
     * {@link demo:sap/m/demokit/iconExplorer/webapp/index.html SAP Business Suite} collections.
     *
     *
     * Example:
     *  `name='add'`, `name='delete'`, `name='employee'`.
     *
     *
     *
     * **Note:** To use the SAP Fiori Tools icons, you need to set the `tnt` prefix in front of the icon's name.
     *
     *
     *
     * Example:
     *  `name='tnt/antenna'`, `name='tnt/actor'`, `name='tnt/api'`.
     *
     *
     *
     * **Note:** To use the SAP Business Suite icons, you need to set the `business-suite` prefix in front of
     * the icon's name.
     *
     *
     * Example:
     *  `name='business-suite/3d'`, `name='business-suite/1x2-grid-layout'`, `name='business-suite/4x4-grid-layout'`.
     */
    name?: string | PropertyBindingInfo;

    /**
     * Defines whether the component should have a tooltip.
     *
     *  **Note:** The tooltip text should be provided via the `accessible-name` property.
     */
    showTooltip?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Fired when the user clicks the control
     */
    click?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Icon#click event.
   */
  export interface Icon$ClickEventParameters {}

  /**
   * Event object of the Icon#click event.
   */
  export type Icon$ClickEvent = Event<Icon$ClickEventParameters, Icon>;
}

declare module "sap/ui/webc/main/Input" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import {
    IInput,
    IIcon,
    IInputSuggestionItem,
    InputType,
  } from "sap/ui/webc/main/library";

  import { IFormContent, ID, ValueState, CSSSize } from "sap/ui/core/library";

  import Control from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * The `sap.ui.webc.main.Input` component allows the user to enter and edit text or numeric values in one
   * line.
   *  Additionally, you can provide `suggestionItems`, that are displayed in a popover right under the input.
   *
   *
   *  The text field can be editable or read-only (`readonly` property), and it can be enabled or disabled
   * (`disabled` property). To visualize semantic states, such as "error" or "warning", the `valueState` property
   * is provided. When the user makes changes to the text, the change event is fired, which enables you to
   * react on any text change.
   *
   *  **Note:** If you are using the `sap.ui.webc.main.Input` as a single npm module, don't forget to import
   * the `InputSuggestions` module from "@ui5/webcomponents/dist/features/InputSuggestions.js" to enable the
   * suggestions functionality.
   *
   * Keyboard Handling: The `sap.ui.webc.main.Input` provides the following keyboard shortcuts:
   *
   *
   *
   * 	 - [ESC] - Closes the suggestion list, if open. If closed or not enabled, cancels changes and reverts
   *     to the value which the Input field had when it got the focus.
   * 	 - [ENTER] or [RETURN] - If suggestion list is open takes over the current matching item and closes
   *     it. If value state or group header is focused, does nothing.
   * 	 - [DOWN] - Focuses the next matching item in the suggestion list.
   * 	 - [UP] - Focuses the previous matching item in the suggestion list.
   * 	 - [HOME] - If focus is in the text input, moves caret before the first character. If focus is in the
   *     list, highlights the first item and updates the input accordingly.
   * 	 - [END] - If focus is in the text input, moves caret after the last character. If focus is in the list,
   *     highlights the last item and updates the input accordingly.
   * 	 - [PAGEUP] - If focus is in the list, moves highlight up by page size (10 items by default). If focus
   *     is in the input, does nothing.
   * 	 - [PAGEDOWN] - If focus is in the list, moves highlight down by page size (10 items by default). If
   *     focus is in the input, does nothing.
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class Input
    extends WebComponent
    implements IInput, IFormContent {
    __implements__sap_ui_webc_main_IInput: boolean;
    __implements__sap_ui_core_IFormContent: boolean;
    /**
     * Constructor for a new `Input`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $InputSettings
    );
    /**
     * Constructor for a new `Input`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $InputSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.Input with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Input>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.Input.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some icon to the aggregation {@link #getIcon icon}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addIcon(
      /**
       * The icon to add; if empty, nothing is inserted
       */
      oIcon: IIcon
    ): this;
    /**
     * Adds some suggestionItem to the aggregation {@link #getSuggestionItems suggestionItems}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addSuggestionItem(
      /**
       * The suggestionItem to add; if empty, nothing is inserted
       */
      oSuggestionItem: IInputSuggestionItem
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.Input`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Input` itself.
     *
     * Fired when the input operation has finished by pressing Enter or on focusout.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Input` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.Input`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Input` itself.
     *
     * Fired when the input operation has finished by pressing Enter or on focusout.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Input` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:input input} event of this `sap.ui.webc.main.Input`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Input` itself.
     *
     * Fired when the value of the component changes at each keystroke, and when a suggestion item has been
     * selected.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInput(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Input` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:input input} event of this `sap.ui.webc.main.Input`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Input` itself.
     *
     * Fired when the value of the component changes at each keystroke, and when a suggestion item has been
     * selected.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInput(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Input` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:suggestionItemPreview suggestionItemPreview }
     * event of this `sap.ui.webc.main.Input`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Input` itself.
     *
     * Fired when the user navigates to a suggestion item via the ARROW keys, as a preview, before the final
     * selection.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSuggestionItemPreview(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Input$SuggestionItemPreviewEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Input` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:suggestionItemPreview suggestionItemPreview }
     * event of this `sap.ui.webc.main.Input`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Input` itself.
     *
     * Fired when the user navigates to a suggestion item via the ARROW keys, as a preview, before the final
     * selection.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSuggestionItemPreview(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Input$SuggestionItemPreviewEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Input` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:suggestionItemSelect suggestionItemSelect} event
     * of this `sap.ui.webc.main.Input`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Input` itself.
     *
     * Fired when a suggestion item, that is displayed in the suggestion popup, is selected.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSuggestionItemSelect(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Input$SuggestionItemSelectEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Input` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:suggestionItemSelect suggestionItemSelect} event
     * of this `sap.ui.webc.main.Input`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Input` itself.
     *
     * Fired when a suggestion item, that is displayed in the suggestion popup, is selected.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSuggestionItemSelect(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Input$SuggestionItemSelectEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Input` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the icon in the aggregation {@link #getIcon icon}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyIcon(): this;
    /**
     * Destroys all the suggestionItems in the aggregation {@link #getSuggestionItems suggestionItems}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroySuggestionItems(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:change change} event of this `sap.ui.webc.main.Input`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:input input} event of this `sap.ui.webc.main.Input`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInput(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:suggestionItemPreview suggestionItemPreview }
     * event of this `sap.ui.webc.main.Input`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSuggestionItemPreview(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Input$SuggestionItemPreviewEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:suggestionItemSelect suggestionItemSelect }
     * event of this `sap.ui.webc.main.Input`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSuggestionItemSelect(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Input$SuggestionItemSelectEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:change change} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:input input} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInput(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:suggestionItemPreview suggestionItemPreview} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSuggestionItemPreview(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Input$SuggestionItemPreviewEventParameters
    ): this;
    /**
     * Fires event {@link #event:suggestionItemSelect suggestionItemSelect} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSuggestionItemSelect(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Input$SuggestionItemSelectEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets content of aggregation {@link #getIcon icon}.
     *
     * Defines the icon to be displayed in the component.
     */
    getIcon(): IIcon[];
    /**
     * Gets current value of property {@link #getMaxlength maxlength}.
     *
     * Sets the maximum number of characters available in the input field.
     *
     *  **Note:** This property is not compatible with the ui5-input type InputType.Number. If the ui5-input
     * type is set to Number, the maxlength value is ignored.
     *
     *
     * @returns Value of property `maxlength`
     */
    getMaxlength(): int;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * Determines the name with which the component will be submitted in an HTML form.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form. Do not use this property unless you need to submit a form.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getNoTypeahead noTypeahead}.
     *
     * Defines whether the value will be autcompleted to match an item
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `noTypeahead`
     */
    getNoTypeahead(): boolean;
    /**
     * Gets current value of property {@link #getPlaceholder placeholder}.
     *
     * Defines a short hint intended to aid the user with data entry when the component has no value.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `placeholder`
     */
    getPlaceholder(): string;
    /**
     * Returns the the suggestion item on preview.
     */
    getPreviewItem(): void;
    /**
     * Gets current value of property {@link #getReadonly readonly}.
     *
     * Defines whether the component is read-only.
     *
     *  **Note:** A read-only component is not editable, but still provides visual feedback upon user interaction.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `readonly`
     */
    getReadonly(): boolean;
    /**
     * Gets current value of property {@link #getRequired required}.
     *
     * Defines whether the component is required.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `required`
     */
    getRequired(): boolean;
    /**
     * Gets current value of property {@link #getShowClearIcon showClearIcon}.
     *
     * Defines whether the clear icon of the input will be shown.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showClearIcon`
     */
    getShowClearIcon(): boolean;
    /**
     * Gets current value of property {@link #getShowSuggestions showSuggestions}.
     *
     * Defines whether the component should show suggestions, if such are present.
     *
     *  **Note:** You need to import the `InputSuggestions` module from `"@ui5/webcomponents/dist/features/InputSuggestions.js"`
     * to enable this functionality.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showSuggestions`
     */
    getShowSuggestions(): boolean;
    /**
     * Gets content of aggregation {@link #getSuggestionItems suggestionItems}.
     */
    getSuggestionItems(): IInputSuggestionItem[];
    /**
     * Gets current value of property {@link #getType type}.
     *
     * Defines the HTML type of the component.
     *
     *  **Notes:**
     * 	 - The particular effect of this property differs depending on the browser and the current language
     *     settings, especially for type `Number`.
     * 	 - The property is mostly intended to be used with touch devices that use different soft keyboard layouts
     *     depending on the given input type.
     *
     * Default value is `Text`.
     *
     *
     * @returns Value of property `type`
     */
    getType(): InputType | keyof typeof InputType;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * Defines the value of the component.
     *
     *  **Note:** The property is updated upon typing.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): string;
    /**
     * Gets current value of property {@link #getValueState valueState}.
     *
     * Defines the value state of the component.
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `valueState`
     */
    getValueState(): ValueState | keyof typeof ValueState;
    /**
     * Gets current value of property {@link #getValueStateMessage valueStateMessage}.
     *
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `valueStateMessage`
     */
    getValueStateMessage(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.ui.webc.main.IIcon` in the aggregation {@link #getIcon icon}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfIcon(
      /**
       * The icon whose index is looked for
       */
      oIcon: IIcon
    ): int;
    /**
     * Checks for the provided `sap.ui.webc.main.IInputSuggestionItem` in the aggregation {@link #getSuggestionItems suggestionItems}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfSuggestionItem(
      /**
       * The suggestionItem whose index is looked for
       */
      oSuggestionItem: IInputSuggestionItem
    ): int;
    /**
     * Inserts a icon into the aggregation {@link #getIcon icon}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertIcon(
      /**
       * The icon to insert; if empty, nothing is inserted
       */
      oIcon: IIcon,
      /**
       * The `0`-based index the icon should be inserted at; for a negative value of `iIndex`, the icon is inserted
       * at position 0; for a value greater than the current size of the aggregation, the icon is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a suggestionItem into the aggregation {@link #getSuggestionItems suggestionItems}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertSuggestionItem(
      /**
       * The suggestionItem to insert; if empty, nothing is inserted
       */
      oSuggestionItem: IInputSuggestionItem,
      /**
       * The `0`-based index the suggestionItem should be inserted at; for a negative value of `iIndex`, the suggestionItem
       * is inserted at position 0; for a value greater than the current size of the aggregation, the suggestionItem
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Manually opens the suggestions popover, assuming suggestions are enabled. Items must be preloaded for
     * it to open.
     */
    openPicker(): void;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getIcon icon}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllIcon(): IIcon[];
    /**
     * Removes all the controls from the aggregation {@link #getSuggestionItems suggestionItems}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllSuggestionItems(): IInputSuggestionItem[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a icon from the aggregation {@link #getIcon icon}.
     *
     *
     * @returns The removed icon or `null`
     */
    removeIcon(
      /**
       * The icon to remove or its index or id
       */
      vIcon: int | string | IIcon
    ): IIcon | null;
    /**
     * Removes a suggestionItem from the aggregation {@link #getSuggestionItems suggestionItems}.
     *
     *
     * @returns The removed suggestionItem or `null`
     */
    removeSuggestionItem(
      /**
       * The suggestionItem to remove or its index or id
       */
      vSuggestionItem: int | string | IInputSuggestionItem
    ): IInputSuggestionItem | null;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName: string
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getMaxlength maxlength}.
     *
     * Sets the maximum number of characters available in the input field.
     *
     *  **Note:** This property is not compatible with the ui5-input type InputType.Number. If the ui5-input
     * type is set to Number, the maxlength value is ignored.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxlength(
      /**
       * New value for property `maxlength`
       */
      iMaxlength: int
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * Determines the name with which the component will be submitted in an HTML form.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form. Do not use this property unless you need to submit a form.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getNoTypeahead noTypeahead}.
     *
     * Defines whether the value will be autcompleted to match an item
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNoTypeahead(
      /**
       * New value for property `noTypeahead`
       */
      bNoTypeahead?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getPlaceholder placeholder}.
     *
     * Defines a short hint intended to aid the user with data entry when the component has no value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlaceholder(
      /**
       * New value for property `placeholder`
       */
      sPlaceholder?: string
    ): this;
    /**
     * Sets a new value for property {@link #getReadonly readonly}.
     *
     * Defines whether the component is read-only.
     *
     *  **Note:** A read-only component is not editable, but still provides visual feedback upon user interaction.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setReadonly(
      /**
       * New value for property `readonly`
       */
      bReadonly?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getRequired required}.
     *
     * Defines whether the component is required.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRequired(
      /**
       * New value for property `required`
       */
      bRequired?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowClearIcon showClearIcon}.
     *
     * Defines whether the clear icon of the input will be shown.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowClearIcon(
      /**
       * New value for property `showClearIcon`
       */
      bShowClearIcon?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowSuggestions showSuggestions}.
     *
     * Defines whether the component should show suggestions, if such are present.
     *
     *  **Note:** You need to import the `InputSuggestions` module from `"@ui5/webcomponents/dist/features/InputSuggestions.js"`
     * to enable this functionality.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowSuggestions(
      /**
       * New value for property `showSuggestions`
       */
      bShowSuggestions?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * Defines the HTML type of the component.
     *
     *  **Notes:**
     * 	 - The particular effect of this property differs depending on the browser and the current language
     *     settings, especially for type `Number`.
     * 	 - The property is mostly intended to be used with touch devices that use different soft keyboard layouts
     *     depending on the given input type.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Text`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: InputType | keyof typeof InputType
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * Defines the value of the component.
     *
     *  **Note:** The property is updated upon typing.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      sValue?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValueState valueState}.
     *
     * Defines the value state of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueState(
      /**
       * New value for property `valueState`
       */
      sValueState?: ValueState | keyof typeof ValueState
    ): this;
    /**
     * Sets a new value for property {@link #getValueStateMessage valueStateMessage}.
     *
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueStateMessage(
      /**
       * New value for property `valueStateMessage`
       */
      sValueStateMessage?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Input constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $InputSettings extends $WebComponentSettings {
    /**
     * Defines the accessible ARIA name of the component.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets the maximum number of characters available in the input field.
     *
     *  **Note:** This property is not compatible with the ui5-input type InputType.Number. If the ui5-input
     * type is set to Number, the maxlength value is ignored.
     */
    maxlength?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines the name with which the component will be submitted in an HTML form.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form. Do not use this property unless you need to submit a form.
     */
    name?: string | PropertyBindingInfo;

    /**
     * Defines whether the value will be autcompleted to match an item
     */
    noTypeahead?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines a short hint intended to aid the user with data entry when the component has no value.
     */
    placeholder?: string | PropertyBindingInfo;

    /**
     * Defines whether the component is read-only.
     *
     *  **Note:** A read-only component is not editable, but still provides visual feedback upon user interaction.
     */
    readonly?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the component is required.
     */
    required?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the clear icon of the input will be shown.
     */
    showClearIcon?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the component should show suggestions, if such are present.
     *
     *  **Note:** You need to import the `InputSuggestions` module from `"@ui5/webcomponents/dist/features/InputSuggestions.js"`
     * to enable this functionality.
     */
    showSuggestions?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the HTML type of the component.
     *
     *  **Notes:**
     * 	 - The particular effect of this property differs depending on the browser and the current language
     *     settings, especially for type `Number`.
     * 	 - The property is mostly intended to be used with touch devices that use different soft keyboard layouts
     *     depending on the given input type.
     */
    type?:
      | (InputType | keyof typeof InputType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the value of the component.
     *
     *  **Note:** The property is updated upon typing.
     */
    value?: string | PropertyBindingInfo;

    /**
     * Defines the value state of the component.
     */
    valueState?:
      | (ValueState | keyof typeof ValueState)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     */
    valueStateMessage?: string | PropertyBindingInfo;

    /**
     * Defines the width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the icon to be displayed in the component.
     */
    icon?: IIcon[] | IIcon | AggregationBindingInfo | `{${string}}`;

    suggestionItems?:
      | IInputSuggestionItem[]
      | IInputSuggestionItem
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Receives id(or many ids) of the controls that label this control.
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Fired when the input operation has finished by pressing Enter or on focusout.
     */
    change?: (oEvent: Event) => void;

    /**
     * Fired when the value of the component changes at each keystroke, and when a suggestion item has been
     * selected.
     */
    input?: (oEvent: Event) => void;

    /**
     * Fired when the user navigates to a suggestion item via the ARROW keys, as a preview, before the final
     * selection.
     */
    suggestionItemPreview?: (oEvent: Input$SuggestionItemPreviewEvent) => void;

    /**
     * Fired when a suggestion item, that is displayed in the suggestion popup, is selected.
     */
    suggestionItemSelect?: (oEvent: Input$SuggestionItemSelectEvent) => void;
  }

  /**
   * Parameters of the Input#change event.
   */
  export interface Input$ChangeEventParameters {}

  /**
   * Event object of the Input#change event.
   */
  export type Input$ChangeEvent = Event<Input$ChangeEventParameters, Input>;

  /**
   * Parameters of the Input#input event.
   */
  export interface Input$InputEventParameters {}

  /**
   * Event object of the Input#input event.
   */
  export type Input$InputEvent = Event<Input$InputEventParameters, Input>;

  /**
   * Parameters of the Input#suggestionItemPreview event.
   */
  export interface Input$SuggestionItemPreviewEventParameters {
    /**
     * The previewed suggestion item.
     */
    item?: HTMLElement;

    /**
     * The DOM ref of the suggestion item.
     */
    targetRef?: HTMLElement;
  }

  /**
   * Event object of the Input#suggestionItemPreview event.
   */
  export type Input$SuggestionItemPreviewEvent = Event<
    Input$SuggestionItemPreviewEventParameters,
    Input
  >;

  /**
   * Parameters of the Input#suggestionItemSelect event.
   */
  export interface Input$SuggestionItemSelectEventParameters {
    /**
     * The selected item.
     */
    item?: HTMLElement;
  }

  /**
   * Event object of the Input#suggestionItemSelect event.
   */
  export type Input$SuggestionItemSelectEvent = Event<
    Input$SuggestionItemSelectEventParameters,
    Input
  >;
}

declare module "sap/ui/webc/main/Label" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { Label as Label1, ID, CSSSize } from "sap/ui/core/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { WrappingType } from "sap/ui/webc/main/library";

  import Control from "sap/ui/core/Control";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * The `sap.ui.webc.main.Label` is a component used to represent a label for elements like input, textarea,
   * select.
   *
   *  The `for` property of the `sap.ui.webc.main.Label` must be the same as the id attribute of the related
   * input element.
   *
   *  Screen readers read out the label, when the user focuses the labelled control.
   *
   *  The `sap.ui.webc.main.Label` appearance can be influenced by properties, such as `required` and `wrappingType`.
   * The appearance of the Label can be configured in a limited way by using the design property. For a broader
   * choice of designs, you can use custom styles.
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class Label extends WebComponent implements Label1 {
    __implements__sap_ui_core_Label: boolean;
    /**
     * Constructor for a new `Label`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $LabelSettings
    );
    /**
     * Constructor for a new `Label`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $LabelSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.Label with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Label>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.Label.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * ID of the element which is the current target of the association {@link #getLabelFor labelFor}, or `null`.
     */
    getLabelFor(): ID;
    /**
     * Gets current value of property {@link #getRequired required}.
     *
     * Defines whether an asterisk character is added to the component text.
     *
     *  **Note:** Usually indicates that user input (bound with the `for` property) is required. In that case
     * the required</> property of the corresponding input should also be set.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `required`
     */
    getRequired(): boolean;
    /**
     * Gets current value of property {@link #getShowColon showColon}.
     *
     * Defines whether colon is added to the component text.
     *
     *  **Note:** Usually used in forms.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showColon`
     */
    getShowColon(): boolean;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Defines the content of the control
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Gets current value of property {@link #getWrappingType wrappingType}.
     *
     * Defines how the text of a component will be displayed when there is not enough space.
     *  **Note:** for option "Normal" the text will wrap and the words will not be broken based on hyphenation.
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `wrappingType`
     */
    getWrappingType(): WrappingType | keyof typeof WrappingType;
    /**
     * Sets the associated {@link #getLabelFor labelFor}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabelFor(
      /**
       * ID of an element which becomes the new target of this labelFor association; alternatively, an element
       * instance may be given
       */
      oLabelFor: ID | Control
    ): this;
    /**
     * Sets a new value for property {@link #getRequired required}.
     *
     * Defines whether an asterisk character is added to the component text.
     *
     *  **Note:** Usually indicates that user input (bound with the `for` property) is required. In that case
     * the required</> property of the corresponding input should also be set.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRequired(
      /**
       * New value for property `required`
       */
      bRequired?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowColon showColon}.
     *
     * Defines whether colon is added to the component text.
     *
     *  **Note:** Usually used in forms.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowColon(
      /**
       * New value for property `showColon`
       */
      bShowColon?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Defines the content of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getWrappingType wrappingType}.
     *
     * Defines how the text of a component will be displayed when there is not enough space.
     *  **Note:** for option "Normal" the text will wrap and the words will not be broken based on hyphenation.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWrappingType(
      /**
       * New value for property `wrappingType`
       */
      sWrappingType?: WrappingType | keyof typeof WrappingType
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Label constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $LabelSettings extends $WebComponentSettings {
    /**
     * Defines whether an asterisk character is added to the component text.
     *
     *  **Note:** Usually indicates that user input (bound with the `for` property) is required. In that case
     * the required</> property of the corresponding input should also be set.
     */
    required?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether colon is added to the component text.
     *
     *  **Note:** Usually used in forms.
     */
    showColon?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the content of the control
     */
    text?: string | PropertyBindingInfo;

    /**
     * Defines the width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines how the text of a component will be displayed when there is not enough space.
     *  **Note:** for option "Normal" the text will wrap and the words will not be broken based on hyphenation.
     */
    wrappingType?:
      | (WrappingType | keyof typeof WrappingType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Association to the labelled control.
     *
     *
     * By default, the label sets the for attribute to the ID of the labelled control. This can be changed by
     * implementing the function getIdForLabel on the labelled control.
     */
    labelFor?: Control | string;
  }
}

declare module "sap/ui/webc/main/Link" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { ID } from "sap/ui/core/library";

  import Control from "sap/ui/core/Control";

  import { LinkDesign, WrappingType } from "sap/ui/webc/main/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Overview: The `sap.ui.webc.main.Link` is a hyperlink component that is used to navigate to other apps
   * and web pages, or to trigger actions. It is a clickable text element, visualized in such a way that it
   * stands out from the standard text. On hover, it changes its style to an underlined text to provide additional
   * feedback to the user.
   *
   * Usage:
   *
   * You can set the `sap.ui.webc.main.Link` to be enabled or disabled.
   *
   *  To create a visual hierarchy in large lists of links, you can set the less important links as `Subtle`
   * or the more important ones as `Emphasized`, by using the `design` property.
   *
   *  If the `href` property is set, the link behaves as the HTML anchor tag (`<a><a/>`) and
   * opens the specified URL in the given target frame (`target` property). To specify where the linked content
   * is opened, you can use the `target` property.
   *
   * Responsive behavior:
   *
   * If there is not enough space, the text of the `sap.ui.webc.main.Link` becomes truncated. If the `wrappingType`
   * property is set to `"Normal"`, the text is displayed on several lines instead of being truncated.
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class Link extends WebComponent {
    /**
     * Constructor for a new `Link`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $LinkSettings
    );
    /**
     * Constructor for a new `Link`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $LinkSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.Link with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Link>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.Link.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.webc.main.Link`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Link` itself.
     *
     * Fired when the component is triggered either with a mouse/tap or by using the Enter key.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Link$ClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Link` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:click click} event of this `sap.ui.webc.main.Link`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Link` itself.
     *
     * Fired when the component is triggered either with a mouse/tap or by using the Enter key.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Link$ClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Link` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:click click} event of this `sap.ui.webc.main.Link`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Link$ClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:click click} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Link$ClickEventParameters
    ): boolean;
    /**
     * Gets current value of property {@link #getAccessibilityAttributes accessibilityAttributes}.
     *
     * An object of strings that defines several additional accessibility attribute values for customization
     * depending on the use case.
     *
     * It supports the following fields:
     *
     *
     * 	 - `expanded`: Indicates whether the anchor element, or another grouping element it controls, is currently
     *     expanded or collapsed. Accepts the following string values:
     * 	`true`
     * 	 - `false`
     * 	 - `hasPopup`: Indicates the availability and type of interactive popup element, such as menu or dialog,
     *     that can be triggered by the anchor element. Accepts the following string values:
     * 	`Dialog`
     * 	 - `Grid`
     * 	 - `ListBox`
     * 	 - `Menu`
     * 	 - `Tree`
     *
     * Default value is `{}`.
     *
     *
     * @returns Value of property `accessibilityAttributes`
     */
    getAccessibilityAttributes(): object;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Gets current value of property {@link #getAccessibleRole accessibleRole}.
     *
     * Defines the ARIA role of the component.
     *
     * **Note:** Use the "button" role in cases when navigation is not expected to occur and the href property
     * is not defined.
     *
     * Default value is `"link"`.
     *
     *
     * @returns Value of property `accessibleRole`
     */
    getAccessibleRole(): string;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getDesign design}.
     *
     * Defines the component design.
     *
     *  **Note:** Avaialble options are `Default`, `Subtle`, and `Emphasized`.
     *
     * Default value is `Default`.
     *
     *
     * @returns Value of property `design`
     */
    getDesign(): LinkDesign | keyof typeof LinkDesign;
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getHref href}.
     *
     * Defines the component href.
     *
     *  **Note:** Standard hyperlink behavior is supported.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `href`
     */
    getHref(): string;
    /**
     * Gets current value of property {@link #getTarget target}.
     *
     * Defines the component target.
     *
     *  **Notes:**
     *
     *
     * 	 - `_self`
     * 	 - `_top`
     * 	 - `_blank`
     * 	 - `_parent`
     * 	 - `_search`
     *
     * **This property must only be used when the `href` property is set.**
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `target`
     */
    getTarget(): string;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Defines the content of the control
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets current value of property {@link #getWrappingType wrappingType}.
     *
     * Defines how the text of a component will be displayed when there is not enough space.
     *  **Note:** for option "Normal" the text will wrap and the words will not be broken based on hyphenation.
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `wrappingType`
     */
    getWrappingType(): WrappingType | keyof typeof WrappingType;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Sets a new value for property {@link #getAccessibilityAttributes accessibilityAttributes}.
     *
     * An object of strings that defines several additional accessibility attribute values for customization
     * depending on the use case.
     *
     * It supports the following fields:
     *
     *
     * 	 - `expanded`: Indicates whether the anchor element, or another grouping element it controls, is currently
     *     expanded or collapsed. Accepts the following string values:
     * 	`true`
     * 	 - `false`
     * 	 - `hasPopup`: Indicates the availability and type of interactive popup element, such as menu or dialog,
     *     that can be triggered by the anchor element. Accepts the following string values:
     * 	`Dialog`
     * 	 - `Grid`
     * 	 - `ListBox`
     * 	 - `Menu`
     * 	 - `Tree`
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `{}`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibilityAttributes(
      /**
       * New value for property `accessibilityAttributes`
       */
      oAccessibilityAttributes?: object
    ): this;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getAccessibleRole accessibleRole}.
     *
     * Defines the ARIA role of the component.
     *
     * **Note:** Use the "button" role in cases when navigation is not expected to occur and the href property
     * is not defined.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"link"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleRole(
      /**
       * New value for property `accessibleRole`
       */
      sAccessibleRole?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDesign design}.
     *
     * Defines the component design.
     *
     *  **Note:** Avaialble options are `Default`, `Subtle`, and `Emphasized`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Default`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDesign(
      /**
       * New value for property `design`
       */
      sDesign?: LinkDesign | keyof typeof LinkDesign
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHref href}.
     *
     * Defines the component href.
     *
     *  **Note:** Standard hyperlink behavior is supported.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHref(
      /**
       * New value for property `href`
       */
      sHref?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTarget target}.
     *
     * Defines the component target.
     *
     *  **Notes:**
     *
     *
     * 	 - `_self`
     * 	 - `_top`
     * 	 - `_blank`
     * 	 - `_parent`
     * 	 - `_search`
     *
     * **This property must only be used when the `href` property is set.**
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTarget(
      /**
       * New value for property `target`
       */
      sTarget?: string
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Defines the content of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWrappingType wrappingType}.
     *
     * Defines how the text of a component will be displayed when there is not enough space.
     *  **Note:** for option "Normal" the text will wrap and the words will not be broken based on hyphenation.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWrappingType(
      /**
       * New value for property `wrappingType`
       */
      sWrappingType?: WrappingType | keyof typeof WrappingType
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Link constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $LinkSettings extends $WebComponentSettings {
    /**
     * An object of strings that defines several additional accessibility attribute values for customization
     * depending on the use case.
     *
     * It supports the following fields:
     *
     *
     * 	 - `expanded`: Indicates whether the anchor element, or another grouping element it controls, is currently
     *     expanded or collapsed. Accepts the following string values:
     * 	`true`
     * 	 - `false`
     * 	 - `hasPopup`: Indicates the availability and type of interactive popup element, such as menu or dialog,
     *     that can be triggered by the anchor element. Accepts the following string values:
     * 	`Dialog`
     * 	 - `Grid`
     * 	 - `ListBox`
     * 	 - `Menu`
     * 	 - `Tree`
     */
    accessibilityAttributes?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the accessible ARIA name of the component.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * Defines the ARIA role of the component.
     *
     * **Note:** Use the "button" role in cases when navigation is not expected to occur and the href property
     * is not defined.
     */
    accessibleRole?: string | PropertyBindingInfo;

    /**
     * Defines the component design.
     *
     *  **Note:** Avaialble options are `Default`, `Subtle`, and `Emphasized`.
     */
    design?:
      | (LinkDesign | keyof typeof LinkDesign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the component href.
     *
     *  **Note:** Standard hyperlink behavior is supported.
     */
    href?: string | PropertyBindingInfo;

    /**
     * Defines the component target.
     *
     *  **Notes:**
     *
     *
     * 	 - `_self`
     * 	 - `_top`
     * 	 - `_blank`
     * 	 - `_parent`
     * 	 - `_search`
     *
     * **This property must only be used when the `href` property is set.**
     */
    target?: string | PropertyBindingInfo;

    /**
     * Defines the content of the control
     */
    text?: string | PropertyBindingInfo;

    /**
     * Defines how the text of a component will be displayed when there is not enough space.
     *  **Note:** for option "Normal" the text will wrap and the words will not be broken based on hyphenation.
     */
    wrappingType?:
      | (WrappingType | keyof typeof WrappingType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Receives id(or many ids) of the controls that label this control.
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Fired when the component is triggered either with a mouse/tap or by using the Enter key.
     */
    click?: (oEvent: Link$ClickEvent) => void;
  }

  /**
   * Parameters of the Link#click event.
   */
  export interface Link$ClickEventParameters {
    /**
     * Returns whether the "ALT" key was pressed when the event was triggered.
     */
    altKey?: boolean;

    /**
     * Returns whether the "CTRL" key was pressed when the event was triggered.
     */
    ctrlKey?: boolean;

    /**
     * Returns whether the "META" key was pressed when the event was triggered.
     */
    metaKey?: boolean;

    /**
     * Returns whether the "SHIFT" key was pressed when the event was triggered.
     */
    shiftKey?: boolean;
  }

  /**
   * Event object of the Link#click event.
   */
  export type Link$ClickEvent = Event<Link$ClickEventParameters, Link>;
}

declare module "sap/ui/webc/main/List" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { ID, CSSSize } from "sap/ui/core/library";

  import Control from "sap/ui/core/Control";

  import {
    IListItem,
    ListGrowingMode,
    ListMode,
    ListSeparators,
  } from "sap/ui/webc/main/library";

  import Event from "sap/ui/base/Event";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * The `sap.ui.webc.main.List` component allows displaying a list of items, advanced keyboard handling support
   * for navigating between items, and predefined modes to improve the development efficiency.
   *
   *  The `sap.ui.webc.main.List` is a container for the available list items:
   * 	 - `sap.ui.webc.main.StandardListItem`
   * 	 - `sap.ui.webc.main.CustomListItem`
   * 	 - `sap.ui.webc.main.GroupHeaderListItem`
   *
   *  To benefit from the built-in selection mechanism, you can use the available selection modes, such as
   * `SingleSelect`, `MultiSelect` and `Delete`.
   *
   *  Additionally, the `sap.ui.webc.main.List` provides header, footer, and customization for the list item
   * separators.
   *
   *
   *
   *  Keyboard Handling:
   *
   * Basic Navigation: The `sap.ui.webc.main.List` provides advanced keyboard handling. When a list is focused
   * the user can use the following keyboard shortcuts in order to perform a navigation:
   *
   *
   *
   * 	 - [UP/DOWN] - Navigates up and down the items
   * 	 - [HOME] - Navigates to first item
   * 	 - [END] - Navigates to the last item
   *
   * The user can use the following keyboard shortcuts to perform actions (such as select, delete), when the
   * `mode` property is in use:
   * 	 - [SPACE] - Select an item (if `type` is 'Active') when `mode` is selection
   * 	 - [DELETE] - Delete an item if `mode` property is `Delete`
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class List extends WebComponent {
    /**
     * Constructor for a new `List`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ListSettings
    );
    /**
     * Constructor for a new `List`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ListSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.List with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, List>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.List.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some header to the aggregation {@link #getHeader header}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addHeader(
      /**
       * The header to add; if empty, nothing is inserted
       */
      oHeader: Control
    ): this;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: IListItem
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemClick itemClick} event of this `sap.ui.webc.main.List`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.List` itself.
     *
     * Fired when an item is activated, unless the item's `type` property is set to `Inactive`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: List$ItemClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.List` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemClick itemClick} event of this `sap.ui.webc.main.List`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.List` itself.
     *
     * Fired when an item is activated, unless the item's `type` property is set to `Inactive`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: List$ItemClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.List` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemClose itemClose} event of this `sap.ui.webc.main.List`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.List` itself.
     *
     * Fired when the `Close` button of any item is clicked
     *
     *  **Note:** This event is only applicable to list items that can be closed (such as notification list
     * items), not to be confused with `item-delete`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemClose(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: List$ItemCloseEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.List` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemClose itemClose} event of this `sap.ui.webc.main.List`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.List` itself.
     *
     * Fired when the `Close` button of any item is clicked
     *
     *  **Note:** This event is only applicable to list items that can be closed (such as notification list
     * items), not to be confused with `item-delete`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemClose(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: List$ItemCloseEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.List` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemDelete itemDelete} event of this `sap.ui.webc.main.List`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.List` itself.
     *
     * Fired when the Delete button of any item is pressed.
     *
     *  **Note:** A Delete button is displayed on each item, when the component `mode` property is set to `Delete`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemDelete(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: List$ItemDeleteEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.List` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemDelete itemDelete} event of this `sap.ui.webc.main.List`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.List` itself.
     *
     * Fired when the Delete button of any item is pressed.
     *
     *  **Note:** A Delete button is displayed on each item, when the component `mode` property is set to `Delete`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemDelete(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: List$ItemDeleteEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.List` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemToggle itemToggle} event of this `sap.ui.webc.main.List`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.List` itself.
     *
     * Fired when the `Toggle` button of any item is clicked.
     *
     *  **Note:** This event is only applicable to list items that can be toggled (such as notification group
     * list items).
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemToggle(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: List$ItemToggleEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.List` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemToggle itemToggle} event of this `sap.ui.webc.main.List`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.List` itself.
     *
     * Fired when the `Toggle` button of any item is clicked.
     *
     *  **Note:** This event is only applicable to list items that can be toggled (such as notification group
     * list items).
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemToggle(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: List$ItemToggleEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.List` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:loadMore loadMore} event of this `sap.ui.webc.main.List`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.List` itself.
     *
     * Fired when the user scrolls to the bottom of the list.
     *
     *  **Note:** The event is fired when the `growing='Scroll'` property is enabled.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLoadMore(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.List` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:loadMore loadMore} event of this `sap.ui.webc.main.List`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.List` itself.
     *
     * Fired when the user scrolls to the bottom of the list.
     *
     *  **Note:** The event is fired when the `growing='Scroll'` property is enabled.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLoadMore(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.List` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionChange selectionChange} event of this
     * `sap.ui.webc.main.List`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.List` itself.
     *
     * Fired when selection is changed by user interaction in `SingleSelect`, `SingleSelectBegin`, `SingleSelectEnd`
     * and `MultiSelect` modes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: List$SelectionChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.List` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionChange selectionChange} event of this
     * `sap.ui.webc.main.List`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.List` itself.
     *
     * Fired when selection is changed by user interaction in `SingleSelect`, `SingleSelectBegin`, `SingleSelectEnd`
     * and `MultiSelect` modes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: List$SelectionChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.List` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the header in the aggregation {@link #getHeader header}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyHeader(): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:itemClick itemClick} event of this `sap.ui.webc.main.List`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachItemClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: List$ItemClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:itemClose itemClose} event of this `sap.ui.webc.main.List`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachItemClose(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: List$ItemCloseEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:itemDelete itemDelete} event of this `sap.ui.webc.main.List`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachItemDelete(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: List$ItemDeleteEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:itemToggle itemToggle} event of this `sap.ui.webc.main.List`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachItemToggle(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: List$ItemToggleEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:loadMore loadMore} event of this `sap.ui.webc.main.List`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachLoadMore(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectionChange selectionChange} event of
     * this `sap.ui.webc.main.List`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectionChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: List$SelectionChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:itemClick itemClick} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireItemClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: List$ItemClickEventParameters
    ): boolean;
    /**
     * Fires event {@link #event:itemClose itemClose} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireItemClose(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: List$ItemCloseEventParameters
    ): this;
    /**
     * Fires event {@link #event:itemDelete itemDelete} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireItemDelete(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: List$ItemDeleteEventParameters
    ): this;
    /**
     * Fires event {@link #event:itemToggle itemToggle} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireItemToggle(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: List$ItemToggleEventParameters
    ): this;
    /**
     * Fires event {@link #event:loadMore loadMore} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireLoadMore(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectionChange selectionChange} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireSelectionChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: List$SelectionChangeEventParameters
    ): boolean;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible name of the component.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Gets current value of property {@link #getAccessibleRole accessibleRole}.
     *
     * Defines the accessible role of the component.
     *
     *
     *
     * Default value is `"list"`.
     *
     *
     * @returns Value of property `accessibleRole`
     */
    getAccessibleRole(): string;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getBusy busy}.
     *
     * Defines if the component would display a loading indicator over the list.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `busy`
     */
    getBusy(): boolean;
    /**
     * Gets current value of property {@link #getBusyDelay busyDelay}.
     *
     * Defines the delay in milliseconds, after which the busy indicator will show up for this component.
     *
     * Default value is `1000`.
     *
     *
     * @returns Value of property `busyDelay`
     */
    getBusyDelay(): int;
    /**
     * Gets current value of property {@link #getFooterText footerText}.
     *
     * Defines the footer text.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `footerText`
     */
    getFooterText(): string;
    /**
     * Gets current value of property {@link #getGrowing growing}.
     *
     * Defines whether the component will have growing capability either by pressing a `More` button, or via
     * user scroll. In both cases `load-more` event is fired.
     *
     *
     *
     * Available options:
     *
     *  `Button` - Shows a `More` button at the bottom of the list, pressing of which triggers the `load-more`
     * event.
     *  `Scroll` - The `load-more` event is triggered when the user scrolls to the bottom of the list;
     *  `None` (default) - The growing is off.
     *
     *
     *
     * **Restrictions:** `growing="Scroll"` is not supported for Internet Explorer, on IE the component will
     * fallback to `growing="Button"`.
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `growing`
     */
    getGrowing(): ListGrowingMode | keyof typeof ListGrowingMode;
    /**
     * Gets content of aggregation {@link #getHeader header}.
     *
     * Defines the component header.
     *
     *  **Note:** When `header` is set, the `headerText` property is ignored.
     */
    getHeader(): Control[];
    /**
     * Gets current value of property {@link #getHeaderText headerText}.
     *
     * Defines the component header text.
     *
     *  **Note:** If `header` is set this property is ignored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `headerText`
     */
    getHeaderText(): string;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Defines the height of the control
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getIndent indent}.
     *
     * Determines whether the component is indented.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `indent`
     */
    getIndent(): boolean;
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * Defines the items of the component.
     *
     *  **Note:** Use `sap.ui.webc.main.StandardListItem`, `sap.ui.webc.main.CustomListItem`, and `sap.ui.webc.main.GroupHeaderListItem`
     * for the intended design.
     */
    getItems(): IListItem[];
    /**
     * Gets current value of property {@link #getMode mode}.
     *
     * Defines the mode of the component.
     *
     *  **Note:** Available options are `None`, `SingleSelect`, `SingleSelectBegin`, `SingleSelectEnd`, `MultiSelect`,
     * and `Delete`.
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `mode`
     */
    getMode(): ListMode | keyof typeof ListMode;
    /**
     * Gets current value of property {@link #getNoDataText noDataText}.
     *
     * Defines the text that is displayed when the component contains no items.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `noDataText`
     */
    getNoDataText(): string;
    /**
     * Gets current value of property {@link #getSeparators separators}.
     *
     * Defines the item separator style that is used.
     *
     *  **Notes:**
     * 	 - Avalaible options are `All`, `Inner`, and `None`.
     * 	 - When set to `None`, none of the items are separated by horizontal lines.
     * 	 - When set to `Inner`, the first item doesn't have a top separator and the last item doesn't have a
     *     bottom separator.
     *
     * Default value is `All`.
     *
     *
     * @returns Value of property `separators`
     */
    getSeparators(): ListSeparators | keyof typeof ListSeparators;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getHeader header}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfHeader(
      /**
       * The header whose index is looked for
       */
      oHeader: Control
    ): int;
    /**
     * Checks for the provided `sap.ui.webc.main.IListItem` in the aggregation {@link #getItems items}. and
     * returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: IListItem
    ): int;
    /**
     * Inserts a header into the aggregation {@link #getHeader header}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertHeader(
      /**
       * The header to insert; if empty, nothing is inserted
       */
      oHeader: Control,
      /**
       * The `0`-based index the header should be inserted at; for a negative value of `iIndex`, the header is
       * inserted at position 0; for a value greater than the current size of the aggregation, the header is inserted
       * at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: IListItem,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getHeader header}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllHeader(): Control[];
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): IListItem[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a header from the aggregation {@link #getHeader header}.
     *
     *
     * @returns The removed header or `null`
     */
    removeHeader(
      /**
       * The header to remove or its index or id
       */
      vHeader: int | string | Control
    ): Control | null;
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | IListItem
    ): IListItem | null;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible name of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getAccessibleRole accessibleRole}.
     *
     * Defines the accessible role of the component.
     *
     *
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"list"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleRole(
      /**
       * New value for property `accessibleRole`
       */
      sAccessibleRole?: string
    ): this;
    /**
     * Sets a new value for property {@link #getBusy busy}.
     *
     * Defines if the component would display a loading indicator over the list.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBusy(
      /**
       * New value for property `busy`
       */
      bBusy?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getBusyDelay busyDelay}.
     *
     * Defines the delay in milliseconds, after which the busy indicator will show up for this component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1000`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBusyDelay(
      /**
       * New value for property `busyDelay`
       */
      iBusyDelay?: int
    ): this;
    /**
     * Sets a new value for property {@link #getFooterText footerText}.
     *
     * Defines the footer text.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFooterText(
      /**
       * New value for property `footerText`
       */
      sFooterText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getGrowing growing}.
     *
     * Defines whether the component will have growing capability either by pressing a `More` button, or via
     * user scroll. In both cases `load-more` event is fired.
     *
     *
     *
     * Available options:
     *
     *  `Button` - Shows a `More` button at the bottom of the list, pressing of which triggers the `load-more`
     * event.
     *  `Scroll` - The `load-more` event is triggered when the user scrolls to the bottom of the list;
     *  `None` (default) - The growing is off.
     *
     *
     *
     * **Restrictions:** `growing="Scroll"` is not supported for Internet Explorer, on IE the component will
     * fallback to `growing="Button"`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGrowing(
      /**
       * New value for property `growing`
       */
      sGrowing?: ListGrowingMode | keyof typeof ListGrowingMode
    ): this;
    /**
     * Sets a new value for property {@link #getHeaderText headerText}.
     *
     * Defines the component header text.
     *
     *  **Note:** If `header` is set this property is ignored.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeaderText(
      /**
       * New value for property `headerText`
       */
      sHeaderText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * Defines the height of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getIndent indent}.
     *
     * Determines whether the component is indented.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIndent(
      /**
       * New value for property `indent`
       */
      bIndent?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getMode mode}.
     *
     * Defines the mode of the component.
     *
     *  **Note:** Available options are `None`, `SingleSelect`, `SingleSelectBegin`, `SingleSelectEnd`, `MultiSelect`,
     * and `Delete`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMode(
      /**
       * New value for property `mode`
       */
      sMode?: ListMode | keyof typeof ListMode
    ): this;
    /**
     * Sets a new value for property {@link #getNoDataText noDataText}.
     *
     * Defines the text that is displayed when the component contains no items.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNoDataText(
      /**
       * New value for property `noDataText`
       */
      sNoDataText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSeparators separators}.
     *
     * Defines the item separator style that is used.
     *
     *  **Notes:**
     * 	 - Avalaible options are `All`, `Inner`, and `None`.
     * 	 - When set to `None`, none of the items are separated by horizontal lines.
     * 	 - When set to `Inner`, the first item doesn't have a top separator and the last item doesn't have a
     *     bottom separator.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `All`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSeparators(
      /**
       * New value for property `separators`
       */
      sSeparators?: ListSeparators | keyof typeof ListSeparators
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the List constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $ListSettings extends $WebComponentSettings {
    /**
     * Defines the accessible name of the component.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * Defines the accessible role of the component.
     */
    accessibleRole?: string | PropertyBindingInfo;

    /**
     * Defines if the component would display a loading indicator over the list.
     */
    busy?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the delay in milliseconds, after which the busy indicator will show up for this component.
     */
    busyDelay?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the footer text.
     */
    footerText?: string | PropertyBindingInfo;

    /**
     * Defines whether the component will have growing capability either by pressing a `More` button, or via
     * user scroll. In both cases `load-more` event is fired.
     *
     *
     *
     * Available options:
     *
     *  `Button` - Shows a `More` button at the bottom of the list, pressing of which triggers the `load-more`
     * event.
     *  `Scroll` - The `load-more` event is triggered when the user scrolls to the bottom of the list;
     *  `None` (default) - The growing is off.
     *
     *
     *
     * **Restrictions:** `growing="Scroll"` is not supported for Internet Explorer, on IE the component will
     * fallback to `growing="Button"`.
     */
    growing?:
      | (ListGrowingMode | keyof typeof ListGrowingMode)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the component header text.
     *
     *  **Note:** If `header` is set this property is ignored.
     */
    headerText?: string | PropertyBindingInfo;

    /**
     * Defines the height of the control
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the component is indented.
     */
    indent?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the mode of the component.
     *
     *  **Note:** Available options are `None`, `SingleSelect`, `SingleSelectBegin`, `SingleSelectEnd`, `MultiSelect`,
     * and `Delete`.
     */
    mode?:
      | (ListMode | keyof typeof ListMode)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the text that is displayed when the component contains no items.
     */
    noDataText?: string | PropertyBindingInfo;

    /**
     * Defines the item separator style that is used.
     *
     *  **Notes:**
     * 	 - Avalaible options are `All`, `Inner`, and `None`.
     * 	 - When set to `None`, none of the items are separated by horizontal lines.
     * 	 - When set to `Inner`, the first item doesn't have a top separator and the last item doesn't have a
     *     bottom separator.
     */
    separators?:
      | (ListSeparators | keyof typeof ListSeparators)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the component header.
     *
     *  **Note:** When `header` is set, the `headerText` property is ignored.
     */
    header?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * Defines the items of the component.
     *
     *  **Note:** Use `sap.ui.webc.main.StandardListItem`, `sap.ui.webc.main.CustomListItem`, and `sap.ui.webc.main.GroupHeaderListItem`
     * for the intended design.
     */
    items?: IListItem[] | IListItem | AggregationBindingInfo | `{${string}}`;

    /**
     * Receives id(or many ids) of the controls that label this control.
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Fired when an item is activated, unless the item's `type` property is set to `Inactive`.
     */
    itemClick?: (oEvent: List$ItemClickEvent) => void;

    /**
     * Fired when the `Close` button of any item is clicked
     *
     *  **Note:** This event is only applicable to list items that can be closed (such as notification list
     * items), not to be confused with `item-delete`.
     */
    itemClose?: (oEvent: List$ItemCloseEvent) => void;

    /**
     * Fired when the Delete button of any item is pressed.
     *
     *  **Note:** A Delete button is displayed on each item, when the component `mode` property is set to `Delete`.
     */
    itemDelete?: (oEvent: List$ItemDeleteEvent) => void;

    /**
     * Fired when the `Toggle` button of any item is clicked.
     *
     *  **Note:** This event is only applicable to list items that can be toggled (such as notification group
     * list items).
     */
    itemToggle?: (oEvent: List$ItemToggleEvent) => void;

    /**
     * Fired when the user scrolls to the bottom of the list.
     *
     *  **Note:** The event is fired when the `growing='Scroll'` property is enabled.
     */
    loadMore?: (oEvent: Event) => void;

    /**
     * Fired when selection is changed by user interaction in `SingleSelect`, `SingleSelectBegin`, `SingleSelectEnd`
     * and `MultiSelect` modes.
     */
    selectionChange?: (oEvent: List$SelectionChangeEvent) => void;
  }

  /**
   * Parameters of the List#itemClick event.
   */
  export interface List$ItemClickEventParameters {
    /**
     * The clicked item.
     */
    item?: HTMLElement;
  }

  /**
   * Event object of the List#itemClick event.
   */
  export type List$ItemClickEvent = Event<List$ItemClickEventParameters, List>;

  /**
   * Parameters of the List#itemClose event.
   */
  export interface List$ItemCloseEventParameters {
    /**
     * the item about to be closed.
     */
    item?: HTMLElement;
  }

  /**
   * Event object of the List#itemClose event.
   */
  export type List$ItemCloseEvent = Event<List$ItemCloseEventParameters, List>;

  /**
   * Parameters of the List#itemDelete event.
   */
  export interface List$ItemDeleteEventParameters {
    /**
     * the deleted item.
     */
    item?: HTMLElement;
  }

  /**
   * Event object of the List#itemDelete event.
   */
  export type List$ItemDeleteEvent = Event<
    List$ItemDeleteEventParameters,
    List
  >;

  /**
   * Parameters of the List#itemToggle event.
   */
  export interface List$ItemToggleEventParameters {
    /**
     * the toggled item.
     */
    item?: HTMLElement;
  }

  /**
   * Event object of the List#itemToggle event.
   */
  export type List$ItemToggleEvent = Event<
    List$ItemToggleEventParameters,
    List
  >;

  /**
   * Parameters of the List#loadMore event.
   */
  export interface List$LoadMoreEventParameters {}

  /**
   * Event object of the List#loadMore event.
   */
  export type List$LoadMoreEvent = Event<List$LoadMoreEventParameters, List>;

  /**
   * Parameters of the List#selectionChange event.
   */
  export interface List$SelectionChangeEventParameters {
    /**
     * An array of the selected items.
     */
    selectedItems?: any[];

    /**
     * An array of the previously selected items.
     */
    previouslySelectedItems?: any[];
  }

  /**
   * Event object of the List#selectionChange event.
   */
  export type List$SelectionChangeEvent = Event<
    List$SelectionChangeEventParameters,
    List
  >;
}

declare module "sap/ui/webc/main/Menu" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IMenuItem } from "sap/ui/webc/main/library";

  import Event from "sap/ui/base/Event";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { ID } from "sap/ui/core/library";

  import Control from "sap/ui/core/Control";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * `sap.ui.webc.main.Menu` component represents a hierarchical menu structure.
   *
   * Usage:
   *
   * `sap.ui.webc.main.Menu` contains `sap.ui.webc.main.MenuItem` components. An arbitrary hierarchy structure
   * can be represented by recursively nesting menu items.
   *
   * Keyboard Handling:
   *
   * The `sap.ui.webc.main.Menu` provides advanced keyboard handling. The user can use the following keyboard
   * shortcuts in order to navigate trough the tree:
   * 	 - `Arrow Up` / `Arrow Down` - Navigates up and down the menu items that are currently visible.
   * 	 - `Arrow Right`, `Space` or `Enter` - Opens a sub-menu if there are menu items nested in the currently
   *     clicked menu item.
   * 	 - `Arrow Left` or `Escape` - Closes the currently opened sub-menu.  Note: if the text ditrection
   *     is set to Right-to-left (RTL), `Arrow Right` and `Arrow Left` functionality is swapped.
   *
   *
   * @since 1.102.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.102.0) - This control is experimental and its API might change significantly.
   */
  export default class Menu extends WebComponent {
    /**
     * Constructor for a new `Menu`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $MenuSettings
    );
    /**
     * Constructor for a new `Menu`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $MenuSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.Menu with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Menu>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.Menu.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: IMenuItem
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterClose afterClose} event of this `sap.ui.webc.main.Menu`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Menu` itself.
     *
     * Fired after the menu is closed. **This event does not bubble.**
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterClose(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Menu` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterClose afterClose} event of this `sap.ui.webc.main.Menu`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Menu` itself.
     *
     * Fired after the menu is closed. **This event does not bubble.**
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterClose(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Menu` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterOpen afterOpen} event of this `sap.ui.webc.main.Menu`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Menu` itself.
     *
     * Fired after the menu is opened. **This event does not bubble.**
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterOpen(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Menu` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterOpen afterOpen} event of this `sap.ui.webc.main.Menu`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Menu` itself.
     *
     * Fired after the menu is opened. **This event does not bubble.**
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterOpen(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Menu` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeClose beforeClose} event of this `sap.ui.webc.main.Menu`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Menu` itself.
     *
     * Fired before the menu is closed. This event can be cancelled, which will prevent the menu from closing.
     * **This event does not bubble.**
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeClose(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Menu$BeforeCloseEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Menu` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeClose beforeClose} event of this `sap.ui.webc.main.Menu`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Menu` itself.
     *
     * Fired before the menu is closed. This event can be cancelled, which will prevent the menu from closing.
     * **This event does not bubble.**
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeClose(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Menu$BeforeCloseEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Menu` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeOpen beforeOpen} event of this `sap.ui.webc.main.Menu`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Menu` itself.
     *
     * Fired before the menu is opened. This event can be cancelled, which will prevent the menu from opening.
     * **This event does not bubble.** **Note:** Since 1.14.0 the event is also fired before a sub-menu opens.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeOpen(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Menu$BeforeOpenEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Menu` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeOpen beforeOpen} event of this `sap.ui.webc.main.Menu`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Menu` itself.
     *
     * Fired before the menu is opened. This event can be cancelled, which will prevent the menu from opening.
     * **This event does not bubble.** **Note:** Since 1.14.0 the event is also fired before a sub-menu opens.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeOpen(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Menu$BeforeOpenEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Menu` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemClick itemClick} event of this `sap.ui.webc.main.Menu`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Menu` itself.
     *
     * Fired when an item is being clicked. **Note:** Since 1.17.0 the event is preventable, allowing the menu
     * to remain open after an item is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Menu$ItemClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Menu` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:itemClick itemClick} event of this `sap.ui.webc.main.Menu`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Menu` itself.
     *
     * Fired when an item is being clicked. **Note:** Since 1.17.0 the event is preventable, allowing the menu
     * to remain open after an item is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachItemClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Menu$ItemClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Menu` itself
       */
      oListener?: object
    ): this;
    /**
     * Closes the Menu.
     */
    close(): void;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:afterClose afterClose} event of this `sap.ui.webc.main.Menu`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAfterClose(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:afterOpen afterOpen} event of this `sap.ui.webc.main.Menu`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAfterOpen(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:beforeClose beforeClose} event of this `sap.ui.webc.main.Menu`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachBeforeClose(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Menu$BeforeCloseEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:beforeOpen beforeOpen} event of this `sap.ui.webc.main.Menu`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachBeforeOpen(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Menu$BeforeOpenEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:itemClick itemClick} event of this `sap.ui.webc.main.Menu`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachItemClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Menu$ItemClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:afterClose afterClose} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAfterClose(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:afterOpen afterOpen} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAfterOpen(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:beforeClose beforeClose} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireBeforeClose(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Menu$BeforeCloseEventParameters
    ): boolean;
    /**
     * Fires event {@link #event:beforeOpen beforeOpen} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireBeforeOpen(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Menu$BeforeOpenEventParameters
    ): boolean;
    /**
     * Fires event {@link #event:itemClick itemClick} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireItemClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Menu$ItemClickEventParameters
    ): boolean;
    /**
     * Gets current value of property {@link #getBusy busy}.
     *
     * Defines if a loading indicator would be displayed inside the corresponding ui5-menu popover.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `busy`
     */
    getBusy(): boolean;
    /**
     * Gets current value of property {@link #getBusyDelay busyDelay}.
     *
     * Defines the delay in milliseconds, after which the busy indicator will be displayed inside the corresponding
     * ui5-menu popover..
     *
     * Default value is `1000`.
     *
     *
     * @returns Value of property `busyDelay`
     */
    getBusyDelay(): int;
    /**
     * Gets current value of property {@link #getHeaderText headerText}.
     *
     * Defines the header text of the menu (displayed on mobile).
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `headerText`
     */
    getHeaderText(): string;
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * Defines the items of this component.
     *
     *  **Note:** Use `sap.ui.webc.main.MenuItem` for the intended design.
     */
    getItems(): IMenuItem[];
    /**
     * Gets current value of property {@link #getOpen open}.
     *
     * Indicates if the menu is open
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `open`
     */
    getOpen(): boolean;
    /**
     * ID of the element which is the current target of the association {@link #getOpener opener}, or `null`.
     */
    getOpener(): ID;
    /**
     * Checks for the provided `sap.ui.webc.main.IMenuItem` in the aggregation {@link #getItems items}. and
     * returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: IMenuItem
    ): int;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: IMenuItem,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): IMenuItem[];
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | IMenuItem
    ): IMenuItem | null;
    /**
     * Sets a new value for property {@link #getBusy busy}.
     *
     * Defines if a loading indicator would be displayed inside the corresponding ui5-menu popover.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBusy(
      /**
       * New value for property `busy`
       */
      bBusy?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getBusyDelay busyDelay}.
     *
     * Defines the delay in milliseconds, after which the busy indicator will be displayed inside the corresponding
     * ui5-menu popover..
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1000`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBusyDelay(
      /**
       * New value for property `busyDelay`
       */
      iBusyDelay?: int
    ): this;
    /**
     * Sets a new value for property {@link #getHeaderText headerText}.
     *
     * Defines the header text of the menu (displayed on mobile).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeaderText(
      /**
       * New value for property `headerText`
       */
      sHeaderText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getOpen open}.
     *
     * Indicates if the menu is open
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOpen(
      /**
       * New value for property `open`
       */
      bOpen?: boolean
    ): this;
    /**
     * Sets the associated {@link #getOpener opener}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOpener(
      /**
       * ID of an element which becomes the new target of this opener association; alternatively, an element instance
       * may be given
       */
      oOpener: ID | Control
    ): this;
    /**
     * Shows the Menu near the opener element.
     */
    showAt(
      /**
       * the element that the popover is shown at
       */
      opener: HTMLElement
    ): void;
  }
  /**
   * Describes the settings that can be provided to the Menu constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.102.0) - This control is experimental and its API might change significantly.
   */
  export interface $MenuSettings extends $WebComponentSettings {
    /**
     * Defines if a loading indicator would be displayed inside the corresponding ui5-menu popover.
     */
    busy?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the delay in milliseconds, after which the busy indicator will be displayed inside the corresponding
     * ui5-menu popover..
     */
    busyDelay?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the header text of the menu (displayed on mobile).
     */
    headerText?: string | PropertyBindingInfo;

    /**
     * Indicates if the menu is open
     */
    open?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the items of this component.
     *
     *  **Note:** Use `sap.ui.webc.main.MenuItem` for the intended design.
     */
    items?: IMenuItem[] | IMenuItem | AggregationBindingInfo | `{${string}}`;

    /**
     * Defines the ID or DOM Reference of the element that the menu is shown at
     */
    opener?: Control | string;

    /**
     * Fired after the menu is closed. **This event does not bubble.**
     */
    afterClose?: (oEvent: Event) => void;

    /**
     * Fired after the menu is opened. **This event does not bubble.**
     */
    afterOpen?: (oEvent: Event) => void;

    /**
     * Fired before the menu is closed. This event can be cancelled, which will prevent the menu from closing.
     * **This event does not bubble.**
     */
    beforeClose?: (oEvent: Menu$BeforeCloseEvent) => void;

    /**
     * Fired before the menu is opened. This event can be cancelled, which will prevent the menu from opening.
     * **This event does not bubble.** **Note:** Since 1.14.0 the event is also fired before a sub-menu opens.
     */
    beforeOpen?: (oEvent: Menu$BeforeOpenEvent) => void;

    /**
     * Fired when an item is being clicked. **Note:** Since 1.17.0 the event is preventable, allowing the menu
     * to remain open after an item is pressed.
     */
    itemClick?: (oEvent: Menu$ItemClickEvent) => void;
  }

  /**
   * Parameters of the Menu#afterClose event.
   */
  export interface Menu$AfterCloseEventParameters {}

  /**
   * Event object of the Menu#afterClose event.
   */
  export type Menu$AfterCloseEvent = Event<
    Menu$AfterCloseEventParameters,
    Menu
  >;

  /**
   * Parameters of the Menu#afterOpen event.
   */
  export interface Menu$AfterOpenEventParameters {}

  /**
   * Event object of the Menu#afterOpen event.
   */
  export type Menu$AfterOpenEvent = Event<Menu$AfterOpenEventParameters, Menu>;

  /**
   * Parameters of the Menu#beforeClose event.
   */
  export interface Menu$BeforeCloseEventParameters {
    /**
     * Indicates that `ESC` key has triggered the event.
     */
    escPressed?: boolean;
  }

  /**
   * Event object of the Menu#beforeClose event.
   */
  export type Menu$BeforeCloseEvent = Event<
    Menu$BeforeCloseEventParameters,
    Menu
  >;

  /**
   * Parameters of the Menu#beforeOpen event.
   */
  export interface Menu$BeforeOpenEventParameters {
    /**
     * The `sap.ui.webc.main.MenuItem` that triggers opening of the sub-menu or undefined when fired upon root
     * menu opening. **Note:** available since 1.14.0.
     */
    item?: HTMLElement;
  }

  /**
   * Event object of the Menu#beforeOpen event.
   */
  export type Menu$BeforeOpenEvent = Event<
    Menu$BeforeOpenEventParameters,
    Menu
  >;

  /**
   * Parameters of the Menu#itemClick event.
   */
  export interface Menu$ItemClickEventParameters {
    /**
     * The currently clicked menu item.
     */
    item?: HTMLElement;

    /**
     * The text of the currently clicked menu item.
     */
    text?: string;
  }

  /**
   * Event object of the Menu#itemClick event.
   */
  export type Menu$ItemClickEvent = Event<Menu$ItemClickEventParameters, Menu>;
}

declare module "sap/ui/webc/main/MenuItem" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IMenuItem } from "sap/ui/webc/main/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * `sap.ui.webc.main.MenuItem` is the item to use inside a `sap.ui.webc.main.Menu`. An arbitrary hierarchy
   * structure can be represented by recursively nesting menu items.
   *
   * Usage:
   *
   * `sap.ui.webc.main.MenuItem` is an abstract element, representing a node in a `sap.ui.webc.main.Menu`.
   * The menu itself is rendered as a list, and each `sap.ui.webc.main.MenuItem` is represented by a list
   * item (`sap.ui.webc.main.StandardListItem`) in that list. Therefore, you should only use `sap.ui.webc.main.MenuItem`
   * directly in your apps. The `sap.ui.webc.main.StandardListItem` list item is internal for the list, and
   * not intended for public use.
   *
   * @since 1.102.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.102.0) - This control is experimental and its API might change significantly.
   */
  export default class MenuItem extends WebComponent implements IMenuItem {
    __implements__sap_ui_webc_main_IMenuItem: boolean;
    /**
     * Constructor for a new `MenuItem`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $MenuItemSettings
    );
    /**
     * Constructor for a new `MenuItem`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $MenuItemSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.MenuItem with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, MenuItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.MenuItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: IMenuItem
    ): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Gets current value of property {@link #getAdditionalText additionalText}.
     *
     * Defines the `additionalText`, displayed in the end of the menu item. **Note:** The additional text would
     * not be displayed if the item has a submenu.
     *
     *
     * @returns Value of property `additionalText`
     */
    getAdditionalText(): string;
    /**
     * Gets current value of property {@link #getBusy busy}.
     *
     * Defines the delay in milliseconds, after which the busy indicator will be displayed inside the corresponding
     * ui5-menu popover.
     *
     * Note: If set to `true` a `sap.ui.webc.main.BusyIndicator` component will be displayed into the related
     * one to the current `sap.ui.webc.main.MenuItem` sub-menu popover.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `busy`
     */
    getBusy(): boolean;
    /**
     * Gets current value of property {@link #getBusyDelay busyDelay}.
     *
     * Defines the delay in milliseconds, after which the busy indicator will be displayed inside the corresponding
     * ui5-menu popover.
     *
     * Default value is `1000`.
     *
     *
     * @returns Value of property `busyDelay`
     */
    getBusyDelay(): int;
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getIcon icon}.
     *
     * Defines the icon to be displayed as graphical element within the component. The SAP-icons font provides
     * numerous options.
     *
     *  *** Example:** See all the available icons in the {@link demo:sap/m/demokit/iconExplorer/webapp/index.html Icon Explorer}.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `icon`
     */
    getIcon(): string;
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * Defines the items of this component.
     */
    getItems(): IMenuItem[];
    /**
     * Gets current value of property {@link #getStartsSection startsSection}.
     *
     * Defines whether a visual separator should be rendered before the item.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `startsSection`
     */
    getStartsSection(): boolean;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Defines the text of the tree item.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Checks for the provided `sap.ui.webc.main.IMenuItem` in the aggregation {@link #getItems items}. and
     * returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: IMenuItem
    ): int;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: IMenuItem,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): IMenuItem[];
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | IMenuItem
    ): IMenuItem | null;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getAdditionalText additionalText}.
     *
     * Defines the `additionalText`, displayed in the end of the menu item. **Note:** The additional text would
     * not be displayed if the item has a submenu.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAdditionalText(
      /**
       * New value for property `additionalText`
       */
      sAdditionalText: string
    ): this;
    /**
     * Sets a new value for property {@link #getBusy busy}.
     *
     * Defines the delay in milliseconds, after which the busy indicator will be displayed inside the corresponding
     * ui5-menu popover.
     *
     * Note: If set to `true` a `sap.ui.webc.main.BusyIndicator` component will be displayed into the related
     * one to the current `sap.ui.webc.main.MenuItem` sub-menu popover.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBusy(
      /**
       * New value for property `busy`
       */
      bBusy?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getBusyDelay busyDelay}.
     *
     * Defines the delay in milliseconds, after which the busy indicator will be displayed inside the corresponding
     * ui5-menu popover.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1000`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBusyDelay(
      /**
       * New value for property `busyDelay`
       */
      iBusyDelay?: int
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIcon icon}.
     *
     * Defines the icon to be displayed as graphical element within the component. The SAP-icons font provides
     * numerous options.
     *
     *  *** Example:** See all the available icons in the {@link demo:sap/m/demokit/iconExplorer/webapp/index.html Icon Explorer}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIcon(
      /**
       * New value for property `icon`
       */
      sIcon?: string
    ): this;
    /**
     * Sets a new value for property {@link #getStartsSection startsSection}.
     *
     * Defines whether a visual separator should be rendered before the item.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStartsSection(
      /**
       * New value for property `startsSection`
       */
      bStartsSection?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Defines the text of the tree item.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the MenuItem constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.102.0) - This control is experimental and its API might change significantly.
   */
  export interface $MenuItemSettings extends $WebComponentSettings {
    /**
     * Defines the accessible ARIA name of the component.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * Defines the `additionalText`, displayed in the end of the menu item. **Note:** The additional text would
     * not be displayed if the item has a submenu.
     */
    additionalText?: string | PropertyBindingInfo;

    /**
     * Defines the delay in milliseconds, after which the busy indicator will be displayed inside the corresponding
     * ui5-menu popover.
     *
     * Note: If set to `true` a `sap.ui.webc.main.BusyIndicator` component will be displayed into the related
     * one to the current `sap.ui.webc.main.MenuItem` sub-menu popover.
     */
    busy?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the delay in milliseconds, after which the busy indicator will be displayed inside the corresponding
     * ui5-menu popover.
     */
    busyDelay?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the icon to be displayed as graphical element within the component. The SAP-icons font provides
     * numerous options.
     *
     *  *** Example:** See all the available icons in the {@link demo:sap/m/demokit/iconExplorer/webapp/index.html Icon Explorer}.
     */
    icon?: string | PropertyBindingInfo;

    /**
     * Defines whether a visual separator should be rendered before the item.
     */
    startsSection?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the text of the tree item.
     */
    text?: string | PropertyBindingInfo;

    /**
     * Defines the items of this component.
     */
    items?: IMenuItem[] | IMenuItem | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/webc/main/MessageStrip" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import Event from "sap/ui/base/Event";

  import { MessageStripDesign, IIcon } from "sap/ui/webc/main/library";

  import { CSSSize } from "sap/ui/core/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * The `sap.ui.webc.main.MessageStrip` component enables the embedding of app-related messages. It displays
   * 4 designs of messages, each with corresponding semantic color and icon: Information, Positive, Warning
   * and Negative. Each message can have a Close button, so that it can be removed from the UI, if needed.
   *
   * Usage:
   *
   * For the `sap.ui.webc.main.MessageStrip` component, you can define whether it displays an icon in the
   * beginning and a close button. Moreover, its size and background can be controlled with CSS.
   *
   * Keyboard Handling:
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class MessageStrip extends WebComponent {
    /**
     * Constructor for a new `MessageStrip`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $MessageStripSettings
    );
    /**
     * Constructor for a new `MessageStrip`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $MessageStripSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.MessageStrip with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, MessageStrip>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.MessageStrip.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:close close} event of this `sap.ui.webc.main.MessageStrip`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.MessageStrip` itself.
     *
     * Fired when the close button is pressed either with a click/tap or by using the Enter or Space key.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClose(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.MessageStrip` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:close close} event of this `sap.ui.webc.main.MessageStrip`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.MessageStrip` itself.
     *
     * Fired when the close button is pressed either with a click/tap or by using the Enter or Space key.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClose(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.MessageStrip` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the icon in the aggregation {@link #getIcon icon}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyIcon(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:close close} event of this `sap.ui.webc.main.MessageStrip`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachClose(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:close close} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireClose(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getDesign design}.
     *
     * Defines the component type.
     *
     * Default value is `Information`.
     *
     *
     * @returns Value of property `design`
     */
    getDesign(): MessageStripDesign | keyof typeof MessageStripDesign;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Defines the height of the control
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getHideCloseButton hideCloseButton}.
     *
     * Defines whether the MessageStrip renders close button.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `hideCloseButton`
     */
    getHideCloseButton(): boolean;
    /**
     * Gets current value of property {@link #getHideIcon hideIcon}.
     *
     * Defines whether the MessageStrip will show an icon in the beginning. You can directly provide an icon
     * with the `icon` slot. Otherwise, the default icon for the type will be used.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `hideIcon`
     */
    getHideIcon(): boolean;
    /**
     * Gets content of aggregation {@link #getIcon icon}.
     *
     * Defines the content to be displayed as graphical element within the component.
     *
     *  **Note:** If no icon is given, the default icon for the component type will be used. The SAP-icons font
     * provides numerous options.
     *
     *
     *
     * See all the available icons in the {@link demo:sap/m/demokit/iconExplorer/webapp/index.html Icon Explorer}.
     */
    getIcon(): IIcon;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Defines the content of the control
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Sets a new value for property {@link #getDesign design}.
     *
     * Defines the component type.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Information`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDesign(
      /**
       * New value for property `design`
       */
      sDesign?: MessageStripDesign | keyof typeof MessageStripDesign
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * Defines the height of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getHideCloseButton hideCloseButton}.
     *
     * Defines whether the MessageStrip renders close button.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideCloseButton(
      /**
       * New value for property `hideCloseButton`
       */
      bHideCloseButton?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHideIcon hideIcon}.
     *
     * Defines whether the MessageStrip will show an icon in the beginning. You can directly provide an icon
     * with the `icon` slot. Otherwise, the default icon for the type will be used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideIcon(
      /**
       * New value for property `hideIcon`
       */
      bHideIcon?: boolean
    ): this;
    /**
     * Sets the aggregated {@link #getIcon icon}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIcon(
      /**
       * The icon to set
       */
      oIcon: IIcon
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Defines the content of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the MessageStrip constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $MessageStripSettings extends $WebComponentSettings {
    /**
     * Defines the component type.
     */
    design?:
      | (MessageStripDesign | keyof typeof MessageStripDesign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the height of the control
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the MessageStrip renders close button.
     */
    hideCloseButton?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the MessageStrip will show an icon in the beginning. You can directly provide an icon
     * with the `icon` slot. Otherwise, the default icon for the type will be used.
     */
    hideIcon?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the content of the control
     */
    text?: string | PropertyBindingInfo;

    /**
     * Defines the width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the content to be displayed as graphical element within the component.
     *
     *  **Note:** If no icon is given, the default icon for the component type will be used. The SAP-icons font
     * provides numerous options.
     *
     *
     *
     * See all the available icons in the {@link demo:sap/m/demokit/iconExplorer/webapp/index.html Icon Explorer}.
     */
    icon?: IIcon;

    /**
     * Fired when the close button is pressed either with a click/tap or by using the Enter or Space key.
     */
    close?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the MessageStrip#close event.
   */
  export interface MessageStrip$CloseEventParameters {}

  /**
   * Event object of the MessageStrip#close event.
   */
  export type MessageStrip$CloseEvent = Event<
    MessageStrip$CloseEventParameters,
    MessageStrip
  >;
}

declare module "sap/ui/webc/main/MultiComboBox" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IFormContent, ID, ValueState, CSSSize } from "sap/ui/core/library";

  import Control from "sap/ui/core/Control";

  import {
    IIcon,
    IMultiComboBoxItem,
    ComboBoxFilter,
  } from "sap/ui/webc/main/library";

  import Event from "sap/ui/base/Event";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * The `sap.ui.webc.main.MultiComboBox` component consists of a list box with items and a text field allowing
   * the user to either type a value directly into the text field, or choose from the list of existing items.
   *
   * The drop-down list is used for selecting and filtering values, it enables users to select one or more
   * options from a predefined list. The control provides an editable input field to filter the list, and
   * a dropdown arrow to expand/collapse the list of available options. The options in the list have checkboxes
   * that permit multi-selection. Entered values are displayed as tokens. Structure: The `sap.ui.webc.main.MultiComboBox`
   * consists of the following elements:
   * 	 -  Tokenizer - a list of tokens with selected options.
   * 	 -  Input field - displays the selected option/s as token/s. Users can type to filter the list.
   * 	 -  Drop-down arrow - expands\collapses the option list.
   * 	 -  Option list - the list of available options.  Keyboard Handling:
   *
   * The `sap.ui.webc.main.MultiComboBox` provides advanced keyboard handling.
   *
   * Picker: If the `sap.ui.webc.main.MultiComboBox` is focused, you can open or close the drop-down by pressing
   * `F4`, `ALT+UP` or `ALT+DOWN` keys. Once the drop-down is opened, you can use the `UP` and `DOWN` arrow
   * keys to navigate through the available options and select one by pressing the `Space` or `Enter` keys.
   *
   *
   *
   * Tokens:
   * 	 -  Left/Right arrow keys - moves the focus selection form the currently focused token to the previous/next
   *     one (if available).
   * 	 -  Delete - deletes the token and focuses the previous token.
   * 	 -  Backspace - deletes the token and focus the next token.
   *
   * CSS Shadow Parts:
   *
   * {@link https://developer.mozilla.org/en-US/docs/Web/CSS/::part CSS Shadow Parts} allow developers to
   * style elements inside the Shadow DOM.
   *  The `sap.ui.webc.main.MultiComboBox` exposes the following CSS Shadow Parts:
   * 	 - token-{index} - Used to style each token(where `token-0` corresponds to the first item)
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class MultiComboBox
    extends WebComponent
    implements IFormContent {
    __implements__sap_ui_core_IFormContent: boolean;
    /**
     * Constructor for a new `MultiComboBox`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $MultiComboBoxSettings
    );
    /**
     * Constructor for a new `MultiComboBox`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $MultiComboBoxSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.MultiComboBox with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, MultiComboBox>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.MultiComboBox.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some icon to the aggregation {@link #getIcon icon}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addIcon(
      /**
       * The icon to add; if empty, nothing is inserted
       */
      oIcon: IIcon
    ): this;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: IMultiComboBoxItem
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.MultiComboBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.MultiComboBox` itself.
     *
     * Fired when the input operation has finished by pressing Enter or on focusout.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.MultiComboBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.MultiComboBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.MultiComboBox` itself.
     *
     * Fired when the input operation has finished by pressing Enter or on focusout.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.MultiComboBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:input input} event of this `sap.ui.webc.main.MultiComboBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.MultiComboBox` itself.
     *
     * Fired when the value of the component changes at each keystroke.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInput(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.MultiComboBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:input input} event of this `sap.ui.webc.main.MultiComboBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.MultiComboBox` itself.
     *
     * Fired when the value of the component changes at each keystroke.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInput(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.MultiComboBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:openChange openChange} event of this `sap.ui.webc.main.MultiComboBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.MultiComboBox` itself.
     *
     * Fired when the dropdown is opened or closed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachOpenChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.MultiComboBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:openChange openChange} event of this `sap.ui.webc.main.MultiComboBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.MultiComboBox` itself.
     *
     * Fired when the dropdown is opened or closed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachOpenChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.MultiComboBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionChange selectionChange} event of this
     * `sap.ui.webc.main.MultiComboBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.MultiComboBox` itself.
     *
     * Fired when selection is changed by user interaction in `SingleSelect` and `MultiSelect` modes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: MultiComboBox$SelectionChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.MultiComboBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionChange selectionChange} event of this
     * `sap.ui.webc.main.MultiComboBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.MultiComboBox` itself.
     *
     * Fired when selection is changed by user interaction in `SingleSelect` and `MultiSelect` modes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: MultiComboBox$SelectionChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.MultiComboBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the icon in the aggregation {@link #getIcon icon}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyIcon(): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:change change} event of this `sap.ui.webc.main.MultiComboBox`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:input input} event of this `sap.ui.webc.main.MultiComboBox`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInput(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:openChange openChange} event of this `sap.ui.webc.main.MultiComboBox`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachOpenChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectionChange selectionChange} event of
     * this `sap.ui.webc.main.MultiComboBox`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectionChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: MultiComboBox$SelectionChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:change change} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:input input} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInput(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:openChange openChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireOpenChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectionChange selectionChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectionChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: MultiComboBox$SelectionChangeEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Gets current value of property {@link #getAllowCustomValues allowCustomValues}.
     *
     * Defines if the user input will be prevented, if no matching item has been found
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `allowCustomValues`
     */
    getAllowCustomValues(): boolean;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getFilter filter}.
     *
     * Defines the filter type of the component. Available options are: `StartsWithPerTerm`, `StartsWith`, `Contains`
     * and `None`.
     *
     * Default value is `StartsWithPerTerm`.
     *
     *
     * @returns Value of property `filter`
     */
    getFilter(): ComboBoxFilter | keyof typeof ComboBoxFilter;
    /**
     * Gets content of aggregation {@link #getIcon icon}.
     *
     * Defines the icon to be displayed in the component.
     */
    getIcon(): IIcon[];
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * Defines the component items.
     */
    getItems(): IMultiComboBoxItem[];
    /**
     * Gets current value of property {@link #getNoTypeahead noTypeahead}.
     *
     * Defines whether the value will be autcompleted to match an item
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `noTypeahead`
     */
    getNoTypeahead(): boolean;
    /**
     * Returns the indicates whether the dropdown is open. True if the dropdown is open, false otherwise.
     */
    getOpen(): void;
    /**
     * Gets current value of property {@link #getPlaceholder placeholder}.
     *
     * Defines a short hint intended to aid the user with data entry when the component has no value.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `placeholder`
     */
    getPlaceholder(): string;
    /**
     * Gets current value of property {@link #getReadonly readonly}.
     *
     * Defines whether the component is read-only.
     *
     *  **Note:** A read-only component is not editable, but still provides visual feedback upon user interaction.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `readonly`
     */
    getReadonly(): boolean;
    /**
     * Gets current value of property {@link #getRequired required}.
     *
     * Defines whether the component is required.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `required`
     */
    getRequired(): boolean;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * Defines the value of the component.
     *
     *  **Note:** The property is updated upon typing.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): string;
    /**
     * Gets current value of property {@link #getValueState valueState}.
     *
     * Defines the value state of the component.
     *
     *  Available options are:
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `valueState`
     */
    getValueState(): ValueState | keyof typeof ValueState;
    /**
     * Gets current value of property {@link #getValueStateMessage valueStateMessage}.
     *
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `valueStateMessage`
     */
    getValueStateMessage(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.ui.webc.main.IIcon` in the aggregation {@link #getIcon icon}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfIcon(
      /**
       * The icon whose index is looked for
       */
      oIcon: IIcon
    ): int;
    /**
     * Checks for the provided `sap.ui.webc.main.IMultiComboBoxItem` in the aggregation {@link #getItems items}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: IMultiComboBoxItem
    ): int;
    /**
     * Inserts a icon into the aggregation {@link #getIcon icon}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertIcon(
      /**
       * The icon to insert; if empty, nothing is inserted
       */
      oIcon: IIcon,
      /**
       * The `0`-based index the icon should be inserted at; for a negative value of `iIndex`, the icon is inserted
       * at position 0; for a value greater than the current size of the aggregation, the icon is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: IMultiComboBoxItem,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getIcon icon}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllIcon(): IIcon[];
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): IMultiComboBoxItem[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a icon from the aggregation {@link #getIcon icon}.
     *
     *
     * @returns The removed icon or `null`
     */
    removeIcon(
      /**
       * The icon to remove or its index or id
       */
      vIcon: int | string | IIcon
    ): IIcon | null;
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | IMultiComboBoxItem
    ): IMultiComboBoxItem | null;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getAllowCustomValues allowCustomValues}.
     *
     * Defines if the user input will be prevented, if no matching item has been found
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAllowCustomValues(
      /**
       * New value for property `allowCustomValues`
       */
      bAllowCustomValues?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getFilter filter}.
     *
     * Defines the filter type of the component. Available options are: `StartsWithPerTerm`, `StartsWith`, `Contains`
     * and `None`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `StartsWithPerTerm`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFilter(
      /**
       * New value for property `filter`
       */
      sFilter?: ComboBoxFilter | keyof typeof ComboBoxFilter
    ): this;
    /**
     * Sets a new value for property {@link #getNoTypeahead noTypeahead}.
     *
     * Defines whether the value will be autcompleted to match an item
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNoTypeahead(
      /**
       * New value for property `noTypeahead`
       */
      bNoTypeahead?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getPlaceholder placeholder}.
     *
     * Defines a short hint intended to aid the user with data entry when the component has no value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlaceholder(
      /**
       * New value for property `placeholder`
       */
      sPlaceholder?: string
    ): this;
    /**
     * Sets a new value for property {@link #getReadonly readonly}.
     *
     * Defines whether the component is read-only.
     *
     *  **Note:** A read-only component is not editable, but still provides visual feedback upon user interaction.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setReadonly(
      /**
       * New value for property `readonly`
       */
      bReadonly?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getRequired required}.
     *
     * Defines whether the component is required.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRequired(
      /**
       * New value for property `required`
       */
      bRequired?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * Defines the value of the component.
     *
     *  **Note:** The property is updated upon typing.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      sValue?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValueState valueState}.
     *
     * Defines the value state of the component.
     *
     *  Available options are:
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueState(
      /**
       * New value for property `valueState`
       */
      sValueState?: ValueState | keyof typeof ValueState
    ): this;
    /**
     * Sets a new value for property {@link #getValueStateMessage valueStateMessage}.
     *
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueStateMessage(
      /**
       * New value for property `valueStateMessage`
       */
      sValueStateMessage?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the MultiComboBox constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $MultiComboBoxSettings extends $WebComponentSettings {
    /**
     * Defines the accessible ARIA name of the component.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * Defines if the user input will be prevented, if no matching item has been found
     */
    allowCustomValues?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the filter type of the component. Available options are: `StartsWithPerTerm`, `StartsWith`, `Contains`
     * and `None`.
     */
    filter?:
      | (ComboBoxFilter | keyof typeof ComboBoxFilter)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines whether the value will be autcompleted to match an item
     */
    noTypeahead?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines a short hint intended to aid the user with data entry when the component has no value.
     */
    placeholder?: string | PropertyBindingInfo;

    /**
     * Defines whether the component is read-only.
     *
     *  **Note:** A read-only component is not editable, but still provides visual feedback upon user interaction.
     */
    readonly?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the component is required.
     */
    required?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the value of the component.
     *
     *  **Note:** The property is updated upon typing.
     */
    value?: string | PropertyBindingInfo;

    /**
     * Defines the value state of the component.
     *
     *  Available options are:
     */
    valueState?:
      | (ValueState | keyof typeof ValueState)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     */
    valueStateMessage?: string | PropertyBindingInfo;

    /**
     * Defines the width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the icon to be displayed in the component.
     */
    icon?: IIcon[] | IIcon | AggregationBindingInfo | `{${string}}`;

    /**
     * Defines the component items.
     */
    items?:
      | IMultiComboBoxItem[]
      | IMultiComboBoxItem
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Receives id(or many ids) of the controls that label this control.
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Fired when the input operation has finished by pressing Enter or on focusout.
     */
    change?: (oEvent: Event) => void;

    /**
     * Fired when the value of the component changes at each keystroke.
     */
    input?: (oEvent: Event) => void;

    /**
     * Fired when the dropdown is opened or closed.
     */
    openChange?: (oEvent: Event) => void;

    /**
     * Fired when selection is changed by user interaction in `SingleSelect` and `MultiSelect` modes.
     */
    selectionChange?: (oEvent: MultiComboBox$SelectionChangeEvent) => void;
  }

  /**
   * Parameters of the MultiComboBox#change event.
   */
  export interface MultiComboBox$ChangeEventParameters {}

  /**
   * Event object of the MultiComboBox#change event.
   */
  export type MultiComboBox$ChangeEvent = Event<
    MultiComboBox$ChangeEventParameters,
    MultiComboBox
  >;

  /**
   * Parameters of the MultiComboBox#input event.
   */
  export interface MultiComboBox$InputEventParameters {}

  /**
   * Event object of the MultiComboBox#input event.
   */
  export type MultiComboBox$InputEvent = Event<
    MultiComboBox$InputEventParameters,
    MultiComboBox
  >;

  /**
   * Parameters of the MultiComboBox#openChange event.
   */
  export interface MultiComboBox$OpenChangeEventParameters {}

  /**
   * Event object of the MultiComboBox#openChange event.
   */
  export type MultiComboBox$OpenChangeEvent = Event<
    MultiComboBox$OpenChangeEventParameters,
    MultiComboBox
  >;

  /**
   * Parameters of the MultiComboBox#selectionChange event.
   */
  export interface MultiComboBox$SelectionChangeEventParameters {
    /**
     * an array of the selected items.
     */
    items?: any[];
  }

  /**
   * Event object of the MultiComboBox#selectionChange event.
   */
  export type MultiComboBox$SelectionChangeEvent = Event<
    MultiComboBox$SelectionChangeEventParameters,
    MultiComboBox
  >;
}

declare module "sap/ui/webc/main/MultiComboBoxGroupItem" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IMultiComboBoxItem } from "sap/ui/webc/main/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The `sap.ui.webc.main.MultiComboBoxGroupItem` is type of suggestion item, that can be used to split the
   * `sap.ui.webc.main.MultiComboBox` suggestions into groups.
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class MultiComboBoxGroupItem
    extends WebComponent
    implements IMultiComboBoxItem {
    __implements__sap_ui_webc_main_IMultiComboBoxItem: boolean;
    /**
     * Constructor for a new `MultiComboBoxGroupItem`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $MultiComboBoxGroupItemSettings
    );
    /**
     * Constructor for a new `MultiComboBoxGroupItem`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $MultiComboBoxGroupItemSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.MultiComboBoxGroupItem with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, MultiComboBoxGroupItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.MultiComboBoxGroupItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Defines the text of the component.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Defines the text of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the MultiComboBoxGroupItem constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $MultiComboBoxGroupItemSettings
    extends $WebComponentSettings {
    /**
     * Defines the text of the component.
     */
    text?: string | PropertyBindingInfo;
  }
}

declare module "sap/ui/webc/main/MultiComboBoxItem" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IMultiComboBoxItem } from "sap/ui/webc/main/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The `sap.ui.webc.main.MultiComboBoxItem` represents the item for a `sap.ui.webc.main.MultiComboBox`.
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class MultiComboBoxItem
    extends WebComponent
    implements IMultiComboBoxItem {
    __implements__sap_ui_webc_main_IMultiComboBoxItem: boolean;
    /**
     * Constructor for a new `MultiComboBoxItem`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $MultiComboBoxItemSettings
    );
    /**
     * Constructor for a new `MultiComboBoxItem`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $MultiComboBoxItemSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.MultiComboBoxItem with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, MultiComboBoxItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.MultiComboBoxItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Gets current value of property {@link #getAdditionalText additionalText}.
     *
     * Defines the additional text of the component.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `additionalText`
     */
    getAdditionalText(): string;
    /**
     * Gets current value of property {@link #getSelected selected}.
     *
     * Defines the selected state of the component.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `selected`
     */
    getSelected(): boolean;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Defines the text of the component.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Sets a new value for property {@link #getAdditionalText additionalText}.
     *
     * Defines the additional text of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAdditionalText(
      /**
       * New value for property `additionalText`
       */
      sAdditionalText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSelected selected}.
     *
     * Defines the selected state of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelected(
      /**
       * New value for property `selected`
       */
      bSelected?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Defines the text of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the MultiComboBoxItem constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $MultiComboBoxItemSettings extends $WebComponentSettings {
    /**
     * Defines the additional text of the component.
     */
    additionalText?: string | PropertyBindingInfo;

    /**
     * Defines the selected state of the component.
     */
    selected?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the text of the component.
     */
    text?: string | PropertyBindingInfo;
  }
}

declare module "sap/ui/webc/main/MultiInput" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import {
    IFormContent,
    ISemanticFormContent,
    ID,
    ValueState,
    CSSSize,
  } from "sap/ui/core/library";

  import Control from "sap/ui/core/Control";

  import {
    IIcon,
    IInputSuggestionItem,
    IToken,
    InputType,
  } from "sap/ui/webc/main/library";

  import Event from "sap/ui/base/Event";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Overview: A `sap.ui.webc.main.MultiInput` field allows the user to enter multiple values, which are displayed
   * as `sap.ui.webc.main.Token`.
   *
   * User can choose interaction for creating tokens. Fiori Guidelines say that user should create tokens
   * when:
   * 	 - Type a value in the input and press enter or focus out the input field (`change` event is fired)
   *
   * 	 - Select a value from the suggestion list (`suggestion-item-select` event is fired)
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class MultiInput
    extends WebComponent
    implements IFormContent, ISemanticFormContent {
    __implements__sap_ui_core_IFormContent: boolean;
    __implements__sap_ui_core_ISemanticFormContent: boolean;
    /**
     * Constructor for a new `MultiInput`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $MultiInputSettings
    );
    /**
     * Constructor for a new `MultiInput`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $MultiInputSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.MultiInput with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, MultiInput>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.MultiInput.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some icon to the aggregation {@link #getIcon icon}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addIcon(
      /**
       * The icon to add; if empty, nothing is inserted
       */
      oIcon: IIcon
    ): this;
    /**
     * Adds some suggestionItem to the aggregation {@link #getSuggestionItems suggestionItems}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addSuggestionItem(
      /**
       * The suggestionItem to add; if empty, nothing is inserted
       */
      oSuggestionItem: IInputSuggestionItem
    ): this;
    /**
     * Adds some token to the aggregation {@link #getTokens tokens}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addToken(
      /**
       * The token to add; if empty, nothing is inserted
       */
      oToken: IToken
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.MultiInput`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.MultiInput` itself.
     *
     * Fired when the input operation has finished by pressing Enter or on focusout.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.MultiInput` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.MultiInput`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.MultiInput` itself.
     *
     * Fired when the input operation has finished by pressing Enter or on focusout.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.MultiInput` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:input input} event of this `sap.ui.webc.main.MultiInput`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.MultiInput` itself.
     *
     * Fired when the value of the component changes at each keystroke, and when a suggestion item has been
     * selected.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInput(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.MultiInput` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:input input} event of this `sap.ui.webc.main.MultiInput`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.MultiInput` itself.
     *
     * Fired when the value of the component changes at each keystroke, and when a suggestion item has been
     * selected.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInput(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.MultiInput` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:suggestionItemPreview suggestionItemPreview }
     * event of this `sap.ui.webc.main.MultiInput`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.MultiInput` itself.
     *
     * Fired when the user navigates to a suggestion item via the ARROW keys, as a preview, before the final
     * selection.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSuggestionItemPreview(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: MultiInput$SuggestionItemPreviewEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.MultiInput` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:suggestionItemPreview suggestionItemPreview }
     * event of this `sap.ui.webc.main.MultiInput`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.MultiInput` itself.
     *
     * Fired when the user navigates to a suggestion item via the ARROW keys, as a preview, before the final
     * selection.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSuggestionItemPreview(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: MultiInput$SuggestionItemPreviewEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.MultiInput` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:suggestionItemSelect suggestionItemSelect} event
     * of this `sap.ui.webc.main.MultiInput`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.MultiInput` itself.
     *
     * Fired when a suggestion item, that is displayed in the suggestion popup, is selected.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSuggestionItemSelect(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: MultiInput$SuggestionItemSelectEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.MultiInput` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:suggestionItemSelect suggestionItemSelect} event
     * of this `sap.ui.webc.main.MultiInput`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.MultiInput` itself.
     *
     * Fired when a suggestion item, that is displayed in the suggestion popup, is selected.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSuggestionItemSelect(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: MultiInput$SuggestionItemSelectEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.MultiInput` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:tokenDelete tokenDelete} event of this `sap.ui.webc.main.MultiInput`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.MultiInput` itself.
     *
     * Fired when a token is about to be deleted.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTokenDelete(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: MultiInput$TokenDeleteEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.MultiInput` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:tokenDelete tokenDelete} event of this `sap.ui.webc.main.MultiInput`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.MultiInput` itself.
     *
     * Fired when a token is about to be deleted.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTokenDelete(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: MultiInput$TokenDeleteEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.MultiInput` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:valueHelpTrigger valueHelpTrigger} event of
     * this `sap.ui.webc.main.MultiInput`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.MultiInput` itself.
     *
     * Fired when the value help icon is pressed and F4 or ALT/OPTION + ARROW_UP/ARROW_DOWN keyboard keys are
     * used.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachValueHelpTrigger(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.MultiInput` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:valueHelpTrigger valueHelpTrigger} event of
     * this `sap.ui.webc.main.MultiInput`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.MultiInput` itself.
     *
     * Fired when the value help icon is pressed and F4 or ALT/OPTION + ARROW_UP/ARROW_DOWN keyboard keys are
     * used.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachValueHelpTrigger(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.MultiInput` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the icon in the aggregation {@link #getIcon icon}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyIcon(): this;
    /**
     * Destroys all the suggestionItems in the aggregation {@link #getSuggestionItems suggestionItems}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroySuggestionItems(): this;
    /**
     * Destroys all the tokens in the aggregation {@link #getTokens tokens}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTokens(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:change change} event of this `sap.ui.webc.main.MultiInput`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:input input} event of this `sap.ui.webc.main.MultiInput`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInput(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:suggestionItemPreview suggestionItemPreview }
     * event of this `sap.ui.webc.main.MultiInput`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSuggestionItemPreview(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: MultiInput$SuggestionItemPreviewEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:suggestionItemSelect suggestionItemSelect }
     * event of this `sap.ui.webc.main.MultiInput`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSuggestionItemSelect(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: MultiInput$SuggestionItemSelectEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:tokenDelete tokenDelete} event of this `sap.ui.webc.main.MultiInput`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachTokenDelete(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: MultiInput$TokenDeleteEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:valueHelpTrigger valueHelpTrigger} event of
     * this `sap.ui.webc.main.MultiInput`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachValueHelpTrigger(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:change change} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:input input} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInput(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:suggestionItemPreview suggestionItemPreview} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSuggestionItemPreview(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: MultiInput$SuggestionItemPreviewEventParameters
    ): this;
    /**
     * Fires event {@link #event:suggestionItemSelect suggestionItemSelect} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSuggestionItemSelect(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: MultiInput$SuggestionItemSelectEventParameters
    ): this;
    /**
     * Fires event {@link #event:tokenDelete tokenDelete} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireTokenDelete(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: MultiInput$TokenDeleteEventParameters
    ): this;
    /**
     * Fires event {@link #event:valueHelpTrigger valueHelpTrigger} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireValueHelpTrigger(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets content of aggregation {@link #getIcon icon}.
     *
     * Defines the icon to be displayed in the component.
     */
    getIcon(): IIcon[];
    /**
     * Gets current value of property {@link #getMaxlength maxlength}.
     *
     * Sets the maximum number of characters available in the input field.
     *
     *  **Note:** This property is not compatible with the ui5-input type InputType.Number. If the ui5-input
     * type is set to Number, the maxlength value is ignored.
     *
     *
     * @returns Value of property `maxlength`
     */
    getMaxlength(): int;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * Determines the name with which the component will be submitted in an HTML form.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form. Do not use this property unless you need to submit a form.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getNoTypeahead noTypeahead}.
     *
     * Defines whether the value will be autcompleted to match an item
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `noTypeahead`
     */
    getNoTypeahead(): boolean;
    /**
     * Gets current value of property {@link #getPlaceholder placeholder}.
     *
     * Defines a short hint intended to aid the user with data entry when the component has no value.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `placeholder`
     */
    getPlaceholder(): string;
    /**
     * Returns the the suggestion item on preview.
     */
    getPreviewItem(): void;
    /**
     * Gets current value of property {@link #getReadonly readonly}.
     *
     * Defines whether the component is read-only.
     *
     *  **Note:** A read-only component is not editable, but still provides visual feedback upon user interaction.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `readonly`
     */
    getReadonly(): boolean;
    /**
     * Gets current value of property {@link #getRequired required}.
     *
     * Defines whether the component is required.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `required`
     */
    getRequired(): boolean;
    /**
     * Gets current value of property {@link #getShowClearIcon showClearIcon}.
     *
     * Defines whether the clear icon of the input will be shown.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showClearIcon`
     */
    getShowClearIcon(): boolean;
    /**
     * Gets current value of property {@link #getShowSuggestions showSuggestions}.
     *
     * Defines whether the component should show suggestions, if such are present.
     *
     *  **Note:** You need to import the `InputSuggestions` module from `"@ui5/webcomponents/dist/features/InputSuggestions.js"`
     * to enable this functionality.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showSuggestions`
     */
    getShowSuggestions(): boolean;
    /**
     * Gets current value of property {@link #getShowValueHelpIcon showValueHelpIcon}.
     *
     * Determines whether a value help icon will be visualized in the end of the input. Pressing the icon will
     * fire `value-help-trigger` event.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showValueHelpIcon`
     */
    getShowValueHelpIcon(): boolean;
    /**
     * Gets content of aggregation {@link #getSuggestionItems suggestionItems}.
     */
    getSuggestionItems(): IInputSuggestionItem[];
    /**
     * Gets content of aggregation {@link #getTokens tokens}.
     *
     * Defines the component tokens.
     */
    getTokens(): IToken[];
    /**
     * Gets current value of property {@link #getType type}.
     *
     * Defines the HTML type of the component.
     *
     *  **Notes:**
     * 	 - The particular effect of this property differs depending on the browser and the current language
     *     settings, especially for type `Number`.
     * 	 - The property is mostly intended to be used with touch devices that use different soft keyboard layouts
     *     depending on the given input type.
     *
     * Default value is `Text`.
     *
     *
     * @returns Value of property `type`
     */
    getType(): InputType | keyof typeof InputType;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * Defines the value of the component.
     *
     *  **Note:** The property is updated upon typing.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): string;
    /**
     * Gets current value of property {@link #getValueState valueState}.
     *
     * Defines the value state of the component.
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `valueState`
     */
    getValueState(): ValueState | keyof typeof ValueState;
    /**
     * Gets current value of property {@link #getValueStateMessage valueStateMessage}.
     *
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `valueStateMessage`
     */
    getValueStateMessage(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.ui.webc.main.IIcon` in the aggregation {@link #getIcon icon}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfIcon(
      /**
       * The icon whose index is looked for
       */
      oIcon: IIcon
    ): int;
    /**
     * Checks for the provided `sap.ui.webc.main.IInputSuggestionItem` in the aggregation {@link #getSuggestionItems suggestionItems}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfSuggestionItem(
      /**
       * The suggestionItem whose index is looked for
       */
      oSuggestionItem: IInputSuggestionItem
    ): int;
    /**
     * Checks for the provided `sap.ui.webc.main.IToken` in the aggregation {@link #getTokens tokens}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfToken(
      /**
       * The token whose index is looked for
       */
      oToken: IToken
    ): int;
    /**
     * Inserts a icon into the aggregation {@link #getIcon icon}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertIcon(
      /**
       * The icon to insert; if empty, nothing is inserted
       */
      oIcon: IIcon,
      /**
       * The `0`-based index the icon should be inserted at; for a negative value of `iIndex`, the icon is inserted
       * at position 0; for a value greater than the current size of the aggregation, the icon is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a suggestionItem into the aggregation {@link #getSuggestionItems suggestionItems}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertSuggestionItem(
      /**
       * The suggestionItem to insert; if empty, nothing is inserted
       */
      oSuggestionItem: IInputSuggestionItem,
      /**
       * The `0`-based index the suggestionItem should be inserted at; for a negative value of `iIndex`, the suggestionItem
       * is inserted at position 0; for a value greater than the current size of the aggregation, the suggestionItem
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a token into the aggregation {@link #getTokens tokens}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertToken(
      /**
       * The token to insert; if empty, nothing is inserted
       */
      oToken: IToken,
      /**
       * The `0`-based index the token should be inserted at; for a negative value of `iIndex`, the token is inserted
       * at position 0; for a value greater than the current size of the aggregation, the token is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Manually opens the suggestions popover, assuming suggestions are enabled. Items must be preloaded for
     * it to open.
     */
    openPicker(): void;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getIcon icon}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllIcon(): IIcon[];
    /**
     * Removes all the controls from the aggregation {@link #getSuggestionItems suggestionItems}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllSuggestionItems(): IInputSuggestionItem[];
    /**
     * Removes all the controls from the aggregation {@link #getTokens tokens}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllTokens(): IToken[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a icon from the aggregation {@link #getIcon icon}.
     *
     *
     * @returns The removed icon or `null`
     */
    removeIcon(
      /**
       * The icon to remove or its index or id
       */
      vIcon: int | string | IIcon
    ): IIcon | null;
    /**
     * Removes a suggestionItem from the aggregation {@link #getSuggestionItems suggestionItems}.
     *
     *
     * @returns The removed suggestionItem or `null`
     */
    removeSuggestionItem(
      /**
       * The suggestionItem to remove or its index or id
       */
      vSuggestionItem: int | string | IInputSuggestionItem
    ): IInputSuggestionItem | null;
    /**
     * Removes a token from the aggregation {@link #getTokens tokens}.
     *
     *
     * @returns The removed token or `null`
     */
    removeToken(
      /**
       * The token to remove or its index or id
       */
      vToken: int | string | IToken
    ): IToken | null;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName: string
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getMaxlength maxlength}.
     *
     * Sets the maximum number of characters available in the input field.
     *
     *  **Note:** This property is not compatible with the ui5-input type InputType.Number. If the ui5-input
     * type is set to Number, the maxlength value is ignored.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxlength(
      /**
       * New value for property `maxlength`
       */
      iMaxlength: int
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * Determines the name with which the component will be submitted in an HTML form.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form. Do not use this property unless you need to submit a form.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getNoTypeahead noTypeahead}.
     *
     * Defines whether the value will be autcompleted to match an item
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNoTypeahead(
      /**
       * New value for property `noTypeahead`
       */
      bNoTypeahead?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getPlaceholder placeholder}.
     *
     * Defines a short hint intended to aid the user with data entry when the component has no value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlaceholder(
      /**
       * New value for property `placeholder`
       */
      sPlaceholder?: string
    ): this;
    /**
     * Sets a new value for property {@link #getReadonly readonly}.
     *
     * Defines whether the component is read-only.
     *
     *  **Note:** A read-only component is not editable, but still provides visual feedback upon user interaction.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setReadonly(
      /**
       * New value for property `readonly`
       */
      bReadonly?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getRequired required}.
     *
     * Defines whether the component is required.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRequired(
      /**
       * New value for property `required`
       */
      bRequired?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowClearIcon showClearIcon}.
     *
     * Defines whether the clear icon of the input will be shown.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowClearIcon(
      /**
       * New value for property `showClearIcon`
       */
      bShowClearIcon?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowSuggestions showSuggestions}.
     *
     * Defines whether the component should show suggestions, if such are present.
     *
     *  **Note:** You need to import the `InputSuggestions` module from `"@ui5/webcomponents/dist/features/InputSuggestions.js"`
     * to enable this functionality.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowSuggestions(
      /**
       * New value for property `showSuggestions`
       */
      bShowSuggestions?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowValueHelpIcon showValueHelpIcon}.
     *
     * Determines whether a value help icon will be visualized in the end of the input. Pressing the icon will
     * fire `value-help-trigger` event.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowValueHelpIcon(
      /**
       * New value for property `showValueHelpIcon`
       */
      bShowValueHelpIcon?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * Defines the HTML type of the component.
     *
     *  **Notes:**
     * 	 - The particular effect of this property differs depending on the browser and the current language
     *     settings, especially for type `Number`.
     * 	 - The property is mostly intended to be used with touch devices that use different soft keyboard layouts
     *     depending on the given input type.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Text`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: InputType | keyof typeof InputType
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * Defines the value of the component.
     *
     *  **Note:** The property is updated upon typing.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      sValue?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValueState valueState}.
     *
     * Defines the value state of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueState(
      /**
       * New value for property `valueState`
       */
      sValueState?: ValueState | keyof typeof ValueState
    ): this;
    /**
     * Sets a new value for property {@link #getValueStateMessage valueStateMessage}.
     *
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueStateMessage(
      /**
       * New value for property `valueStateMessage`
       */
      sValueStateMessage?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the MultiInput constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $MultiInputSettings extends $WebComponentSettings {
    /**
     * Defines the accessible ARIA name of the component.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets the maximum number of characters available in the input field.
     *
     *  **Note:** This property is not compatible with the ui5-input type InputType.Number. If the ui5-input
     * type is set to Number, the maxlength value is ignored.
     */
    maxlength?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines the name with which the component will be submitted in an HTML form.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form. Do not use this property unless you need to submit a form.
     */
    name?: string | PropertyBindingInfo;

    /**
     * Defines whether the value will be autcompleted to match an item
     */
    noTypeahead?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines a short hint intended to aid the user with data entry when the component has no value.
     */
    placeholder?: string | PropertyBindingInfo;

    /**
     * Defines whether the component is read-only.
     *
     *  **Note:** A read-only component is not editable, but still provides visual feedback upon user interaction.
     */
    readonly?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the component is required.
     */
    required?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the clear icon of the input will be shown.
     */
    showClearIcon?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the component should show suggestions, if such are present.
     *
     *  **Note:** You need to import the `InputSuggestions` module from `"@ui5/webcomponents/dist/features/InputSuggestions.js"`
     * to enable this functionality.
     */
    showSuggestions?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether a value help icon will be visualized in the end of the input. Pressing the icon will
     * fire `value-help-trigger` event.
     */
    showValueHelpIcon?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the HTML type of the component.
     *
     *  **Notes:**
     * 	 - The particular effect of this property differs depending on the browser and the current language
     *     settings, especially for type `Number`.
     * 	 - The property is mostly intended to be used with touch devices that use different soft keyboard layouts
     *     depending on the given input type.
     */
    type?:
      | (InputType | keyof typeof InputType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the value of the component.
     *
     *  **Note:** The property is updated upon typing.
     */
    value?: string | PropertyBindingInfo;

    /**
     * Defines the value state of the component.
     */
    valueState?:
      | (ValueState | keyof typeof ValueState)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the value state message that will be displayed as pop up under the contorl.
     *
     *
     *
     * **Note:** If not specified, a default text (in the respective language) will be displayed.
     */
    valueStateMessage?: string | PropertyBindingInfo;

    /**
     * Defines the width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the icon to be displayed in the component.
     */
    icon?: IIcon[] | IIcon | AggregationBindingInfo | `{${string}}`;

    suggestionItems?:
      | IInputSuggestionItem[]
      | IInputSuggestionItem
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Defines the component tokens.
     */
    tokens?: IToken[] | IToken | AggregationBindingInfo | `{${string}}`;

    /**
     * Receives id(or many ids) of the controls that label this control.
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Fired when the input operation has finished by pressing Enter or on focusout.
     */
    change?: (oEvent: Event) => void;

    /**
     * Fired when the value of the component changes at each keystroke, and when a suggestion item has been
     * selected.
     */
    input?: (oEvent: Event) => void;

    /**
     * Fired when the user navigates to a suggestion item via the ARROW keys, as a preview, before the final
     * selection.
     */
    suggestionItemPreview?: (
      oEvent: MultiInput$SuggestionItemPreviewEvent
    ) => void;

    /**
     * Fired when a suggestion item, that is displayed in the suggestion popup, is selected.
     */
    suggestionItemSelect?: (
      oEvent: MultiInput$SuggestionItemSelectEvent
    ) => void;

    /**
     * Fired when a token is about to be deleted.
     */
    tokenDelete?: (oEvent: MultiInput$TokenDeleteEvent) => void;

    /**
     * Fired when the value help icon is pressed and F4 or ALT/OPTION + ARROW_UP/ARROW_DOWN keyboard keys are
     * used.
     */
    valueHelpTrigger?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the MultiInput#change event.
   */
  export interface MultiInput$ChangeEventParameters {}

  /**
   * Event object of the MultiInput#change event.
   */
  export type MultiInput$ChangeEvent = Event<
    MultiInput$ChangeEventParameters,
    MultiInput
  >;

  /**
   * Parameters of the MultiInput#input event.
   */
  export interface MultiInput$InputEventParameters {}

  /**
   * Event object of the MultiInput#input event.
   */
  export type MultiInput$InputEvent = Event<
    MultiInput$InputEventParameters,
    MultiInput
  >;

  /**
   * Parameters of the MultiInput#suggestionItemPreview event.
   */
  export interface MultiInput$SuggestionItemPreviewEventParameters {
    /**
     * The previewed suggestion item.
     */
    item?: HTMLElement;

    /**
     * The DOM ref of the suggestion item.
     */
    targetRef?: HTMLElement;
  }

  /**
   * Event object of the MultiInput#suggestionItemPreview event.
   */
  export type MultiInput$SuggestionItemPreviewEvent = Event<
    MultiInput$SuggestionItemPreviewEventParameters,
    MultiInput
  >;

  /**
   * Parameters of the MultiInput#suggestionItemSelect event.
   */
  export interface MultiInput$SuggestionItemSelectEventParameters {
    /**
     * The selected item.
     */
    item?: HTMLElement;
  }

  /**
   * Event object of the MultiInput#suggestionItemSelect event.
   */
  export type MultiInput$SuggestionItemSelectEvent = Event<
    MultiInput$SuggestionItemSelectEventParameters,
    MultiInput
  >;

  /**
   * Parameters of the MultiInput#tokenDelete event.
   */
  export interface MultiInput$TokenDeleteEventParameters {
    /**
     * deleted token.
     */
    token?: HTMLElement;
  }

  /**
   * Event object of the MultiInput#tokenDelete event.
   */
  export type MultiInput$TokenDeleteEvent = Event<
    MultiInput$TokenDeleteEventParameters,
    MultiInput
  >;

  /**
   * Parameters of the MultiInput#valueHelpTrigger event.
   */
  export interface MultiInput$ValueHelpTriggerEventParameters {}

  /**
   * Event object of the MultiInput#valueHelpTrigger event.
   */
  export type MultiInput$ValueHelpTriggerEvent = Event<
    MultiInput$ValueHelpTriggerEventParameters,
    MultiInput
  >;
}

declare module "sap/ui/webc/main/Option" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { ISelectOption } from "sap/ui/webc/main/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * The `sap.ui.webc.main.Option` component defines the content of an option in the `sap.ui.webc.main.Select`.
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class Option extends WebComponent implements ISelectOption {
    __implements__sap_ui_webc_main_ISelectOption: boolean;
    /**
     * Constructor for a new `Option`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $OptionSettings
    );
    /**
     * Constructor for a new `Option`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $OptionSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.Option with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Option>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.Option.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Gets current value of property {@link #getAdditionalText additionalText}.
     *
     * Defines the additional text displayed at the end of the option element.
     *
     *
     * @returns Value of property `additionalText`
     */
    getAdditionalText(): string;
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getIcon icon}.
     *
     * Defines the `icon` source URI.
     *
     *  **Note:** SAP-icons font provides numerous built-in icons. To find all the available icons, see the
     * {@link demo:sap/m/demokit/iconExplorer/webapp/index.html Icon Explorer}.
     *
     *
     * @returns Value of property `icon`
     */
    getIcon(): string;
    /**
     * Gets current value of property {@link #getSelected selected}.
     *
     * Defines the selected state of the component.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `selected`
     */
    getSelected(): boolean;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Defines the content of the control
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * Defines the value of the `sap.ui.webc.main.Select` inside an HTML Form element when this component is
     * selected. For more information on HTML Form support, see the `name` property of `sap.ui.webc.main.Select`.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): string;
    /**
     * Sets a new value for property {@link #getAdditionalText additionalText}.
     *
     * Defines the additional text displayed at the end of the option element.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAdditionalText(
      /**
       * New value for property `additionalText`
       */
      sAdditionalText: string
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIcon icon}.
     *
     * Defines the `icon` source URI.
     *
     *  **Note:** SAP-icons font provides numerous built-in icons. To find all the available icons, see the
     * {@link demo:sap/m/demokit/iconExplorer/webapp/index.html Icon Explorer}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIcon(
      /**
       * New value for property `icon`
       */
      sIcon: string
    ): this;
    /**
     * Sets a new value for property {@link #getSelected selected}.
     *
     * Defines the selected state of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelected(
      /**
       * New value for property `selected`
       */
      bSelected?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Defines the content of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * Defines the value of the `sap.ui.webc.main.Select` inside an HTML Form element when this component is
     * selected. For more information on HTML Form support, see the `name` property of `sap.ui.webc.main.Select`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      sValue: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Option constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $OptionSettings extends $WebComponentSettings {
    /**
     * Defines the additional text displayed at the end of the option element.
     */
    additionalText?: string | PropertyBindingInfo;

    /**
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the `icon` source URI.
     *
     *  **Note:** SAP-icons font provides numerous built-in icons. To find all the available icons, see the
     * {@link demo:sap/m/demokit/iconExplorer/webapp/index.html Icon Explorer}.
     */
    icon?: string | PropertyBindingInfo;

    /**
     * Defines the selected state of the component.
     */
    selected?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the content of the control
     */
    text?: string | PropertyBindingInfo;

    /**
     * Defines the value of the `sap.ui.webc.main.Select` inside an HTML Form element when this component is
     * selected. For more information on HTML Form support, see the `name` property of `sap.ui.webc.main.Select`.
     */
    value?: string | PropertyBindingInfo;
  }
}

declare module "sap/ui/webc/main/Panel" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import Control from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import { PanelAccessibleRole, TitleLevel } from "sap/ui/webc/main/library";

  import { CSSSize } from "sap/ui/core/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * The `sap.ui.webc.main.Panel` component is a container which has a header and a content area and is used
   * for grouping and displaying information. It can be collapsed to save space on the screen.
   *
   * Guidelines::
   * 	 - Nesting two or more panels is not recommended.
   * 	 - Do not stack too many panels on one page.
   *
   * Structure: The panel's header area consists of a title bar with a header text or custom header.
   *  The header is clickable and can be used to toggle between the expanded and collapsed state. It includes
   * an icon which rotates depending on the state.
   *  The custom header can be set through the `header` slot and it may contain arbitraray content, such as:
   * title, buttons or any other HTML elements.
   *  The content area can contain an arbitrary set of controls.
   *  **Note:** The custom header is not clickable out of the box, but in this case the icon is interactive
   * and allows to show/hide the content area.
   *
   * Responsive Behavior:
   * 	 - If the width of the panel is set to 100% (default), the panel and its children are resized responsively,
   *     depending on its parent container.
   * 	 - If the panel has a fixed height, it will take up the space even if the panel is collapsed.
   * 	 - When the panel is expandable (the `fixed` property is set to `false`), an arrow icon (pointing to
   *     the right) appears in front of the header.
   * 	 - When the animation is activated, expand/collapse uses a smooth animation to open or close the content
   *     area.
   * 	 - When the panel expands/collapses, the arrow icon rotates 90 degrees clockwise/counter-clockwise.
   *
   *
   * CSS Shadow Parts:
   *
   * {@link https://developer.mozilla.org/en-US/docs/Web/CSS/::part CSS Shadow Parts} allow developers to
   * style elements inside the Shadow DOM.
   *  The `sap.ui.webc.main.Panel` exposes the following CSS Shadow Parts:
   * 	 - header - Used to style the wrapper of the header
   * 	 - content - Used to style the wrapper of the content
   *
   * Keyboard Handling:
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class Panel extends WebComponent {
    /**
     * Constructor for a new `Panel`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $PanelSettings
    );
    /**
     * Constructor for a new `Panel`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $PanelSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.Panel with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Panel>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.Panel.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some content to the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted
       */
      oContent: Control
    ): this;
    /**
     * Adds some header to the aggregation {@link #getHeader header}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addHeader(
      /**
       * The header to add; if empty, nothing is inserted
       */
      oHeader: Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:toggle toggle} event of this `sap.ui.webc.main.Panel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Panel` itself.
     *
     * Fired when the component is expanded/collapsed by user interaction.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachToggle(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Panel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:toggle toggle} event of this `sap.ui.webc.main.Panel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Panel` itself.
     *
     * Fired when the component is expanded/collapsed by user interaction.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachToggle(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Panel` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Destroys all the header in the aggregation {@link #getHeader header}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyHeader(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:toggle toggle} event of this `sap.ui.webc.main.Panel`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachToggle(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:toggle toggle} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireToggle(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Gets current value of property {@link #getAccessibleRole accessibleRole}.
     *
     * Sets the accessible ARIA role of the component. Depending on the usage, you can change the role from
     * the default `Form` to `Region` or `Complementary`.
     *
     * Default value is `Form`.
     *
     *
     * @returns Value of property `accessibleRole`
     */
    getAccessibleRole(): PanelAccessibleRole | keyof typeof PanelAccessibleRole;
    /**
     * Gets current value of property {@link #getCollapsed collapsed}.
     *
     * Indicates whether the component is collapsed and only the header is displayed.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `collapsed`
     */
    getCollapsed(): boolean;
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * Defines the content of the component. The content is visible only when the component is expanded.
     */
    getContent(): Control[];
    /**
     * Gets current value of property {@link #getFixed fixed}.
     *
     * Determines whether the component is in a fixed state that is not expandable/collapsible by user interaction.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `fixed`
     */
    getFixed(): boolean;
    /**
     * Gets content of aggregation {@link #getHeader header}.
     *
     * Defines the component header area.
     *
     *  **Note:** When a header is provided, the `headerText` property is ignored.
     */
    getHeader(): Control[];
    /**
     * Gets current value of property {@link #getHeaderLevel headerLevel}.
     *
     * Defines the "aria-level" of component heading, set by the `headerText`.
     *
     *  Available options are: `"H6"` to `"H1"`.
     *
     * Default value is `H2`.
     *
     *
     * @returns Value of property `headerLevel`
     */
    getHeaderLevel(): TitleLevel | keyof typeof TitleLevel;
    /**
     * Gets current value of property {@link #getHeaderText headerText}.
     *
     * This property is used to set the header text of the component. The text is visible in both expanded and
     * collapsed states.
     *
     *  **Note:** This property is overridden by the `header` slot.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `headerText`
     */
    getHeaderText(): string;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Defines the height of the control
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getNoAnimation noAnimation}.
     *
     * Indicates whether the transition between the expanded and the collapsed state of the component is animated.
     * By default the animation is enabled.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `noAnimation`
     */
    getNoAnimation(): boolean;
    /**
     * Gets current value of property {@link #getStickyHeader stickyHeader}.
     *
     * Indicates whether the Panel header is sticky or not. If stickyHeader is set to true, then whenever you
     * scroll the content or the application, the header of the panel will be always visible and a solid color
     * will be used for its design.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `stickyHeader`
     */
    getStickyHeader(): boolean;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContent content}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: Control
    ): int;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getHeader header}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfHeader(
      /**
       * The header whose index is looked for
       */
      oHeader: Control
    ): int;
    /**
     * Inserts a content into the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: Control,
      /**
       * The `0`-based index the content should be inserted at; for a negative value of `iIndex`, the content
       * is inserted at position 0; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a header into the aggregation {@link #getHeader header}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertHeader(
      /**
       * The header to insert; if empty, nothing is inserted
       */
      oHeader: Control,
      /**
       * The `0`-based index the header should be inserted at; for a negative value of `iIndex`, the header is
       * inserted at position 0; for a value greater than the current size of the aggregation, the header is inserted
       * at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): Control[];
    /**
     * Removes all the controls from the aggregation {@link #getHeader header}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllHeader(): Control[];
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | Control
    ): Control | null;
    /**
     * Removes a header from the aggregation {@link #getHeader header}.
     *
     *
     * @returns The removed header or `null`
     */
    removeHeader(
      /**
       * The header to remove or its index or id
       */
      vHeader: int | string | Control
    ): Control | null;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getAccessibleRole accessibleRole}.
     *
     * Sets the accessible ARIA role of the component. Depending on the usage, you can change the role from
     * the default `Form` to `Region` or `Complementary`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Form`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleRole(
      /**
       * New value for property `accessibleRole`
       */
      sAccessibleRole?: PanelAccessibleRole | keyof typeof PanelAccessibleRole
    ): this;
    /**
     * Sets a new value for property {@link #getCollapsed collapsed}.
     *
     * Indicates whether the component is collapsed and only the header is displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCollapsed(
      /**
       * New value for property `collapsed`
       */
      bCollapsed?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getFixed fixed}.
     *
     * Determines whether the component is in a fixed state that is not expandable/collapsible by user interaction.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFixed(
      /**
       * New value for property `fixed`
       */
      bFixed?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHeaderLevel headerLevel}.
     *
     * Defines the "aria-level" of component heading, set by the `headerText`.
     *
     *  Available options are: `"H6"` to `"H1"`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `H2`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeaderLevel(
      /**
       * New value for property `headerLevel`
       */
      sHeaderLevel?: TitleLevel | keyof typeof TitleLevel
    ): this;
    /**
     * Sets a new value for property {@link #getHeaderText headerText}.
     *
     * This property is used to set the header text of the component. The text is visible in both expanded and
     * collapsed states.
     *
     *  **Note:** This property is overridden by the `header` slot.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeaderText(
      /**
       * New value for property `headerText`
       */
      sHeaderText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * Defines the height of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getNoAnimation noAnimation}.
     *
     * Indicates whether the transition between the expanded and the collapsed state of the component is animated.
     * By default the animation is enabled.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNoAnimation(
      /**
       * New value for property `noAnimation`
       */
      bNoAnimation?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getStickyHeader stickyHeader}.
     *
     * Indicates whether the Panel header is sticky or not. If stickyHeader is set to true, then whenever you
     * scroll the content or the application, the header of the panel will be always visible and a solid color
     * will be used for its design.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStickyHeader(
      /**
       * New value for property `stickyHeader`
       */
      bStickyHeader?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Panel constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $PanelSettings extends $WebComponentSettings {
    /**
     * Defines the accessible ARIA name of the component.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * Sets the accessible ARIA role of the component. Depending on the usage, you can change the role from
     * the default `Form` to `Region` or `Complementary`.
     */
    accessibleRole?:
      | (PanelAccessibleRole | keyof typeof PanelAccessibleRole)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Indicates whether the component is collapsed and only the header is displayed.
     */
    collapsed?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the component is in a fixed state that is not expandable/collapsible by user interaction.
     */
    fixed?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the "aria-level" of component heading, set by the `headerText`.
     *
     *  Available options are: `"H6"` to `"H1"`.
     */
    headerLevel?:
      | (TitleLevel | keyof typeof TitleLevel)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * This property is used to set the header text of the component. The text is visible in both expanded and
     * collapsed states.
     *
     *  **Note:** This property is overridden by the `header` slot.
     */
    headerText?: string | PropertyBindingInfo;

    /**
     * Defines the height of the control
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates whether the transition between the expanded and the collapsed state of the component is animated.
     * By default the animation is enabled.
     */
    noAnimation?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates whether the Panel header is sticky or not. If stickyHeader is set to true, then whenever you
     * scroll the content or the application, the header of the panel will be always visible and a solid color
     * will be used for its design.
     */
    stickyHeader?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the content of the component. The content is visible only when the component is expanded.
     */
    content?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * Defines the component header area.
     *
     *  **Note:** When a header is provided, the `headerText` property is ignored.
     */
    header?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * Fired when the component is expanded/collapsed by user interaction.
     */
    toggle?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Panel#toggle event.
   */
  export interface Panel$ToggleEventParameters {}

  /**
   * Event object of the Panel#toggle event.
   */
  export type Panel$ToggleEvent = Event<Panel$ToggleEventParameters, Panel>;
}

declare module "sap/ui/webc/main/Popover" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { ID, CSSSize } from "sap/ui/core/library";

  import Control from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import {
    PopupAccessibleRole,
    PopoverHorizontalAlign,
    PopoverPlacementType,
    PopoverVerticalAlign,
  } from "sap/ui/webc/main/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * The `sap.ui.webc.main.Popover` component displays additional information for an object in a compact way
   * and without leaving the page. The Popover can contain various UI elements, such as fields, tables, images,
   * and charts. It can also include actions in the footer.
   *
   * Structure:
   *
   * The popover has three main areas:
   * 	 - Header (optional)
   * 	 - Content
   * 	 - Footer (optional)
   *
   * **Note:** The `sap.ui.webc.main.Popover` is closed when the user clicks or taps outside the popover or
   * selects an action within the popover. You can prevent this with the `modal` property.
   *
   * CSS Shadow Parts:
   *
   * {@link https://developer.mozilla.org/en-US/docs/Web/CSS/::part CSS Shadow Parts} allow developers to
   * style elements inside the Shadow DOM.
   *  The `sap.ui.webc.main.Popover` exposes the following CSS Shadow Parts:
   * 	 - header - Used to style the header of the component
   * 	 - content - Used to style the content of the component
   * 	 - footer - Used to style the footer of the component
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class Popover extends WebComponent {
    /**
     * Constructor for a new `Popover`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $PopoverSettings
    );
    /**
     * Constructor for a new `Popover`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $PopoverSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.Popover with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Popover>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.Popover.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some content to the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted
       */
      oContent: Control
    ): this;
    /**
     * Adds some footer to the aggregation {@link #getFooter footer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addFooter(
      /**
       * The footer to add; if empty, nothing is inserted
       */
      oFooter: Control
    ): this;
    /**
     * Adds some header to the aggregation {@link #getHeader header}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addHeader(
      /**
       * The header to add; if empty, nothing is inserted
       */
      oHeader: Control
    ): this;
    /**
     * Focuses the element denoted by `initialFocus`, if provided, or the first focusable element otherwise.
     */
    applyFocus(): void;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterClose afterClose} event of this `sap.ui.webc.main.Popover`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Popover` itself.
     *
     * Fired after the component is closed. **This event does not bubble.**
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterClose(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Popover` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterClose afterClose} event of this `sap.ui.webc.main.Popover`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Popover` itself.
     *
     * Fired after the component is closed. **This event does not bubble.**
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterClose(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Popover` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterOpen afterOpen} event of this `sap.ui.webc.main.Popover`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Popover` itself.
     *
     * Fired after the component is opened. **This event does not bubble.**
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterOpen(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Popover` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterOpen afterOpen} event of this `sap.ui.webc.main.Popover`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Popover` itself.
     *
     * Fired after the component is opened. **This event does not bubble.**
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterOpen(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Popover` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeClose beforeClose} event of this `sap.ui.webc.main.Popover`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Popover` itself.
     *
     * Fired before the component is closed. This event can be cancelled, which will prevent the popup from
     * closing. **This event does not bubble.**
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeClose(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Popover$BeforeCloseEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Popover` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeClose beforeClose} event of this `sap.ui.webc.main.Popover`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Popover` itself.
     *
     * Fired before the component is closed. This event can be cancelled, which will prevent the popup from
     * closing. **This event does not bubble.**
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeClose(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Popover$BeforeCloseEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Popover` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeOpen beforeOpen} event of this `sap.ui.webc.main.Popover`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Popover` itself.
     *
     * Fired before the component is opened. This event can be cancelled, which will prevent the popup from
     * opening. **This event does not bubble.**
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeOpen(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Popover` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeOpen beforeOpen} event of this `sap.ui.webc.main.Popover`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.Popover` itself.
     *
     * Fired before the component is opened. This event can be cancelled, which will prevent the popup from
     * opening. **This event does not bubble.**
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeOpen(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.Popover` itself
       */
      oListener?: object
    ): this;
    /**
     * Closes the popup.
     */
    close(): void;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Destroys all the footer in the aggregation {@link #getFooter footer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyFooter(): this;
    /**
     * Destroys all the header in the aggregation {@link #getHeader header}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyHeader(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:afterClose afterClose} event of this `sap.ui.webc.main.Popover`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAfterClose(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:afterOpen afterOpen} event of this `sap.ui.webc.main.Popover`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAfterOpen(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:beforeClose beforeClose} event of this `sap.ui.webc.main.Popover`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachBeforeClose(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Popover$BeforeCloseEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:beforeOpen beforeOpen} event of this `sap.ui.webc.main.Popover`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachBeforeOpen(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:afterClose afterClose} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAfterClose(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:afterOpen afterOpen} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAfterOpen(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:beforeClose beforeClose} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireBeforeClose(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Popover$BeforeCloseEventParameters
    ): boolean;
    /**
     * Fires event {@link #event:beforeOpen beforeOpen} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireBeforeOpen(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): boolean;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible name of the component.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Gets current value of property {@link #getAccessibleRole accessibleRole}.
     *
     * Allows setting a custom role.
     *
     * Default value is `Dialog`.
     *
     *
     * @returns Value of property `accessibleRole`
     */
    getAccessibleRole(): PopupAccessibleRole | keyof typeof PopupAccessibleRole;
    /**
     * Gets current value of property {@link #getAllowTargetOverlap allowTargetOverlap}.
     *
     * Determines if there is no enough space, the component can be placed over the target.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `allowTargetOverlap`
     */
    getAllowTargetOverlap(): boolean;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * Defines the content of the Popup.
     */
    getContent(): Control[];
    /**
     * Gets content of aggregation {@link #getFooter footer}.
     *
     * Defines the footer HTML Element.
     */
    getFooter(): Control[];
    /**
     * Gets content of aggregation {@link #getHeader header}.
     *
     * Defines the header HTML Element.
     */
    getHeader(): Control[];
    /**
     * Gets current value of property {@link #getHeaderText headerText}.
     *
     * Defines the header text.
     *
     *  **Note:** If `header` slot is provided, the `headerText` is ignored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `headerText`
     */
    getHeaderText(): string;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Defines the height of the control
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getHideArrow hideArrow}.
     *
     * Determines whether the component arrow is hidden.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `hideArrow`
     */
    getHideArrow(): boolean;
    /**
     * Gets current value of property {@link #getHideBackdrop hideBackdrop}.
     *
     * Defines whether the block layer will be shown if modal property is set to true.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `hideBackdrop`
     */
    getHideBackdrop(): boolean;
    /**
     * Gets current value of property {@link #getHorizontalAlign horizontalAlign}.
     *
     * Determines the horizontal alignment of the component.
     *
     * Default value is `Center`.
     *
     *
     * @returns Value of property `horizontalAlign`
     */
    getHorizontalAlign():
      | PopoverHorizontalAlign
      | keyof typeof PopoverHorizontalAlign;
    /**
     * ID of the element which is the current target of the association {@link #getInitialFocus initialFocus},
     * or `null`.
     */
    getInitialFocus(): ID;
    /**
     * Gets current value of property {@link #getModal modal}.
     *
     * Defines whether the component should close when clicking/tapping outside of the popover. If enabled,
     * it blocks any interaction with the background.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `modal`
     */
    getModal(): boolean;
    /**
     * Gets current value of property {@link #getOpen open}.
     *
     * Indicates if the element is open
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `open`
     */
    getOpen(): boolean;
    /**
     * ID of the element which is the current target of the association {@link #getOpener opener}, or `null`.
     */
    getOpener(): ID;
    /**
     * Gets current value of property {@link #getPlacementType placementType}.
     *
     * Determines on which side the component is placed at.
     *
     * Default value is `Right`.
     *
     *
     * @returns Value of property `placementType`
     */
    getPlacementType():
      | PopoverPlacementType
      | keyof typeof PopoverPlacementType;
    /**
     * Gets current value of property {@link #getPreventFocusRestore preventFocusRestore}.
     *
     * Defines if the focus should be returned to the previously focused element, when the popup closes.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `preventFocusRestore`
     */
    getPreventFocusRestore(): boolean;
    /**
     * Gets current value of property {@link #getVerticalAlign verticalAlign}.
     *
     * Determines the vertical alignment of the component.
     *
     * Default value is `Center`.
     *
     *
     * @returns Value of property `verticalAlign`
     */
    getVerticalAlign():
      | PopoverVerticalAlign
      | keyof typeof PopoverVerticalAlign;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContent content}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: Control
    ): int;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getFooter footer}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfFooter(
      /**
       * The footer whose index is looked for
       */
      oFooter: Control
    ): int;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getHeader header}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfHeader(
      /**
       * The header whose index is looked for
       */
      oHeader: Control
    ): int;
    /**
     * Inserts a content into the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: Control,
      /**
       * The `0`-based index the content should be inserted at; for a negative value of `iIndex`, the content
       * is inserted at position 0; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a footer into the aggregation {@link #getFooter footer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertFooter(
      /**
       * The footer to insert; if empty, nothing is inserted
       */
      oFooter: Control,
      /**
       * The `0`-based index the footer should be inserted at; for a negative value of `iIndex`, the footer is
       * inserted at position 0; for a value greater than the current size of the aggregation, the footer is inserted
       * at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a header into the aggregation {@link #getHeader header}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertHeader(
      /**
       * The header to insert; if empty, nothing is inserted
       */
      oHeader: Control,
      /**
       * The `0`-based index the header should be inserted at; for a negative value of `iIndex`, the header is
       * inserted at position 0; for a value greater than the current size of the aggregation, the header is inserted
       * at the last position
       */
      iIndex: int
    ): this;
    /**
     * Tells if the component is opened
     */
    isOpen(): void;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): Control[];
    /**
     * Removes all the controls from the aggregation {@link #getFooter footer}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllFooter(): Control[];
    /**
     * Removes all the controls from the aggregation {@link #getHeader header}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllHeader(): Control[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | Control
    ): Control | null;
    /**
     * Removes a footer from the aggregation {@link #getFooter footer}.
     *
     *
     * @returns The removed footer or `null`
     */
    removeFooter(
      /**
       * The footer to remove or its index or id
       */
      vFooter: int | string | Control
    ): Control | null;
    /**
     * Removes a header from the aggregation {@link #getHeader header}.
     *
     *
     * @returns The removed header or `null`
     */
    removeHeader(
      /**
       * The header to remove or its index or id
       */
      vHeader: int | string | Control
    ): Control | null;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible name of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getAccessibleRole accessibleRole}.
     *
     * Allows setting a custom role.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Dialog`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleRole(
      /**
       * New value for property `accessibleRole`
       */
      sAccessibleRole?: PopupAccessibleRole | keyof typeof PopupAccessibleRole
    ): this;
    /**
     * Sets a new value for property {@link #getAllowTargetOverlap allowTargetOverlap}.
     *
     * Determines if there is no enough space, the component can be placed over the target.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAllowTargetOverlap(
      /**
       * New value for property `allowTargetOverlap`
       */
      bAllowTargetOverlap?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHeaderText headerText}.
     *
     * Defines the header text.
     *
     *  **Note:** If `header` slot is provided, the `headerText` is ignored.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeaderText(
      /**
       * New value for property `headerText`
       */
      sHeaderText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * Defines the height of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getHideArrow hideArrow}.
     *
     * Determines whether the component arrow is hidden.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideArrow(
      /**
       * New value for property `hideArrow`
       */
      bHideArrow?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHideBackdrop hideBackdrop}.
     *
     * Defines whether the block layer will be shown if modal property is set to true.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideBackdrop(
      /**
       * New value for property `hideBackdrop`
       */
      bHideBackdrop?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHorizontalAlign horizontalAlign}.
     *
     * Determines the horizontal alignment of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Center`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHorizontalAlign(
      /**
       * New value for property `horizontalAlign`
       */
      sHorizontalAlign?:
        | PopoverHorizontalAlign
        | keyof typeof PopoverHorizontalAlign
    ): this;
    /**
     * Sets the associated {@link #getInitialFocus initialFocus}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInitialFocus(
      /**
       * ID of an element which becomes the new target of this initialFocus association; alternatively, an element
       * instance may be given
       */
      oInitialFocus: ID | Control
    ): this;
    /**
     * Sets a new value for property {@link #getModal modal}.
     *
     * Defines whether the component should close when clicking/tapping outside of the popover. If enabled,
     * it blocks any interaction with the background.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setModal(
      /**
       * New value for property `modal`
       */
      bModal?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getOpen open}.
     *
     * Indicates if the element is open
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOpen(
      /**
       * New value for property `open`
       */
      bOpen?: boolean
    ): this;
    /**
     * Sets the associated {@link #getOpener opener}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOpener(
      /**
       * ID of an element which becomes the new target of this opener association; alternatively, an element instance
       * may be given
       */
      oOpener: ID | Control
    ): this;
    /**
     * Sets a new value for property {@link #getPlacementType placementType}.
     *
     * Determines on which side the component is placed at.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Right`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlacementType(
      /**
       * New value for property `placementType`
       */
      sPlacementType?: PopoverPlacementType | keyof typeof PopoverPlacementType
    ): this;
    /**
     * Sets a new value for property {@link #getPreventFocusRestore preventFocusRestore}.
     *
     * Defines if the focus should be returned to the previously focused element, when the popup closes.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPreventFocusRestore(
      /**
       * New value for property `preventFocusRestore`
       */
      bPreventFocusRestore?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getVerticalAlign verticalAlign}.
     *
     * Determines the vertical alignment of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Center`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVerticalAlign(
      /**
       * New value for property `verticalAlign`
       */
      sVerticalAlign?: PopoverVerticalAlign | keyof typeof PopoverVerticalAlign
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
    /**
     * Shows the popover.
     */
    showAt(
      /**
       * the element that the popover is shown at
       */
      opener: HTMLElement,
      /**
       * prevents applying the focus inside the popover
       */
      preventInitialFocus: boolean
    ): void;
  }
  /**
   * Describes the settings that can be provided to the Popover constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $PopoverSettings extends $WebComponentSettings {
    /**
     * Defines the accessible name of the component.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * Allows setting a custom role.
     */
    accessibleRole?:
      | (PopupAccessibleRole | keyof typeof PopupAccessibleRole)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Determines if there is no enough space, the component can be placed over the target.
     */
    allowTargetOverlap?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the header text.
     *
     *  **Note:** If `header` slot is provided, the `headerText` is ignored.
     */
    headerText?: string | PropertyBindingInfo;

    /**
     * Defines the height of the control
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the component arrow is hidden.
     */
    hideArrow?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the block layer will be shown if modal property is set to true.
     */
    hideBackdrop?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines the horizontal alignment of the component.
     */
    horizontalAlign?:
      | (PopoverHorizontalAlign | keyof typeof PopoverHorizontalAlign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines whether the component should close when clicking/tapping outside of the popover. If enabled,
     * it blocks any interaction with the background.
     */
    modal?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates if the element is open
     */
    open?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines on which side the component is placed at.
     */
    placementType?:
      | (PopoverPlacementType | keyof typeof PopoverPlacementType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines if the focus should be returned to the previously focused element, when the popup closes.
     */
    preventFocusRestore?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines the vertical alignment of the component.
     */
    verticalAlign?:
      | (PopoverVerticalAlign | keyof typeof PopoverVerticalAlign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the content of the Popup.
     */
    content?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * Defines the footer HTML Element.
     */
    footer?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * Defines the header HTML Element.
     */
    header?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * Defines the ID or DOM Reference of the element that the popover is shown at
     */
    opener?: Control | string;

    /**
     * Receives id(or many ids) of the controls that label this control.
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Defines the ID of the HTML Element, which will get the initial focus.
     */
    initialFocus?: Control | string;

    /**
     * Fired after the component is closed. **This event does not bubble.**
     */
    afterClose?: (oEvent: Event) => void;

    /**
     * Fired after the component is opened. **This event does not bubble.**
     */
    afterOpen?: (oEvent: Event) => void;

    /**
     * Fired before the component is closed. This event can be cancelled, which will prevent the popup from
     * closing. **This event does not bubble.**
     */
    beforeClose?: (oEvent: Popover$BeforeCloseEvent) => void;

    /**
     * Fired before the component is opened. This event can be cancelled, which will prevent the popup from
     * opening. **This event does not bubble.**
     */
    beforeOpen?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Popover#afterClose event.
   */
  export interface Popover$AfterCloseEventParameters {}

  /**
   * Event object of the Popover#afterClose event.
   */
  export type Popover$AfterCloseEvent = Event<
    Popover$AfterCloseEventParameters,
    Popover
  >;

  /**
   * Parameters of the Popover#afterOpen event.
   */
  export interface Popover$AfterOpenEventParameters {}

  /**
   * Event object of the Popover#afterOpen event.
   */
  export type Popover$AfterOpenEvent = Event<
    Popover$AfterOpenEventParameters,
    Popover
  >;

  /**
   * Parameters of the Popover#beforeClose event.
   */
  export interface Popover$BeforeCloseEventParameters {
    /**
     * Indicates that `ESC` key has triggered the event.
     */
    escPressed?: boolean;
  }

  /**
   * Event object of the Popover#beforeClose event.
   */
  export type Popover$BeforeCloseEvent = Event<
    Popover$BeforeCloseEventParameters,
    Popover
  >;

  /**
   * Parameters of the Popover#beforeOpen event.
   */
  export interface Popover$BeforeOpenEventParameters {}

  /**
   * Event object of the Popover#beforeOpen event.
   */
  export type Popover$BeforeOpenEvent = Event<
    Popover$BeforeOpenEventParameters,
    Popover
  >;
}

declare module "sap/ui/webc/main/ProgressIndicator" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IFormContent, ValueState, CSSSize } from "sap/ui/core/library";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Overview: Shows the progress of a process in a graphical way. To indicate the progress, the inside of
   * the component is filled with a color.
   *
   * Responsive Behavior: You can change the size of the Progress Indicator by changing its `width` or `height`
   * CSS properties.
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class ProgressIndicator
    extends WebComponent
    implements IFormContent {
    __implements__sap_ui_core_IFormContent: boolean;
    /**
     * Constructor for a new `ProgressIndicator`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ProgressIndicatorSettings
    );
    /**
     * Constructor for a new `ProgressIndicator`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ProgressIndicatorSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.ProgressIndicator with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ProgressIndicator>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.ProgressIndicator.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Gets current value of property {@link #getDisplayValue displayValue}.
     *
     * Specifies the text value to be displayed in the bar.
     *
     * **Note:**
     * 	 - If there is no value provided or the value is empty, the default percentage value is shown.
     * 	 - If `hideValue` property is `true` both the `displayValue` and `value` property values are not shown.
     *
     *
     *
     * @returns Value of property `displayValue`
     */
    getDisplayValue(): string;
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getHideValue hideValue}.
     *
     * Defines whether the component value is shown.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `hideValue`
     */
    getHideValue(): boolean;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * Specifies the numerical value in percent for the length of the component.
     *
     * **Note:** If a value greater than 100 is provided, the percentValue is set to 100. In other cases of
     * invalid value, percentValue is set to its default of 0.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): int;
    /**
     * Gets current value of property {@link #getValueState valueState}.
     *
     * Defines the value state of the component.
     *
     *  Available options are:
     * 	 - `None`
     * 	 - `Error`
     * 	 - `Warning`
     * 	 - `Success`
     * 	 - `Information`
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `valueState`
     */
    getValueState(): ValueState | keyof typeof ValueState;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayValue displayValue}.
     *
     * Specifies the text value to be displayed in the bar.
     *
     * **Note:**
     * 	 - If there is no value provided or the value is empty, the default percentage value is shown.
     * 	 - If `hideValue` property is `true` both the `displayValue` and `value` property values are not shown.
     *
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayValue(
      /**
       * New value for property `displayValue`
       */
      sDisplayValue: string
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHideValue hideValue}.
     *
     * Defines whether the component value is shown.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideValue(
      /**
       * New value for property `hideValue`
       */
      bHideValue?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * Specifies the numerical value in percent for the length of the component.
     *
     * **Note:** If a value greater than 100 is provided, the percentValue is set to 100. In other cases of
     * invalid value, percentValue is set to its default of 0.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      iValue?: int
    ): this;
    /**
     * Sets a new value for property {@link #getValueState valueState}.
     *
     * Defines the value state of the component.
     *
     *  Available options are:
     * 	 - `None`
     * 	 - `Error`
     * 	 - `Warning`
     * 	 - `Success`
     * 	 - `Information`
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueState(
      /**
       * New value for property `valueState`
       */
      sValueState?: ValueState | keyof typeof ValueState
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ProgressIndicator constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $ProgressIndicatorSettings extends $WebComponentSettings {
    /**
     * Defines the accessible ARIA name of the component.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * Specifies the text value to be displayed in the bar.
     *
     * **Note:**
     * 	 - If there is no value provided or the value is empty, the default percentage value is shown.
     * 	 - If `hideValue` property is `true` both the `displayValue` and `value` property values are not shown.
     */
    displayValue?: string | PropertyBindingInfo;

    /**
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the component value is shown.
     */
    hideValue?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies the numerical value in percent for the length of the component.
     *
     * **Note:** If a value greater than 100 is provided, the percentValue is set to 100. In other cases of
     * invalid value, percentValue is set to its default of 0.
     */
    value?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the value state of the component.
     *
     *  Available options are:
     * 	 - `None`
     * 	 - `Error`
     * 	 - `Warning`
     * 	 - `Success`
     * 	 - `Information`
     */
    valueState?:
      | (ValueState | keyof typeof ValueState)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/webc/main/RadioButton" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IFormContent, ID, ValueState, CSSSize } from "sap/ui/core/library";

  import Control from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { WrappingType } from "sap/ui/webc/main/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Overview:
   *
   * The `sap.ui.webc.main.RadioButton` component enables users to select a single option from a set of options.
   * When a `sap.ui.webc.main.RadioButton` is selected by the user, the `change` event is fired. When a `sap.ui.webc.main.RadioButton`
   * that is within a group is selected, the one that was previously selected gets automatically deselected.
   * You can group radio buttons by using the `name` property.
   *  **Note:** If `sap.ui.webc.main.RadioButton` is not part of a group, it can be selected once, but can
   * not be deselected back.
   *
   * Keyboard Handling:
   *
   * Once the `sap.ui.webc.main.RadioButton` is on focus, it might be selected by pressing the Space and Enter
   * keys.
   *  The Arrow Down/Arrow Up and Arrow Left/Arrow Right keys can be used to change selection between next/previous
   * radio buttons in one group, while TAB and SHIFT + TAB can be used to enter or leave the radio button
   * group.
   *  **Note:** On entering radio button group, the focus goes to the currently selected radio button.
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class RadioButton
    extends WebComponent
    implements IFormContent {
    __implements__sap_ui_core_IFormContent: boolean;
    /**
     * Constructor for a new `RadioButton`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $RadioButtonSettings
    );
    /**
     * Constructor for a new `RadioButton`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $RadioButtonSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.RadioButton with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, RadioButton>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.RadioButton.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.RadioButton`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.RadioButton` itself.
     *
     * Fired when the component checked state changes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.RadioButton` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.RadioButton`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.RadioButton` itself.
     *
     * Fired when the component checked state changes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.RadioButton` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:change change} event of this `sap.ui.webc.main.RadioButton`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:change change} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getChecked checked}.
     *
     * Defines whether the component is checked or not.
     *
     *  **Note:** The property value can be changed with user interaction, either by clicking/tapping on the
     * component, or by using the Space or Enter key.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `checked`
     */
    getChecked(): boolean;
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * Defines the name of the component. Radio buttons with the same `name` will form a radio button group.
     *
     *
     *
     *  **Note:** The selection can be changed with `ARROW_UP/DOWN` and `ARROW_LEFT/RIGHT` keys between radio
     * buttons in same group.
     *
     *
     *
     *  **Note:** Only one radio button can be selected per group.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getReadonly readonly}.
     *
     * Defines whether the component is read-only.
     *
     *  **Note:** A read-only component is not editable, but still provides visual feedback upon user interaction.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `readonly`
     */
    getReadonly(): boolean;
    /**
     * Gets current value of property {@link #getRequired required}.
     *
     * Defines whether the component is required.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `required`
     */
    getRequired(): boolean;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Defines the text of the component.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): string;
    /**
     * Gets current value of property {@link #getValueState valueState}.
     *
     * Defines the value state of the component.
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `valueState`
     */
    getValueState(): ValueState | keyof typeof ValueState;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Gets current value of property {@link #getWrappingType wrappingType}.
     *
     * Defines whether the component text wraps when there is not enough space.
     *  **Note:** for option "Normal" the text will wrap and the words will not be broken based on hyphenation.
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `wrappingType`
     */
    getWrappingType(): WrappingType | keyof typeof WrappingType;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getChecked checked}.
     *
     * Defines whether the component is checked or not.
     *
     *  **Note:** The property value can be changed with user interaction, either by clicking/tapping on the
     * component, or by using the Space or Enter key.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setChecked(
      /**
       * New value for property `checked`
       */
      bChecked?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * Defines the name of the component. Radio buttons with the same `name` will form a radio button group.
     *
     *
     *
     *  **Note:** The selection can be changed with `ARROW_UP/DOWN` and `ARROW_LEFT/RIGHT` keys between radio
     * buttons in same group.
     *
     *
     *
     *  **Note:** Only one radio button can be selected per group.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getReadonly readonly}.
     *
     * Defines whether the component is read-only.
     *
     *  **Note:** A read-only component is not editable, but still provides visual feedback upon user interaction.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setReadonly(
      /**
       * New value for property `readonly`
       */
      bReadonly?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getRequired required}.
     *
     * Defines whether the component is required.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRequired(
      /**
       * New value for property `required`
       */
      bRequired?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Defines the text of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      sValue?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValueState valueState}.
     *
     * Defines the value state of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueState(
      /**
       * New value for property `valueState`
       */
      sValueState?: ValueState | keyof typeof ValueState
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getWrappingType wrappingType}.
     *
     * Defines whether the component text wraps when there is not enough space.
     *  **Note:** for option "Normal" the text will wrap and the words will not be broken based on hyphenation.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWrappingType(
      /**
       * New value for property `wrappingType`
       */
      sWrappingType?: WrappingType | keyof typeof WrappingType
    ): this;
  }
  /**
   * Describes the settings that can be provided to the RadioButton constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $RadioButtonSettings extends $WebComponentSettings {
    /**
     * Defines the accessible ARIA name of the component.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * Defines whether the component is checked or not.
     *
     *  **Note:** The property value can be changed with user interaction, either by clicking/tapping on the
     * component, or by using the Space or Enter key.
     */
    checked?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the name of the component. Radio buttons with the same `name` will form a radio button group.
     *
     *
     *
     *  **Note:** The selection can be changed with `ARROW_UP/DOWN` and `ARROW_LEFT/RIGHT` keys between radio
     * buttons in same group.
     *
     *
     *
     *  **Note:** Only one radio button can be selected per group.
     *
     *
     *
     *  **Note:** When set, a native `input` HTML element will be created inside the component so that it can
     * be submitted as part of an HTML form.
     */
    name?: string | PropertyBindingInfo;

    /**
     * Defines whether the component is read-only.
     *
     *  **Note:** A read-only component is not editable, but still provides visual feedback upon user interaction.
     */
    readonly?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the component is required.
     */
    required?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the text of the component.
     */
    text?: string | PropertyBindingInfo;

    value?: string | PropertyBindingInfo;

    /**
     * Defines the value state of the component.
     */
    valueState?:
      | (ValueState | keyof typeof ValueState)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the component text wraps when there is not enough space.
     *  **Note:** for option "Normal" the text will wrap and the words will not be broken based on hyphenation.
     */
    wrappingType?:
      | (WrappingType | keyof typeof WrappingType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Receives id(or many ids) of the controls that label this control.
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Fired when the component checked state changes.
     */
    change?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the RadioButton#change event.
   */
  export interface RadioButton$ChangeEventParameters {}

  /**
   * Event object of the RadioButton#change event.
   */
  export type RadioButton$ChangeEvent = Event<
    RadioButton$ChangeEventParameters,
    RadioButton
  >;
}

declare module "sap/ui/webc/main/RangeSlider" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import Event from "sap/ui/base/Event";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { CSSSize } from "sap/ui/core/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Overview: Represents a numerical interval and two handles (grips) to select a sub-range within it. The
   * purpose of the component to enable visual selection of sub-ranges within a given interval.
   *
   * Structure: The most important properties of the Range Slider are:
   * 	 - min - The minimum value of the slider range.
   * 	 - max - The maximum value of the slider range.
   * 	 - value - The current value of the slider.
   * 	 - step - Determines the increments in which the slider will move.
   * 	 - showTooltip - Determines if a tooltip should be displayed above the handle.
   * 	 - showTickmarks - Displays a visual divider between the step values.
   * 	 - labelInterval - Labels some or all of the tickmarks with their values.  Notes::
   * 	 - The right and left handle can be moved individually and their positions could therefore switch.
   * 	 - The entire range can be moved along the interval.  Usage: The most common use case is to select
   *     and move sub-ranges on a continuous numerical scale.
   *
   * Responsive Behavior: You can move the currently selected range by clicking on it and dragging it along
   * the interval.
   *
   * CSS Shadow Parts:
   *
   * {@link https://developer.mozilla.org/en-US/docs/Web/CSS/::part CSS Shadow Parts} allow developers to
   * style elements inside the Shadow DOM.
   *  The `sap.ui.webc.main.RangeSlider` exposes the following CSS Shadow Parts:
   * 	 - progress-container - Used to style the progress container(the horizontal bar which visually represents
   *     the range between the minimum and maximum value) of the `sap.ui.webc.main.RangeSlider`.
   * 	 - progress-bar - Used to style the progress bar, which shows the progress of the `sap.ui.webc.main.RangeSlider`.
   *
   * 	 - handle - Used to style the handles of the `sap.ui.webc.main.RangeSlider`.
   *
   * Keyboard Handling:
   *
   *
   * 	 - `Left or Down Arrow` - Moves a component's handle or the entire selection one step to the left;
   * 	 - `Right or Up Arrow` - Moves a component's handle or the entire selection one step to the right;
   * 	 - `Left or Down Arrow + Ctrl/Cmd` - Moves a component's handle to the left or the entire range with
   *     step equal to 1/10th of the entire range;
   * 	 - `Right or Up Arrow + Ctrl/Cmd` - Moves a component's handle to the right or the entire range with
   *     step equal to 1/10th of the entire range;
   * 	 - `Plus` - Same as `Right or Up Arrow`;
   * 	 - `Minus` - Same as `Left or Down Arrow`;
   * 	 - `Home` - Moves the entire selection or the selected handle to the beginning of the component's range;
   *
   * 	 - `End` - Moves the entire selection or the selected handle to the end of the component's range;
   * 	 - `Page Up` - Same as `Right or Up Arrow + Ctrl/Cmd`;
   * 	 - `Page Down` - Same as `Left or Down Arrow + Ctrl/Cmd`;
   * 	 - `Escape` - Resets the `startValue` and `endValue` properties to the values prior the component focusing;
   *
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class RangeSlider extends WebComponent {
    /**
     * Constructor for a new `RangeSlider`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $RangeSliderSettings
    );
    /**
     * Constructor for a new `RangeSlider`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $RangeSliderSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.RangeSlider with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, RangeSlider>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.RangeSlider.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.RangeSlider`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.RangeSlider` itself.
     *
     * Fired when the value changes and the user has finished interacting with the slider.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.RangeSlider` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.RangeSlider`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.RangeSlider` itself.
     *
     * Fired when the value changes and the user has finished interacting with the slider.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.RangeSlider` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:input input} event of this `sap.ui.webc.main.RangeSlider`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.RangeSlider` itself.
     *
     * Fired when the value changes due to user interaction that is not yet finished - during mouse/touch dragging.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInput(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.RangeSlider` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:input input} event of this `sap.ui.webc.main.RangeSlider`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.RangeSlider` itself.
     *
     * Fired when the value changes due to user interaction that is not yet finished - during mouse/touch dragging.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInput(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.RangeSlider` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:change change} event of this `sap.ui.webc.main.RangeSlider`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:input input} event of this `sap.ui.webc.main.RangeSlider`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInput(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:change change} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:input input} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInput(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getEndValue endValue}.
     *
     * Defines end point of a selection - position of a second handle on the slider.
     *
     *
     *
     * Default value is `100`.
     *
     *
     * @returns Value of property `endValue`
     */
    getEndValue(): float;
    /**
     * Gets current value of property {@link #getLabelInterval labelInterval}.
     *
     * Displays a label with a value on every N-th step.
     *
     *  **Note:** The step and tickmarks properties must be enabled. Example - if the step value is set to 2
     * and the label interval is also specified to 2 - then every second tickmark will be labelled, which means
     * every 4th value number.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `labelInterval`
     */
    getLabelInterval(): int;
    /**
     * Gets current value of property {@link #getMax max}.
     *
     * Defines the maximum value of the slider.
     *
     * Default value is `100`.
     *
     *
     * @returns Value of property `max`
     */
    getMax(): float;
    /**
     * Gets current value of property {@link #getMin min}.
     *
     * Defines the minimum value of the slider.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `min`
     */
    getMin(): float;
    /**
     * Gets current value of property {@link #getShowTickmarks showTickmarks}.
     *
     * Enables tickmarks visualization for each step.
     *
     *  **Note:** The step must be a positive number.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showTickmarks`
     */
    getShowTickmarks(): boolean;
    /**
     * Gets current value of property {@link #getShowTooltip showTooltip}.
     *
     * Enables handle tooltip displaying the current value.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showTooltip`
     */
    getShowTooltip(): boolean;
    /**
     * Gets current value of property {@link #getStartValue startValue}.
     *
     * Defines start point of a selection - position of a first handle on the slider.
     *
     *
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `startValue`
     */
    getStartValue(): float;
    /**
     * Gets current value of property {@link #getStep step}.
     *
     * Defines the size of the slider's selection intervals (e.g. min = 0, max = 10, step = 5 would result in
     * possible selection of the values 0, 5, 10).
     *
     *  **Note:** If set to 0 the slider handle movement is disabled. When negative number or value other than
     * a number, the component fallbacks to its default value.
     *
     * Default value is `1`.
     *
     *
     * @returns Value of property `step`
     */
    getStep(): int;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName: string
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEndValue endValue}.
     *
     * Defines end point of a selection - position of a second handle on the slider.
     *
     *
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `100`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEndValue(
      /**
       * New value for property `endValue`
       */
      fEndValue?: float
    ): this;
    /**
     * Sets a new value for property {@link #getLabelInterval labelInterval}.
     *
     * Displays a label with a value on every N-th step.
     *
     *  **Note:** The step and tickmarks properties must be enabled. Example - if the step value is set to 2
     * and the label interval is also specified to 2 - then every second tickmark will be labelled, which means
     * every 4th value number.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabelInterval(
      /**
       * New value for property `labelInterval`
       */
      iLabelInterval?: int
    ): this;
    /**
     * Sets a new value for property {@link #getMax max}.
     *
     * Defines the maximum value of the slider.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `100`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMax(
      /**
       * New value for property `max`
       */
      fMax?: float
    ): this;
    /**
     * Sets a new value for property {@link #getMin min}.
     *
     * Defines the minimum value of the slider.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMin(
      /**
       * New value for property `min`
       */
      fMin?: float
    ): this;
    /**
     * Sets a new value for property {@link #getShowTickmarks showTickmarks}.
     *
     * Enables tickmarks visualization for each step.
     *
     *  **Note:** The step must be a positive number.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowTickmarks(
      /**
       * New value for property `showTickmarks`
       */
      bShowTickmarks?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowTooltip showTooltip}.
     *
     * Enables handle tooltip displaying the current value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowTooltip(
      /**
       * New value for property `showTooltip`
       */
      bShowTooltip?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getStartValue startValue}.
     *
     * Defines start point of a selection - position of a first handle on the slider.
     *
     *
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStartValue(
      /**
       * New value for property `startValue`
       */
      fStartValue?: float
    ): this;
    /**
     * Sets a new value for property {@link #getStep step}.
     *
     * Defines the size of the slider's selection intervals (e.g. min = 0, max = 10, step = 5 would result in
     * possible selection of the values 0, 5, 10).
     *
     *  **Note:** If set to 0 the slider handle movement is disabled. When negative number or value other than
     * a number, the component fallbacks to its default value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStep(
      /**
       * New value for property `step`
       */
      iStep?: int
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the RangeSlider constructor.
   *
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export interface $RangeSliderSettings extends $WebComponentSettings {
    /**
     * Defines the accessible ARIA name of the component.
     */
    accessibleName?: string | PropertyBindingInfo;

    /**
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines end point of a selection - position of a second handle on the slider.
     */
    endValue?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Displays a label with a value on every N-th step.
     *
     *  **Note:** The step and tickmarks properties must be enabled. Example - if the step value is set to 2
     * and the label interval is also specified to 2 - then every second tickmark will be labelled, which means
     * every 4th value number.
     */
    labelInterval?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the maximum value of the slider.
     */
    max?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the minimum value of the slider.
     */
    min?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Enables tickmarks visualization for each step.
     *
     *  **Note:** The step must be a positive number.
     */
    showTickmarks?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Enables handle tooltip displaying the current value.
     */
    showTooltip?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines start point of a selection - position of a first handle on the slider.
     */
    startValue?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the size of the slider's selection intervals (e.g. min = 0, max = 10, step = 5 would result in
     * possible selection of the values 0, 5, 10).
     *
     *  **Note:** If set to 0 the slider handle movement is disabled. When negative number or value other than
     * a number, the component fallbacks to its default value.
     */
    step?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Fired when the value changes and the user has finished interacting with the slider.
     */
    change?: (oEvent: Event) => void;

    /**
     * Fired when the value changes due to user interaction that is not yet finished - during mouse/touch dragging.
     */
    input?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the RangeSlider#change event.
   */
  export interface RangeSlider$ChangeEventParameters {}

  /**
   * Event object of the RangeSlider#change event.
   */
  export type RangeSlider$ChangeEvent = Event<
    RangeSlider$ChangeEventParameters,
    RangeSlider
  >;

  /**
   * Parameters of the RangeSlider#input event.
   */
  export interface RangeSlider$InputEventParameters {}

  /**
   * Event object of the RangeSlider#input event.
   */
  export type RangeSlider$InputEvent = Event<
    RangeSlider$InputEventParameters,
    RangeSlider
  >;
}

declare module "sap/ui/webc/main/RatingIndicator" {
  import {
    default as WebComponent,
    $WebComponentSettings,
  } from "sap/ui/core/webc/WebComponent";

  import { IFormContent, ID, CSSSize } from "sap/ui/core/library";

  import Control from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import WebComponentMetadata from "sap/ui/core/webc/WebComponentMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Overview: The Rating Indicator is used to display a specific number of icons that are used to rate an
   * item. Additionally, it is also used to display the average and overall ratings.
   *
   * Usage: The recommended number of icons is between 5 and 7.
   *
   * Responsive Behavior: You can change the size of the Rating Indicator by changing its `font-size` CSS
   * property.
   *  Example: `<ui5-rating-indicator style="font-size: 3rem;"></ui5-rating-indicator>`
   *
   * Keyboard Handling: When the `sap.ui.webc.main.RatingIndicator` is focused, the user can change the rating
   * with the following keyboard shortcuts:
   *
   *
   *
   * 	 - [RIGHT/UP] - Increases the value of the rating by one step. If the highest value is reached, does
   *     nothing
   * 	 - [LEFT/DOWN] - Decreases the value of the rating by one step. If the lowest value is reached, does
   *     nothing.
   * 	 - [HOME] - Sets the lowest value.
   * 	 - [END] - Sets the highest value.
   * 	 - [SPACE/ENTER/RETURN] - Increases the value of the rating by one step. If the highest value is reached,
   *     sets the rating to the lowest value.
   * 	 - Any number - Changes value to the corresponding number. If typed number is larger than the number
   *     of values, sets the highest value.
   *
   * @since 1.92.0
   * @deprecated (since 1.120) - this Web Components consumption model has been discarded. Until an alternative
   * Web Components consumption model is available in the future, use sap.m and sap.f controls with similar
   * functionality.
   * @experimental (since 1.92.0) - This control is experimental and its API might change significantly.
   */
  export default class RatingIndicator
    extends WebComponent
    implements IFormContent {
    __implements__sap_ui_core_IFormContent: boolean;
    /**
     * Constructor for a new `RatingIndicator`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $RatingIndicatorSettings
    );
    /**
     * Constructor for a new `RatingIndicator`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $RatingIndicatorSettings
    );

    /**
     * Creates a new subclass of class sap.ui.webc.main.RatingIndicator with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.webc.WebComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, RatingIndicator>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.webc.main.RatingIndicator.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): WebComponentMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.RatingIndicator`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.RatingIndicator` itself.
     *
     * The event is fired when the value changes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.RatingIndicator` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.webc.main.RatingIndicator`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.webc.main.RatingIndicator` itself.
     *
     * The event is fired when the value changes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.webc.main.RatingIndicator` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:change change} event of this `sap.ui.webc.main.RatingIndicator`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:change change} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     *
     * @returns Value of property `accessibleName`
     */
    getAccessibleName(): string;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getMax max}.
     *
     * The number of displayed rating symbols.
     *
     * Default value is `5`.
     *
     *
     * @returns Value of property `max`
     */
    getMax(): int;
    /**
     * Gets current value of property {@link #getReadonly readonly}.
     *
     * Defines whether the component is read-only.
     *
     *  **Note:** A read-only component is not editable, but still provides visual feedback upon user interaction.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `readonly`
     */
    getReadonly(): boolean;
    /**
     * Gets current value of property {@link #getRequired required}.
     *
     * Defines whether the component is required.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `required`
     */
    getRequired(): boolean;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * The indicated value of the rating.
     *
     *  **Note:** If you set a number which is not round, it would be shown as follows:
     * 	 - 1.0 - 1.2 -> 1
     * 	 - 1.3 - 1.7 -> 1.5
     * 	 - 1.8 - 1.9 -> 2
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): float;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Sets a new value for property {@link #getAccessibleName accessibleName}.
     *
     * Defines the accessible ARIA name of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleName(
      /**
       * New value for property `accessibleName`
       */
      sAccessibleName: string
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Defines whether the control is enabled. A disabled control can't be interacted with, and it is not in
     * the tab chain.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getMax max}.
     *
     * The number of displayed rating symbols.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `5`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMax(
      /**
       * New value for property `max`
       */
      iMax?: int
    ): this;
    /**
     * Sets a new value for property {@link #getReadonly readonly}.
     *
     * Defines whether the component is read-only.
     *
     *  **Note:** A read-only component is not editable, but still provides visual feedback upon user interaction.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setReadonly(
      /**
       * New value for property `readonly`
       */
      bReadonly?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getRequired required}.
     *
     * Defines whether the component is required.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRequired(
      /**
       * New value for property `required`
       */
      bRequired?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * The indicated value of the rating.
     *
     *  **Note:** If you set a number which is not round, it would be shown as follows:
     * 	 - 1.0 - 1.2 -> 1
     