// For Library Version: 1.120.12

declare module "sap/zen/commons/library" {}

declare module "sap/zen/commons/HAlign" {
  /**
   * Horizontal alignment, e.g. of a layout cell's content within the cell's borders. Note that some values
   * depend on the current locale's writing direction while others do not.
   *
   * @deprecated (since 1.89.0) - Please use the WD Grid control instead.
   */
  enum HAlign {
    /**
     * Aligned towards the beginning of a line, in the current locale's writing direction.
     */
    Begin = "Begin",
    /**
     * Horizontally centered.
     */
    Center = "Center",
    /**
     * Aligned towards the end of a line, in the current locale's writing direction.
     */
    End = "End",
    /**
     * Left aligned, regardless of the current locale's writing direction.
     */
    Left = "Left",
    /**
     * Right aligned, regardless of the current locale's writing direction.
     */
    Right = "Right",
  }
  export default HAlign;
}

declare module "sap/zen/commons/layout/AbsoluteLayout" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import PositionContainer from "sap/zen/commons/layout/PositionContainer";

  import { CSSSize, Scrolling } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * The Absolute Layout positions its child controls absolutely
   *
   * @deprecated (since 1.38)
   */
  export default class AbsoluteLayout extends Control {
    /**
     * Constructor for a new layout/AbsoluteLayout.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $AbsoluteLayoutSettings
    );
    /**
     * Constructor for a new layout/AbsoluteLayout.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $AbsoluteLayoutSettings
    );

    /**
     * Creates a new subclass of class sap.zen.commons.layout.AbsoluteLayout with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, AbsoluteLayout>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.zen.commons.layout.AbsoluteLayout.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds the given control and a corresponding position container into the aggregation named 'positions'.
     * Returns 'this' to allow method chaining.
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted.
       */
      oContent: Control,
      /**
       * JSON-like object which defines the position of the child control in the layout. The object is expected
       * to have one or more from the attribute set top, bottom, left, right; each with a value of type sap.ui.core.CSSSize.
       * If no object is given, the default is left=0px,right=0px
       */
      oPos: object
    ): AbsoluteLayout;
    /**
     * Adds some position to the aggregation {@link #getPositions positions}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addPosition(
      /**
       * The position to add; if empty, nothing is inserted
       */
      oPosition: PositionContainer
    ): this;
    /**
     * Destroys all aggregated position containers and their child controls. Returns 'this' to allow method
     * chaining.
     */
    destroyContent(): AbsoluteLayout;
    /**
     * Destroys all the positions in the aggregation {@link #getPositions positions}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPositions(): this;
    /**
     * Returns an array of the controls contained in the aggregated position containers (might be empty).
     */
    getContent(): Control[];
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * The overall height of the control. When not set, 100% is automatically set.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getHorizontalScrolling horizontalScrolling}.
     *
     * 'Auto', 'Scroll', 'Hidden', and 'None' are the available values for setting the vertical scrolling mode.
     *
     * Default value is `Hidden`.
     *
     *
     * @returns Value of property `horizontalScrolling`
     */
    getHorizontalScrolling(): Scrolling | keyof typeof Scrolling;
    /**
     * Gets content of aggregation {@link #getPositions positions}.
     *
     * Positioned child controls within the layout
     */
    getPositions(): PositionContainer[];
    /**
     * Gets current value of property {@link #getVerticalScrolling verticalScrolling}.
     *
     * 'Auto', 'Scroll', 'Hidden', and 'None' are the available values for setting the vertical scrolling mode.
     *
     * Default value is `Hidden`.
     *
     *
     * @returns Value of property `verticalScrolling`
     */
    getVerticalScrolling(): Scrolling | keyof typeof Scrolling;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * The overall width of the control. When not set, 100% is automatically set.
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided sap.ui.core.Control in the aggregated position containers, and returns the index
     * of the container in the positions aggregation if found, or '-1' otherwise.
     */
    indexOfContent(
      /**
       * The content of which the index is looked for
       */
      oContent: Control
    ): int;
    /**
     * Checks for the provided `sap.zen.commons.layout.PositionContainer` in the aggregation {@link #getPositions positions}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfPosition(
      /**
       * The position whose index is looked for
       */
      oPosition: PositionContainer
    ): int;
    /**
     * Inserts the given control and a corresponding position container into the aggregation named 'positions'.
     * Returns 'this' to allow method chaining.
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: Control,
      /**
       * The '0'-based index where the content shall be inserted at. For a negative value of iIndex, the content
       * is inserted at position '0'; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position.
       */
      iIndex: int,
      /**
       * JSON-like object which defines the position of the child control within the layout. The object is expected
       * to have one or more from the attribute set top, bottom, left, right; each with a value of type sap.ui.core.CSSSize.
       * If no object is given, the default is left=0px,right=0px.
       */
      oPos: object
    ): AbsoluteLayout;
    /**
     * Inserts a position into the aggregation {@link #getPositions positions}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertPosition(
      /**
       * The position to insert; if empty, nothing is inserted
       */
      oPosition: PositionContainer,
      /**
       * The `0`-based index the position should be inserted at; for a negative value of `iIndex`, the position
       * is inserted at position 0; for a value greater than the current size of the aggregation, the position
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all aggregated position containers. Returns an array of the controls contained in the removed
     * position containers (might be empty).
     */
    removeAllContent(): Control[];
    /**
     * Removes all the controls from the aggregation {@link #getPositions positions}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllPositions(): PositionContainer[];
    /**
     * Removes the given control and its corresponding position container from the aggregation named 'positions'.
     */
    removeContent(
      /**
       * The content control to remove, its ID, or the index of the corresponding position container in the 'positions'
       * aggregation.
       */
      oContent: object
    ): Control;
    /**
     * Removes a position from the aggregation {@link #getPositions positions}.
     *
     *
     * @returns The removed position or `null`
     */
    removePosition(
      /**
       * The position to remove or its index or id
       */
      vPosition: int | string | PositionContainer
    ): PositionContainer | null;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * The overall height of the control. When not set, 100% is automatically set.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getHorizontalScrolling horizontalScrolling}.
     *
     * 'Auto', 'Scroll', 'Hidden', and 'None' are the available values for setting the vertical scrolling mode.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Hidden`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHorizontalScrolling(
      /**
       * New value for property `horizontalScrolling`
       */
      sHorizontalScrolling?: Scrolling | keyof typeof Scrolling
    ): this;
    /**
     * Allows to set or change the position information of the given child control
     */
    setPositionOfChild(
      /**
       * The child control for which to change the position information; if empty or not aggregated, nothing is
       * changed
       */
      oControl: Control,
      /**
       * JSON-like object which defines the position of the child control. The object is expected to have one
       * or more from the attribute set top, bottom, left, right; each with a value of type sap.ui.core.CSSSize.
       * If no object is given, the default is used which is left=0px,right=0px.
       */
      oPos: object
    ): boolean;
    /**
     * Sets a new value for property {@link #getVerticalScrolling verticalScrolling}.
     *
     * 'Auto', 'Scroll', 'Hidden', and 'None' are the available values for setting the vertical scrolling mode.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Hidden`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVerticalScrolling(
      /**
       * New value for property `verticalScrolling`
       */
      sVerticalScrolling?: Scrolling | keyof typeof Scrolling
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * The overall width of the control. When not set, 100% is automatically set.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the AbsoluteLayout constructor.
   *
   * @deprecated (since 1.38)
   */
  export interface $AbsoluteLayoutSettings extends $ControlSettings {
    /**
     * The overall width of the control. When not set, 100% is automatically set.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The overall height of the control. When not set, 100% is automatically set.
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * 'Auto', 'Scroll', 'Hidden', and 'None' are the available values for setting the vertical scrolling mode.
     */
    verticalScrolling?:
      | (Scrolling | keyof typeof Scrolling)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * 'Auto', 'Scroll', 'Hidden', and 'None' are the available values for setting the vertical scrolling mode.
     */
    horizontalScrolling?:
      | (Scrolling | keyof typeof Scrolling)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Positioned child controls within the layout
     */
    positions?:
      | PositionContainer[]
      | PositionContainer
      | AggregationBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/zen/commons/layout/MatrixLayout" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import MatrixLayoutRow from "sap/zen/commons/layout/MatrixLayoutRow";

  import MatrixLayoutCell from "sap/zen/commons/layout/MatrixLayoutCell";

  import { CSSSize } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * @deprecated (since 1.38) - Instead, use the `sap.ui.layout.Grid` control.
   */
  export default class MatrixLayout extends Control {
    /**
     * Constructor for a new layout/MatrixLayout.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $MatrixLayoutSettings
    );
    /**
     * Constructor for a new layout/MatrixLayout.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $MatrixLayoutSettings
    );

    /**
     * Creates a new subclass of class sap.zen.commons.layout.MatrixLayout with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, MatrixLayout>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.zen.commons.layout.MatrixLayout.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some row to the aggregation {@link #getRows rows}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addRow(
      /**
       * The row to add; if empty, nothing is inserted
       */
      oRow: MatrixLayoutRow
    ): this;
    /**
     * Creates a new matrix layout row and appends it to this matrix layout.
     *
     * Each argument must be either a matrix layout cell, which is added to the row "as is", or an arbitrary
     * content control, which is wrapped with a new (default) matrix layout cell first and then added to the
     * row.
     *
     *
     * @returns `this` to allow method chaining
     */
    createRow(
      /**
       * to add
       */
      rowContent: Control | MatrixLayoutCell | string
    ): MatrixLayout;
    /**
     * Destroys all the rows in the aggregation {@link #getRows rows}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyRows(): this;
    /**
     * Gets current value of property {@link #getColumns columns}.
     *
     * Number of columns. If not specified, the number of columns will be determined from the given cells.
     *
     *
     * @returns Value of property `columns`
     */
    getColumns(): int;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * CSS height of the matrix layout.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getLayoutFixed layoutFixed}.
     *
     * Sets the table layout. If fixed the width parameter of a column has priority, if not the width of the
     * content of the colums has priority. The default is "fixed". If the fixed layout is used a adequate width
     * of the MatrixLayout should be provided. Otherwise the column width displayed could be different than
     * the given ones because of browser dependend optimazations.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `layoutFixed`
     */
    getLayoutFixed(): boolean;
    /**
     * Gets content of aggregation {@link #getRows rows}.
     *
     * The matrix layout's individual rows.
     */
    getRows(): MatrixLayoutRow[];
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * CSS width of the matrix layout. If the LayoutFixed = true a adequate width should be provided.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Gets current value of property {@link #getWidths widths}.
     *
     * Widths of the columns. Use an array to define the widths of the columns. If a column shall have an automatical
     * sizing enter "auto" for this column width.
     *
     *
     * @returns Value of property `widths`
     */
    getWidths(): CSSSize[];
    /**
     * Checks for the provided `sap.zen.commons.layout.MatrixLayoutRow` in the aggregation {@link #getRows rows}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfRow(
      /**
       * The row whose index is looked for
       */
      oRow: MatrixLayoutRow
    ): int;
    /**
     * Inserts a row into the aggregation {@link #getRows rows}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertRow(
      /**
       * The row to insert; if empty, nothing is inserted
       */
      oRow: MatrixLayoutRow,
      /**
       * The `0`-based index the row should be inserted at; for a negative value of `iIndex`, the row is inserted
       * at position 0; for a value greater than the current size of the aggregation, the row is inserted at the
       * last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getRows rows}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllRows(): MatrixLayoutRow[];
    /**
     * Removes a row from the aggregation {@link #getRows rows}.
     *
     *
     * @returns The removed row or `null`
     */
    removeRow(
      /**
       * The row to remove or its index or id
       */
      vRow: int | string | MatrixLayoutRow
    ): MatrixLayoutRow | null;
    /**
     * Sets a new value for property {@link #getColumns columns}.
     *
     * Number of columns. If not specified, the number of columns will be determined from the given cells.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColumns(
      /**
       * New value for property `columns`
       */
      iColumns?: int
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * CSS height of the matrix layout.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getLayoutFixed layoutFixed}.
     *
     * Sets the table layout. If fixed the width parameter of a column has priority, if not the width of the
     * content of the colums has priority. The default is "fixed". If the fixed layout is used a adequate width
     * of the MatrixLayout should be provided. Otherwise the column width displayed could be different than
     * the given ones because of browser dependend optimazations.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLayoutFixed(
      /**
       * New value for property `layoutFixed`
       */
      bLayoutFixed?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * CSS width of the matrix layout. If the LayoutFixed = true a adequate width should be provided.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getWidths widths}.
     *
     * Widths of the columns. Use an array to define the widths of the columns. If a column shall have an automatical
     * sizing enter "auto" for this column width.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidths(
      /**
       * New value for property `widths`
       */
      sWidths?: CSSSize[]
    ): this;
  }
  /**
   * Describes the settings that can be provided to the MatrixLayout constructor.
   *
   * @deprecated (since 1.38) - Instead, use the `sap.ui.layout.Grid` control.
   */
  export interface $MatrixLayoutSettings extends $ControlSettings {
    /**
     * CSS width of the matrix layout. If the LayoutFixed = true a adequate width should be provided.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * CSS height of the matrix layout.
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets the table layout. If fixed the width parameter of a column has priority, if not the width of the
     * content of the colums has priority. The default is "fixed". If the fixed layout is used a adequate width
     * of the MatrixLayout should be provided. Otherwise the column width displayed could be different than
     * the given ones because of browser dependend optimazations.
     */
    layoutFixed?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Number of columns. If not specified, the number of columns will be determined from the given cells.
     */
    columns?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Widths of the columns. Use an array to define the widths of the columns. If a column shall have an automatical
     * sizing enter "auto" for this column width.
     */
    widths?: CSSSize[] | PropertyBindingInfo | `{${string}}`;

    /**
     * The matrix layout's individual rows.
     */
    rows?:
      | MatrixLayoutRow[]
      | MatrixLayoutRow
      | AggregationBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/zen/commons/layout/MatrixLayoutCell" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  /**
   * Non-control element used as part of a matrix layout's inner structure.
   *
   * @deprecated (since 1.38) - Instead, use the `sap.ui.layout.Grid` control.
   */
  export default class MatrixLayoutCell extends UI5Element {
    /**
     * Constructor for a new layout/MatrixLayoutCell.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $MatrixLayoutCellSettings
    );
    /**
     * Constructor for a new layout/MatrixLayoutCell.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $MatrixLayoutCellSettings
    );

    /**
     * The string given as "sStyleClass" will be added to the "class" attribute of this element's root HTML
     * element.
     *
     * This method is intended to be used to mark controls as being of a special type for which special styling
     * can be provided using CSS selectors that reference this style class name.
     *
     *
     * ```javascript
     *
     * Example:
     * myButton.addStyleClass("myRedTextButton"); // add a CSS class to one button instance
     *
     * ...and in CSS:
     * .myRedTextButton {
     * color: red;
     * }
     * ```
     *
     *
     * This will add the CSS class "myRedTextButton" to the Button HTML and the CSS code above will then make
     * the text in this particular button red.
     *
     * Only characters allowed inside HTML attributes are allowed. Quotes are not allowed and this method will
     * ignore any strings containing quotes. Strings containing spaces are interpreted as ONE custom style class
     * (even though CSS selectors interpret them as different classes) and can only removed later by calling
     * removeStyleClass() with exactly the same (space-containing) string as parameter. Multiple calls with
     * the same sStyleClass will have no different effect than calling once. If sStyleClass is null, the call
     * is ignored.
     *
     * Returns `this` to allow method chaining
     */
    addStyleClass(
      /**
       * the CSS class name to be added
       */
      sStyleClass: string
    ): MatrixLayoutCell;
    /**
     * Returns true if the given style class string is valid and if this Element has this style class set via
     * a previous call to addStyleClass().
     */
    hasStyleClass(
      /**
       * the style to check for
       */
      sStyleClass: string
    ): boolean;
    /**
     * Removes the given string from the list of custom style classes that have been set previously. Regular
     * style classes like "sapUiBtn" cannot be removed.
     *
     * Returns `this` to allow method chaining
     */
    removeStyleClass(
      /**
       * the style to be removed
       */
      sStyleClass: string
    ): MatrixLayoutCell;
  }
  /**
   * Describes the settings that can be provided to the MatrixLayoutCell constructor.
   *
   * @deprecated (since 1.38) - Instead, use the `sap.ui.layout.Grid` control.
   */
  export interface $MatrixLayoutCellSettings extends $ElementSettings {}
}

declare module "sap/zen/commons/layout/MatrixLayoutRow" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import MatrixLayoutCell from "sap/zen/commons/layout/MatrixLayoutCell";

  import { CSSSize } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Non-control element used as part of a matrix layout's inner structure.
   *
   * @deprecated (since 1.89.0)
   */
  export default class MatrixLayoutRow extends UI5Element {
    /**
     * Constructor for a new layout/MatrixLayoutRow.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $MatrixLayoutRowSettings
    );
    /**
     * Constructor for a new layout/MatrixLayoutRow.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $MatrixLayoutRowSettings
    );

    /**
     * Creates a new subclass of class sap.zen.commons.layout.MatrixLayoutRow with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, MatrixLayoutRow>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.zen.commons.layout.MatrixLayoutRow.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some cell to the aggregation {@link #getCells cells}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addCell(
      /**
       * The cell to add; if empty, nothing is inserted
       */
      oCell: MatrixLayoutCell
    ): this;
    /**
     * The string given as "sStyleClass" will be added to the "class" attribute of this element's root HTML
     * element.
     *
     * This method is intended to be used to mark controls as being of a special type for which special styling
     * can be provided using CSS selectors that reference this style class name.
     *
     *
     * ```javascript
     *
     * Example:
     * myButton.addStyleClass("myRedTextButton"); // add a CSS class to one button instance
     *
     * ...and in CSS:
     * .myRedTextButton {
     * color: red;
     * }
     * ```
     *
     *
     * This will add the CSS class "myRedTextButton" to the Button HTML and the CSS code above will then make
     * the text in this particular button red.
     *
     * Only characters allowed inside HTML attributes are allowed. Quotes are not allowed and this method will
     * ignore any strings containing quotes. Strings containing spaces are interpreted as ONE custom style class
     * (even though CSS selectors interpret them as different classes) and can only removed later by calling
     * removeStyleClass() with exactly the same (space-containing) string as parameter. Multiple calls with
     * the same sStyleClass will have no different effect than calling once. If sStyleClass is null, the call
     * is ignored.
     *
     * Returns `this` to allow method chaining
     */
    addStyleClass(
      /**
       * the CSS class name to be added
       */
      sStyleClass: string
    ): MatrixLayoutRow;
    /**
     * Destroys all the cells in the aggregation {@link #getCells cells}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyCells(): this;
    /**
     * Gets content of aggregation {@link #getCells cells}.
     *
     * The matrix layout row's individual cells.
     */
    getCells(): MatrixLayoutCell[];
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Height of the row.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Returns true if the given style class string is valid and if this Element has this style class set via
     * a previous call to addStyleClass().
     */
    hasStyleClass(
      /**
       * the style to check for
       */
      sStyleClass: string
    ): boolean;
    /**
     * Checks for the provided `sap.zen.commons.layout.MatrixLayoutCell` in the aggregation {@link #getCells cells}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfCell(
      /**
       * The cell whose index is looked for
       */
      oCell: MatrixLayoutCell
    ): int;
    /**
     * Inserts a cell into the aggregation {@link #getCells cells}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertCell(
      /**
       * The cell to insert; if empty, nothing is inserted
       */
      oCell: MatrixLayoutCell,
      /**
       * The `0`-based index the cell should be inserted at; for a negative value of `iIndex`, the cell is inserted
       * at position 0; for a value greater than the current size of the aggregation, the cell is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getCells cells}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllCells(): MatrixLayoutCell[];
    /**
     * Removes a cell from the aggregation {@link #getCells cells}.
     *
     *
     * @returns The removed cell or `null`
     */
    removeCell(
      /**
       * The cell to remove or its index or id
       */
      vCell: int | string | MatrixLayoutCell
    ): MatrixLayoutCell | null;
    /**
     * Removes the given string from the list of custom style classes that have been set previously. Regular
     * style classes like "sapUiBtn" cannot be removed.
     *
     * Returns `this` to allow method chaining
     */
    removeStyleClass(
      /**
       * the style to be removed
       */
      sStyleClass: string
    ): MatrixLayoutRow;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * Height of the row.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the MatrixLayoutRow constructor.
   *
   * @deprecated (since 1.89.0)
   */
  export interface $MatrixLayoutRowSettings extends $ElementSettings {
    /**
     * Height of the row.
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The matrix layout row's individual cells.
     */
    cells?:
      | MatrixLayoutCell[]
      | MatrixLayoutCell
      | AggregationBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/zen/commons/layout/PositionContainer" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { CSSSize } from "sap/ui/core/library";

  import Control from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Is used to specify the position of a control in the AbsoluteLayout
   *
   * @deprecated (since 1.89)
   */
  export default class PositionContainer extends UI5Element {
    /**
     * Constructor for a new layout/PositionContainer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $PositionContainerSettings
    );
    /**
     * Constructor for a new layout/PositionContainer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $PositionContainerSettings
    );

    /**
     * Creates a new subclass of class sap.zen.commons.layout.PositionContainer with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, PositionContainer>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.zen.commons.layout.PositionContainer.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Destroys the control in the aggregation {@link #getControl control}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyControl(): this;
    /**
     * Gets current value of property {@link #getBottom bottom}.
     *
     * Defines the distance to the bottom of the layout (as specified in HTML)
     *
     *
     * @returns Value of property `bottom`
     */
    getBottom(): CSSSize;
    /**
     * Gets current value of property {@link #getCenterHorizontally centerHorizontally}.
     *
     * Indicates whether this container shall be centered horizontally within the AbsoluteLayout area. The values
     * of the attributes left and right are ignored when this feature is activated.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `centerHorizontally`
     */
    getCenterHorizontally(): boolean;
    /**
     * Gets current value of property {@link #getCenterVertically centerVertically}.
     *
     * Indicates whether this container should be centered vertically within the AbsoluteLayout area. The values
     * of the attributes top and bottom are ignored when this feature is activated.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `centerVertically`
     */
    getCenterVertically(): boolean;
    /**
     * Gets content of aggregation {@link #getControl control}.
     *
     * Child control of the position container
     */
    getControl(): Control;
    /**
     * Gets current value of property {@link #getLeft left}.
     *
     * Defines the distance to the left of the layout (as specified in HTML)
     *
     *
     * @returns Value of property `left`
     */
    getLeft(): CSSSize;
    /**
     * Gets current value of property {@link #getRight right}.
     *
     * Defines the distance to the right of the layout (as specified in HTML)
     *
     *
     * @returns Value of property `right`
     */
    getRight(): CSSSize;
    /**
     * Gets current value of property {@link #getTop top}.
     *
     * Defines the distance to the top of the layout (as specified in HTML)
     *
     *
     * @returns Value of property `top`
     */
    getTop(): CSSSize;
    /**
     * Sets a new value for property {@link #getBottom bottom}.
     *
     * Defines the distance to the bottom of the layout (as specified in HTML)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBottom(
      /**
       * New value for property `bottom`
       */
      sBottom?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getCenterHorizontally centerHorizontally}.
     *
     * Indicates whether this container shall be centered horizontally within the AbsoluteLayout area. The values
     * of the attributes left and right are ignored when this feature is activated.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCenterHorizontally(
      /**
       * New value for property `centerHorizontally`
       */
      bCenterHorizontally?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getCenterVertically centerVertically}.
     *
     * Indicates whether this container should be centered vertically within the AbsoluteLayout area. The values
     * of the attributes top and bottom are ignored when this feature is activated.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCenterVertically(
      /**
       * New value for property `centerVertically`
       */
      bCenterVertically?: boolean
    ): this;
    /**
     * Sets the aggregated {@link #getControl control}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setControl(
      /**
       * The control to set
       */
      oControl: Control
    ): this;
    /**
     * Sets a new value for property {@link #getLeft left}.
     *
     * Defines the distance to the left of the layout (as specified in HTML)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLeft(
      /**
       * New value for property `left`
       */
      sLeft?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getRight right}.
     *
     * Defines the distance to the right of the layout (as specified in HTML)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRight(
      /**
       * New value for property `right`
       */
      sRight?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getTop top}.
     *
     * Defines the distance to the top of the layout (as specified in HTML)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTop(
      /**
       * New value for property `top`
       */
      sTop?: CSSSize
    ): this;
    /**
     * Updates the position properties of the container according to the given position in JSON style.
     */
    updatePosition(
      /**
       * JSON-like object which defines the position of the child control in the absolute layout. The object is
       * expected to have one or more out of the attributes top, bottom, left, right (each with a value of type
       * sap.ui.core.CSSSize). If no object is given, nothing is updated.
       */
      oPos: object
    ): void;
  }
  /**
   * Describes the settings that can be provided to the PositionContainer constructor.
   *
   * @deprecated (since 1.89)
   */
  export interface $PositionContainerSettings extends $ElementSettings {
    /**
     * Defines the distance to the top of the layout (as specified in HTML)
     */
    top?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the distance to the bottom of the layout (as specified in HTML)
     */
    bottom?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the distance to the left of the layout (as specified in HTML)
     */
    left?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the distance to the right of the layout (as specified in HTML)
     */
    right?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates whether this container shall be centered horizontally within the AbsoluteLayout area. The values
     * of the attributes left and right are ignored when this feature is activated.
     */
    centerHorizontally?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates whether this container should be centered vertically within the AbsoluteLayout area. The values
     * of the attributes top and bottom are ignored when this feature is activated.
     */
    centerVertically?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Child control of the position container
     */
    control?: Control;
  }
}

declare module "sap/zen/commons/Padding" {
  /**
   * Padding, e.g. of a layout cell's content within the cell's borders. Note that all options except "None"
   * include a padding of 2px at the top and bottom, and differ only in the presence of a 4px padding towards
   * the beginning or end of a line, in the current locale's writing direction.
   *
   * @deprecated (since 1.89.0) - Please use the WD Grid control instead.
   * @experimental
   */
  enum Padding {
    /**
     * Top and bottom padding of 2px. Padding of 4px towards the beginning of a line, in the current locale's
     * writing direction, but none towards its end.
     */
    Begin = "Begin",
    /**
     * Top and bottom padding of 2px. Padding of 4px towards both the beginning and end of a line.
     */
    Both = "Both",
    /**
     * Top and bottom padding of 2px. Padding of 4px towards the end of a line, in the current locale's writing
     * direction, but none towards its beginning.
     */
    End = "End",
    /**
     * Top and bottom padding of 2px. No padding towards neither the beginning nor end of a line.
     */
    Neither = "Neither",
    /**
     * No padding at all.
     */
    None = "None",
  }
  export default Padding;
}

declare module "sap/zen/commons/Separation" {
  /**
   * Separation, e.g. of a layout cell from its neighbor, via a vertical gutter of defined width, with or
   * without a vertical line in its middle.
   *
   * @deprecated (since 1.89.0) - Please use the WD Grid control instead.
   */
  enum Separation {
    /**
     * A large (63px) vertical gutter without a vertical line.
     */
    Large = "Large",
    /**
     * A large (63px) vertical gutter with a vertical line in its middle.
     */
    LargeWithLine = "LargeWithLine",
    /**
     * A medium (31px) vertical gutter without a vertical line.
     */
    Medium = "Medium",
    /**
     * A medium (31px) vertical gutter with a vertical line in its middle.
     */
    MediumWithLine = "MediumWithLine",
    /**
     * No gutter at all (0px), and without a vertical line, of course.
     */
    None = "None",
    /**
     * A small (17px) vertical gutter without a vertical line.
     */
    Small = "Small",
    /**
     * A small (17px) vertical gutter with a vertical line in its middle.
     */
    SmallWithLine = "SmallWithLine",
  }
  export default Separation;
}

declare module "sap/zen/commons/VAlign" {
  /**
   * Vertical alignment, e.g. of a layout cell's content within the cell's borders.
   *
   * @deprecated (since 1.89.0) - Please use the WD Grid control instead.
   */
  enum VAlign {
    /**
     * Aligned at the bottom.
     */
    Bottom = "Bottom",
    /**
     * Vertically centered.
     */
    Middle = "Middle",
    /**
     * Aligned at the top.
     */
    Top = "Top",
  }
  export default VAlign;
}

declare namespace sap {
  interface IUI5DefineDependencyNames {
    "sap/zen/commons/HAlign": undefined;

    "sap/zen/commons/layout/AbsoluteLayout": undefined;

    "sap/zen/commons/layout/MatrixLayout": undefined;

    "sap/zen/commons/layout/MatrixLayoutCell": undefined;

    "sap/zen/commons/layout/MatrixLayoutRow": undefined;

    "sap/zen/commons/layout/PositionContainer": undefined;

    "sap/zen/commons/library": undefined;

    "sap/zen/commons/Padding": undefined;

    "sap/zen/commons/Separation": undefined;

    "sap/zen/commons/VAlign": undefined;
  }
}
