/**
 * @template {Node} [Tree=Node]
 *   Node kind.
 * @template {unknown} [Option=unknown]
 *   Parameter kind.
 * @param {Meta | string} meta
 *   Info.
 * @param {Rule<Tree, Option>} rule
 *   Rule.
 * @returns {Plugin<Tree, Option>}
 *   Plugin.
 */
export function lintRule<Tree extends Node = Node, Option extends unknown = unknown>(meta: Meta | string, rule: Rule<Tree, Option>): Plugin<Tree, Option>;
/**
 * Severity label;
 * `'off'`: `0`, `'on'` and `warn`: `1`, `'error'`: `2`.
 */
export type Label = "error" | "on" | "off" | "warn";
/**
 * Rule metadata.
 */
export type Meta = {
    /**
     *   Name of the lint rule.
     */
    origin: string;
    /**
     * Link to documentation (optional).
     */
    url?: string | null | undefined;
};
/**
 * Severity number;
 * `0`: `'off'`, `1`: `'on'` and `warn`, `2`: `'error'`.
 */
export type Severity = 0 | 1 | 2;
import type { Node } from 'unist';
import type { Rule } from 'unified-lint-rule';
import type { Plugin } from 'unified-lint-rule';
//# sourceMappingURL=index.d.ts.map