import { SaxEventType, SAXParser } from "sax-wasm";
import { finished } from "node:stream/promises";
import fs from "node:fs/promises";
import { createRequire } from "node:module";
const require = createRequire(import.meta.url);
export function isSaxParserToJSON(tag) {
    const tagAsSaxParserToJSON = tag;
    return !!tag &&
        Object.prototype.hasOwnProperty.call(tagAsSaxParserToJSON, "openStart") &&
        Object.prototype.hasOwnProperty.call(tagAsSaxParserToJSON, "openEnd") &&
        Object.prototype.hasOwnProperty.call(tagAsSaxParserToJSON, "closeStart") &&
        Object.prototype.hasOwnProperty.call(tagAsSaxParserToJSON, "closeEnd") &&
        Object.prototype.hasOwnProperty.call(tagAsSaxParserToJSON, "attributes") &&
        Object.prototype.hasOwnProperty.call(tagAsSaxParserToJSON, "textNodes");
}
export function isSaxText(tag) {
    return !!tag &&
        Object.prototype.hasOwnProperty.call(tag, "start") &&
        Object.prototype.hasOwnProperty.call(tag, "end") &&
        Object.prototype.hasOwnProperty.call(tag, "value");
}
let saxWasmBuffer;
async function initSaxWasm() {
    if (!saxWasmBuffer) {
        const saxPath = require.resolve("sax-wasm/lib/sax-wasm.wasm");
        saxWasmBuffer = await fs.readFile(saxPath);
    }
    return saxWasmBuffer;
}
export async function parseXML(contentStream, parseHandler) {
    const saxWasmBuffer = await initSaxWasm();
    const saxParser = new SAXParser(SaxEventType.CloseTag + SaxEventType.OpenTag);
    saxParser.eventHandler = parseHandler;
    // Instantiate and prepare the wasm for parsing
    if (!await saxParser.prepareWasm(saxWasmBuffer)) {
        throw new Error("Unknown error during WASM Initialization");
    }
    // stream from a file in the current directory
    contentStream.on("data", (chunk) => {
        try {
            saxParser.write(chunk);
        }
        catch (err) {
            if (err instanceof Error) {
                // In case of an error, destroy the content stream to make the
                // error bubble up to our callers
                contentStream.destroy(err);
            }
            else {
                throw err;
            }
        }
    });
    await finished(contentStream);
    saxParser.end();
}
//# sourceMappingURL=xmlParser.js.map