// For Library Version: 1.120.26

declare module "sap/viz/library" {
  export namespace ui5 {
    namespace types {
      namespace controller {
        /**
         * List (Enum) type sap.viz.ui5.types.controller.Interaction_pan_orientation
         *
         * @since 1.7.2
         * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
         * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
         * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
         * distribution for backward compatibility.
         *
         * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
         * control to benefit from new charting enhancements and timely support. **
         *
         * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
         * make sure you evaluate it thoroughly before migration.
         * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
         */
        enum Interaction_pan_orientation {
          /**
           * Value both
           */
          both = "both",
          /**
           * Value horizontal
           */
          horizontal = "horizontal",
          /**
           * Value vertical
           */
          vertical = "vertical",
        }
        /**
         * List (Enum) type sap.viz.ui5.types.controller.Interaction_selectability_mode
         *
         * @since 1.7.2
         * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
         * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
         * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
         * distribution for backward compatibility.
         *
         * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
         * control to benefit from new charting enhancements and timely support. **
         *
         * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
         * make sure you evaluate it thoroughly before migration.
         * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
         */
        enum Interaction_selectability_mode {
          /**
           * Value exclusive
           */
          exclusive = "exclusive",
          /**
           * Value inclusive
           */
          inclusive = "inclusive",
          /**
           * Value multiple
           */
          multiple = "multiple",
          /**
           * Value none
           */
          none = "none",
          /**
           * Value single
           */
          single = "single",
        }
      }

      namespace legend {
        /**
         * List (Enum) type sap.viz.ui5.types.legend.Common_alignment
         *
         * @since 1.7.2
         * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
         * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
         * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
         * distribution for backward compatibility.
         *
         * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
         * control to benefit from new charting enhancements and timely support. **
         *
         * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
         * make sure you evaluate it thoroughly before migration.
         * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
         */
        enum Common_alignment {
          /**
           * Value end
           */
          end = "end",
          /**
           * Value middle
           */
          middle = "middle",
          /**
           * Value start
           */
          start = "start",
        }
        /**
         * List (Enum) type sap.viz.ui5.types.legend.Common_drawingEffect
         *
         * @since 1.7.2
         * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
         * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
         * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
         * distribution for backward compatibility.
         *
         * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
         * control to benefit from new charting enhancements and timely support. **
         *
         * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
         * make sure you evaluate it thoroughly before migration.
         * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
         */
        enum Common_drawingEffect {
          /**
           * Value glossy
           */
          glossy = "glossy",
          /**
           * Value normal
           */
          normal = "normal",
        }
        /**
         * List (Enum) type sap.viz.ui5.types.legend.Common_position
         *
         * @since 1.7.2
         * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
         * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
         * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
         * distribution for backward compatibility.
         *
         * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
         * control to benefit from new charting enhancements and timely support. **
         *
         * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
         * make sure you evaluate it thoroughly before migration.
         * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
         */
        enum Common_position {
          /**
           * Value bottom
           */
          bottom = "bottom",
          /**
           * Value left
           */
          left = "left",
          /**
           * Value right
           */
          right = "right",
          /**
           * Value top
           */
          top = "top",
        }
        /**
         * List (Enum) type sap.viz.ui5.types.legend.Common_type
         *
         * @since 1.7.2
         * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
         * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
         * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
         * distribution for backward compatibility.
         *
         * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
         * control to benefit from new charting enhancements and timely support. **
         *
         * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
         * make sure you evaluate it thoroughly before migration.
         * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
         */
        enum Common_type {
          /**
           * Value BubbleColorLegend
           */
          BubbleColorLegend = "BubbleColorLegend",
          /**
           * Value ColorLegend
           */
          ColorLegend = "ColorLegend",
          /**
           * Value MeasureBasedColoringLegend
           */
          MeasureBasedColoringLegend = "MeasureBasedColoringLegend",
          /**
           * Value SizeLegend
           */
          SizeLegend = "SizeLegend",
        }
      }

      /**
       * List (Enum) type sap.viz.ui5.types.Area_drawingEffect
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Area_drawingEffect {
        /**
         * Value glossy
         */
        glossy = "glossy",
        /**
         * Value normal
         */
        normal = "normal",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Area_marker_shape
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Area_marker_shape {
        /**
         * Value circle
         */
        circle = "circle",
        /**
         * Value cross
         */
        cross = "cross",
        /**
         * Value diamond
         */
        diamond = "diamond",
        /**
         * Value intersection
         */
        intersection = "intersection",
        /**
         * Value triangleDown
         */
        triangleDown = "triangleDown",
        /**
         * Value triangleLeft
         */
        triangleLeft = "triangleLeft",
        /**
         * Value triangleRight
         */
        triangleRight = "triangleRight",
        /**
         * Value triangleUp
         */
        triangleUp = "triangleUp",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Area_mode
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Area_mode {
        /**
         * Value comparison
         */
        comparison = "comparison",
        /**
         * Value percentage
         */
        percentage = "percentage",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Area_orientation
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Area_orientation {
        /**
         * Value horizontal
         */
        horizontal = "horizontal",
        /**
         * Value vertical
         */
        vertical = "vertical",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Axis_gridline_type
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Axis_gridline_type {
        /**
         * Value dotted
         */
        dotted = "dotted",
        /**
         * Value incised
         */
        incised = "incised",
        /**
         * Value line
         */
        line = "line",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Axis_label_unitFormatType
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Axis_label_unitFormatType {
        /**
         * Value FinancialUnits
         */
        FinancialUnits = "FinancialUnits",
        /**
         * Value MetricUnits
         */
        MetricUnits = "MetricUnits",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Axis_position
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Axis_position {
        /**
         * Value bottom
         */
        bottom = "bottom",
        /**
         * Value left
         */
        left = "left",
        /**
         * Value right
         */
        right = "right",
        /**
         * Value top
         */
        top = "top",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Axis_type
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Axis_type {
        /**
         * Value category
         */
        category = "category",
        /**
         * Value timeValue
         */
        timeValue = "timeValue",
        /**
         * Value value
         */
        value = "value",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Background_direction
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Background_direction {
        /**
         * Value horizontal
         */
        horizontal = "horizontal",
        /**
         * Value vertical
         */
        vertical = "vertical",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Background_drawingEffect
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Background_drawingEffect {
        /**
         * Value glossy
         */
        glossy = "glossy",
        /**
         * Value normal
         */
        normal = "normal",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Bar_drawingEffect
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Bar_drawingEffect {
        /**
         * Value glossy
         */
        glossy = "glossy",
        /**
         * Value normal
         */
        normal = "normal",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Bar_orientation
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Bar_orientation {
        /**
         * Value horizontal
         */
        horizontal = "horizontal",
        /**
         * Value vertical
         */
        vertical = "vertical",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Bubble_drawingEffect
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Bubble_drawingEffect {
        /**
         * Value glossy
         */
        glossy = "glossy",
        /**
         * Value normal
         */
        normal = "normal",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Bullet_drawingEffect
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Bullet_drawingEffect {
        /**
         * Value glossy
         */
        glossy = "glossy",
        /**
         * Value normal
         */
        normal = "normal",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Bullet_orientation
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Bullet_orientation {
        /**
         * Value horizontal
         */
        horizontal = "horizontal",
        /**
         * Value vertical
         */
        vertical = "vertical",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Combination_drawingEffect
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Combination_drawingEffect {
        /**
         * Value glossy
         */
        glossy = "glossy",
        /**
         * Value normal
         */
        normal = "normal",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Combination_orientation
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Combination_orientation {
        /**
         * Value horizontal
         */
        horizontal = "horizontal",
        /**
         * Value vertical
         */
        vertical = "vertical",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Datalabel_orientation
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Datalabel_orientation {
        /**
         * Value horizontal
         */
        horizontal = "horizontal",
        /**
         * Value vertical
         */
        vertical = "vertical",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Datalabel_outsidePosition
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Datalabel_outsidePosition {
        /**
         * Value down
         */
        down = "down",
        /**
         * Value left
         */
        left = "left",
        /**
         * Value right
         */
        right = "right",
        /**
         * Value up
         */
        up = "up",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Datalabel_paintingMode
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Datalabel_paintingMode {
        /**
         * Value polarCoordinate
         */
        polarCoordinate = "polarCoordinate",
        /**
         * Value rectCoordinate
         */
        rectCoordinate = "rectCoordinate",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Datalabel_position
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Datalabel_position {
        /**
         * Value inside
         */
        inside = "inside",
        /**
         * Value outside
         */
        outside = "outside",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Legend_layout_position
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Legend_layout_position {
        /**
         * Value bottom
         */
        bottom = "bottom",
        /**
         * Value left
         */
        left = "left",
        /**
         * Value right
         */
        right = "right",
        /**
         * Value top
         */
        top = "top",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Line_drawingEffect
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Line_drawingEffect {
        /**
         * Value glossy
         */
        glossy = "glossy",
        /**
         * Value normal
         */
        normal = "normal",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Line_marker_shape
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Line_marker_shape {
        /**
         * Value circle
         */
        circle = "circle",
        /**
         * Value cross
         */
        cross = "cross",
        /**
         * Value diamond
         */
        diamond = "diamond",
        /**
         * Value intersection
         */
        intersection = "intersection",
        /**
         * Value triangleDown
         */
        triangleDown = "triangleDown",
        /**
         * Value triangleLeft
         */
        triangleLeft = "triangleLeft",
        /**
         * Value triangleRight
         */
        triangleRight = "triangleRight",
        /**
         * Value triangleUp
         */
        triangleUp = "triangleUp",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Line_orientation
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Line_orientation {
        /**
         * Value horizontal
         */
        horizontal = "horizontal",
        /**
         * Value vertical
         */
        vertical = "vertical",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Pie_drawingEffect
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Pie_drawingEffect {
        /**
         * Value glossy
         */
        glossy = "glossy",
        /**
         * Value normal
         */
        normal = "normal",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Pie_valign
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Pie_valign {
        /**
         * Value center
         */
        center = "center",
        /**
         * Value top
         */
        top = "top",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Scatter_drawingEffect
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Scatter_drawingEffect {
        /**
         * Value glossy
         */
        glossy = "glossy",
        /**
         * Value normal
         */
        normal = "normal",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.StackedVerticalBar_drawingEffect
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum StackedVerticalBar_drawingEffect {
        /**
         * Value glossy
         */
        glossy = "glossy",
        /**
         * Value normal
         */
        normal = "normal",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.StackedVerticalBar_mode
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum StackedVerticalBar_mode {
        /**
         * Value comparison
         */
        comparison = "comparison",
        /**
         * Value percentage
         */
        percentage = "percentage",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.StackedVerticalBar_orientation
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum StackedVerticalBar_orientation {
        /**
         * Value horizontal
         */
        horizontal = "horizontal",
        /**
         * Value vertical
         */
        vertical = "vertical",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Title_alignment
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Title_alignment {
        /**
         * Value center
         */
        center = "center",
        /**
         * Value left
         */
        left = "left",
        /**
         * Value right
         */
        right = "right",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.Tooltip_drawingEffect
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum Tooltip_drawingEffect {
        /**
         * Value glossy
         */
        glossy = "glossy",
        /**
         * Value normal
         */
        normal = "normal",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.VerticalBar_drawingEffect
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum VerticalBar_drawingEffect {
        /**
         * Value glossy
         */
        glossy = "glossy",
        /**
         * Value normal
         */
        normal = "normal",
      }
      /**
       * List (Enum) type sap.viz.ui5.types.VerticalBar_orientation
       *
       * @since 1.7.2
       * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
       * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
       * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
       * distribution for backward compatibility.
       *
       * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
       * control to benefit from new charting enhancements and timely support. **
       *
       * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
       * make sure you evaluate it thoroughly before migration.
       * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
       */
      enum VerticalBar_orientation {
        /**
         * Value horizontal
         */
        horizontal = "horizontal",
        /**
         * Value vertical
         */
        vertical = "vertical",
      }
    }
  }
}

declare module "sap/viz/ui5/api/env/Format" {
  /**
   * Provides methods set global formatter for VizFrame.
   *
   * @since 1.24.0
   */
  interface Format {
    /**
     * Customize the global numeric formatter. If you set a formatter, it will replace the existing formatter.
     * This function will take effect globally.
     *
     * Example:
     * ```javascript
     *
     * // Format required from "sap/viz/ui5/api/env/Format"
     * var customerFormatter = {
     *     format : function(value, pattern) {
     *         // add your codes here to convert number value to formatted string
     *         // according to the pattern string
     *         return formattedString;
     *     }
     * };
     * Format.numericFormatter(customerFormatter);
     * ```
     */
    numericFormatter(formatter: Function): any;
  }
  const Format: Format;
  export default Format;
}

declare module "sap/viz/ui5/Area" {
  import {
    default as BaseChart,
    $BaseChartSettings,
  } from "sap/viz/ui5/core/BaseChart";

  import Event from "sap/ui/base/Event";

  import Background from "sap/viz/ui5/types/Background";

  import Datalabel from "sap/viz/ui5/types/Datalabel";

  import RootContainer from "sap/viz/ui5/types/RootContainer";

  import Interaction from "sap/viz/ui5/types/controller/Interaction";

  import Common from "sap/viz/ui5/types/legend/Common";

  import Legend from "sap/viz/ui5/types/Legend";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Area1 from "sap/viz/ui5/types/Area";

  import Title from "sap/viz/ui5/types/Title";

  import Tooltip from "sap/viz/ui5/types/Tooltip";

  import Axis from "sap/viz/ui5/types/Axis";

  import XYContainer from "sap/viz/ui5/types/XYContainer";

  /**
   * Chart sap.viz.ui5.Area
   *
   * @since 1.7.2
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export default class Area extends BaseChart {
    /**
     * Constructor for a new sap.viz.ui5.Area
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $AreaSettings
    );
    /**
     * Constructor for a new sap.viz.ui5.Area
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $AreaSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.Area with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.core.BaseChart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Area>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.Area.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Area`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Area` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Area` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Area`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Area` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Area` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Area`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Area` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Area` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Area`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Area` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Area` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Area`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Area` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Area` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Area`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Area` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Area` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Area`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Area` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Area` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Area`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Area` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Area` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Area`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Area` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Area` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Area`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Area` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Area` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the background in the aggregation {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyBackground(): this;
    /**
     * Destroys the dataLabel in the aggregation {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataLabel(): this;
    /**
     * Destroys the general in the aggregation {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGeneral(): this;
    /**
     * Destroys the interaction in the aggregation {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInteraction(): this;
    /**
     * Destroys the legend in the aggregation {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegend(): this;
    /**
     * Destroys the legendGroup in the aggregation {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegendGroup(): this;
    /**
     * Destroys the plotArea in the aggregation {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPlotArea(): this;
    /**
     * Destroys the title in the aggregation {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTitle(): this;
    /**
     * Destroys the toolTip in the aggregation {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolTip(): this;
    /**
     * Destroys the xAxis in the aggregation {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXAxis(): this;
    /**
     * Destroys the xyContainer in the aggregation {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXyContainer(): this;
    /**
     * Destroys the yAxis in the aggregation {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Area`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeselectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Area`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHideTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialized initialized} event of this `sap.viz.ui5.Area`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialized(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectData selectData} event of this `sap.viz.ui5.Area`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Area`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShowTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:deselectData deselectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeselectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:hideTooltip hideTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHideTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:initialized initialized} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialized(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectData selectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:showTooltip showTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShowTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getBackground background}.
     *
     * Module sap.viz.modules.background
     */
    getBackground(): Background;
    /**
     * Gets content of aggregation {@link #getDataLabel dataLabel}.
     *
     * Module sap.viz.modules.datalabel
     */
    getDataLabel(): Datalabel;
    /**
     * Gets content of aggregation {@link #getGeneral general}.
     *
     * Module sap.viz.modules.rootContainer
     */
    getGeneral(): RootContainer;
    /**
     * Gets content of aggregation {@link #getInteraction interaction}.
     *
     * Module sap.viz.modules.controller.interaction
     */
    getInteraction(): Interaction;
    /**
     * Gets content of aggregation {@link #getLegend legend}.
     *
     * Module sap.viz.modules.legend.common
     */
    getLegend(): Common;
    /**
     * Gets content of aggregation {@link #getLegendGroup legendGroup}.
     *
     * Module sap.viz.modules.legend
     */
    getLegendGroup(): Legend;
    /**
     * Gets content of aggregation {@link #getPlotArea plotArea}.
     *
     * Module sap.viz.modules.area
     */
    getPlotArea(): Area1;
    /**
     * Gets content of aggregation {@link #getTitle title}.
     *
     * Module sap.viz.modules.title
     */
    getTitle(): Title;
    /**
     * Gets content of aggregation {@link #getToolTip toolTip}.
     *
     * Module sap.viz.chart.elements.Tooltip
     */
    getToolTip(): Tooltip;
    /**
     * Gets content of aggregation {@link #getXAxis xAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getXAxis(): Axis;
    /**
     * Gets content of aggregation {@link #getXyContainer xyContainer}.
     *
     * Module sap.viz.modules.xycontainer
     */
    getXyContainer(): XYContainer;
    /**
     * Gets content of aggregation {@link #getYAxis yAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis(): Axis;
    /**
     * Sets the aggregated {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackground(
      /**
       * The background to set
       */
      oBackground: Background
    ): this;
    /**
     * Sets the aggregated {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabel(
      /**
       * The dataLabel to set
       */
      oDataLabel: Datalabel
    ): this;
    /**
     * Sets the aggregated {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGeneral(
      /**
       * The general to set
       */
      oGeneral: RootContainer
    ): this;
    /**
     * Sets the aggregated {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInteraction(
      /**
       * The interaction to set
       */
      oInteraction: Interaction
    ): this;
    /**
     * Sets the aggregated {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegend(
      /**
       * The legend to set
       */
      oLegend: Common
    ): this;
    /**
     * Sets the aggregated {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendGroup(
      /**
       * The legendGroup to set
       */
      oLegendGroup: Legend
    ): this;
    /**
     * Sets the aggregated {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlotArea(
      /**
       * The plotArea to set
       */
      oPlotArea: Area1
    ): this;
    /**
     * Sets the aggregated {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * The title to set
       */
      oTitle: Title
    ): this;
    /**
     * Sets the aggregated {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolTip(
      /**
       * The toolTip to set
       */
      oToolTip: Tooltip
    ): this;
    /**
     * Sets the aggregated {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxis(
      /**
       * The xAxis to set
       */
      oXAxis: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXyContainer(
      /**
       * The xyContainer to set
       */
      oXyContainer: XYContainer
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis(
      /**
       * The yAxis to set
       */
      oYAxis: Axis
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Area constructor.
   *
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export interface $AreaSettings extends $BaseChartSettings {
    /**
     * Module sap.viz.modules.rootContainer
     */
    general?: RootContainer;

    /**
     * Module sap.viz.modules.controller.interaction
     */
    interaction?: Interaction;

    /**
     * Module sap.viz.modules.title
     */
    title?: Title;

    /**
     * Module sap.viz.modules.legend
     */
    legendGroup?: Legend;

    /**
     * Module sap.viz.modules.legend.common
     */
    legend?: Common;

    /**
     * Module sap.viz.chart.elements.Tooltip
     */
    toolTip?: Tooltip;

    /**
     * Module sap.viz.modules.xycontainer
     */
    xyContainer?: XYContainer;

    /**
     * Module sap.viz.modules.datalabel
     */
    dataLabel?: Datalabel;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis?: Axis;

    /**
     * Module sap.viz.modules.axis
     */
    xAxis?: Axis;

    /**
     * Module sap.viz.modules.background
     */
    background?: Background;

    /**
     * Module sap.viz.modules.area
     */
    plotArea?: Area1;

    /**
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     */
    selectData?: (oEvent: Event) => void;

    /**
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     */
    deselectData?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    showTooltip?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    hideTooltip?: (oEvent: Event) => void;

    /**
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     */
    initialized?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Area#deselectData event.
   */
  export interface Area$DeselectDataEventParameters {}

  /**
   * Event object of the Area#deselectData event.
   */
  export type Area$DeselectDataEvent = Event<
    Area$DeselectDataEventParameters,
    Area
  >;

  /**
   * Parameters of the Area#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Area$HideTooltipEventParameters {}

  /**
   * Event object of the Area#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Area$HideTooltipEvent = Event<
    Area$HideTooltipEventParameters,
    Area
  >;

  /**
   * Parameters of the Area#initialized event.
   */
  export interface Area$InitializedEventParameters {}

  /**
   * Event object of the Area#initialized event.
   */
  export type Area$InitializedEvent = Event<
    Area$InitializedEventParameters,
    Area
  >;

  /**
   * Parameters of the Area#selectData event.
   */
  export interface Area$SelectDataEventParameters {}

  /**
   * Event object of the Area#selectData event.
   */
  export type Area$SelectDataEvent = Event<
    Area$SelectDataEventParameters,
    Area
  >;

  /**
   * Parameters of the Area#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Area$ShowTooltipEventParameters {}

  /**
   * Event object of the Area#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Area$ShowTooltipEvent = Event<
    Area$ShowTooltipEventParameters,
    Area
  >;
}

declare module "sap/viz/ui5/Area100" {
  import {
    default as BaseChart,
    $BaseChartSettings,
  } from "sap/viz/ui5/core/BaseChart";

  import Event from "sap/ui/base/Event";

  import Background from "sap/viz/ui5/types/Background";

  import Datalabel from "sap/viz/ui5/types/Datalabel";

  import RootContainer from "sap/viz/ui5/types/RootContainer";

  import Interaction from "sap/viz/ui5/types/controller/Interaction";

  import Common from "sap/viz/ui5/types/legend/Common";

  import Legend from "sap/viz/ui5/types/Legend";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Area from "sap/viz/ui5/types/Area";

  import Title from "sap/viz/ui5/types/Title";

  import Tooltip from "sap/viz/ui5/types/Tooltip";

  import Axis from "sap/viz/ui5/types/Axis";

  import XYContainer from "sap/viz/ui5/types/XYContainer";

  /**
   * Chart sap.viz.ui5.Area100
   *
   * @since 1.7.2
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export default class Area100 extends BaseChart {
    /**
     * Constructor for a new sap.viz.ui5.Area100
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $Area100Settings
    );
    /**
     * Constructor for a new sap.viz.ui5.Area100
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $Area100Settings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.Area100 with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.core.BaseChart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Area100>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.Area100.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Area100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Area100` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Area100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Area100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Area100` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Area100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Area100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Area100` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Area100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Area100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Area100` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Area100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Area100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Area100` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Area100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Area100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Area100` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Area100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Area100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Area100` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Area100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Area100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Area100` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Area100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Area100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Area100` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Area100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Area100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Area100` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Area100` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the background in the aggregation {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyBackground(): this;
    /**
     * Destroys the dataLabel in the aggregation {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataLabel(): this;
    /**
     * Destroys the general in the aggregation {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGeneral(): this;
    /**
     * Destroys the interaction in the aggregation {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInteraction(): this;
    /**
     * Destroys the legend in the aggregation {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegend(): this;
    /**
     * Destroys the legendGroup in the aggregation {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegendGroup(): this;
    /**
     * Destroys the plotArea in the aggregation {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPlotArea(): this;
    /**
     * Destroys the title in the aggregation {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTitle(): this;
    /**
     * Destroys the toolTip in the aggregation {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolTip(): this;
    /**
     * Destroys the xAxis in the aggregation {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXAxis(): this;
    /**
     * Destroys the xyContainer in the aggregation {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXyContainer(): this;
    /**
     * Destroys the yAxis in the aggregation {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Area100`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeselectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Area100`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHideTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialized initialized} event of this `sap.viz.ui5.Area100`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialized(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectData selectData} event of this `sap.viz.ui5.Area100`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Area100`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShowTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:deselectData deselectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeselectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:hideTooltip hideTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHideTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:initialized initialized} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialized(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectData selectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:showTooltip showTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShowTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getBackground background}.
     *
     * Module sap.viz.modules.background
     */
    getBackground(): Background;
    /**
     * Gets content of aggregation {@link #getDataLabel dataLabel}.
     *
     * Module sap.viz.modules.datalabel
     */
    getDataLabel(): Datalabel;
    /**
     * Gets content of aggregation {@link #getGeneral general}.
     *
     * Module sap.viz.modules.rootContainer
     */
    getGeneral(): RootContainer;
    /**
     * Gets content of aggregation {@link #getInteraction interaction}.
     *
     * Module sap.viz.modules.controller.interaction
     */
    getInteraction(): Interaction;
    /**
     * Gets content of aggregation {@link #getLegend legend}.
     *
     * Module sap.viz.modules.legend.common
     */
    getLegend(): Common;
    /**
     * Gets content of aggregation {@link #getLegendGroup legendGroup}.
     *
     * Module sap.viz.modules.legend
     */
    getLegendGroup(): Legend;
    /**
     * Gets content of aggregation {@link #getPlotArea plotArea}.
     *
     * Module sap.viz.modules.area
     */
    getPlotArea(): Area;
    /**
     * Gets content of aggregation {@link #getTitle title}.
     *
     * Module sap.viz.modules.title
     */
    getTitle(): Title;
    /**
     * Gets content of aggregation {@link #getToolTip toolTip}.
     *
     * Module sap.viz.chart.elements.Tooltip
     */
    getToolTip(): Tooltip;
    /**
     * Gets content of aggregation {@link #getXAxis xAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getXAxis(): Axis;
    /**
     * Gets content of aggregation {@link #getXyContainer xyContainer}.
     *
     * Module sap.viz.modules.xycontainer
     */
    getXyContainer(): XYContainer;
    /**
     * Gets content of aggregation {@link #getYAxis yAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis(): Axis;
    /**
     * Sets the aggregated {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackground(
      /**
       * The background to set
       */
      oBackground: Background
    ): this;
    /**
     * Sets the aggregated {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabel(
      /**
       * The dataLabel to set
       */
      oDataLabel: Datalabel
    ): this;
    /**
     * Sets the aggregated {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGeneral(
      /**
       * The general to set
       */
      oGeneral: RootContainer
    ): this;
    /**
     * Sets the aggregated {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInteraction(
      /**
       * The interaction to set
       */
      oInteraction: Interaction
    ): this;
    /**
     * Sets the aggregated {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegend(
      /**
       * The legend to set
       */
      oLegend: Common
    ): this;
    /**
     * Sets the aggregated {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendGroup(
      /**
       * The legendGroup to set
       */
      oLegendGroup: Legend
    ): this;
    /**
     * Sets the aggregated {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlotArea(
      /**
       * The plotArea to set
       */
      oPlotArea: Area
    ): this;
    /**
     * Sets the aggregated {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * The title to set
       */
      oTitle: Title
    ): this;
    /**
     * Sets the aggregated {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolTip(
      /**
       * The toolTip to set
       */
      oToolTip: Tooltip
    ): this;
    /**
     * Sets the aggregated {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxis(
      /**
       * The xAxis to set
       */
      oXAxis: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXyContainer(
      /**
       * The xyContainer to set
       */
      oXyContainer: XYContainer
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis(
      /**
       * The yAxis to set
       */
      oYAxis: Axis
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Area100 constructor.
   *
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export interface $Area100Settings extends $BaseChartSettings {
    /**
     * Module sap.viz.modules.rootContainer
     */
    general?: RootContainer;

    /**
     * Module sap.viz.modules.controller.interaction
     */
    interaction?: Interaction;

    /**
     * Module sap.viz.modules.title
     */
    title?: Title;

    /**
     * Module sap.viz.modules.legend
     */
    legendGroup?: Legend;

    /**
     * Module sap.viz.modules.legend.common
     */
    legend?: Common;

    /**
     * Module sap.viz.chart.elements.Tooltip
     */
    toolTip?: Tooltip;

    /**
     * Module sap.viz.modules.xycontainer
     */
    xyContainer?: XYContainer;

    /**
     * Module sap.viz.modules.datalabel
     */
    dataLabel?: Datalabel;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis?: Axis;

    /**
     * Module sap.viz.modules.axis
     */
    xAxis?: Axis;

    /**
     * Module sap.viz.modules.background
     */
    background?: Background;

    /**
     * Module sap.viz.modules.area
     */
    plotArea?: Area;

    /**
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     */
    selectData?: (oEvent: Event) => void;

    /**
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     */
    deselectData?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    showTooltip?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    hideTooltip?: (oEvent: Event) => void;

    /**
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     */
    initialized?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Area100#deselectData event.
   */
  export interface Area100$DeselectDataEventParameters {}

  /**
   * Event object of the Area100#deselectData event.
   */
  export type Area100$DeselectDataEvent = Event<
    Area100$DeselectDataEventParameters,
    Area100
  >;

  /**
   * Parameters of the Area100#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Area100$HideTooltipEventParameters {}

  /**
   * Event object of the Area100#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Area100$HideTooltipEvent = Event<
    Area100$HideTooltipEventParameters,
    Area100
  >;

  /**
   * Parameters of the Area100#initialized event.
   */
  export interface Area100$InitializedEventParameters {}

  /**
   * Event object of the Area100#initialized event.
   */
  export type Area100$InitializedEvent = Event<
    Area100$InitializedEventParameters,
    Area100
  >;

  /**
   * Parameters of the Area100#selectData event.
   */
  export interface Area100$SelectDataEventParameters {}

  /**
   * Event object of the Area100#selectData event.
   */
  export type Area100$SelectDataEvent = Event<
    Area100$SelectDataEventParameters,
    Area100
  >;

  /**
   * Parameters of the Area100#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Area100$ShowTooltipEventParameters {}

  /**
   * Event object of the Area100#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Area100$ShowTooltipEvent = Event<
    Area100$ShowTooltipEventParameters,
    Area100
  >;
}

declare module "sap/viz/ui5/Bar" {
  import {
    default as BaseChart,
    $BaseChartSettings,
  } from "sap/viz/ui5/core/BaseChart";

  import Event from "sap/ui/base/Event";

  import Background from "sap/viz/ui5/types/Background";

  import Datalabel from "sap/viz/ui5/types/Datalabel";

  import RootContainer from "sap/viz/ui5/types/RootContainer";

  import Interaction from "sap/viz/ui5/types/controller/Interaction";

  import Common from "sap/viz/ui5/types/legend/Common";

  import Legend from "sap/viz/ui5/types/Legend";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Bar1 from "sap/viz/ui5/types/Bar";

  import Title from "sap/viz/ui5/types/Title";

  import Tooltip from "sap/viz/ui5/types/Tooltip";

  import Axis from "sap/viz/ui5/types/Axis";

  import XYContainer from "sap/viz/ui5/types/XYContainer";

  /**
   * Chart sap.viz.ui5.Bar
   *
   * @since 1.7.2
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'bar'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export default class Bar extends BaseChart {
    /**
     * Constructor for a new sap.viz.ui5.Bar
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $BarSettings
    );
    /**
     * Constructor for a new sap.viz.ui5.Bar
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $BarSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.Bar with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.core.BaseChart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Bar>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.Bar.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Bar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bar` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Bar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bar` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Bar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bar` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Bar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bar` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Bar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bar` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Bar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bar` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Bar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bar` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Bar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bar` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Bar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bar` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Bar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bar` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bar` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the background in the aggregation {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyBackground(): this;
    /**
     * Destroys the dataLabel in the aggregation {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataLabel(): this;
    /**
     * Destroys the general in the aggregation {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGeneral(): this;
    /**
     * Destroys the interaction in the aggregation {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInteraction(): this;
    /**
     * Destroys the legend in the aggregation {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegend(): this;
    /**
     * Destroys the legendGroup in the aggregation {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegendGroup(): this;
    /**
     * Destroys the plotArea in the aggregation {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPlotArea(): this;
    /**
     * Destroys the title in the aggregation {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTitle(): this;
    /**
     * Destroys the toolTip in the aggregation {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolTip(): this;
    /**
     * Destroys the xAxis in the aggregation {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXAxis(): this;
    /**
     * Destroys the xyContainer in the aggregation {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXyContainer(): this;
    /**
     * Destroys the yAxis in the aggregation {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Bar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeselectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Bar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHideTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialized initialized} event of this `sap.viz.ui5.Bar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialized(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectData selectData} event of this `sap.viz.ui5.Bar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Bar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShowTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:deselectData deselectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeselectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:hideTooltip hideTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHideTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:initialized initialized} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialized(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectData selectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:showTooltip showTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShowTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getBackground background}.
     *
     * Module sap.viz.modules.background
     */
    getBackground(): Background;
    /**
     * Gets content of aggregation {@link #getDataLabel dataLabel}.
     *
     * Module sap.viz.modules.datalabel
     */
    getDataLabel(): Datalabel;
    /**
     * Gets content of aggregation {@link #getGeneral general}.
     *
     * Module sap.viz.modules.rootContainer
     */
    getGeneral(): RootContainer;
    /**
     * Gets content of aggregation {@link #getInteraction interaction}.
     *
     * Module sap.viz.modules.controller.interaction
     */
    getInteraction(): Interaction;
    /**
     * Gets content of aggregation {@link #getLegend legend}.
     *
     * Module sap.viz.modules.legend.common
     */
    getLegend(): Common;
    /**
     * Gets content of aggregation {@link #getLegendGroup legendGroup}.
     *
     * Module sap.viz.modules.legend
     */
    getLegendGroup(): Legend;
    /**
     * Gets content of aggregation {@link #getPlotArea plotArea}.
     *
     * Module sap.viz.modules.bar
     */
    getPlotArea(): Bar1;
    /**
     * Gets content of aggregation {@link #getTitle title}.
     *
     * Module sap.viz.modules.title
     */
    getTitle(): Title;
    /**
     * Gets content of aggregation {@link #getToolTip toolTip}.
     *
     * Module sap.viz.chart.elements.Tooltip
     */
    getToolTip(): Tooltip;
    /**
     * Gets content of aggregation {@link #getXAxis xAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getXAxis(): Axis;
    /**
     * Gets content of aggregation {@link #getXyContainer xyContainer}.
     *
     * Module sap.viz.modules.xycontainer
     */
    getXyContainer(): XYContainer;
    /**
     * Gets content of aggregation {@link #getYAxis yAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis(): Axis;
    /**
     * Sets the aggregated {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackground(
      /**
       * The background to set
       */
      oBackground: Background
    ): this;
    /**
     * Sets the aggregated {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabel(
      /**
       * The dataLabel to set
       */
      oDataLabel: Datalabel
    ): this;
    /**
     * Sets the aggregated {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGeneral(
      /**
       * The general to set
       */
      oGeneral: RootContainer
    ): this;
    /**
     * Sets the aggregated {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInteraction(
      /**
       * The interaction to set
       */
      oInteraction: Interaction
    ): this;
    /**
     * Sets the aggregated {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegend(
      /**
       * The legend to set
       */
      oLegend: Common
    ): this;
    /**
     * Sets the aggregated {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendGroup(
      /**
       * The legendGroup to set
       */
      oLegendGroup: Legend
    ): this;
    /**
     * Sets the aggregated {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlotArea(
      /**
       * The plotArea to set
       */
      oPlotArea: Bar1
    ): this;
    /**
     * Sets the aggregated {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * The title to set
       */
      oTitle: Title
    ): this;
    /**
     * Sets the aggregated {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolTip(
      /**
       * The toolTip to set
       */
      oToolTip: Tooltip
    ): this;
    /**
     * Sets the aggregated {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxis(
      /**
       * The xAxis to set
       */
      oXAxis: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXyContainer(
      /**
       * The xyContainer to set
       */
      oXyContainer: XYContainer
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis(
      /**
       * The yAxis to set
       */
      oYAxis: Axis
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Bar constructor.
   *
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'bar'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export interface $BarSettings extends $BaseChartSettings {
    /**
     * Module sap.viz.modules.rootContainer
     */
    general?: RootContainer;

    /**
     * Module sap.viz.modules.controller.interaction
     */
    interaction?: Interaction;

    /**
     * Module sap.viz.modules.title
     */
    title?: Title;

    /**
     * Module sap.viz.modules.legend
     */
    legendGroup?: Legend;

    /**
     * Module sap.viz.modules.legend.common
     */
    legend?: Common;

    /**
     * Module sap.viz.chart.elements.Tooltip
     */
    toolTip?: Tooltip;

    /**
     * Module sap.viz.modules.xycontainer
     */
    xyContainer?: XYContainer;

    /**
     * Module sap.viz.modules.datalabel
     */
    dataLabel?: Datalabel;

    /**
     * Module sap.viz.modules.axis
     */
    xAxis?: Axis;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis?: Axis;

    /**
     * Module sap.viz.modules.background
     */
    background?: Background;

    /**
     * Module sap.viz.modules.bar
     */
    plotArea?: Bar1;

    /**
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     */
    selectData?: (oEvent: Event) => void;

    /**
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     */
    deselectData?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    showTooltip?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    hideTooltip?: (oEvent: Event) => void;

    /**
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     */
    initialized?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Bar#deselectData event.
   */
  export interface Bar$DeselectDataEventParameters {}

  /**
   * Event object of the Bar#deselectData event.
   */
  export type Bar$DeselectDataEvent = Event<
    Bar$DeselectDataEventParameters,
    Bar
  >;

  /**
   * Parameters of the Bar#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Bar$HideTooltipEventParameters {}

  /**
   * Event object of the Bar#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Bar$HideTooltipEvent = Event<Bar$HideTooltipEventParameters, Bar>;

  /**
   * Parameters of the Bar#initialized event.
   */
  export interface Bar$InitializedEventParameters {}

  /**
   * Event object of the Bar#initialized event.
   */
  export type Bar$InitializedEvent = Event<Bar$InitializedEventParameters, Bar>;

  /**
   * Parameters of the Bar#selectData event.
   */
  export interface Bar$SelectDataEventParameters {}

  /**
   * Event object of the Bar#selectData event.
   */
  export type Bar$SelectDataEvent = Event<Bar$SelectDataEventParameters, Bar>;

  /**
   * Parameters of the Bar#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Bar$ShowTooltipEventParameters {}

  /**
   * Event object of the Bar#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Bar$ShowTooltipEvent = Event<Bar$ShowTooltipEventParameters, Bar>;
}

declare module "sap/viz/ui5/Bubble" {
  import {
    default as BaseChart,
    $BaseChartSettings,
  } from "sap/viz/ui5/core/BaseChart";

  import Event from "sap/ui/base/Event";

  import Background from "sap/viz/ui5/types/Background";

  import Datalabel from "sap/viz/ui5/types/Datalabel";

  import RootContainer from "sap/viz/ui5/types/RootContainer";

  import Interaction from "sap/viz/ui5/types/controller/Interaction";

  import Common from "sap/viz/ui5/types/legend/Common";

  import Legend from "sap/viz/ui5/types/Legend";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Bubble1 from "sap/viz/ui5/types/Bubble";

  import Title from "sap/viz/ui5/types/Title";

  import Tooltip from "sap/viz/ui5/types/Tooltip";

  import Axis from "sap/viz/ui5/types/Axis";

  import XYContainer from "sap/viz/ui5/types/XYContainer";

  /**
   * Chart sap.viz.ui5.Bubble
   *
   * @since 1.7.2
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'bubble'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export default class Bubble extends BaseChart {
    /**
     * Constructor for a new sap.viz.ui5.Bubble
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $BubbleSettings
    );
    /**
     * Constructor for a new sap.viz.ui5.Bubble
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $BubbleSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.Bubble with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.core.BaseChart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Bubble>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.Bubble.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Bubble`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bubble` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bubble` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Bubble`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bubble` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bubble` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Bubble`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bubble` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bubble` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Bubble`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bubble` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bubble` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Bubble`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bubble` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bubble` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Bubble`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bubble` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bubble` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Bubble`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bubble` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bubble` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Bubble`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bubble` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bubble` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Bubble`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bubble` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bubble` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Bubble`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bubble` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bubble` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the background in the aggregation {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyBackground(): this;
    /**
     * Destroys the dataLabel in the aggregation {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataLabel(): this;
    /**
     * Destroys the general in the aggregation {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGeneral(): this;
    /**
     * Destroys the interaction in the aggregation {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInteraction(): this;
    /**
     * Destroys the legend in the aggregation {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegend(): this;
    /**
     * Destroys the legendGroup in the aggregation {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegendGroup(): this;
    /**
     * Destroys the plotArea in the aggregation {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPlotArea(): this;
    /**
     * Destroys the sizeLegend in the aggregation {@link #getSizeLegend sizeLegend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroySizeLegend(): this;
    /**
     * Destroys the title in the aggregation {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTitle(): this;
    /**
     * Destroys the toolTip in the aggregation {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolTip(): this;
    /**
     * Destroys the xAxis in the aggregation {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXAxis(): this;
    /**
     * Destroys the xyContainer in the aggregation {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXyContainer(): this;
    /**
     * Destroys the yAxis in the aggregation {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Bubble`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeselectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Bubble`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHideTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialized initialized} event of this `sap.viz.ui5.Bubble`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialized(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectData selectData} event of this `sap.viz.ui5.Bubble`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Bubble`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShowTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:deselectData deselectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeselectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:hideTooltip hideTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHideTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:initialized initialized} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialized(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectData selectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:showTooltip showTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShowTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getBackground background}.
     *
     * Module sap.viz.modules.background
     */
    getBackground(): Background;
    /**
     * Gets content of aggregation {@link #getDataLabel dataLabel}.
     *
     * Module sap.viz.modules.datalabel
     */
    getDataLabel(): Datalabel;
    /**
     * Gets content of aggregation {@link #getGeneral general}.
     *
     * Module sap.viz.modules.rootContainer
     */
    getGeneral(): RootContainer;
    /**
     * Gets content of aggregation {@link #getInteraction interaction}.
     *
     * Module sap.viz.modules.controller.interaction
     */
    getInteraction(): Interaction;
    /**
     * Gets content of aggregation {@link #getLegend legend}.
     *
     * Module sap.viz.modules.legend.common
     */
    getLegend(): Common;
    /**
     * Gets content of aggregation {@link #getLegendGroup legendGroup}.
     *
     * Module sap.viz.modules.legend
     */
    getLegendGroup(): Legend;
    /**
     * Gets content of aggregation {@link #getPlotArea plotArea}.
     *
     * Module sap.viz.modules.bubble
     */
    getPlotArea(): Bubble1;
    /**
     * Gets content of aggregation {@link #getSizeLegend sizeLegend}.
     *
     * Module sap.viz.modules.legend.common
     */
    getSizeLegend(): Common;
    /**
     * Gets content of aggregation {@link #getTitle title}.
     *
     * Module sap.viz.modules.title
     */
    getTitle(): Title;
    /**
     * Gets content of aggregation {@link #getToolTip toolTip}.
     *
     * Module sap.viz.chart.elements.Tooltip
     */
    getToolTip(): Tooltip;
    /**
     * Gets content of aggregation {@link #getXAxis xAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getXAxis(): Axis;
    /**
     * Gets content of aggregation {@link #getXyContainer xyContainer}.
     *
     * Module sap.viz.modules.xycontainer
     */
    getXyContainer(): XYContainer;
    /**
     * Gets content of aggregation {@link #getYAxis yAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis(): Axis;
    /**
     * Sets the aggregated {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackground(
      /**
       * The background to set
       */
      oBackground: Background
    ): this;
    /**
     * Sets the aggregated {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabel(
      /**
       * The dataLabel to set
       */
      oDataLabel: Datalabel
    ): this;
    /**
     * Sets the aggregated {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGeneral(
      /**
       * The general to set
       */
      oGeneral: RootContainer
    ): this;
    /**
     * Sets the aggregated {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInteraction(
      /**
       * The interaction to set
       */
      oInteraction: Interaction
    ): this;
    /**
     * Sets the aggregated {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegend(
      /**
       * The legend to set
       */
      oLegend: Common
    ): this;
    /**
     * Sets the aggregated {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendGroup(
      /**
       * The legendGroup to set
       */
      oLegendGroup: Legend
    ): this;
    /**
     * Sets the aggregated {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlotArea(
      /**
       * The plotArea to set
       */
      oPlotArea: Bubble1
    ): this;
    /**
     * Sets the aggregated {@link #getSizeLegend sizeLegend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSizeLegend(
      /**
       * The sizeLegend to set
       */
      oSizeLegend: Common
    ): this;
    /**
     * Sets the aggregated {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * The title to set
       */
      oTitle: Title
    ): this;
    /**
     * Sets the aggregated {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolTip(
      /**
       * The toolTip to set
       */
      oToolTip: Tooltip
    ): this;
    /**
     * Sets the aggregated {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxis(
      /**
       * The xAxis to set
       */
      oXAxis: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXyContainer(
      /**
       * The xyContainer to set
       */
      oXyContainer: XYContainer
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis(
      /**
       * The yAxis to set
       */
      oYAxis: Axis
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Bubble constructor.
   *
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'bubble'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export interface $BubbleSettings extends $BaseChartSettings {
    /**
     * Module sap.viz.modules.rootContainer
     */
    general?: RootContainer;

    /**
     * Module sap.viz.modules.title
     */
    title?: Title;

    /**
     * Module sap.viz.modules.legend
     */
    legendGroup?: Legend;

    /**
     * Module sap.viz.modules.legend.common
     */
    legend?: Common;

    /**
     * Module sap.viz.modules.legend.common
     */
    sizeLegend?: Common;

    /**
     * Module sap.viz.modules.xycontainer
     */
    xyContainer?: XYContainer;

    /**
     * Module sap.viz.modules.datalabel
     */
    dataLabel?: Datalabel;

    /**
     * Module sap.viz.modules.axis
     */
    xAxis?: Axis;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis?: Axis;

    /**
     * Module sap.viz.modules.background
     */
    background?: Background;

    /**
     * Module sap.viz.modules.bubble
     */
    plotArea?: Bubble1;

    /**
     * Module sap.viz.chart.elements.Tooltip
     */
    toolTip?: Tooltip;

    /**
     * Module sap.viz.modules.controller.interaction
     */
    interaction?: Interaction;

    /**
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     */
    selectData?: (oEvent: Event) => void;

    /**
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     */
    deselectData?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    showTooltip?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    hideTooltip?: (oEvent: Event) => void;

    /**
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     */
    initialized?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Bubble#deselectData event.
   */
  export interface Bubble$DeselectDataEventParameters {}

  /**
   * Event object of the Bubble#deselectData event.
   */
  export type Bubble$DeselectDataEvent = Event<
    Bubble$DeselectDataEventParameters,
    Bubble
  >;

  /**
   * Parameters of the Bubble#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Bubble$HideTooltipEventParameters {}

  /**
   * Event object of the Bubble#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Bubble$HideTooltipEvent = Event<
    Bubble$HideTooltipEventParameters,
    Bubble
  >;

  /**
   * Parameters of the Bubble#initialized event.
   */
  export interface Bubble$InitializedEventParameters {}

  /**
   * Event object of the Bubble#initialized event.
   */
  export type Bubble$InitializedEvent = Event<
    Bubble$InitializedEventParameters,
    Bubble
  >;

  /**
   * Parameters of the Bubble#selectData event.
   */
  export interface Bubble$SelectDataEventParameters {}

  /**
   * Event object of the Bubble#selectData event.
   */
  export type Bubble$SelectDataEvent = Event<
    Bubble$SelectDataEventParameters,
    Bubble
  >;

  /**
   * Parameters of the Bubble#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Bubble$ShowTooltipEventParameters {}

  /**
   * Event object of the Bubble#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Bubble$ShowTooltipEvent = Event<
    Bubble$ShowTooltipEventParameters,
    Bubble
  >;
}

declare module "sap/viz/ui5/Bullet" {
  import {
    default as BaseChart,
    $BaseChartSettings,
  } from "sap/viz/ui5/core/BaseChart";

  import Event from "sap/ui/base/Event";

  import Background from "sap/viz/ui5/types/Background";

  import RootContainer from "sap/viz/ui5/types/RootContainer";

  import Interaction from "sap/viz/ui5/types/controller/Interaction";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Bullet1 from "sap/viz/ui5/types/Bullet";

  import Title from "sap/viz/ui5/types/Title";

  import Tooltip from "sap/viz/ui5/types/Tooltip";

  import Axis from "sap/viz/ui5/types/Axis";

  import XYContainer from "sap/viz/ui5/types/XYContainer";

  /**
   * Chart sap.viz.ui5.Bullet
   *
   * @since 1.7.2
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'vertical_bullet'})`) **control to benefit from new charting
   * enhancements and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export default class Bullet extends BaseChart {
    /**
     * Constructor for a new sap.viz.ui5.Bullet
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $BulletSettings
    );
    /**
     * Constructor for a new sap.viz.ui5.Bullet
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $BulletSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.Bullet with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.core.BaseChart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Bullet>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.Bullet.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Bullet`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bullet` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bullet` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Bullet`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bullet` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bullet` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Bullet`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bullet` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bullet` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Bullet`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bullet` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bullet` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Bullet`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bullet` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bullet` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Bullet`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bullet` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bullet` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Bullet`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bullet` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bullet` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Bullet`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bullet` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bullet` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Bullet`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bullet` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bullet` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Bullet`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Bullet` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Bullet` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the background in the aggregation {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyBackground(): this;
    /**
     * Destroys the general in the aggregation {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGeneral(): this;
    /**
     * Destroys the interaction in the aggregation {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInteraction(): this;
    /**
     * Destroys the plotArea in the aggregation {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPlotArea(): this;
    /**
     * Destroys the title in the aggregation {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTitle(): this;
    /**
     * Destroys the toolTip in the aggregation {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolTip(): this;
    /**
     * Destroys the xAxis2 in the aggregation {@link #getXAxis2 xAxis2}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXAxis2(): this;
    /**
     * Destroys the xyContainer in the aggregation {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXyContainer(): this;
    /**
     * Destroys the yAxis in the aggregation {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis(): this;
    /**
     * Destroys the yAxis2 in the aggregation {@link #getYAxis2 yAxis2}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis2(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Bullet`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeselectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Bullet`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHideTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialized initialized} event of this `sap.viz.ui5.Bullet`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialized(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectData selectData} event of this `sap.viz.ui5.Bullet`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Bullet`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShowTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:deselectData deselectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeselectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:hideTooltip hideTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHideTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:initialized initialized} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialized(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectData selectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:showTooltip showTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShowTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getBackground background}.
     *
     * Module sap.viz.modules.background
     */
    getBackground(): Background;
    /**
     * Gets content of aggregation {@link #getGeneral general}.
     *
     * Module sap.viz.modules.rootContainer
     */
    getGeneral(): RootContainer;
    /**
     * Gets content of aggregation {@link #getInteraction interaction}.
     *
     * Module sap.viz.modules.controller.interaction
     */
    getInteraction(): Interaction;
    /**
     * Gets content of aggregation {@link #getPlotArea plotArea}.
     *
     * Module sap.viz.modules.bullet
     */
    getPlotArea(): Bullet1;
    /**
     * Gets content of aggregation {@link #getTitle title}.
     *
     * Module sap.viz.modules.title
     */
    getTitle(): Title;
    /**
     * Gets content of aggregation {@link #getToolTip toolTip}.
     *
     * Module sap.viz.chart.elements.Tooltip
     */
    getToolTip(): Tooltip;
    /**
     * Gets content of aggregation {@link #getXAxis2 xAxis2}.
     *
     * Module sap.viz.modules.axis
     */
    getXAxis2(): Axis;
    /**
     * Gets content of aggregation {@link #getXyContainer xyContainer}.
     *
     * Module sap.viz.modules.xycontainer
     */
    getXyContainer(): XYContainer;
    /**
     * Gets content of aggregation {@link #getYAxis yAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis(): Axis;
    /**
     * Gets content of aggregation {@link #getYAxis2 yAxis2}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis2(): Axis;
    /**
     * Sets the aggregated {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackground(
      /**
       * The background to set
       */
      oBackground: Background
    ): this;
    /**
     * Sets the aggregated {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGeneral(
      /**
       * The general to set
       */
      oGeneral: RootContainer
    ): this;
    /**
     * Sets the aggregated {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInteraction(
      /**
       * The interaction to set
       */
      oInteraction: Interaction
    ): this;
    /**
     * Sets the aggregated {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlotArea(
      /**
       * The plotArea to set
       */
      oPlotArea: Bullet1
    ): this;
    /**
     * Sets the aggregated {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * The title to set
       */
      oTitle: Title
    ): this;
    /**
     * Sets the aggregated {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolTip(
      /**
       * The toolTip to set
       */
      oToolTip: Tooltip
    ): this;
    /**
     * Sets the aggregated {@link #getXAxis2 xAxis2}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxis2(
      /**
       * The xAxis2 to set
       */
      oXAxis2: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXyContainer(
      /**
       * The xyContainer to set
       */
      oXyContainer: XYContainer
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis(
      /**
       * The yAxis to set
       */
      oYAxis: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis2 yAxis2}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis2(
      /**
       * The yAxis2 to set
       */
      oYAxis2: Axis
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Bullet constructor.
   *
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'vertical_bullet'})`) **control to benefit from new charting
   * enhancements and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export interface $BulletSettings extends $BaseChartSettings {
    /**
     * Module sap.viz.modules.rootContainer
     */
    general?: RootContainer;

    /**
     * Module sap.viz.modules.controller.interaction
     */
    interaction?: Interaction;

    /**
     * Module sap.viz.modules.title
     */
    title?: Title;

    /**
     * Module sap.viz.chart.elements.Tooltip
     */
    toolTip?: Tooltip;

    /**
     * Module sap.viz.modules.xycontainer
     */
    xyContainer?: XYContainer;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis?: Axis;

    /**
     * Module sap.viz.modules.background
     */
    background?: Background;

    /**
     * Module sap.viz.modules.bullet
     */
    plotArea?: Bullet1;

    /**
     * Module sap.viz.modules.axis
     */
    xAxis2?: Axis;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis2?: Axis;

    /**
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     */
    selectData?: (oEvent: Event) => void;

    /**
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     */
    deselectData?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    showTooltip?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    hideTooltip?: (oEvent: Event) => void;

    /**
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     */
    initialized?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Bullet#deselectData event.
   */
  export interface Bullet$DeselectDataEventParameters {}

  /**
   * Event object of the Bullet#deselectData event.
   */
  export type Bullet$DeselectDataEvent = Event<
    Bullet$DeselectDataEventParameters,
    Bullet
  >;

  /**
   * Parameters of the Bullet#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Bullet$HideTooltipEventParameters {}

  /**
   * Event object of the Bullet#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Bullet$HideTooltipEvent = Event<
    Bullet$HideTooltipEventParameters,
    Bullet
  >;

  /**
   * Parameters of the Bullet#initialized event.
   */
  export interface Bullet$InitializedEventParameters {}

  /**
   * Event object of the Bullet#initialized event.
   */
  export type Bullet$InitializedEvent = Event<
    Bullet$InitializedEventParameters,
    Bullet
  >;

  /**
   * Parameters of the Bullet#selectData event.
   */
  export interface Bullet$SelectDataEventParameters {}

  /**
   * Event object of the Bullet#selectData event.
   */
  export type Bullet$SelectDataEvent = Event<
    Bullet$SelectDataEventParameters,
    Bullet
  >;

  /**
   * Parameters of the Bullet#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Bullet$ShowTooltipEventParameters {}

  /**
   * Event object of the Bullet#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Bullet$ShowTooltipEvent = Event<
    Bullet$ShowTooltipEventParameters,
    Bullet
  >;
}

declare module "sap/viz/ui5/Column" {
  import {
    default as BaseChart,
    $BaseChartSettings,
  } from "sap/viz/ui5/core/BaseChart";

  import Event from "sap/ui/base/Event";

  import Background from "sap/viz/ui5/types/Background";

  import Datalabel from "sap/viz/ui5/types/Datalabel";

  import RootContainer from "sap/viz/ui5/types/RootContainer";

  import Interaction from "sap/viz/ui5/types/controller/Interaction";

  import Common from "sap/viz/ui5/types/legend/Common";

  import Legend from "sap/viz/ui5/types/Legend";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import VerticalBar from "sap/viz/ui5/types/VerticalBar";

  import Title from "sap/viz/ui5/types/Title";

  import Tooltip from "sap/viz/ui5/types/Tooltip";

  import Axis from "sap/viz/ui5/types/Axis";

  import XYContainer from "sap/viz/ui5/types/XYContainer";

  /**
   * Chart sap.viz.ui5.Column
   *
   * @since 1.7.2
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'column'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export default class Column extends BaseChart {
    /**
     * Constructor for a new sap.viz.ui5.Column
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ColumnSettings
    );
    /**
     * Constructor for a new sap.viz.ui5.Column
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ColumnSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.Column with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.core.BaseChart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Column>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.Column.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Column`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Column` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Column` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Column`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Column` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Column` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Column`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Column` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Column` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Column`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Column` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Column` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Column`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Column` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Column` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Column`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Column` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Column` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Column`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Column` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Column` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Column`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Column` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Column` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Column`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Column` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Column` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Column`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Column` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Column` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the background in the aggregation {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyBackground(): this;
    /**
     * Destroys the dataLabel in the aggregation {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataLabel(): this;
    /**
     * Destroys the general in the aggregation {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGeneral(): this;
    /**
     * Destroys the interaction in the aggregation {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInteraction(): this;
    /**
     * Destroys the legend in the aggregation {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegend(): this;
    /**
     * Destroys the legendGroup in the aggregation {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegendGroup(): this;
    /**
     * Destroys the plotArea in the aggregation {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPlotArea(): this;
    /**
     * Destroys the title in the aggregation {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTitle(): this;
    /**
     * Destroys the toolTip in the aggregation {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolTip(): this;
    /**
     * Destroys the xAxis in the aggregation {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXAxis(): this;
    /**
     * Destroys the xyContainer in the aggregation {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXyContainer(): this;
    /**
     * Destroys the yAxis in the aggregation {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Column`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeselectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Column`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHideTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialized initialized} event of this `sap.viz.ui5.Column`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialized(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectData selectData} event of this `sap.viz.ui5.Column`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Column`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShowTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:deselectData deselectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeselectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:hideTooltip hideTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHideTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:initialized initialized} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialized(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectData selectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:showTooltip showTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShowTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getBackground background}.
     *
     * Module sap.viz.modules.background
     */
    getBackground(): Background;
    /**
     * Gets content of aggregation {@link #getDataLabel dataLabel}.
     *
     * Module sap.viz.modules.datalabel
     */
    getDataLabel(): Datalabel;
    /**
     * Gets content of aggregation {@link #getGeneral general}.
     *
     * Module sap.viz.modules.rootContainer
     */
    getGeneral(): RootContainer;
    /**
     * Gets content of aggregation {@link #getInteraction interaction}.
     *
     * Module sap.viz.modules.controller.interaction
     */
    getInteraction(): Interaction;
    /**
     * Gets content of aggregation {@link #getLegend legend}.
     *
     * Module sap.viz.modules.legend.common
     */
    getLegend(): Common;
    /**
     * Gets content of aggregation {@link #getLegendGroup legendGroup}.
     *
     * Module sap.viz.modules.legend
     */
    getLegendGroup(): Legend;
    /**
     * Gets content of aggregation {@link #getPlotArea plotArea}.
     *
     * Module sap.viz.modules.verticalbar
     */
    getPlotArea(): VerticalBar;
    /**
     * Gets content of aggregation {@link #getTitle title}.
     *
     * Module sap.viz.modules.title
     */
    getTitle(): Title;
    /**
     * Gets content of aggregation {@link #getToolTip toolTip}.
     *
     * Module sap.viz.chart.elements.Tooltip
     */
    getToolTip(): Tooltip;
    /**
     * Gets content of aggregation {@link #getXAxis xAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getXAxis(): Axis;
    /**
     * Gets content of aggregation {@link #getXyContainer xyContainer}.
     *
     * Module sap.viz.modules.xycontainer
     */
    getXyContainer(): XYContainer;
    /**
     * Gets content of aggregation {@link #getYAxis yAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis(): Axis;
    /**
     * Sets the aggregated {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackground(
      /**
       * The background to set
       */
      oBackground: Background
    ): this;
    /**
     * Sets the aggregated {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabel(
      /**
       * The dataLabel to set
       */
      oDataLabel: Datalabel
    ): this;
    /**
     * Sets the aggregated {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGeneral(
      /**
       * The general to set
       */
      oGeneral: RootContainer
    ): this;
    /**
     * Sets the aggregated {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInteraction(
      /**
       * The interaction to set
       */
      oInteraction: Interaction
    ): this;
    /**
     * Sets the aggregated {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegend(
      /**
       * The legend to set
       */
      oLegend: Common
    ): this;
    /**
     * Sets the aggregated {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendGroup(
      /**
       * The legendGroup to set
       */
      oLegendGroup: Legend
    ): this;
    /**
     * Sets the aggregated {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlotArea(
      /**
       * The plotArea to set
       */
      oPlotArea: VerticalBar
    ): this;
    /**
     * Sets the aggregated {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * The title to set
       */
      oTitle: Title
    ): this;
    /**
     * Sets the aggregated {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolTip(
      /**
       * The toolTip to set
       */
      oToolTip: Tooltip
    ): this;
    /**
     * Sets the aggregated {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxis(
      /**
       * The xAxis to set
       */
      oXAxis: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXyContainer(
      /**
       * The xyContainer to set
       */
      oXyContainer: XYContainer
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis(
      /**
       * The yAxis to set
       */
      oYAxis: Axis
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Column constructor.
   *
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'column'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export interface $ColumnSettings extends $BaseChartSettings {
    /**
     * Module sap.viz.modules.rootContainer
     */
    general?: RootContainer;

    /**
     * Module sap.viz.modules.controller.interaction
     */
    interaction?: Interaction;

    /**
     * Module sap.viz.modules.title
     */
    title?: Title;

    /**
     * Module sap.viz.modules.legend
     */
    legendGroup?: Legend;

    /**
     * Module sap.viz.modules.legend.common
     */
    legend?: Common;

    /**
     * Module sap.viz.chart.elements.Tooltip
     */
    toolTip?: Tooltip;

    /**
     * Module sap.viz.modules.xycontainer
     */
    xyContainer?: XYContainer;

    /**
     * Module sap.viz.modules.datalabel
     */
    dataLabel?: Datalabel;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis?: Axis;

    /**
     * Module sap.viz.modules.axis
     */
    xAxis?: Axis;

    /**
     * Module sap.viz.modules.background
     */
    background?: Background;

    /**
     * Module sap.viz.modules.verticalbar
     */
    plotArea?: VerticalBar;

    /**
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     */
    selectData?: (oEvent: Event) => void;

    /**
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     */
    deselectData?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    showTooltip?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    hideTooltip?: (oEvent: Event) => void;

    /**
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     */
    initialized?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Column#deselectData event.
   */
  export interface Column$DeselectDataEventParameters {}

  /**
   * Event object of the Column#deselectData event.
   */
  export type Column$DeselectDataEvent = Event<
    Column$DeselectDataEventParameters,
    Column
  >;

  /**
   * Parameters of the Column#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Column$HideTooltipEventParameters {}

  /**
   * Event object of the Column#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Column$HideTooltipEvent = Event<
    Column$HideTooltipEventParameters,
    Column
  >;

  /**
   * Parameters of the Column#initialized event.
   */
  export interface Column$InitializedEventParameters {}

  /**
   * Event object of the Column#initialized event.
   */
  export type Column$InitializedEvent = Event<
    Column$InitializedEventParameters,
    Column
  >;

  /**
   * Parameters of the Column#selectData event.
   */
  export interface Column$SelectDataEventParameters {}

  /**
   * Event object of the Column#selectData event.
   */
  export type Column$SelectDataEvent = Event<
    Column$SelectDataEventParameters,
    Column
  >;

  /**
   * Parameters of the Column#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Column$ShowTooltipEventParameters {}

  /**
   * Event object of the Column#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Column$ShowTooltipEvent = Event<
    Column$ShowTooltipEventParameters,
    Column
  >;
}

declare module "sap/viz/ui5/Combination" {
  import {
    default as BaseChart,
    $BaseChartSettings,
  } from "sap/viz/ui5/core/BaseChart";

  import Event from "sap/ui/base/Event";

  import Background from "sap/viz/ui5/types/Background";

  import Datalabel from "sap/viz/ui5/types/Datalabel";

  import RootContainer from "sap/viz/ui5/types/RootContainer";

  import Interaction from "sap/viz/ui5/types/controller/Interaction";

  import Common from "sap/viz/ui5/types/legend/Common";

  import Legend from "sap/viz/ui5/types/Legend";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Combination1 from "sap/viz/ui5/types/Combination";

  import Title from "sap/viz/ui5/types/Title";

  import Tooltip from "sap/viz/ui5/types/Tooltip";

  import Axis from "sap/viz/ui5/types/Axis";

  import XYContainer from "sap/viz/ui5/types/XYContainer";

  /**
   * Chart sap.viz.ui5.Combination
   *
   * @since 1.7.2
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'combination'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export default class Combination extends BaseChart {
    /**
     * Constructor for a new sap.viz.ui5.Combination
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $CombinationSettings
    );
    /**
     * Constructor for a new sap.viz.ui5.Combination
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $CombinationSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.Combination with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.core.BaseChart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Combination>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.Combination.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Combination`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Combination` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Combination` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Combination`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Combination` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Combination` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Combination`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Combination` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Combination` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Combination`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Combination` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Combination` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Combination`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Combination` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Combination` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Combination`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Combination` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Combination` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Combination`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Combination` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Combination` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Combination`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Combination` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Combination` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Combination`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Combination` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Combination` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Combination`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Combination` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Combination` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the background in the aggregation {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyBackground(): this;
    /**
     * Destroys the dataLabel in the aggregation {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataLabel(): this;
    /**
     * Destroys the general in the aggregation {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGeneral(): this;
    /**
     * Destroys the interaction in the aggregation {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInteraction(): this;
    /**
     * Destroys the legend in the aggregation {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegend(): this;
    /**
     * Destroys the legendGroup in the aggregation {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegendGroup(): this;
    /**
     * Destroys the plotArea in the aggregation {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPlotArea(): this;
    /**
     * Destroys the title in the aggregation {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTitle(): this;
    /**
     * Destroys the toolTip in the aggregation {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolTip(): this;
    /**
     * Destroys the xAxis in the aggregation {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXAxis(): this;
    /**
     * Destroys the xyContainer in the aggregation {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXyContainer(): this;
    /**
     * Destroys the yAxis in the aggregation {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Combination`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeselectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Combination`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHideTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialized initialized} event of this `sap.viz.ui5.Combination`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialized(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectData selectData} event of this `sap.viz.ui5.Combination`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Combination`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShowTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:deselectData deselectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeselectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:hideTooltip hideTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHideTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:initialized initialized} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialized(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectData selectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:showTooltip showTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShowTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getBackground background}.
     *
     * Module sap.viz.modules.background
     */
    getBackground(): Background;
    /**
     * Gets content of aggregation {@link #getDataLabel dataLabel}.
     *
     * Module sap.viz.modules.datalabel
     */
    getDataLabel(): Datalabel;
    /**
     * Gets content of aggregation {@link #getGeneral general}.
     *
     * Module sap.viz.modules.rootContainer
     */
    getGeneral(): RootContainer;
    /**
     * Gets content of aggregation {@link #getInteraction interaction}.
     *
     * Module sap.viz.modules.controller.interaction
     */
    getInteraction(): Interaction;
    /**
     * Gets content of aggregation {@link #getLegend legend}.
     *
     * Module sap.viz.modules.legend.common
     */
    getLegend(): Common;
    /**
     * Gets content of aggregation {@link #getLegendGroup legendGroup}.
     *
     * Module sap.viz.modules.legend
     */
    getLegendGroup(): Legend;
    /**
     * Gets content of aggregation {@link #getPlotArea plotArea}.
     *
     * Module sap.viz.modules.combination
     */
    getPlotArea(): Combination1;
    /**
     * Gets content of aggregation {@link #getTitle title}.
     *
     * Module sap.viz.modules.title
     */
    getTitle(): Title;
    /**
     * Gets content of aggregation {@link #getToolTip toolTip}.
     *
     * Module sap.viz.chart.elements.Tooltip
     */
    getToolTip(): Tooltip;
    /**
     * Gets content of aggregation {@link #getXAxis xAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getXAxis(): Axis;
    /**
     * Gets content of aggregation {@link #getXyContainer xyContainer}.
     *
     * Module sap.viz.modules.xycontainer
     */
    getXyContainer(): XYContainer;
    /**
     * Gets content of aggregation {@link #getYAxis yAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis(): Axis;
    /**
     * Sets the aggregated {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackground(
      /**
       * The background to set
       */
      oBackground: Background
    ): this;
    /**
     * Sets the aggregated {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabel(
      /**
       * The dataLabel to set
       */
      oDataLabel: Datalabel
    ): this;
    /**
     * Sets the aggregated {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGeneral(
      /**
       * The general to set
       */
      oGeneral: RootContainer
    ): this;
    /**
     * Sets the aggregated {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInteraction(
      /**
       * The interaction to set
       */
      oInteraction: Interaction
    ): this;
    /**
     * Sets the aggregated {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegend(
      /**
       * The legend to set
       */
      oLegend: Common
    ): this;
    /**
     * Sets the aggregated {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendGroup(
      /**
       * The legendGroup to set
       */
      oLegendGroup: Legend
    ): this;
    /**
     * Sets the aggregated {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlotArea(
      /**
       * The plotArea to set
       */
      oPlotArea: Combination1
    ): this;
    /**
     * Sets the aggregated {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * The title to set
       */
      oTitle: Title
    ): this;
    /**
     * Sets the aggregated {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolTip(
      /**
       * The toolTip to set
       */
      oToolTip: Tooltip
    ): this;
    /**
     * Sets the aggregated {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxis(
      /**
       * The xAxis to set
       */
      oXAxis: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXyContainer(
      /**
       * The xyContainer to set
       */
      oXyContainer: XYContainer
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis(
      /**
       * The yAxis to set
       */
      oYAxis: Axis
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Combination constructor.
   *
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'combination'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export interface $CombinationSettings extends $BaseChartSettings {
    /**
     * Module sap.viz.modules.rootContainer
     */
    general?: RootContainer;

    /**
     * Module sap.viz.modules.controller.interaction
     */
    interaction?: Interaction;

    /**
     * Module sap.viz.modules.title
     */
    title?: Title;

    /**
     * Module sap.viz.modules.legend
     */
    legendGroup?: Legend;

    /**
     * Module sap.viz.modules.legend.common
     */
    legend?: Common;

    /**
     * Module sap.viz.chart.elements.Tooltip
     */
    toolTip?: Tooltip;

    /**
     * Module sap.viz.modules.xycontainer
     */
    xyContainer?: XYContainer;

    /**
     * Module sap.viz.modules.datalabel
     */
    dataLabel?: Datalabel;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis?: Axis;

    /**
     * Module sap.viz.modules.axis
     */
    xAxis?: Axis;

    /**
     * Module sap.viz.modules.background
     */
    background?: Background;

    /**
     * Module sap.viz.modules.combination
     */
    plotArea?: Combination1;

    /**
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     */
    selectData?: (oEvent: Event) => void;

    /**
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     */
    deselectData?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    showTooltip?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    hideTooltip?: (oEvent: Event) => void;

    /**
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     */
    initialized?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Combination#deselectData event.
   */
  export interface Combination$DeselectDataEventParameters {}

  /**
   * Event object of the Combination#deselectData event.
   */
  export type Combination$DeselectDataEvent = Event<
    Combination$DeselectDataEventParameters,
    Combination
  >;

  /**
   * Parameters of the Combination#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Combination$HideTooltipEventParameters {}

  /**
   * Event object of the Combination#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Combination$HideTooltipEvent = Event<
    Combination$HideTooltipEventParameters,
    Combination
  >;

  /**
   * Parameters of the Combination#initialized event.
   */
  export interface Combination$InitializedEventParameters {}

  /**
   * Event object of the Combination#initialized event.
   */
  export type Combination$InitializedEvent = Event<
    Combination$InitializedEventParameters,
    Combination
  >;

  /**
   * Parameters of the Combination#selectData event.
   */
  export interface Combination$SelectDataEventParameters {}

  /**
   * Event object of the Combination#selectData event.
   */
  export type Combination$SelectDataEvent = Event<
    Combination$SelectDataEventParameters,
    Combination
  >;

  /**
   * Parameters of the Combination#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Combination$ShowTooltipEventParameters {}

  /**
   * Event object of the Combination#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Combination$ShowTooltipEvent = Event<
    Combination$ShowTooltipEventParameters,
    Combination
  >;
}

declare module "sap/viz/ui5/controls/common/BaseControl" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { CSSSize } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * An abstract base class for all VIZ controls
   *
   * @since 1.22.0
   */
  export default class BaseControl extends Control {
    /**
     * Constructor for a new ui5/controls/common/BaseControl.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $BaseControlSettings
    );
    /**
     * Constructor for a new ui5/controls/common/BaseControl.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $BaseControlSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.controls.common.BaseControl with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, BaseControl>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.controls.common.BaseControl.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Height of the VizControl as a CSS size.
     *
     * Default value is `'480px'`.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getUiConfig uiConfig}.
     *
     * Configuration for initialization to VizControl. This property could only set via settings parameter in
     * Constructor.
     *
     *
     * @returns Value of property `uiConfig`
     */
    getUiConfig(): object;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Width of the VizControl as a CSS size.
     *
     * Default value is `'640px'`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * Height of the VizControl as a CSS size.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'480px'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getUiConfig uiConfig}.
     *
     * Configuration for initialization to VizControl. This property could only set via settings parameter in
     * Constructor.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUiConfig(
      /**
       * New value for property `uiConfig`
       */
      oUiConfig?: object
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Width of the VizControl as a CSS size.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'640px'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the BaseControl constructor.
   */
  export interface $BaseControlSettings extends $ControlSettings {
    /**
     * Configuration for initialization to VizControl. This property could only set via settings parameter in
     * Constructor.
     */
    uiConfig?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Width of the VizControl as a CSS size.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Height of the VizControl as a CSS size.
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/viz/ui5/controls/common/feeds/AnalysisObject" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * AnalysisObject Class
   *
   * @since 1.21.0
   */
  export default class AnalysisObject extends UI5Element {
    /**
     * Constructor for a new ui5/controls/common/feeds/AnalysisObject.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $AnalysisObjectSettings
    );
    /**
     * Constructor for a new ui5/controls/common/feeds/AnalysisObject.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $AnalysisObjectSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.controls.common.feeds.AnalysisObject with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, AnalysisObject>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.controls.common.feeds.AnalysisObject.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getDataType dataType}.
     *
     * Data type of an analysis object. Enumeration: string, number, date
     *
     *
     * @returns Value of property `dataType`
     */
    getDataType(): string;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * Name of an analysis object.
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * Type of an analysis object. Enumeration: Measure, Dimension
     *
     *
     * @returns Value of property `type`
     */
    getType(): string;
    /**
     * Gets current value of property {@link #getUid uid}.
     *
     * Uid of analysis object
     *
     *
     * @returns Value of property `uid`
     */
    getUid(): string;
    /**
     * Sets a new value for property {@link #getDataType dataType}.
     *
     * Data type of an analysis object. Enumeration: string, number, date
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataType(
      /**
       * New value for property `dataType`
       */
      sDataType?: string
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * Name of an analysis object.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * Type of an analysis object. Enumeration: Measure, Dimension
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: string
    ): this;
    /**
     * Sets a new value for property {@link #getUid uid}.
     *
     * Uid of analysis object
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUid(
      /**
       * New value for property `uid`
       */
      sUid?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the AnalysisObject constructor.
   */
  export interface $AnalysisObjectSettings extends $ElementSettings {
    /**
     * Uid of analysis object
     */
    uid?: string | PropertyBindingInfo;

    /**
     * Name of an analysis object.
     */
    name?: string | PropertyBindingInfo;

    /**
     * Type of an analysis object. Enumeration: Measure, Dimension
     */
    type?: string | PropertyBindingInfo;

    /**
     * Data type of an analysis object. Enumeration: string, number, date
     */
    dataType?: string | PropertyBindingInfo;
  }
}

declare module "sap/viz/ui5/controls/common/feeds/FeedItem" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * FeedItem Class
   *
   * @since 1.21.0
   */
  export default class FeedItem extends UI5Element {
    /**
     * Constructor for a new ui5/controls/common/feeds/FeedItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $FeedItemSettings
    );
    /**
     * Constructor for a new ui5/controls/common/feeds/FeedItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $FeedItemSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.controls.common.feeds.FeedItem with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FeedItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.controls.common.feeds.FeedItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * Type of a feed item. Enumeration: Measure, Dimension
     *
     *
     * @returns Value of property `type`
     */
    getType(): string;
    /**
     * Gets current value of property {@link #getUid uid}.
     *
     * Uid of a feed item. Please reference to bindings section in VIZDOCS to get the exact sUid string for
     * each chart type.
     *
     * For example: Bar chart > bindings > categoryAxis ; color ; valueAxis. The 'categoryAxis' should be the
     * sUid for x axis feeding for bar chart.
     *
     *
     * @returns Value of property `uid`
     */
    getUid(): string;
    /**
     * Gets current value of property {@link #getValues values}.
     *
     * Value of a feed item.
     *
     *
     * @returns Value of property `values`
     */
    getValues(): any[];
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * Type of a feed item. Enumeration: Measure, Dimension
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: string
    ): this;
    /**
     * Sets a new value for property {@link #getUid uid}.
     *
     * Uid of a feed item. Please reference to bindings section in VIZDOCS to get the exact sUid string for
     * each chart type.
     *
     * For example: Bar chart > bindings > categoryAxis ; color ; valueAxis. The 'categoryAxis' should be the
     * sUid for x axis feeding for bar chart.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUid(
      /**
       * New value for property `uid`
       */
      sUid?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValues values}.
     *
     * Value of a feed item.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValues(
      /**
       * New value for property `values`
       */
      sValues?: any[]
    ): this;
  }
  /**
   * Describes the settings that can be provided to the FeedItem constructor.
   */
  export interface $FeedItemSettings extends $ElementSettings {
    /**
     * Uid of a feed item. Please reference to bindings section in VIZDOCS to get the exact sUid string for
     * each chart type.
     *
     * For example: Bar chart > bindings > categoryAxis ; color ; valueAxis. The 'categoryAxis' should be the
     * sUid for x axis feeding for bar chart.
     */
    uid?: string | PropertyBindingInfo;

    /**
     * Type of a feed item. Enumeration: Measure, Dimension
     */
    type?: string | PropertyBindingInfo;

    /**
     * Value of a feed item.
     */
    values?: any[] | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/viz/ui5/controls/Popover" {
  import {
    default as BaseControl,
    $BaseControlSettings,
  } from "sap/viz/ui5/controls/common/BaseControl";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Viz Chart Popover
   *
   * @since 1.22.0
   * @experimental (since 1.22.0) - API is not finished yet and might change completely
   */
  export default class Popover extends BaseControl {
    /**
     * Constructor for a new ui5/controls/Popover.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $PopoverSettings
    );
    /**
     * Constructor for a new ui5/controls/Popover.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $PopoverSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.controls.Popover with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.controls.common.BaseControl.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Popover>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.controls.Popover.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Close Chart's Popover.
     */
    close(): void;
    /**
     * Connect chart Popover with VizFrame.
     *
     * Chart Popover is only supported for VizFrame with type 'fiori'. This method must be called by application.
     */
    connect(
      /**
       * Unique ID of the VizFrame to connect this Popover with
       */
      uid: string
    ): void;
    /**
     * Gets current value of property {@link #getActionItems actionItems}.
     *
     * The items of this list or rows of Action List in Home Page inside the Popover.
     *
     *
     * @returns Value of property `actionItems`
     */
    getActionItems(): object[];
    /**
     * Gets current value of property {@link #getCustomDataControl customDataControl}.
     *
     * A callback function let user customize Popover's content panel.
     *
     *
     * @returns Value of property `customDataControl`
     */
    getCustomDataControl(): any;
    /**
     * Gets current value of property {@link #getFormatString formatString}.
     *
     * The pattern is used to format the measures displayed in Popover. If value type of format string is String,
     * the format string will be used to format all measures. If value type is Object, each format string in
     * the Object will be used to format the specified measure or time dimension.
     *
     *
     * @returns Value of property `formatString`
     */
    getFormatString(): any;
    /**
     * Gets current value of property {@link #getShowLine showLine}.
     *
     * Show line with popover marker in line/combination charts.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showLine`
     */
    getShowLine(): boolean;
    /**
     * Sets a new value for property {@link #getActionItems actionItems}.
     *
     * The items of this list or rows of Action List in Home Page inside the Popover.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setActionItems(
      /**
       * New value for property `actionItems`
       */
      sActionItems?: object[]
    ): this;
    /**
     * Sets a new value for property {@link #getCustomDataControl customDataControl}.
     *
     * A callback function let user customize Popover's content panel.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCustomDataControl(
      /**
       * New value for property `customDataControl`
       */
      oCustomDataControl?: any
    ): this;
    /**
     * Sets a new value for property {@link #getFormatString formatString}.
     *
     * The pattern is used to format the measures displayed in Popover. If value type of format string is String,
     * the format string will be used to format all measures. If value type is Object, each format string in
     * the Object will be used to format the specified measure or time dimension.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFormatString(
      /**
       * New value for property `formatString`
       */
      oFormatString?: any
    ): this;
    /**
     * Sets a new value for property {@link #getShowLine showLine}.
     *
     * Show line with popover marker in line/combination charts.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowLine(
      /**
       * New value for property `showLine`
       */
      bShowLine?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Popover constructor.
   *
   * @experimental (since 1.22.0) - API is not finished yet and might change completely
   */
  export interface $PopoverSettings extends $BaseControlSettings {
    /**
     * A callback function let user customize Popover's content panel.
     */
    customDataControl?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * The items of this list or rows of Action List in Home Page inside the Popover.
     */
    actionItems?: object[] | PropertyBindingInfo | `{${string}}`;

    /**
     * The pattern is used to format the measures displayed in Popover. If value type of format string is String,
     * the format string will be used to format all measures. If value type is Object, each format string in
     * the Object will be used to format the specified measure or time dimension.
     */
    formatString?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Show line with popover marker in line/combination charts.
     */
    showLine?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/viz/ui5/controls/VizFrame" {
  import {
    default as BaseControl,
    $BaseControlSettings,
  } from "sap/viz/ui5/controls/common/BaseControl";

  import FeedItem from "sap/viz/ui5/controls/common/feeds/FeedItem";

  import Event from "sap/ui/base/Event";

  import Dataset from "sap/viz/ui5/data/Dataset";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * VizFrame is a viz control that manages a visualization’s initialization, layout, feeding, customization
   * and interactions.
   *
   * At the moment, the time series chart in VizFrame only accepts time inputs in UTC and system time, and
   * does not have the capability to switch timezones dynamically. Additionally, the week representation in
   * VizFrame adheres to the ISO week standard, and does not support other variations of week definitions.
   *
   * @since 1.22.0
   */
  export default class VizFrame extends BaseControl {
    /**
     * Constructor for a new ui5/controls/VizFrame. For more information on the available info chart types,
     * see the following documentation.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $VizFrameSettings
    );
    /**
     * Constructor for a new ui5/controls/VizFrame. For more information on the available info chart types,
     * see the following documentation.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $VizFrameSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.controls.VizFrame with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.controls.common.BaseControl.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, VizFrame>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.controls.VizFrame.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some feed to the aggregation {@link #getFeeds feeds}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addFeed(
      /**
       * The feed to add; if empty, nothing is inserted
       */
      oFeed: FeedItem
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.controls.VizFrame`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.controls.VizFrame` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.controls.VizFrame` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.controls.VizFrame`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.controls.VizFrame` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.controls.VizFrame` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:renderComplete renderComplete} event of this
     * `sap.viz.ui5.controls.VizFrame`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.controls.VizFrame` itself.
     *
     * Event fires when the rendering ends.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRenderComplete(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.controls.VizFrame` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:renderComplete renderComplete} event of this
     * `sap.viz.ui5.controls.VizFrame`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.controls.VizFrame` itself.
     *
     * Event fires when the rendering ends.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRenderComplete(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.controls.VizFrame` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.controls.VizFrame`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.controls.VizFrame` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.controls.VizFrame` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.controls.VizFrame`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.controls.VizFrame` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.controls.VizFrame` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the dataset in the aggregation {@link #getDataset dataset}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataset(): this;
    /**
     * Destroys all the feeds in the aggregation {@link #getFeeds feeds}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyFeeds(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.controls.VizFrame`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeselectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:renderComplete renderComplete} event of this
     * `sap.viz.ui5.controls.VizFrame`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachRenderComplete(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectData selectData} event of this `sap.viz.ui5.controls.VizFrame`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Exports the current viz as an SVG String.
     *
     * The viz is ready to be exported to SVG ONLY after the initialization is finished. Any attempt to export
     * to SVG before that will result in an empty SVG string.
     *
     *
     * @returns the SVG string of the current viz or empty SVG if error occurs.
     */
    exportToSVGString(
      /**
       * Options for the export
       */
      option?: {
        /**
         * the exported SVG will be scaled to the specific width
         */
        width?: int;
        /**
         * the exported SVG will be scaled to the specific height
         */
        height?: int;
        /**
         * flag to indicate if the exported SVG includes the original title and legend
         */
        hideTitleLegend?: boolean;
        /**
         * flag to indicate if the exported SVG includes the original axis
         */
        hideAxis?: boolean;
      }
    ): string;
    /**
     * Fires event {@link #event:deselectData deselectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeselectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:renderComplete renderComplete} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireRenderComplete(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectData selectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getDataset dataset}.
     *
     * Dataset for chart.
     */
    getDataset(): Dataset;
    /**
     * Gets content of aggregation {@link #getFeeds feeds}.
     *
     * All feeds for chart.
     */
    getFeeds(): FeedItem[];
    /**
     * Return current legend group visibility.
     *
     * @since 1.28
     *
     * @returns current legend group visibility
     */
    getLegendVisible(): boolean;
    /**
     * Get ResponsiveLegend Control. (For fiori application set only. It has been deprecated since 1.28.)
     *
     * @deprecated (since 1.28) - This API has been deprecated. This interface will be removed from the SAPUI5
     * delivery in one of the next releases.
     */
    getResponsiveLegend(): void;
    /**
     * Gets current value of property {@link #getVizCustomizations vizCustomizations}.
     *
     * Chart customizations property, aim to customize existing (build-in) charts to meet specific LoB requirements.
     * Currently, supported chart type : column, dual_column, bar, dual_bar, stacked_column, stacked_bar, 100_stacked_bar,
     * 100_stacked_column, 100_dual_stacked_bar, 100_dual_stacked_column, dual_stacked_bar, dual_stacked_column,
     * line, horizontal_line, dual_line, dual_horizontal_line, combination, horizontal_combination, stacked_combination,
     * horizontal_stacked_combination, dual_stacked_combination, dual_horizontal_stacked_combination, scatter,
     * bubble.
     *
     *
     * @returns Value of property `vizCustomizations`
     */
    getVizCustomizations(): object;
    /**
     * Gets current value of property {@link #getVizProperties vizProperties}.
     *
     * Chart properties, refer to chart property doc for more details.
     *
     *
     * @returns Value of property `vizProperties`
     */
    getVizProperties(): object;
    /**
     * Gets current value of property {@link #getVizScales vizScales}.
     *
     * Chart scales, refer to chart property doc for more details.
     *
     * @since 1.25
     *
     * @returns Value of property `vizScales`
     */
    getVizScales(): object;
    /**
     * Gets current value of property {@link #getVizType vizType}.
     *
     * Type for viz frame. User can pass 'chartType' or 'info/chartType'. For example both 'bar' and 'info/bar'
     * will create a info bar chart. Supported chart type: column, dual_column, bar, dual_bar, stacked_bar,
     * stacked_column, line, dual_line, combination, bullet, time_bullet, bubble, time_bubble, pie, donut, timeseries_column,
     * timeseries_line, timeseries_scatter, timeseries_bubble, timeseries_stacked_column, timeseries_100_stacked_column,
     * timeseries_bullet, timeseries_waterfall, timeseries_stacked_combination scatter, vertical_bullet, dual_stacked_bar,
     * 100_stacked_bar, 100_dual_stacked_bar, dual_stacked_column, 100_stacked_column, 100_dual_stacked_column,
     * stacked_combination, horizontal_stacked_combination, dual_stacked_combination, dual_horizontal_stacked_combination,
     * heatmap, treemap, waterfall, horizontal_waterfall, area, radar
     *
     * Default value is `"column"`.
     *
     *
     * @returns Value of property `vizType`
     */
    getVizType(): string;
    /**
     * Uid for this viz frame. It supports other controls to connect to a viz instance.
     *
     *
     * @returns Uid of this viz frame
     */
    getVizUid(): string;
    /**
     * Checks for the provided `sap.viz.ui5.controls.common.feeds.FeedItem` in the aggregation {@link #getFeeds feeds}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfFeed(
      /**
       * The feed whose index is looked for
       */
      oFeed: FeedItem
    ): int;
    /**
     * Inserts a feed into the aggregation {@link #getFeeds feeds}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertFeed(
      /**
       * The feed to insert; if empty, nothing is inserted
       */
      oFeed: FeedItem,
      /**
       * The `0`-based index the feed should be inserted at; for a negative value of `iIndex`, the feed is inserted
       * at position 0; for a value greater than the current size of the aggregation, the feed is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getFeeds feeds}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllFeeds(): FeedItem[];
    /**
     * Removes a feed from the aggregation {@link #getFeeds feeds}.
     *
     *
     * @returns The removed feed or `null`
     */
    removeFeed(
      /**
       * The feed to remove or its index or id
       */
      vFeed: int | string | FeedItem
    ): FeedItem | null;
    /**
     * Set whether to enable overlay or not. If the value is true, the chart will be blocked with a transparent
     * overlay.
     */
    setBlocked(
      /**
       * New value for whether to enable visibility of overlay.
       */
      bBlocked?: boolean
    ): void;
    /**
     * Sets the aggregated {@link #getDataset dataset}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataset(
      /**
       * The dataset to set
       */
      oDataset: Dataset
    ): this;
    /**
     * Will respect the setting for all available legends.
     *
     * @since 1.28
     */
    setLegendVisible(
      /**
       * Set legend visibility.
       */
      visibility: boolean
    ): this;
    /**
     * Setter for property uiConfig. uiConfig could only set via settings parameter of constructor.
     *
     * uiConfig from base type could config the instance. Supported uiConfig keyword: applicationSet, showErrorMessage
     */
    setUiConfig(oUiConfig: object): this;
    /**
     * Properties for viz frame.
     */
    setVizProperties(oVizProperties: object): this;
    /**
     * Scales for VizFrame.
     */
    setVizScales(
      oVizScales: object,

      oVizScalesOption?: {
        /**
         * replace scales or not. When oVizScalesOption.replace is true, replace existing scales with the input
         * scales.
         */
        replace?: boolean;
      }
    ): this;
    /**
     * Setter for property vizType. vizType could only set via settings parameter in Constructor. Do not set
     * vizType at runtime.
     *
     * vizType is a string of supported chart type or extension chart type.
     *
     * Supported chart types: bubble, combination, column, bar, line, stacked_bar, stacked_column, bullet, vertical_bullet,
     * timebubble. User can pass 'chartType' or 'info/chartType' for these supported chart types.
     *
     * Example:
     * ```javascript
     *
     * // VizFrame required from "sap/viz/ui5/controls/VizFrame"
     * var vizFrame = new VizFrame({
     *  'vizType' : 'bar'
     * });
     * ```
     *
     *
     * For extension chart type, user should load extension js file manually at first.
     *
     * Example:
     * ```javascript
     *
     * // VizFrame required from "sap/viz/ui5/controls/VizFrame"
     * var vizFrame = new VizFrame({
     *  'vizType' : 'myextension'
     * });
     * ```
     */
    setVizType(sVizType: string): this;
    /**
     * Selections for viz frame.
     */
    vizSelection(
      /**
       * some data points of the chart
       */
      aPoints: object[],
      /**
       * whether to clear previous selection, by default the selection will be incremental selection
       */
      oAction: object
    ): this;
    /**
     * Update viz frame according to a JSON object, it can update css, properties, feeds and data model.
     *
     * VizFrame instance has to be placed at its corresponding parent at first to make this API work.
     */
    vizUpdate(
      /**
       * a JSON object contains combination of properties, feeds and data model.
       */
      oOptions: object
    ): void;
    /**
     * Zoom the chart plot.
     */
    zoom(
      /**
       * contains a "direction" attribute with value "in" or "out" indicating zoom to enlarge or shrink respectively
       */
      cfg: object
    ): void;
  }
  /**
   * Describes the settings that can be provided to the VizFrame constructor.
   */
  export interface $VizFrameSettings extends $BaseControlSettings {
    /**
     * Type for viz frame. User can pass 'chartType' or 'info/chartType'. For example both 'bar' and 'info/bar'
     * will create a info bar chart. Supported chart type: column, dual_column, bar, dual_bar, stacked_bar,
     * stacked_column, line, dual_line, combination, bullet, time_bullet, bubble, time_bubble, pie, donut, timeseries_column,
     * timeseries_line, timeseries_scatter, timeseries_bubble, timeseries_stacked_column, timeseries_100_stacked_column,
     * timeseries_bullet, timeseries_waterfall, timeseries_stacked_combination scatter, vertical_bullet, dual_stacked_bar,
     * 100_stacked_bar, 100_dual_stacked_bar, dual_stacked_column, 100_stacked_column, 100_dual_stacked_column,
     * stacked_combination, horizontal_stacked_combination, dual_stacked_combination, dual_horizontal_stacked_combination,
     * heatmap, treemap, waterfall, horizontal_waterfall, area, radar
     */
    vizType?: string | PropertyBindingInfo;

    /**
     * Chart properties, refer to chart property doc for more details.
     */
    vizProperties?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Chart scales, refer to chart property doc for more details.
     *
     * @since 1.25
     */
    vizScales?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Chart customizations property, aim to customize existing (build-in) charts to meet specific LoB requirements.
     * Currently, supported chart type : column, dual_column, bar, dual_bar, stacked_column, stacked_bar, 100_stacked_bar,
     * 100_stacked_column, 100_dual_stacked_bar, 100_dual_stacked_column, dual_stacked_bar, dual_stacked_column,
     * line, horizontal_line, dual_line, dual_horizontal_line, combination, horizontal_combination, stacked_combination,
     * horizontal_stacked_combination, dual_stacked_combination, dual_horizontal_stacked_combination, scatter,
     * bubble.
     */
    vizCustomizations?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Set chart's legend properties.
     */
    legendVisible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Dataset for chart.
     */
    dataset?: Dataset;

    /**
     * All feeds for chart.
     */
    feeds?: FeedItem[] | FeedItem | AggregationBindingInfo | `{${string}}`;

    /**
     * Event fires when the rendering ends.
     */
    renderComplete?: (oEvent: Event) => void;

    /**
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in.
     */
    selectData?: (oEvent: Event) => void;

    /**
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in
     */
    deselectData?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the VizFrame#deselectData event.
   */
  export interface VizFrame$DeselectDataEventParameters {}

  /**
   * Event object of the VizFrame#deselectData event.
   */
  export type VizFrame$DeselectDataEvent = Event<
    VizFrame$DeselectDataEventParameters,
    VizFrame
  >;

  /**
   * Parameters of the VizFrame#renderComplete event.
   */
  export interface VizFrame$RenderCompleteEventParameters {}

  /**
   * Event object of the VizFrame#renderComplete event.
   */
  export type VizFrame$RenderCompleteEvent = Event<
    VizFrame$RenderCompleteEventParameters,
    VizFrame
  >;

  /**
   * Parameters of the VizFrame#selectData event.
   */
  export interface VizFrame$SelectDataEventParameters {}

  /**
   * Event object of the VizFrame#selectData event.
   */
  export type VizFrame$SelectDataEvent = Event<
    VizFrame$SelectDataEventParameters,
    VizFrame
  >;
}

declare module "sap/viz/ui5/controls/VizSlider" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import FeedItem from "sap/viz/ui5/controls/common/feeds/FeedItem";

  import Event from "sap/ui/base/Event";

  import Dataset from "sap/viz/ui5/data/Dataset";

  import { CSSSize } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * VizSlider is a viz control with range slider that provide data range selection.
   *
   * @since 1.51.0
   */
  export default class VizSlider extends Control {
    /**
     * Constructor for a new ui5/controls/VizSider.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $VizSliderSettings
    );
    /**
     * Constructor for a new ui5/controls/VizSider.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $VizSliderSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.controls.VizSlider with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, VizSlider>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.controls.VizSlider.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some feed to the aggregation {@link #getFeeds feeds}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addFeed(
      /**
       * The feed to add; if empty, nothing is inserted
       */
      oFeed: FeedItem
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:rangeChanged rangeChanged} event of this `sap.viz.ui5.controls.VizSlider`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.controls.VizSlider` itself.
     *
     * Event fires when selected range changes. Data structure For Time chart: { start: {Date: 1422181498387},
     * end: {Date: 1422049107429} }. For column and line Chart: { "data":[{"Country":"Canada"}, {"Country":"China"},{"Country":"France"},
     * {"Country":"Germany"},{"Country":"India"}] }.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRangeChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.controls.VizSlider` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:rangeChanged rangeChanged} event of this `sap.viz.ui5.controls.VizSlider`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.controls.VizSlider` itself.
     *
     * Event fires when selected range changes. Data structure For Time chart: { start: {Date: 1422181498387},
     * end: {Date: 1422049107429} }. For column and line Chart: { "data":[{"Country":"Canada"}, {"Country":"China"},{"Country":"France"},
     * {"Country":"Germany"},{"Country":"India"}] }.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRangeChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.controls.VizSlider` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the dataset in the aggregation {@link #getDataset dataset}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataset(): this;
    /**
     * Destroys all the feeds in the aggregation {@link #getFeeds feeds}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyFeeds(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:rangeChanged rangeChanged} event of this `sap.viz.ui5.controls.VizSlider`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachRangeChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:rangeChanged rangeChanged} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireRangeChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getDataset dataset}.
     *
     * Dataset for VizSlider.
     */
    getDataset(): Dataset;
    /**
     * Gets content of aggregation {@link #getFeeds feeds}.
     *
     * All feeds for VizSlider.
     */
    getFeeds(): FeedItem[];
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Height of the VizControl as a CSS size.
     *
     * Default value is `'200px'`.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Get start end date of range slider. Supported chart type: timeseries_column, timeseries_line.
     *
     *
     * @returns range : {start : timestamp, end : timestamp}
     */
    getRange(): object;
    /**
     * Gets current value of property {@link #getShowPercentageLabel showPercentageLabel}.
     *
     * Set percentage label of range slider visible or not
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showPercentageLabel`
     */
    getShowPercentageLabel(): boolean;
    /**
     * Gets current value of property {@link #getShowStartEndLabel showStartEndLabel}.
     *
     * Set start end label of range slider visible or not
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showStartEndLabel`
     */
    getShowStartEndLabel(): boolean;
    /**
     * Gets current value of property {@link #getUiConfig uiConfig}.
     *
     * Configuration for initialization to VizControl. This property could only set via settings parameter in
     * Constructor.
     *
     *
     * @returns Value of property `uiConfig`
     */
    getUiConfig(): object;
    /**
     * Gets current value of property {@link #getValueAxisVisible valueAxisVisible}.
     *
     * Set valueAxis visible or not
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `valueAxisVisible`
     */
    getValueAxisVisible(): boolean;
    /**
     * Gets current value of property {@link #getVizType vizType}.
     *
     * Type of chart. User can pass 'chartType' or 'info/chartType'. For example both 'bar' and 'info/bar' will
     * create a info bar chart. Supported chart type: column, line, timeseries_column, timeseries_line
     *
     * Default value is `"column"`.
     *
     *
     * @returns Value of property `vizType`
     */
    getVizType(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Width of the VizControl as a CSS size.
     *
     * Default value is `'800px'`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.viz.ui5.controls.common.feeds.FeedItem` in the aggregation {@link #getFeeds feeds}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfFeed(
      /**
       * The feed whose index is looked for
       */
      oFeed: FeedItem
    ): int;
    /**
     * Inserts a feed into the aggregation {@link #getFeeds feeds}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertFeed(
      /**
       * The feed to insert; if empty, nothing is inserted
       */
      oFeed: FeedItem,
      /**
       * The `0`-based index the feed should be inserted at; for a negative value of `iIndex`, the feed is inserted
       * at position 0; for a value greater than the current size of the aggregation, the feed is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getFeeds feeds}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllFeeds(): FeedItem[];
    /**
     * Removes a feed from the aggregation {@link #getFeeds feeds}.
     *
     *
     * @returns The removed feed or `null`
     */
    removeFeed(
      /**
       * The feed to remove or its index or id
       */
      vFeed: int | string | FeedItem
    ): FeedItem | null;
    /**
     * Sets the aggregated {@link #getDataset dataset}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataset(
      /**
       * The dataset to set
       */
      oDataset: Dataset
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * Height of the VizControl as a CSS size.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'200px'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Set start end date of range slider. Supported chart type: timeseries_column, timeseries_line.
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    setRange(
      /**
       * {start : timestamp, end : timestamp}
       */
      range: object
    ): this;
    /**
     * Sets a new value for property {@link #getShowPercentageLabel showPercentageLabel}.
     *
     * Set percentage label of range slider visible or not
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowPercentageLabel(
      /**
       * New value for property `showPercentageLabel`
       */
      bShowPercentageLabel?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowStartEndLabel showStartEndLabel}.
     *
     * Set start end label of range slider visible or not
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowStartEndLabel(
      /**
       * New value for property `showStartEndLabel`
       */
      bShowStartEndLabel?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getUiConfig uiConfig}.
     *
     * Configuration for initialization to VizControl. This property could only set via settings parameter in
     * Constructor.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUiConfig(
      /**
       * New value for property `uiConfig`
       */
      oUiConfig?: object
    ): this;
    /**
     * Sets a new value for property {@link #getValueAxisVisible valueAxisVisible}.
     *
     * Set valueAxis visible or not
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueAxisVisible(
      /**
       * New value for property `valueAxisVisible`
       */
      bValueAxisVisible?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getVizType vizType}.
     *
     * Type of chart. User can pass 'chartType' or 'info/chartType'. For example both 'bar' and 'info/bar' will
     * create a info bar chart. Supported chart type: column, line, timeseries_column, timeseries_line
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"column"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVizType(
      /**
       * New value for property `vizType`
       */
      sVizType?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Width of the VizControl as a CSS size.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'800px'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the VizSlider constructor.
   */
  export interface $VizSliderSettings extends $ControlSettings {
    /**
     * Type of chart. User can pass 'chartType' or 'info/chartType'. For example both 'bar' and 'info/bar' will
     * create a info bar chart. Supported chart type: column, line, timeseries_column, timeseries_line
     */
    vizType?: string | PropertyBindingInfo;

    /**
     * Configuration for initialization to VizControl. This property could only set via settings parameter in
     * Constructor.
     */
    uiConfig?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Width of the VizControl as a CSS size.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Height of the VizControl as a CSS size.
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Set valueAxis visible or not
     */
    valueAxisVisible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Set percentage label of range slider visible or not
     */
    showPercentageLabel?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Set start end label of range slider visible or not
     */
    showStartEndLabel?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Set start end date of range slider. Supported chart type: timeseries_column, timeseries_line
     */
    range?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Dataset for VizSlider.
     */
    dataset?: Dataset;

    /**
     * All feeds for VizSlider.
     */
    feeds?: FeedItem[] | FeedItem | AggregationBindingInfo | `{${string}}`;

    /**
     * Event fires when selected range changes. Data structure For Time chart: { start: {Date: 1422181498387},
     * end: {Date: 1422049107429} }. For column and line Chart: { "data":[{"Country":"Canada"}, {"Country":"China"},{"Country":"France"},
     * {"Country":"Germany"},{"Country":"India"}] }.
     */
    rangeChanged?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the VizSlider#rangeChanged event.
   */
  export interface VizSlider$RangeChangedEventParameters {}

  /**
   * Event object of the VizSlider#rangeChanged event.
   */
  export type VizSlider$RangeChangedEvent = Event<
    VizSlider$RangeChangedEventParameters,
    VizSlider
  >;
}

declare module "sap/viz/ui5/controls/VizTooltip" {
  import {
    default as BaseControl,
    $BaseControlSettings,
  } from "sap/viz/ui5/controls/common/BaseControl";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Viz Chart Tooltip
   *
   * @since 1.44.0
   */
  export default class VizTooltip extends BaseControl {
    /**
     * Constructor for a new ui5/controls/VizTooltip.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $VizTooltipSettings
    );
    /**
     * Constructor for a new ui5/controls/VizTooltip.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $VizTooltipSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.controls.VizTooltip with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.controls.common.BaseControl.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, VizTooltip>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.controls.VizTooltip.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Connect chart Tooltip with VizFrame. Chart Tooltip is only supported for VizFrame with 'fiori' type.
     * It must be called by application.
     */
    connect(uid: string): void;
    /**
     * Gets current value of property {@link #getFormatString formatString}.
     *
     * The pattern is used to format the measures/timeDimensions displayed in Tooltip. If value type of format
     * string is String or an object with 'formatPattern' and 'dataUnit' values defined, the value will be used
     * to format all measures(not works with TimeDimension). The value of ‘formatPattern’ here is a string to
     * define the format pattern of numbers, and value of ‘dataUnit’ is a postfix string to indicate the unit
     * of measure. If value type is Object whose key is measure/timeDimension name, the possible value type
     * is string or an object with ‘formatPattern’ and ‘dataUnit’ values defined. And each string value will
     * be used to format the specified measure or time dimension. And TimeDimension does not support 'dataUnit'.
     *
     *
     * @returns Value of property `formatString`
     */
    getFormatString(): any;
    /**
     * Sets a new value for property {@link #getFormatString formatString}.
     *
     * The pattern is used to format the measures/timeDimensions displayed in Tooltip. If value type of format
     * string is String or an object with 'formatPattern' and 'dataUnit' values defined, the value will be used
     * to format all measures(not works with TimeDimension). The value of ‘formatPattern’ here is a string to
     * define the format pattern of numbers, and value of ‘dataUnit’ is a postfix string to indicate the unit
     * of measure. If value type is Object whose key is measure/timeDimension name, the possible value type
     * is string or an object with ‘formatPattern’ and ‘dataUnit’ values defined. And each string value will
     * be used to format the specified measure or time dimension. And TimeDimension does not support 'dataUnit'.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFormatString(
      /**
       * New value for property `formatString`
       */
      oFormatString?: any
    ): this;
  }
  /**
   * Describes the settings that can be provided to the VizTooltip constructor.
   */
  export interface $VizTooltipSettings extends $BaseControlSettings {
    /**
     * The pattern is used to format the measures/timeDimensions displayed in Tooltip. If value type of format
     * string is String or an object with 'formatPattern' and 'dataUnit' values defined, the value will be used
     * to format all measures(not works with TimeDimension). The value of ‘formatPattern’ here is a string to
     * define the format pattern of numbers, and value of ‘dataUnit’ is a postfix string to indicate the unit
     * of measure. If value type is Object whose key is measure/timeDimension name, the possible value type
     * is string or an object with ‘formatPattern’ and ‘dataUnit’ values defined. And each string value will
     * be used to format the specified measure or time dimension. And TimeDimension does not support 'dataUnit'.
     */
    formatString?: any | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/viz/ui5/core/BaseChart" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Dataset from "sap/viz/ui5/data/Dataset";

  import { CSSSize } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * An abstract base class for all VIZ charts
   *
   * @since 1.7.2
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
   * control to benefit from new charting enhancements and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely
   */
  export default class BaseChart extends Control {
    /**
     * Constructor for a new ui5/core/BaseChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $BaseChartSettings
    );
    /**
     * Constructor for a new ui5/core/BaseChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $BaseChartSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.core.BaseChart with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, BaseChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.core.BaseChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeCreateViz beforeCreateViz} event of this
     * `sap.viz.ui5.core.BaseChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.core.BaseChart` itself.
     *
     * Fired before a new VIZ instance is created. Event parameter "usrOptions" contains the intended value
     * for the parameter with the same name of the createViz call.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeCreateViz(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: BaseChart$BeforeCreateVizEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.core.BaseChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeCreateViz beforeCreateViz} event of this
     * `sap.viz.ui5.core.BaseChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.core.BaseChart` itself.
     *
     * Fired before a new VIZ instance is created. Event parameter "usrOptions" contains the intended value
     * for the parameter with the same name of the createViz call.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeCreateViz(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: BaseChart$BeforeCreateVizEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.core.BaseChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the dataset in the aggregation {@link #getDataset dataset}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataset(): this;
    /**
     * Destroys the noData in the aggregation {@link #getNoData noData}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyNoData(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:beforeCreateViz beforeCreateViz} event of
     * this `sap.viz.ui5.core.BaseChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachBeforeCreateViz(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: BaseChart$BeforeCreateVizEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:beforeCreateViz beforeCreateViz} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireBeforeCreateViz(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: BaseChart$BeforeCreateVizEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getCss css}.
     *
     * CSS style of Chart.
     *
     *
     * @returns Value of property `css`
     */
    getCss(): string;
    /**
     * Gets content of aggregation {@link #getDataset dataset}.
     *
     * Dataset for this chart
     */
    getDataset(): Dataset;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Height of the Chart as a CSS size.
     *
     * Default value is `'480px'`.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets content of aggregation {@link #getNoData noData}.
     *
     * Control tree to display when there is no data available
     */
    getNoData(): Control;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Width of the Chart as a CSS size.
     *
     * Default value is `'640px'`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Sets a new value for property {@link #getCss css}.
     *
     * CSS style of Chart.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCss(
      /**
       * New value for property `css`
       */
      sCss?: string
    ): this;
    /**
     * Sets the aggregated {@link #getDataset dataset}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataset(
      /**
       * The dataset to set
       */
      oDataset: Dataset
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * Height of the Chart as a CSS size.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'480px'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Sets the aggregated {@link #getNoData noData}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNoData(
      /**
       * The noData to set
       */
      oNoData: Control
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Width of the Chart as a CSS size.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'640px'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the BaseChart constructor.
   *
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
   * control to benefit from new charting enhancements and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely
   */
  export interface $BaseChartSettings extends $ControlSettings {
    /**
     * Width of the Chart as a CSS size.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Height of the Chart as a CSS size.
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * CSS style of Chart.
     */
    css?: string | PropertyBindingInfo;

    /**
     * Dataset for this chart
     */
    dataset?: Dataset;

    /**
     * Control tree to display when there is no data available
     */
    noData?: Control;

    /**
     * Fired before a new VIZ instance is created. Event parameter "usrOptions" contains the intended value
     * for the parameter with the same name of the createViz call.
     */
    beforeCreateViz?: (oEvent: BaseChart$BeforeCreateVizEvent) => void;
  }

  /**
   * Parameters of the BaseChart#beforeCreateViz event.
   */
  export interface BaseChart$BeforeCreateVizEventParameters {
    /**
     * Value for the parameter with the same name of the createViz call.
     */
    usrOptions?: object;
  }

  /**
   * Event object of the BaseChart#beforeCreateViz event.
   */
  export type BaseChart$BeforeCreateVizEvent = Event<
    BaseChart$BeforeCreateVizEventParameters,
    BaseChart
  >;
}

declare module "sap/viz/ui5/core/BaseStructuredType" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * Abstract base class for all elements that represent VIZ modules or complex property types
   *
   * @since 1.7.2
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
   * control to benefit from new charting enhancements and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely
   */
  export default class BaseStructuredType extends UI5Element {
    /**
     * Constructor for a new ui5/core/BaseStructuredType.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.core.Element#constructor sap.ui.core.Element }
     * can be used.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $BaseStructuredTypeSettings
    );
    /**
     * Constructor for a new ui5/core/BaseStructuredType.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.core.Element#constructor sap.ui.core.Element }
     * can be used.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $BaseStructuredTypeSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.core.BaseStructuredType with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, BaseStructuredType>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.core.BaseStructuredType.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
  }
  /**
   * Describes the settings that can be provided to the BaseStructuredType constructor.
   *
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame }
   * control to benefit from new charting enhancements and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely
   */
  export interface $BaseStructuredTypeSettings extends $ElementSettings {}
}

declare module "sap/viz/ui5/data/CustomDataset" {
  import {
    default as Dataset,
    $DatasetSettings,
  } from "sap/viz/ui5/data/Dataset";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * A dataset for raw data format.
   *
   * @since 1.31
   */
  export default class CustomDataset extends Dataset {
    /**
     * Constructor for a new ui5/data/CustomDataset.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $CustomDatasetSettings
    );
    /**
     * Constructor for a new ui5/data/CustomDataset.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $CustomDatasetSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.data.CustomDataset with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.data.Dataset.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, CustomDataset>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.data.CustomDataset.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getData data}.
     *
     * Data containing dimensions and measures. The format and structure of this data is depends on the chart.
     *
     *
     * @returns Value of property `data`
     */
    getData(): object;
    /**
     * Sets a new value for property {@link #getData data}.
     *
     * Data containing dimensions and measures. The format and structure of this data is depends on the chart.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setData(
      /**
       * New value for property `data`
       */
      oData: object
    ): this;
  }
  /**
   * Describes the settings that can be provided to the CustomDataset constructor.
   */
  export interface $CustomDatasetSettings extends $DatasetSettings {
    /**
     * Data containing dimensions and measures. The format and structure of this data is depends on the chart.
     */
    data?: object | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/viz/ui5/data/Dataset" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * Abstract Dataset implementation
   *
   * @since 1.7.2
   */
  export default class Dataset extends UI5Element {
    /**
     * Constructor for a new ui5/data/Dataset.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.core.Element#constructor sap.ui.core.Element }
     * can be used.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $DatasetSettings
    );
    /**
     * Constructor for a new ui5/data/Dataset.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.core.Element#constructor sap.ui.core.Element }
     * can be used.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $DatasetSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.data.Dataset with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Dataset>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.data.Dataset.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
  }
  /**
   * Describes the settings that can be provided to the Dataset constructor.
   */
  export interface $DatasetSettings extends $ElementSettings {}
}

declare module "sap/viz/ui5/data/DimensionDefinition" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Definition of a single dimension in a dataset
   *
   * @since 1.7.2
   */
  export default class DimensionDefinition extends UI5Element {
    /**
     * Constructor for a new ui5/data/DimensionDefinition.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $DimensionDefinitionSettings
    );
    /**
     * Constructor for a new ui5/data/DimensionDefinition.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $DimensionDefinitionSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.data.DimensionDefinition with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DimensionDefinition>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.data.DimensionDefinition.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getAxis axis}.
     *
     * Number of axis this dimension belongs to. Currently must be 1 or 2. Skip this property when use VizFrame.
     *
     *
     * @returns Value of property `axis`
     */
    getAxis(): int;
    /**
     * Gets current value of property {@link #getDataType dataType}.
     *
     * Data type of the dimension as displayed in the chart. Enumeration: string, number, date. Currently only
     * in time series chart, it is required to set data type to 'date' if this column is going to be fed on
     * 'timeAxis'.
     *
     *
     * @returns Value of property `dataType`
     */
    getDataType(): string;
    /**
     * Gets current value of property {@link #getDisplayValue displayValue}.
     *
     * Display value for the dimension. Usually bound to some model field. It doesn't work with 'waterfallType'
     *
     *
     * @returns Value of property `displayValue`
     */
    getDisplayValue(): any;
    /**
     * Gets current value of property {@link #getIdentity identity}.
     *
     * Id of the dimension as displayed in the chart
     *
     *
     * @returns Value of property `identity`
     */
    getIdentity(): string;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * Name of the dimension as displayed in the chart
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getSorter sorter}.
     *
     * `Sorter` Object of the dimension. There is a default comparator function, if no custom comparator is
     * given. The function returns -1, 0 or 1, depending on the order of the two items and is suitable to be
     * used as a comparator method for Array.sort. The object contains two entries:
     * 	 - `bDescending:`{boolean} (optional) define whether the sort order is descending. Default is false.
     *
     * 	 - `fnComparator:`{function} (optional) a user defined comparator function, which have two input values
     *     to compare. The input value is an object, which contains value and displayValue (optional).
     *
     *
     * @returns Value of property `sorter`
     */
    getSorter(): object;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * Value for the dimension. Usually bound to some model field.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): any;
    /**
     * Sets a new value for property {@link #getAxis axis}.
     *
     * Number of axis this dimension belongs to. Currently must be 1 or 2. Skip this property when use VizFrame.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAxis(
      /**
       * New value for property `axis`
       */
      iAxis?: int
    ): this;
    /**
     * Sets a new value for property {@link #getDataType dataType}.
     *
     * Data type of the dimension as displayed in the chart. Enumeration: string, number, date. Currently only
     * in time series chart, it is required to set data type to 'date' if this column is going to be fed on
     * 'timeAxis'.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataType(
      /**
       * New value for property `dataType`
       */
      sDataType?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayValue displayValue}.
     *
     * Display value for the dimension. Usually bound to some model field. It doesn't work with 'waterfallType'
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayValue(
      /**
       * New value for property `displayValue`
       */
      oDisplayValue?: any
    ): this;
    /**
     * Sets a new value for property {@link #getIdentity identity}.
     *
     * Id of the dimension as displayed in the chart
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIdentity(
      /**
       * New value for property `identity`
       */
      sIdentity?: string
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * Name of the dimension as displayed in the chart
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSorter sorter}.
     *
     * `Sorter` Object of the dimension. There is a default comparator function, if no custom comparator is
     * given. The function returns -1, 0 or 1, depending on the order of the two items and is suitable to be
     * used as a comparator method for Array.sort. The object contains two entries:
     * 	 - `bDescending:`{boolean} (optional) define whether the sort order is descending. Default is false.
     *
     * 	 - `fnComparator:`{function} (optional) a user defined comparator function, which have two input values
     *     to compare. The input value is an object, which contains value and displayValue (optional).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSorter(
      /**
       * New value for property `sorter`
       */
      oSorter?: object
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * Value for the dimension. Usually bound to some model field.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      oValue?: any
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DimensionDefinition constructor.
   */
  export interface $DimensionDefinitionSettings extends $ElementSettings {
    /**
     * Number of axis this dimension belongs to. Currently must be 1 or 2. Skip this property when use VizFrame.
     */
    axis?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Value for the dimension. Usually bound to some model field.
     */
    value?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Name of the dimension as displayed in the chart
     */
    name?: string | PropertyBindingInfo;

    /**
     * Id of the dimension as displayed in the chart
     */
    identity?: string | PropertyBindingInfo;

    /**
     * Display value for the dimension. Usually bound to some model field. It doesn't work with 'waterfallType'
     */
    displayValue?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Data type of the dimension as displayed in the chart. Enumeration: string, number, date. Currently only
     * in time series chart, it is required to set data type to 'date' if this column is going to be fed on
     * 'timeAxis'.
     */
    dataType?: string | PropertyBindingInfo;

    /**
     * `Sorter` Object of the dimension. There is a default comparator function, if no custom comparator is
     * given. The function returns -1, 0 or 1, depending on the order of the two items and is suitable to be
     * used as a comparator method for Array.sort. The object contains two entries:
     * 	 - `bDescending:`{boolean} (optional) define whether the sort order is descending. Default is false.
     *
     * 	 - `fnComparator:`{function} (optional) a user defined comparator function, which have two input values
     *     to compare. The input value is an object, which contains value and displayValue (optional).
     */
    sorter?: object | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/viz/ui5/data/FlattenedDataset" {
  import {
    default as Dataset,
    $DatasetSettings,
  } from "sap/viz/ui5/data/Dataset";

  import UI5Element from "sap/ui/core/Element";

  import DimensionDefinition from "sap/viz/ui5/data/DimensionDefinition";

  import MeasureDefinition from "sap/viz/ui5/data/MeasureDefinition";

  import Event from "sap/ui/base/Event";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Context from "sap/ui/model/Context";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * A dataset for flattened (redundant) data using a tabular format.
   *
   * @since 1.7.2
   */
  export default class FlattenedDataset extends Dataset {
    /**
     * Constructor for a new ui5/data/FlattenedDataset.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $FlattenedDatasetSettings
    );
    /**
     * Constructor for a new ui5/data/FlattenedDataset.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $FlattenedDatasetSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.data.FlattenedDataset with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.data.Dataset.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FlattenedDataset>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.data.FlattenedDataset.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some data to the aggregation {@link #getData data}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addData(
      /**
       * The data to add; if empty, nothing is inserted
       */
      oData: UI5Element
    ): this;
    /**
     * Adds some dimension to the aggregation {@link #getDimensions dimensions}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addDimension(
      /**
       * The dimension to add; if empty, nothing is inserted
       */
      oDimension: DimensionDefinition
    ): this;
    /**
     * Adds some measure to the aggregation {@link #getMeasures measures}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addMeasure(
      /**
       * The measure to add; if empty, nothing is inserted
       */
      oMeasure: MeasureDefinition
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:dataChange dataChange} event of this `sap.viz.ui5.data.FlattenedDataset`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.data.FlattenedDataset` itself.
     *
     * data change event
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDataChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.data.FlattenedDataset` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:dataChange dataChange} event of this `sap.viz.ui5.data.FlattenedDataset`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.data.FlattenedDataset` itself.
     *
     * data change event
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDataChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.data.FlattenedDataset` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:dataError dataError} event of this `sap.viz.ui5.data.FlattenedDataset`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.data.FlattenedDataset` itself.
     *
     * data error event
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDataError(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.data.FlattenedDataset` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:dataError dataError} event of this `sap.viz.ui5.data.FlattenedDataset`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.data.FlattenedDataset` itself.
     *
     * data error event
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDataError(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.data.FlattenedDataset` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:dataRefresh dataRefresh} event of this `sap.viz.ui5.data.FlattenedDataset`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.data.FlattenedDataset` itself.
     *
     * data refresh event
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDataRefresh(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.data.FlattenedDataset` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:dataRefresh dataRefresh} event of this `sap.viz.ui5.data.FlattenedDataset`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.data.FlattenedDataset` itself.
     *
     * data refresh event
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDataRefresh(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.data.FlattenedDataset` itself
       */
      oListener?: object
    ): this;
    /**
     * Binds aggregation {@link #getData data} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindData(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys all the data in the aggregation {@link #getData data}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyData(): this;
    /**
     * Destroys all the dimensions in the aggregation {@link #getDimensions dimensions}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDimensions(): this;
    /**
     * Destroys all the measures in the aggregation {@link #getMeasures measures}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyMeasures(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:dataChange dataChange} event of this `sap.viz.ui5.data.FlattenedDataset`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDataChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:dataError dataError} event of this `sap.viz.ui5.data.FlattenedDataset`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDataError(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:dataRefresh dataRefresh} event of this `sap.viz.ui5.data.FlattenedDataset`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDataRefresh(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Find the model context for a given 'criteria' into chart data.
     *
     * The native sap.viz library provides data objects with the `selectData` event. Applications can call this
     * method for each data in a selectData event to find the corresponding UI5 model context.
     *
     * When the dataset has not been converted into a VIZ dataset yet (e.g. no rendering yet) or when the coordinates
     * of the path are not within the range of the current dataset, then undefined will be returned.
     *
     * Example when use sap.viz.ui5.*:
     * ```javascript
     *
     * selectData: function(oEvent) {
     *   var aSelectData = oEvent.getParameter("data");
     *   var oContext = this.getDataset().findContext(aSelectData[0].data[0].ctx.path);
     * }
     * ```
     *  Example when use sap.viz.ui5.controls.VizFrame:
     * ```javascript
     *
     * selectData: function(oEvent) {
     *   var aSelectData = oEvent.getParameter("data");
     *   var oContext = this.getDataset().findContext(aSelectData[0].data);
     * }
     * ```
     *
     *
     * @experimental (since 1.16.6) - Might later be integrated into the selectData event.
     *
     * @returns the model context for the given criteria or undefined.
     */
    findContext(
      /**
       * a structure as provided by the sap.viz library
       */
      oCriteria: object
    ): Context;
    /**
     * Fires event {@link #event:dataChange dataChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDataChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:dataError dataError} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDataError(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:dataRefresh dataRefresh} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDataRefresh(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getContext context}.
     *
     * Additional data which works with data context in this dataset. The input could be an array. Each item
     * represents a dimension that is added as the additional information based on data context. The input could
     * be a string of dimension id, or object like this {id: "name", showInTooltip: true}. If showInTooltip
     * is false, the dimensions set in this API will not show in popover or tooltip. However other dimensions
     * in data context will show. In selection event, all dimension information (including the dimension set
     * in this API) will be included. Context will be shown by default in tooltip if only set context with string
     * or string of array.
     *
     *
     * @returns Value of property `context`
     */
    getContext(): any;
    /**
     * Gets content of aggregation {@link #getData data}.
     *
     * Data containing dimensions and measures.
     *
     * **Note:** This aggregation can only be bound against a model, it cannot be managed programmatically using
     * the aggregation mutator methods like addData.
     */
    getData(): UI5Element[];
    /**
     * Gets content of aggregation {@link #getDimensions dimensions}.
     *
     * List of definitions of all dimensions in this dataset
     */
    getDimensions(): DimensionDefinition[];
    /**
     * Gets content of aggregation {@link #getMeasures measures}.
     *
     * list of definitions of all measures in this dataset
     */
    getMeasures(): MeasureDefinition[];
    /**
     * Checks for the provided `sap.ui.core.Element` in the aggregation {@link #getData data}. and returns its
     * index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfData(
      /**
       * The data whose index is looked for
       */
      oData: UI5Element
    ): int;
    /**
     * Checks for the provided `sap.viz.ui5.data.DimensionDefinition` in the aggregation {@link #getDimensions dimensions}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfDimension(
      /**
       * The dimension whose index is looked for
       */
      oDimension: DimensionDefinition
    ): int;
    /**
     * Checks for the provided `sap.viz.ui5.data.MeasureDefinition` in the aggregation {@link #getMeasures measures}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfMeasure(
      /**
       * The measure whose index is looked for
       */
      oMeasure: MeasureDefinition
    ): int;
    /**
     * Inserts a data into the aggregation {@link #getData data}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertData(
      /**
       * The data to insert; if empty, nothing is inserted
       */
      oData: UI5Element,
      /**
       * The `0`-based index the data should be inserted at; for a negative value of `iIndex`, the data is inserted
       * at position 0; for a value greater than the current size of the aggregation, the data is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a dimension into the aggregation {@link #getDimensions dimensions}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertDimension(
      /**
       * The dimension to insert; if empty, nothing is inserted
       */
      oDimension: DimensionDefinition,
      /**
       * The `0`-based index the dimension should be inserted at; for a negative value of `iIndex`, the dimension
       * is inserted at position 0; for a value greater than the current size of the aggregation, the dimension
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a measure into the aggregation {@link #getMeasures measures}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertMeasure(
      /**
       * The measure to insert; if empty, nothing is inserted
       */
      oMeasure: MeasureDefinition,
      /**
       * The `0`-based index the measure should be inserted at; for a negative value of `iIndex`, the measure
       * is inserted at position 0; for a value greater than the current size of the aggregation, the measure
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getData data}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllData(): UI5Element[];
    /**
     * Removes all the controls from the aggregation {@link #getDimensions dimensions}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllDimensions(): DimensionDefinition[];
    /**
     * Removes all the controls from the aggregation {@link #getMeasures measures}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllMeasures(): MeasureDefinition[];
    /**
     * Removes a data from the aggregation {@link #getData data}.
     *
     *
     * @returns The removed data or `null`
     */
    removeData(
      /**
       * The data to remove or its index or id
       */
      vData: int | string | UI5Element
    ): UI5Element | null;
    /**
     * Removes a dimension from the aggregation {@link #getDimensions dimensions}.
     *
     *
     * @returns The removed dimension or `null`
     */
    removeDimension(
      /**
       * The dimension to remove or its index or id
       */
      vDimension: int | string | DimensionDefinition
    ): DimensionDefinition | null;
    /**
     * Removes a measure from the aggregation {@link #getMeasures measures}.
     *
     *
     * @returns The removed measure or `null`
     */
    removeMeasure(
      /**
       * The measure to remove or its index or id
       */
      vMeasure: int | string | MeasureDefinition
    ): MeasureDefinition | null;
    /**
     * Sets a new value for property {@link #getContext context}.
     *
     * Additional data which works with data context in this dataset. The input could be an array. Each item
     * represents a dimension that is added as the additional information based on data context. The input could
     * be a string of dimension id, or object like this {id: "name", showInTooltip: true}. If showInTooltip
     * is false, the dimensions set in this API will not show in popover or tooltip. However other dimensions
     * in data context will show. In selection event, all dimension information (including the dimension set
     * in this API) will be included. Context will be shown by default in tooltip if only set context with string
     * or string of array.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContext(
      /**
       * New value for property `context`
       */
      oContext: any
    ): this;
    /**
     * Set chart's default selection. This api will do nothing when use VizFrame.
     *
     * @deprecated (since 1.19) - Please use selection API {@link sap.viz.ui5.core.BaseChart.prototype.selection}.
     */
    setDefaultSelection(
      /**
       * Array of default selection info
       */
      selectionInfos: object[]
    ): void;
    /**
     * Unbinds aggregation {@link #getData data} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindData(): this;
  }
  /**
   * Describes the settings that can be provided to the FlattenedDataset constructor.
   */
  export interface $FlattenedDatasetSettings extends $DatasetSettings {
    /**
     * Additional data which works with data context in this dataset. The input could be an array. Each item
     * represents a dimension that is added as the additional information based on data context. The input could
     * be a string of dimension id, or object like this {id: "name", showInTooltip: true}. If showInTooltip
     * is false, the dimensions set in this API will not show in popover or tooltip. However other dimensions
     * in data context will show. In selection event, all dimension information (including the dimension set
     * in this API) will be included. Context will be shown by default in tooltip if only set context with string
     * or string of array.
     */
    context?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * List of definitions of all dimensions in this dataset
     */
    dimensions?:
      | DimensionDefinition[]
      | DimensionDefinition
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * list of definitions of all measures in this dataset
     */
    measures?:
      | MeasureDefinition[]
      | MeasureDefinition
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Data containing dimensions and measures.
     *
     * **Note:** This aggregation can only be bound against a model, it cannot be managed programmatically using
     * the aggregation mutator methods like addData.
     */
    data?: UI5Element[] | UI5Element | AggregationBindingInfo | `{${string}}`;

    /**
     * data change event
     */
    dataChange?: (oEvent: Event) => void;

    /**
     * data refresh event
     */
    dataRefresh?: (oEvent: Event) => void;

    /**
     * data error event
     */
    dataError?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the FlattenedDataset#dataChange event.
   */
  export interface FlattenedDataset$DataChangeEventParameters {}

  /**
   * Event object of the FlattenedDataset#dataChange event.
   */
  export type FlattenedDataset$DataChangeEvent = Event<
    FlattenedDataset$DataChangeEventParameters,
    FlattenedDataset
  >;

  /**
   * Parameters of the FlattenedDataset#dataError event.
   */
  export interface FlattenedDataset$DataErrorEventParameters {}

  /**
   * Event object of the FlattenedDataset#dataError event.
   */
  export type FlattenedDataset$DataErrorEvent = Event<
    FlattenedDataset$DataErrorEventParameters,
    FlattenedDataset
  >;

  /**
   * Parameters of the FlattenedDataset#dataRefresh event.
   */
  export interface FlattenedDataset$DataRefreshEventParameters {}

  /**
   * Event object of the FlattenedDataset#dataRefresh event.
   */
  export type FlattenedDataset$DataRefreshEvent = Event<
    FlattenedDataset$DataRefreshEventParameters,
    FlattenedDataset
  >;
}

declare module "sap/viz/ui5/data/MeasureDefinition" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Definition of a single Measure
   *
   * @since 1.7.2
   */
  export default class MeasureDefinition extends UI5Element {
    /**
     * Constructor for a new ui5/data/MeasureDefinition.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $MeasureDefinitionSettings
    );
    /**
     * Constructor for a new ui5/data/MeasureDefinition.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $MeasureDefinitionSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.data.MeasureDefinition with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, MeasureDefinition>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.data.MeasureDefinition.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getFormat format}.
     *
     * Format pattern for values of the measure
     *
     *
     * @returns Value of property `format`
     */
    getFormat(): any;
    /**
     * Gets current value of property {@link #getGroup group}.
     *
     * Measure group this measure belongs to. Order is significant, number should start from 1. Skip this property
     * when use VizFrame.
     *
     * Default value is `1`.
     *
     *
     * @returns Value of property `group`
     */
    getGroup(): int;
    /**
     * Gets current value of property {@link #getIdentity identity}.
     *
     * Id of the measure as displayed in the chart
     *
     *
     * @returns Value of property `identity`
     */
    getIdentity(): string;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * Name of the measure as displayed in the chart
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getRange range}.
     *
     * Value range
     *
     * Default value is `[]`.
     *
     *
     * @returns Value of property `range`
     */
    getRange(): any[];
    /**
     * Gets current value of property {@link #getUnit unit}.
     *
     * Unit of measure
     *
     *
     * @returns Value of property `unit`
     */
    getUnit(): string;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * Value for the measure. Usually bound to some model field.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): any;
    /**
     * Sets a new value for property {@link #getFormat format}.
     *
     * Format pattern for values of the measure
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFormat(
      /**
       * New value for property `format`
       */
      oFormat?: any
    ): this;
    /**
     * Sets a new value for property {@link #getGroup group}.
     *
     * Measure group this measure belongs to. Order is significant, number should start from 1. Skip this property
     * when use VizFrame.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGroup(
      /**
       * New value for property `group`
       */
      iGroup?: int
    ): this;
    /**
     * Sets a new value for property {@link #getIdentity identity}.
     *
     * Id of the measure as displayed in the chart
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIdentity(
      /**
       * New value for property `identity`
       */
      sIdentity?: string
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * Name of the measure as displayed in the chart
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getRange range}.
     *
     * Value range
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRange(
      /**
       * New value for property `range`
       */
      sRange?: any[]
    ): this;
    /**
     * Sets a new value for property {@link #getUnit unit}.
     *
     * Unit of measure
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUnit(
      /**
       * New value for property `unit`
       */
      sUnit?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * Value for the measure. Usually bound to some model field.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      oValue?: any
    ): this;
  }
  /**
   * Describes the settings that can be provided to the MeasureDefinition constructor.
   */
  export interface $MeasureDefinitionSettings extends $ElementSettings {
    /**
     * Measure group this measure belongs to. Order is significant, number should start from 1. Skip this property
     * when use VizFrame.
     */
    group?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Value for the measure. Usually bound to some model field.
     */
    value?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Name of the measure as displayed in the chart
     */
    name?: string | PropertyBindingInfo;

    /**
     * Id of the measure as displayed in the chart
     */
    identity?: string | PropertyBindingInfo;

    /**
     * Format pattern for values of the measure
     */
    format?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Value range
     */
    range?: any[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Unit of measure
     */
    unit?: string | PropertyBindingInfo;
  }
}

declare module "sap/viz/ui5/Donut" {
  import {
    default as BaseChart,
    $BaseChartSettings,
  } from "sap/viz/ui5/core/BaseChart";

  import Event from "sap/ui/base/Event";

  import Datalabel from "sap/viz/ui5/types/Datalabel";

  import Datatransform from "sap/viz/ui5/types/Datatransform";

  import RootContainer from "sap/viz/ui5/types/RootContainer";

  import Interaction from "sap/viz/ui5/types/controller/Interaction";

  import Common from "sap/viz/ui5/types/legend/Common";

  import Legend from "sap/viz/ui5/types/Legend";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Pie from "sap/viz/ui5/types/Pie";

  import Title from "sap/viz/ui5/types/Title";

  import Tooltip from "sap/viz/ui5/types/Tooltip";

  import XYContainer from "sap/viz/ui5/types/XYContainer";

  /**
   * Chart sap.viz.ui5.Donut
   *
   * @since 1.7.2
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'donut'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export default class Donut extends BaseChart {
    /**
     * Constructor for a new sap.viz.ui5.Donut
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $DonutSettings
    );
    /**
     * Constructor for a new sap.viz.ui5.Donut
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $DonutSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.Donut with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.core.BaseChart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Donut>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.Donut.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Donut`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Donut` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Donut` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Donut`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Donut` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Donut` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Donut`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Donut` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Donut` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Donut`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Donut` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Donut` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Donut`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Donut` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Donut` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Donut`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Donut` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Donut` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Donut`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Donut` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Donut` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Donut`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Donut` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Donut` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Donut`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Donut` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Donut` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Donut`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Donut` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Donut` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the dataLabel in the aggregation {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataLabel(): this;
    /**
     * Destroys the dataTransform in the aggregation {@link #getDataTransform dataTransform}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataTransform(): this;
    /**
     * Destroys the general in the aggregation {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGeneral(): this;
    /**
     * Destroys the interaction in the aggregation {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInteraction(): this;
    /**
     * Destroys the legend in the aggregation {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegend(): this;
    /**
     * Destroys the legendGroup in the aggregation {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegendGroup(): this;
    /**
     * Destroys the plotArea in the aggregation {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPlotArea(): this;
    /**
     * Destroys the title in the aggregation {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTitle(): this;
    /**
     * Destroys the toolTip in the aggregation {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolTip(): this;
    /**
     * Destroys the xyContainer in the aggregation {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXyContainer(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Donut`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeselectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Donut`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHideTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialized initialized} event of this `sap.viz.ui5.Donut`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialized(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectData selectData} event of this `sap.viz.ui5.Donut`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Donut`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShowTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:deselectData deselectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeselectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:hideTooltip hideTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHideTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:initialized initialized} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialized(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectData selectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:showTooltip showTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShowTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getDataLabel dataLabel}.
     *
     * Module sap.viz.modules.datalabel
     */
    getDataLabel(): Datalabel;
    /**
     * Gets content of aggregation {@link #getDataTransform dataTransform}.
     *
     * Module sap.viz.modules.datatransform
     */
    getDataTransform(): Datatransform;
    /**
     * Gets content of aggregation {@link #getGeneral general}.
     *
     * Module sap.viz.modules.rootContainer
     */
    getGeneral(): RootContainer;
    /**
     * Gets content of aggregation {@link #getInteraction interaction}.
     *
     * Module sap.viz.modules.controller.interaction
     */
    getInteraction(): Interaction;
    /**
     * Gets content of aggregation {@link #getLegend legend}.
     *
     * Module sap.viz.modules.legend.common
     */
    getLegend(): Common;
    /**
     * Gets content of aggregation {@link #getLegendGroup legendGroup}.
     *
     * Module sap.viz.modules.legend
     */
    getLegendGroup(): Legend;
    /**
     * Gets content of aggregation {@link #getPlotArea plotArea}.
     *
     * Module sap.viz.modules.pie
     */
    getPlotArea(): Pie;
    /**
     * Gets content of aggregation {@link #getTitle title}.
     *
     * Module sap.viz.modules.title
     */
    getTitle(): Title;
    /**
     * Gets content of aggregation {@link #getToolTip toolTip}.
     *
     * Module sap.viz.chart.elements.Tooltip
     */
    getToolTip(): Tooltip;
    /**
     * Gets content of aggregation {@link #getXyContainer xyContainer}.
     *
     * Module sap.viz.modules.xycontainer
     */
    getXyContainer(): XYContainer;
    /**
     * Sets the aggregated {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabel(
      /**
       * The dataLabel to set
       */
      oDataLabel: Datalabel
    ): this;
    /**
     * Sets the aggregated {@link #getDataTransform dataTransform}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataTransform(
      /**
       * The dataTransform to set
       */
      oDataTransform: Datatransform
    ): this;
    /**
     * Sets the aggregated {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGeneral(
      /**
       * The general to set
       */
      oGeneral: RootContainer
    ): this;
    /**
     * Sets the aggregated {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInteraction(
      /**
       * The interaction to set
       */
      oInteraction: Interaction
    ): this;
    /**
     * Sets the aggregated {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegend(
      /**
       * The legend to set
       */
      oLegend: Common
    ): this;
    /**
     * Sets the aggregated {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendGroup(
      /**
       * The legendGroup to set
       */
      oLegendGroup: Legend
    ): this;
    /**
     * Sets the aggregated {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlotArea(
      /**
       * The plotArea to set
       */
      oPlotArea: Pie
    ): this;
    /**
     * Sets the aggregated {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * The title to set
       */
      oTitle: Title
    ): this;
    /**
     * Sets the aggregated {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolTip(
      /**
       * The toolTip to set
       */
      oToolTip: Tooltip
    ): this;
    /**
     * Sets the aggregated {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXyContainer(
      /**
       * The xyContainer to set
       */
      oXyContainer: XYContainer
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Donut constructor.
   *
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'donut'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export interface $DonutSettings extends $BaseChartSettings {
    /**
     * Module sap.viz.modules.rootContainer
     */
    general?: RootContainer;

    /**
     * Module sap.viz.modules.title
     */
    title?: Title;

    /**
     * Module sap.viz.modules.legend
     */
    legendGroup?: Legend;

    /**
     * Module sap.viz.modules.legend.common
     */
    legend?: Common;

    /**
     * Module sap.viz.modules.xycontainer
     */
    xyContainer?: XYContainer;

    /**
     * Module sap.viz.modules.pie
     */
    plotArea?: Pie;

    /**
     * Module sap.viz.modules.datalabel
     */
    dataLabel?: Datalabel;

    /**
     * Module sap.viz.modules.controller.interaction
     */
    interaction?: Interaction;

    /**
     * Module sap.viz.chart.elements.Tooltip
     */
    toolTip?: Tooltip;

    /**
     * Module sap.viz.modules.datatransform
     */
    dataTransform?: Datatransform;

    /**
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     */
    selectData?: (oEvent: Event) => void;

    /**
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     */
    deselectData?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    showTooltip?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    hideTooltip?: (oEvent: Event) => void;

    /**
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     */
    initialized?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Donut#deselectData event.
   */
  export interface Donut$DeselectDataEventParameters {}

  /**
   * Event object of the Donut#deselectData event.
   */
  export type Donut$DeselectDataEvent = Event<
    Donut$DeselectDataEventParameters,
    Donut
  >;

  /**
   * Parameters of the Donut#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Donut$HideTooltipEventParameters {}

  /**
   * Event object of the Donut#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Donut$HideTooltipEvent = Event<
    Donut$HideTooltipEventParameters,
    Donut
  >;

  /**
   * Parameters of the Donut#initialized event.
   */
  export interface Donut$InitializedEventParameters {}

  /**
   * Event object of the Donut#initialized event.
   */
  export type Donut$InitializedEvent = Event<
    Donut$InitializedEventParameters,
    Donut
  >;

  /**
   * Parameters of the Donut#selectData event.
   */
  export interface Donut$SelectDataEventParameters {}

  /**
   * Event object of the Donut#selectData event.
   */
  export type Donut$SelectDataEvent = Event<
    Donut$SelectDataEventParameters,
    Donut
  >;

  /**
   * Parameters of the Donut#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Donut$ShowTooltipEventParameters {}

  /**
   * Event object of the Donut#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Donut$ShowTooltipEvent = Event<
    Donut$ShowTooltipEventParameters,
    Donut
  >;
}

declare module "sap/viz/ui5/DualBar" {
  import {
    default as BaseChart,
    $BaseChartSettings,
  } from "sap/viz/ui5/core/BaseChart";

  import Event from "sap/ui/base/Event";

  import Background from "sap/viz/ui5/types/Background";

  import Datalabel from "sap/viz/ui5/types/Datalabel";

  import RootContainer from "sap/viz/ui5/types/RootContainer";

  import Interaction from "sap/viz/ui5/types/controller/Interaction";

  import Common from "sap/viz/ui5/types/legend/Common";

  import Legend from "sap/viz/ui5/types/Legend";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Bar from "sap/viz/ui5/types/Bar";

  import Title from "sap/viz/ui5/types/Title";

  import Tooltip from "sap/viz/ui5/types/Tooltip";

  import Axis from "sap/viz/ui5/types/Axis";

  import XYContainer from "sap/viz/ui5/types/XYContainer";

  /**
   * Chart sap.viz.ui5.DualBar
   *
   * @since 1.7.2
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'dual_bar'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export default class DualBar extends BaseChart {
    /**
     * Constructor for a new sap.viz.ui5.DualBar
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $DualBarSettings
    );
    /**
     * Constructor for a new sap.viz.ui5.DualBar
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $DualBarSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.DualBar with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.core.BaseChart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DualBar>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.DualBar.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.DualBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualBar` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.DualBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualBar` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.DualBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualBar` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.DualBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualBar` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.DualBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualBar` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.DualBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualBar` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.DualBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualBar` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.DualBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualBar` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.DualBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualBar` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.DualBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualBar` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the background in the aggregation {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyBackground(): this;
    /**
     * Destroys the dataLabel in the aggregation {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataLabel(): this;
    /**
     * Destroys the general in the aggregation {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGeneral(): this;
    /**
     * Destroys the interaction in the aggregation {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInteraction(): this;
    /**
     * Destroys the legend in the aggregation {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegend(): this;
    /**
     * Destroys the legendGroup in the aggregation {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegendGroup(): this;
    /**
     * Destroys the plotArea in the aggregation {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPlotArea(): this;
    /**
     * Destroys the title in the aggregation {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTitle(): this;
    /**
     * Destroys the toolTip in the aggregation {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolTip(): this;
    /**
     * Destroys the xAxis in the aggregation {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXAxis(): this;
    /**
     * Destroys the xAxis2 in the aggregation {@link #getXAxis2 xAxis2}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXAxis2(): this;
    /**
     * Destroys the xyContainer in the aggregation {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXyContainer(): this;
    /**
     * Destroys the yAxis in the aggregation {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.DualBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeselectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.DualBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHideTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialized initialized} event of this `sap.viz.ui5.DualBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialized(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectData selectData} event of this `sap.viz.ui5.DualBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.DualBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShowTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:deselectData deselectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeselectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:hideTooltip hideTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHideTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:initialized initialized} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialized(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectData selectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:showTooltip showTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShowTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getBackground background}.
     *
     * Module sap.viz.modules.background
     */
    getBackground(): Background;
    /**
     * Gets content of aggregation {@link #getDataLabel dataLabel}.
     *
     * Module sap.viz.modules.datalabel
     */
    getDataLabel(): Datalabel;
    /**
     * Gets content of aggregation {@link #getGeneral general}.
     *
     * Module sap.viz.modules.rootContainer
     */
    getGeneral(): RootContainer;
    /**
     * Gets content of aggregation {@link #getInteraction interaction}.
     *
     * Module sap.viz.modules.controller.interaction
     */
    getInteraction(): Interaction;
    /**
     * Gets content of aggregation {@link #getLegend legend}.
     *
     * Module sap.viz.modules.legend.common
     */
    getLegend(): Common;
    /**
     * Gets content of aggregation {@link #getLegendGroup legendGroup}.
     *
     * Module sap.viz.modules.legend
     */
    getLegendGroup(): Legend;
    /**
     * Gets content of aggregation {@link #getPlotArea plotArea}.
     *
     * Module sap.viz.modules.bar
     */
    getPlotArea(): Bar;
    /**
     * Gets content of aggregation {@link #getTitle title}.
     *
     * Module sap.viz.modules.title
     */
    getTitle(): Title;
    /**
     * Gets content of aggregation {@link #getToolTip toolTip}.
     *
     * Module sap.viz.chart.elements.Tooltip
     */
    getToolTip(): Tooltip;
    /**
     * Gets content of aggregation {@link #getXAxis xAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getXAxis(): Axis;
    /**
     * Gets content of aggregation {@link #getXAxis2 xAxis2}.
     *
     * Module sap.viz.modules.axis
     */
    getXAxis2(): Axis;
    /**
     * Gets content of aggregation {@link #getXyContainer xyContainer}.
     *
     * Module sap.viz.modules.xycontainer
     */
    getXyContainer(): XYContainer;
    /**
     * Gets content of aggregation {@link #getYAxis yAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis(): Axis;
    /**
     * Sets the aggregated {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackground(
      /**
       * The background to set
       */
      oBackground: Background
    ): this;
    /**
     * Sets the aggregated {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabel(
      /**
       * The dataLabel to set
       */
      oDataLabel: Datalabel
    ): this;
    /**
     * Sets the aggregated {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGeneral(
      /**
       * The general to set
       */
      oGeneral: RootContainer
    ): this;
    /**
     * Sets the aggregated {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInteraction(
      /**
       * The interaction to set
       */
      oInteraction: Interaction
    ): this;
    /**
     * Sets the aggregated {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegend(
      /**
       * The legend to set
       */
      oLegend: Common
    ): this;
    /**
     * Sets the aggregated {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendGroup(
      /**
       * The legendGroup to set
       */
      oLegendGroup: Legend
    ): this;
    /**
     * Sets the aggregated {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlotArea(
      /**
       * The plotArea to set
       */
      oPlotArea: Bar
    ): this;
    /**
     * Sets the aggregated {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * The title to set
       */
      oTitle: Title
    ): this;
    /**
     * Sets the aggregated {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolTip(
      /**
       * The toolTip to set
       */
      oToolTip: Tooltip
    ): this;
    /**
     * Sets the aggregated {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxis(
      /**
       * The xAxis to set
       */
      oXAxis: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getXAxis2 xAxis2}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxis2(
      /**
       * The xAxis2 to set
       */
      oXAxis2: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXyContainer(
      /**
       * The xyContainer to set
       */
      oXyContainer: XYContainer
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis(
      /**
       * The yAxis to set
       */
      oYAxis: Axis
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DualBar constructor.
   *
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'dual_bar'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export interface $DualBarSettings extends $BaseChartSettings {
    /**
     * Module sap.viz.modules.rootContainer
     */
    general?: RootContainer;

    /**
     * Module sap.viz.modules.controller.interaction
     */
    interaction?: Interaction;

    /**
     * Module sap.viz.modules.title
     */
    title?: Title;

    /**
     * Module sap.viz.modules.legend
     */
    legendGroup?: Legend;

    /**
     * Module sap.viz.modules.legend.common
     */
    legend?: Common;

    /**
     * Module sap.viz.chart.elements.Tooltip
     */
    toolTip?: Tooltip;

    /**
     * Module sap.viz.modules.xycontainer
     */
    xyContainer?: XYContainer;

    /**
     * Module sap.viz.modules.datalabel
     */
    dataLabel?: Datalabel;

    /**
     * Module sap.viz.modules.axis
     */
    xAxis?: Axis;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis?: Axis;

    /**
     * Module sap.viz.modules.background
     */
    background?: Background;

    /**
     * Module sap.viz.modules.bar
     */
    plotArea?: Bar;

    /**
     * Module sap.viz.modules.axis
     */
    xAxis2?: Axis;

    /**
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     */
    selectData?: (oEvent: Event) => void;

    /**
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     */
    deselectData?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    showTooltip?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    hideTooltip?: (oEvent: Event) => void;

    /**
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     */
    initialized?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the DualBar#deselectData event.
   */
  export interface DualBar$DeselectDataEventParameters {}

  /**
   * Event object of the DualBar#deselectData event.
   */
  export type DualBar$DeselectDataEvent = Event<
    DualBar$DeselectDataEventParameters,
    DualBar
  >;

  /**
   * Parameters of the DualBar#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface DualBar$HideTooltipEventParameters {}

  /**
   * Event object of the DualBar#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type DualBar$HideTooltipEvent = Event<
    DualBar$HideTooltipEventParameters,
    DualBar
  >;

  /**
   * Parameters of the DualBar#initialized event.
   */
  export interface DualBar$InitializedEventParameters {}

  /**
   * Event object of the DualBar#initialized event.
   */
  export type DualBar$InitializedEvent = Event<
    DualBar$InitializedEventParameters,
    DualBar
  >;

  /**
   * Parameters of the DualBar#selectData event.
   */
  export interface DualBar$SelectDataEventParameters {}

  /**
   * Event object of the DualBar#selectData event.
   */
  export type DualBar$SelectDataEvent = Event<
    DualBar$SelectDataEventParameters,
    DualBar
  >;

  /**
   * Parameters of the DualBar#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface DualBar$ShowTooltipEventParameters {}

  /**
   * Event object of the DualBar#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type DualBar$ShowTooltipEvent = Event<
    DualBar$ShowTooltipEventParameters,
    DualBar
  >;
}

declare module "sap/viz/ui5/DualColumn" {
  import {
    default as BaseChart,
    $BaseChartSettings,
  } from "sap/viz/ui5/core/BaseChart";

  import Event from "sap/ui/base/Event";

  import Background from "sap/viz/ui5/types/Background";

  import Datalabel from "sap/viz/ui5/types/Datalabel";

  import RootContainer from "sap/viz/ui5/types/RootContainer";

  import Interaction from "sap/viz/ui5/types/controller/Interaction";

  import Common from "sap/viz/ui5/types/legend/Common";

  import Legend from "sap/viz/ui5/types/Legend";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import VerticalBar from "sap/viz/ui5/types/VerticalBar";

  import Title from "sap/viz/ui5/types/Title";

  import Tooltip from "sap/viz/ui5/types/Tooltip";

  import Axis from "sap/viz/ui5/types/Axis";

  import XYContainer from "sap/viz/ui5/types/XYContainer";

  /**
   * Chart sap.viz.ui5.DualColumn
   *
   * @since 1.7.2
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'dual_column'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export default class DualColumn extends BaseChart {
    /**
     * Constructor for a new sap.viz.ui5.DualColumn
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $DualColumnSettings
    );
    /**
     * Constructor for a new sap.viz.ui5.DualColumn
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $DualColumnSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.DualColumn with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.core.BaseChart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DualColumn>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.DualColumn.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.DualColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualColumn` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.DualColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualColumn` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.DualColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualColumn` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.DualColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualColumn` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.DualColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualColumn` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.DualColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualColumn` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.DualColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualColumn` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.DualColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualColumn` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.DualColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualColumn` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.DualColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualColumn` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the background in the aggregation {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyBackground(): this;
    /**
     * Destroys the dataLabel in the aggregation {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataLabel(): this;
    /**
     * Destroys the general in the aggregation {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGeneral(): this;
    /**
     * Destroys the interaction in the aggregation {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInteraction(): this;
    /**
     * Destroys the legend in the aggregation {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegend(): this;
    /**
     * Destroys the legendGroup in the aggregation {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegendGroup(): this;
    /**
     * Destroys the plotArea in the aggregation {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPlotArea(): this;
    /**
     * Destroys the title in the aggregation {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTitle(): this;
    /**
     * Destroys the toolTip in the aggregation {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolTip(): this;
    /**
     * Destroys the xAxis in the aggregation {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXAxis(): this;
    /**
     * Destroys the xyContainer in the aggregation {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXyContainer(): this;
    /**
     * Destroys the yAxis in the aggregation {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis(): this;
    /**
     * Destroys the yAxis2 in the aggregation {@link #getYAxis2 yAxis2}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis2(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.DualColumn`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeselectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.DualColumn`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHideTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialized initialized} event of this `sap.viz.ui5.DualColumn`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialized(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectData selectData} event of this `sap.viz.ui5.DualColumn`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.DualColumn`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShowTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:deselectData deselectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeselectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:hideTooltip hideTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHideTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:initialized initialized} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialized(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectData selectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:showTooltip showTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShowTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getBackground background}.
     *
     * Module sap.viz.modules.background
     */
    getBackground(): Background;
    /**
     * Gets content of aggregation {@link #getDataLabel dataLabel}.
     *
     * Module sap.viz.modules.datalabel
     */
    getDataLabel(): Datalabel;
    /**
     * Gets content of aggregation {@link #getGeneral general}.
     *
     * Module sap.viz.modules.rootContainer
     */
    getGeneral(): RootContainer;
    /**
     * Gets content of aggregation {@link #getInteraction interaction}.
     *
     * Module sap.viz.modules.controller.interaction
     */
    getInteraction(): Interaction;
    /**
     * Gets content of aggregation {@link #getLegend legend}.
     *
     * Module sap.viz.modules.legend.common
     */
    getLegend(): Common;
    /**
     * Gets content of aggregation {@link #getLegendGroup legendGroup}.
     *
     * Module sap.viz.modules.legend
     */
    getLegendGroup(): Legend;
    /**
     * Gets content of aggregation {@link #getPlotArea plotArea}.
     *
     * Module sap.viz.modules.verticalbar
     */
    getPlotArea(): VerticalBar;
    /**
     * Gets content of aggregation {@link #getTitle title}.
     *
     * Module sap.viz.modules.title
     */
    getTitle(): Title;
    /**
     * Gets content of aggregation {@link #getToolTip toolTip}.
     *
     * Module sap.viz.chart.elements.Tooltip
     */
    getToolTip(): Tooltip;
    /**
     * Gets content of aggregation {@link #getXAxis xAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getXAxis(): Axis;
    /**
     * Gets content of aggregation {@link #getXyContainer xyContainer}.
     *
     * Module sap.viz.modules.xycontainer
     */
    getXyContainer(): XYContainer;
    /**
     * Gets content of aggregation {@link #getYAxis yAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis(): Axis;
    /**
     * Gets content of aggregation {@link #getYAxis2 yAxis2}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis2(): Axis;
    /**
     * Sets the aggregated {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackground(
      /**
       * The background to set
       */
      oBackground: Background
    ): this;
    /**
     * Sets the aggregated {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabel(
      /**
       * The dataLabel to set
       */
      oDataLabel: Datalabel
    ): this;
    /**
     * Sets the aggregated {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGeneral(
      /**
       * The general to set
       */
      oGeneral: RootContainer
    ): this;
    /**
     * Sets the aggregated {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInteraction(
      /**
       * The interaction to set
       */
      oInteraction: Interaction
    ): this;
    /**
     * Sets the aggregated {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegend(
      /**
       * The legend to set
       */
      oLegend: Common
    ): this;
    /**
     * Sets the aggregated {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendGroup(
      /**
       * The legendGroup to set
       */
      oLegendGroup: Legend
    ): this;
    /**
     * Sets the aggregated {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlotArea(
      /**
       * The plotArea to set
       */
      oPlotArea: VerticalBar
    ): this;
    /**
     * Sets the aggregated {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * The title to set
       */
      oTitle: Title
    ): this;
    /**
     * Sets the aggregated {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolTip(
      /**
       * The toolTip to set
       */
      oToolTip: Tooltip
    ): this;
    /**
     * Sets the aggregated {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxis(
      /**
       * The xAxis to set
       */
      oXAxis: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXyContainer(
      /**
       * The xyContainer to set
       */
      oXyContainer: XYContainer
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis(
      /**
       * The yAxis to set
       */
      oYAxis: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis2 yAxis2}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis2(
      /**
       * The yAxis2 to set
       */
      oYAxis2: Axis
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DualColumn constructor.
   *
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'dual_column'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export interface $DualColumnSettings extends $BaseChartSettings {
    /**
     * Module sap.viz.modules.rootContainer
     */
    general?: RootContainer;

    /**
     * Module sap.viz.modules.controller.interaction
     */
    interaction?: Interaction;

    /**
     * Module sap.viz.modules.title
     */
    title?: Title;

    /**
     * Module sap.viz.modules.legend
     */
    legendGroup?: Legend;

    /**
     * Module sap.viz.modules.legend.common
     */
    legend?: Common;

    /**
     * Module sap.viz.chart.elements.Tooltip
     */
    toolTip?: Tooltip;

    /**
     * Module sap.viz.modules.xycontainer
     */
    xyContainer?: XYContainer;

    /**
     * Module sap.viz.modules.datalabel
     */
    dataLabel?: Datalabel;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis?: Axis;

    /**
     * Module sap.viz.modules.axis
     */
    xAxis?: Axis;

    /**
     * Module sap.viz.modules.background
     */
    background?: Background;

    /**
     * Module sap.viz.modules.verticalbar
     */
    plotArea?: VerticalBar;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis2?: Axis;

    /**
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     */
    selectData?: (oEvent: Event) => void;

    /**
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     */
    deselectData?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    showTooltip?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    hideTooltip?: (oEvent: Event) => void;

    /**
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     */
    initialized?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the DualColumn#deselectData event.
   */
  export interface DualColumn$DeselectDataEventParameters {}

  /**
   * Event object of the DualColumn#deselectData event.
   */
  export type DualColumn$DeselectDataEvent = Event<
    DualColumn$DeselectDataEventParameters,
    DualColumn
  >;

  /**
   * Parameters of the DualColumn#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface DualColumn$HideTooltipEventParameters {}

  /**
   * Event object of the DualColumn#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type DualColumn$HideTooltipEvent = Event<
    DualColumn$HideTooltipEventParameters,
    DualColumn
  >;

  /**
   * Parameters of the DualColumn#initialized event.
   */
  export interface DualColumn$InitializedEventParameters {}

  /**
   * Event object of the DualColumn#initialized event.
   */
  export type DualColumn$InitializedEvent = Event<
    DualColumn$InitializedEventParameters,
    DualColumn
  >;

  /**
   * Parameters of the DualColumn#selectData event.
   */
  export interface DualColumn$SelectDataEventParameters {}

  /**
   * Event object of the DualColumn#selectData event.
   */
  export type DualColumn$SelectDataEvent = Event<
    DualColumn$SelectDataEventParameters,
    DualColumn
  >;

  /**
   * Parameters of the DualColumn#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface DualColumn$ShowTooltipEventParameters {}

  /**
   * Event object of the DualColumn#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type DualColumn$ShowTooltipEvent = Event<
    DualColumn$ShowTooltipEventParameters,
    DualColumn
  >;
}

declare module "sap/viz/ui5/DualCombination" {
  import {
    default as BaseChart,
    $BaseChartSettings,
  } from "sap/viz/ui5/core/BaseChart";

  import Event from "sap/ui/base/Event";

  import Background from "sap/viz/ui5/types/Background";

  import Datalabel from "sap/viz/ui5/types/Datalabel";

  import RootContainer from "sap/viz/ui5/types/RootContainer";

  import Interaction from "sap/viz/ui5/types/controller/Interaction";

  import Common from "sap/viz/ui5/types/legend/Common";

  import Legend from "sap/viz/ui5/types/Legend";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Combination from "sap/viz/ui5/types/Combination";

  import Title from "sap/viz/ui5/types/Title";

  import Tooltip from "sap/viz/ui5/types/Tooltip";

  import Axis from "sap/viz/ui5/types/Axis";

  import XYContainer from "sap/viz/ui5/types/XYContainer";

  /**
   * Chart sap.viz.ui5.DualCombination
   *
   * @since 1.7.2
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export default class DualCombination extends BaseChart {
    /**
     * Constructor for a new sap.viz.ui5.DualCombination
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $DualCombinationSettings
    );
    /**
     * Constructor for a new sap.viz.ui5.DualCombination
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $DualCombinationSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.DualCombination with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.core.BaseChart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DualCombination>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.DualCombination.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.DualCombination`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualCombination` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualCombination` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.DualCombination`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualCombination` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualCombination` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.DualCombination`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualCombination` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualCombination` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.DualCombination`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualCombination` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualCombination` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.DualCombination`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualCombination` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualCombination` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.DualCombination`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualCombination` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualCombination` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.DualCombination`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualCombination` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualCombination` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.DualCombination`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualCombination` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualCombination` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.DualCombination`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualCombination` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualCombination` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.DualCombination`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualCombination` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualCombination` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the background in the aggregation {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyBackground(): this;
    /**
     * Destroys the dataLabel in the aggregation {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataLabel(): this;
    /**
     * Destroys the general in the aggregation {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGeneral(): this;
    /**
     * Destroys the interaction in the aggregation {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInteraction(): this;
    /**
     * Destroys the legend in the aggregation {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegend(): this;
    /**
     * Destroys the legendGroup in the aggregation {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegendGroup(): this;
    /**
     * Destroys the plotArea in the aggregation {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPlotArea(): this;
    /**
     * Destroys the title in the aggregation {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTitle(): this;
    /**
     * Destroys the toolTip in the aggregation {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolTip(): this;
    /**
     * Destroys the xAxis in the aggregation {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXAxis(): this;
    /**
     * Destroys the xyContainer in the aggregation {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXyContainer(): this;
    /**
     * Destroys the yAxis in the aggregation {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis(): this;
    /**
     * Destroys the yAxis2 in the aggregation {@link #getYAxis2 yAxis2}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis2(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.DualCombination`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeselectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.DualCombination`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHideTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialized initialized} event of this `sap.viz.ui5.DualCombination`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialized(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectData selectData} event of this `sap.viz.ui5.DualCombination`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.DualCombination`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShowTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:deselectData deselectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeselectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:hideTooltip hideTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHideTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:initialized initialized} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialized(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectData selectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:showTooltip showTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShowTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getBackground background}.
     *
     * Module sap.viz.modules.background
     */
    getBackground(): Background;
    /**
     * Gets content of aggregation {@link #getDataLabel dataLabel}.
     *
     * Module sap.viz.modules.datalabel
     */
    getDataLabel(): Datalabel;
    /**
     * Gets content of aggregation {@link #getGeneral general}.
     *
     * Module sap.viz.modules.rootContainer
     */
    getGeneral(): RootContainer;
    /**
     * Gets content of aggregation {@link #getInteraction interaction}.
     *
     * Module sap.viz.modules.controller.interaction
     */
    getInteraction(): Interaction;
    /**
     * Gets content of aggregation {@link #getLegend legend}.
     *
     * Module sap.viz.modules.legend.common
     */
    getLegend(): Common;
    /**
     * Gets content of aggregation {@link #getLegendGroup legendGroup}.
     *
     * Module sap.viz.modules.legend
     */
    getLegendGroup(): Legend;
    /**
     * Gets content of aggregation {@link #getPlotArea plotArea}.
     *
     * Module sap.viz.modules.combination
     */
    getPlotArea(): Combination;
    /**
     * Gets content of aggregation {@link #getTitle title}.
     *
     * Module sap.viz.modules.title
     */
    getTitle(): Title;
    /**
     * Gets content of aggregation {@link #getToolTip toolTip}.
     *
     * Module sap.viz.chart.elements.Tooltip
     */
    getToolTip(): Tooltip;
    /**
     * Gets content of aggregation {@link #getXAxis xAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getXAxis(): Axis;
    /**
     * Gets content of aggregation {@link #getXyContainer xyContainer}.
     *
     * Module sap.viz.modules.xycontainer
     */
    getXyContainer(): XYContainer;
    /**
     * Gets content of aggregation {@link #getYAxis yAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis(): Axis;
    /**
     * Gets content of aggregation {@link #getYAxis2 yAxis2}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis2(): Axis;
    /**
     * Sets the aggregated {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackground(
      /**
       * The background to set
       */
      oBackground: Background
    ): this;
    /**
     * Sets the aggregated {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabel(
      /**
       * The dataLabel to set
       */
      oDataLabel: Datalabel
    ): this;
    /**
     * Sets the aggregated {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGeneral(
      /**
       * The general to set
       */
      oGeneral: RootContainer
    ): this;
    /**
     * Sets the aggregated {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInteraction(
      /**
       * The interaction to set
       */
      oInteraction: Interaction
    ): this;
    /**
     * Sets the aggregated {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegend(
      /**
       * The legend to set
       */
      oLegend: Common
    ): this;
    /**
     * Sets the aggregated {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendGroup(
      /**
       * The legendGroup to set
       */
      oLegendGroup: Legend
    ): this;
    /**
     * Sets the aggregated {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlotArea(
      /**
       * The plotArea to set
       */
      oPlotArea: Combination
    ): this;
    /**
     * Sets the aggregated {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * The title to set
       */
      oTitle: Title
    ): this;
    /**
     * Sets the aggregated {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolTip(
      /**
       * The toolTip to set
       */
      oToolTip: Tooltip
    ): this;
    /**
     * Sets the aggregated {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxis(
      /**
       * The xAxis to set
       */
      oXAxis: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXyContainer(
      /**
       * The xyContainer to set
       */
      oXyContainer: XYContainer
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis(
      /**
       * The yAxis to set
       */
      oYAxis: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis2 yAxis2}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis2(
      /**
       * The yAxis2 to set
       */
      oYAxis2: Axis
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DualCombination constructor.
   *
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export interface $DualCombinationSettings extends $BaseChartSettings {
    /**
     * Module sap.viz.modules.rootContainer
     */
    general?: RootContainer;

    /**
     * Module sap.viz.modules.controller.interaction
     */
    interaction?: Interaction;

    /**
     * Module sap.viz.modules.title
     */
    title?: Title;

    /**
     * Module sap.viz.modules.legend
     */
    legendGroup?: Legend;

    /**
     * Module sap.viz.modules.legend.common
     */
    legend?: Common;

    /**
     * Module sap.viz.chart.elements.Tooltip
     */
    toolTip?: Tooltip;

    /**
     * Module sap.viz.modules.xycontainer
     */
    xyContainer?: XYContainer;

    /**
     * Module sap.viz.modules.datalabel
     */
    dataLabel?: Datalabel;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis?: Axis;

    /**
     * Module sap.viz.modules.axis
     */
    xAxis?: Axis;

    /**
     * Module sap.viz.modules.background
     */
    background?: Background;

    /**
     * Module sap.viz.modules.combination
     */
    plotArea?: Combination;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis2?: Axis;

    /**
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     */
    selectData?: (oEvent: Event) => void;

    /**
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     */
    deselectData?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    showTooltip?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    hideTooltip?: (oEvent: Event) => void;

    /**
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     */
    initialized?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the DualCombination#deselectData event.
   */
  export interface DualCombination$DeselectDataEventParameters {}

  /**
   * Event object of the DualCombination#deselectData event.
   */
  export type DualCombination$DeselectDataEvent = Event<
    DualCombination$DeselectDataEventParameters,
    DualCombination
  >;

  /**
   * Parameters of the DualCombination#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface DualCombination$HideTooltipEventParameters {}

  /**
   * Event object of the DualCombination#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type DualCombination$HideTooltipEvent = Event<
    DualCombination$HideTooltipEventParameters,
    DualCombination
  >;

  /**
   * Parameters of the DualCombination#initialized event.
   */
  export interface DualCombination$InitializedEventParameters {}

  /**
   * Event object of the DualCombination#initialized event.
   */
  export type DualCombination$InitializedEvent = Event<
    DualCombination$InitializedEventParameters,
    DualCombination
  >;

  /**
   * Parameters of the DualCombination#selectData event.
   */
  export interface DualCombination$SelectDataEventParameters {}

  /**
   * Event object of the DualCombination#selectData event.
   */
  export type DualCombination$SelectDataEvent = Event<
    DualCombination$SelectDataEventParameters,
    DualCombination
  >;

  /**
   * Parameters of the DualCombination#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface DualCombination$ShowTooltipEventParameters {}

  /**
   * Event object of the DualCombination#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type DualCombination$ShowTooltipEvent = Event<
    DualCombination$ShowTooltipEventParameters,
    DualCombination
  >;
}

declare module "sap/viz/ui5/DualLine" {
  import {
    default as BaseChart,
    $BaseChartSettings,
  } from "sap/viz/ui5/core/BaseChart";

  import Event from "sap/ui/base/Event";

  import Background from "sap/viz/ui5/types/Background";

  import Datalabel from "sap/viz/ui5/types/Datalabel";

  import RootContainer from "sap/viz/ui5/types/RootContainer";

  import Interaction from "sap/viz/ui5/types/controller/Interaction";

  import Common from "sap/viz/ui5/types/legend/Common";

  import Legend from "sap/viz/ui5/types/Legend";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Line from "sap/viz/ui5/types/Line";

  import Title from "sap/viz/ui5/types/Title";

  import Tooltip from "sap/viz/ui5/types/Tooltip";

  import Axis from "sap/viz/ui5/types/Axis";

  import XYContainer from "sap/viz/ui5/types/XYContainer";

  /**
   * Chart sap.viz.ui5.DualLine
   *
   * @since 1.7.2
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'dual_line'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export default class DualLine extends BaseChart {
    /**
     * Constructor for a new sap.viz.ui5.DualLine
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $DualLineSettings
    );
    /**
     * Constructor for a new sap.viz.ui5.DualLine
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $DualLineSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.DualLine with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.core.BaseChart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DualLine>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.DualLine.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.DualLine`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualLine` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualLine` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.DualLine`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualLine` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualLine` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.DualLine`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualLine` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualLine` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.DualLine`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualLine` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualLine` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.DualLine`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualLine` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualLine` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.DualLine`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualLine` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualLine` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.DualLine`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualLine` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualLine` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.DualLine`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualLine` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualLine` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.DualLine`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualLine` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualLine` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.DualLine`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualLine` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualLine` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the background in the aggregation {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyBackground(): this;
    /**
     * Destroys the dataLabel in the aggregation {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataLabel(): this;
    /**
     * Destroys the general in the aggregation {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGeneral(): this;
    /**
     * Destroys the interaction in the aggregation {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInteraction(): this;
    /**
     * Destroys the legend in the aggregation {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegend(): this;
    /**
     * Destroys the legendGroup in the aggregation {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegendGroup(): this;
    /**
     * Destroys the plotArea in the aggregation {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPlotArea(): this;
    /**
     * Destroys the title in the aggregation {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTitle(): this;
    /**
     * Destroys the toolTip in the aggregation {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolTip(): this;
    /**
     * Destroys the xAxis in the aggregation {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXAxis(): this;
    /**
     * Destroys the xyContainer in the aggregation {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXyContainer(): this;
    /**
     * Destroys the yAxis in the aggregation {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis(): this;
    /**
     * Destroys the yAxis2 in the aggregation {@link #getYAxis2 yAxis2}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis2(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.DualLine`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeselectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.DualLine`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHideTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialized initialized} event of this `sap.viz.ui5.DualLine`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialized(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectData selectData} event of this `sap.viz.ui5.DualLine`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.DualLine`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShowTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:deselectData deselectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeselectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:hideTooltip hideTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHideTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:initialized initialized} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialized(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectData selectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:showTooltip showTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShowTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getBackground background}.
     *
     * Module sap.viz.modules.background
     */
    getBackground(): Background;
    /**
     * Gets content of aggregation {@link #getDataLabel dataLabel}.
     *
     * Module sap.viz.modules.datalabel
     */
    getDataLabel(): Datalabel;
    /**
     * Gets content of aggregation {@link #getGeneral general}.
     *
     * Module sap.viz.modules.rootContainer
     */
    getGeneral(): RootContainer;
    /**
     * Gets content of aggregation {@link #getInteraction interaction}.
     *
     * Module sap.viz.modules.controller.interaction
     */
    getInteraction(): Interaction;
    /**
     * Gets content of aggregation {@link #getLegend legend}.
     *
     * Module sap.viz.modules.legend.common
     */
    getLegend(): Common;
    /**
     * Gets content of aggregation {@link #getLegendGroup legendGroup}.
     *
     * Module sap.viz.modules.legend
     */
    getLegendGroup(): Legend;
    /**
     * Gets content of aggregation {@link #getPlotArea plotArea}.
     *
     * Module sap.viz.modules.line
     */
    getPlotArea(): Line;
    /**
     * Gets content of aggregation {@link #getTitle title}.
     *
     * Module sap.viz.modules.title
     */
    getTitle(): Title;
    /**
     * Gets content of aggregation {@link #getToolTip toolTip}.
     *
     * Module sap.viz.chart.elements.Tooltip
     */
    getToolTip(): Tooltip;
    /**
     * Gets content of aggregation {@link #getXAxis xAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getXAxis(): Axis;
    /**
     * Gets content of aggregation {@link #getXyContainer xyContainer}.
     *
     * Module sap.viz.modules.xycontainer
     */
    getXyContainer(): XYContainer;
    /**
     * Gets content of aggregation {@link #getYAxis yAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis(): Axis;
    /**
     * Gets content of aggregation {@link #getYAxis2 yAxis2}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis2(): Axis;
    /**
     * Sets the aggregated {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackground(
      /**
       * The background to set
       */
      oBackground: Background
    ): this;
    /**
     * Sets the aggregated {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabel(
      /**
       * The dataLabel to set
       */
      oDataLabel: Datalabel
    ): this;
    /**
     * Sets the aggregated {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGeneral(
      /**
       * The general to set
       */
      oGeneral: RootContainer
    ): this;
    /**
     * Sets the aggregated {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInteraction(
      /**
       * The interaction to set
       */
      oInteraction: Interaction
    ): this;
    /**
     * Sets the aggregated {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegend(
      /**
       * The legend to set
       */
      oLegend: Common
    ): this;
    /**
     * Sets the aggregated {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendGroup(
      /**
       * The legendGroup to set
       */
      oLegendGroup: Legend
    ): this;
    /**
     * Sets the aggregated {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlotArea(
      /**
       * The plotArea to set
       */
      oPlotArea: Line
    ): this;
    /**
     * Sets the aggregated {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * The title to set
       */
      oTitle: Title
    ): this;
    /**
     * Sets the aggregated {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolTip(
      /**
       * The toolTip to set
       */
      oToolTip: Tooltip
    ): this;
    /**
     * Sets the aggregated {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxis(
      /**
       * The xAxis to set
       */
      oXAxis: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXyContainer(
      /**
       * The xyContainer to set
       */
      oXyContainer: XYContainer
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis(
      /**
       * The yAxis to set
       */
      oYAxis: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis2 yAxis2}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis2(
      /**
       * The yAxis2 to set
       */
      oYAxis2: Axis
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DualLine constructor.
   *
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'dual_line'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export interface $DualLineSettings extends $BaseChartSettings {
    /**
     * Module sap.viz.modules.rootContainer
     */
    general?: RootContainer;

    /**
     * Module sap.viz.modules.controller.interaction
     */
    interaction?: Interaction;

    /**
     * Module sap.viz.modules.title
     */
    title?: Title;

    /**
     * Module sap.viz.modules.legend
     */
    legendGroup?: Legend;

    /**
     * Module sap.viz.modules.legend.common
     */
    legend?: Common;

    /**
     * Module sap.viz.chart.elements.Tooltip
     */
    toolTip?: Tooltip;

    /**
     * Module sap.viz.modules.xycontainer
     */
    xyContainer?: XYContainer;

    /**
     * Module sap.viz.modules.datalabel
     */
    dataLabel?: Datalabel;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis?: Axis;

    /**
     * Module sap.viz.modules.axis
     */
    xAxis?: Axis;

    /**
     * Module sap.viz.modules.background
     */
    background?: Background;

    /**
     * Module sap.viz.modules.line
     */
    plotArea?: Line;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis2?: Axis;

    /**
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     */
    selectData?: (oEvent: Event) => void;

    /**
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     */
    deselectData?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    showTooltip?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    hideTooltip?: (oEvent: Event) => void;

    /**
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     */
    initialized?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the DualLine#deselectData event.
   */
  export interface DualLine$DeselectDataEventParameters {}

  /**
   * Event object of the DualLine#deselectData event.
   */
  export type DualLine$DeselectDataEvent = Event<
    DualLine$DeselectDataEventParameters,
    DualLine
  >;

  /**
   * Parameters of the DualLine#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface DualLine$HideTooltipEventParameters {}

  /**
   * Event object of the DualLine#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type DualLine$HideTooltipEvent = Event<
    DualLine$HideTooltipEventParameters,
    DualLine
  >;

  /**
   * Parameters of the DualLine#initialized event.
   */
  export interface DualLine$InitializedEventParameters {}

  /**
   * Event object of the DualLine#initialized event.
   */
  export type DualLine$InitializedEvent = Event<
    DualLine$InitializedEventParameters,
    DualLine
  >;

  /**
   * Parameters of the DualLine#selectData event.
   */
  export interface DualLine$SelectDataEventParameters {}

  /**
   * Event object of the DualLine#selectData event.
   */
  export type DualLine$SelectDataEvent = Event<
    DualLine$SelectDataEventParameters,
    DualLine
  >;

  /**
   * Parameters of the DualLine#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface DualLine$ShowTooltipEventParameters {}

  /**
   * Event object of the DualLine#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type DualLine$ShowTooltipEvent = Event<
    DualLine$ShowTooltipEventParameters,
    DualLine
  >;
}

declare module "sap/viz/ui5/DualStackedColumn" {
  import {
    default as BaseChart,
    $BaseChartSettings,
  } from "sap/viz/ui5/core/BaseChart";

  import Event from "sap/ui/base/Event";

  import Background from "sap/viz/ui5/types/Background";

  import Datalabel from "sap/viz/ui5/types/Datalabel";

  import RootContainer from "sap/viz/ui5/types/RootContainer";

  import Interaction from "sap/viz/ui5/types/controller/Interaction";

  import Common from "sap/viz/ui5/types/legend/Common";

  import Legend from "sap/viz/ui5/types/Legend";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import StackedVerticalBar from "sap/viz/ui5/types/StackedVerticalBar";

  import Title from "sap/viz/ui5/types/Title";

  import Tooltip from "sap/viz/ui5/types/Tooltip";

  import Axis from "sap/viz/ui5/types/Axis";

  import XYContainer from "sap/viz/ui5/types/XYContainer";

  /**
   * Chart sap.viz.ui5.DualStackedColumn
   *
   * @since 1.7.2
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'dual_stacked_column'})`) **control to benefit from new charting
   * enhancements and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export default class DualStackedColumn extends BaseChart {
    /**
     * Constructor for a new sap.viz.ui5.DualStackedColumn
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $DualStackedColumnSettings
    );
    /**
     * Constructor for a new sap.viz.ui5.DualStackedColumn
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $DualStackedColumnSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.DualStackedColumn with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.core.BaseChart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DualStackedColumn>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.DualStackedColumn.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.DualStackedColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualStackedColumn` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualStackedColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.DualStackedColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualStackedColumn` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualStackedColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.DualStackedColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualStackedColumn` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualStackedColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.DualStackedColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualStackedColumn` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualStackedColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.DualStackedColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualStackedColumn` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualStackedColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.DualStackedColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualStackedColumn` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualStackedColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.DualStackedColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualStackedColumn` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualStackedColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.DualStackedColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualStackedColumn` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualStackedColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.DualStackedColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualStackedColumn` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualStackedColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.DualStackedColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualStackedColumn` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualStackedColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the background in the aggregation {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyBackground(): this;
    /**
     * Destroys the dataLabel in the aggregation {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataLabel(): this;
    /**
     * Destroys the general in the aggregation {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGeneral(): this;
    /**
     * Destroys the interaction in the aggregation {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInteraction(): this;
    /**
     * Destroys the legend in the aggregation {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegend(): this;
    /**
     * Destroys the legendGroup in the aggregation {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegendGroup(): this;
    /**
     * Destroys the plotArea in the aggregation {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPlotArea(): this;
    /**
     * Destroys the title in the aggregation {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTitle(): this;
    /**
     * Destroys the toolTip in the aggregation {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolTip(): this;
    /**
     * Destroys the xAxis in the aggregation {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXAxis(): this;
    /**
     * Destroys the xyContainer in the aggregation {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXyContainer(): this;
    /**
     * Destroys the yAxis in the aggregation {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis(): this;
    /**
     * Destroys the yAxis2 in the aggregation {@link #getYAxis2 yAxis2}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis2(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.DualStackedColumn`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeselectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.DualStackedColumn`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHideTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialized initialized} event of this `sap.viz.ui5.DualStackedColumn`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialized(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectData selectData} event of this `sap.viz.ui5.DualStackedColumn`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.DualStackedColumn`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShowTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:deselectData deselectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeselectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:hideTooltip hideTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHideTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:initialized initialized} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialized(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectData selectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:showTooltip showTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShowTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getBackground background}.
     *
     * Module sap.viz.modules.background
     */
    getBackground(): Background;
    /**
     * Gets content of aggregation {@link #getDataLabel dataLabel}.
     *
     * Module sap.viz.modules.datalabel
     */
    getDataLabel(): Datalabel;
    /**
     * Gets content of aggregation {@link #getGeneral general}.
     *
     * Module sap.viz.modules.rootContainer
     */
    getGeneral(): RootContainer;
    /**
     * Gets content of aggregation {@link #getInteraction interaction}.
     *
     * Module sap.viz.modules.controller.interaction
     */
    getInteraction(): Interaction;
    /**
     * Gets content of aggregation {@link #getLegend legend}.
     *
     * Module sap.viz.modules.legend.common
     */
    getLegend(): Common;
    /**
     * Gets content of aggregation {@link #getLegendGroup legendGroup}.
     *
     * Module sap.viz.modules.legend
     */
    getLegendGroup(): Legend;
    /**
     * Gets content of aggregation {@link #getPlotArea plotArea}.
     *
     * Module sap.viz.modules.stackedverticalbar
     */
    getPlotArea(): StackedVerticalBar;
    /**
     * Gets content of aggregation {@link #getTitle title}.
     *
     * Module sap.viz.modules.title
     */
    getTitle(): Title;
    /**
     * Gets content of aggregation {@link #getToolTip toolTip}.
     *
     * Module sap.viz.chart.elements.Tooltip
     */
    getToolTip(): Tooltip;
    /**
     * Gets content of aggregation {@link #getXAxis xAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getXAxis(): Axis;
    /**
     * Gets content of aggregation {@link #getXyContainer xyContainer}.
     *
     * Module sap.viz.modules.xycontainer
     */
    getXyContainer(): XYContainer;
    /**
     * Gets content of aggregation {@link #getYAxis yAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis(): Axis;
    /**
     * Gets content of aggregation {@link #getYAxis2 yAxis2}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis2(): Axis;
    /**
     * Sets the aggregated {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackground(
      /**
       * The background to set
       */
      oBackground: Background
    ): this;
    /**
     * Sets the aggregated {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabel(
      /**
       * The dataLabel to set
       */
      oDataLabel: Datalabel
    ): this;
    /**
     * Sets the aggregated {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGeneral(
      /**
       * The general to set
       */
      oGeneral: RootContainer
    ): this;
    /**
     * Sets the aggregated {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInteraction(
      /**
       * The interaction to set
       */
      oInteraction: Interaction
    ): this;
    /**
     * Sets the aggregated {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegend(
      /**
       * The legend to set
       */
      oLegend: Common
    ): this;
    /**
     * Sets the aggregated {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendGroup(
      /**
       * The legendGroup to set
       */
      oLegendGroup: Legend
    ): this;
    /**
     * Sets the aggregated {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlotArea(
      /**
       * The plotArea to set
       */
      oPlotArea: StackedVerticalBar
    ): this;
    /**
     * Sets the aggregated {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * The title to set
       */
      oTitle: Title
    ): this;
    /**
     * Sets the aggregated {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolTip(
      /**
       * The toolTip to set
       */
      oToolTip: Tooltip
    ): this;
    /**
     * Sets the aggregated {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxis(
      /**
       * The xAxis to set
       */
      oXAxis: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXyContainer(
      /**
       * The xyContainer to set
       */
      oXyContainer: XYContainer
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis(
      /**
       * The yAxis to set
       */
      oYAxis: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis2 yAxis2}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis2(
      /**
       * The yAxis2 to set
       */
      oYAxis2: Axis
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DualStackedColumn constructor.
   *
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'dual_stacked_column'})`) **control to benefit from new charting
   * enhancements and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export interface $DualStackedColumnSettings extends $BaseChartSettings {
    /**
     * Module sap.viz.modules.rootContainer
     */
    general?: RootContainer;

    /**
     * Module sap.viz.modules.controller.interaction
     */
    interaction?: Interaction;

    /**
     * Module sap.viz.modules.title
     */
    title?: Title;

    /**
     * Module sap.viz.modules.legend
     */
    legendGroup?: Legend;

    /**
     * Module sap.viz.modules.legend.common
     */
    legend?: Common;

    /**
     * Module sap.viz.chart.elements.Tooltip
     */
    toolTip?: Tooltip;

    /**
     * Module sap.viz.modules.xycontainer
     */
    xyContainer?: XYContainer;

    /**
     * Module sap.viz.modules.datalabel
     */
    dataLabel?: Datalabel;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis?: Axis;

    /**
     * Module sap.viz.modules.axis
     */
    xAxis?: Axis;

    /**
     * Module sap.viz.modules.background
     */
    background?: Background;

    /**
     * Module sap.viz.modules.stackedverticalbar
     */
    plotArea?: StackedVerticalBar;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis2?: Axis;

    /**
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     */
    selectData?: (oEvent: Event) => void;

    /**
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     */
    deselectData?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    showTooltip?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    hideTooltip?: (oEvent: Event) => void;

    /**
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     */
    initialized?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the DualStackedColumn#deselectData event.
   */
  export interface DualStackedColumn$DeselectDataEventParameters {}

  /**
   * Event object of the DualStackedColumn#deselectData event.
   */
  export type DualStackedColumn$DeselectDataEvent = Event<
    DualStackedColumn$DeselectDataEventParameters,
    DualStackedColumn
  >;

  /**
   * Parameters of the DualStackedColumn#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface DualStackedColumn$HideTooltipEventParameters {}

  /**
   * Event object of the DualStackedColumn#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type DualStackedColumn$HideTooltipEvent = Event<
    DualStackedColumn$HideTooltipEventParameters,
    DualStackedColumn
  >;

  /**
   * Parameters of the DualStackedColumn#initialized event.
   */
  export interface DualStackedColumn$InitializedEventParameters {}

  /**
   * Event object of the DualStackedColumn#initialized event.
   */
  export type DualStackedColumn$InitializedEvent = Event<
    DualStackedColumn$InitializedEventParameters,
    DualStackedColumn
  >;

  /**
   * Parameters of the DualStackedColumn#selectData event.
   */
  export interface DualStackedColumn$SelectDataEventParameters {}

  /**
   * Event object of the DualStackedColumn#selectData event.
   */
  export type DualStackedColumn$SelectDataEvent = Event<
    DualStackedColumn$SelectDataEventParameters,
    DualStackedColumn
  >;

  /**
   * Parameters of the DualStackedColumn#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface DualStackedColumn$ShowTooltipEventParameters {}

  /**
   * Event object of the DualStackedColumn#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type DualStackedColumn$ShowTooltipEvent = Event<
    DualStackedColumn$ShowTooltipEventParameters,
    DualStackedColumn
  >;
}

declare module "sap/viz/ui5/DualStackedColumn100" {
  import {
    default as BaseChart,
    $BaseChartSettings,
  } from "sap/viz/ui5/core/BaseChart";

  import Event from "sap/ui/base/Event";

  import Background from "sap/viz/ui5/types/Background";

  import Datalabel from "sap/viz/ui5/types/Datalabel";

  import RootContainer from "sap/viz/ui5/types/RootContainer";

  import Interaction from "sap/viz/ui5/types/controller/Interaction";

  import Common from "sap/viz/ui5/types/legend/Common";

  import Legend from "sap/viz/ui5/types/Legend";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import StackedVerticalBar from "sap/viz/ui5/types/StackedVerticalBar";

  import Title from "sap/viz/ui5/types/Title";

  import Tooltip from "sap/viz/ui5/types/Tooltip";

  import Axis from "sap/viz/ui5/types/Axis";

  import XYContainer from "sap/viz/ui5/types/XYContainer";

  /**
   * Chart sap.viz.ui5.DualStackedColumn100
   *
   * @since 1.7.2
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': '100_dual_stacked_column'})`) **control to benefit from new
   * charting enhancements and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export default class DualStackedColumn100 extends BaseChart {
    /**
     * Constructor for a new sap.viz.ui5.DualStackedColumn100
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $DualStackedColumn100Settings
    );
    /**
     * Constructor for a new sap.viz.ui5.DualStackedColumn100
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $DualStackedColumn100Settings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.DualStackedColumn100 with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.core.BaseChart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DualStackedColumn100>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.DualStackedColumn100.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.DualStackedColumn100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualStackedColumn100` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualStackedColumn100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.DualStackedColumn100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualStackedColumn100` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualStackedColumn100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.DualStackedColumn100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualStackedColumn100` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualStackedColumn100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.DualStackedColumn100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualStackedColumn100` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualStackedColumn100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.DualStackedColumn100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualStackedColumn100` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualStackedColumn100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.DualStackedColumn100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualStackedColumn100` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualStackedColumn100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.DualStackedColumn100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualStackedColumn100` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualStackedColumn100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.DualStackedColumn100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualStackedColumn100` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualStackedColumn100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.DualStackedColumn100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualStackedColumn100` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualStackedColumn100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.DualStackedColumn100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.DualStackedColumn100` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.DualStackedColumn100` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the background in the aggregation {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyBackground(): this;
    /**
     * Destroys the dataLabel in the aggregation {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataLabel(): this;
    /**
     * Destroys the general in the aggregation {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGeneral(): this;
    /**
     * Destroys the interaction in the aggregation {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInteraction(): this;
    /**
     * Destroys the legend in the aggregation {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegend(): this;
    /**
     * Destroys the legendGroup in the aggregation {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegendGroup(): this;
    /**
     * Destroys the plotArea in the aggregation {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPlotArea(): this;
    /**
     * Destroys the title in the aggregation {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTitle(): this;
    /**
     * Destroys the toolTip in the aggregation {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolTip(): this;
    /**
     * Destroys the xAxis in the aggregation {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXAxis(): this;
    /**
     * Destroys the xyContainer in the aggregation {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXyContainer(): this;
    /**
     * Destroys the yAxis in the aggregation {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis(): this;
    /**
     * Destroys the yAxis2 in the aggregation {@link #getYAxis2 yAxis2}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis2(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.DualStackedColumn100`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeselectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.DualStackedColumn100`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHideTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialized initialized} event of this `sap.viz.ui5.DualStackedColumn100`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialized(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectData selectData} event of this `sap.viz.ui5.DualStackedColumn100`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.DualStackedColumn100`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShowTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:deselectData deselectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeselectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:hideTooltip hideTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHideTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:initialized initialized} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialized(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectData selectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:showTooltip showTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShowTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getBackground background}.
     *
     * Module sap.viz.modules.background
     */
    getBackground(): Background;
    /**
     * Gets content of aggregation {@link #getDataLabel dataLabel}.
     *
     * Module sap.viz.modules.datalabel
     */
    getDataLabel(): Datalabel;
    /**
     * Gets content of aggregation {@link #getGeneral general}.
     *
     * Module sap.viz.modules.rootContainer
     */
    getGeneral(): RootContainer;
    /**
     * Gets content of aggregation {@link #getInteraction interaction}.
     *
     * Module sap.viz.modules.controller.interaction
     */
    getInteraction(): Interaction;
    /**
     * Gets content of aggregation {@link #getLegend legend}.
     *
     * Module sap.viz.modules.legend.common
     */
    getLegend(): Common;
    /**
     * Gets content of aggregation {@link #getLegendGroup legendGroup}.
     *
     * Module sap.viz.modules.legend
     */
    getLegendGroup(): Legend;
    /**
     * Gets content of aggregation {@link #getPlotArea plotArea}.
     *
     * Module sap.viz.modules.stackedverticalbar
     */
    getPlotArea(): StackedVerticalBar;
    /**
     * Gets content of aggregation {@link #getTitle title}.
     *
     * Module sap.viz.modules.title
     */
    getTitle(): Title;
    /**
     * Gets content of aggregation {@link #getToolTip toolTip}.
     *
     * Module sap.viz.chart.elements.Tooltip
     */
    getToolTip(): Tooltip;
    /**
     * Gets content of aggregation {@link #getXAxis xAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getXAxis(): Axis;
    /**
     * Gets content of aggregation {@link #getXyContainer xyContainer}.
     *
     * Module sap.viz.modules.xycontainer
     */
    getXyContainer(): XYContainer;
    /**
     * Gets content of aggregation {@link #getYAxis yAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis(): Axis;
    /**
     * Gets content of aggregation {@link #getYAxis2 yAxis2}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis2(): Axis;
    /**
     * Sets the aggregated {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackground(
      /**
       * The background to set
       */
      oBackground: Background
    ): this;
    /**
     * Sets the aggregated {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabel(
      /**
       * The dataLabel to set
       */
      oDataLabel: Datalabel
    ): this;
    /**
     * Sets the aggregated {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGeneral(
      /**
       * The general to set
       */
      oGeneral: RootContainer
    ): this;
    /**
     * Sets the aggregated {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInteraction(
      /**
       * The interaction to set
       */
      oInteraction: Interaction
    ): this;
    /**
     * Sets the aggregated {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegend(
      /**
       * The legend to set
       */
      oLegend: Common
    ): this;
    /**
     * Sets the aggregated {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendGroup(
      /**
       * The legendGroup to set
       */
      oLegendGroup: Legend
    ): this;
    /**
     * Sets the aggregated {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlotArea(
      /**
       * The plotArea to set
       */
      oPlotArea: StackedVerticalBar
    ): this;
    /**
     * Sets the aggregated {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * The title to set
       */
      oTitle: Title
    ): this;
    /**
     * Sets the aggregated {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolTip(
      /**
       * The toolTip to set
       */
      oToolTip: Tooltip
    ): this;
    /**
     * Sets the aggregated {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxis(
      /**
       * The xAxis to set
       */
      oXAxis: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXyContainer(
      /**
       * The xyContainer to set
       */
      oXyContainer: XYContainer
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis(
      /**
       * The yAxis to set
       */
      oYAxis: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis2 yAxis2}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis2(
      /**
       * The yAxis2 to set
       */
      oYAxis2: Axis
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DualStackedColumn100 constructor.
   *
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': '100_dual_stacked_column'})`) **control to benefit from new
   * charting enhancements and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export interface $DualStackedColumn100Settings extends $BaseChartSettings {
    /**
     * Module sap.viz.modules.rootContainer
     */
    general?: RootContainer;

    /**
     * Module sap.viz.modules.controller.interaction
     */
    interaction?: Interaction;

    /**
     * Module sap.viz.modules.title
     */
    title?: Title;

    /**
     * Module sap.viz.modules.legend
     */
    legendGroup?: Legend;

    /**
     * Module sap.viz.modules.legend.common
     */
    legend?: Common;

    /**
     * Module sap.viz.chart.elements.Tooltip
     */
    toolTip?: Tooltip;

    /**
     * Module sap.viz.modules.xycontainer
     */
    xyContainer?: XYContainer;

    /**
     * Module sap.viz.modules.datalabel
     */
    dataLabel?: Datalabel;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis?: Axis;

    /**
     * Module sap.viz.modules.axis
     */
    xAxis?: Axis;

    /**
     * Module sap.viz.modules.background
     */
    background?: Background;

    /**
     * Module sap.viz.modules.stackedverticalbar
     */
    plotArea?: StackedVerticalBar;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis2?: Axis;

    /**
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     */
    selectData?: (oEvent: Event) => void;

    /**
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     */
    deselectData?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    showTooltip?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    hideTooltip?: (oEvent: Event) => void;

    /**
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     */
    initialized?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the DualStackedColumn100#deselectData event.
   */
  export interface DualStackedColumn100$DeselectDataEventParameters {}

  /**
   * Event object of the DualStackedColumn100#deselectData event.
   */
  export type DualStackedColumn100$DeselectDataEvent = Event<
    DualStackedColumn100$DeselectDataEventParameters,
    DualStackedColumn100
  >;

  /**
   * Parameters of the DualStackedColumn100#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface DualStackedColumn100$HideTooltipEventParameters {}

  /**
   * Event object of the DualStackedColumn100#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type DualStackedColumn100$HideTooltipEvent = Event<
    DualStackedColumn100$HideTooltipEventParameters,
    DualStackedColumn100
  >;

  /**
   * Parameters of the DualStackedColumn100#initialized event.
   */
  export interface DualStackedColumn100$InitializedEventParameters {}

  /**
   * Event object of the DualStackedColumn100#initialized event.
   */
  export type DualStackedColumn100$InitializedEvent = Event<
    DualStackedColumn100$InitializedEventParameters,
    DualStackedColumn100
  >;

  /**
   * Parameters of the DualStackedColumn100#selectData event.
   */
  export interface DualStackedColumn100$SelectDataEventParameters {}

  /**
   * Event object of the DualStackedColumn100#selectData event.
   */
  export type DualStackedColumn100$SelectDataEvent = Event<
    DualStackedColumn100$SelectDataEventParameters,
    DualStackedColumn100
  >;

  /**
   * Parameters of the DualStackedColumn100#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface DualStackedColumn100$ShowTooltipEventParameters {}

  /**
   * Event object of the DualStackedColumn100#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type DualStackedColumn100$ShowTooltipEvent = Event<
    DualStackedColumn100$ShowTooltipEventParameters,
    DualStackedColumn100
  >;
}

declare module "sap/viz/ui5/format/ChartFormatter" {
  /**
   * Provides methods set chart formatter for VizFrame.
   */
  export default class ChartFormatter {
    constructor();
    /**
     * List (Enum) type sap.viz.ui5.format.ChartFormatter.DefaultPattern
     */
    static DefaultPattern: typeof DefaultPattern;

    /**
     * Get an instance of ChartFormatter
     */
    static getInstance(): void;
    /**
     * Format the value according to the custom format function
     */
    format(): void;
  }
  /**
   * List (Enum) type sap.viz.ui5.format.ChartFormatter.DefaultPattern
   */
  enum DefaultPattern {
    /**
     * Binary file size
     *
     * e.g. 1 Kibibyte = 1024 Byte
     */
    BINARYFILESIZE = "BinaryFileSize",
    /**
     * type: Currency
     *
     * style: "standard"
     *
     * e.g. 234234.234 is formatted as 234,234.23
     *
     * @deprecated (since 1.48.0)
     */
    CURRENCY = "Currency",
    /**
     * Decimal file size
     *
     * e.g. 1 Kilobyte = 1000 Byte
     */
    DECIMALFILESIZE = "DecimalFileSize",
    /**
     * type: Float
     *
     * style: "long"
     *
     * e.g. 2.3 million
     */
    LONGFLOAT = "LongFloat",
    /**
     * Medium day
     *
     * e.g. 01
     */
    MEDIUMDAY = "MediumDay",
    /**
     * Medium hour
     *
     * e.g. 18
     */
    MEDIUMHOUR = "MediumHour",
    /**
     * Medium minute
     *
     * e.g. 18
     */
    MEDIUMMINUTE = "MediumMinute",
    /**
     * Medium month
     *
     * e.g. Aug
     */
    MEDIUMMONTH = "MediumMonth",
    /**
     * Medium quarter
     *
     * e.g. Q3
     */
    MEDIUMQUARTER = "MediumQuarter",
    /**
     * Medium second
     *
     * e.g. 59
     */
    MEDIUMSECOND = "MediumSecond",
    /**
     * Medium week
     *
     * e.g. CW35
     */
    MEDIUMWEEK = "MediumWeek",
    /**
     * Medium year
     *
     * e.g. 2015
     */
    MEDIUMYEAR = "MediumYear",
    /**
     * Medium format pattern for combination of year, month, and day
     *
     * e.g. Aug 28, 2015
     */
    MEDIUMYEARMONTHDAY = "MediumYearMonthDay",
    /**
     * type: Percentage
     *
     * style: "standard"
     *
     * e.g. 0.0234 is formatted as 2.34%
     *
     * @deprecated (since 1.48.0)
     */
    PERCENT = "Percent",
    /**
     * Quarter
     *
     * e.g. Q3
     *
     * @deprecated (since 1.48.0)
     */
    QUARTER = "Quarter",
    /**
     * type: Float
     *
     * style: "short"
     *
     * e.g. 2.3M
     */
    SHORTFLOAT = "ShortFloat",
    /**
     * type: Float
     *
     * style: "short"
     *
     * maxFractionDigits: 2
     *
     * e.g. 2.34234234 is formatted as 2.34
     */
    SHORTFLOAT_MFD2 = "ShortFloat_MFD2",
    /**
     * type: Integer
     *
     * style: "short"
     *
     * e.g. 234M
     */
    SHORTINTEGER = "ShortInteger",
    /**
     * type: Currency
     *
     * style: "standard"
     *
     * e.g. 234234.234 is formatted as 234,234.23
     */
    STANDARDCURRENCY = "StandardCurrency",
    /**
     * type: Float
     *
     * style: "standard"
     *
     * e.g. 234,234.234
     */
    STANDARDFLOAT = "StandardFloat",
    /**
     * type: Integer
     *
     * style: "standard"
     *
     * e.g. 234234234
     */
    STANDARDINTEGER = "StandardInteger",
    /**
     * type: Percentage
     *
     * style: "standard"
     *
     * e.g. 0.0234234 is formatted as 2.34234%
     */
    STANDARDPERCENT = "StandardPercent",
    /**
     * type: Percentage
     *
     * style: "standard"
     *
     * maxFractionDigits: 2
     *
     * e.g. 0.0234234 is formatted as 2.34%
     */
    STANDARDPERCENT_MFD2 = "StandardPercent_MFD2",
    /**
     * Week
     *
     * e.g. CW35
     *
     * @deprecated (since 1.48.0)
     */
    WEEK = "Week",
    /**
     * Format pattern for combination of year, month, and day
     *
     * e.g. Aug 28, 2015
     *
     * @deprecated (since 1.48.0)
     */
    YEARMONTHDAY = "YearMonthDay",
  }
}

declare module "sap/viz/ui5/Heatmap" {
  import {
    default as BaseChart,
    $BaseChartSettings,
  } from "sap/viz/ui5/core/BaseChart";

  import Event from "sap/ui/base/Event";

  import Datalabel from "sap/viz/ui5/types/Datalabel";

  import RootContainer from "sap/viz/ui5/types/RootContainer";

  import Interaction from "sap/viz/ui5/types/controller/Interaction";

  import Common from "sap/viz/ui5/types/legend/Common";

  import Legend from "sap/viz/ui5/types/Legend";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Heatmap1 from "sap/viz/ui5/types/Heatmap";

  import Title from "sap/viz/ui5/types/Title";

  import Tooltip from "sap/viz/ui5/types/Tooltip";

  import Axis from "sap/viz/ui5/types/Axis";

  import XYContainer from "sap/viz/ui5/types/XYContainer";

  /**
   * Chart sap.viz.ui5.Heatmap
   *
   * @since 1.7.2
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'heatmap'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export default class Heatmap extends BaseChart {
    /**
     * Constructor for a new sap.viz.ui5.Heatmap
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $HeatmapSettings
    );
    /**
     * Constructor for a new sap.viz.ui5.Heatmap
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $HeatmapSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.Heatmap with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.core.BaseChart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Heatmap>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.Heatmap.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Heatmap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Heatmap` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Heatmap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Heatmap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Heatmap` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Heatmap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Heatmap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Heatmap` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Heatmap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Heatmap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Heatmap` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Heatmap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Heatmap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Heatmap` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Heatmap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Heatmap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Heatmap` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Heatmap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Heatmap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Heatmap` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Heatmap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Heatmap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Heatmap` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Heatmap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Heatmap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Heatmap` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Heatmap` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Heatmap`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Heatmap` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Heatmap` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the dataLabel in the aggregation {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataLabel(): this;
    /**
     * Destroys the general in the aggregation {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGeneral(): this;
    /**
     * Destroys the interaction in the aggregation {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInteraction(): this;
    /**
     * Destroys the legend in the aggregation {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegend(): this;
    /**
     * Destroys the legendGroup in the aggregation {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegendGroup(): this;
    /**
     * Destroys the plotArea in the aggregation {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPlotArea(): this;
    /**
     * Destroys the title in the aggregation {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTitle(): this;
    /**
     * Destroys the toolTip in the aggregation {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolTip(): this;
    /**
     * Destroys the xAxis in the aggregation {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXAxis(): this;
    /**
     * Destroys the xyContainer in the aggregation {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXyContainer(): this;
    /**
     * Destroys the yAxis in the aggregation {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Heatmap`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeselectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Heatmap`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHideTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialized initialized} event of this `sap.viz.ui5.Heatmap`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialized(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectData selectData} event of this `sap.viz.ui5.Heatmap`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Heatmap`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShowTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:deselectData deselectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeselectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:hideTooltip hideTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHideTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:initialized initialized} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialized(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectData selectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:showTooltip showTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShowTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getDataLabel dataLabel}.
     *
     * Module sap.viz.modules.datalabel
     */
    getDataLabel(): Datalabel;
    /**
     * Gets content of aggregation {@link #getGeneral general}.
     *
     * Module sap.viz.modules.rootContainer
     */
    getGeneral(): RootContainer;
    /**
     * Gets content of aggregation {@link #getInteraction interaction}.
     *
     * Module sap.viz.modules.controller.interaction
     */
    getInteraction(): Interaction;
    /**
     * Gets content of aggregation {@link #getLegend legend}.
     *
     * Module sap.viz.modules.legend.common
     */
    getLegend(): Common;
    /**
     * Gets content of aggregation {@link #getLegendGroup legendGroup}.
     *
     * Module sap.viz.modules.legend
     */
    getLegendGroup(): Legend;
    /**
     * Gets content of aggregation {@link #getPlotArea plotArea}.
     *
     * Module sap.viz.modules.heatmap
     */
    getPlotArea(): Heatmap1;
    /**
     * Gets content of aggregation {@link #getTitle title}.
     *
     * Module sap.viz.modules.title
     */
    getTitle(): Title;
    /**
     * Gets content of aggregation {@link #getToolTip toolTip}.
     *
     * Module sap.viz.chart.elements.Tooltip
     */
    getToolTip(): Tooltip;
    /**
     * Gets content of aggregation {@link #getXAxis xAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getXAxis(): Axis;
    /**
     * Gets content of aggregation {@link #getXyContainer xyContainer}.
     *
     * Module sap.viz.modules.xycontainer
     */
    getXyContainer(): XYContainer;
    /**
     * Gets content of aggregation {@link #getYAxis yAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis(): Axis;
    /**
     * Sets the aggregated {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabel(
      /**
       * The dataLabel to set
       */
      oDataLabel: Datalabel
    ): this;
    /**
     * Sets the aggregated {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGeneral(
      /**
       * The general to set
       */
      oGeneral: RootContainer
    ): this;
    /**
     * Sets the aggregated {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInteraction(
      /**
       * The interaction to set
       */
      oInteraction: Interaction
    ): this;
    /**
     * Sets the aggregated {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegend(
      /**
       * The legend to set
       */
      oLegend: Common
    ): this;
    /**
     * Sets the aggregated {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendGroup(
      /**
       * The legendGroup to set
       */
      oLegendGroup: Legend
    ): this;
    /**
     * Sets the aggregated {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlotArea(
      /**
       * The plotArea to set
       */
      oPlotArea: Heatmap1
    ): this;
    /**
     * Sets the aggregated {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * The title to set
       */
      oTitle: Title
    ): this;
    /**
     * Sets the aggregated {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolTip(
      /**
       * The toolTip to set
       */
      oToolTip: Tooltip
    ): this;
    /**
     * Sets the aggregated {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxis(
      /**
       * The xAxis to set
       */
      oXAxis: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXyContainer(
      /**
       * The xyContainer to set
       */
      oXyContainer: XYContainer
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis(
      /**
       * The yAxis to set
       */
      oYAxis: Axis
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Heatmap constructor.
   *
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'heatmap'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export interface $HeatmapSettings extends $BaseChartSettings {
    /**
     * Module sap.viz.modules.rootContainer
     */
    general?: RootContainer;

    /**
     * Module sap.viz.modules.title
     */
    title?: Title;

    /**
     * Module sap.viz.modules.legend
     */
    legendGroup?: Legend;

    /**
     * Module sap.viz.modules.legend.common
     */
    legend?: Common;

    /**
     * Module sap.viz.modules.xycontainer
     */
    xyContainer?: XYContainer;

    /**
     * Module sap.viz.modules.datalabel
     */
    dataLabel?: Datalabel;

    /**
     * Module sap.viz.modules.axis
     */
    xAxis?: Axis;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis?: Axis;

    /**
     * Module sap.viz.modules.heatmap
     */
    plotArea?: Heatmap1;

    /**
     * Module sap.viz.chart.elements.Tooltip
     */
    toolTip?: Tooltip;

    /**
     * Module sap.viz.modules.controller.interaction
     */
    interaction?: Interaction;

    /**
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     */
    selectData?: (oEvent: Event) => void;

    /**
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     */
    deselectData?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    showTooltip?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    hideTooltip?: (oEvent: Event) => void;

    /**
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     */
    initialized?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Heatmap#deselectData event.
   */
  export interface Heatmap$DeselectDataEventParameters {}

  /**
   * Event object of the Heatmap#deselectData event.
   */
  export type Heatmap$DeselectDataEvent = Event<
    Heatmap$DeselectDataEventParameters,
    Heatmap
  >;

  /**
   * Parameters of the Heatmap#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Heatmap$HideTooltipEventParameters {}

  /**
   * Event object of the Heatmap#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Heatmap$HideTooltipEvent = Event<
    Heatmap$HideTooltipEventParameters,
    Heatmap
  >;

  /**
   * Parameters of the Heatmap#initialized event.
   */
  export interface Heatmap$InitializedEventParameters {}

  /**
   * Event object of the Heatmap#initialized event.
   */
  export type Heatmap$InitializedEvent = Event<
    Heatmap$InitializedEventParameters,
    Heatmap
  >;

  /**
   * Parameters of the Heatmap#selectData event.
   */
  export interface Heatmap$SelectDataEventParameters {}

  /**
   * Event object of the Heatmap#selectData event.
   */
  export type Heatmap$SelectDataEvent = Event<
    Heatmap$SelectDataEventParameters,
    Heatmap
  >;

  /**
   * Parameters of the Heatmap#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Heatmap$ShowTooltipEventParameters {}

  /**
   * Event object of the Heatmap#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Heatmap$ShowTooltipEvent = Event<
    Heatmap$ShowTooltipEventParameters,
    Heatmap
  >;
}

declare module "sap/viz/ui5/HorizontalArea" {
  import {
    default as BaseChart,
    $BaseChartSettings,
  } from "sap/viz/ui5/core/BaseChart";

  import Event from "sap/ui/base/Event";

  import Background from "sap/viz/ui5/types/Background";

  import Datalabel from "sap/viz/ui5/types/Datalabel";

  import RootContainer from "sap/viz/ui5/types/RootContainer";

  import Interaction from "sap/viz/ui5/types/controller/Interaction";

  import Common from "sap/viz/ui5/types/legend/Common";

  import Legend from "sap/viz/ui5/types/Legend";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Area from "sap/viz/ui5/types/Area";

  import Title from "sap/viz/ui5/types/Title";

  import Tooltip from "sap/viz/ui5/types/Tooltip";

  import Axis from "sap/viz/ui5/types/Axis";

  import XYContainer from "sap/viz/ui5/types/XYContainer";

  /**
   * Chart sap.viz.ui5.HorizontalArea
   *
   * @since 1.7.2
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export default class HorizontalArea extends BaseChart {
    /**
     * Constructor for a new sap.viz.ui5.HorizontalArea
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $HorizontalAreaSettings
    );
    /**
     * Constructor for a new sap.viz.ui5.HorizontalArea
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $HorizontalAreaSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.HorizontalArea with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.core.BaseChart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, HorizontalArea>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.HorizontalArea.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.HorizontalArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.HorizontalArea` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.HorizontalArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.HorizontalArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.HorizontalArea` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.HorizontalArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.HorizontalArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.HorizontalArea` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.HorizontalArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.HorizontalArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.HorizontalArea` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.HorizontalArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.HorizontalArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.HorizontalArea` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.HorizontalArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.HorizontalArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.HorizontalArea` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.HorizontalArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.HorizontalArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.HorizontalArea` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.HorizontalArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.HorizontalArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.HorizontalArea` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.HorizontalArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.HorizontalArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.HorizontalArea` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.HorizontalArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.HorizontalArea`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.HorizontalArea` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.HorizontalArea` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the background in the aggregation {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyBackground(): this;
    /**
     * Destroys the dataLabel in the aggregation {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataLabel(): this;
    /**
     * Destroys the general in the aggregation {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGeneral(): this;
    /**
     * Destroys the interaction in the aggregation {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInteraction(): this;
    /**
     * Destroys the legend in the aggregation {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegend(): this;
    /**
     * Destroys the legendGroup in the aggregation {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegendGroup(): this;
    /**
     * Destroys the plotArea in the aggregation {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPlotArea(): this;
    /**
     * Destroys the title in the aggregation {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTitle(): this;
    /**
     * Destroys the toolTip in the aggregation {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolTip(): this;
    /**
     * Destroys the xAxis in the aggregation {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXAxis(): this;
    /**
     * Destroys the xyContainer in the aggregation {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXyContainer(): this;
    /**
     * Destroys the yAxis in the aggregation {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.HorizontalArea`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeselectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.HorizontalArea`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHideTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialized initialized} event of this `sap.viz.ui5.HorizontalArea`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialized(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectData selectData} event of this `sap.viz.ui5.HorizontalArea`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.HorizontalArea`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShowTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:deselectData deselectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeselectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:hideTooltip hideTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHideTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:initialized initialized} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialized(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectData selectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:showTooltip showTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShowTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getBackground background}.
     *
     * Module sap.viz.modules.background
     */
    getBackground(): Background;
    /**
     * Gets content of aggregation {@link #getDataLabel dataLabel}.
     *
     * Module sap.viz.modules.datalabel
     */
    getDataLabel(): Datalabel;
    /**
     * Gets content of aggregation {@link #getGeneral general}.
     *
     * Module sap.viz.modules.rootContainer
     */
    getGeneral(): RootContainer;
    /**
     * Gets content of aggregation {@link #getInteraction interaction}.
     *
     * Module sap.viz.modules.controller.interaction
     */
    getInteraction(): Interaction;
    /**
     * Gets content of aggregation {@link #getLegend legend}.
     *
     * Module sap.viz.modules.legend.common
     */
    getLegend(): Common;
    /**
     * Gets content of aggregation {@link #getLegendGroup legendGroup}.
     *
     * Module sap.viz.modules.legend
     */
    getLegendGroup(): Legend;
    /**
     * Gets content of aggregation {@link #getPlotArea plotArea}.
     *
     * Module sap.viz.modules.area
     */
    getPlotArea(): Area;
    /**
     * Gets content of aggregation {@link #getTitle title}.
     *
     * Module sap.viz.modules.title
     */
    getTitle(): Title;
    /**
     * Gets content of aggregation {@link #getToolTip toolTip}.
     *
     * Module sap.viz.chart.elements.Tooltip
     */
    getToolTip(): Tooltip;
    /**
     * Gets content of aggregation {@link #getXAxis xAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getXAxis(): Axis;
    /**
     * Gets content of aggregation {@link #getXyContainer xyContainer}.
     *
     * Module sap.viz.modules.xycontainer
     */
    getXyContainer(): XYContainer;
    /**
     * Gets content of aggregation {@link #getYAxis yAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis(): Axis;
    /**
     * Sets the aggregated {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackground(
      /**
       * The background to set
       */
      oBackground: Background
    ): this;
    /**
     * Sets the aggregated {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabel(
      /**
       * The dataLabel to set
       */
      oDataLabel: Datalabel
    ): this;
    /**
     * Sets the aggregated {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGeneral(
      /**
       * The general to set
       */
      oGeneral: RootContainer
    ): this;
    /**
     * Sets the aggregated {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInteraction(
      /**
       * The interaction to set
       */
      oInteraction: Interaction
    ): this;
    /**
     * Sets the aggregated {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegend(
      /**
       * The legend to set
       */
      oLegend: Common
    ): this;
    /**
     * Sets the aggregated {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendGroup(
      /**
       * The legendGroup to set
       */
      oLegendGroup: Legend
    ): this;
    /**
     * Sets the aggregated {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlotArea(
      /**
       * The plotArea to set
       */
      oPlotArea: Area
    ): this;
    /**
     * Sets the aggregated {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * The title to set
       */
      oTitle: Title
    ): this;
    /**
     * Sets the aggregated {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolTip(
      /**
       * The toolTip to set
       */
      oToolTip: Tooltip
    ): this;
    /**
     * Sets the aggregated {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxis(
      /**
       * The xAxis to set
       */
      oXAxis: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXyContainer(
      /**
       * The xyContainer to set
       */
      oXyContainer: XYContainer
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis(
      /**
       * The yAxis to set
       */
      oYAxis: Axis
    ): this;
  }
  /**
   * Describes the settings that can be provided to the HorizontalArea constructor.
   *
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export interface $HorizontalAreaSettings extends $BaseChartSettings {
    /**
     * Module sap.viz.modules.rootContainer
     */
    general?: RootContainer;

    /**
     * Module sap.viz.modules.controller.interaction
     */
    interaction?: Interaction;

    /**
     * Module sap.viz.modules.title
     */
    title?: Title;

    /**
     * Module sap.viz.modules.legend
     */
    legendGroup?: Legend;

    /**
     * Module sap.viz.modules.legend.common
     */
    legend?: Common;

    /**
     * Module sap.viz.chart.elements.Tooltip
     */
    toolTip?: Tooltip;

    /**
     * Module sap.viz.modules.xycontainer
     */
    xyContainer?: XYContainer;

    /**
     * Module sap.viz.modules.datalabel
     */
    dataLabel?: Datalabel;

    /**
     * Module sap.viz.modules.axis
     */
    xAxis?: Axis;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis?: Axis;

    /**
     * Module sap.viz.modules.background
     */
    background?: Background;

    /**
     * Module sap.viz.modules.area
     */
    plotArea?: Area;

    /**
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     */
    selectData?: (oEvent: Event) => void;

    /**
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     */
    deselectData?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    showTooltip?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    hideTooltip?: (oEvent: Event) => void;

    /**
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     */
    initialized?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the HorizontalArea#deselectData event.
   */
  export interface HorizontalArea$DeselectDataEventParameters {}

  /**
   * Event object of the HorizontalArea#deselectData event.
   */
  export type HorizontalArea$DeselectDataEvent = Event<
    HorizontalArea$DeselectDataEventParameters,
    HorizontalArea
  >;

  /**
   * Parameters of the HorizontalArea#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface HorizontalArea$HideTooltipEventParameters {}

  /**
   * Event object of the HorizontalArea#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type HorizontalArea$HideTooltipEvent = Event<
    HorizontalArea$HideTooltipEventParameters,
    HorizontalArea
  >;

  /**
   * Parameters of the HorizontalArea#initialized event.
   */
  export interface HorizontalArea$InitializedEventParameters {}

  /**
   * Event object of the HorizontalArea#initialized event.
   */
  export type HorizontalArea$InitializedEvent = Event<
    HorizontalArea$InitializedEventParameters,
    HorizontalArea
  >;

  /**
   * Parameters of the HorizontalArea#selectData event.
   */
  export interface HorizontalArea$SelectDataEventParameters {}

  /**
   * Event object of the HorizontalArea#selectData event.
   */
  export type HorizontalArea$SelectDataEvent = Event<
    HorizontalArea$SelectDataEventParameters,
    HorizontalArea
  >;

  /**
   * Parameters of the HorizontalArea#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface HorizontalArea$ShowTooltipEventParameters {}

  /**
   * Event object of the HorizontalArea#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type HorizontalArea$ShowTooltipEvent = Event<
    HorizontalArea$ShowTooltipEventParameters,
    HorizontalArea
  >;
}

declare module "sap/viz/ui5/HorizontalArea100" {
  import {
    default as BaseChart,
    $BaseChartSettings,
  } from "sap/viz/ui5/core/BaseChart";

  import Event from "sap/ui/base/Event";

  import Background from "sap/viz/ui5/types/Background";

  import Datalabel from "sap/viz/ui5/types/Datalabel";

  import RootContainer from "sap/viz/ui5/types/RootContainer";

  import Interaction from "sap/viz/ui5/types/controller/Interaction";

  import Common from "sap/viz/ui5/types/legend/Common";

  import Legend from "sap/viz/ui5/types/Legend";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Area from "sap/viz/ui5/types/Area";

  import Title from "sap/viz/ui5/types/Title";

  import Tooltip from "sap/viz/ui5/types/Tooltip";

  import Axis from "sap/viz/ui5/types/Axis";

  import XYContainer from "sap/viz/ui5/types/XYContainer";

  /**
   * Chart sap.viz.ui5.HorizontalArea100
   *
   * @since 1.7.2
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export default class HorizontalArea100 extends BaseChart {
    /**
     * Constructor for a new sap.viz.ui5.HorizontalArea100
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $HorizontalArea100Settings
    );
    /**
     * Constructor for a new sap.viz.ui5.HorizontalArea100
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $HorizontalArea100Settings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.HorizontalArea100 with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.core.BaseChart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, HorizontalArea100>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.HorizontalArea100.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.HorizontalArea100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.HorizontalArea100` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.HorizontalArea100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.HorizontalArea100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.HorizontalArea100` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.HorizontalArea100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.HorizontalArea100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.HorizontalArea100` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.HorizontalArea100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.HorizontalArea100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.HorizontalArea100` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.HorizontalArea100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.HorizontalArea100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.HorizontalArea100` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.HorizontalArea100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.HorizontalArea100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.HorizontalArea100` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.HorizontalArea100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.HorizontalArea100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.HorizontalArea100` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.HorizontalArea100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.HorizontalArea100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.HorizontalArea100` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.HorizontalArea100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.HorizontalArea100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.HorizontalArea100` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.HorizontalArea100` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.HorizontalArea100`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.HorizontalArea100` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.HorizontalArea100` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the background in the aggregation {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyBackground(): this;
    /**
     * Destroys the dataLabel in the aggregation {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataLabel(): this;
    /**
     * Destroys the general in the aggregation {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGeneral(): this;
    /**
     * Destroys the interaction in the aggregation {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInteraction(): this;
    /**
     * Destroys the legend in the aggregation {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegend(): this;
    /**
     * Destroys the legendGroup in the aggregation {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegendGroup(): this;
    /**
     * Destroys the plotArea in the aggregation {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPlotArea(): this;
    /**
     * Destroys the title in the aggregation {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTitle(): this;
    /**
     * Destroys the toolTip in the aggregation {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolTip(): this;
    /**
     * Destroys the xAxis in the aggregation {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXAxis(): this;
    /**
     * Destroys the xyContainer in the aggregation {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXyContainer(): this;
    /**
     * Destroys the yAxis in the aggregation {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.HorizontalArea100`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeselectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.HorizontalArea100`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHideTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialized initialized} event of this `sap.viz.ui5.HorizontalArea100`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialized(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectData selectData} event of this `sap.viz.ui5.HorizontalArea100`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.HorizontalArea100`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShowTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:deselectData deselectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeselectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:hideTooltip hideTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHideTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:initialized initialized} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialized(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectData selectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:showTooltip showTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShowTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getBackground background}.
     *
     * Module sap.viz.modules.background
     */
    getBackground(): Background;
    /**
     * Gets content of aggregation {@link #getDataLabel dataLabel}.
     *
     * Module sap.viz.modules.datalabel
     */
    getDataLabel(): Datalabel;
    /**
     * Gets content of aggregation {@link #getGeneral general}.
     *
     * Module sap.viz.modules.rootContainer
     */
    getGeneral(): RootContainer;
    /**
     * Gets content of aggregation {@link #getInteraction interaction}.
     *
     * Module sap.viz.modules.controller.interaction
     */
    getInteraction(): Interaction;
    /**
     * Gets content of aggregation {@link #getLegend legend}.
     *
     * Module sap.viz.modules.legend.common
     */
    getLegend(): Common;
    /**
     * Gets content of aggregation {@link #getLegendGroup legendGroup}.
     *
     * Module sap.viz.modules.legend
     */
    getLegendGroup(): Legend;
    /**
     * Gets content of aggregation {@link #getPlotArea plotArea}.
     *
     * Module sap.viz.modules.area
     */
    getPlotArea(): Area;
    /**
     * Gets content of aggregation {@link #getTitle title}.
     *
     * Module sap.viz.modules.title
     */
    getTitle(): Title;
    /**
     * Gets content of aggregation {@link #getToolTip toolTip}.
     *
     * Module sap.viz.chart.elements.Tooltip
     */
    getToolTip(): Tooltip;
    /**
     * Gets content of aggregation {@link #getXAxis xAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getXAxis(): Axis;
    /**
     * Gets content of aggregation {@link #getXyContainer xyContainer}.
     *
     * Module sap.viz.modules.xycontainer
     */
    getXyContainer(): XYContainer;
    /**
     * Gets content of aggregation {@link #getYAxis yAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis(): Axis;
    /**
     * Sets the aggregated {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackground(
      /**
       * The background to set
       */
      oBackground: Background
    ): this;
    /**
     * Sets the aggregated {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabel(
      /**
       * The dataLabel to set
       */
      oDataLabel: Datalabel
    ): this;
    /**
     * Sets the aggregated {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGeneral(
      /**
       * The general to set
       */
      oGeneral: RootContainer
    ): this;
    /**
     * Sets the aggregated {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInteraction(
      /**
       * The interaction to set
       */
      oInteraction: Interaction
    ): this;
    /**
     * Sets the aggregated {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegend(
      /**
       * The legend to set
       */
      oLegend: Common
    ): this;
    /**
     * Sets the aggregated {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendGroup(
      /**
       * The legendGroup to set
       */
      oLegendGroup: Legend
    ): this;
    /**
     * Sets the aggregated {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlotArea(
      /**
       * The plotArea to set
       */
      oPlotArea: Area
    ): this;
    /**
     * Sets the aggregated {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * The title to set
       */
      oTitle: Title
    ): this;
    /**
     * Sets the aggregated {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolTip(
      /**
       * The toolTip to set
       */
      oToolTip: Tooltip
    ): this;
    /**
     * Sets the aggregated {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxis(
      /**
       * The xAxis to set
       */
      oXAxis: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXyContainer(
      /**
       * The xyContainer to set
       */
      oXyContainer: XYContainer
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis(
      /**
       * The yAxis to set
       */
      oYAxis: Axis
    ): this;
  }
  /**
   * Describes the settings that can be provided to the HorizontalArea100 constructor.
   *
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export interface $HorizontalArea100Settings extends $BaseChartSettings {
    /**
     * Module sap.viz.modules.rootContainer
     */
    general?: RootContainer;

    /**
     * Module sap.viz.modules.controller.interaction
     */
    interaction?: Interaction;

    /**
     * Module sap.viz.modules.title
     */
    title?: Title;

    /**
     * Module sap.viz.modules.legend
     */
    legendGroup?: Legend;

    /**
     * Module sap.viz.modules.legend.common
     */
    legend?: Common;

    /**
     * Module sap.viz.chart.elements.Tooltip
     */
    toolTip?: Tooltip;

    /**
     * Module sap.viz.modules.xycontainer
     */
    xyContainer?: XYContainer;

    /**
     * Module sap.viz.modules.datalabel
     */
    dataLabel?: Datalabel;

    /**
     * Module sap.viz.modules.axis
     */
    xAxis?: Axis;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis?: Axis;

    /**
     * Module sap.viz.modules.background
     */
    background?: Background;

    /**
     * Module sap.viz.modules.area
     */
    plotArea?: Area;

    /**
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     */
    selectData?: (oEvent: Event) => void;

    /**
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     */
    deselectData?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    showTooltip?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    hideTooltip?: (oEvent: Event) => void;

    /**
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     */
    initialized?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the HorizontalArea100#deselectData event.
   */
  export interface HorizontalArea100$DeselectDataEventParameters {}

  /**
   * Event object of the HorizontalArea100#deselectData event.
   */
  export type HorizontalArea100$DeselectDataEvent = Event<
    HorizontalArea100$DeselectDataEventParameters,
    HorizontalArea100
  >;

  /**
   * Parameters of the HorizontalArea100#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface HorizontalArea100$HideTooltipEventParameters {}

  /**
   * Event object of the HorizontalArea100#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type HorizontalArea100$HideTooltipEvent = Event<
    HorizontalArea100$HideTooltipEventParameters,
    HorizontalArea100
  >;

  /**
   * Parameters of the HorizontalArea100#initialized event.
   */
  export interface HorizontalArea100$InitializedEventParameters {}

  /**
   * Event object of the HorizontalArea100#initialized event.
   */
  export type HorizontalArea100$InitializedEvent = Event<
    HorizontalArea100$InitializedEventParameters,
    HorizontalArea100
  >;

  /**
   * Parameters of the HorizontalArea100#selectData event.
   */
  export interface HorizontalArea100$SelectDataEventParameters {}

  /**
   * Event object of the HorizontalArea100#selectData event.
   */
  export type HorizontalArea100$SelectDataEvent = Event<
    HorizontalArea100$SelectDataEventParameters,
    HorizontalArea100
  >;

  /**
   * Parameters of the HorizontalArea100#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface HorizontalArea100$ShowTooltipEventParameters {}

  /**
   * Event object of the HorizontalArea100#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type HorizontalArea100$ShowTooltipEvent = Event<
    HorizontalArea100$ShowTooltipEventParameters,
    HorizontalArea100
  >;
}

declare module "sap/viz/ui5/Line" {
  import {
    default as BaseChart,
    $BaseChartSettings,
  } from "sap/viz/ui5/core/BaseChart";

  import Event from "sap/ui/base/Event";

  import Background from "sap/viz/ui5/types/Background";

  import Datalabel from "sap/viz/ui5/types/Datalabel";

  import RootContainer from "sap/viz/ui5/types/RootContainer";

  import Interaction from "sap/viz/ui5/types/controller/Interaction";

  import Common from "sap/viz/ui5/types/legend/Common";

  import Legend from "sap/viz/ui5/types/Legend";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Line1 from "sap/viz/ui5/types/Line";

  import Title from "sap/viz/ui5/types/Title";

  import Tooltip from "sap/viz/ui5/types/Tooltip";

  import Axis from "sap/viz/ui5/types/Axis";

  import XYContainer from "sap/viz/ui5/types/XYContainer";

  /**
   * Chart sap.viz.ui5.Line
   *
   * @since 1.7.2
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'line'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export default class Line extends BaseChart {
    /**
     * Constructor for a new sap.viz.ui5.Line
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $LineSettings
    );
    /**
     * Constructor for a new sap.viz.ui5.Line
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $LineSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.Line with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.core.BaseChart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Line>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.Line.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Line`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Line` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Line` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Line`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Line` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Line` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Line`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Line` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Line` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Line`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Line` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Line` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Line`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Line` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Line` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Line`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Line` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Line` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Line`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Line` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Line` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Line`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Line` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Line` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Line`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Line` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Line` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Line`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Line` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Line` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the background in the aggregation {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyBackground(): this;
    /**
     * Destroys the dataLabel in the aggregation {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataLabel(): this;
    /**
     * Destroys the general in the aggregation {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGeneral(): this;
    /**
     * Destroys the interaction in the aggregation {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInteraction(): this;
    /**
     * Destroys the legend in the aggregation {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegend(): this;
    /**
     * Destroys the legendGroup in the aggregation {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegendGroup(): this;
    /**
     * Destroys the plotArea in the aggregation {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPlotArea(): this;
    /**
     * Destroys the title in the aggregation {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTitle(): this;
    /**
     * Destroys the toolTip in the aggregation {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolTip(): this;
    /**
     * Destroys the xAxis in the aggregation {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXAxis(): this;
    /**
     * Destroys the xyContainer in the aggregation {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXyContainer(): this;
    /**
     * Destroys the yAxis in the aggregation {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Line`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeselectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Line`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHideTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialized initialized} event of this `sap.viz.ui5.Line`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialized(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectData selectData} event of this `sap.viz.ui5.Line`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Line`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShowTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:deselectData deselectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeselectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:hideTooltip hideTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHideTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:initialized initialized} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialized(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectData selectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:showTooltip showTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShowTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getBackground background}.
     *
     * Module sap.viz.modules.background
     */
    getBackground(): Background;
    /**
     * Gets content of aggregation {@link #getDataLabel dataLabel}.
     *
     * Module sap.viz.modules.datalabel
     */
    getDataLabel(): Datalabel;
    /**
     * Gets content of aggregation {@link #getGeneral general}.
     *
     * Module sap.viz.modules.rootContainer
     */
    getGeneral(): RootContainer;
    /**
     * Gets content of aggregation {@link #getInteraction interaction}.
     *
     * Module sap.viz.modules.controller.interaction
     */
    getInteraction(): Interaction;
    /**
     * Gets content of aggregation {@link #getLegend legend}.
     *
     * Module sap.viz.modules.legend.common
     */
    getLegend(): Common;
    /**
     * Gets content of aggregation {@link #getLegendGroup legendGroup}.
     *
     * Module sap.viz.modules.legend
     */
    getLegendGroup(): Legend;
    /**
     * Gets content of aggregation {@link #getPlotArea plotArea}.
     *
     * Module sap.viz.modules.line
     */
    getPlotArea(): Line1;
    /**
     * Gets content of aggregation {@link #getTitle title}.
     *
     * Module sap.viz.modules.title
     */
    getTitle(): Title;
    /**
     * Gets content of aggregation {@link #getToolTip toolTip}.
     *
     * Module sap.viz.chart.elements.Tooltip
     */
    getToolTip(): Tooltip;
    /**
     * Gets content of aggregation {@link #getXAxis xAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getXAxis(): Axis;
    /**
     * Gets content of aggregation {@link #getXyContainer xyContainer}.
     *
     * Module sap.viz.modules.xycontainer
     */
    getXyContainer(): XYContainer;
    /**
     * Gets content of aggregation {@link #getYAxis yAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis(): Axis;
    /**
     * Sets the aggregated {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackground(
      /**
       * The background to set
       */
      oBackground: Background
    ): this;
    /**
     * Sets the aggregated {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabel(
      /**
       * The dataLabel to set
       */
      oDataLabel: Datalabel
    ): this;
    /**
     * Sets the aggregated {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGeneral(
      /**
       * The general to set
       */
      oGeneral: RootContainer
    ): this;
    /**
     * Sets the aggregated {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInteraction(
      /**
       * The interaction to set
       */
      oInteraction: Interaction
    ): this;
    /**
     * Sets the aggregated {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegend(
      /**
       * The legend to set
       */
      oLegend: Common
    ): this;
    /**
     * Sets the aggregated {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendGroup(
      /**
       * The legendGroup to set
       */
      oLegendGroup: Legend
    ): this;
    /**
     * Sets the aggregated {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlotArea(
      /**
       * The plotArea to set
       */
      oPlotArea: Line1
    ): this;
    /**
     * Sets the aggregated {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * The title to set
       */
      oTitle: Title
    ): this;
    /**
     * Sets the aggregated {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolTip(
      /**
       * The toolTip to set
       */
      oToolTip: Tooltip
    ): this;
    /**
     * Sets the aggregated {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxis(
      /**
       * The xAxis to set
       */
      oXAxis: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXyContainer(
      /**
       * The xyContainer to set
       */
      oXyContainer: XYContainer
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis(
      /**
       * The yAxis to set
       */
      oYAxis: Axis
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Line constructor.
   *
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'line'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export interface $LineSettings extends $BaseChartSettings {
    /**
     * Module sap.viz.modules.rootContainer
     */
    general?: RootContainer;

    /**
     * Module sap.viz.modules.controller.interaction
     */
    interaction?: Interaction;

    /**
     * Module sap.viz.modules.title
     */
    title?: Title;

    /**
     * Module sap.viz.modules.legend
     */
    legendGroup?: Legend;

    /**
     * Module sap.viz.modules.legend.common
     */
    legend?: Common;

    /**
     * Module sap.viz.chart.elements.Tooltip
     */
    toolTip?: Tooltip;

    /**
     * Module sap.viz.modules.xycontainer
     */
    xyContainer?: XYContainer;

    /**
     * Module sap.viz.modules.datalabel
     */
    dataLabel?: Datalabel;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis?: Axis;

    /**
     * Module sap.viz.modules.axis
     */
    xAxis?: Axis;

    /**
     * Module sap.viz.modules.background
     */
    background?: Background;

    /**
     * Module sap.viz.modules.line
     */
    plotArea?: Line1;

    /**
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     */
    selectData?: (oEvent: Event) => void;

    /**
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     */
    deselectData?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    showTooltip?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    hideTooltip?: (oEvent: Event) => void;

    /**
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     */
    initialized?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Line#deselectData event.
   */
  export interface Line$DeselectDataEventParameters {}

  /**
   * Event object of the Line#deselectData event.
   */
  export type Line$DeselectDataEvent = Event<
    Line$DeselectDataEventParameters,
    Line
  >;

  /**
   * Parameters of the Line#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Line$HideTooltipEventParameters {}

  /**
   * Event object of the Line#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Line$HideTooltipEvent = Event<
    Line$HideTooltipEventParameters,
    Line
  >;

  /**
   * Parameters of the Line#initialized event.
   */
  export interface Line$InitializedEventParameters {}

  /**
   * Event object of the Line#initialized event.
   */
  export type Line$InitializedEvent = Event<
    Line$InitializedEventParameters,
    Line
  >;

  /**
   * Parameters of the Line#selectData event.
   */
  export interface Line$SelectDataEventParameters {}

  /**
   * Event object of the Line#selectData event.
   */
  export type Line$SelectDataEvent = Event<
    Line$SelectDataEventParameters,
    Line
  >;

  /**
   * Parameters of the Line#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Line$ShowTooltipEventParameters {}

  /**
   * Event object of the Line#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Line$ShowTooltipEvent = Event<
    Line$ShowTooltipEventParameters,
    Line
  >;
}

declare module "sap/viz/ui5/Pie" {
  import {
    default as BaseChart,
    $BaseChartSettings,
  } from "sap/viz/ui5/core/BaseChart";

  import Event from "sap/ui/base/Event";

  import Datalabel from "sap/viz/ui5/types/Datalabel";

  import Datatransform from "sap/viz/ui5/types/Datatransform";

  import RootContainer from "sap/viz/ui5/types/RootContainer";

  import Interaction from "sap/viz/ui5/types/controller/Interaction";

  import Common from "sap/viz/ui5/types/legend/Common";

  import Legend from "sap/viz/ui5/types/Legend";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Pie1 from "sap/viz/ui5/types/Pie";

  import Title from "sap/viz/ui5/types/Title";

  import Tooltip from "sap/viz/ui5/types/Tooltip";

  import XYContainer from "sap/viz/ui5/types/XYContainer";

  /**
   * Chart sap.viz.ui5.Pie
   *
   * @since 1.7.2
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'pie'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export default class Pie extends BaseChart {
    /**
     * Constructor for a new sap.viz.ui5.Pie
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $PieSettings
    );
    /**
     * Constructor for a new sap.viz.ui5.Pie
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $PieSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.Pie with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.core.BaseChart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Pie>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.Pie.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Pie`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Pie` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Pie` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Pie`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Pie` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Pie` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Pie`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Pie` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Pie` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Pie`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Pie` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Pie` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Pie`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Pie` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Pie` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Pie`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Pie` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Pie` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Pie`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Pie` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Pie` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Pie`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Pie` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Pie` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Pie`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Pie` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Pie` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Pie`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Pie` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Pie` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the dataLabel in the aggregation {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataLabel(): this;
    /**
     * Destroys the dataTransform in the aggregation {@link #getDataTransform dataTransform}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataTransform(): this;
    /**
     * Destroys the general in the aggregation {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGeneral(): this;
    /**
     * Destroys the interaction in the aggregation {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInteraction(): this;
    /**
     * Destroys the legend in the aggregation {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegend(): this;
    /**
     * Destroys the legendGroup in the aggregation {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegendGroup(): this;
    /**
     * Destroys the plotArea in the aggregation {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPlotArea(): this;
    /**
     * Destroys the title in the aggregation {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTitle(): this;
    /**
     * Destroys the toolTip in the aggregation {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolTip(): this;
    /**
     * Destroys the xyContainer in the aggregation {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXyContainer(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Pie`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeselectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Pie`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHideTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialized initialized} event of this `sap.viz.ui5.Pie`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialized(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectData selectData} event of this `sap.viz.ui5.Pie`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Pie`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShowTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:deselectData deselectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeselectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:hideTooltip hideTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHideTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:initialized initialized} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialized(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectData selectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:showTooltip showTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShowTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getDataLabel dataLabel}.
     *
     * Module sap.viz.modules.datalabel
     */
    getDataLabel(): Datalabel;
    /**
     * Gets content of aggregation {@link #getDataTransform dataTransform}.
     *
     * Module sap.viz.modules.datatransform
     */
    getDataTransform(): Datatransform;
    /**
     * Gets content of aggregation {@link #getGeneral general}.
     *
     * Module sap.viz.modules.rootContainer
     */
    getGeneral(): RootContainer;
    /**
     * Gets content of aggregation {@link #getInteraction interaction}.
     *
     * Module sap.viz.modules.controller.interaction
     */
    getInteraction(): Interaction;
    /**
     * Gets content of aggregation {@link #getLegend legend}.
     *
     * Module sap.viz.modules.legend.common
     */
    getLegend(): Common;
    /**
     * Gets content of aggregation {@link #getLegendGroup legendGroup}.
     *
     * Module sap.viz.modules.legend
     */
    getLegendGroup(): Legend;
    /**
     * Gets content of aggregation {@link #getPlotArea plotArea}.
     *
     * Module sap.viz.modules.pie
     */
    getPlotArea(): Pie1;
    /**
     * Gets content of aggregation {@link #getTitle title}.
     *
     * Module sap.viz.modules.title
     */
    getTitle(): Title;
    /**
     * Gets content of aggregation {@link #getToolTip toolTip}.
     *
     * Module sap.viz.chart.elements.Tooltip
     */
    getToolTip(): Tooltip;
    /**
     * Gets content of aggregation {@link #getXyContainer xyContainer}.
     *
     * Module sap.viz.modules.xycontainer
     */
    getXyContainer(): XYContainer;
    /**
     * Sets the aggregated {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabel(
      /**
       * The dataLabel to set
       */
      oDataLabel: Datalabel
    ): this;
    /**
     * Sets the aggregated {@link #getDataTransform dataTransform}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataTransform(
      /**
       * The dataTransform to set
       */
      oDataTransform: Datatransform
    ): this;
    /**
     * Sets the aggregated {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGeneral(
      /**
       * The general to set
       */
      oGeneral: RootContainer
    ): this;
    /**
     * Sets the aggregated {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInteraction(
      /**
       * The interaction to set
       */
      oInteraction: Interaction
    ): this;
    /**
     * Sets the aggregated {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegend(
      /**
       * The legend to set
       */
      oLegend: Common
    ): this;
    /**
     * Sets the aggregated {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendGroup(
      /**
       * The legendGroup to set
       */
      oLegendGroup: Legend
    ): this;
    /**
     * Sets the aggregated {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlotArea(
      /**
       * The plotArea to set
       */
      oPlotArea: Pie1
    ): this;
    /**
     * Sets the aggregated {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * The title to set
       */
      oTitle: Title
    ): this;
    /**
     * Sets the aggregated {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolTip(
      /**
       * The toolTip to set
       */
      oToolTip: Tooltip
    ): this;
    /**
     * Sets the aggregated {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXyContainer(
      /**
       * The xyContainer to set
       */
      oXyContainer: XYContainer
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Pie constructor.
   *
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'pie'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export interface $PieSettings extends $BaseChartSettings {
    /**
     * Module sap.viz.modules.rootContainer
     */
    general?: RootContainer;

    /**
     * Module sap.viz.modules.title
     */
    title?: Title;

    /**
     * Module sap.viz.modules.legend
     */
    legendGroup?: Legend;

    /**
     * Module sap.viz.modules.legend.common
     */
    legend?: Common;

    /**
     * Module sap.viz.modules.xycontainer
     */
    xyContainer?: XYContainer;

    /**
     * Module sap.viz.modules.pie
     */
    plotArea?: Pie1;

    /**
     * Module sap.viz.modules.datalabel
     */
    dataLabel?: Datalabel;

    /**
     * Module sap.viz.modules.controller.interaction
     */
    interaction?: Interaction;

    /**
     * Module sap.viz.chart.elements.Tooltip
     */
    toolTip?: Tooltip;

    /**
     * Module sap.viz.modules.datatransform
     */
    dataTransform?: Datatransform;

    /**
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     */
    selectData?: (oEvent: Event) => void;

    /**
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     */
    deselectData?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    showTooltip?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    hideTooltip?: (oEvent: Event) => void;

    /**
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     */
    initialized?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Pie#deselectData event.
   */
  export interface Pie$DeselectDataEventParameters {}

  /**
   * Event object of the Pie#deselectData event.
   */
  export type Pie$DeselectDataEvent = Event<
    Pie$DeselectDataEventParameters,
    Pie
  >;

  /**
   * Parameters of the Pie#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Pie$HideTooltipEventParameters {}

  /**
   * Event object of the Pie#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Pie$HideTooltipEvent = Event<Pie$HideTooltipEventParameters, Pie>;

  /**
   * Parameters of the Pie#initialized event.
   */
  export interface Pie$InitializedEventParameters {}

  /**
   * Event object of the Pie#initialized event.
   */
  export type Pie$InitializedEvent = Event<Pie$InitializedEventParameters, Pie>;

  /**
   * Parameters of the Pie#selectData event.
   */
  export interface Pie$SelectDataEventParameters {}

  /**
   * Event object of the Pie#selectData event.
   */
  export type Pie$SelectDataEvent = Event<Pie$SelectDataEventParameters, Pie>;

  /**
   * Parameters of the Pie#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Pie$ShowTooltipEventParameters {}

  /**
   * Event object of the Pie#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Pie$ShowTooltipEvent = Event<Pie$ShowTooltipEventParameters, Pie>;
}

declare module "sap/viz/ui5/Scatter" {
  import {
    default as BaseChart,
    $BaseChartSettings,
  } from "sap/viz/ui5/core/BaseChart";

  import Event from "sap/ui/base/Event";

  import Background from "sap/viz/ui5/types/Background";

  import Datalabel from "sap/viz/ui5/types/Datalabel";

  import Datatransform from "sap/viz/ui5/types/Datatransform";

  import RootContainer from "sap/viz/ui5/types/RootContainer";

  import Interaction from "sap/viz/ui5/types/controller/Interaction";

  import Common from "sap/viz/ui5/types/legend/Common";

  import Legend from "sap/viz/ui5/types/Legend";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Scatter1 from "sap/viz/ui5/types/Scatter";

  import Title from "sap/viz/ui5/types/Title";

  import Tooltip from "sap/viz/ui5/types/Tooltip";

  import Axis from "sap/viz/ui5/types/Axis";

  import XYContainer from "sap/viz/ui5/types/XYContainer";

  /**
   * Chart sap.viz.ui5.Scatter
   *
   * @since 1.7.2
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'scatter'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export default class Scatter extends BaseChart {
    /**
     * Constructor for a new sap.viz.ui5.Scatter
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ScatterSettings
    );
    /**
     * Constructor for a new sap.viz.ui5.Scatter
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ScatterSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.Scatter with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.core.BaseChart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Scatter>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.Scatter.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Scatter`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Scatter` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Scatter` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Scatter`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Scatter` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Scatter` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Scatter`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Scatter` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Scatter` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Scatter`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Scatter` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Scatter` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Scatter`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Scatter` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Scatter` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.Scatter`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Scatter` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Scatter` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Scatter`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Scatter` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Scatter` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.Scatter`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Scatter` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Scatter` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Scatter`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Scatter` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Scatter` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Scatter`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.Scatter` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.Scatter` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the background in the aggregation {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyBackground(): this;
    /**
     * Destroys the dataLabel in the aggregation {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataLabel(): this;
    /**
     * Destroys the dataTransform in the aggregation {@link #getDataTransform dataTransform}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataTransform(): this;
    /**
     * Destroys the general in the aggregation {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGeneral(): this;
    /**
     * Destroys the interaction in the aggregation {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInteraction(): this;
    /**
     * Destroys the legend in the aggregation {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegend(): this;
    /**
     * Destroys the legendGroup in the aggregation {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegendGroup(): this;
    /**
     * Destroys the plotArea in the aggregation {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPlotArea(): this;
    /**
     * Destroys the title in the aggregation {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTitle(): this;
    /**
     * Destroys the toolTip in the aggregation {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolTip(): this;
    /**
     * Destroys the xAxis in the aggregation {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXAxis(): this;
    /**
     * Destroys the xyContainer in the aggregation {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXyContainer(): this;
    /**
     * Destroys the yAxis in the aggregation {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.Scatter`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeselectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.Scatter`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHideTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialized initialized} event of this `sap.viz.ui5.Scatter`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialized(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectData selectData} event of this `sap.viz.ui5.Scatter`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.Scatter`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShowTooltip(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:deselectData deselectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeselectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:hideTooltip hideTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHideTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:initialized initialized} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialized(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectData selectData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:showTooltip showTooltip} to attached listeners.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShowTooltip(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getBackground background}.
     *
     * Module sap.viz.modules.background
     */
    getBackground(): Background;
    /**
     * Gets content of aggregation {@link #getDataLabel dataLabel}.
     *
     * Module sap.viz.modules.datalabel
     */
    getDataLabel(): Datalabel;
    /**
     * Gets content of aggregation {@link #getDataTransform dataTransform}.
     *
     * Module sap.viz.modules.datatransform
     */
    getDataTransform(): Datatransform;
    /**
     * Gets content of aggregation {@link #getGeneral general}.
     *
     * Module sap.viz.modules.rootContainer
     */
    getGeneral(): RootContainer;
    /**
     * Gets content of aggregation {@link #getInteraction interaction}.
     *
     * Module sap.viz.modules.controller.interaction
     */
    getInteraction(): Interaction;
    /**
     * Gets content of aggregation {@link #getLegend legend}.
     *
     * Module sap.viz.modules.legend.common
     */
    getLegend(): Common;
    /**
     * Gets content of aggregation {@link #getLegendGroup legendGroup}.
     *
     * Module sap.viz.modules.legend
     */
    getLegendGroup(): Legend;
    /**
     * Gets content of aggregation {@link #getPlotArea plotArea}.
     *
     * Module sap.viz.modules.scatter
     */
    getPlotArea(): Scatter1;
    /**
     * Gets content of aggregation {@link #getTitle title}.
     *
     * Module sap.viz.modules.title
     */
    getTitle(): Title;
    /**
     * Gets content of aggregation {@link #getToolTip toolTip}.
     *
     * Module sap.viz.chart.elements.Tooltip
     */
    getToolTip(): Tooltip;
    /**
     * Gets content of aggregation {@link #getXAxis xAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getXAxis(): Axis;
    /**
     * Gets content of aggregation {@link #getXyContainer xyContainer}.
     *
     * Module sap.viz.modules.xycontainer
     */
    getXyContainer(): XYContainer;
    /**
     * Gets content of aggregation {@link #getYAxis yAxis}.
     *
     * Module sap.viz.modules.axis
     */
    getYAxis(): Axis;
    /**
     * Sets the aggregated {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackground(
      /**
       * The background to set
       */
      oBackground: Background
    ): this;
    /**
     * Sets the aggregated {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabel(
      /**
       * The dataLabel to set
       */
      oDataLabel: Datalabel
    ): this;
    /**
     * Sets the aggregated {@link #getDataTransform dataTransform}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataTransform(
      /**
       * The dataTransform to set
       */
      oDataTransform: Datatransform
    ): this;
    /**
     * Sets the aggregated {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGeneral(
      /**
       * The general to set
       */
      oGeneral: RootContainer
    ): this;
    /**
     * Sets the aggregated {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInteraction(
      /**
       * The interaction to set
       */
      oInteraction: Interaction
    ): this;
    /**
     * Sets the aggregated {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegend(
      /**
       * The legend to set
       */
      oLegend: Common
    ): this;
    /**
     * Sets the aggregated {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendGroup(
      /**
       * The legendGroup to set
       */
      oLegendGroup: Legend
    ): this;
    /**
     * Sets the aggregated {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlotArea(
      /**
       * The plotArea to set
       */
      oPlotArea: Scatter1
    ): this;
    /**
     * Sets the aggregated {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * The title to set
       */
      oTitle: Title
    ): this;
    /**
     * Sets the aggregated {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolTip(
      /**
       * The toolTip to set
       */
      oToolTip: Tooltip
    ): this;
    /**
     * Sets the aggregated {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxis(
      /**
       * The xAxis to set
       */
      oXAxis: Axis
    ): this;
    /**
     * Sets the aggregated {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXyContainer(
      /**
       * The xyContainer to set
       */
      oXyContainer: XYContainer
    ): this;
    /**
     * Sets the aggregated {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis(
      /**
       * The yAxis to set
       */
      oYAxis: Axis
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Scatter constructor.
   *
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'scatter'})`) **control to benefit from new charting enhancements
   * and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export interface $ScatterSettings extends $BaseChartSettings {
    /**
     * Module sap.viz.modules.rootContainer
     */
    general?: RootContainer;

    /**
     * Module sap.viz.modules.title
     */
    title?: Title;

    /**
     * Module sap.viz.modules.legend
     */
    legendGroup?: Legend;

    /**
     * Module sap.viz.modules.legend.common
     */
    legend?: Common;

    /**
     * Module sap.viz.modules.xycontainer
     */
    xyContainer?: XYContainer;

    /**
     * Module sap.viz.modules.datalabel
     */
    dataLabel?: Datalabel;

    /**
     * Module sap.viz.modules.axis
     */
    xAxis?: Axis;

    /**
     * Module sap.viz.modules.axis
     */
    yAxis?: Axis;

    /**
     * Module sap.viz.modules.background
     */
    background?: Background;

    /**
     * Module sap.viz.modules.scatter
     */
    plotArea?: Scatter1;

    /**
     * Module sap.viz.chart.elements.Tooltip
     */
    toolTip?: Tooltip;

    /**
     * Module sap.viz.modules.controller.interaction
     */
    interaction?: Interaction;

    /**
     * Module sap.viz.modules.datatransform
     */
    dataTransform?: Datatransform;

    /**
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     */
    selectData?: (oEvent: Event) => void;

    /**
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     */
    deselectData?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    showTooltip?: (oEvent: Event) => void;

    /**
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     */
    hideTooltip?: (oEvent: Event) => void;

    /**
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     */
    initialized?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Scatter#deselectData event.
   */
  export interface Scatter$DeselectDataEventParameters {}

  /**
   * Event object of the Scatter#deselectData event.
   */
  export type Scatter$DeselectDataEvent = Event<
    Scatter$DeselectDataEventParameters,
    Scatter
  >;

  /**
   * Parameters of the Scatter#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Scatter$HideTooltipEventParameters {}

  /**
   * Event object of the Scatter#hideTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Scatter$HideTooltipEvent = Event<
    Scatter$HideTooltipEventParameters,
    Scatter
  >;

  /**
   * Parameters of the Scatter#initialized event.
   */
  export interface Scatter$InitializedEventParameters {}

  /**
   * Event object of the Scatter#initialized event.
   */
  export type Scatter$InitializedEvent = Event<
    Scatter$InitializedEventParameters,
    Scatter
  >;

  /**
   * Parameters of the Scatter#selectData event.
   */
  export interface Scatter$SelectDataEventParameters {}

  /**
   * Event object of the Scatter#selectData event.
   */
  export type Scatter$SelectDataEvent = Event<
    Scatter$SelectDataEventParameters,
    Scatter
  >;

  /**
   * Parameters of the Scatter#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export interface Scatter$ShowTooltipEventParameters {}

  /**
   * Event object of the Scatter#showTooltip event.
   *
   * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
   * SAPUI5 delivery in one of the next releases.
   */
  export type Scatter$ShowTooltipEvent = Event<
    Scatter$ShowTooltipEventParameters,
    Scatter
  >;
}

declare module "sap/viz/ui5/StackedColumn" {
  import {
    default as BaseChart,
    $BaseChartSettings,
  } from "sap/viz/ui5/core/BaseChart";

  import Event from "sap/ui/base/Event";

  import Background from "sap/viz/ui5/types/Background";

  import Datalabel from "sap/viz/ui5/types/Datalabel";

  import RootContainer from "sap/viz/ui5/types/RootContainer";

  import Interaction from "sap/viz/ui5/types/controller/Interaction";

  import Common from "sap/viz/ui5/types/legend/Common";

  import Legend from "sap/viz/ui5/types/Legend";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import StackedVerticalBar from "sap/viz/ui5/types/StackedVerticalBar";

  import Title from "sap/viz/ui5/types/Title";

  import Tooltip from "sap/viz/ui5/types/Tooltip";

  import Axis from "sap/viz/ui5/types/Axis";

  import XYContainer from "sap/viz/ui5/types/XYContainer";

  /**
   * Chart sap.viz.ui5.StackedColumn
   *
   * @since 1.7.2
   * @deprecated (since 1.32.0) - The chart controls in the `sap.viz.ui5` package (which were always marked
   * as experimental) have been deprecated since 1.32.0. They are no longer actively developed and
   * won't receive new features or improvements, only important bug fixes. They will only remain in the SAPUI5
   * distribution for backward compatibility.
   *
   * **SAP strongly recommends that existing consumers of those controls migrate to the new {@link sap.viz.ui5.controls.VizFrame VizFrame}**(`new
   * sap.viz.ui5.controls.VizFrame({'vizType': 'stacked_column'})`) **control to benefit from new charting
   * enhancements and timely support. **
   *
   * **Note**: As the feature set, design and API usage of VizFrame might differ from the old chart controls,
   * make sure you evaluate it thoroughly before migration.
   * @experimental (since 1.7.2) - Charting API is not finished yet and might change completely.
   */
  export default class StackedColumn extends BaseChart {
    /**
     * Constructor for a new sap.viz.ui5.StackedColumn
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $StackedColumnSettings
    );
    /**
     * Constructor for a new sap.viz.ui5.StackedColumn
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $StackedColumnSettings
    );

    /**
     * Creates a new subclass of class sap.viz.ui5.StackedColumn with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.viz.ui5.core.BaseChart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, StackedColumn>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.viz.ui5.StackedColumn.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.StackedColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.StackedColumn` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.StackedColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.StackedColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.StackedColumn` itself.
     *
     * Event fires when certain data point(s) is(are) deselected, data context of deselected item(s) would be
     * passed in accordance with the following format.{name: "deselectData",data:["---the same as selectedData---"]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeselectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.StackedColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.StackedColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.StackedColumn` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.StackedColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.StackedColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.StackedColumn` itself.
     *
     * This event is deprecated, please use hideDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover out of the specific part of chart, no data is passed.
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHideTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.StackedColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.StackedColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.StackedColumn` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.StackedColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.viz.ui5.StackedColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.StackedColumn` itself.
     *
     * Event fires when the loading ends. To use the event listener when creating charts, you must use an event
     * that is passed by the events option. For more information on events options, see the usrOptions section
     * of the createViz function in the API document.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.StackedColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.StackedColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.StackedColumn` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.StackedColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectData selectData} event of this `sap.viz.ui5.StackedColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.StackedColumn` itself.
     *
     * Event fires when certain data point(s) is(are) selected, data context of selected item(s) would be passed
     * in accordance with the following format.{name: "selectData",data:[{ //selected element's detail
     * target:"Dom Element",//an object pointed to corresponding dom element data:[{val: "...",//value of this
     * element ctx:{type:"Dimension"||"Measure"||"MND", //for Dimension path:{aa:"...",di:"...",dii:"..."},
     * //for Measure path:{mg:"...",mi:"...",dii_a1:"...",dii_a2:"..."}, //for MND path:{mg:"...",mi:"..." }
     * //path: analysis path //aa: analysis axis index // 0 for analysis axis 1, 1 for analysis 2 //di: dimension
     * index //zero based //dii: dimension item index //zero based //mg: measure group index // 0 for measure
     * group 1,1 for measure group 2 //mi: measure index // measure index in measure group zero based //dii_a1:
     * each dii of di in analysis axis 1 index //dii_a2: each dii of di in analysis axis 2 index }},{ //for
     * bubble, tagcloud and scatter, there will be more than one values in one selected element. var:"...",ctx:"..."}]},{
     * //if under multi selection, there will be more than one selected elements target:"...",data:["..."]}]}
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.StackedColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.StackedColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.StackedColumn` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.StackedColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showTooltip showTooltip} event of this `sap.viz.ui5.StackedColumn`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.viz.ui5.StackedColumn` itself.
     *
     * This event is deprecated, please use showDetail decoration (refer to properties: interaction.decorations)
     * instead. Event fires when the mouse hover onto the specific part of chart, data context of tooltip would
     * be passed in accordance with the following format.{name:"showTooltip",data:{body:[{ //All measures
     * name:"...",val:[{//measure value is an array containing only one item value:"..."}]},"..."],footer:[{label:"...",value:"..."},"..."],plotArea:{
     * //this object specifies the plot area of the chart height:"...",width:"...",x:"...",y:"..."},point:{
     * //this object specifies a point which affects the position of tooltip x:"...",y:"..."},selectedValues:...//this
     * number specify how many values are selected}}
     *
     * @deprecated (since 1.19) - This Property has been deprecated. This interface will be removed from the
     * SAPUI5 delivery in one of the next releases.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowTooltip(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.viz.ui5.StackedColumn` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the background in the aggregation {@link #getBackground background}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyBackground(): this;
    /**
     * Destroys the dataLabel in the aggregation {@link #getDataLabel dataLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDataLabel(): this;
    /**
     * Destroys the general in the aggregation {@link #getGeneral general}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGeneral(): this;
    /**
     * Destroys the interaction in the aggregation {@link #getInteraction interaction}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInteraction(): this;
    /**
     * Destroys the legend in the aggregation {@link #getLegend legend}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegend(): this;
    /**
     * Destroys the legendGroup in the aggregation {@link #getLegendGroup legendGroup}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegendGroup(): this;
    /**
     * Destroys the plotArea in the aggregation {@link #getPlotArea plotArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPlotArea(): this;
    /**
     * Destroys the title in the aggregation {@link #getTitle title}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTitle(): this;
    /**
     * Destroys the toolTip in the aggregation {@link #getToolTip toolTip}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolTip(): this;
    /**
     * Destroys the xAxis in the aggregation {@link #getXAxis xAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXAxis(): this;
    /**
     * Destroys the xyContainer in the aggregation {@link #getXyContainer xyContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyXyContainer(): this;
    /**
     * Destroys the yAxis in the aggregation {@link #getYAxis yAxis}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyYAxis(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deselectData deselectData} event of this `sap.viz.ui5.StackedColumn`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeselectData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:hideTooltip hideTooltip} event of this `sap.viz.ui5.StackedColumn`.
     *
     * The 