import jsonMap from "json-source-map";
export function parseManifest(manifest) {
    const json = jsonMap.parse(manifest);
    const data = json.data;
    const pointers = json.pointers;
    return { data, pointers };
}
function findAdjacentPropertyPointer(pointers, targetPointer, targetKey, direction) {
    const parentKey = targetKey.substring(0, targetKey.lastIndexOf("/") + 1);
    const targetPos = targetPointer.value.pos;
    let bestPointer;
    let bestPos = direction === "previous" ? -1 : Infinity;
    for (const [key, pointer] of Object.entries(pointers)) {
        if (key === targetKey) {
            continue; // Skip the target key itself
        }
        if (!key.startsWith(parentKey)) {
            continue; // Skip keys that are not direct children of the same parent
        }
        // Check if it's a sibling property (same parent, no additional nesting)
        const keyWithoutParent = key.substring(parentKey.length);
        if (keyWithoutParent.includes("/")) {
            continue; // Skip nested properties
        }
        if ((direction === "previous" && pointer.value.pos < targetPos && pointer.value.pos > bestPos) ||
            (direction === "next" && pointer.value.pos > targetPos && pointer.value.pos < bestPos)) {
            bestPos = pointer.value.pos;
            bestPointer = pointer;
        }
    }
    return bestPointer;
}
export function getPreviousPropertyPointer(pointers, targetPointer, targetKey) {
    return findAdjacentPropertyPointer(pointers, targetPointer, targetKey, "previous");
}
export function getNextPropertyPointer(pointers, targetPointer, targetKey) {
    return findAdjacentPropertyPointer(pointers, targetPointer, targetKey, "next");
}
//# sourceMappingURL=parser.js.map