export type Namespace = string;
export interface NamespaceDeclaration {
    localName: string | null;
    namespace: Namespace;
}
export declare const enum NodeKind {
    Unknown = 0,
    Control = 1,
    Aggregation = 2,
    FragmentDefinition = 4,
    Template = 8,
    Xhtml = 16,// Should generally be ignored
    Svg = 32
}
export interface Position {
    line: number;
    column: number;
}
export interface NodeDeclaration {
    kind: NodeKind;
    name: string;
    namespace: Namespace;
    start: Position;
    end: Position;
}
export interface ControlDeclaration extends NodeDeclaration {
    kind: NodeKind.Control;
    properties: Set<PropertyDeclaration>;
    aggregations: Map<string, AggregationDeclaration>;
    variableName?: string;
}
export interface AggregationDeclaration extends NodeDeclaration {
    kind: NodeKind.Aggregation;
    owner: ControlDeclaration;
    controls: ControlDeclaration[];
}
export interface FragmentDefinitionDeclaration extends NodeDeclaration {
    kind: NodeKind.FragmentDefinition;
    controls: Set<ControlDeclaration>;
}
export interface AttributeDeclaration {
    name: string;
    value: string;
    localNamespace?: string;
    start: Position;
    end: Position;
}
export type PropertyDeclaration = AttributeDeclaration;
export interface RequireExpression extends AttributeDeclaration {
    declarations: RequireDeclaration[];
}
export interface RequireDeclaration {
    moduleName?: string;
    variableName: string;
}
export interface NamespaceStackEntry {
    namespace: NamespaceDeclaration;
    level: number;
}
