import { lintProject } from "./linter/linter.js";
import SharedLanguageService from "./linter/ui5Types/SharedLanguageService.js";
export async function ui5lint(options) {
    return new UI5LinterEngine().lint(options);
}
export class UI5LinterEngine {
    sharedLanguageService = new SharedLanguageService();
    lintingInProgress = false;
    async lint(options) {
        if (this.lintingInProgress) {
            throw new Error("Linting is already in progress");
        }
        this.lintingInProgress = true;
        const { filePatterns, ignorePatterns = [], details = false, fix = false, config, noConfig, coverage = false, ui5Config, rootDir = process.cwd(), } = options ?? {};
        try {
            return await lintProject({
                rootDir,
                filePatterns,
                ignorePatterns,
                coverage,
                details,
                fix,
                configPath: config,
                noConfig,
                ui5Config,
            }, this.sharedLanguageService);
        }
        finally {
            // Ensure that the flag is reset even if an error occurs
            this.lintingInProgress = false;
        }
    }
}
//# sourceMappingURL=index.js.map