export default BindingParser;
declare namespace BindingParser {
    function simpleParser(sString: any, ...args: any[]): object | undefined;
    namespace simpleParser {
        function escape(sValue: any): any;
    }
    function complexParser(sString: any, oContext: any, bUnescape: any, bTolerateFunctionsNotFound: any, bStaticContext: any, bPreferContext: any, mLocals: any, bResolveTypesAsync: any, mAdditionalBindableValues: any): string | {
        parts: never[];
    } | {
        bindingInfo: {
            parts: never[];
        };
        resolved: Promise<unknown[] | []>;
        wait: boolean;
    } | {
        bindingInfo: string;
        resolved: Promise<void>;
        wait?: undefined;
    } | undefined;
    namespace complexParser {
        function escape(sValue: any): any;
    }
    /**
     * Merges the given binding info object's parts, which may have parts themselves, into a flat
     * list of parts, taking care of existing formatter functions. If the given binding info does
     * not have a root formatter, <code>Array.prototype.join(., " ")</code> is used instead.
     * Parts which are not binding info objects are also supported; they are removed from the
     * "parts" array and taken care of by the new root-level formatter function, which feeds them
     * into the old formatter function at the right place.
     *
     * Note: Truly hierarchical composite bindings are not yet supported. This method deals with a
     * special case of a two-level hierarchy which can be turned into a one-level hierarchy. The
     * precondition is that the parts which have parts themselves are not too complex, i.e. must
     * have no other properties than "formatter" and "parts". A missing formatter on that level
     * is replaced with the default <code>Array.prototype.join(., " ")</code>.
     *
     * @param {object} oBindingInfo
     *   a binding info object with a possibly empty array of parts and a new formatter function
     * @throws {Error}
     *   in case precondition is not met
     * @private
     */
    function mergeParts(oBindingInfo: object): void;
    /**
     * Parses a string <code>sInput</code> with an expression. The input string is parsed starting
     * at the index <code>iStart</code> and the return value contains the index after the last
     * character belonging to the expression.
     *
     * @param {string} sInput
     *   the string to be parsed
     * @param {int} iStart
     *   the index to start parsing
     * @param {object} [oEnv]
     *   the "environment" (see resolveEmbeddedBinding function for details)
     * @param {object} [mLocals]
     *   variables allowed in the expression as map of variable name to value
     * @returns {object}
     *   the parse result with the following properties
     *   <ul>
     *    <li><code>result</code>: the binding info as an object with the properties
     *     <code>formatter</code> (the formatter function to evaluate the expression) and
     *     <code>parts</code> (an array of the referenced bindings)</li>
     *    <li><code>at</code>: the index of the first character after the expression in
     *     <code>sInput</code></li>
     *   </ul>
     * @throws SyntaxError
     *   If the expression string is invalid or unsupported. The at property of
     *   the error contains the position where parsing failed.
     * @private
     */
    function parseExpression(sInput: string, iStart: int, oEnv?: object, mLocals?: object): object;
}
