import { Ui5TypeInfoKind, } from "./Ui5TypeInfo.js";
// Re-export selected interfaces as public API
export { Ui5TypeInfoKind, };
export default class Ui5TypeInfoMatcher {
    libraryName;
    rootModules = new Map();
    rootNamespaces = new Map();
    constructor(libraryName) {
        this.libraryName = libraryName;
    }
    getLibraryName() {
        return this.libraryName;
    }
    match(ui5TypeInfo) {
        let filterStack = [];
        let node = ui5TypeInfo;
        while (node) {
            filterStack.push(node);
            if (node.kind === Ui5TypeInfoKind.Module) {
                break;
            }
            node = node.parent;
        }
        filterStack = filterStack.reverse();
        const rootTypeInfo = filterStack[0];
        let rootNode;
        if (rootTypeInfo.kind === Ui5TypeInfoKind.Module) {
            if (!this.libraryName || rootTypeInfo.library !== this.libraryName) {
                return;
            }
            rootNode = this.rootModules.get(rootTypeInfo.name);
        }
        else if (rootTypeInfo.kind === Ui5TypeInfoKind.Namespace) {
            rootNode = this.rootNamespaces.get(rootTypeInfo.name);
        }
        else {
            throw new Error(`Provided UI5 Type Info has an unexpected kind of root node`);
        }
        if (!rootNode) {
            return;
        }
        let matchedNode = rootNode;
        for (let i = 1; i < filterStack.length; i++) {
            const childNode = this.findChildNode(matchedNode, filterStack[i]);
            if (!childNode) {
                return; // No match
            }
            matchedNode = childNode;
        }
        return matchedNode.value;
    }
    findChildNode(node, typeInfo) {
        if (!node.children || !("name" in typeInfo)) {
            return;
        }
        for (const child of node.children) {
            if (child.kind === typeInfo.kind && child.name === typeInfo.name) {
                return child;
            }
        }
    }
    declareModule(moduleName, children, value) {
        this.rootModules.set(moduleName, this.createModule(moduleName, children, value));
    }
    declareModules(moduleNames, children, value) {
        for (const entityName of moduleNames) {
            this.rootModules.set(entityName, this.createModule(entityName, children, value));
        }
    }
    createModule(name, children, value) {
        if (!this.libraryName) {
            throw new Error("Library name must be defined to create a module node");
        }
        const moduleNode = this.createNode(Ui5TypeInfoKind.Module, name, children, value);
        moduleNode.library = this.libraryName;
        return moduleNode;
    }
    declareNamespace(namespace, children, value) {
        this.rootNamespaces.set(namespace, this.namespace(namespace, children, value));
    }
    declareNamespaces(namespaces, children, value) {
        for (const moduleName of namespaces) {
            this.rootNamespaces.set(moduleName, this.namespace(moduleName, children, value));
        }
    }
    namespace(name, children, value) {
        return this.createNode(Ui5TypeInfoKind.Namespace, name, children, value);
    }
    namespaces(names, children, value) {
        return names.map((name) => {
            return this.createNode(Ui5TypeInfoKind.Namespace, name, children, value);
        });
    }
    class(name, children, value) {
        return this.createNode(Ui5TypeInfoKind.Class, name, children, value);
    }
    classes(names, children, value) {
        return names.map((name) => {
            return this.createNode(Ui5TypeInfoKind.Class, name, children, value);
        });
    }
    constr(children, value) {
        return this.createNode(Ui5TypeInfoKind.Constructor, "constructor", children, value);
    }
    constuctorParameter(name, children, value) {
        return this.createNode(Ui5TypeInfoKind.ConstructorParameter, name, children, value);
    }
    constructorParameters(names, children, value) {
        return names.map((name) => {
            return this.createNode(Ui5TypeInfoKind.ConstructorParameter, name, children, value);
        });
    }
    method(name, children, value) {
        return this.createNode(Ui5TypeInfoKind.Method, name, children, value);
    }
    methods(names, children, value) {
        return names.map((name) => {
            return this.createNode(Ui5TypeInfoKind.Method, name, children, value);
        });
    }
    staticMethod(name, children, value) {
        return this.createNode(Ui5TypeInfoKind.StaticMethod, name, children, value);
    }
    staticMethods(names, children, value) {
        return names.map((name) => {
            return this.createNode(Ui5TypeInfoKind.StaticMethod, name, children, value);
        });
    }
    property(name, children, value) {
        return this.createNode(Ui5TypeInfoKind.Property, name, children, value);
    }
    properties(names, children, value) {
        return names.map((name) => {
            return this.createNode(Ui5TypeInfoKind.Property, name, children, value);
        });
    }
    function(name, children, value) {
        return this.createNode(Ui5TypeInfoKind.Function, name, children, value);
    }
    functions(names, children, value) {
        return names.map((name) => {
            return this.createNode(Ui5TypeInfoKind.Function, name, children, value);
        });
    }
    managedObjectSetting(name, children, value) {
        return this.createNode(Ui5TypeInfoKind.ManagedObjectSettings, name, children, value);
    }
    managedObjectSettings(names, children, value) {
        return names.map((name) => {
            return this.createNode(Ui5TypeInfoKind.ManagedObjectSettings, name, children, value);
        });
    }
    metadataEvent(name, children, value) {
        return this.createNode(Ui5TypeInfoKind.MetadataEvent, name, children, value);
    }
    metadataEvents(names, children, value) {
        return names.map((name) => {
            return this.createNode(Ui5TypeInfoKind.MetadataEvent, name, children, value);
        });
    }
    metadataProperty(name, children, value) {
        return this.createNode(Ui5TypeInfoKind.MetadataProperty, name, children, value);
    }
    metadataProperties(names, children, value) {
        return names.map((name) => {
            return this.createNode(Ui5TypeInfoKind.MetadataProperty, name, children, value);
        });
    }
    metadataAggregation(name, children, value) {
        return this.createNode(Ui5TypeInfoKind.MetadataAggregation, name, children, value);
    }
    metadataAggregations(names, children, value) {
        return names.map((name) => {
            return this.createNode(Ui5TypeInfoKind.MetadataAggregation, name, children, value);
        });
    }
    metadataAssociation(name, children, value) {
        return this.createNode(Ui5TypeInfoKind.MetadataAssociation, name, children, value);
    }
    metadataAssociations(names, children, value) {
        return names.map((name) => {
            return this.createNode(Ui5TypeInfoKind.MetadataAssociation, name, children, value);
        });
    }
    enum(name, children, value) {
        return this.createNode(Ui5TypeInfoKind.Enum, name, children, value);
    }
    enums(names, children, value) {
        return names.map((name) => {
            return this.createNode(Ui5TypeInfoKind.Enum, name, children, value);
        });
    }
    enumMember(name, children, value) {
        return this.createNode(Ui5TypeInfoKind.EnumMember, name, children, value);
    }
    enumMembers(names, children, value) {
        return names.map((name) => {
            return this.createNode(Ui5TypeInfoKind.EnumMember, name, children, value);
        });
    }
    export(children, value) {
        return this.createNode(Ui5TypeInfoKind.Export, "export", children, value);
    }
    createNode(kind, name, children, value) {
        if (!Array.isArray(children)) {
            value = children;
            children = undefined;
        }
        return {
            kind,
            name,
            value,
            children,
        };
    }
}
//# sourceMappingURL=Ui5TypeInfoMatcher.js.map