import ts from "typescript";
import { PositionInfo } from "../../LinterContext.js";
import Fix from "./Fix.js";
export interface ObsoleteImportFixParams {
    moduleName: string;
}
export default class ObsoleteImportFix extends Fix {
    private params;
    private sourcePosition;
    constructor(params: ObsoleteImportFixParams);
    visitLinterNode(node: ts.Node, sourcePosition: PositionInfo): boolean;
    getNodeSearchParameters(): {
        nodeTypes: ts.SyntaxKind[];
        position: PositionInfo;
    };
    visitAutofixNode(_node: ts.Node, _position: number, _sourceFile: ts.SourceFile): boolean;
    getObsoleteModuleDependencies(): {
        moduleName: string;
        usagePosition: number;
    };
}
