import ts from "typescript";
import { ChangeSet } from "../../../utils/textChanges.js";
import { PositionInfo } from "../../LinterContext.js";
import { FixHelpers } from "./Fix.js";
import PropertyAssignmentBaseFix from "./PropertyAssignmentBaseFix.js";
import { Attribute, Position } from "sax-wasm";
export interface PropertyAssignmentGeneratorFixParams<GeneratorContext extends object> {
    /**
     * Validate the property assignment, optionally using the checker provided in the fix helpers.
     *
     * This hook may also collect information that affects the generator. For that, it can store
     * information in the provided context object, which can be retrieved later in the generator function
     */
    validatePropertyAssignment?: (ctx: GeneratorContext, helpers: FixHelpers, propertyAssignment: ts.PropertyAssignment) => boolean;
    /**
     * The generator function will be used to determine the value of the replacement, affecting
     * the whole call expression
     *
     * If the return value is undefined, no change will be generated.
     *
     * @param ctx - The context object that can be used to store information between validation and generation
     * @param propertyName -
     * 	The name of the property that is being accessed, as a string representation of the source code,
     * @param propertyInitializer -
     * 	The initializer of the property assignment, as a string representation of the source code.
     */
    generator: (ctx: GeneratorContext, propertyName: string, propertyInitializer: string) => string | undefined;
}
/**
 * Fix a global property access. Requires a module name which will be imported and replaces the defined property access.
 * The property access is in the order of the AST, e.g. ["core", "ui", "sap"]
 */
export default class PropertyAssignmentGeneratorFix<GeneratorContext extends object> extends PropertyAssignmentBaseFix {
    private params;
    protected generatorContext: GeneratorContext;
    protected propertyName: string | undefined;
    protected propertyInitializer: string | undefined;
    constructor(params: PropertyAssignmentGeneratorFixParams<GeneratorContext>);
    visitLinterNode(node: ts.Node, sourcePosition: PositionInfo, helpers: FixHelpers): boolean;
    visitAutofixNode(node: ts.Node, position: number, sourceFile: ts.SourceFile): boolean;
    visitAutofixXmlNode(node: Attribute, toPosition: (pos: Position) => number): boolean;
    generateChanges(): ChangeSet | ChangeSet[] | undefined;
}
