import LinterContext, { PositionInfo } from "../LinterContext.js";
import { TranspileResult } from "../LinterContext.js";
import { ApiExtract } from "../../utils/ApiExtract.js";
import ControllerByIdInfo from "./ControllerByIdInfo.js";
import { Tag as SaxTag, Text as SaxText } from "sax-wasm";
import { AggregationDeclaration, AttributeDeclaration, ControlDeclaration, FragmentDefinitionDeclaration, Namespace, NamespaceDeclaration, NodeDeclaration, RequireDeclaration } from "./xmlNodes.js";
export default class Parser {
    #private;
    constructor(resourcePath: string, apiExtract: ApiExtract, context: LinterContext, controllerByIdInfo: ControllerByIdInfo);
    pushTag(tag: SaxTag): void;
    popTag(_tag: SaxTag): void;
    parseComment(comment: SaxText): void;
    generate(): TranspileResult;
    _findParentNode(kindFilter: number): NodeDeclaration | null;
    _addNamespace(namespace: NamespaceDeclaration, level: number): void;
    _resolveNamespace(localName: string | null): Namespace | undefined;
    _removeNamespacesForLevel(level: number): void;
    _addDefaultAggregation(owner: ControlDeclaration, control: ControlDeclaration): void;
    _parseRequireAttribute(attrValue: string): RequireDeclaration[];
    _createNode(tag: SaxTag): NodeDeclaration;
    _controllerName: string | undefined;
    _handleUi5LibraryNamespace(moduleName: string, namespace: Namespace, attributes: Map<string, AttributeDeclaration>, tag: SaxTag): ControlDeclaration | AggregationDeclaration | FragmentDefinitionDeclaration;
    _handleTemplatingNamespace(tagName: string, namespace: Namespace, attributes: Map<string, AttributeDeclaration>, tag: SaxTag): NodeDeclaration;
    _checkGlobalReference(value: string, { line, column }: PositionInfo): void;
}
