// For Library Version: 1.136.7

declare module "sap/fe/macros/Chart" {
  import {
    default as MacroAPI,
    $MacroAPISettings,
  } from "sap/fe/macros/MacroAPI";

  import PresentationVariant from "sap/fe/navigation/PresentationVariant";

  import Context from "sap/ui/model/odata/v4/Context";

  import SelectionVariant from "sap/fe/navigation/SelectionVariant";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import ActionGroup from "sap/fe/macros/chart/ActionGroup";

  import Action from "sap/fe/macros/chart/Action";

  import Event from "sap/ui/base/Event";

  /**
   * Building block used to create a chart based on the metadata provided by OData V4.
   * {@link demo:sap/fe/core/fpmExplorer/index.html#/buildingBlocks/chart/chartDefault Overview of Building Blocks}
   *
   *
   * Usually, a contextPath and metaPath is expected.
   *
   * Usage example:
   *
   * ```javascript
   *
   * <macros:Chart id="MyChart" contextPath="/RootEntity" metaPath="@com.sap.vocabularies.UI.v1.Chart" />
   * ```
   */
  export default class Chart
    extends MacroAPI
    implements
      /* was: sap.fe.core.controllerextensions.viewState.IViewStateContributor */ Object
  {
    __implements__sap_fe_core_controllerextensions_viewState_IViewStateContributor: boolean;

    /**
     * Gets current value of property contextPath.
     *
     *
     * @returns Value of property `contextPath`
     */
    getContextPath(): string;
    /**
     * Gets the key of the current variant in the associated variant management.
     *
     *
     * @returns Variant key of {@link sap.ui.fl.variants.VariantManagement } applied to the chart
     */
    getCurrentVariantKey(): null | string;
    /**
     * Gets current value of property filterBar.
     *
     *
     * @returns Value of property `filterBar`
     */
    getFilterBar(): string;
    /**
     * Gets current value of property header.
     *
     *
     * @returns Value of property `header`
     */
    getHeader(): string;
    /**
     * Gets current value of property headerVisible.
     *
     *
     * @returns Value of property `headerVisible`
     */
    getHeaderVisible(): boolean;
    /**
     * Gets current value of property metaPath.
     *
     *
     * @returns Value of property `metaPath`
     */
    getMetaPath(): string;
    /**
     * Gets current value of property personalization.
     *
     *
     * @returns Value of property `personalization`
     */
    getPersonalization(): string;
    /**
     * Get the presentation variant that is currently applied on the chart.
     *
     *
     * @returns The presentation variant {@link sap.fe.navigation.PresentationVariant } applied to the chart
     */
    getPresentationVariant(): Promise<PresentationVariant>;
    /**
     * Gets contexts from the chart that have been selected by the user.
     *
     *
     * @returns Contexts of the rows selected by the user
     */
    getSelectedContexts(): Context[];
    /**
     * Gets current value of property selectionMode.
     *
     *
     * @returns Value of property `selectionMode`
     */
    getSelectionMode(): string;
    /**
     * Get the selection variant from the chart. This function considers only the selection variant applied
     * at the control level.
     *
     *
     * @returns A promise that resolves with {@link sap.fe.navigation.SelectionVariant }.
     */
    getSelectionVariant(): Promise<SelectionVariant>;
    /**
     * Gets current value of property variantManagement.
     *
     *
     * @returns Value of property `variantManagement`
     */
    getVariantManagement(): string;
    /**
     * Gets current value of property contextPath.
     *
     *
     * @returns Value of property `contextPath`
     */
    setContextPath(): string;
    /**
     * Sets the variant of the provided key in the associated variant management.
     */
    setCurrentVariantKey(
      /**
       * The variant key of {@link sap.ui.fl.variants.VariantManagement } to be set
       */
      key: string
    ): void;
    /**
     * Gets current value of property filterBar.
     *
     *
     * @returns Value of property `filterBar`
     */
    setFilterBar(): string;
    /**
     * Gets current value of property header.
     *
     *
     * @returns Value of property `header`
     */
    setHeader(): string;
    /**
     * Gets current value of property headerVisible.
     *
     *
     * @returns Value of property `headerVisible`
     */
    setHeaderVisible(): boolean;
    /**
     * Gets current value of property metaPath.
     *
     *
     * @returns Value of property `metaPath`
     */
    setMetaPath(): string;
    /**
     * Gets current value of property personalization.
     *
     *
     * @returns Value of property `personalization`
     */
    setPersonalization(): string;
    /**
     * Set the presentation variant for the mdc chart.
     * The json format retrieved by using the get PresentationVariant button in the linked FPM sample should
     * be followed while trying to set the PresentationVariant as needed.
     * The values dimensions, measures and other properties should also be given in the valid format and null
     * or empty values should be avoided.
     * One dimension attribute should have only one role associated with it on a given chart.
     */
    setPresentationVariant(
      /**
       * the presentation variant {@link sap.fe.navigation.PresentationVariant } to be set
       */
      presentationVariant: PresentationVariant
    ): Promise<void>;
    /**
     * Gets current value of property selectionMode.
     *
     *
     * @returns Value of property `selectionMode`
     */
    setSelectionMode(): string;
    /**
     * Sets {@link sap.fe.navigation.SelectionVariant } to the chart. Note: setSelectionVariant will clear existing
     * filters and then apply the SelectionVariant values.
     *
     *
     * @returns A promise for asynchronous handling
     */
    setSelectionVariant(
      /**
       * The {@link sap.fe.navigation.SelectionVariant } to apply to the chart
       */
      selectionVariant: SelectionVariant,
      /**
       * Optional. If true, we will use the associated text property values (if they're available in the SelectionVariant)
       * to display the filter value descriptions, instead of loading them from the backend
       */
      prefillDescriptions?: boolean
    ): Promise<any>;
    /**
     * Gets current value of property variantManagement.
     *
     *
     * @returns Value of property `variantManagement`
     */
    setVariantManagement(): string;
  }
  /**
   * Describes the settings that can be provided to the Chart constructor.
   */
  export interface $ChartSettings extends $MacroAPISettings {
    /**
     * Metadata path to the entitySet or navigationProperty
     */
    contextPath?: string | PropertyBindingInfo;

    /**
     * Id of the FilterBar building block associated with the chart.
     */
    filterBar?: string | PropertyBindingInfo;

    /**
     * Specifies the header text that is shown in the chart
     */
    header?: string | PropertyBindingInfo;

    /**
     * Controls if the header text should be shown or not
     */
    headerVisible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Metadata path to the presentation context (UI.Chart with or without a qualifier)
     */
    metaPath?: string | PropertyBindingInfo;

    /**
     * Controls which options should be enabled for the chart personalization dialog.
     * If it is set to `true`, all possible options for this kind of chart are enabled.
     *
     * If it is set to `false`, personalization is disabled.
     *
     *
     *
     * You can also provide a more granular control for the personalization by providing a comma-separated list
     * with the options you want to be available.
     *
     * Available options are:
     *
     * - Sort
     *
     * - Type
     *
     * - Item
     *
     * - Filter
     */
    personalization?: string | PropertyBindingInfo;

    /**
     * Defines the selection mode to be used by the chart.
     * Allowed values are `None`, `Single` or `Multiple`
     */
    selectionMode?: string | PropertyBindingInfo;

    /**
     * Controls the kind of variant management that should be enabled for the chart.
     * Allowed value is `Control`.
     *
     * If set with value `Control`, a variant management control is seen within the chart and the chart is linked
     * to this.
     *
     * If not set with any value, variant management control is not available for this chart.
     */
    variantManagement?: string | PropertyBindingInfo;

    /**
     * Aggregate actions of the chart.
     */
    actions?:
      | Array<ActionGroup | Action>
      | ActionGroup
      | Action
      | AggregationBindingInfo
      | `{${string}}`;
  }

  /**
   * Parameters of the Chart#selectionChange event.
   */
  export interface Chart$SelectionChangeEventParameters {}

  /**
   * Event object of the Chart#selectionChange event.
   */
  export type Chart$SelectionChangeEvent = Event<
    Chart$SelectionChangeEventParameters,
    Chart
  >;
}

declare module "sap/fe/macros/CollectionBindingInfo" {
  import Filter from "sap/ui/model/Filter";

  import Sorter from "sap/ui/model/Sorter";

  /**
   * API to add parameters to the collection binding infos.
   */
  export default class CollectionBindingInfo {
    /**
     * Adds a filter to the filters already present in the binding info.
     */
    addFilter(
      /**
       * The {@link sap.ui.model.Filter "filter"} to add
       */
      customFilter: Filter
    ): void;
    /**
     * Adds parameters to the select query.
     */
    addSelect(
      /**
       * The list or properties to add to the query
       */
      parameters: string[]
    ): void;
    /**
     * Adds a sorter to the sorter(s) already present, or create one if none exists.
     */
    addSorter(
      /**
       * The {@link sap.ui.model.Sorter "sorter"} to add to the query
       */
      sorter: Sorter
    ): void;
    /**
     * Retrieve the 'serialized' binding info, useful if you want to create your own binding
     *
     *
     * @returns The {@link sap.fe.macros.CollectionBindingInfo "CollectionBindingInfo"}
     */
    getBindingInfo(): /* was: sap.fe.macros.CollectionBindingInfo.CollectionBindingInfo */ any;
    /**
     * Returns the current filters applied to the Table.
     *
     *
     * @returns The {@link sap.ui.model.Filter "filters"} on the table
     */
    getFilters(): Filter | undefined;
    /**
     * Returns the current sorters of the Table.
     *
     *
     * @returns The {@link sap.ui.model.Sorter "sorters"} on the table
     */
    getSorters(): Sorter[] | undefined;
  }
}

declare module "sap/fe/macros/Field" {
  import {
    default as MacroAPI,
    $MacroAPISettings,
  } from "sap/fe/macros/MacroAPI";

  import Control from "sap/ui/core/Control";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import FieldFormatOptions from "sap/fe/macros/field/FieldFormatOptions";

  import Event from "sap/ui/base/Event";

  /**
   * Building block for creating a field based on the metadata provided by OData V4.
   *
   *
   * Usually, a DataField or DataPoint annotation is expected, but the field can also be used to display a
   * property from the entity type.
   * When creating a Field building block, you must provide an ID to ensure everything works correctly.
   *
   * Usage example:
   *
   * ```javascript
   *
   * <macros:Field id="MyField" metaPath="MyProperty" />
   * ```
   *
   * Overview of Building Blocks
   */
  export default class Field extends MacroAPI {
    /**
     * Adds a message to the field.
     *
     *
     * @returns The id of the message
     */
    addMessage(
      /**
       * The parameters to create message
       */
      parameters: {
        /**
         * Message description
         */
        description?: string;
        /**
         * Message text
         */
        message?: string;
        /**
         * True if the message is persistent
         */
        persistent?: boolean;
        /**
         * Type of the message
         */
        type?: /* was: sap.ui.core.message.MessageType */ any;
      }
    ): string;
    /**
     * Gets the current enablement state of the field.
     *
     *
     * @returns Boolean value with the enablement state
     */
    getEnabled(): boolean;
    /**
     * Retrieves the current value of the field.
     *
     *
     * @returns The current value of the field
     */
    getValue(): boolean | float | string | undefined;
    /**
     * Removes a message from the field.
     */
    removeMessage(
      /**
       * The id of the message
       */
      id: string
    ): void;
    /**
     * Sets the current enablement state of the field.
     *
     *
     * @returns The current field reference
     */
    setEnabled(): Control;
    /**
     * Sets the current value of the field.
     *
     *
     * @returns The current field reference
     */
    setValue(): Control;
  }
  /**
   * Describes the settings that can be provided to the Field constructor.
   */
  export interface $FieldSettings extends $MacroAPISettings {
    /**
     * Defines the path of the context used in the current page or block.
     * This setting is defined by the framework.
     */
    contextPath?: string | PropertyBindingInfo;

    /**
     * This is used to optionally provide an external description that comes from a different model than the
     * oData model.
     * This should be used in conjunction with the value property.
     */
    description?: string | PropertyBindingInfo;

    /**
     * Defines the relative path of the property in the metamodel, based on the current contextPath.
     */
    metaPath?: string | PropertyBindingInfo;

    /**
     * An expression that allows you to control the read-only state of the field.
     * If you do not set any expression, SAP Fiori elements hooks into the standard lifecycle to determine the
     * current state.
     */
    readOnly?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Option to add semantic objects for a field.
     * This parameter overwrites the semantic objects defined through annotations.
     * Valid options are either a single semantic object, a stringified array of semantic objects,
     * a formatter or a single binding expression returning either a single semantic object or an array of semantic
     * objects.
     */
    semanticObject?: string | PropertyBindingInfo;

    /**
     * This is used to optionally provide an external value that comes from a different model than the OData
     * model.
     * It is designed to work with a field with value help, and without support for complex value help (currency
     * / unit).
     */
    value?: string | PropertyBindingInfo;

    /**
     * A set of options that can be configured.
     */
    formatOptions?: FieldFormatOptions;
  }

  /**
   * Parameters of the Field#change event.
   */
  export interface Field$ChangeEventParameters {}

  /**
   * Event object of the Field#change event.
   */
  export type Field$ChangeEvent = Event<Field$ChangeEventParameters, Field>;

  /**
   * Parameters of the Field#liveChange event.
   */
  export interface Field$LiveChangeEventParameters {}

  /**
   * Event object of the Field#liveChange event.
   */
  export type Field$LiveChangeEvent = Event<
    Field$LiveChangeEventParameters,
    Field
  >;
}

declare module "sap/fe/macros/KPITag" {
  import {
    default as BuildingBlock,
    $BuildingBlockSettings,
  } from "sap/fe/core/buildingBlocks/BuildingBlock";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Building block used to create a KPI tag.
   */
  export default class KPITag extends BuildingBlock {}
  /**
   * Describes the settings that can be provided to the KPITag constructor.
   */
  export interface $KPITagSettings extends $BuildingBlockSettings {
    /**
     * The Number to be displayed.
     */
    number?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Set it to `true` if the KPI should display its status icon.
     */
    showIcon?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The Status to be displayed.
     */
    status?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * The Text to be displayed.
     */
    text?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * The Tooltip to be displayed.
     */
    tooltip?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * The Unit of Measure of the number to be displayed.
     */
    unit?: any | PropertyBindingInfo | `{${string}}`;
  }

  /**
   * Parameters of the KPITag#press event.
   */
  export interface KPITag$PressEventParameters {}

  /**
   * Event object of the KPITag#press event.
   */
  export type KPITag$PressEvent = Event<KPITag$PressEventParameters, KPITag>;
}

declare module "sap/fe/macros/library" {}

declare module "sap/fe/macros/MacroAPI" {
  import {
    default as BuildingBlock,
    $BuildingBlockSettings,
  } from "sap/fe/core/buildingBlocks/BuildingBlock";

  import { IFormContent } from "sap/ui/core/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Base API control for building blocks.
   */
  export default class MacroAPI extends BuildingBlock implements IFormContent {
    __implements__sap_ui_core_IFormContent: boolean;
  }
  /**
   * Describes the settings that can be provided to the MacroAPI constructor.
   */
  export interface $MacroAPISettings extends $BuildingBlockSettings {
    /**
     * Defines the path of the context used in the current page or block.
     * This setting is defined by the framework.
     */
    contextPath?: string | PropertyBindingInfo;

    /**
     * Defines the relative path of the property in the metamodel, based on the current contextPath.
     */
    metaPath?: string | PropertyBindingInfo;
  }
}

declare module "sap/fe/macros/MessageButton" {
  import {
    default as BuildingBlock,
    $BuildingBlockSettings,
  } from "sap/fe/core/buildingBlocks/BuildingBlock";

  import Event from "sap/ui/base/Event";

  /**
   * Building block used to show bound messages.
   * The Message Button Building Block gets the bound messages from the MessageModel.
   * Usage example:
   *
   * ```javascript
   *
   * <macros:MessageButton visibilityChange=".handler.onMessageButtonVisibilityChange" />
   * ```
   *
   *
   *
   * @experimental
   */
  export default class MessageButton extends BuildingBlock {}
  /**
   * Describes the settings that can be provided to the MessageButton constructor.
   *
   * @experimental
   */
  export interface $MessageButtonSettings extends $BuildingBlockSettings {}

  /**
   * Parameters of the MessageButton#visibilityChange event.
   */
  export interface MessageButton$VisibilityChangeEventParameters {}

  /**
   * Event object of the MessageButton#visibilityChange event.
   */
  export type MessageButton$VisibilityChangeEvent = Event<
    MessageButton$VisibilityChangeEventParameters,
    MessageButton
  >;
}

declare module "sap/fe/macros/MicroChart" {
  import {
    default as BuildingBlock,
    $BuildingBlockSettings,
  } from "sap/fe/core/buildingBlocks/BuildingBlock";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Building block used to create a MicroChart based on the metadata provided by OData V4.
   * {@link demo:sap/fe/core/fpmExplorer/index.html#/buildingBlocks/microchart/ Overview of Micro Chart Building Block}
   *
   *
   * Usually, a contextPath and metaPath is expected.
   *
   * Usage example:
   *
   * ```javascript
   *
   * <macros:MicroChart id="MyMicroChart" contextPath="/RootEntity" metaPath="@com.sap.vocabularies.UI.v1.Chart" />
   * ```
   *
   *
   * ```javascript
   *
   * sap.ui.require(["sap/fe/macros/MicroChart"], function(MicroChart) {
   * 	 ...
   * 	 new MicroChart("myMicroChart", {metaPath:"@com.sap.vocabularies.UI.v1.Chart"})
   * })
   * ```
   *
   *
   *
   * @since 1.93.0
   */
  export default class MicroChart extends BuildingBlock {
    /**
     * Gets current value of property contextPath.
     *
     *
     * @returns Value of property `contextPath`
     */
    getContextPath(): string;
    /**
     * Gets current value of property hideOnNoData.
     *
     *
     * @returns Value of property `hideOnNoData`
     */
    getHideOnNoData(): boolean;
    /**
     * Gets current value of property metaPath.
     *
     *
     * @returns Value of property `metaPath`
     */
    getMetaPath(): string;
    /**
     * Gets current value of property showOnlyChart.
     *
     *
     * @returns Value of property `showOnlyChart`
     */
    getShowOnlyChart(): boolean;
    /**
     * Gets current value of property size.
     *
     *
     * @returns Value of property `size`
     */
    getSize(): string;
    /**
     * Gets current value of property contextPath.
     *
     *
     * @returns Value of property `contextPath`
     */
    setContextPath(): string;
    /**
     * Gets current value of property hideOnNoData.
     *
     *
     * @returns Value of property `hideOnNoData`
     */
    setHideOnNoData(): boolean;
    /**
     * Gets current value of property metaPath.
     *
     *
     * @returns Value of property `metaPath`
     */
    setMetaPath(): string;
    /**
     * Gets current value of property showOnlyChart.
     *
     *
     * @returns Value of property `showOnlyChart`
     */
    setShowOnlyChart(): boolean;
    /**
     * Gets current value of property size.
     *
     *
     * @returns Value of property `size`
     */
    setSize(): string;
  }
  /**
   * Describes the settings that can be provided to the MicroChart constructor.
   */
  export interface $MicroChartSettings extends $BuildingBlockSettings {
    /**
     * context path to the MicroChart.
     */
    contextPath?: string | PropertyBindingInfo;

    /**
     * Show blank space in case there is no data in the chart
     */
    hideOnNoData?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Metadata path to the  MicroChart.
     */
    metaPath?: string | PropertyBindingInfo;

    /**
     * To control the rendering of Title, Subtitle and Currency Labels. When the size is xs then we do
     * not see the inner labels of the MicroChart as well.
     */
    showOnlyChart?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Size of the MicroChart
     */
    size?: string | PropertyBindingInfo;
  }
}

declare module "sap/fe/macros/MultiValueField" {
  import {
    default as BuildingBlock,
    $BuildingBlockSettings,
  } from "sap/fe/core/buildingBlocks/BuildingBlock";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Building block for creating a MultiValueField based on the metadata provided by OData V4.
   *
   *
   * The MultiValueField can be used to display either a DataField or Property directly. It has to point to
   * a collection property.
   *
   *
   * Usage example:
   *
   * ```javascript
   *
   * <macro:MultiValueField
   * id="SomeUniqueIdentifier"
   * contextPath="{entitySet>}"
   * metaPath="{dataField>}"
   * />
   * ```
   *
   *
   * @since 1.118.0
   * @experimental As of version 1.118.0.
   */
  export default class MultiValueField extends BuildingBlock {}
  /**
   * Describes the settings that can be provided to the MultiValueField constructor.
   *
   * @experimental As of version 1.118.0.
   */
  export interface $MultiValueFieldSettings extends $BuildingBlockSettings {
    /**
     * The context path provided for the MultiValueField
     */
    contextPath?: string | PropertyBindingInfo;

    /**
     * Property added to be able to add data / items to the multi value field via a different model
     */
    items?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the relative Metadata path to the MultiValueField.
     * The metaPath should point to a Property or DataField.
     */
    metaPath?: string | PropertyBindingInfo;

    /**
     * The readOnly flag
     */
    readOnly?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/fe/macros/Page" {
  import {
    default as BuildingBlock,
    $BuildingBlockSettings,
  } from "sap/fe/core/buildingBlocks/BuildingBlock";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Control from "sap/ui/core/Control";

  /**
   * Provides a Page building block that can be used to create a page with a title and content
   * By default, the page comes with an ObjectTitle
   */
  export default class Page extends BuildingBlock {}
  /**
   * Describes the settings that can be provided to the Page constructor.
   */
  export interface $PageSettings extends $BuildingBlockSettings {
    /**
     * Avatar source of the page. It is considered only if the title property is specified.
     */
    avatarSrc?: string | PropertyBindingInfo;

    /**
     * Description of the page. It is considered only if the title property is specified.
     */
    description?: string | PropertyBindingInfo;

    /**
     * Title of the page
     * If title is not given, then we will add a title, avatar and description based on the unqualified HeaderInfo
     * associated to the entity
     */
    title?: string | PropertyBindingInfo;

    /**
     * Content(s) of the page
     */
    items?: Control[] | Control | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/fe/macros/Paginator" {
  import {
    default as BuildingBlock,
    $BuildingBlockSettings,
  } from "sap/fe/core/buildingBlocks/BuildingBlock";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Building block used to create a paginator control.
   * Usage example:
   *
   * ```javascript
   *
   * <macros:Paginator />
   * ```
   *
   *
   *
   * @since 1.94.0
   */
  export default class Paginator extends BuildingBlock {}
  /**
   * Describes the settings that can be provided to the Paginator constructor.
   */
  export interface $PaginatorSettings extends $BuildingBlockSettings {
    /**
     * Title of the object that is readout by screen readers when the next/previous item is loaded via keyboard
     * focus on the paginator button.
     */
    ariaTitle?: string | PropertyBindingInfo;
  }
}

declare module "sap/fe/macros/RichTextEditor" {
  import {
    default as BuildingBlock,
    $BuildingBlockSettings,
  } from "sap/fe/core/buildingBlocks/BuildingBlock";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import ButtonGroup from "sap/fe/macros/richtexteditor/ButtonGroup";

  import Plugin from "sap/fe/macros/richtexteditor/Plugin";

  /**
   * Building block that exposes the RichTextEditor UI5 control.
   * It's used to enter formatted text, and uses the third-party component called TinyMCE.
   *
   *
   * @since 1.117.0
   */
  export default class RichTextEditor extends BuildingBlock {}
  /**
   * Describes the settings that can be provided to the RichTextEditor constructor.
   */
  export interface $RichTextEditorSettings extends $BuildingBlockSettings {
    /**
     * With the 'excludeDefaultPlugins' you can ask to remove the plugins that will be added by default
     * The default plugins are "emoticons" "directionality" "image" "table" "link" "powerpaste".
     */
    excludeDefaultPlugins?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Use the readOnly attribute to override the edit flow of the page.
     * By setting 'readOnly' to true, a FormattedText will be displayed instead of the editor.
     */
    readOnly?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Use the 'required' attribute to make sure that the editor is filled with some text.
     */
    required?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * The value contained in the editor. You can use this attribute to set a default value.
     */
    value?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * With the 'buttonGroups' attribute you can customize the buttons that are displayed on the toolbar of
     * the editor.
     */
    buttonGroups?:
      | ButtonGroup[]
      | ButtonGroup
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * With the 'plugins' attribute you can customize the plugins that will be loaded by the editor.
     */
    plugins?: Plugin[] | Plugin | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/fe/macros/RichTextEditorWithMetadata" {
  import {
    default as RichTextEditor,
    $RichTextEditorSettings,
  } from "sap/fe/macros/RichTextEditor";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Metadata-driven building block that exposes the RichTextEditor UI5 control.
   * It's used to enter formatted text and uses the third-party component called TinyMCE.
   *
   *
   * @since 1.117.0
   */
  export default class RichTextEditorWithMetadata extends RichTextEditor {}
  /**
   * Describes the settings that can be provided to the RichTextEditorWithMetadata constructor.
   */
  export interface $RichTextEditorWithMetadataSettings
    extends $RichTextEditorSettings {
    /**
     * The context path of the property displayed
     */
    contextPath?: string | PropertyBindingInfo;

    /**
     * The metaPath of the displayed property
     */
    metaPath?: string | PropertyBindingInfo;
  }
}

declare module "sap/fe/macros/Share" {
  import {
    default as BuildingBlock,
    $BuildingBlockSettings,
  } from "sap/fe/core/buildingBlocks/BuildingBlock";

  import ShareOptions from "sap/fe/macros/share/ShareOptions";

  /**
   * Building block used to create the ‘Share’ functionality.
   *
   *
   * Please note that the 'Share in SAP Jam' option is only available on platforms that are integrated with
   * SAP Jam.
   *
   *
   * If you are consuming this macro in an environment where the SAP Fiori launchpad is not available, then
   * the 'Save as Tile' option is not visible.
   *
   * Usage example:
   *
   * ```javascript
   *
   * <macros:Share
   * id="someID"
   * visible="true"
   * />
   * ```
   *
   * {@link demo:sap/fe/core/fpmExplorer/index.html#/buildingBlocks/features/shareDefault Overview of Building Blocks}
   *
   *
   * @since 1.93.0
   */
  export default class Share extends BuildingBlock {}
  /**
   * Describes the settings that can be provided to the Share constructor.
   */
  export interface $ShareSettings extends $BuildingBlockSettings {
    /**
     * Supported Share options {@link sap.fe.macros.share.ShareOptions }.
     */
    shareOptions?: ShareOptions;
  }
}

declare module "sap/fe/macros/VariantManagement" {
  import {
    default as BuildingBlock,
    $BuildingBlockSettings,
  } from "sap/fe/core/buildingBlocks/BuildingBlock";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Building block used to create a Variant Management based on the metadata provided by OData V4.
   * Usage example:
   *
   * ```javascript
   *
   * <macro:VariantManagement
   * id="SomeUniqueIdentifier"
   * for="{listOfControlIds>}"
   * />
   * ```
   *
   * {@link demo:sap/fe/core/fpmExplorer/index.html#/buildingBlocks/filterBar/filterBarVMWithTable Overview of Building Blocks}
   */
  export default class VariantManagement extends BuildingBlock {}
  /**
   * Describes the settings that can be provided to the VariantManagement constructor.
   */
  export interface $VariantManagementSettings extends $BuildingBlockSettings {
    /**
     * A list of control IDs to which the variant management is applied.
     */
    for?: string[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Header level for the variant management, determining its position or style.
     */
    headerLevel?: string | PropertyBindingInfo;

    /**
     * Identifier for the variant management control.
     */
    id?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Whether the "Set as Default" option is visible.
     */
    showSetAsDefault?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/fe/macros/chart/Action" {
  import {
    default as BuildingBlockObjectProperty,
    $BuildingBlockObjectPropertySettings,
  } from "sap/fe/macros/controls/BuildingBlockObjectProperty";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Definition of a custom action to be used in the chart toolbar
   */
  export default class Action extends BuildingBlockObjectProperty {}
  /**
   * Describes the settings that can be provided to the Action constructor.
   */
  export interface $ActionSettings
    extends $BuildingBlockObjectPropertySettings {
    /**
     * Reference to the key of another action already displayed in the toolbar to properly place this one
     */
    anchor?: string | PropertyBindingInfo;

    /**
     * Enables or disables the action
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Unique identifier of the action
     */
    key?: string | PropertyBindingInfo;

    /**
     * Defines where this action should be placed relative to the defined anchor
     * Allowed values are `Before` and `After`
     */
    placement?: string | PropertyBindingInfo;

    /**
     * Event handler to be called when the user chooses the action
     */
    press?: string | PropertyBindingInfo;

    /**
     * Defines if the action requires a selection.
     */
    requiresSelection?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The text that will be displayed for this action
     */
    text?: string | PropertyBindingInfo;
  }
}

declare module "sap/fe/macros/chart/ActionGroup" {
  import {
    default as Action,
    $ActionSettings,
  } from "sap/fe/macros/chart/Action";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Definition of a custom action group to be used inside the chart toolbar
   */
  export default class ActionGroup extends Action {}
  /**
   * Describes the settings that can be provided to the ActionGroup constructor.
   */
  export interface $ActionGroupSettings extends $ActionSettings {
    /**
     * Reference to the key of another action or action group already displayed in the toolbar to properly place
     * this one
     */
    anchor?: string | PropertyBindingInfo;

    /**
     * Unique identifier of the action
     */
    key?: string | PropertyBindingInfo;

    /**
     * Defines where this action group should be placed relative to the defined anchor
     * Allowed values are `Before` and `After`
     */
    placement?: string | PropertyBindingInfo;

    /**
     * The text that will be displayed for this action group
     */
    text?: string | PropertyBindingInfo;

    /**
     * Defines nested actions
     */
    actions?: Action[] | Action | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/fe/macros/chart/Chart" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import PresentationVariant from "sap/fe/navigation/PresentationVariant";

  import Context from "sap/ui/model/odata/v4/Context";

  import SelectionVariant from "sap/fe/navigation/SelectionVariant";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import ActionGroup from "sap/fe/macros/chart/ActionGroup";

  import Action from "sap/fe/macros/chart/Action";

  import Event from "sap/ui/base/Event";

  /**
   * Building block used to create a chart based on the metadata provided by OData V4.
   *
   *
   * Usually, a contextPath and metaPath is expected.
   * Usage example:
   *
   * ```javascript
   *
   * sap.ui.require(["sap/fe/macros/chart/Chart"], function(Chart) {
   * 	 ...
   * 	 new Chart("myChart", {metaPath:"MyChart"})
   * })
   * ```
   *
   * This is currently an experimental API because the structure of the generated content will change to come
   * closer to the Chart that you get out of templates.
   * The public method and property will not change but the internal structure will so be careful on your
   * usage.
   *
   *
   * @deprecated As of version 1.130. Use {@link sap.fe.macros.Chart } instead
   * @experimental
   */
  export default class Chart extends Control {
    /**
     * Gets current value of property contextPath.
     *
     *
     * @returns Value of property `contextPath`
     */
    getContextPath(): string;
    /**
     * Gets the key of the current variant in the associated variant management.
     *
     *
     * @returns Variant key of {@link sap.ui.fl.variants.VariantManagement } applied to the chart
     */
    getCurrentVariantKey(): null | string;
    /**
     * Gets current value of property filterBar.
     *
     *
     * @returns Value of property `filterBar`
     */
    getFilterBar(): string;
    /**
     * Gets current value of property header.
     *
     *
     * @returns Value of property `header`
     */
    getHeader(): string;
    /**
     * Gets current value of property headerVisible.
     *
     *
     * @returns Value of property `headerVisible`
     */
    getHeaderVisible(): boolean;
    /**
     * Gets current value of property metaPath.
     *
     *
     * @returns Value of property `metaPath`
     */
    getMetaPath(): string;
    /**
     * Gets current value of property personalization.
     *
     *
     * @returns Value of property `personalization`
     */
    getPersonalization(): string;
    /**
     * Get the presentation variant that is currently applied on the chart.
     *
     *
     * @returns The presentation variant {@link sap.fe.navigation.PresentationVariant } applied to the chart
     */
    getPresentationVariant(): Promise<PresentationVariant>;
    /**
     * Gets contexts from the chart that have been selected by the user.
     *
     *
     * @returns Contexts of the rows selected by the user
     */
    getSelectedContexts(): Context[];
    /**
     * Gets current value of property selectionMode.
     *
     *
     * @returns Value of property `selectionMode`
     */
    getSelectionMode(): string;
    /**
     * Get the selection variant from the chart. This function considers only the selection variant applied
     * at the control level.
     *
     *
     * @returns A promise that resolves with {@link sap.fe.navigation.SelectionVariant }.
     */
    getSelectionVariant(): Promise<SelectionVariant>;
    /**
     * Gets current value of property variantManagement.
     *
     *
     * @returns Value of property `variantManagement`
     */
    getVariantManagement(): string;
    /**
     * Gets current value of property contextPath.
     *
     *
     * @returns Value of property `contextPath`
     */
    setContextPath(): string;
    /**
     * Sets the variant of the provided key in the associated variant management.
     */
    setCurrentVariantKey(
      /**
       * The variant key of {@link sap.ui.fl.variants.VariantManagement } to be set
       */
      key: string
    ): void;
    /**
     * Gets current value of property filterBar.
     *
     *
     * @returns Value of property `filterBar`
     */
    setFilterBar(): string;
    /**
     * Gets current value of property header.
     *
     *
     * @returns Value of property `header`
     */
    setHeader(): string;
    /**
     * Gets current value of property headerVisible.
     *
     *
     * @returns Value of property `headerVisible`
     */
    setHeaderVisible(): boolean;
    /**
     * Gets current value of property metaPath.
     *
     *
     * @returns Value of property `metaPath`
     */
    setMetaPath(): string;
    /**
     * Gets current value of property personalization.
     *
     *
     * @returns Value of property `personalization`
     */
    setPersonalization(): string;
    /**
     * Set the presentation variant for the mdc chart.
     * The json format retrieved by using the get PresentationVariant button in the linked FPM sample should
     * be followed while trying to set the PresentationVariant as needed.
     * The values dimensions, measures and other properties should also be given in the valid format and null
     * or empty values should be avoided.
     * One dimension attribute should have only one role associated with it on a given chart.
     */
    setPresentationVariant(
      /**
       * the presentation variant {@link sap.fe.navigation.PresentationVariant } to be set
       */
      presentationVariant: PresentationVariant
    ): Promise<void>;
    /**
     * Gets current value of property selectionMode.
     *
     *
     * @returns Value of property `selectionMode`
     */
    setSelectionMode(): string;
    /**
     * Sets {@link sap.fe.navigation.SelectionVariant } to the chart. Note: setSelectionVariant will clear existing
     * filters and then apply the SelectionVariant values.
     *
     *
     * @returns A promise for asynchronous handling
     */
    setSelectionVariant(
      /**
       * The {@link sap.fe.navigation.SelectionVariant } to apply to the chart
       */
      selectionVariant: SelectionVariant,
      /**
       * Optional. If true, we will use the associated text property values (if they're available in the SelectionVariant)
       * to display the filter value descriptions, instead of loading them from the backend
       */
      prefillDescriptions?: boolean
    ): Promise<any>;
    /**
     * Gets current value of property variantManagement.
     *
     *
     * @returns Value of property `variantManagement`
     */
    setVariantManagement(): string;
  }
  /**
   * Describes the settings that can be provided to the Chart constructor.
   *
   * @deprecated As of version 1.130. Use {@link sap.fe.macros.Chart } instead
   * @experimental
   */
  export interface $ChartSettings extends $ControlSettings {
    /**
     * Metadata path to the entitySet or navigationProperty
     */
    contextPath?: string | PropertyBindingInfo;

    /**
     * Id of the FilterBar building block associated with the chart.
     */
    filterBar?: string | PropertyBindingInfo;

    /**
     * Specifies the header text that is shown in the chart
     */
    header?: string | PropertyBindingInfo;

    /**
     * Controls if the header text should be shown or not
     */
    headerVisible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Metadata path to the presentation context (UI.Chart with or without a qualifier)
     */
    metaPath?: string | PropertyBindingInfo;

    /**
     * Controls which options should be enabled for the chart personalization dialog.
     * If it is set to `true`, all possible options for this kind of chart are enabled.
     *
     * If it is set to `false`, personalization is disabled.
     *
     *
     *
     * You can also provide a more granular control for the personalization by providing a comma-separated list
     * with the options you want to be available.
     *
     * Available options are:
     *
     * - Sort
     *
     * - Type
     *
     * - Item
     *
     * - Filter
     */
    personalization?: string | PropertyBindingInfo;

    /**
     * Defines the selection mode to be used by the chart.
     * Allowed values are `None`, `Single` or `Multiple`
     */
    selectionMode?: string | PropertyBindingInfo;

    /**
     * Controls the kind of variant management that should be enabled for the chart.
     * Allowed value is `Control`.
     *
     * If set with value `Control`, a variant management control is seen within the chart and the chart is linked
     * to this.
     *
     * If not set with any value, variant management control is not available for this chart.
     */
    variantManagement?: string | PropertyBindingInfo;

    /**
     * Aggregate actions of the chart.
     */
    actions?:
      | Array<ActionGroup | Action>
      | ActionGroup
      | Action
      | AggregationBindingInfo
      | `{${string}}`;
  }

  /**
   * Parameters of the Chart#selectionChange event.
   */
  export interface Chart$SelectionChangeEventParameters {}

  /**
   * Event object of the Chart#selectionChange event.
   */
  export type Chart$SelectionChangeEvent = Event<
    Chart$SelectionChangeEventParameters,
    Chart
  >;
}

declare module "sap/fe/macros/controls/BuildingBlockObjectProperty" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  /**
   * Base class for building block complex object properties that can be serialized to XML.
   */
  export default class BuildingBlockObjectProperty extends UI5Element {}
  /**
   * Describes the settings that can be provided to the BuildingBlockObjectProperty constructor.
   */
  export interface $BuildingBlockObjectPropertySettings
    extends $ElementSettings {}
}

declare module "sap/fe/macros/controls/BuildingBlockWithTemplating" {
  import {
    default as BuildingBlock,
    $BuildingBlockSettings,
  } from "sap/fe/core/buildingBlocks/BuildingBlock";

  /**
   * Using this class you can define a building block that will manage and render a templating based building
   * block.
   * On change of the main properties you will be able to recreate the content.
   *
   * @experimental
   */
  export default class BuildingBlockWithTemplating extends BuildingBlock {}
  /**
   * Describes the settings that can be provided to the BuildingBlockWithTemplating constructor.
   *
   * @experimental
   */
  export interface $BuildingBlockWithTemplatingSettings
    extends $BuildingBlockSettings {}
}

declare module "sap/fe/macros/fcl/FlexibleColumnLayoutActions.block" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  /**
   * Building block for adding overflow toolbar buttons to integrate into the flexible column layout support
   * from Fiori elements.
   * Usage example:
   *
   * ```javascript
   *
   * <macros:FlexibleColumnLayoutActions />
   * ```
   *
   *
   *
   * @since 1.93.0
   */
  export default class FlexibleColumnLayoutActions extends Control {}
  /**
   * Describes the settings that can be provided to the FlexibleColumnLayoutActions constructor.
   */
  export interface $FlexibleColumnLayoutActionsSettings
    extends $ControlSettings {}
}

declare module "sap/fe/macros/field/Field" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import FieldFormatOptions from "sap/fe/macros/field/FieldFormatOptions";

  import Event from "sap/ui/base/Event";

  /**
   * Building block for creating a field based on the metadata provided by OData V4.
   *
   *
   * Usually, a DataField or DataPoint annotation is expected, but the field can also be used to display a
   * property from the entity type.
   * When creating a Field building block, you must provide an ID to ensure everything works correctly.
   * Usage example:
   *
   * ```javascript
   *
   * sap.ui.require(["sap/fe/macros/field/Field"], function(Field) {
   * 	 ...
   * 	 new Field("MyField", {metaPath:"MyProperty"})
   * })
   * ```
   *
   * This is currently an experimental API because the structure of the generated content will change to come
   * closer to the Field that you get out of templates.
   * The public method and property will not change but the internal structure will so be careful on your
   * usage.
   *
   *
   * @deprecated As of version 1.135. Use {@link sap.fe.macros.Field } instead
   * @experimental
   */
  export default class Field extends Control {
    /**
     * Adds a message to the field.
     *
     *
     * @returns The id of the message
     */
    addMessage(
      /**
       * The parameters to create message
       */
      parameters: {
        /**
         * Message description
         */
        description?: string;
        /**
         * Message text
         */
        message?: string;
        /**
         * True if the message is persistent
         */
        persistent?: boolean;
        /**
         * Type of the message
         */
        type?: /* was: sap.ui.core.message.MessageType */ any;
      }
    ): string;
    /**
     * Gets the current enablement state of the field.
     *
     *
     * @returns Boolean value with the enablement state
     */
    getEnabled(): boolean;
    /**
     * Retrieves the current value of the field.
     *
     *
     * @returns The current value of the field
     */
    getValue(): boolean | float | string | undefined;
    /**
     * Removes a message from the field.
     */
    removeMessage(
      /**
       * The id of the message
       */
      id: string
    ): void;
    /**
     * Sets the current enablement state of the field.
     *
     *
     * @returns The current field reference
     */
    setEnabled(): Control;
    /**
     * Sets the current value of the field.
     *
     *
     * @returns The current field reference
     */
    setValue(): Control;
  }
  /**
   * Describes the settings that can be provided to the Field constructor.
   *
   * @deprecated As of version 1.135. Use {@link sap.fe.macros.Field } instead
   * @experimental
   */
  export interface $FieldSettings extends $ControlSettings {
    /**
     * Defines the path of the context used in the current page or block.
     * This setting is defined by the framework.
     */
    contextPath?: string | PropertyBindingInfo;

    /**
     * This is used to optionally provide an external description that comes from a different model than the
     * oData model.
     * This should be used in conjunction with the value property.
     */
    description?: string | PropertyBindingInfo;

    /**
     * Defines the relative path of the property in the metamodel, based on the current contextPath.
     */
    metaPath?: string | PropertyBindingInfo;

    /**
     * An expression that allows you to control the read-only state of the field.
     * If you do not set any expression, SAP Fiori elements hooks into the standard lifecycle to determine the
     * current state.
     */
    readOnly?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Option to add semantic objects for a field.
     * This parameter overwrites the semantic objects defined through annotations.
     * Valid options are either a single semantic object, a stringified array of semantic objects,
     * a formatter or a single binding expression returning either a single semantic object or an array of semantic
     * objects.
     */
    semanticObject?: string | PropertyBindingInfo;

    /**
     * This is used to optionally provide an external value that comes from a different model than the OData
     * model.
     * It is designed to work with a field with value help, and without support for complex value help (currency
     * / unit).
     */
    value?: string | PropertyBindingInfo;

    /**
     * A set of options that can be configured.
     */
    formatOptions?: FieldFormatOptions;
  }

  /**
   * Parameters of the Field#change event.
   */
  export interface Field$ChangeEventParameters {}

  /**
   * Event object of the Field#change event.
   */
  export type Field$ChangeEvent = Event<Field$ChangeEventParameters, Field>;

  /**
   * Parameters of the Field#liveChange event.
   */
  export interface Field$LiveChangeEventParameters {}

  /**
   * Event object of the Field#liveChange event.
   */
  export type Field$LiveChangeEvent = Event<
    Field$LiveChangeEventParameters,
    Field
  >;
}

declare module "sap/fe/macros/field/FieldFormatOptions" {
  import {
    default as BuildingBlockObjectProperty,
    $BuildingBlockObjectPropertySettings,
  } from "sap/fe/macros/controls/BuildingBlockObjectProperty";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Additional format options for the field.
   */
  export default class FieldFormatOptions extends BuildingBlockObjectProperty {}
  /**
   * Describes the settings that can be provided to the FieldFormatOptions constructor.
   */
  export interface $FieldFormatOptionsSettings
    extends $BuildingBlockObjectPropertySettings {
    /**
     * Property for defining a custom pattern for the date, time, or dateTime format.
     *
     * If there is a dateTimePattern defined dateTimeStyle is ignored.
     */
    dateTimePattern?: string | PropertyBindingInfo;

    /**
     * Property for defining the display style for the date, time, or dateTime format.
     *
     * If there is a dateTimePattern defined dateTimeStyle is ignored.
     */
    dateTimeStyle?: string | PropertyBindingInfo;

    /**
     * Defines how the field value and associated text will be displayed together.
     *
     * Allowed values are "Value", "Description", "DescriptionValue" and "ValueDescription"
     */
    displayMode?: string | PropertyBindingInfo;

    /**
     * Determines how the field should be rendered, e.g. as radio buttons.
     *
     * If not all prerequisites are met, the field will default back to the standard rendering.
     */
    fieldEditStyle?: string | PropertyBindingInfo;

    /**
     * Defines if and how the field measure will be displayed.
     *
     * Allowed values are "Hidden" and "ReadOnly"
     */
    measureDisplayMode?: string | PropertyBindingInfo;

    /**
     * Specifies if radio buttons should be rendered in a horizontal layout.
     */
    radioButtonsHorizontalLayout?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines if the date part of a date time with timezone field should be shown.
     *
     * The dateTimeOffset field must have a timezone annotation.
     * The default value is true.
     */
    showDate?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines if the time part of a date time with timezone field should be shown.
     *
     * The dateTimeOffset field must have a timezone annotation.
     * The default value is true.
     */
    showTime?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines if the timezone part of a date time with timezone field should be shown.
     *
     * The dateTimeOffset field must have a timezone annotation.
     * The default value is true.
     */
    showTimezone?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines how the full text will be displayed.
     *
     * Allowed values are "InPlace" and "Popover"
     */
    textExpandBehaviorDisplay?: string | PropertyBindingInfo;

    /**
     * Maximum number of lines for multiline texts in edit mode.
     */
    textLinesEdit?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Maximum number of characters from the beginning of the text field that are shown initially.
     */
    textMaxCharactersDisplay?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the maximum number of characters for the multiline text value.
     *
     * If a multiline text exceeds the maximum number of allowed characters, the counter below the input field
     * displays the exact number.
     */
    textMaxLength?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Maximum number of lines that multiline texts in edit mode can grow to.
     */
    textMaxLines?: int | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/fe/macros/filterBar/FilterBar" {
  import {
    default as BuildingBlockWithTemplating,
    $BuildingBlockWithTemplatingSettings,
  } from "sap/fe/macros/controls/BuildingBlockWithTemplating";

  import SelectionVariant from "sap/fe/navigation/SelectionVariant";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import FilterField from "sap/fe/macros/filterBar/FilterField";

  import Event from "sap/ui/base/Event";

  /**
   * Usage example:
   *
   * ```javascript
   *
   * sap.ui.require(["sap/fe/macros/filterBar/FilterBar"], function(FilterBar) {
   * 	 ...
   * 	 new FilterBar("MyFilterBar", {metaPath:"@com.sap.vocabularies.UI.v1.SelectionFields"})
   * })
   * ```
   *
   * This is currently an experimental API because the structure of the generated content will change to come
   * closer to the FilterBar that you get out of templates.
   * The public method and property will not change but the internal structure will so be careful on your
   * usage.
   *
   *
   * @experimental
   */
  export default class FilterBar extends BuildingBlockWithTemplating {
    /**
     * Get the Active Filters Text Summary for the filter bar.
     *
     *
     * @returns Active filters summary as text
     */
    getActiveFiltersText(): string;
    /**
     * Gets the key of the current variant in the associated variant management.
     *
     *
     * @returns Key of the currently selected variant. In case the model is not yet set, `null` will be returned.
     */
    getCurrentVariantKey(): null | string;
    /**
     * Determines whether the field is enabled or disabled.
     *
     *
     * @returns Whether the filterField is enabled or disabled.
     */
    getFilterFieldEnabled(
      /**
       * Name of the field.
       */
      name: string
    ): boolean;
    /**
     * Gets the visibility of a filter field.
     *
     *
     * @returns A {@link Promise } that resolves to check whether the filter field is visible or not.
     */
    getFilterFieldVisible(
      /**
       * The path to the property as a condition path
       */
      conditionPath: string
    ): Promise<boolean>;
    /**
     * Provides all the filters that are currently active
     * along with the search expression.
     *
     *
     * @returns An array of active filters and the search expression.
     */
    getFilters(): object;
    /**
     * Get the selection variant from the filter bar.
     *
     *
     * @returns A promise which resolves with a {@link sap.fe.navigation.SelectionVariant }
     */
    getSelectionVariant(): Promise<SelectionVariant>;
    /**
     * Sets the new selected variant in the associated variant management.
     */
    setCurrentVariantKey(
      /**
       * Key of the variant that should be selected. If the passed key doesn't identify a variant, it will be
       * ignored.
       */
      key: string
    ): void;
    /**
     * Sets the enablement of the field.
     */
    setFilterFieldEnabled(
      /**
       * Name of the field that should be enabled or disabled.
       */
      name: string,
      /**
       * Whether the field should be enabled or disabled.
       */
      enabled: boolean
    ): void;
    /**
     * Shows or hides any filter field from the filter bar.
     * The property will not be hidden inside the adaptation dialog and may be re-added.
     *
     *
     * @returns A {@link Promise } resolving once the change in visibility was applied
     */
    setFilterFieldVisible(
      /**
       * The path to the property as a condition path
       */
      conditionPath: string,
      /**
       * Whether it should be shown or hidden
       */
      visible: boolean
    ): Promise<void>;
    /**
     * Set the filter values for the given property in the filter bar.
     * The filter values can be either a single value or an array of values.
     * Each filter value must be represented as a primitive value.
     *
     *
     * @returns A promise for asynchronous handling
     */
    setFilterValues(
      /**
       * The path to the property as a condition path
       */
      sConditionPath: string,
      /**
       * The operator to be used (optional) - if not set, the default operator (EQ) will be used
       */
      sOperator: string | undefined,
      /**
       * The values to be applied
       */
      vValues?:
        | boolean
        | boolean[]
        | number
        | number[]
        | string
        | string[]
        | undefined
    ): Promise<void>;
    /**
     * Sets {@link sap.fe.navigation.SelectionVariant } to the filter bar. Note: setSelectionVariant will clear
     * existing filters and then apply the SelectionVariant values.
     *
     *
     * @returns A promise for asynchronous handling
     */
    setSelectionVariant(
      /**
       * The {@link sap.fe.navigation.SelectionVariant } to apply to the filter bar
       */
      selectionVariant: SelectionVariant,
      /**
       * Optional. If true, we will use the associated text property values (if they're available in the selectionVariant)
       * to display the filter value descriptions, instead of loading them from the backend
       */
      prefillDescriptions?: boolean
    ): Promise<any>;
    /**
     * Triggers the API search on the filter bar.
     *
     *
     * @returns Returns a promise which resolves if filter go is triggered successfully; otherwise gets rejected.
     */
    triggerSearch(): Promise<object | undefined>;
  }
  /**
   * Describes the settings that can be provided to the FilterBar constructor.
   *
   * @experimental
   */
  export interface $FilterBarSettings
    extends $BuildingBlockWithTemplatingSettings {
    /**
     * Defines the path of the context used in the current page or block.
     * This setting is defined by the framework.
     */
    contextPath?: string | PropertyBindingInfo;

    /**
     * If true, the search is triggered automatically when a filter value is changed.
     */
    liveMode?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the relative path of the property in the metamodel, based on the current contextPath.
     */
    metaPath?: string | PropertyBindingInfo;

    /**
     * Handles the visibility of the 'Clear' button on the FilterBar.
     */
    showClearButton?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Displays possible errors during the search in a message box
     */
    showMessages?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Parameter which sets the visibility of the FilterBar building block
     */
    visible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Aggregate filter fields of the FilterBar building block
     */
    filterFields?:
      | FilterField[]
      | FilterField
      | AggregationBindingInfo
      | `{${string}}`;
  }

  /**
   * Parameters of the FilterBar#afterClear event.
   */
  export interface FilterBar$AfterClearEventParameters {}

  /**
   * Event object of the FilterBar#afterClear event.
   */
  export type FilterBar$AfterClearEvent = Event<
    FilterBar$AfterClearEventParameters,
    FilterBar
  >;

  /**
   * Parameters of the FilterBar#filterChanged event.
   */
  export interface FilterBar$FilterChangedEventParameters {}

  /**
   * Event object of the FilterBar#filterChanged event.
   */
  export type FilterBar$FilterChangedEvent = Event<
    FilterBar$FilterChangedEventParameters,
    FilterBar
  >;

  /**
   * Parameters of the FilterBar#search event.
   */
  export interface FilterBar$SearchEventParameters {}

  /**
   * Event object of the FilterBar#search event.
   */
  export type FilterBar$SearchEvent = Event<
    FilterBar$SearchEventParameters,
    FilterBar
  >;
}

declare module "sap/fe/macros/filterBar/FilterBarAPI" {
  import {
    default as MacroAPI,
    $MacroAPISettings,
  } from "sap/fe/macros/MacroAPI";

  import SelectionVariant from "sap/fe/navigation/SelectionVariant";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import FilterField from "sap/fe/macros/filterBar/FilterField";

  import Event from "sap/ui/base/Event";

  /**
   * Building block for creating a FilterBar based on the metadata provided by OData V4.
   * {@link demo:sap/fe/core/fpmExplorer/index.html#/buildingBlocks/filterBar/filterBarDefault Overview of Building Blocks}
   *
   *
   * Usually, a SelectionFields annotation is expected.
   *
   * Usage example:
   *
   * ```javascript
   *
   * <macros:FilterBar id="MyFilterBar" metaPath="@com.sap.vocabularies.UI.v1.SelectionFields" />
   * ```
   */
  export default class FilterBar extends MacroAPI {
    /**
     * Get the Active Filters Text Summary for the filter bar.
     *
     *
     * @returns Active filters summary as text
     */
    getActiveFiltersText(): string;
    /**
     * Gets the key of the current variant in the associated variant management.
     *
     *
     * @returns Key of the currently selected variant. In case the model is not yet set, `null` will be returned.
     */
    getCurrentVariantKey(): null | string;
    /**
     * Determines whether the field is enabled or disabled.
     *
     *
     * @returns Whether the filterField is enabled or disabled.
     */
    getFilterFieldEnabled(
      /**
       * Name of the field.
       */
      name: string
    ): boolean;
    /**
     * Gets the visibility of a filter field.
     *
     *
     * @returns A {@link Promise } that resolves to check whether the filter field is visible or not.
     */
    getFilterFieldVisible(
      /**
       * The path to the property as a condition path
       */
      conditionPath: string
    ): Promise<boolean>;
    /**
     * Provides all the filters that are currently active
     * along with the search expression.
     *
     *
     * @returns An array of active filters and the search expression.
     */
    getFilters(): object;
    /**
     * Get the selection variant from the filter bar.
     *
     *
     * @returns A promise which resolves with a {@link sap.fe.navigation.SelectionVariant }
     */
    getSelectionVariant(): Promise<SelectionVariant>;
    /**
     * Sets the new selected variant in the associated variant management.
     */
    setCurrentVariantKey(
      /**
       * Key of the variant that should be selected. If the passed key doesn't identify a variant, it will be
       * ignored.
       */
      key: string
    ): void;
    /**
     * Sets the enablement of the field.
     */
    setFilterFieldEnabled(
      /**
       * Name of the field that should be enabled or disabled.
       */
      name: string,
      /**
       * Whether the field should be enabled or disabled.
       */
      enabled: boolean
    ): void;
    /**
     * Shows or hides any filter field from the filter bar.
     * The property will not be hidden inside the adaptation dialog and may be re-added.
     *
     *
     * @returns A {@link Promise } resolving once the change in visibility was applied
     */
    setFilterFieldVisible(
      /**
       * The path to the property as a condition path
       */
      conditionPath: string,
      /**
       * Whether it should be shown or hidden
       */
      visible: boolean
    ): Promise<void>;
    /**
     * Set the filter values for the given property in the filter bar.
     * The filter values can be either a single value or an array of values.
     * Each filter value must be represented as a primitive value.
     *
     *
     * @returns A promise for asynchronous handling
     */
    setFilterValues(
      /**
       * The path to the property as a condition path
       */
      sConditionPath: string,
      /**
       * The operator to be used (optional) - if not set, the default operator (EQ) will be used
       */
      sOperator: string | undefined,
      /**
       * The values to be applied
       */
      vValues?:
        | boolean
        | boolean[]
        | number
        | number[]
        | string
        | string[]
        | undefined
    ): Promise<void>;
    /**
     * Sets {@link sap.fe.navigation.SelectionVariant } to the filter bar. Note: setSelectionVariant will clear
     * existing filters and then apply the SelectionVariant values.
     *
     *
     * @returns A promise for asynchronous handling
     */
    setSelectionVariant(
      /**
       * The {@link sap.fe.navigation.SelectionVariant } to apply to the filter bar
       */
      selectionVariant: SelectionVariant,
      /**
       * Optional. If true, we will use the associated text property values (if they're available in the selectionVariant)
       * to display the filter value descriptions, instead of loading them from the backend
       */
      prefillDescriptions?: boolean
    ): Promise<any>;
    /**
     * Triggers the API search on the filter bar.
     *
     *
     * @returns Returns a promise which resolves if filter go is triggered successfully; otherwise gets rejected.
     */
    triggerSearch(): Promise<object | undefined>;
  }
  /**
   * Describes the settings that can be provided to the FilterBar constructor.
   */
  export interface $FilterBarSettings extends $MacroAPISettings {
    /**
     * Defines the path of the context used in the current page or block.
     * This setting is defined by the framework.
     */
    contextPath?: string | PropertyBindingInfo;

    /**
     * If true, the search is triggered automatically when a filter value is changed.
     */
    liveMode?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the relative path of the property in the metamodel, based on the current contextPath.
     */
    metaPath?: string | PropertyBindingInfo;

    /**
     * Handles the visibility of the 'Clear' button on the FilterBar.
     */
    showClearButton?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Displays possible errors during the search in a message box
     */
    showMessages?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Parameter which sets the visibility of the FilterBar building block
     */
    visible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Aggregate filter fields of the FilterBar building block
     */
    filterFields?:
      | FilterField[]
      | FilterField
      | AggregationBindingInfo
      | `{${string}}`;
  }

  /**
   * Parameters of the FilterBar#afterClear event.
   */
  export interface FilterBar$AfterClearEventParameters {}

  /**
   * Event object of the FilterBar#afterClear event.
   */
  export type FilterBar$AfterClearEvent = Event<
    FilterBar$AfterClearEventParameters,
    FilterBar
  >;

  /**
   * Parameters of the FilterBar#filterChanged event.
   */
  export interface FilterBar$FilterChangedEventParameters {}

  /**
   * Event object of the FilterBar#filterChanged event.
   */
  export type FilterBar$FilterChangedEvent = Event<
    FilterBar$FilterChangedEventParameters,
    FilterBar
  >;

  /**
   * Parameters of the FilterBar#search event.
   */
  export interface FilterBar$SearchEventParameters {}

  /**
   * Event object of the FilterBar#search event.
   */
  export type FilterBar$SearchEvent = Event<
    FilterBar$SearchEventParameters,
    FilterBar
  >;
}

declare module "sap/fe/macros/filterBar/FilterField" {
  import {
    default as BuildingBlockObjectProperty,
    $BuildingBlockObjectPropertySettings,
  } from "sap/fe/macros/controls/BuildingBlockObjectProperty";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Definition of a custom filter to be used inside the FilterBar.
   * The template for the FilterField has to be provided as the default aggregation
   *
   * {@link demo:sap/fe/core/fpmExplorer/index.html#/buildingBlocks/filterBar/filterBarCustoms Overview of Building Blocks}
   */
  export default class FilterField extends BuildingBlockObjectProperty {}
  /**
   * Describes the settings that can be provided to the FilterField constructor.
   */
  export interface $FilterFieldSettings
    extends $BuildingBlockObjectPropertySettings {
    /**
     * Reference to the key of another filter already displayed in the table to properly place this one
     */
    anchor?: string | PropertyBindingInfo;

    /**
     * The property name of the FilterField
     */
    key?: string | PropertyBindingInfo;

    /**
     * The text that will be displayed for this FilterField
     */
    label?: string | PropertyBindingInfo;

    /**
     * Defines where this filter should be placed relative to the defined anchor
     * Allowed values are `Before` and `After`
     */
    placement?: string | PropertyBindingInfo;

    /**
     * Defines which property will be influenced by the FilterField.
     * This must be a valid property of the entity as this can be used for SAP Companion integration
     */
    property?: string | PropertyBindingInfo;

    /**
     * If set, the FilterField will be marked as a mandatory field.
     */
    required?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * This property is not required at filter field level. To achieve the desired behavior, specify the showMessages
     * property in the FilterBar building block.
     *
     * @deprecated As of version 1.135.
     */
    showMessages?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/fe/macros/form/Form.block" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Context from "sap/ui/model/Context";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Building block for creating a Form based on the metadata provided by OData V4.
   *
   *
   * It is designed to work based on a FieldGroup annotation but can also work if you provide a ReferenceFacet
   * or a CollectionFacet
   *
   * Usage example:
   *
   * ```javascript
   *
   * <macros:Form id="MyForm" metaPath="@com.sap.vocabularies.UI.v1.FieldGroup#GeneralInformation" />
   * ```
   */
  export default class Form extends Control {}
  /**
   * Describes the settings that can be provided to the Form constructor.
   */
  export interface $FormSettings extends $ControlSettings {
    /**
     * Defines the path of the context used in the current page or block.
     * This setting is defined by the framework.
     */
    contextPath?: Context | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the relative path of the property in the metamodel, based on the current contextPath.
     */
    metaPath?: Context | PropertyBindingInfo | `{${string}}`;

    /**
     * The title of the form control.
     */
    title?: string | PropertyBindingInfo;
  }
}

declare module "sap/fe/macros/form/FormElement.block" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Context from "sap/ui/model/Context";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Building block used to create a form element based on the metadata provided by OData V4.
   *
   * @since 1.90.0
   */
  export default class FormElement extends Control {}
  /**
   * Describes the settings that can be provided to the FormElement constructor.
   */
  export interface $FormElementSettings extends $ControlSettings {
    /**
     * Defines the path of the context used in the current page or block.
     * This setting is defined by the framework.
     */
    contextPath?: Context | PropertyBindingInfo | `{${string}}`;

    /**
     * Label shown for the field. If not set, the label from the annotations will be shown.
     */
    label?: string | PropertyBindingInfo;

    /**
     * Defines the relative path of the property in the metamodel, based on the current contextPath.
     */
    metaPath?: Context | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to false, the FormElement is not rendered.
     */
    visible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Optional aggregation of controls that should be displayed inside the FormElement.
     * If not set, a default Field building block will be rendered
     */
    fields?: Control;
  }

  /**
   * Parameters of the FormElement#change event.
   */
  export interface FormElement$ChangeEventParameters {}

  /**
   * Event object of the FormElement#change event.
   */
  export type FormElement$ChangeEvent = Event<
    FormElement$ChangeEventParameters,
    FormElement
  >;
}

declare module "sap/fe/macros/microchart/MicroChart" {
  import {
    default as MicroChart1,
    $MicroChartSettings as $MicroChartSettings1,
  } from "sap/fe/macros/MicroChart";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Building block used to create a MicroChart based on the metadata provided by OData V4.
   *
   *
   * Usually, a contextPath and metaPath is expected.
   * Usage example:
   *
   * ```javascript
   *
   * sap.ui.require(["sap/fe/macros/microchart/MicroChart"], function(MicroChart) {
   * 	 ...
   * 	 new MicroChart("microChartID", {metaPath:"MyProperty"})
   * })
   * ```
   *
   * This is currently an experimental API because the structure of the generated content will change to come
   * closer to the MicroChart that you get out of templates.
   * The public method and property will not change but the internal structure will so be careful on your
   * usage.
   *
   *
   * @deprecated As of version 1.130. Use {@link sap.fe.macros.MicroChart } instead
   * @experimental
   */
  export default class MicroChart extends MicroChart1 {
    /**
     * Gets current value of property contextPath.
     *
     *
     * @returns Value of property `contextPath`
     */
    getContextPath(): string;
    /**
     * Gets current value of property hideOnNoData.
     *
     *
     * @returns Value of property `hideOnNoData`
     */
    getHideOnNoData(): boolean;
    /**
     * Gets current value of property metaPath.
     *
     *
     * @returns Value of property `metaPath`
     */
    getMetaPath(): string;
    /**
     * Gets current value of property showOnlyChart.
     *
     *
     * @returns Value of property `showOnlyChart`
     */
    getShowOnlyChart(): boolean;
    /**
     * Gets current value of property size.
     *
     *
     * @returns Value of property `size`
     */
    getSize(): string;
    /**
     * Gets current value of property contextPath.
     *
     *
     * @returns Value of property `contextPath`
     */
    setContextPath(): string;
    /**
     * Gets current value of property hideOnNoData.
     *
     *
     * @returns Value of property `hideOnNoData`
     */
    setHideOnNoData(): boolean;
    /**
     * Gets current value of property metaPath.
     *
     *
     * @returns Value of property `metaPath`
     */
    setMetaPath(): string;
    /**
     * Gets current value of property showOnlyChart.
     *
     *
     * @returns Value of property `showOnlyChart`
     */
    setShowOnlyChart(): boolean;
    /**
     * Gets current value of property size.
     *
     *
     * @returns Value of property `size`
     */
    setSize(): string;
  }
  /**
   * Describes the settings that can be provided to the MicroChart constructor.
   *
   * @deprecated As of version 1.130. Use {@link sap.fe.macros.MicroChart } instead
   * @experimental
   */
  export interface $MicroChartSettings extends $MicroChartSettings1 {
    /**
     * context path to the MicroChart.
     */
    contextPath?: string | PropertyBindingInfo;

    /**
     * Show blank space in case there is no data in the chart
     */
    hideOnNoData?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Metadata path to the  MicroChart.
     */
    metaPath?: string | PropertyBindingInfo;

    /**
     * To control the rendering of Title, Subtitle and Currency Labels. When the size is xs then we do
     * not see the inner labels of the MicroChart as well.
     */
    showOnlyChart?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Size of the MicroChart
     */
    size?: string | PropertyBindingInfo;
  }
}

declare module "sap/fe/macros/richtexteditor/ButtonGroup" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Button configurations for the RichTextEditor.
   */
  export default class ButtonGroup extends UI5Element {}
  /**
   * Describes the settings that can be provided to the ButtonGroup constructor.
   */
  export interface $ButtonGroupSettings extends $ElementSettings {
    /**
     * The buttons to be displayed in the group.
     */
    buttons?: string | PropertyBindingInfo;

    /**
     * The priority of the group in the custom toolbar.
     */
    customToolbarPriority?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * The name of the group.
     */
    name?: string | PropertyBindingInfo;

    /**
     * The priority of the group.
     */
    priority?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Row number in which the button should be
     */
    row?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Whether the group is visible.
     */
    visible?: string | PropertyBindingInfo;
  }
}

declare module "sap/fe/macros/richtexteditor/Plugin" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Represents a TinyMCE plugin.
   * Each object has to contain a property "name" which then contains the plugin name/ID.
   */
  export default class Plugin extends UI5Element {}
  /**
   * Describes the settings that can be provided to the Plugin constructor.
   */
  export interface $PluginSettings extends $ElementSettings {
    /**
     * The plugin name.
     */
    name?: string | PropertyBindingInfo;
  }
}

declare module "sap/fe/macros/share/ShareOptions" {
  import {
    default as BuildingBlockObjectProperty,
    $BuildingBlockObjectPropertySettings,
  } from "sap/fe/macros/controls/BuildingBlockObjectProperty";

  /**
   * Share Options.
   */
  export default class ShareOptions extends BuildingBlockObjectProperty {}
  /**
   * Describes the settings that can be provided to the ShareOptions constructor.
   */
  export interface $ShareOptionsSettings
    extends $BuildingBlockObjectPropertySettings {}
}

declare module "sap/fe/macros/table/Action" {
  import {
    default as BuildingBlockObjectProperty,
    $BuildingBlockObjectPropertySettings,
  } from "sap/fe/macros/controls/BuildingBlockObjectProperty";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Definition of a custom action to be used inside the table toolbar
   */
  export default class Action extends BuildingBlockObjectProperty {}
  /**
   * Describes the settings that can be provided to the Action constructor.
   */
  export interface $ActionSettings
    extends $BuildingBlockObjectPropertySettings {
    /**
     * Reference to the key of another action already displayed in the toolbar to properly place this one
     */
    anchor?: string | PropertyBindingInfo;

    /**
     * Determines the shortcut combination to trigger the action
     */
    command?: string | PropertyBindingInfo;

    /**
     * Enables or disables the action
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the action requires selecting one item or multiple items.
     * Allowed values are `single` and `multi`
     */
    enableOnSelect?: string | PropertyBindingInfo;

    /**
     * Unique identifier of the action
     */
    key?: string | PropertyBindingInfo;

    /**
     * Defines where this action should be placed relative to the defined anchor
     * Allowed values are `Before` and `After`
     */
    placement?: string | PropertyBindingInfo;

    /**
     * Defines if the action requires a selection.
     */
    requiresSelection?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The text that will be displayed for this action
     */
    text?: string | PropertyBindingInfo;

    /**
     * Determines whether the action is visible.
     */
    visible?: boolean | PropertyBindingInfo | `{${string}}`;
  }

  /**
   * Parameters of the Action#press event.
   */
  export interface Action$PressEventParameters {}

  /**
   * Event object of the Action#press event.
   */
  export type Action$PressEvent = Event<Action$PressEventParameters, Action>;
}

declare module "sap/fe/macros/table/ActionGroup" {
  import {
    default as BuildingBlockObjectProperty,
    $BuildingBlockObjectPropertySettings,
  } from "sap/fe/macros/controls/BuildingBlockObjectProperty";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import ActionOverride from "sap/fe/macros/table/ActionOverride";

  import Action from "sap/fe/macros/table/Action";

  /**
   * Definition of a custom ActionGroup to be used inside the table toolbar
   */
  export default class ActionGroup extends BuildingBlockObjectProperty {}
  /**
   * Describes the settings that can be provided to the ActionGroup constructor.
   */
  export interface $ActionGroupSettings
    extends $BuildingBlockObjectPropertySettings {
    /**
     * Reference to the key of another action or action group already displayed in the toolbar to properly place
     * this one
     */
    anchor?: string | PropertyBindingInfo;

    /**
     * Determines the default action to be executed on the action group.
     */
    defaultAction?: string | PropertyBindingInfo;

    /**
     * Unique identifier of the ActionGroup
     */
    key?: string | PropertyBindingInfo;

    /**
     * Determines where this action group should be placed relative to the defined anchor
     * Allowed values are `Before` and `After`
     */
    placement?: string | PropertyBindingInfo;

    /**
     * The text that will be displayed for this action group
     */
    text?: string | PropertyBindingInfo;

    /**
     * Determines the nested actions
     */
    actions?:
      | Array<ActionOverride | Action>
      | ActionOverride
      | Action
      | AggregationBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/fe/macros/table/ActionGroupOverride" {
  import {
    default as BuildingBlockObjectProperty,
    $BuildingBlockObjectPropertySettings,
  } from "sap/fe/macros/controls/BuildingBlockObjectProperty";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import ActionOverride from "sap/fe/macros/table/ActionOverride";

  import Action from "sap/fe/macros/table/Action";

  /**
   * Definition of an action group override to be used inside the Table building block.
   */
  export default class ActionGroupOverride extends BuildingBlockObjectProperty {}
  /**
   * Describes the settings that can be provided to the ActionGroupOverride constructor.
   */
  export interface $ActionGroupOverrideSettings
    extends $BuildingBlockObjectPropertySettings {
    /**
     * Reference to the key of another action or action group already displayed in the toolbar to properly place
     * this one
     */
    anchor?: string | PropertyBindingInfo;

    /**
     * Unique identifier of the ActionGroup to overridden.
     */
    key?: string | PropertyBindingInfo;

    /**
     * Determines where this action group should be placed relative to the defined anchor
     * Allowed values are `Before` and `After`
     */
    placement?: string | PropertyBindingInfo;

    /**
     * Determines the nested actions
     */
    actions?:
      | Array<ActionOverride | Action>
      | ActionOverride
      | Action
      | AggregationBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/fe/macros/table/ActionOverride" {
  import {
    default as BuildingBlockObjectProperty,
    $BuildingBlockObjectPropertySettings,
  } from "sap/fe/macros/controls/BuildingBlockObjectProperty";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Definition of an override for the action to be used inside the Table building block.
   */
  export default class ActionOverride extends BuildingBlockObjectProperty {}
  /**
   * Describes the settings that can be provided to the ActionOverride constructor.
   */
  export interface $ActionOverrideSettings
    extends $BuildingBlockObjectPropertySettings {
    /**
     * Reference to the key of another action already displayed in the toolbar to properly place this one
     */
    anchor?: string | PropertyBindingInfo;

    /**
     * Determines the shortcut combination to trigger the action
     */
    command?: string | PropertyBindingInfo;

    /**
     * Determines the function to get the default values of the action.
     */
    defaultValuesFunction?: string | PropertyBindingInfo;

    /**
     * Determines if the auto scroll is enabled after executing the action.
     */
    enableAutoScroll?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Enables or disables the action
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the action requires selecting one item or multiple items.
     * Allowed values are `single` and `multi`
     */
    enableOnSelect?: string | PropertyBindingInfo;

    /**
     * Unique identifier of the action to overridden.
     */
    key?: string | PropertyBindingInfo;

    /**
     * Determines whether there is a navigation after executing the action.
     */
    navigateToInstance?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines where this action should be placed relative to the defined anchor
     * Allowed values are `Before` and `After`
     */
    placement?: string | PropertyBindingInfo;

    /**
     * Determines whether the action is visible.
     */
    visible?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/fe/macros/table/AnalyticalConfiguration" {
  import {
    default as BuildingBlockObjectProperty,
    $BuildingBlockObjectPropertySettings,
  } from "sap/fe/macros/controls/BuildingBlockObjectProperty";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * A set of options that can be configured to control the aggregation behavior
   */
  export default class AnalyticalConfiguration extends BuildingBlockObjectProperty {}
  /**
   * Describes the settings that can be provided to the AnalyticalConfiguration constructor.
   */
  export interface $AnalyticalConfigurationSettings
    extends $BuildingBlockObjectPropertySettings {
    /**
     * True if leaf level rows shall display aggregated data
     */
    aggregationOnLeafLevel?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/fe/macros/table/Column" {
  import {
    default as BuildingBlockObjectProperty,
    $BuildingBlockObjectPropertySettings,
  } from "sap/fe/macros/controls/BuildingBlockObjectProperty";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import ColumnExportSettings from "sap/fe/macros/table/ColumnExportSettings";

  /**
   * Definition of a custom column to be used inside the table.
   * The template for the column has to be provided as the default aggregation
   */
  export default class Column extends BuildingBlockObjectProperty {}
  /**
   * Describes the settings that can be provided to the Column constructor.
   */
  export interface $ColumnSettings
    extends $BuildingBlockObjectPropertySettings {
    /**
     * Reference to the key of another column already displayed in the table to properly place this one
     */
    anchor?: string | PropertyBindingInfo;

    /**
     * The column availability
     * Allowed values are `Default`, `Adaptation`, `Hidden`
     */
    availability?: string | PropertyBindingInfo;

    /**
     * The text that will be displayed for this column header
     */
    header?: string | PropertyBindingInfo;

    /**
     * Aligns the header as well as the content horizontally
     */
    horizontalAlign?: string | PropertyBindingInfo;

    /**
     * Defines the column importance.
     * You can define which columns should be automatically moved to the pop-in area based on their importance
     */
    importance?: string | PropertyBindingInfo;

    /**
     * Unique identifier of the column
     */
    key?: string | PropertyBindingInfo;

    /**
     * Determines where this column should be placed relative to the defined anchor
     * Allowed values are `Before` and `After`
     */
    placement?: string | PropertyBindingInfo;

    /**
     * Determines the properties displayed in the column
     * The properties allow to export, sort, group, copy, and paste in the column
     */
    properties?: string[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines if the information in the column is required.
     */
    required?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines the text displayed for the column tooltip
     */
    tooltip?: string | PropertyBindingInfo;

    /**
     * Determines the column's width.
     * Allowed values are 'auto', 'value', and 'inherit', according to {@link sap.ui.core.CSSSize }
     */
    width?: string | PropertyBindingInfo;

    /**
     * Indicates if the column header should be a part of the width calculation.
     */
    widthIncludingColumnHeader?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines the export settings for the column.
     */
    exportSettings?: ColumnExportSettings;
  }
}

declare module "sap/fe/macros/table/ColumnExportSettings" {
  import {
    default as BuildingBlockObjectProperty,
    $BuildingBlockObjectPropertySettings,
  } from "sap/fe/macros/controls/BuildingBlockObjectProperty";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Definition of the export settings applied to a column within the table.
   */
  export default class ColumnExportSettings extends BuildingBlockObjectProperty {}
  /**
   * Describes the settings that can be provided to the ColumnExportSettings constructor.
   */
  export interface $ColumnExportSettingsSettings
    extends $BuildingBlockObjectPropertySettings {
    /**
     * Determines the properties of the column.
     */
    property?: string[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines a formatting template that supports indexed placeholders within curly brackets.
     */
    template?: string | PropertyBindingInfo;

    /**
     * Determines the data type of the field
     */
    type?: string | PropertyBindingInfo;

    /**
     * Determines the width of the column in characters
     */
    width?: number | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines if the content needs to be wrapped.
     */
    wrap?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/fe/macros/table/ColumnOverride" {
  import {
    default as BuildingBlockObjectProperty,
    $BuildingBlockObjectPropertySettings,
  } from "sap/fe/macros/controls/BuildingBlockObjectProperty";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import ColumnExportSettings from "sap/fe/macros/table/ColumnExportSettings";

  /**
   * Definition of an override for the column to be used inside the Table building block.
   */
  export default class ColumnOverride extends BuildingBlockObjectProperty {}
  /**
   * Describes the settings that can be provided to the ColumnOverride constructor.
   */
  export interface $ColumnOverrideSettings
    extends $BuildingBlockObjectPropertySettings {
    /**
     * The column availability
     * Allowed values are `Default`, `Adaptation`, `Hidden``
     */
    availability?: string | PropertyBindingInfo;

    /**
     * Aligns the header as well as the content horizontally
     */
    horizontalAlign?: string | PropertyBindingInfo;

    /**
     * Defines the importance of the column.
     * You can define which columns should be automatically moved to the pop-in area based on their importance
     */
    importance?: string | PropertyBindingInfo;

    /**
     * Unique identifier of the column to overridden.
     */
    key?: string | PropertyBindingInfo;

    /**
     * Determines the column's width.
     * Allowed values are 'auto', 'value', and 'inherit', according to {@link sap.ui.core.CSSSize }
     */
    width?: string | PropertyBindingInfo;

    /**
     * Indicates if the column header should be a part of the width calculation.
     */
    widthIncludingColumnHeader?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines the export settings for the column.
     */
    exportSettings?: ColumnExportSettings;
  }
}

declare module "sap/fe/macros/table/MassEdit" {
  import {
    default as BuildingBlockObjectProperty,
    $BuildingBlockObjectPropertySettings,
  } from "sap/fe/macros/controls/BuildingBlockObjectProperty";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import FormContainer from "sap/ui/layout/form/FormContainer";

  /**
   * Definition of the mass edit to be used inside the table.
   */
  export default class MassEdit extends BuildingBlockObjectProperty {}
  /**
   * Describes the settings that can be provided to the MassEdit constructor.
   */
  export interface $MassEditSettings
    extends $BuildingBlockObjectPropertySettings {
    /**
     * Defines the list of fields that should be ignored in the mass edit dialog
     */
    ignoredFields?: string[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the mode of the operation grouping to save the new values
     * Allowed values are `ChangeSet` and `Isolated`
     */
    operationGroupingMode?: string | PropertyBindingInfo;

    /**
     * Defines the list of fields that should be visible in the mass edit dialog
     */
    visibleFields?: string[] | PropertyBindingInfo | `{${string}}`;

    /**
     * The custom form container that can be displayed at the top of the mass edit dialog
     */
    customContent?: FormContainer;
  }
}

declare module "sap/fe/macros/table/QuickVariantSelection" {
  import {
    default as BuildingBlockObjectProperty,
    $BuildingBlockObjectPropertySettings,
  } from "sap/fe/macros/controls/BuildingBlockObjectProperty";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Definition of the quickVariantSelection to be used inside the table.
   */
  export default class QuickVariantSelection extends BuildingBlockObjectProperty {}
  /**
   * Describes the settings that can be provided to the QuickVariantSelection constructor.
   */
  export interface $QuickVariantSelectionSettings
    extends $BuildingBlockObjectPropertySettings {
    /**
     * Defines the list of paths pointing to the selection variants that should be used as quick filters
     */
    paths?: string[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the counts should be displayed next to the text
     */
    showCounts?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/fe/macros/table/Table.block" {
  import {
    default as MacroAPI,
    $MacroAPISettings,
  } from "sap/fe/macros/MacroAPI";

  import PresentationVariant from "sap/fe/navigation/PresentationVariant";

  import Context from "sap/ui/model/odata/v4/Context";

  import SelectionVariant from "sap/fe/navigation/SelectionVariant";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import TableCreationOptions from "sap/fe/macros/table/TableCreationOptions";

  import ActionGroup from "sap/fe/macros/table/ActionGroup";

  import Action from "sap/fe/macros/table/Action";

  import AnalyticalConfiguration from "sap/fe/macros/table/AnalyticalConfiguration";

  import ColumnOverride from "sap/fe/macros/table/ColumnOverride";

  import Column from "sap/fe/macros/table/Column";

  import MassEdit from "sap/fe/macros/table/MassEdit";

  import Text from "sap/m/Text";

  import IllustratedMessage from "sap/m/IllustratedMessage";

  import QuickVariantSelection from "sap/fe/macros/table/QuickVariantSelection";

  import Event from "sap/ui/base/Event";

  /**
   * Building block used to create a table based on the metadata provided by OData V4.
   *
   *
   * Usually, a LineItem, PresentationVariant, or SelectionPresentationVariant annotation is expected, but
   * the Table building block can also be used to display an EntitySet.
   *
   *
   * If a PresentationVariant is specified, then it must have UI.LineItem as the first property of the Visualizations.
   *
   *
   * If a SelectionPresentationVariant is specified, then it must contain a valid PresentationVariant that
   * also has a UI.LineItem as the first property of the Visualizations.
   * Usage example:
   *
   * ```javascript
   *
   * <macros:Table id="MyTable" metaPath="@com.sap.vocabularies.UI.v1.LineItem" />
   * ```
   *
   * {@link demo:sap/fe/core/fpmExplorer/index.html#/buildingBlocks/table Overview of Table Building Blocks}
   */
  export default class Table extends MacroAPI {
    /**
     * Adds a message to the table.
     * The message applies to the whole table and not to an individual table row.
     *
     *
     *
     * @returns Promise The ID of the message
     */
    addMessage(
      /**
       * The parameters to create the message
       */
      parameters: {
        /**
         * Message description
         */
        description?: string;
        /**
         * Message text
         */
        message?: string;
        /**
         * True if the message is persistent
         */
        persistent?: boolean;
        /**
         * Message type
         */
        type?: /* was: sap.ui.core.message.MessageType */ any;
      }
    ): Promise<string>;
    /**
     * Get the variant management applied to the table.
     *
     *
     * @returns Key of the currently selected variant. In case the model is not yet set, `null` will be returned.
     */
    getCurrentVariantKey(): null | string;
    /**
     * Get the fields that should be ignored when generating the table.
     *
     * @since 1.124.0
     * @experimental As of version 1.124.0.
     *
     * @returns The value of the ignoredFields property
     */
    getIgnoredFields(): string;
    /**
     * Get the presentation variant that is currently applied on the table.
     *
     *
     * @returns The presentation variant applied to the table
     */
    getPresentationVariant(): Promise<PresentationVariant>;
    /**
     * Gets contexts from the table that have been selected by the user.
     *
     *
     * @returns Contexts of the rows selected by the user
     */
    getSelectedContexts(): Context[];
    /**
     * Get the selection variant from the table. This function considers only the selection variant applied
     * at the control level.
     *
     *
     * @returns A promise which resolves with {@link sap.fe.navigation.SelectionVariant }
     */
    getSelectionVariant(): Promise<SelectionVariant>;
    /**
     * Hide the columns with the given column keys by setting their availability to Default.
     *
     * @since 1.124.0
     * @experimental As of version 1.124.0.
     *
     * @returns Promise
     */
    hideColumns(
      /**
       * The keys for the columns to hide
       */
      columnKeys: string[]
    ): Promise<void>;
    /**
     * Requests a refresh of the table.
     */
    refresh(): void;
    /**
     * Removes a message from the table.
     */
    removeMessage(
      /**
       * The id of the message
       */
      id: string
    ): void;
    /**
     * Set a variant management to the table.
     */
    setCurrentVariantKey(
      /**
       * Key of the variant that should be selected. If the passed key doesn't identify a variant, it will be
       * ignored.
       */
      key: string
    ): void;
    /**
     * Sets the fields that should be ignored when generating the table.
     *
     * @since 1.124.0
     * @experimental As of version 1.124.0.
     *
     * @returns Reference to this in order to allow method chaining
     */
    setIgnoredFields(
      /**
       * The fields to ignore
       */
      ignoredFields: string
    ): this;
    /**
     * Set a new presentation variant to the table.
     */
    setPresentationVariant(
      /**
       * The new presentation variant that is to be set on the table.
       */
      tablePV: PresentationVariant
    ): Promise<void>;
    /**
     * Sets {@link sap.fe.navigation.SelectionVariant } to the table. Note: setSelectionVariant will clear existing
     * filters and then apply the SelectionVariant values.
     *
     *
     * @returns A promise for asynchronous handling
     */
    setSelectionVariant(
      /**
       * The {@link sap.fe.navigation.SelectionVariant } to apply to the table
       */
      selectionVariant: SelectionVariant,
      /**
       * Optional. If true, we will use the associated text property values (if they're available in the SelectionVariant)
       * to display the filter value descriptions, instead of loading them from the backend
       */
      prefillDescriptions?: boolean
    ): Promise<any>;
    /**
     * Show the columns with the given column keys by setting their availability to Default.
     *
     * @since 1.124.0
     * @experimental As of version 1.124.0.
     *
     * @returns Promise
     */
    showColumns(
      /**
       * The keys for the columns to show
       */
      columnKeys: string[]
    ): Promise<void>;
  }
  /**
   * Describes the settings that can be provided to the Table constructor.
   */
  export interface $TableSettings extends $MacroAPISettings {
    /**
     * An expression that allows you to control the 'busy' state of the table.
     */
    busy?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the table adapts to the condensed layout.
     */
    condensedTableLayout?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the path of the context used in the current page or block.
     * This setting is defined by the framework.
     */
    contextPath?: string | PropertyBindingInfo;

    /**
     * A set of options that can be configured.
     */
    creationMode?: TableCreationOptions | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls if the copy functionality of the table is disabled or not.
     */
    disableCopyToClipboard?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies if the column width is automatically calculated.
     */
    enableAutoColumnWidth?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls if the export functionality of the table is enabled or not.
     */
    enableExport?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls whether the table can be opened in fullscreen mode or not.
     */
    enableFullScreen?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls if the paste functionality of the table is enabled or not.
     */
    enablePaste?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determine whether the data copied to the computed columns is sent to the back end.
     */
    enablePastingOfComputedProperties?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Determines whether the Clear All button is enabled by default.
     * To enable the Clear All button by default, you must set this property to false.
     */
    enableSelectAll?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Maximum allowed number of records to be exported in one request.
     */
    exportRequestSize?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * ID of the FilterBar building block associated with the table.
     */
    filterBar?: string | PropertyBindingInfo;

    /**
     * Number of columns that are fixed on the left. Only columns which are not fixed can be scrolled horizontally.
     * This property is not relevant for responsive tables
     */
    frozenColumnCount?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies the header text that is shown in the table.
     */
    header?: string | PropertyBindingInfo;

    /**
     * Controls if the header text should be shown or not.
     */
    headerVisible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Comma-separated value of fields that must be ignored in the OData metadata by the Table building block.
     *
     * The table building block is not going to create built-in columns or offer table personalization for comma-separated
     * value of fields that are provided in the ignoredfields.
     *
     * Any column referencing an ignored field is to be removed.
     */
    ignoredFields?: string | PropertyBindingInfo;

    /**
     * Defines whether to display the search action.
     */
    isSearchable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the relative path to a LineItem, PresentationVariant or SelectionPresentationVariant in the metamodel,
     * based on the current contextPath.
     */
    metaPath?: string | PropertyBindingInfo;

    /**
     * Changes the size of the IllustratedMessage in the table, or removes it completely.
     * Allowed values are `illustratedMessage-Auto`, `illustratedMessage-Base`, `illustratedMessage-Dialog`,
     * `illustratedMessage-Dot`, `illustratedMessage-Scene`, `illustratedMessage-Spot` or `text`.
     */
    modeForNoDataMessage?: string | PropertyBindingInfo;

    /**
     * Controls which options should be enabled for the table personalization dialog.
     * If it is set to `true`, all possible options for this kind of table are enabled.
     *
     * If it is set to `false`, personalization is disabled.
     *
     *
     *
     * You can also provide a more granular control for the personalization by providing a comma-separated list
     * with the options you want to be available.
     *
     * Available options are:
     *
     * - Sort
     *
     * - Column
     *
     * - Filter
     *
     * - Group
     *
     *
     *
     * The Group option is only applicable to analytical tables and responsive tables.
     */
    personalization?: string | PropertyBindingInfo;

    /**
     * An expression that allows you to control the 'read-only' state of the table.
     * If you do not set any expression, SAP Fiori elements hooks into the standard lifecycle to determine the
     * current state.
     */
    readOnly?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Number of rows to be displayed in the table. Does not apply to responsive tables.
     */
    rowCount?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines how the table handles the visible rows. Does not apply to Responsive tables.
     * Allowed values are `Auto`, `Fixed`, and `Interactive`.
     *
     * - If set to `Fixed`, the table always has as many rows as defined in the rowCount property.
     *
     * - If set to `Auto`, the number of rows is changed by the table automatically. It will then adjust its
     *     row count to the space it is allowed to cover (limited by the surrounding container) but it cannot have
     *     less than defined in the `rowCount` property.
     *
     * - If set to `Interactive` the table can have as many rows as defined in the rowCount property. This number
     *     of rows can be modified by dragging the resizer available in this mode.
     */
    rowCountMode?: string | PropertyBindingInfo;

    /**
     * Defines how many additional data records are requested from the back-end system when the user scrolls
     * vertically in the table.
     */
    scrollThreshold?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the maximum number of rows that can be selected at once in the table.
     * This property does not apply to responsive tables.
     */
    selectionLimit?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the selection mode to be used by the table.
     * Allowed values are `None`, `Single`, `ForceSingle`, `Multi`, `ForceMulti` or `Auto`.
     * If set to 'Single', 'Multi' or 'Auto', SAP Fiori elements hooks into the standard lifecycle to determine
     * the consistent selection mode.
     * If set to 'ForceSingle' or 'ForceMulti' your choice will be respected but this might not respect the
     * Fiori guidelines.
     */
    selectionMode?: string | PropertyBindingInfo;

    /**
     * Defines the type of table that will be used by the building block to render the data.
     * Allowed values are `GridTable`, `ResponsiveTable` and `AnalyticalTable`.
     */
    type?: string | PropertyBindingInfo;

    /**
     * Controls the kind of variant management that should be enabled for the table.
     * Allowed value is `Control`.
     *
     * If set with value `Control`, a variant management control is seen within the table and the table is linked
     * to this.
     *
     * If not set with any value, control level variant management is not available for this table.
     */
    variantManagement?: string | PropertyBindingInfo;

    /**
     * Indicates if the column header should be a part of the width calculation.
     */
    widthIncludingColumnHeader?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Aggregate actions of the table.
     */
    actions?:
      | Array<ActionGroup | Action>
      | ActionGroup
      | Action
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * A set of options that can be configured to control the aggregation behavior
     */
    analyticalConfiguration?: AnalyticalConfiguration;

    /**
     * Aggregate columns of the table.
     */
    columns?:
      | Array<ColumnOverride | Column>
      | ColumnOverride
      | Column
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Aggregate mass edit of the table.
     */
    massEdit?: MassEdit;

    /**
     * Aggregation to forward the IllustratedMessage control to the mdc control.
     */
    noData?: Text | IllustratedMessage | PropertyBindingInfo | `{${string}}`;

    /**
     * Aggregate quickVariantSelection of the table.
     */
    quickVariantSelection?: QuickVariantSelection;
  }

  /**
   * Parameters of the Table#beforeRebindTable event.
   */
  export interface Table$BeforeRebindTableEventParameters {}

  /**
   * Event object of the Table#beforeRebindTable event.
   */
  export type Table$BeforeRebindTableEvent = Event<
    Table$BeforeRebindTableEventParameters,
    Table
  >;

  /**
   * Parameters of the Table#rowPress event.
   */
  export interface Table$RowPressEventParameters {}

  /**
   * Event object of the Table#rowPress event.
   */
  export type Table$RowPressEvent = Event<Table$RowPressEventParameters, Table>;

  /**
   * Parameters of the Table#selectionChange event.
   */
  export interface Table$SelectionChangeEventParameters {}

  /**
   * Event object of the Table#selectionChange event.
   */
  export type Table$SelectionChangeEvent = Event<
    Table$SelectionChangeEventParameters,
    Table
  >;
}

declare module "sap/fe/macros/table/Table" {
  import {
    default as BuildingBlockWithTemplating,
    $BuildingBlockWithTemplatingSettings,
  } from "sap/fe/macros/controls/BuildingBlockWithTemplating";

  import Action from "sap/fe/macros/table/Action";

  import Column from "sap/fe/macros/table/Column";

  import PresentationVariant from "sap/fe/navigation/PresentationVariant";

  import Context from "sap/ui/model/odata/v4/Context";

  import SelectionVariant from "sap/fe/navigation/SelectionVariant";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import TableCreationOptions from "sap/fe/macros/table/TableCreationOptions";

  import ActionGroup from "sap/fe/macros/table/ActionGroup";

  import AnalyticalConfiguration from "sap/fe/macros/table/AnalyticalConfiguration";

  import ColumnOverride from "sap/fe/macros/table/ColumnOverride";

  import MassEdit from "sap/fe/macros/table/MassEdit";

  import Text from "sap/m/Text";

  import IllustratedMessage from "sap/m/IllustratedMessage";

  import QuickVariantSelection from "sap/fe/macros/table/QuickVariantSelection";

  import Event from "sap/ui/base/Event";

  /**
   * Building block used to create a table based on the metadata provided by OData V4.
   *
   *
   * Usually, a LineItem, PresentationVariant or SelectionPresentationVariant annotation is expected, but
   * the Table building block can also be used to display an EntitySet.
   *
   *
   * If a PresentationVariant is specified, then it must have UI.LineItem as the first property of the Visualizations.
   *
   *
   * If a SelectionPresentationVariant is specified, then it must contain a valid PresentationVariant that
   * also has a UI.LineItem as the first property of the Visualizations.
   * Usage example:
   *
   * ```javascript
   *
   * sap.ui.require(["sap/fe/macros/table/Table"], function(Table) {
   * 	 ...
   * 	 new Table("myTable", {metaPath:"@com.sap.vocabularies.UI.v1.LineItem"})
   * })
   * ```
   *
   * This is currently an experimental API because the structure of the generated content will change to come
   * closer to the Table that you get out of templates.
   * The public method and property will not change but the internal structure will so be careful on your
   * usage.
   *
   *
   * @since 1.124.0
   * @experimental As of version 1.124.0.
   */
  export default class Table extends BuildingBlockWithTemplating {
    /**
     * Adds an action to the table.
     *
     * @since 1.124.0
     * @experimental As of version 1.124.0.
     *
     * @returns Reference to this in order to allow method chaining
     */
    addAction(
      /**
       * The action to add
       */
      action: Action
    ): this;
    /**
     * Adds a column to the table.
     *
     * @since 1.124.0
     * @experimental As of version 1.124.0.
     *
     * @returns Reference to this in order to allow method chaining
     */
    addColumn(
      /**
       * The column to add
       */
      column: Column
    ): this;
    /**
     * Adds a message to the table.
     * The message applies to the whole table and not to an individual table row.
     *
     *
     *
     * @returns Promise The ID of the message
     */
    addMessage(
      /**
       * The parameters to create the message
       */
      parameters: {
        /**
         * Message description
         */
        description?: string;
        /**
         * Message text
         */
        message?: string;
        /**
         * True if the message is persistent
         */
        persistent?: boolean;
        /**
         * Message type
         */
        type?: /* was: sap.ui.core.message.MessageType */ any;
      }
    ): Promise<string>;
    /**
     * Get the variant management applied to the table.
     *
     *
     * @returns Key of the currently selected variant. In case the model is not yet set, `null` will be returned.
     */
    getCurrentVariantKey(): null | string;
    /**
     * Get the fields that should be ignored when generating the table.
     *
     * @since 1.124.0
     * @experimental As of version 1.124.0.
     *
     * @returns The value of the ignoredFields property
     */
    getIgnoredFields(): string;
    /**
     * Gets the path to the metadata that should be used to generate the table.
     *
     * @since 1.124.0
     * @experimental As of version 1.124.0.
     *
     * @returns The path to the metadata
     */
    getMetaPath(): string;
    /**
     * Get the presentation variant that is currently applied on the table.
     *
     *
     * @returns The presentation variant applied to the table
     */
    getPresentationVariant(): Promise<PresentationVariant>;
    /**
     * Gets contexts from the table that have been selected by the user.
     *
     *
     * @returns Contexts of the rows selected by the user
     */
    getSelectedContexts(): Context[];
    /**
     * Get the selection variant from the table. This function considers only the selection variant applied
     * at the control level.
     *
     *
     * @returns A promise which resolves with {@link sap.fe.navigation.SelectionVariant }
     */
    getSelectionVariant(): Promise<SelectionVariant>;
    /**
     * Hide the columns with the given column keys by setting their availability to Default.
     *
     * @since 1.124.0
     * @experimental As of version 1.124.0.
     *
     * @returns Promise
     */
    hideColumns(
      /**
       * The keys for the columns to hide
       */
      columnKeys: string[]
    ): Promise<void>;
    /**
     * Requests a refresh of the table.
     */
    refresh(): void;
    /**
     * Removes an action from the table.
     *
     * @since 1.124.0
     * @experimental As of version 1.124.0.
     *
     * @returns The removed action or null
     */
    removeAction(
      /**
       * The action to remove, or its index or ID
       */
      action: number | Action | string
    ): null | Action;
    /**
     * Removes a column from the table.
     *
     * @since 1.124.0
     * @experimental As of version 1.124.0.
     *
     * @returns The removed column or null
     */
    removeColumn(
      /**
       * The column to remove, or its index or ID
       */
      column: number | Column | string
    ): null | Column;
    /**
     * Removes a message from the table.
     */
    removeMessage(
      /**
       * The id of the message
       */
      id: string
    ): void;
    /**
     * Set a variant management to the table.
     */
    setCurrentVariantKey(
      /**
       * Key of the variant that should be selected. If the passed key doesn't identify a variant, it will be
       * ignored.
       */
      key: string
    ): void;
    /**
     * Sets the fields that should be ignored when generating the table.
     *
     * @since 1.124.0
     * @experimental As of version 1.124.0.
     *
     * @returns Reference to this in order to allow method chaining
     */
    setIgnoredFields(
      /**
       * The fields to ignore
       */
      ignoredFields: string
    ): this;
    /**
     * Sets the path to the metadata that should be used to generate the table.
     *
     * @since 1.124.0
     * @experimental As of version 1.124.0.
     *
     * @returns Reference to this in order to allow method chaining
     */
    setMetaPath(
      /**
       * The path to the metadata
       */
      metaPath: string
    ): this;
    /**
     * Set a new presentation variant to the table.
     */
    setPresentationVariant(
      /**
       * The new presentation variant that is to be set on the table.
       */
      tablePV: PresentationVariant
    ): Promise<void>;
    /**
     * Sets {@link sap.fe.navigation.SelectionVariant } to the table. Note: setSelectionVariant will clear existing
     * filters and then apply the SelectionVariant values.
     *
     *
     * @returns A promise for asynchronous handling
     */
    setSelectionVariant(
      /**
       * The {@link sap.fe.navigation.SelectionVariant } to apply to the table
       */
      selectionVariant: SelectionVariant,
      /**
       * Optional. If true, we will use the associated text property values (if they're available in the SelectionVariant)
       * to display the filter value descriptions, instead of loading them from the backend
       */
      prefillDescriptions?: boolean
    ): Promise<any>;
    /**
     * Show the columns with the given column keys by setting their availability to Default.
     *
     * @since 1.124.0
     * @experimental As of version 1.124.0.
     *
     * @returns Promise
     */
    showColumns(
      /**
       * The keys for the columns to show
       */
      columnKeys: string[]
    ): Promise<void>;
  }
  /**
   * Describes the settings that can be provided to the Table constructor.
   *
   * @experimental As of version 1.124.0.
   */
  export interface $TableSettings extends $BuildingBlockWithTemplatingSettings {
    /**
     * An expression that allows you to control the 'busy' state of the table.
     */
    busy?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the table adapts to the condensed layout.
     */
    condensedTableLayout?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the path of the context used in the current page or block.
     * This setting is defined by the framework.
     */
    contextPath?: string | PropertyBindingInfo;

    /**
     * A set of options that can be configured.
     */
    creationMode?: TableCreationOptions | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls if the copy functionality of the table is disabled or not.
     */
    disableCopyToClipboard?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies if the column width is automatically calculated.
     */
    enableAutoColumnWidth?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls if the export functionality of the table is enabled or not.
     */
    enableExport?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls whether the table can be opened in fullscreen mode or not.
     */
    enableFullScreen?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls if the paste functionality of the table is enabled or not.
     */
    enablePaste?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determine whether the data copied to the computed columns is sent to the back end.
     */
    enablePastingOfComputedProperties?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Determines whether the Clear All button is enabled by default.
     * To enable the Clear All button by default, you must set this property to false.
     */
    enableSelectAll?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Maximum allowed number of records to be exported in one request.
     */
    exportRequestSize?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * ID of the FilterBar building block associated with the table.
     */
    filterBar?: string | PropertyBindingInfo;

    /**
     * Number of columns that are fixed on the left. Only columns which are not fixed can be scrolled horizontally.
     * This property is not relevant for responsive tables
     */
    frozenColumnCount?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies the header text that is shown in the table.
     */
    header?: string | PropertyBindingInfo;

    /**
     * Controls if the header text should be shown or not.
     */
    headerVisible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Comma-separated value of fields that must be ignored in the OData metadata by the Table building block.
     *
     * The table building block is not going to create built-in columns or offer table personalization for comma-separated
     * value of fields that are provided in the ignoredfields.
     *
     * Any column referencing an ignored field is to be removed.
     */
    ignoredFields?: string | PropertyBindingInfo;

    /**
     * Defines whether to display the search action.
     */
    isSearchable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the relative path to a LineItem, PresentationVariant or SelectionPresentationVariant in the metamodel,
     * based on the current contextPath.
     */
    metaPath?: string | PropertyBindingInfo;

    /**
     * Changes the size of the IllustratedMessage in the table, or removes it completely.
     * Allowed values are `illustratedMessage-Auto`, `illustratedMessage-Base`, `illustratedMessage-Dialog`,
     * `illustratedMessage-Dot`, `illustratedMessage-Scene`, `illustratedMessage-Spot` or `text`.
     */
    modeForNoDataMessage?: string | PropertyBindingInfo;

    /**
     * Controls which options should be enabled for the table personalization dialog.
     * If it is set to `true`, all possible options for this kind of table are enabled.
     *
     * If it is set to `false`, personalization is disabled.
     *
     *
     *
     * You can also provide a more granular control for the personalization by providing a comma-separated list
     * with the options you want to be available.
     *
     * Available options are:
     *
     * - Sort
     *
     * - Column
     *
     * - Filter
     *
     * - Group
     *
     *
     *
     * The Group option is only applicable to analytical tables and responsive tables.
     */
    personalization?: string | PropertyBindingInfo;

    /**
     * An expression that allows you to control the 'read-only' state of the table.
     * If you do not set any expression, SAP Fiori elements hooks into the standard lifecycle to determine the
     * current state.
     */
    readOnly?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Number of rows to be displayed in the table. Does not apply to responsive tables.
     */
    rowCount?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines how the table handles the visible rows. Does not apply to Responsive tables.
     * Allowed values are `Auto`, `Fixed`, and `Interactive`.
     *
     * - If set to `Fixed`, the table always has as many rows as defined in the rowCount property.
     *
     * - If set to `Auto`, the number of rows is changed by the table automatically. It will then adjust its
     *     row count to the space it is allowed to cover (limited by the surrounding container) but it cannot have
     *     less than defined in the `rowCount` property.
     *
     * - If set to `Interactive` the table can have as many rows as defined in the rowCount property. This number
     *     of rows can be modified by dragging the resizer available in this mode.
     */
    rowCountMode?: string | PropertyBindingInfo;

    /**
     * Defines how many additional data records are requested from the back-end system when the user scrolls
     * vertically in the table.
     */
    scrollThreshold?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the maximum number of rows that can be selected at once in the table.
     * This property does not apply to responsive tables.
     */
    selectionLimit?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the selection mode to be used by the table.
     * Allowed values are `None`, `Single`, `ForceSingle`, `Multi`, `ForceMulti` or `Auto`.
     * If set to 'Single', 'Multi' or 'Auto', SAP Fiori elements hooks into the standard lifecycle to determine
     * the consistent selection mode.
     * If set to 'ForceSingle' or 'ForceMulti' your choice will be respected but this might not respect the
     * Fiori guidelines.
     */
    selectionMode?: string | PropertyBindingInfo;

    /**
     * Defines the type of table that will be used by the building block to render the data.
     * Allowed values are `GridTable`, `ResponsiveTable` and `AnalyticalTable`.
     */
    type?: string | PropertyBindingInfo;

    /**
     * Controls the kind of variant management that should be enabled for the table.
     * Allowed value is `Control`.
     *
     * If set with value `Control`, a variant management control is seen within the table and the table is linked
     * to this.
     *
     * If not set with any value, control level variant management is not available for this table.
     */
    variantManagement?: string | PropertyBindingInfo;

    /**
     * Indicates if the column header should be a part of the width calculation.
     */
    widthIncludingColumnHeader?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Aggregate actions of the table.
     */
    actions?:
      | Array<ActionGroup | Action>
      | ActionGroup
      | Action
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * A set of options that can be configured to control the aggregation behavior
     */
    analyticalConfiguration?: AnalyticalConfiguration;

    /**
     * Aggregate columns of the table.
     */
    columns?:
      | Array<ColumnOverride | Column>
      | ColumnOverride
      | Column
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Aggregate mass edit of the table.
     */
    massEdit?: MassEdit;

    /**
     * Aggregation to forward the IllustratedMessage control to the mdc control.
     */
    noData?: Text | IllustratedMessage | PropertyBindingInfo | `{${string}}`;

    /**
     * Aggregate quickVariantSelection of the table.
     */
    quickVariantSelection?: QuickVariantSelection;
  }

  /**
   * Parameters of the Table#beforeRebindTable event.
   */
  export interface Table$BeforeRebindTableEventParameters {}

  /**
   * Event object of the Table#beforeRebindTable event.
   */
  export type Table$BeforeRebindTableEvent = Event<
    Table$BeforeRebindTableEventParameters,
    Table
  >;

  /**
   * Parameters of the Table#rowPress event.
   */
  export interface Table$RowPressEventParameters {}

  /**
   * Event object of the Table#rowPress event.
   */
  export type Table$RowPressEvent = Event<Table$RowPressEventParameters, Table>;

  /**
   * Parameters of the Table#selectionChange event.
   */
  export interface Table$SelectionChangeEventParameters {}

  /**
   * Event object of the Table#selectionChange event.
   */
  export type Table$SelectionChangeEvent = Event<
    Table$SelectionChangeEventParameters,
    Table
  >;
}

declare module "sap/fe/macros/table/TableCreationOptions" {
  import {
    default as BuildingBlockObjectProperty,
    $BuildingBlockObjectPropertySettings,
  } from "sap/fe/macros/controls/BuildingBlockObjectProperty";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Create options for the table.
   */
  export default class TableCreationOptions extends BuildingBlockObjectProperty {}
  /**
   * Describes the settings that can be provided to the TableCreationOptions constructor.
   */
  export interface $TableCreationOptionsSettings
    extends $BuildingBlockObjectPropertySettings {
    /**
     * Specifies if the new entry should be created at the top or bottom of a table in case of creationMode
     * 'Inline'
     *
     * The default value is 'false'
     */
    createAtEnd?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the list of properties that will be displayed in the creation dialog, when the creation mode
     * is set to 'CreationDialog'.
     *
     * The value is a comma-separated list of property names.
     */
    creationFields?: string | PropertyBindingInfo;

    /**
     * Specifies if the new entry should be hidden in case of creationMode 'InlineCreationRows'. This only applies
     * to responsive tables.
     *
     * The default value is 'false'
     */
    inlineCreationRowsHiddenInEditMode?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the creation mode to be used by the table.
     * Allowed values are `NewPage`, `Inline`, `InlineCreationsRows`, `External` or `CreationDialog`.
     *
     *
     *
     * NewPage - the created document is shown in a new page, depending on whether metadata 'Sync', 'Async'
     * or 'Deferred' is used
     *
     * Inline - The creation is done inline
     *
     * InlineCreationsRows - The creation is done inline with an empty row
     *
     * External - The creation is done in a different application specified via the parameter 'outbound'
     * CreationDialog - the creation is done in the table, with a dialog allowing to specify some initial property
     * values (the properties are listed in `creationFields`).
     *
     * If not set with any value:
     *
     * if navigation is defined, the default value is 'NewPage'. Otherwise it is 'Inline'.
     */
    name?: string | PropertyBindingInfo;

    /**
     * The navigation target where the document is created in case of creationMode 'External'
     */
    outbound?: string | PropertyBindingInfo;
  }
}

declare module "sap/fe/macros/table/TreeTable.block" {
  import {
    default as MacroAPI,
    $MacroAPISettings,
  } from "sap/fe/macros/MacroAPI";

  import PresentationVariant from "sap/fe/navigation/PresentationVariant";

  import Context from "sap/ui/model/odata/v4/Context";

  import SelectionVariant from "sap/fe/navigation/SelectionVariant";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import TreeTableCreationOptions from "sap/fe/macros/table/TreeTableCreationOptions";

  import ActionGroup from "sap/fe/macros/table/ActionGroup";

  import Action from "sap/fe/macros/table/Action";

  import AnalyticalConfiguration from "sap/fe/macros/table/AnalyticalConfiguration";

  import ColumnOverride from "sap/fe/macros/table/ColumnOverride";

  import Column from "sap/fe/macros/table/Column";

  import MassEdit from "sap/fe/macros/table/MassEdit";

  import Text from "sap/m/Text";

  import IllustratedMessage from "sap/m/IllustratedMessage";

  import QuickVariantSelection from "sap/fe/macros/table/QuickVariantSelection";

  import Event from "sap/ui/base/Event";

  /**
   * Building block used to create a tree table based on the metadata provided by OData V4.
   * {@link demo:sap/fe/core/fpmExplorer/index.html#/buildingBlocks/table/treeTable Overview of Tree Table Building Block}
   */
  export default class TreeTable extends MacroAPI {
    /**
     * Adds a message to the table.
     * The message applies to the whole table and not to an individual table row.
     *
     *
     *
     * @returns Promise The ID of the message
     */
    addMessage(
      /**
       * The parameters to create the message
       */
      parameters: {
        /**
         * Message description
         */
        description?: string;
        /**
         * Message text
         */
        message?: string;
        /**
         * True if the message is persistent
         */
        persistent?: boolean;
        /**
         * Message type
         */
        type?: /* was: sap.ui.core.message.MessageType */ any;
      }
    ): Promise<string>;
    /**
     * Get the variant management applied to the table.
     *
     *
     * @returns Key of the currently selected variant. In case the model is not yet set, `null` will be returned.
     */
    getCurrentVariantKey(): null | string;
    /**
     * Get the fields that should be ignored when generating the table.
     *
     * @since 1.124.0
     * @experimental As of version 1.124.0.
     *
     * @returns The value of the ignoredFields property
     */
    getIgnoredFields(): string;
    /**
     * Get the presentation variant that is currently applied on the table.
     *
     *
     * @returns The presentation variant applied to the table
     */
    getPresentationVariant(): Promise<PresentationVariant>;
    /**
     * Gets contexts from the table that have been selected by the user.
     *
     *
     * @returns Contexts of the rows selected by the user
     */
    getSelectedContexts(): Context[];
    /**
     * Get the selection variant from the table. This function considers only the selection variant applied
     * at the control level.
     *
     *
     * @returns A promise which resolves with {@link sap.fe.navigation.SelectionVariant }
     */
    getSelectionVariant(): Promise<SelectionVariant>;
    /**
     * Hide the columns with the given column keys by setting their availability to Default.
     *
     * @since 1.124.0
     * @experimental As of version 1.124.0.
     *
     * @returns Promise
     */
    hideColumns(
      /**
       * The keys for the columns to hide
       */
      columnKeys: string[]
    ): Promise<void>;
    /**
     * Requests a refresh of the table.
     */
    refresh(): void;
    /**
     * Removes a message from the table.
     */
    removeMessage(
      /**
       * The id of the message
       */
      id: string
    ): void;
    /**
     * Set a variant management to the table.
     */
    setCurrentVariantKey(
      /**
       * Key of the variant that should be selected. If the passed key doesn't identify a variant, it will be
       * ignored.
       */
      key: string
    ): void;
    /**
     * Sets the fields that should be ignored when generating the table.
     *
     * @since 1.124.0
     * @experimental As of version 1.124.0.
     *
     * @returns Reference to this in order to allow method chaining
     */
    setIgnoredFields(
      /**
       * The fields to ignore
       */
      ignoredFields: string
    ): this;
    /**
     * Set a new presentation variant to the table.
     */
    setPresentationVariant(
      /**
       * The new presentation variant that is to be set on the table.
       */
      tablePV: PresentationVariant
    ): Promise<void>;
    /**
     * Sets {@link sap.fe.navigation.SelectionVariant } to the table. Note: setSelectionVariant will clear existing
     * filters and then apply the SelectionVariant values.
     *
     *
     * @returns A promise for asynchronous handling
     */
    setSelectionVariant(
      /**
       * The {@link sap.fe.navigation.SelectionVariant } to apply to the table
       */
      selectionVariant: SelectionVariant,
      /**
       * Optional. If true, we will use the associated text property values (if they're available in the SelectionVariant)
       * to display the filter value descriptions, instead of loading them from the backend
       */
      prefillDescriptions?: boolean
    ): Promise<any>;
    /**
     * Show the columns with the given column keys by setting their availability to Default.
     *
     * @since 1.124.0
     * @experimental As of version 1.124.0.
     *
     * @returns Promise
     */
    showColumns(
      /**
       * The keys for the columns to show
       */
      columnKeys: string[]
    ): Promise<void>;
  }
  /**
   * Describes the settings that can be provided to the TreeTable constructor.
   */
  export interface $TreeTableSettings extends $MacroAPISettings {
    /**
     * An expression that allows you to control the 'busy' state of the table.
     */
    busy?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the table adapts to the condensed layout.
     */
    condensedTableLayout?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the path of the context used in the current page or block.
     * This setting is defined by the framework.
     */
    contextPath?: string | PropertyBindingInfo;

    /**
     * A set of options that can be configured.
     */
    creationMode?:
      | TreeTableCreationOptions
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Controls if the copy functionality of the table is disabled or not.
     */
    disableCopyToClipboard?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies if the column width is automatically calculated.
     */
    enableAutoColumnWidth?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls if the export functionality of the table is enabled or not.
     */
    enableExport?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls whether the table can be opened in fullscreen mode or not.
     */
    enableFullScreen?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls if the paste functionality of the table is enabled or not.
     */
    enablePaste?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determine whether the data copied to the computed columns is sent to the back end.
     */
    enablePastingOfComputedProperties?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Determines whether the Clear All button is enabled by default.
     * To enable the Clear All button by default, you must set this property to false.
     */
    enableSelectAll?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Maximum allowed number of records to be exported in one request.
     */
    exportRequestSize?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * ID of the FilterBar building block associated with the table.
     */
    filterBar?: string | PropertyBindingInfo;

    /**
     * Number of columns that are fixed on the left. Only columns which are not fixed can be scrolled horizontally.
     * This property is not relevant for responsive tables
     */
    frozenColumnCount?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies the header text that is shown in the table.
     */
    header?: string | PropertyBindingInfo;

    /**
     * Controls if the header text should be shown or not.
     */
    headerVisible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * A set of options that can be configured.
     */
    hierarchyQualifier?: string | PropertyBindingInfo;

    /**
     * Comma-separated value of fields that must be ignored in the OData metadata by the Table building block.
     *
     * The table building block is not going to create built-in columns or offer table personalization for comma-separated
     * value of fields that are provided in the ignoredfields.
     *
     * Any column referencing an ignored field is to be removed.
     */
    ignoredFields?: string | PropertyBindingInfo;

    /**
     * Defines the extension point to control whether a source node can be copied to a specific parent node.
     */
    isCopyToPositionAllowed?: string | PropertyBindingInfo;

    /**
     * Defines the extension point to control whether a source node can be dropped on a specific parent node.
     */
    isMoveToPositionAllowed?: string | PropertyBindingInfo;

    /**
     * efines the extension point to control whether a node can be copied.
     */
    isNodeCopyable?: string | PropertyBindingInfo;

    /**
     * Defines the extension point to control if a node can be dragged.
     */
    isNodeMovable?: string | PropertyBindingInfo;

    /**
     * Defines whether to display the search action.
     */
    isSearchable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the relative path to a LineItem, PresentationVariant or SelectionPresentationVariant in the metamodel,
     * based on the current contextPath.
     */
    metaPath?: string | PropertyBindingInfo;

    /**
     * Changes the size of the IllustratedMessage in the table, or removes it completely.
     * Allowed values are `illustratedMessage-Auto`, `illustratedMessage-Base`, `illustratedMessage-Dialog`,
     * `illustratedMessage-Dot`, `illustratedMessage-Scene`, `illustratedMessage-Spot` or `text`.
     */
    modeForNoDataMessage?: string | PropertyBindingInfo;

    /**
     * Controls which options should be enabled for the table personalization dialog.
     * If it is set to `true`, all possible options for this kind of table are enabled.
     *
     * If it is set to `false`, personalization is disabled.
     *
     *
     *
     * You can also provide a more granular control for the personalization by providing a comma-separated list
     * with the options you want to be available.
     *
     * Available options are:
     *
     * - Sort
     *
     * - Column
     *
     * - Filter
     *
     * - Group
     *
     *
     *
     * The Group option is only applicable to analytical tables and responsive tables.
     */
    personalization?: string | PropertyBindingInfo;

    /**
     * An expression that allows you to control the 'read-only' state of the table.
     * If you do not set any expression, SAP Fiori elements hooks into the standard lifecycle to determine the
     * current state.
     */
    readOnly?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Number of rows to be displayed in the table. Does not apply to responsive tables.
     */
    rowCount?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines how the table handles the visible rows. Does not apply to Responsive tables.
     * Allowed values are `Auto`, `Fixed`, and `Interactive`.
     *
     * - If set to `Fixed`, the table always has as many rows as defined in the rowCount property.
     *
     * - If set to `Auto`, the number of rows is changed by the table automatically. It will then adjust its
     *     row count to the space it is allowed to cover (limited by the surrounding container) but it cannot have
     *     less than defined in the `rowCount` property.
     *
     * - If set to `Interactive` the table can have as many rows as defined in the rowCount property. This number
     *     of rows can be modified by dragging the resizer available in this mode.
     */
    rowCountMode?: string | PropertyBindingInfo;

    /**
     * Defines how many additional data records are requested from the back-end system when the user scrolls
     * vertically in the table.
     */
    scrollThreshold?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the maximum number of rows that can be selected at once in the table.
     * This property does not apply to responsive tables.
     */
    selectionLimit?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the selection mode to be used by the table.
     * Allowed values are `None`, `Single`, `ForceSingle`, `Multi`, `ForceMulti` or `Auto`.
     * If set to 'Single', 'Multi' or 'Auto', SAP Fiori elements hooks into the standard lifecycle to determine
     * the consistent selection mode.
     * If set to 'ForceSingle' or 'ForceMulti' your choice will be respected but this might not respect the
     * Fiori guidelines.
     */
    selectionMode?: string | PropertyBindingInfo;

    /**
     * Defines the type of table that will be used by the building block to render the data. This setting is
     * defined by the framework.
     * Allowed value is `TreeTable`.
     */
    type?: string | PropertyBindingInfo;

    /**
     * Controls the kind of variant management that should be enabled for the table.
     * Allowed value is `Control`.
     *
     * If set with value `Control`, a variant management control is seen within the table and the table is linked
     * to this.
     *
     * If not set with any value, control level variant management is not available for this table.
     */
    variantManagement?: string | PropertyBindingInfo;

    /**
     * Indicates if the column header should be a part of the width calculation.
     */
    widthIncludingColumnHeader?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Aggregate actions of the table.
     */
    actions?:
      | Array<ActionGroup | Action>
      | ActionGroup
      | Action
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * A set of options that can be configured to control the aggregation behavior
     */
    analyticalConfiguration?: AnalyticalConfiguration;

    /**
     * Aggregate columns of the table.
     */
    columns?:
      | Array<ColumnOverride | Column>
      | ColumnOverride
      | Column
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Aggregate mass edit of the table.
     */
    massEdit?: MassEdit;

    /**
     * Aggregation to forward the IllustratedMessage control to the mdc control.
     */
    noData?: Text | IllustratedMessage | PropertyBindingInfo | `{${string}}`;

    /**
     * Aggregate quickVariantSelection of the table.
     */
    quickVariantSelection?: QuickVariantSelection;
  }

  /**
   * Parameters of the TreeTable#beforeRebindTable event.
   */
  export interface TreeTable$BeforeRebindTableEventParameters {}

  /**
   * Event object of the TreeTable#beforeRebindTable event.
   */
  export type TreeTable$BeforeRebindTableEvent = Event<
    TreeTable$BeforeRebindTableEventParameters,
    TreeTable
  >;

  /**
   * Parameters of the TreeTable#rowPress event.
   */
  export interface TreeTable$RowPressEventParameters {}

  /**
   * Event object of the TreeTable#rowPress event.
   */
  export type TreeTable$RowPressEvent = Event<
    TreeTable$RowPressEventParameters,
    TreeTable
  >;

  /**
   * Parameters of the TreeTable#selectionChange event.
   */
  export interface TreeTable$SelectionChangeEventParameters {}

  /**
   * Event object of the TreeTable#selectionChange event.
   */
  export type TreeTable$SelectionChangeEvent = Event<
    TreeTable$SelectionChangeEventParameters,
    TreeTable
  >;
}

declare module "sap/fe/macros/table/TreeTable" {
  import {
    default as BuildingBlockWithTemplating,
    $BuildingBlockWithTemplatingSettings,
  } from "sap/fe/macros/controls/BuildingBlockWithTemplating";

  import Action from "sap/fe/macros/table/Action";

  import Column from "sap/fe/macros/table/Column";

  import PresentationVariant from "sap/fe/navigation/PresentationVariant";

  import Context from "sap/ui/model/odata/v4/Context";

  import SelectionVariant from "sap/fe/navigation/SelectionVariant";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import TreeTableCreationOptions from "sap/fe/macros/table/TreeTableCreationOptions";

  import ActionGroup from "sap/fe/macros/table/ActionGroup";

  import AnalyticalConfiguration from "sap/fe/macros/table/AnalyticalConfiguration";

  import ColumnOverride from "sap/fe/macros/table/ColumnOverride";

  import MassEdit from "sap/fe/macros/table/MassEdit";

  import Text from "sap/m/Text";

  import IllustratedMessage from "sap/m/IllustratedMessage";

  import QuickVariantSelection from "sap/fe/macros/table/QuickVariantSelection";

  import Event from "sap/ui/base/Event";

  /**
   * Building block used to create a table based on the metadata provided by OData V4.
   *
   *
   * Usually, a LineItem, PresentationVariant or SelectionPresentationVariant annotation is expected, but
   * the Table building block can also be used to display an EntitySet.
   *
   *
   * If a PresentationVariant is specified, then it must have UI.LineItem as the first property of the Visualizations.
   *
   *
   * If a SelectionPresentationVariant is specified, then it must contain a valid PresentationVariant that
   * also has a UI.LineItem as the first property of the Visualizations.
   * Usage example:
   *
   * ```javascript
   *
   * sap.ui.require(["sap/fe/macros/table/TreeTable"], function(TreeTable) {
   * 	 ...
   * 	 new TreeTable("myTable", {metaPath:"@com.sap.vocabularies.UI.v1.LineItem"})
   * })
   * ```
   *
   * This is currently an experimental API because the structure of the generated content will change to come
   * closer to the Table that you get out of templates.
   * The public method and property will not change but the internal structure will so be careful on your
   * usage.
   *
   *
   * @since 1.125.0
   * @experimental As of version 1.125.0.
   */
  export default class TreeTable extends BuildingBlockWithTemplating {
    /**
     * Adds an action to the table.
     *
     * @since 1.125.0
     * @experimental As of version 1.125.0.
     *
     * @returns Reference to this in order to allow method chaining
     */
    addAction(
      /**
       * The action to add
       */
      action: Action
    ): this;
    /**
     * Adds a column to the table.
     *
     * @since 1.124.0
     * @experimental As of version 1.124.0.
     *
     * @returns Reference to this in order to allow method chaining
     */
    addColumn(
      /**
       * The column to add
       */
      column: Column
    ): this;
    /**
     * Adds a message to the table.
     * The message applies to the whole table and not to an individual table row.
     *
     *
     *
     * @returns Promise The ID of the message
     */
    addMessage(
      /**
       * The parameters to create the message
       */
      parameters: {
        /**
         * Message description
         */
        description?: string;
        /**
         * Message text
         */
        message?: string;
        /**
         * True if the message is persistent
         */
        persistent?: boolean;
        /**
         * Message type
         */
        type?: /* was: sap.ui.core.message.MessageType */ any;
      }
    ): Promise<string>;
    /**
     * Get the variant management applied to the table.
     *
     *
     * @returns Key of the currently selected variant. In case the model is not yet set, `null` will be returned.
     */
    getCurrentVariantKey(): null | string;
    /**
     * Get the fields that should be ignored when generating the table.
     *
     * @since 1.125.0
     * @experimental As of version 1.125.0.
     *
     * @returns The value of the ignoredFields property
     */
    getIgnoredFields(): string;
    /**
     * Gets the path to the metadata that should be used to generate the table.
     *
     * @since 1.125.0
     * @experimental As of version 1.125.0.
     *
     * @returns The path to the metadata
     */
    getMetaPath(): string;
    /**
     * Get the presentation variant that is currently applied on the table.
     *
     *
     * @returns The presentation variant applied to the table
     */
    getPresentationVariant(): Promise<PresentationVariant>;
    /**
     * Gets contexts from the table that have been selected by the user.
     *
     *
     * @returns Contexts of the rows selected by the user
     */
    getSelectedContexts(): Context[];
    /**
     * Get the selection variant from the table. This function considers only the selection variant applied
     * at the control level.
     *
     *
     * @returns A promise which resolves with {@link sap.fe.navigation.SelectionVariant }
     */
    getSelectionVariant(): Promise<SelectionVariant>;
    /**
     * Hide the columns with the given column keys by setting their availability to Default.
     *
     * @since 1.124.0
     * @experimental As of version 1.124.0.
     *
     * @returns Promise
     */
    hideColumns(
      /**
       * The keys for the columns to hide
       */
      columnKeys: string[]
    ): Promise<void>;
    /**
     * Requests a refresh of the table.
     */
    refresh(): void;
    /**
     * Removes an action from the table.
     *
     * @since 1.125.0
     * @experimental As of version 1.125.0.
     *
     * @returns The removed action or null
     */
    removeAction(
      /**
       * The action to remove, or its index or ID
       */
      action: number | Action | string
    ): null | Action;
    /**
     * Removes a column from the table.
     *
     * @since 1.125.0
     * @experimental As of version 1.125.0.
     *
     * @returns The removed column or null
     */
    removeColumn(
      /**
       * The column to remove, or its index or ID
       */
      column: number | Column | string
    ): null | Column;
    /**
     * Removes a message from the table.
     */
    removeMessage(
      /**
       * The id of the message
       */
      id: string
    ): void;
    /**
     * Set a variant management to the table.
     */
    setCurrentVariantKey(
      /**
       * Key of the variant that should be selected. If the passed key doesn't identify a variant, it will be
       * ignored.
       */
      key: string
    ): void;
    /**
     * Sets the fields that should be ignored when generating the table.
     *
     * @since 1.125.0
     * @experimental As of version 1.125.0.
     *
     * @returns Reference to this in order to allow method chaining
     */
    setIgnoredFields(
      /**
       * The fields to ignore
       */
      ignoredFields: string
    ): this;
    /**
     * Sets the path to the metadata that should be used to generate the table.
     *
     * @since 1.125.0
     * @experimental As of version 1.125.0.
     *
     * @returns Reference to this in order to allow method chaining
     */
    setMetaPath(
      /**
       * The path to the metadata
       */
      metaPath: string
    ): this;
    /**
     * Set a new presentation variant to the table.
     */
    setPresentationVariant(
      /**
       * The new presentation variant that is to be set on the table.
       */
      tablePV: PresentationVariant
    ): Promise<void>;
    /**
     * Sets {@link sap.fe.navigation.SelectionVariant } to the table. Note: setSelectionVariant will clear existing
     * filters and then apply the SelectionVariant values.
     *
     *
     * @returns A promise for asynchronous handling
     */
    setSelectionVariant(
      /**
       * The {@link sap.fe.navigation.SelectionVariant } to apply to the table
       */
      selectionVariant: SelectionVariant,
      /**
       * Optional. If true, we will use the associated text property values (if they're available in the SelectionVariant)
       * to display the filter value descriptions, instead of loading them from the backend
       */
      prefillDescriptions?: boolean
    ): Promise<any>;
    /**
     * Show the columns with the given column keys by setting their availability to Default.
     *
     * @since 1.124.0
     * @experimental As of version 1.124.0.
     *
     * @returns Promise
     */
    showColumns(
      /**
       * The keys for the columns to show
       */
      columnKeys: string[]
    ): Promise<void>;
  }
  /**
   * Describes the settings that can be provided to the TreeTable constructor.
   *
   * @experimental As of version 1.125.0.
   */
  export interface $TreeTableSettings
    extends $BuildingBlockWithTemplatingSettings {
    /**
     * An expression that allows you to control the 'busy' state of the table.
     */
    busy?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the table adapts to the condensed layout.
     */
    condensedTableLayout?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the path of the context used in the current page or block.
     * This setting is defined by the framework.
     */
    contextPath?: string | PropertyBindingInfo;

    /**
     * A set of options that can be configured.
     */
    creationMode?:
      | TreeTableCreationOptions
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Controls if the copy functionality of the table is disabled or not.
     */
    disableCopyToClipboard?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies if the column width is automatically calculated.
     */
    enableAutoColumnWidth?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls if the export functionality of the table is enabled or not.
     */
    enableExport?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls whether the table can be opened in fullscreen mode or not.
     */
    enableFullScreen?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls if the paste functionality of the table is enabled or not.
     */
    enablePaste?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determine whether the data copied to the computed columns is sent to the back end.
     */
    enablePastingOfComputedProperties?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Determines whether the Clear All button is enabled by default.
     * To enable the Clear All button by default, you must set this property to false.
     */
    enableSelectAll?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Maximum allowed number of records to be exported in one request.
     */
    exportRequestSize?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * ID of the FilterBar building block associated with the table.
     */
    filterBar?: string | PropertyBindingInfo;

    /**
     * Number of columns that are fixed on the left. Only columns which are not fixed can be scrolled horizontally.
     * This property is not relevant for responsive tables
     */
    frozenColumnCount?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies the header text that is shown in the table.
     */
    header?: string | PropertyBindingInfo;

    /**
     * Controls if the header text should be shown or not.
     */
    headerVisible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * A set of options that can be configured.
     */
    hierarchyQualifier?: string | PropertyBindingInfo;

    /**
     * Comma-separated value of fields that must be ignored in the OData metadata by the Table building block.
     *
     * The table building block is not going to create built-in columns or offer table personalization for comma-separated
     * value of fields that are provided in the ignoredfields.
     *
     * Any column referencing an ignored field is to be removed.
     */
    ignoredFields?: string | PropertyBindingInfo;

    /**
     * Defines the extension point to control whether a source node can be copied to a specific parent node.
     */
    isCopyToPositionAllowed?: string | PropertyBindingInfo;

    /**
     * Defines the extension point to control whether a source node can be dropped on a specific parent node.
     */
    isMoveToPositionAllowed?: string | PropertyBindingInfo;

    /**
     * efines the extension point to control whether a node can be copied.
     */
    isNodeCopyable?: string | PropertyBindingInfo;

    /**
     * Defines the extension point to control if a node can be dragged.
     */
    isNodeMovable?: string | PropertyBindingInfo;

    /**
     * Defines whether to display the search action.
     */
    isSearchable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the relative path to a LineItem, PresentationVariant or SelectionPresentationVariant in the metamodel,
     * based on the current contextPath.
     */
    metaPath?: string | PropertyBindingInfo;

    /**
     * Changes the size of the IllustratedMessage in the table, or removes it completely.
     * Allowed values are `illustratedMessage-Auto`, `illustratedMessage-Base`, `illustratedMessage-Dialog`,
     * `illustratedMessage-Dot`, `illustratedMessage-Scene`, `illustratedMessage-Spot` or `text`.
     */
    modeForNoDataMessage?: string | PropertyBindingInfo;

    /**
     * Controls which options should be enabled for the table personalization dialog.
     * If it is set to `true`, all possible options for this kind of table are enabled.
     *
     * If it is set to `false`, personalization is disabled.
     *
     *
     *
     * You can also provide a more granular control for the personalization by providing a comma-separated list
     * with the options you want to be available.
     *
     * Available options are:
     *
     * - Sort
     *
     * - Column
     *
     * - Filter
     *
     * - Group
     *
     *
     *
     * The Group option is only applicable to analytical tables and responsive tables.
     */
    personalization?: string | PropertyBindingInfo;

    /**
     * An expression that allows you to control the 'read-only' state of the table.
     * If you do not set any expression, SAP Fiori elements hooks into the standard lifecycle to determine the
     * current state.
     */
    readOnly?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Number of rows to be displayed in the table. Does not apply to responsive tables.
     */
    rowCount?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines how the table handles the visible rows. Does not apply to Responsive tables.
     * Allowed values are `Auto`, `Fixed`, and `Interactive`.
     *
     * - If set to `Fixed`, the table always has as many rows as defined in the rowCount property.
     *
     * - If set to `Auto`, the number of rows is changed by the table automatically. It will then adjust its
     *     row count to the space it is allowed to cover (limited by the surrounding container) but it cannot have
     *     less than defined in the `rowCount` property.
     *
     * - If set to `Interactive` the table can have as many rows as defined in the rowCount property. This number
     *     of rows can be modified by dragging the resizer available in this mode.
     */
    rowCountMode?: string | PropertyBindingInfo;

    /**
     * Defines how many additional data records are requested from the back-end system when the user scrolls
     * vertically in the table.
     */
    scrollThreshold?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the maximum number of rows that can be selected at once in the table.
     * This property does not apply to responsive tables.
     */
    selectionLimit?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the selection mode to be used by the table.
     * Allowed values are `None`, `Single`, `ForceSingle`, `Multi`, `ForceMulti` or `Auto`.
     * If set to 'Single', 'Multi' or 'Auto', SAP Fiori elements hooks into the standard lifecycle to determine
     * the consistent selection mode.
     * If set to 'ForceSingle' or 'ForceMulti' your choice will be respected but this might not respect the
     * Fiori guidelines.
     */
    selectionMode?: string | PropertyBindingInfo;

    /**
     * Defines the type of table that will be used by the building block to render the data. This setting is
     * defined by the framework.
     * Allowed value is `TreeTable`.
     */
    type?: string | PropertyBindingInfo;

    /**
     * Controls the kind of variant management that should be enabled for the table.
     * Allowed value is `Control`.
     *
     * If set with value `Control`, a variant management control is seen within the table and the table is linked
     * to this.
     *
     * If not set with any value, control level variant management is not available for this table.
     */
    variantManagement?: string | PropertyBindingInfo;

    /**
     * Indicates if the column header should be a part of the width calculation.
     */
    widthIncludingColumnHeader?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Aggregate actions of the table.
     */
    actions?:
      | Array<ActionGroup | Action>
      | ActionGroup
      | Action
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * A set of options that can be configured to control the aggregation behavior
     */
    analyticalConfiguration?: AnalyticalConfiguration;

    /**
     * Aggregate columns of the table.
     */
    columns?:
      | Array<ColumnOverride | Column>
      | ColumnOverride
      | Column
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Aggregate mass edit of the table.
     */
    massEdit?: MassEdit;

    /**
     * Aggregation to forward the IllustratedMessage control to the mdc control.
     */
    noData?: Text | IllustratedMessage | PropertyBindingInfo | `{${string}}`;

    /**
     * Aggregate quickVariantSelection of the table.
     */
    quickVariantSelection?: QuickVariantSelection;
  }

  /**
   * Parameters of the TreeTable#beforeRebindTable event.
   */
  export interface TreeTable$BeforeRebindTableEventParameters {}

  /**
   * Event object of the TreeTable#beforeRebindTable event.
   */
  export type TreeTable$BeforeRebindTableEvent = Event<
    TreeTable$BeforeRebindTableEventParameters,
    TreeTable
  >;

  /**
   * Parameters of the TreeTable#rowPress event.
   */
  export interface TreeTable$RowPressEventParameters {}

  /**
   * Event object of the TreeTable#rowPress event.
   */
  export type TreeTable$RowPressEvent = Event<
    TreeTable$RowPressEventParameters,
    TreeTable
  >;

  /**
   * Parameters of the TreeTable#selectionChange event.
   */
  export interface TreeTable$SelectionChangeEventParameters {}

  /**
   * Event object of the TreeTable#selectionChange event.
   */
  export type TreeTable$SelectionChangeEvent = Event<
    TreeTable$SelectionChangeEventParameters,
    TreeTable
  >;
}

declare module "sap/fe/macros/table/TreeTableCreationOptions" {
  import {
    default as BuildingBlockObjectProperty,
    $BuildingBlockObjectPropertySettings,
  } from "sap/fe/macros/controls/BuildingBlockObjectProperty";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Create options for the tree table.
   */
  export default class TreeTableCreationOptions extends BuildingBlockObjectProperty {}
  /**
   * Describes the settings that can be provided to the TreeTableCreationOptions constructor.
   */
  export interface $TreeTableCreationOptionsSettings
    extends $BuildingBlockObjectPropertySettings {
    /**
     * Specifies if the new entry should be placed at the position computed by the backend (e.g. taking sorting
     * into account).
     *
     * The default value is 'false' (that is, the new entry is placed as the first child below its parent).
     */
    createInPlace?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the list of properties that will be displayed in the creation dialog, when the creation mode
     * is set to 'CreationDialog'.
     *
     * The value is a comma-separated list of property names.
     */
    creationFields?: string | PropertyBindingInfo;

    /**
     * Defines the extension point to control the enablement of the Create button or Create Menu buttons.
     */
    isCreateEnabled?: string | PropertyBindingInfo;

    /**
     * Defines the creation mode to be used by the tree table.
     * Allowed values are `NewPage`, `Inline` or `CreationDialog`.
     *
     *
     *
     * NewPage - the created document is shown in a new page, depending on whether metadata 'Sync', 'Async'
     * or 'Deferred' is used.
     *
     * Inline - the creation is done inline.
     *
     * CreationDialog - the creation is done in the table, with a dialog allowing to specify some initial property
     * values (the properties are listed in `creationFields`).
     *
     * If not set with any value:
     *
     * if navigation is defined, the default value is 'NewPage'. Otherwise it is 'Inline'.
     */
    name?: string | PropertyBindingInfo;

    /**
     * Defines the nodes to be added on the custom create.
     * This object must have the following properties:
     * propertyName: the name of the property on the page entity set used to categorize the node type to be
     * created within the hierarchy
     *
     * values: an array of key, label and an optional creationFields that define a value of the property defined
     * by the propertyName key, its label, and the specific fields to be shown in the creation dialog.
     */
    nodeType?: object | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/fe/macros/controls/section/ISingleSectionContributor" {
  /**
   * This interface should be implemented by controls to define it's behaviour
   * when it is the only control in a Fiori Elements Object Page Section.
   *
   *
   *
   * The Fiori Elements Object Page Section checks if it has only one control at runtime and then
   * calls the relevant methods if the control implements the interface.
   *
   *
   *
   * Incase of a composite control or controls placed inside layouts (VBox, HBox, FlexBox) etc. it should
   * always be the root/layout control that implements this interface.
   * It is upto the root/layout contrl in this case of interact with inner controls.
   *
   *
   *
   * Control must implement getSectionContentRole to define whether it is a "provider" or a "consumer".
   *
   *
   *     - provider: Building block is the provider of information to the section
   *
   *     - consumer: Building block is the consumer of information provided by the section
   *
   *
   *
   * If the control is a "provider" then it should implement the getDataFromProvider method and return ProviderData.
   *
   *
   * If the control is a "consumer" then it should implement the sendDataToConsumer method and consume ConsumerData.
   *
   *
   *
   *
   * @since 1.126.0
   */
  export interface ISingleSectionContributor {
    __implements__sap_fe_macros_controls_section_ISingleSectionContributor: boolean;

    /**
     * When the content role is "provider" this method is called by the section to get the information from
     * the the provider.
     *
     *
     * @returns The data from the provider which is needed by the section.
     */
    getDataFromProvider(): ProviderData;
    /**
     * Defines the role of a control when it is the only content in the section. Allowed roles are "provider"
     * and "consumer".
     *
     *
     *
     * provider: control is the provider of information to the section. Control provides the information and
     * section acts on it.
     *
     *
     *
     * consumer: control is the consumer of information provided by the section. Section provides the information
     * and the control acts on it.
     *
     *
     *
     * @returns The role played by the control when it is the only content in the Fiori Elements Object Page
     * Section.
     */
    getSectionContentRole(): string;
    /**
     * When the content role is "consumer" this method is called by the section to collect
     * and send information from the section to the control.
     */
    sendDataToConsumer(
      /**
       * Data provide by the section to the control.
       */
      consumerData: ConsumerData
    ): void;
  }

  /**
   * Definition of data consumer by section from single control
   */
  export type ConsumerData = {
    /**
     * Defines the title to be used by the single control.
     */
    title: string;
  };

  /**
   * Definition of data provided by section to single control
   */
  export type ProviderData = {
    /**
     * Defines the title to be used by the section.
     */
    title: string;
  };
}

declare namespace sap {
  interface IUI5DefineDependencyNames {
    "sap/fe/macros/Chart": undefined;

    "sap/fe/macros/chart/Action": undefined;

    "sap/fe/macros/chart/ActionGroup": undefined;

    "sap/fe/macros/chart/Chart": undefined;

    "sap/fe/macros/CollectionBindingInfo": undefined;

    "sap/fe/macros/controls/BuildingBlockObjectProperty": undefined;

    "sap/fe/macros/controls/BuildingBlockWithTemplating": undefined;

    "sap/fe/macros/controls/section/ISingleSectionContributor": undefined;

    "sap/fe/macros/fcl/FlexibleColumnLayoutActions.block": undefined;

    "sap/fe/macros/Field": undefined;

    "sap/fe/macros/field/Field": undefined;

    "sap/fe/macros/field/FieldFormatOptions": undefined;

    "sap/fe/macros/filterBar/FilterBar": undefined;

    "sap/fe/macros/filterBar/FilterBarAPI": undefined;

    "sap/fe/macros/filterBar/FilterField": undefined;

    "sap/fe/macros/form/Form.block": undefined;

    "sap/fe/macros/form/FormElement.block": undefined;

    "sap/fe/macros/KPITag": undefined;

    "sap/fe/macros/library": undefined;

    "sap/fe/macros/MacroAPI": undefined;

    "sap/fe/macros/MessageButton": undefined;

    "sap/fe/macros/MicroChart": undefined;

    "sap/fe/macros/microchart/MicroChart": undefined;

    "sap/fe/macros/MultiValueField": undefined;

    "sap/fe/macros/Page": undefined;

    "sap/fe/macros/Paginator": undefined;

    "sap/fe/macros/RichTextEditor": undefined;

    "sap/fe/macros/richtexteditor/ButtonGroup": undefined;

    "sap/fe/macros/richtexteditor/Plugin": undefined;

    "sap/fe/macros/RichTextEditorWithMetadata": undefined;

    "sap/fe/macros/Share": undefined;

    "sap/fe/macros/share/ShareOptions": undefined;

    "sap/fe/macros/table/Action": undefined;

    "sap/fe/macros/table/ActionGroup": undefined;

    "sap/fe/macros/table/ActionGroupOverride": undefined;

    "sap/fe/macros/table/ActionOverride": undefined;

    "sap/fe/macros/table/AnalyticalConfiguration": undefined;

    "sap/fe/macros/table/Column": undefined;

    "sap/fe/macros/table/ColumnExportSettings": undefined;

    "sap/fe/macros/table/ColumnOverride": undefined;

    "sap/fe/macros/table/MassEdit": undefined;

    "sap/fe/macros/table/QuickVariantSelection": undefined;

    "sap/fe/macros/table/Table": undefined;

    "sap/fe/macros/table/Table.block": undefined;

    "sap/fe/macros/table/TableCreationOptions": undefined;

    "sap/fe/macros/table/TreeTable": undefined;

    "sap/fe/macros/table/TreeTable.block": undefined;

    "sap/fe/macros/table/TreeTableCreationOptions": undefined;

    "sap/fe/macros/VariantManagement": undefined;
  }
}
