/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.codemods;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.codemods.ESLintMessages;
import org.openrewrite.codemods.NodeBasedRecipe;
import org.openrewrite.codemods.RecipeResources;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.scheduling.WorkingDirectoryExecutionContextView;
import org.openrewrite.text.PlainText;

public final class ESLint
extends NodeBasedRecipe {
    private static final String ESLINT_DIR = ESLint.class.getName() + ".ESLINT_DIR";
    private final transient ESLintMessages messages = new ESLintMessages((Recipe)this);
    @Option(displayName="The lint target files", description="The lint target files. This can contain any of file paths, directory paths, and glob patterns.", example="lib/**/*.js", required=false)
    @Nullable
    private final List<String> patterns;
    @Option(displayName="Parser to be used by ESLint", description="Parser used by ESLint to parse the source files. Defaults to `@typescript-eslint/parser`. See [ESLint documentation](https://eslint.org/docs/latest/use/configure/parsers) for more details.", example="esprima", required=false)
    @Nullable
    private final String parser;
    @Option(displayName="List of parser options for ESLint", description="A list of parser options for ESLint. The format is `key: value`. Defaults to `ecmaVersion: \"latest\", ecmaFeatures: { jsx: true }, sourceType: \"module\"`. See [ESLint documentation](https://eslint.org/docs/latest/use/configure/language-options#specifying-parser-options) for more details.", example="ecmaVersion: 6, ecmaFeatures: { jsx: true }", required=false)
    @Nullable
    private final List<String> parserOptions;
    @Option(displayName="Allow inline configuration for ESLint", description="Whether inline config comments are allowed. Defaults to `false`. See [ESLint documentation](https://eslint.org/docs/latest/use/configure/rules#disabling-inline-comments) for more details.", example="true", required=false)
    @Nullable
    private final Boolean allowInlineConfig;
    @Option(displayName="List of `env` mappings for ESLint", description="A list of `env` mappings for ESLint. The format is `key: value`.", example="browser: true", required=false)
    @Nullable
    private final List<String> envs;
    @Option(displayName="ESLint global variables", description="Define global variables for rules that require knowledge of these.", example="var1, var2: writable", required=false)
    @Nullable
    private final List<String> globals;
    @Option(displayName="ESLint plugins", description="A list of plugins for ESLint.", example="@typescript-eslint, prettier", required=false)
    @Nullable
    private final List<String> plugins;
    @Option(displayName="ESLint extends", description="A list of extends for ESLint.", example="eslint:recommended, prettier", required=false)
    @Nullable
    private final List<String> extend;
    @Option(displayName="ESLint rules and rule configuration", description="List of rules to be checked by ESLint. Optionally, the severity and other rule options can also be specified as e.g. `off`, `warn` or `[\"error\", \"always\"]`. The severity `off` is useful when the rule is declared by an extended [shareable config](https://eslint.org/docs/latest/extend/ways-to-extend#shareable-configs). For more information, see the [ESLint documentation](https://eslint.org/docs/latest/use/configure/rules)", example="eqeqeq: warn, multiline-comment-style: [\"error\", \"starred-block\"], prettier/prettier", required=false)
    @Nullable
    private final List<String> rules;
    @Option(displayName="Autofix", description="Automatically fix violations when possible. Defaults to `true`.", example="false", required=false)
    @Nullable
    private final Boolean fix;
    @Option(displayName="Override config file", description="Allows specifying the full ESLint configuration file contents as multiline JSON. See [ESLint documentation](https://eslint.org/docs/latest/use/configure/configuration-files) for more details.\n\nNote that this will override any other configuration options.", required=false)
    @Nullable
    private final String configFile;

    public String getDisplayName() {
        return "Lint source code with ESLint";
    }

    public String getDescription() {
        return "Run [ESLint](https://eslint.org/) across the code to fix common static analysis issues in the code.\n\nThis requires the code to have an existing ESLint configuration.";
    }

    @Override
    public NodeBasedRecipe.Accumulator getInitialValue(ExecutionContext ctx) {
        Path path = RecipeResources.from(((Object)((Object)this)).getClass()).extractResources("config", "eslint-config", ctx);
        ctx.putMessage(ESLINT_DIR, (Object)path);
        return super.getInitialValue(ctx);
    }

    @Override
    protected List<String> getNpmCommand(NodeBasedRecipe.Accumulator acc, ExecutionContext ctx) {
        if (!(this.plugins != null && !this.plugins.isEmpty() || this.extend != null && !this.extend.isEmpty() || this.rules != null && !this.rules.isEmpty() || this.configFile != null)) {
            return Collections.emptyList();
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("node");
        command.add(ctx.getMessage(ESLINT_DIR).toString() + "/eslint-driver.js");
        if (this.patterns != null) {
            this.patterns.forEach(p -> command.add("--patterns=" + p));
        }
        if (this.configFile != null) {
            try {
                Path directory = WorkingDirectoryExecutionContextView.view((ExecutionContext)ctx).getWorkingDirectory();
                Path configFile = Files.write(Files.createTempFile(directory, "eslint-config", null, new FileAttribute[0]), this.configFile.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                command.add("--config-file=" + configFile);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        } else {
            if (this.parser != null) {
                command.add("--parser=" + this.parser);
            }
            if (this.parserOptions != null) {
                this.parserOptions.forEach(p -> command.add("--parser-options=" + p));
            }
            if (this.allowInlineConfig != null) {
                command.add("--allow-inline-config=" + this.allowInlineConfig);
            }
            if (this.envs != null) {
                this.envs.forEach(e -> command.add("--env={" + e + "}"));
            }
            if (this.globals != null) {
                this.globals.forEach(g -> command.add("--globals={" + g + "}"));
            }
            if (this.plugins != null) {
                this.plugins.forEach(p -> command.add("--plugins=" + p));
            }
            if (this.extend != null) {
                this.extend.forEach(e -> command.add("--extends=" + e));
            }
            if (this.rules != null) {
                this.rules.forEach(r -> {
                    int colonIndex = r.indexOf(58);
                    if (colonIndex != -1) {
                        command.add("--rules={" + r + "}");
                    } else {
                        command.add("--rules={" + r + ": 2}");
                    }
                });
            }
            if (this.fix != null) {
                command.add("--fix=" + this.fix);
            }
        }
        return command;
    }

    @Override
    protected void processOutput(Path output, NodeBasedRecipe.Accumulator acc, ExecutionContext ctx) {
        try {
            HashMap<Path, JsonNode> results = new HashMap<Path, JsonNode>();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode resultsNode = objectMapper.readTree(output.toFile());
            for (JsonNode resultNode : resultsNode.get("results")) {
                if (resultNode.get("errorCount").intValue() <= 0 && resultNode.get("warningCount").intValue() <= 0) continue;
                results.put(Paths.get(resultNode.get("filePath").asText(), new String[0]), resultNode);
            }
            acc.putData("results", results);
            acc.putData("metadata", resultsNode.get("metadata").get("rulesMeta"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected SourceFile createAfter(SourceFile before, NodeBasedRecipe.Accumulator acc, ExecutionContext ctx) {
        SourcePosition endPosition;
        Map results = (Map)acc.getData("results");
        if (results == null) {
            return super.createAfter(before, acc, ctx);
        }
        JsonNode resultNode = (JsonNode)results.get(acc.resolvedPath(before));
        if (resultNode == null) {
            return super.createAfter(before, acc, ctx);
        }
        JsonNode metadata = (JsonNode)acc.getData("metadata");
        String content = acc.content(before);
        ArrayList<PlainText.Snippet> snippets = new ArrayList<PlainText.Snippet>();
        SourcePosition currentPosition = new SourcePosition(content, 1, 1, 0);
        PlainText.Snippet currentSnippet = new PlainText.Snippet(Tree.randomId(), Markers.EMPTY, "");
        JsonNode previousMessage = null;
        ArrayNode messagesNode = (ArrayNode)resultNode.get("messages");
        for (int i = 0; i < messagesNode.size(); ++i) {
            int column;
            JsonNode message = messagesNode.get(i);
            int line = message.get("line").asInt();
            SourcePosition nextPosition = currentPosition.scanForwardTo(line, column = message.get("column").asInt());
            if (nextPosition.offset > currentPosition.offset) {
                SourcePosition endPosition2;
                if (previousMessage != null && (endPosition2 = currentPosition.scanForwardTo(previousMessage.get("endLine").intValue(), previousMessage.get("endColumn").intValue())).offset < nextPosition.offset) {
                    snippets.add(currentSnippet.withText(content.substring(currentPosition.offset, endPosition2.offset)));
                    currentSnippet = new PlainText.Snippet(Tree.randomId(), Markers.EMPTY, "");
                    currentPosition = endPosition2;
                }
                snippets.add(currentSnippet.withText(content.substring(currentPosition.offset, nextPosition.offset)));
                currentSnippet = new PlainText.Snippet(Tree.randomId(), Markers.EMPTY, "");
            }
            int severity = message.get("severity").asInt();
            String messageText = message.get("message").asText();
            String ruleId = message.get("ruleId").asText();
            JsonNode jsonNode = metadata != null ? metadata.get(ruleId) : null;
            String detail = jsonNode != null && jsonNode.has("docs") ? jsonNode.get("docs").get("description").asText() + "\n\nRule: " + ruleId : "Rule: " + ruleId;
            detail = detail + ", Severity: " + (severity == 2 ? "ERROR" : "WARNING");
            SearchResult marker = new SearchResult(Tree.randomId(), messageText + "\n\n" + detail);
            this.messages.insertRow(ctx, new ESLintMessages.Row(before.getSourcePath().toString(), ruleId, ESLintMessages.Severity.of(severity), message.has("fatal") && message.get("fatal").asBoolean(), messageText, line, column));
            currentSnippet = Boolean.TRUE.equals(this.fix) ? currentSnippet : currentSnippet.withMarkers(currentSnippet.getMarkers().add((Marker)marker));
            currentPosition = nextPosition;
            previousMessage = message.has("endLine") ? message : null;
        }
        if (previousMessage != null && (endPosition = currentPosition.scanForwardTo(previousMessage.get("endLine").intValue(), previousMessage.get("endColumn").intValue())).offset < content.length()) {
            snippets.add(currentSnippet.withText(content.substring(currentPosition.offset, endPosition.offset)));
            currentSnippet = new PlainText.Snippet(Tree.randomId(), Markers.EMPTY, "");
            currentPosition = endPosition;
        }
        snippets.add(currentSnippet.withText(content.substring(currentPosition.offset)));
        return new PlainText(before.getId(), before.getSourcePath(), Boolean.TRUE.equals(this.fix) ? Markers.EMPTY : before.getMarkers(), before.getCharset() != null ? before.getCharset().name() : null, before.isCharsetBomMarked(), before.getFileAttributes(), null, "", snippets);
    }

    @Generated
    public ESLint(List<String> patterns, String parser, List<String> parserOptions, Boolean allowInlineConfig, List<String> envs, List<String> globals, List<String> plugins, List<String> extend, List<String> rules, Boolean fix, String configFile) {
        this.patterns = patterns;
        this.parser = parser;
        this.parserOptions = parserOptions;
        this.allowInlineConfig = allowInlineConfig;
        this.envs = envs;
        this.globals = globals;
        this.plugins = plugins;
        this.extend = extend;
        this.rules = rules;
        this.fix = fix;
        this.configFile = configFile;
    }

    @Generated
    public ESLintMessages getMessages() {
        return this.messages;
    }

    @Generated
    public List<String> getPatterns() {
        return this.patterns;
    }

    @Generated
    public String getParser() {
        return this.parser;
    }

    @Generated
    public List<String> getParserOptions() {
        return this.parserOptions;
    }

    @Generated
    public Boolean getAllowInlineConfig() {
        return this.allowInlineConfig;
    }

    @Generated
    public List<String> getEnvs() {
        return this.envs;
    }

    @Generated
    public List<String> getGlobals() {
        return this.globals;
    }

    @Generated
    public List<String> getPlugins() {
        return this.plugins;
    }

    @Generated
    public List<String> getExtend() {
        return this.extend;
    }

    @Generated
    public List<String> getRules() {
        return this.rules;
    }

    @Generated
    public Boolean getFix() {
        return this.fix;
    }

    @Generated
    public String getConfigFile() {
        return this.configFile;
    }

    @Generated
    public String toString() {
        return "ESLint(messages=" + (Object)((Object)this.getMessages()) + ", patterns=" + this.getPatterns() + ", parser=" + this.getParser() + ", parserOptions=" + this.getParserOptions() + ", allowInlineConfig=" + this.getAllowInlineConfig() + ", envs=" + this.getEnvs() + ", globals=" + this.getGlobals() + ", plugins=" + this.getPlugins() + ", extend=" + this.getExtend() + ", rules=" + this.getRules() + ", fix=" + this.getFix() + ", configFile=" + this.getConfigFile() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ESLint)) {
            return false;
        }
        ESLint other = (ESLint)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$allowInlineConfig = this.getAllowInlineConfig();
        Boolean other$allowInlineConfig = other.getAllowInlineConfig();
        if (this$allowInlineConfig == null ? other$allowInlineConfig != null : !((Object)this$allowInlineConfig).equals(other$allowInlineConfig)) {
            return false;
        }
        Boolean this$fix = this.getFix();
        Boolean other$fix = other.getFix();
        if (this$fix == null ? other$fix != null : !((Object)this$fix).equals(other$fix)) {
            return false;
        }
        List<String> this$patterns = this.getPatterns();
        List<String> other$patterns = other.getPatterns();
        if (this$patterns == null ? other$patterns != null : !((Object)this$patterns).equals(other$patterns)) {
            return false;
        }
        String this$parser = this.getParser();
        String other$parser = other.getParser();
        if (this$parser == null ? other$parser != null : !this$parser.equals(other$parser)) {
            return false;
        }
        List<String> this$parserOptions = this.getParserOptions();
        List<String> other$parserOptions = other.getParserOptions();
        if (this$parserOptions == null ? other$parserOptions != null : !((Object)this$parserOptions).equals(other$parserOptions)) {
            return false;
        }
        List<String> this$envs = this.getEnvs();
        List<String> other$envs = other.getEnvs();
        if (this$envs == null ? other$envs != null : !((Object)this$envs).equals(other$envs)) {
            return false;
        }
        List<String> this$globals = this.getGlobals();
        List<String> other$globals = other.getGlobals();
        if (this$globals == null ? other$globals != null : !((Object)this$globals).equals(other$globals)) {
            return false;
        }
        List<String> this$plugins = this.getPlugins();
        List<String> other$plugins = other.getPlugins();
        if (this$plugins == null ? other$plugins != null : !((Object)this$plugins).equals(other$plugins)) {
            return false;
        }
        List<String> this$extend = this.getExtend();
        List<String> other$extend = other.getExtend();
        if (this$extend == null ? other$extend != null : !((Object)this$extend).equals(other$extend)) {
            return false;
        }
        List<String> this$rules = this.getRules();
        List<String> other$rules = other.getRules();
        if (this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules)) {
            return false;
        }
        String this$configFile = this.getConfigFile();
        String other$configFile = other.getConfigFile();
        return !(this$configFile == null ? other$configFile != null : !this$configFile.equals(other$configFile));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ESLint;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $allowInlineConfig = this.getAllowInlineConfig();
        result = result * 59 + ($allowInlineConfig == null ? 43 : ((Object)$allowInlineConfig).hashCode());
        Boolean $fix = this.getFix();
        result = result * 59 + ($fix == null ? 43 : ((Object)$fix).hashCode());
        List<String> $patterns = this.getPatterns();
        result = result * 59 + ($patterns == null ? 43 : ((Object)$patterns).hashCode());
        String $parser = this.getParser();
        result = result * 59 + ($parser == null ? 43 : $parser.hashCode());
        List<String> $parserOptions = this.getParserOptions();
        result = result * 59 + ($parserOptions == null ? 43 : ((Object)$parserOptions).hashCode());
        List<String> $envs = this.getEnvs();
        result = result * 59 + ($envs == null ? 43 : ((Object)$envs).hashCode());
        List<String> $globals = this.getGlobals();
        result = result * 59 + ($globals == null ? 43 : ((Object)$globals).hashCode());
        List<String> $plugins = this.getPlugins();
        result = result * 59 + ($plugins == null ? 43 : ((Object)$plugins).hashCode());
        List<String> $extend = this.getExtend();
        result = result * 59 + ($extend == null ? 43 : ((Object)$extend).hashCode());
        List<String> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        String $configFile = this.getConfigFile();
        result = result * 59 + ($configFile == null ? 43 : $configFile.hashCode());
        return result;
    }

    private static final class SourcePosition {
        private final String text;
        private final int line;
        private final int column;
        private final int offset;

        private SourcePosition scanForwardTo(int line, int column) {
            if (line == this.line && column == this.column) {
                return this;
            }
            int currentLine = this.line;
            int currentColumn = this.column;
            int currentOffset = this.offset;
            while (currentLine < line || currentLine == line && currentColumn < column) {
                if (this.text.charAt(currentOffset) == '\n') {
                    ++currentLine;
                    currentColumn = 1;
                    ++currentOffset;
                    continue;
                }
                ++currentColumn;
                ++currentOffset;
            }
            return new SourcePosition(this.text, line, column, currentOffset);
        }

        @Generated
        public SourcePosition(String text, int line, int column, int offset) {
            this.text = text;
            this.line = line;
            this.column = column;
            this.offset = offset;
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public int getLine() {
            return this.line;
        }

        @Generated
        public int getColumn() {
            return this.column;
        }

        @Generated
        public int getOffset() {
            return this.offset;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SourcePosition)) {
                return false;
            }
            SourcePosition other = (SourcePosition)o;
            if (this.getLine() != other.getLine()) {
                return false;
            }
            if (this.getColumn() != other.getColumn()) {
                return false;
            }
            if (this.getOffset() != other.getOffset()) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLine();
            result = result * 59 + this.getColumn();
            result = result * 59 + this.getOffset();
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ESLint.SourcePosition(text=" + this.getText() + ", line=" + this.getLine() + ", column=" + this.getColumn() + ", offset=" + this.getOffset() + ")";
        }
    }
}

