/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.codemods;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.codemods.NodeBasedRecipe;
import org.openrewrite.codemods.RecipeResources;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.scheduling.WorkingDirectoryExecutionContextView;

public final class Putout
extends NodeBasedRecipe {
    private static final String PUTOUT_DIR = Putout.class.getName() + ".PUTOUT_DIR";
    @Option(displayName="Config file", description="A list of rules to enable", required=false)
    @Nullable
    private final Set<String> rules;

    public String getDisplayName() {
        return "Run Putout";
    }

    public String getDescription() {
        return "Run [Putout](https://github.com/coderaiser/putout) on your projects.";
    }

    @Override
    protected List<String> getNpmCommand(NodeBasedRecipe.Accumulator acc, ExecutionContext ctx) {
        ArrayList<String> commands = new ArrayList<String>();
        String executable = "${nodeModules}/.bin/putout";
        if (this.rules != null) {
            commands.add(executable + " ${repoDir} --disable-all || true");
            for (String rule : this.rules) {
                commands.add(executable + " ${repoDir} --enable " + rule);
            }
        }
        commands.add(executable + " ${repoDir} --fix");
        return commands;
    }

    @Override
    protected void runNode(NodeBasedRecipe.Accumulator acc, ExecutionContext ctx) {
        Path dir = acc.getDirectory();
        Path nodeModules = RecipeResources.from(((Object)((Object)this)).getClass()).init(ctx);
        List<String> commandList = this.getNpmCommand(acc, ctx);
        if (commandList.isEmpty()) {
            return;
        }
        Map<String, String> env = this.getCommandEnvironment(acc, ctx);
        ArrayList<String> processedCommands = new ArrayList<String>();
        for (String cmd : commandList) {
            processedCommands.add(cmd.replace("${nodeModules}", nodeModules.toString()).replace("${repoDir}", ".").replace("${parser}", acc.parser()));
        }
        Path out = null;
        Path err = null;
        try {
            for (String cmd : processedCommands) {
                List<String> singleCommand = Arrays.asList("/bin/bash", "-c", cmd);
                ProcessBuilder builder = new ProcessBuilder(singleCommand);
                builder.directory(dir.toFile());
                builder.environment().put("NODE_PATH", nodeModules.toString());
                builder.environment().put("TERM", "dumb");
                env.forEach(builder.environment()::put);
                out = Files.createTempFile(WorkingDirectoryExecutionContextView.view((ExecutionContext)ctx).getWorkingDirectory(), "node", null, new FileAttribute[0]);
                err = Files.createTempFile(WorkingDirectoryExecutionContextView.view((ExecutionContext)ctx).getWorkingDirectory(), "node", null, new FileAttribute[0]);
                builder.redirectOutput(ProcessBuilder.Redirect.to(out.toFile()));
                builder.redirectError(ProcessBuilder.Redirect.to(err.toFile()));
                Process process = builder.start();
                process.waitFor(5L, TimeUnit.MINUTES);
                if (process.exitValue() != 0) {
                    String error = "Command failed: " + cmd;
                    if (Files.exists(err, new LinkOption[0])) {
                        error = error + "\n" + new String(Files.readAllBytes(err));
                    }
                    throw new RuntimeException(error);
                }
                for (Map.Entry<Path, Long> entry : acc.beforeModificationTimestamps.entrySet()) {
                    Path path = entry.getKey();
                    if (Files.exists(path, new LinkOption[0]) && Files.getLastModifiedTime(path, new LinkOption[0]).toMillis() <= entry.getValue()) continue;
                    acc.modified(path);
                }
                this.processOutput(out, acc, ctx);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                out.toFile().delete();
            }
            if (err != null) {
                err.toFile().delete();
            }
        }
    }

    @Generated
    public Putout(Set<String> rules) {
        this.rules = rules;
    }

    @Generated
    public Set<String> getRules() {
        return this.rules;
    }

    @Generated
    public String toString() {
        return "Putout(rules=" + this.getRules() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Putout)) {
            return false;
        }
        Putout other = (Putout)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Set<String> this$rules = this.getRules();
        Set<String> other$rules = other.getRules();
        return !(this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Putout;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Set<String> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        return result;
    }
}

