# @putout/plugin-apply-early-return [![NPM version][NPMIMGURL]][NPMURL]

[NPMIMGURL]: https://img.shields.io/npm/v/@putout/plugin-apply-early-return.svg?style=flat&longCache=true
[NPMURL]: https://npmjs.org/package/@putout/plugin-apply-early-return"npm"

> In short, an **early return** provides functionality so the result of a conditional statement can be returned as soon as a result is available, rather than wait until the rest of the function is run.
>
> (c) [dev.to](https://dev.to/jenniferlynparsons/early-returns-in-javascript-5hfb)

🐊[**Putout**](https://github.com/coderaiser/putout) plugin adds ability to apply **early return**.

## Install

```
npm i @putout/plugin-apply-early-return
```

## Rule

```json
{
    "rules": {
        "apply-early-return": "on"
    }
}
```

## ❌ Example of incorrect code

```js
function get(a) {
    let b = 0;
    
    if (a > 0)
        b = 5;
    else
        b = 7;
    
    return b;
}
```

## ✅ Example of correct code

```js
function get(a) {
    if (a > 0)
        return 5;
    
    return 7;
}
```

## License

MIT
