import * as Babel from '@babel/core';
import { File } from '@babel/types';
import { ParserOptions } from '@codemod/parser';
/**
 * Fixes the `PluginObj` type from `@babel/core` by making all fields optional
 * and adding parser and generator override methods.
 */
export interface PluginObj<S = File> extends Partial<Babel.PluginObj<S>> {
    parserOverride?(code: string, options: ParserOptions, parse: (code: string, options: ParserOptions) => File): File;
    generatorOverride?(ast: File, options: Babel.GeneratorOptions, code: string, generate: (ast: File, options: Babel.GeneratorOptions) => string): {
        code: string;
        map?: object;
    };
}
export declare type RawBabelPlugin = (babel: typeof Babel) => PluginObj;
export declare type RawBabelPluginWithOptions = [RawBabelPlugin, object];
export declare type BabelPlugin = RawBabelPlugin | RawBabelPluginWithOptions;
