"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transform = void 0;
const core_1 = require("@babel/core");
const assert_1 = require("assert");
const AllSyntaxPlugin_1 = require("./AllSyntaxPlugin");
const RecastPlugin_1 = require("./RecastPlugin");
/**
 * Transform `code` using `@babel/core` parsing using Recast. Additionally,
 * `@codemod/parser` is used to enable as many parser plugins as possible.
 */
function transform(code, options = {}) {
    const result = (0, core_1.transformSync)(code, Object.assign(Object.assign({}, options), { plugins: [
            ...(options.plugins || []),
            (0, AllSyntaxPlugin_1.buildPlugin)(options.sourceType || 'unambiguous'),
            RecastPlugin_1.default,
        ] }));
    (0, assert_1.strict)(result, 'transformSync must return a result');
    return result;
}
exports.transform = transform;
//# sourceMappingURL=transform.js.map