import * as t from '@babel/types';
import { Matcher } from './Matcher';
export { Import as import };
export { Super as super };
export declare class AnyTypeAnnotationMatcher extends Matcher<t.AnyTypeAnnotation> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.AnyTypeAnnotation;
}
export declare function anyTypeAnnotation(): Matcher<t.AnyTypeAnnotation>;
export declare class ArgumentPlaceholderMatcher extends Matcher<t.ArgumentPlaceholder> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ArgumentPlaceholder;
}
export declare function argumentPlaceholder(): Matcher<t.ArgumentPlaceholder>;
export declare class ArrayExpressionMatcher extends Matcher<t.ArrayExpression> {
    private readonly elements?;
    constructor(elements?: Matcher<(t.SpreadElement | t.Expression | null)[]> | (Matcher<t.Expression> | Matcher<null> | Matcher<t.SpreadElement>)[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ArrayExpression;
}
export declare function arrayExpression(elements?: Matcher<Array<null | t.Expression | t.SpreadElement>> | Array<Matcher<null> | Matcher<t.Expression> | Matcher<t.SpreadElement>>): Matcher<t.ArrayExpression>;
export declare class ArrayPatternMatcher extends Matcher<t.ArrayPattern> {
    private readonly elements?;
    constructor(elements?: Matcher<(t.ArrayPattern | t.AssignmentPattern | t.Identifier | t.MemberExpression | t.ObjectPattern | t.RestElement | t.TSAsExpression | t.TSNonNullExpression | t.TSParameterProperty | t.TSSatisfiesExpression | t.TSTypeAssertion | null)[]> | (Matcher<t.LVal> | Matcher<null> | Matcher<t.PatternLike>)[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ArrayPattern;
}
export declare function arrayPattern(elements?: Matcher<Array<null | t.PatternLike | t.LVal>> | Array<Matcher<null> | Matcher<t.PatternLike> | Matcher<t.LVal>>): Matcher<t.ArrayPattern>;
export declare class ArrayTypeAnnotationMatcher extends Matcher<t.ArrayTypeAnnotation> {
    private readonly elementType?;
    constructor(elementType?: Matcher<t.FlowType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ArrayTypeAnnotation;
}
export declare function arrayTypeAnnotation(elementType?: Matcher<t.FlowType>): Matcher<t.ArrayTypeAnnotation>;
export declare class ArrowFunctionExpressionMatcher extends Matcher<t.ArrowFunctionExpression> {
    private readonly params?;
    private readonly body?;
    private readonly async?;
    constructor(params?: Matcher<(t.Identifier | t.RestElement | t.Pattern)[]> | (Matcher<t.Identifier> | Matcher<t.Pattern> | Matcher<t.RestElement>)[] | undefined, body?: Matcher<t.BlockStatement | t.Expression> | undefined, async?: boolean | Matcher<boolean> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ArrowFunctionExpression;
}
export declare function arrowFunctionExpression(params?: Matcher<Array<t.Identifier | t.Pattern | t.RestElement>> | Array<Matcher<t.Identifier> | Matcher<t.Pattern> | Matcher<t.RestElement>>, body?: Matcher<t.BlockStatement | t.Expression>, async?: Matcher<boolean> | boolean): Matcher<t.ArrowFunctionExpression>;
export declare class AssignmentExpressionMatcher extends Matcher<t.AssignmentExpression> {
    private readonly operator?;
    private readonly left?;
    private readonly right?;
    constructor(operator?: string | Matcher<string> | undefined, left?: Matcher<t.LVal> | undefined, right?: Matcher<t.Expression> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.AssignmentExpression;
}
export declare function assignmentExpression(operator?: Matcher<string> | string, left?: Matcher<t.LVal>, right?: Matcher<t.Expression>): Matcher<t.AssignmentExpression>;
export declare class AssignmentPatternMatcher extends Matcher<t.AssignmentPattern> {
    private readonly left?;
    private readonly right?;
    constructor(left?: Matcher<t.ArrayPattern | t.Identifier | t.MemberExpression | t.ObjectPattern | t.TSAsExpression | t.TSNonNullExpression | t.TSSatisfiesExpression | t.TSTypeAssertion> | undefined, right?: Matcher<t.Expression> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.AssignmentPattern;
}
export declare function assignmentPattern(left?: Matcher<t.Identifier | t.ObjectPattern | t.ArrayPattern | t.MemberExpression | t.TSAsExpression | t.TSSatisfiesExpression | t.TSTypeAssertion | t.TSNonNullExpression>, right?: Matcher<t.Expression>): Matcher<t.AssignmentPattern>;
export declare class AwaitExpressionMatcher extends Matcher<t.AwaitExpression> {
    private readonly argument?;
    constructor(argument?: Matcher<t.Expression> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.AwaitExpression;
}
export declare function awaitExpression(argument?: Matcher<t.Expression>): Matcher<t.AwaitExpression>;
export declare class BigIntLiteralMatcher extends Matcher<t.BigIntLiteral> {
    private readonly value?;
    constructor(value?: string | Matcher<string> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.BigIntLiteral;
}
export declare function bigIntLiteral(value?: Matcher<string> | string): Matcher<t.BigIntLiteral>;
export declare class BinaryExpressionMatcher extends Matcher<t.BinaryExpression> {
    private readonly operator?;
    private readonly left?;
    private readonly right?;
    constructor(operator?: string | Matcher<"+" | "-" | "/" | "%" | "*" | "**" | "&" | "|" | ">>" | ">>>" | "<<" | "^" | "==" | "===" | "!=" | "!==" | "in" | "instanceof" | ">" | "<" | ">=" | "<=" | "|>"> | undefined, left?: Matcher<t.PrivateName | t.Expression> | undefined, right?: Matcher<t.Expression> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.BinaryExpression;
}
export declare function binaryExpression(operator?: Matcher<'+' | '-' | '/' | '%' | '*' | '**' | '&' | '|' | '>>' | '>>>' | '<<' | '^' | '==' | '===' | '!=' | '!==' | 'in' | 'instanceof' | '>' | '<' | '>=' | '<=' | '|>'> | string, left?: Matcher<t.Expression | t.PrivateName>, right?: Matcher<t.Expression>): Matcher<t.BinaryExpression>;
export declare class BindExpressionMatcher extends Matcher<t.BindExpression> {
    private readonly object?;
    private readonly callee?;
    constructor(object?: Matcher<t.Expression> | undefined, callee?: Matcher<t.Expression> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.BindExpression;
}
export declare function bindExpression(object?: Matcher<t.Expression>, callee?: Matcher<t.Expression>): Matcher<t.BindExpression>;
export declare class BlockStatementMatcher extends Matcher<t.BlockStatement> {
    private readonly body?;
    private readonly directives?;
    constructor(body?: Matcher<t.Statement[]> | Matcher<t.Statement>[] | undefined, directives?: Matcher<t.Directive[]> | Matcher<t.Directive>[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.BlockStatement;
}
export declare function blockStatement(body?: Matcher<Array<t.Statement>> | Array<Matcher<t.Statement>>, directives?: Matcher<Array<t.Directive>> | Array<Matcher<t.Directive>>): Matcher<t.BlockStatement>;
export declare class BooleanLiteralMatcher extends Matcher<t.BooleanLiteral> {
    private readonly value?;
    constructor(value?: boolean | Matcher<boolean> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.BooleanLiteral;
}
export declare function booleanLiteral(value?: Matcher<boolean> | boolean): Matcher<t.BooleanLiteral>;
export declare class BooleanLiteralTypeAnnotationMatcher extends Matcher<t.BooleanLiteralTypeAnnotation> {
    private readonly value?;
    constructor(value?: boolean | Matcher<boolean> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.BooleanLiteralTypeAnnotation;
}
export declare function booleanLiteralTypeAnnotation(value?: Matcher<boolean> | boolean): Matcher<t.BooleanLiteralTypeAnnotation>;
export declare class BooleanTypeAnnotationMatcher extends Matcher<t.BooleanTypeAnnotation> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.BooleanTypeAnnotation;
}
export declare function booleanTypeAnnotation(): Matcher<t.BooleanTypeAnnotation>;
export declare class BreakStatementMatcher extends Matcher<t.BreakStatement> {
    private readonly label?;
    constructor(label?: Matcher<t.Identifier> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.BreakStatement;
}
export declare function breakStatement(label?: Matcher<t.Identifier> | null): Matcher<t.BreakStatement>;
export declare class CallExpressionMatcher extends Matcher<t.CallExpression> {
    private readonly callee?;
    private readonly _arguments?;
    constructor(callee?: Matcher<t.V8IntrinsicIdentifier | t.Expression> | undefined, _arguments?: Matcher<(t.ArgumentPlaceholder | t.JSXNamespacedName | t.SpreadElement | t.Expression)[]> | (Matcher<t.Expression> | Matcher<t.ArgumentPlaceholder> | Matcher<t.SpreadElement> | Matcher<t.JSXNamespacedName>)[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.CallExpression;
}
export declare function callExpression(callee?: Matcher<t.Expression | t.Super | t.V8IntrinsicIdentifier>, _arguments?: Matcher<Array<t.Expression | t.SpreadElement | t.JSXNamespacedName | t.ArgumentPlaceholder>> | Array<Matcher<t.Expression> | Matcher<t.SpreadElement> | Matcher<t.JSXNamespacedName> | Matcher<t.ArgumentPlaceholder>>): Matcher<t.CallExpression>;
export declare class CatchClauseMatcher extends Matcher<t.CatchClause> {
    private readonly param?;
    private readonly body?;
    constructor(param?: Matcher<t.ArrayPattern | t.Identifier | t.ObjectPattern> | null | undefined, body?: Matcher<t.BlockStatement> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.CatchClause;
}
export declare function catchClause(param?: Matcher<t.Identifier | t.ArrayPattern | t.ObjectPattern> | null, body?: Matcher<t.BlockStatement>): Matcher<t.CatchClause>;
export declare class ClassAccessorPropertyMatcher extends Matcher<t.ClassAccessorProperty> {
    private readonly key?;
    private readonly value?;
    private readonly typeAnnotation?;
    private readonly decorators?;
    private readonly computed?;
    private readonly _static?;
    constructor(key?: Matcher<t.PrivateName | t.Expression> | undefined, value?: Matcher<t.Expression> | null | undefined, typeAnnotation?: Matcher<t.Noop | t.TSTypeAnnotation | t.TypeAnnotation> | null | undefined, decorators?: Matcher<t.Decorator[]> | Matcher<t.Decorator>[] | null | undefined, computed?: boolean | Matcher<boolean> | undefined, _static?: boolean | Matcher<boolean> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ClassAccessorProperty;
}
export declare function classAccessorProperty(key?: Matcher<t.Identifier | t.StringLiteral | t.NumericLiteral | t.BigIntLiteral | t.Expression | t.PrivateName>, value?: Matcher<t.Expression> | null, typeAnnotation?: Matcher<t.TypeAnnotation | t.TSTypeAnnotation | t.Noop> | null, decorators?: Matcher<Array<t.Decorator>> | Array<Matcher<t.Decorator>> | null, computed?: Matcher<boolean> | boolean, _static?: Matcher<boolean> | boolean): Matcher<t.ClassAccessorProperty>;
export declare class ClassBodyMatcher extends Matcher<t.ClassBody> {
    private readonly body?;
    constructor(body?: Matcher<(t.ClassAccessorProperty | t.ClassMethod | t.ClassPrivateMethod | t.ClassPrivateProperty | t.ClassProperty | t.StaticBlock | t.TSDeclareMethod | t.TSIndexSignature)[]> | (Matcher<t.ClassAccessorProperty> | Matcher<t.ClassMethod> | Matcher<t.ClassPrivateMethod> | Matcher<t.ClassProperty> | Matcher<t.ClassPrivateProperty> | Matcher<t.TSDeclareMethod> | Matcher<t.TSIndexSignature> | Matcher<t.StaticBlock>)[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ClassBody;
}
export declare function classBody(body?: Matcher<Array<t.ClassMethod | t.ClassPrivateMethod | t.ClassProperty | t.ClassPrivateProperty | t.ClassAccessorProperty | t.TSDeclareMethod | t.TSIndexSignature | t.StaticBlock>> | Array<Matcher<t.ClassMethod> | Matcher<t.ClassPrivateMethod> | Matcher<t.ClassProperty> | Matcher<t.ClassPrivateProperty> | Matcher<t.ClassAccessorProperty> | Matcher<t.TSDeclareMethod> | Matcher<t.TSIndexSignature> | Matcher<t.StaticBlock>>): Matcher<t.ClassBody>;
export declare class ClassDeclarationMatcher extends Matcher<t.ClassDeclaration> {
    private readonly id?;
    private readonly superClass?;
    private readonly body?;
    private readonly decorators?;
    constructor(id?: Matcher<t.Identifier> | undefined, superClass?: Matcher<t.Expression> | null | undefined, body?: Matcher<t.ClassBody> | undefined, decorators?: Matcher<t.Decorator[]> | Matcher<t.Decorator>[] | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ClassDeclaration;
}
export declare function classDeclaration(id?: Matcher<t.Identifier>, superClass?: Matcher<t.Expression> | null, body?: Matcher<t.ClassBody>, decorators?: Matcher<Array<t.Decorator>> | Array<Matcher<t.Decorator>> | null): Matcher<t.ClassDeclaration>;
export declare class ClassExpressionMatcher extends Matcher<t.ClassExpression> {
    private readonly id?;
    private readonly superClass?;
    private readonly body?;
    private readonly decorators?;
    constructor(id?: Matcher<t.Identifier> | null | undefined, superClass?: Matcher<t.Expression> | null | undefined, body?: Matcher<t.ClassBody> | undefined, decorators?: Matcher<t.Decorator[]> | Matcher<t.Decorator>[] | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ClassExpression;
}
export declare function classExpression(id?: Matcher<t.Identifier> | null, superClass?: Matcher<t.Expression> | null, body?: Matcher<t.ClassBody>, decorators?: Matcher<Array<t.Decorator>> | Array<Matcher<t.Decorator>> | null): Matcher<t.ClassExpression>;
export declare class ClassImplementsMatcher extends Matcher<t.ClassImplements> {
    private readonly id?;
    private readonly typeParameters?;
    constructor(id?: Matcher<t.Identifier> | undefined, typeParameters?: Matcher<t.TypeParameterInstantiation> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ClassImplements;
}
export declare function classImplements(id?: Matcher<t.Identifier>, typeParameters?: Matcher<t.TypeParameterInstantiation> | null): Matcher<t.ClassImplements>;
export declare class ClassMethodMatcher extends Matcher<t.ClassMethod> {
    private readonly kind?;
    private readonly key?;
    private readonly params?;
    private readonly body?;
    private readonly computed?;
    private readonly _static?;
    private readonly generator?;
    private readonly async?;
    constructor(kind?: string | Matcher<"method" | "get" | "set" | "constructor"> | undefined, key?: Matcher<t.Expression> | undefined, params?: Matcher<(t.Identifier | t.RestElement | t.TSParameterProperty | t.Pattern)[]> | (Matcher<t.Identifier> | Matcher<t.Pattern> | Matcher<t.RestElement> | Matcher<t.TSParameterProperty>)[] | undefined, body?: Matcher<t.BlockStatement> | undefined, computed?: boolean | Matcher<boolean> | undefined, _static?: boolean | Matcher<boolean> | undefined, generator?: boolean | Matcher<boolean> | undefined, async?: boolean | Matcher<boolean> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ClassMethod;
}
export declare function classMethod(kind?: Matcher<'get' | 'set' | 'method' | 'constructor'> | string, key?: Matcher<t.Identifier | t.StringLiteral | t.NumericLiteral | t.BigIntLiteral | t.Expression>, params?: Matcher<Array<t.Identifier | t.Pattern | t.RestElement | t.TSParameterProperty>> | Array<Matcher<t.Identifier> | Matcher<t.Pattern> | Matcher<t.RestElement> | Matcher<t.TSParameterProperty>>, body?: Matcher<t.BlockStatement>, computed?: Matcher<boolean> | boolean, _static?: Matcher<boolean> | boolean, generator?: Matcher<boolean> | boolean, async?: Matcher<boolean> | boolean): Matcher<t.ClassMethod>;
export declare class ClassPrivateMethodMatcher extends Matcher<t.ClassPrivateMethod> {
    private readonly kind?;
    private readonly key?;
    private readonly params?;
    private readonly body?;
    private readonly _static?;
    constructor(kind?: string | Matcher<"method" | "get" | "set"> | undefined, key?: Matcher<t.PrivateName> | undefined, params?: Matcher<(t.Identifier | t.RestElement | t.TSParameterProperty | t.Pattern)[]> | (Matcher<t.Identifier> | Matcher<t.Pattern> | Matcher<t.RestElement> | Matcher<t.TSParameterProperty>)[] | undefined, body?: Matcher<t.BlockStatement> | undefined, _static?: boolean | Matcher<boolean> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ClassPrivateMethod;
}
export declare function classPrivateMethod(kind?: Matcher<'get' | 'set' | 'method'> | string, key?: Matcher<t.PrivateName>, params?: Matcher<Array<t.Identifier | t.Pattern | t.RestElement | t.TSParameterProperty>> | Array<Matcher<t.Identifier> | Matcher<t.Pattern> | Matcher<t.RestElement> | Matcher<t.TSParameterProperty>>, body?: Matcher<t.BlockStatement>, _static?: Matcher<boolean> | boolean): Matcher<t.ClassPrivateMethod>;
export declare class ClassPrivatePropertyMatcher extends Matcher<t.ClassPrivateProperty> {
    private readonly key?;
    private readonly value?;
    private readonly decorators?;
    private readonly _static?;
    constructor(key?: Matcher<t.PrivateName> | undefined, value?: Matcher<t.Expression> | null | undefined, decorators?: Matcher<t.Decorator[]> | Matcher<t.Decorator>[] | null | undefined, _static?: boolean | Matcher<boolean> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ClassPrivateProperty;
}
export declare function classPrivateProperty(key?: Matcher<t.PrivateName>, value?: Matcher<t.Expression> | null, decorators?: Matcher<Array<t.Decorator>> | Array<Matcher<t.Decorator>> | null, _static?: Matcher<boolean> | boolean): Matcher<t.ClassPrivateProperty>;
export declare class ClassPropertyMatcher extends Matcher<t.ClassProperty> {
    private readonly key?;
    private readonly value?;
    private readonly typeAnnotation?;
    private readonly decorators?;
    private readonly computed?;
    private readonly _static?;
    constructor(key?: Matcher<t.Expression> | undefined, value?: Matcher<t.Expression> | null | undefined, typeAnnotation?: Matcher<t.Noop | t.TSTypeAnnotation | t.TypeAnnotation> | null | undefined, decorators?: Matcher<t.Decorator[]> | Matcher<t.Decorator>[] | null | undefined, computed?: boolean | Matcher<boolean> | undefined, _static?: boolean | Matcher<boolean> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ClassProperty;
}
export declare function classProperty(key?: Matcher<t.Identifier | t.StringLiteral | t.NumericLiteral | t.BigIntLiteral | t.Expression>, value?: Matcher<t.Expression> | null, typeAnnotation?: Matcher<t.TypeAnnotation | t.TSTypeAnnotation | t.Noop> | null, decorators?: Matcher<Array<t.Decorator>> | Array<Matcher<t.Decorator>> | null, computed?: Matcher<boolean> | boolean, _static?: Matcher<boolean> | boolean): Matcher<t.ClassProperty>;
export declare class ConditionalExpressionMatcher extends Matcher<t.ConditionalExpression> {
    private readonly test?;
    private readonly consequent?;
    private readonly alternate?;
    constructor(test?: Matcher<t.Expression> | undefined, consequent?: Matcher<t.Expression> | undefined, alternate?: Matcher<t.Expression> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ConditionalExpression;
}
export declare function conditionalExpression(test?: Matcher<t.Expression>, consequent?: Matcher<t.Expression>, alternate?: Matcher<t.Expression>): Matcher<t.ConditionalExpression>;
export declare class ContinueStatementMatcher extends Matcher<t.ContinueStatement> {
    private readonly label?;
    constructor(label?: Matcher<t.Identifier> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ContinueStatement;
}
export declare function continueStatement(label?: Matcher<t.Identifier> | null): Matcher<t.ContinueStatement>;
export declare class DebuggerStatementMatcher extends Matcher<t.DebuggerStatement> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.DebuggerStatement;
}
export declare function debuggerStatement(): Matcher<t.DebuggerStatement>;
export declare class DecimalLiteralMatcher extends Matcher<t.DecimalLiteral> {
    private readonly value?;
    constructor(value?: string | Matcher<string> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.DecimalLiteral;
}
export declare function decimalLiteral(value?: Matcher<string> | string): Matcher<t.DecimalLiteral>;
export declare class DeclareClassMatcher extends Matcher<t.DeclareClass> {
    private readonly id?;
    private readonly typeParameters?;
    private readonly _extends?;
    private readonly body?;
    constructor(id?: Matcher<t.Identifier> | undefined, typeParameters?: Matcher<t.TypeParameterDeclaration> | null | undefined, _extends?: Matcher<t.InterfaceExtends[]> | Matcher<t.InterfaceExtends>[] | null | undefined, body?: Matcher<t.ObjectTypeAnnotation> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.DeclareClass;
}
export declare function declareClass(id?: Matcher<t.Identifier>, typeParameters?: Matcher<t.TypeParameterDeclaration> | null, _extends?: Matcher<Array<t.InterfaceExtends>> | Array<Matcher<t.InterfaceExtends>> | null, body?: Matcher<t.ObjectTypeAnnotation>): Matcher<t.DeclareClass>;
export declare class DeclareExportAllDeclarationMatcher extends Matcher<t.DeclareExportAllDeclaration> {
    private readonly source?;
    constructor(source?: Matcher<t.StringLiteral> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.DeclareExportAllDeclaration;
}
export declare function declareExportAllDeclaration(source?: Matcher<t.StringLiteral>): Matcher<t.DeclareExportAllDeclaration>;
export declare class DeclareExportDeclarationMatcher extends Matcher<t.DeclareExportDeclaration> {
    private readonly declaration?;
    private readonly specifiers?;
    private readonly source?;
    constructor(declaration?: Matcher<t.Flow> | null | undefined, specifiers?: Matcher<(t.ExportNamespaceSpecifier | t.ExportSpecifier)[]> | (Matcher<t.ExportSpecifier> | Matcher<t.ExportNamespaceSpecifier>)[] | null | undefined, source?: Matcher<t.StringLiteral> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.DeclareExportDeclaration;
}
export declare function declareExportDeclaration(declaration?: Matcher<t.Flow> | null, specifiers?: Matcher<Array<t.ExportSpecifier | t.ExportNamespaceSpecifier>> | Array<Matcher<t.ExportSpecifier> | Matcher<t.ExportNamespaceSpecifier>> | null, source?: Matcher<t.StringLiteral> | null): Matcher<t.DeclareExportDeclaration>;
export declare class DeclareFunctionMatcher extends Matcher<t.DeclareFunction> {
    private readonly id?;
    constructor(id?: Matcher<t.Identifier> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.DeclareFunction;
}
export declare function declareFunction(id?: Matcher<t.Identifier>): Matcher<t.DeclareFunction>;
export declare class DeclareInterfaceMatcher extends Matcher<t.DeclareInterface> {
    private readonly id?;
    private readonly typeParameters?;
    private readonly _extends?;
    private readonly body?;
    constructor(id?: Matcher<t.Identifier> | undefined, typeParameters?: Matcher<t.TypeParameterDeclaration> | null | undefined, _extends?: Matcher<t.InterfaceExtends[]> | Matcher<t.InterfaceExtends>[] | null | undefined, body?: Matcher<t.ObjectTypeAnnotation> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.DeclareInterface;
}
export declare function declareInterface(id?: Matcher<t.Identifier>, typeParameters?: Matcher<t.TypeParameterDeclaration> | null, _extends?: Matcher<Array<t.InterfaceExtends>> | Array<Matcher<t.InterfaceExtends>> | null, body?: Matcher<t.ObjectTypeAnnotation>): Matcher<t.DeclareInterface>;
export declare class DeclareModuleMatcher extends Matcher<t.DeclareModule> {
    private readonly id?;
    private readonly body?;
    private readonly kind?;
    constructor(id?: Matcher<t.Identifier | t.StringLiteral> | undefined, body?: Matcher<t.BlockStatement> | undefined, kind?: string | Matcher<"CommonJS" | "ES"> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.DeclareModule;
}
export declare function declareModule(id?: Matcher<t.Identifier | t.StringLiteral>, body?: Matcher<t.BlockStatement>, kind?: Matcher<'CommonJS' | 'ES'> | string | null): Matcher<t.DeclareModule>;
export declare class DeclareModuleExportsMatcher extends Matcher<t.DeclareModuleExports> {
    private readonly typeAnnotation?;
    constructor(typeAnnotation?: Matcher<t.TypeAnnotation> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.DeclareModuleExports;
}
export declare function declareModuleExports(typeAnnotation?: Matcher<t.TypeAnnotation>): Matcher<t.DeclareModuleExports>;
export declare class DeclareOpaqueTypeMatcher extends Matcher<t.DeclareOpaqueType> {
    private readonly id?;
    private readonly typeParameters?;
    private readonly supertype?;
    constructor(id?: Matcher<t.Identifier> | undefined, typeParameters?: Matcher<t.TypeParameterDeclaration> | null | undefined, supertype?: Matcher<t.FlowType> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.DeclareOpaqueType;
}
export declare function declareOpaqueType(id?: Matcher<t.Identifier>, typeParameters?: Matcher<t.TypeParameterDeclaration> | null, supertype?: Matcher<t.FlowType> | null): Matcher<t.DeclareOpaqueType>;
export declare class DeclareTypeAliasMatcher extends Matcher<t.DeclareTypeAlias> {
    private readonly id?;
    private readonly typeParameters?;
    private readonly right?;
    constructor(id?: Matcher<t.Identifier> | undefined, typeParameters?: Matcher<t.TypeParameterDeclaration> | null | undefined, right?: Matcher<t.FlowType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.DeclareTypeAlias;
}
export declare function declareTypeAlias(id?: Matcher<t.Identifier>, typeParameters?: Matcher<t.TypeParameterDeclaration> | null, right?: Matcher<t.FlowType>): Matcher<t.DeclareTypeAlias>;
export declare class DeclareVariableMatcher extends Matcher<t.DeclareVariable> {
    private readonly id?;
    constructor(id?: Matcher<t.Identifier> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.DeclareVariable;
}
export declare function declareVariable(id?: Matcher<t.Identifier>): Matcher<t.DeclareVariable>;
export declare class DeclaredPredicateMatcher extends Matcher<t.DeclaredPredicate> {
    private readonly value?;
    constructor(value?: Matcher<t.Flow> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.DeclaredPredicate;
}
export declare function declaredPredicate(value?: Matcher<t.Flow>): Matcher<t.DeclaredPredicate>;
export declare class DecoratorMatcher extends Matcher<t.Decorator> {
    private readonly expression?;
    constructor(expression?: Matcher<t.Expression> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.Decorator;
}
export declare function decorator(expression?: Matcher<t.Expression>): Matcher<t.Decorator>;
export declare class DirectiveMatcher extends Matcher<t.Directive> {
    private readonly value?;
    constructor(value?: Matcher<t.DirectiveLiteral> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.Directive;
}
export declare function directive(value?: Matcher<t.DirectiveLiteral>): Matcher<t.Directive>;
export declare class DirectiveLiteralMatcher extends Matcher<t.DirectiveLiteral> {
    private readonly value?;
    constructor(value?: string | Matcher<string> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.DirectiveLiteral;
}
export declare function directiveLiteral(value?: Matcher<string> | string): Matcher<t.DirectiveLiteral>;
export declare class DoExpressionMatcher extends Matcher<t.DoExpression> {
    private readonly body?;
    private readonly async?;
    constructor(body?: Matcher<t.BlockStatement> | undefined, async?: boolean | Matcher<boolean> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.DoExpression;
}
export declare function doExpression(body?: Matcher<t.BlockStatement>, async?: Matcher<boolean> | boolean): Matcher<t.DoExpression>;
export declare class DoWhileStatementMatcher extends Matcher<t.DoWhileStatement> {
    private readonly test?;
    private readonly body?;
    constructor(test?: Matcher<t.Expression> | undefined, body?: Matcher<t.Statement> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.DoWhileStatement;
}
export declare function doWhileStatement(test?: Matcher<t.Expression>, body?: Matcher<t.Statement>): Matcher<t.DoWhileStatement>;
export declare class EmptyStatementMatcher extends Matcher<t.EmptyStatement> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.EmptyStatement;
}
export declare function emptyStatement(): Matcher<t.EmptyStatement>;
export declare class EmptyTypeAnnotationMatcher extends Matcher<t.EmptyTypeAnnotation> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.EmptyTypeAnnotation;
}
export declare function emptyTypeAnnotation(): Matcher<t.EmptyTypeAnnotation>;
export declare class EnumBooleanBodyMatcher extends Matcher<t.EnumBooleanBody> {
    private readonly members?;
    constructor(members?: Matcher<t.EnumBooleanMember[]> | Matcher<t.EnumBooleanMember>[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.EnumBooleanBody;
}
export declare function enumBooleanBody(members?: Matcher<Array<t.EnumBooleanMember>> | Array<Matcher<t.EnumBooleanMember>>): Matcher<t.EnumBooleanBody>;
export declare class EnumBooleanMemberMatcher extends Matcher<t.EnumBooleanMember> {
    private readonly id?;
    constructor(id?: Matcher<t.Identifier> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.EnumBooleanMember;
}
export declare function enumBooleanMember(id?: Matcher<t.Identifier>): Matcher<t.EnumBooleanMember>;
export declare class EnumDeclarationMatcher extends Matcher<t.EnumDeclaration> {
    private readonly id?;
    private readonly body?;
    constructor(id?: Matcher<t.Identifier> | undefined, body?: Matcher<t.EnumBooleanBody | t.EnumNumberBody | t.EnumStringBody | t.EnumSymbolBody> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.EnumDeclaration;
}
export declare function enumDeclaration(id?: Matcher<t.Identifier>, body?: Matcher<t.EnumBooleanBody | t.EnumNumberBody | t.EnumStringBody | t.EnumSymbolBody>): Matcher<t.EnumDeclaration>;
export declare class EnumDefaultedMemberMatcher extends Matcher<t.EnumDefaultedMember> {
    private readonly id?;
    constructor(id?: Matcher<t.Identifier> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.EnumDefaultedMember;
}
export declare function enumDefaultedMember(id?: Matcher<t.Identifier>): Matcher<t.EnumDefaultedMember>;
export declare class EnumNumberBodyMatcher extends Matcher<t.EnumNumberBody> {
    private readonly members?;
    constructor(members?: Matcher<t.EnumNumberMember[]> | Matcher<t.EnumNumberMember>[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.EnumNumberBody;
}
export declare function enumNumberBody(members?: Matcher<Array<t.EnumNumberMember>> | Array<Matcher<t.EnumNumberMember>>): Matcher<t.EnumNumberBody>;
export declare class EnumNumberMemberMatcher extends Matcher<t.EnumNumberMember> {
    private readonly id?;
    private readonly init?;
    constructor(id?: Matcher<t.Identifier> | undefined, init?: Matcher<t.NumericLiteral> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.EnumNumberMember;
}
export declare function enumNumberMember(id?: Matcher<t.Identifier>, init?: Matcher<t.NumericLiteral>): Matcher<t.EnumNumberMember>;
export declare class EnumStringBodyMatcher extends Matcher<t.EnumStringBody> {
    private readonly members?;
    constructor(members?: Matcher<(t.EnumDefaultedMember | t.EnumStringMember)[]> | (Matcher<t.EnumDefaultedMember> | Matcher<t.EnumStringMember>)[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.EnumStringBody;
}
export declare function enumStringBody(members?: Matcher<Array<t.EnumStringMember | t.EnumDefaultedMember>> | Array<Matcher<t.EnumStringMember> | Matcher<t.EnumDefaultedMember>>): Matcher<t.EnumStringBody>;
export declare class EnumStringMemberMatcher extends Matcher<t.EnumStringMember> {
    private readonly id?;
    private readonly init?;
    constructor(id?: Matcher<t.Identifier> | undefined, init?: Matcher<t.StringLiteral> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.EnumStringMember;
}
export declare function enumStringMember(id?: Matcher<t.Identifier>, init?: Matcher<t.StringLiteral>): Matcher<t.EnumStringMember>;
export declare class EnumSymbolBodyMatcher extends Matcher<t.EnumSymbolBody> {
    private readonly members?;
    constructor(members?: Matcher<t.EnumDefaultedMember[]> | Matcher<t.EnumDefaultedMember>[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.EnumSymbolBody;
}
export declare function enumSymbolBody(members?: Matcher<Array<t.EnumDefaultedMember>> | Array<Matcher<t.EnumDefaultedMember>>): Matcher<t.EnumSymbolBody>;
export declare class ExistsTypeAnnotationMatcher extends Matcher<t.ExistsTypeAnnotation> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ExistsTypeAnnotation;
}
export declare function existsTypeAnnotation(): Matcher<t.ExistsTypeAnnotation>;
export declare class ExportAllDeclarationMatcher extends Matcher<t.ExportAllDeclaration> {
    private readonly source?;
    constructor(source?: Matcher<t.StringLiteral> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ExportAllDeclaration;
}
export declare function exportAllDeclaration(source?: Matcher<t.StringLiteral>): Matcher<t.ExportAllDeclaration>;
export declare class ExportDefaultDeclarationMatcher extends Matcher<t.ExportDefaultDeclaration> {
    private readonly declaration?;
    constructor(declaration?: Matcher<t.ClassDeclaration | t.FunctionDeclaration | t.TSDeclareFunction | t.Expression> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ExportDefaultDeclaration;
}
export declare function exportDefaultDeclaration(declaration?: Matcher<t.TSDeclareFunction | t.FunctionDeclaration | t.ClassDeclaration | t.Expression>): Matcher<t.ExportDefaultDeclaration>;
export declare class ExportDefaultSpecifierMatcher extends Matcher<t.ExportDefaultSpecifier> {
    private readonly exported?;
    constructor(exported?: Matcher<t.Identifier> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ExportDefaultSpecifier;
}
export declare function exportDefaultSpecifier(exported?: Matcher<t.Identifier>): Matcher<t.ExportDefaultSpecifier>;
export declare class ExportNamedDeclarationMatcher extends Matcher<t.ExportNamedDeclaration> {
    private readonly declaration?;
    private readonly specifiers?;
    private readonly source?;
    constructor(declaration?: Matcher<t.Declaration> | null | undefined, specifiers?: Matcher<(t.ExportDefaultSpecifier | t.ExportNamespaceSpecifier | t.ExportSpecifier)[]> | (Matcher<t.ExportSpecifier> | Matcher<t.ExportNamespaceSpecifier> | Matcher<t.ExportDefaultSpecifier>)[] | undefined, source?: Matcher<t.StringLiteral> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ExportNamedDeclaration;
}
export declare function exportNamedDeclaration(declaration?: Matcher<t.Declaration> | null, specifiers?: Matcher<Array<t.ExportSpecifier | t.ExportDefaultSpecifier | t.ExportNamespaceSpecifier>> | Array<Matcher<t.ExportSpecifier> | Matcher<t.ExportDefaultSpecifier> | Matcher<t.ExportNamespaceSpecifier>>, source?: Matcher<t.StringLiteral> | null): Matcher<t.ExportNamedDeclaration>;
export declare class ExportNamespaceSpecifierMatcher extends Matcher<t.ExportNamespaceSpecifier> {
    private readonly exported?;
    constructor(exported?: Matcher<t.Identifier> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ExportNamespaceSpecifier;
}
export declare function exportNamespaceSpecifier(exported?: Matcher<t.Identifier>): Matcher<t.ExportNamespaceSpecifier>;
export declare class ExportSpecifierMatcher extends Matcher<t.ExportSpecifier> {
    private readonly local?;
    private readonly exported?;
    constructor(local?: Matcher<t.Identifier> | undefined, exported?: Matcher<t.Identifier | t.StringLiteral> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ExportSpecifier;
}
export declare function exportSpecifier(local?: Matcher<t.Identifier>, exported?: Matcher<t.Identifier | t.StringLiteral>): Matcher<t.ExportSpecifier>;
export declare class ExpressionStatementMatcher extends Matcher<t.ExpressionStatement> {
    private readonly expression?;
    constructor(expression?: Matcher<t.Expression> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ExpressionStatement;
}
export declare function expressionStatement(expression?: Matcher<t.Expression>): Matcher<t.ExpressionStatement>;
export declare class FileMatcher extends Matcher<t.File> {
    private readonly program?;
    private readonly comments?;
    private readonly tokens?;
    constructor(program?: Matcher<t.Program> | undefined, comments?: Matcher<(t.CommentBlock | t.CommentLine)[]> | null | undefined, tokens?: Matcher<any[]> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.File;
}
export declare function file(program?: Matcher<t.Program>, comments?: Matcher<Array<t.CommentBlock | t.CommentLine>> | null, tokens?: Matcher<Array<any>> | null): Matcher<t.File>;
export declare class ForInStatementMatcher extends Matcher<t.ForInStatement> {
    private readonly left?;
    private readonly right?;
    private readonly body?;
    constructor(left?: Matcher<t.VariableDeclaration | t.LVal> | undefined, right?: Matcher<t.Expression> | undefined, body?: Matcher<t.Statement> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ForInStatement;
}
export declare function forInStatement(left?: Matcher<t.VariableDeclaration | t.LVal>, right?: Matcher<t.Expression>, body?: Matcher<t.Statement>): Matcher<t.ForInStatement>;
export declare class ForOfStatementMatcher extends Matcher<t.ForOfStatement> {
    private readonly left?;
    private readonly right?;
    private readonly body?;
    private readonly _await?;
    constructor(left?: Matcher<t.VariableDeclaration | t.LVal> | undefined, right?: Matcher<t.Expression> | undefined, body?: Matcher<t.Statement> | undefined, _await?: boolean | Matcher<boolean> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ForOfStatement;
}
export declare function forOfStatement(left?: Matcher<t.VariableDeclaration | t.LVal>, right?: Matcher<t.Expression>, body?: Matcher<t.Statement>, _await?: Matcher<boolean> | boolean): Matcher<t.ForOfStatement>;
export declare class ForStatementMatcher extends Matcher<t.ForStatement> {
    private readonly init?;
    private readonly test?;
    private readonly update?;
    private readonly body?;
    constructor(init?: Matcher<t.VariableDeclaration | t.Expression> | null | undefined, test?: Matcher<t.Expression> | null | undefined, update?: Matcher<t.Expression> | null | undefined, body?: Matcher<t.Statement> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ForStatement;
}
export declare function forStatement(init?: Matcher<t.VariableDeclaration | t.Expression> | null, test?: Matcher<t.Expression> | null, update?: Matcher<t.Expression> | null, body?: Matcher<t.Statement>): Matcher<t.ForStatement>;
export declare class FunctionDeclarationMatcher extends Matcher<t.FunctionDeclaration> {
    private readonly id?;
    private readonly params?;
    private readonly body?;
    private readonly generator?;
    private readonly async?;
    constructor(id?: Matcher<t.Identifier> | null | undefined, params?: Matcher<(t.Identifier | t.RestElement | t.Pattern)[]> | (Matcher<t.Identifier> | Matcher<t.Pattern> | Matcher<t.RestElement>)[] | undefined, body?: Matcher<t.BlockStatement> | undefined, generator?: boolean | Matcher<boolean> | undefined, async?: boolean | Matcher<boolean> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.FunctionDeclaration;
}
export declare function functionDeclaration(id?: Matcher<t.Identifier> | null, params?: Matcher<Array<t.Identifier | t.Pattern | t.RestElement>> | Array<Matcher<t.Identifier> | Matcher<t.Pattern> | Matcher<t.RestElement>>, body?: Matcher<t.BlockStatement>, generator?: Matcher<boolean> | boolean, async?: Matcher<boolean> | boolean): Matcher<t.FunctionDeclaration>;
export declare class FunctionExpressionMatcher extends Matcher<t.FunctionExpression> {
    private readonly id?;
    private readonly params?;
    private readonly body?;
    private readonly generator?;
    private readonly async?;
    constructor(id?: Matcher<t.Identifier> | null | undefined, params?: Matcher<(t.Identifier | t.RestElement | t.Pattern)[]> | (Matcher<t.Identifier> | Matcher<t.Pattern> | Matcher<t.RestElement>)[] | undefined, body?: Matcher<t.BlockStatement> | undefined, generator?: boolean | Matcher<boolean> | undefined, async?: boolean | Matcher<boolean> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.FunctionExpression;
}
export declare function functionExpression(id?: Matcher<t.Identifier> | null, params?: Matcher<Array<t.Identifier | t.Pattern | t.RestElement>> | Array<Matcher<t.Identifier> | Matcher<t.Pattern> | Matcher<t.RestElement>>, body?: Matcher<t.BlockStatement>, generator?: Matcher<boolean> | boolean, async?: Matcher<boolean> | boolean): Matcher<t.FunctionExpression>;
export declare class FunctionTypeAnnotationMatcher extends Matcher<t.FunctionTypeAnnotation> {
    private readonly typeParameters?;
    private readonly params?;
    private readonly rest?;
    private readonly returnType?;
    constructor(typeParameters?: Matcher<t.TypeParameterDeclaration> | null | undefined, params?: Matcher<t.FunctionTypeParam[]> | Matcher<t.FunctionTypeParam>[] | undefined, rest?: Matcher<t.FunctionTypeParam> | null | undefined, returnType?: Matcher<t.FlowType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.FunctionTypeAnnotation;
}
export declare function functionTypeAnnotation(typeParameters?: Matcher<t.TypeParameterDeclaration> | null, params?: Matcher<Array<t.FunctionTypeParam>> | Array<Matcher<t.FunctionTypeParam>>, rest?: Matcher<t.FunctionTypeParam> | null, returnType?: Matcher<t.FlowType>): Matcher<t.FunctionTypeAnnotation>;
export declare class FunctionTypeParamMatcher extends Matcher<t.FunctionTypeParam> {
    private readonly name?;
    private readonly typeAnnotation?;
    constructor(name?: Matcher<t.Identifier> | null | undefined, typeAnnotation?: Matcher<t.FlowType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.FunctionTypeParam;
}
export declare function functionTypeParam(name?: Matcher<t.Identifier> | null, typeAnnotation?: Matcher<t.FlowType>): Matcher<t.FunctionTypeParam>;
export declare class GenericTypeAnnotationMatcher extends Matcher<t.GenericTypeAnnotation> {
    private readonly id?;
    private readonly typeParameters?;
    constructor(id?: Matcher<t.Identifier | t.QualifiedTypeIdentifier> | undefined, typeParameters?: Matcher<t.TypeParameterInstantiation> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.GenericTypeAnnotation;
}
export declare function genericTypeAnnotation(id?: Matcher<t.Identifier | t.QualifiedTypeIdentifier>, typeParameters?: Matcher<t.TypeParameterInstantiation> | null): Matcher<t.GenericTypeAnnotation>;
export declare class IdentifierMatcher extends Matcher<t.Identifier> {
    private readonly name?;
    constructor(name?: string | Matcher<string> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.Identifier;
}
export declare function identifier(name?: Matcher<string> | string): Matcher<t.Identifier>;
export declare class IfStatementMatcher extends Matcher<t.IfStatement> {
    private readonly test?;
    private readonly consequent?;
    private readonly alternate?;
    constructor(test?: Matcher<t.Expression> | undefined, consequent?: Matcher<t.Statement> | undefined, alternate?: Matcher<t.Statement> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.IfStatement;
}
export declare function ifStatement(test?: Matcher<t.Expression>, consequent?: Matcher<t.Statement>, alternate?: Matcher<t.Statement> | null): Matcher<t.IfStatement>;
export declare class ImportMatcher extends Matcher<t.Import> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.Import;
}
export declare function Import(): Matcher<t.Import>;
export declare class ImportAttributeMatcher extends Matcher<t.ImportAttribute> {
    private readonly key?;
    private readonly value?;
    constructor(key?: Matcher<t.Identifier | t.StringLiteral> | undefined, value?: Matcher<t.StringLiteral> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ImportAttribute;
}
export declare function importAttribute(key?: Matcher<t.Identifier | t.StringLiteral>, value?: Matcher<t.StringLiteral>): Matcher<t.ImportAttribute>;
export declare class ImportDeclarationMatcher extends Matcher<t.ImportDeclaration> {
    private readonly specifiers?;
    private readonly source?;
    constructor(specifiers?: Matcher<(t.ImportDefaultSpecifier | t.ImportNamespaceSpecifier | t.ImportSpecifier)[]> | (Matcher<t.ImportSpecifier> | Matcher<t.ImportDefaultSpecifier> | Matcher<t.ImportNamespaceSpecifier>)[] | undefined, source?: Matcher<t.StringLiteral> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ImportDeclaration;
}
export declare function importDeclaration(specifiers?: Matcher<Array<t.ImportSpecifier | t.ImportDefaultSpecifier | t.ImportNamespaceSpecifier>> | Array<Matcher<t.ImportSpecifier> | Matcher<t.ImportDefaultSpecifier> | Matcher<t.ImportNamespaceSpecifier>>, source?: Matcher<t.StringLiteral>): Matcher<t.ImportDeclaration>;
export declare class ImportDefaultSpecifierMatcher extends Matcher<t.ImportDefaultSpecifier> {
    private readonly local?;
    constructor(local?: Matcher<t.Identifier> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ImportDefaultSpecifier;
}
export declare function importDefaultSpecifier(local?: Matcher<t.Identifier>): Matcher<t.ImportDefaultSpecifier>;
export declare class ImportNamespaceSpecifierMatcher extends Matcher<t.ImportNamespaceSpecifier> {
    private readonly local?;
    constructor(local?: Matcher<t.Identifier> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ImportNamespaceSpecifier;
}
export declare function importNamespaceSpecifier(local?: Matcher<t.Identifier>): Matcher<t.ImportNamespaceSpecifier>;
export declare class ImportSpecifierMatcher extends Matcher<t.ImportSpecifier> {
    private readonly local?;
    private readonly imported?;
    constructor(local?: Matcher<t.Identifier> | undefined, imported?: Matcher<t.Identifier | t.StringLiteral> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ImportSpecifier;
}
export declare function importSpecifier(local?: Matcher<t.Identifier>, imported?: Matcher<t.Identifier | t.StringLiteral>): Matcher<t.ImportSpecifier>;
export declare class IndexedAccessTypeMatcher extends Matcher<t.IndexedAccessType> {
    private readonly objectType?;
    private readonly indexType?;
    constructor(objectType?: Matcher<t.FlowType> | undefined, indexType?: Matcher<t.FlowType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.IndexedAccessType;
}
export declare function indexedAccessType(objectType?: Matcher<t.FlowType>, indexType?: Matcher<t.FlowType>): Matcher<t.IndexedAccessType>;
export declare class InferredPredicateMatcher extends Matcher<t.InferredPredicate> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.InferredPredicate;
}
export declare function inferredPredicate(): Matcher<t.InferredPredicate>;
export declare class InterfaceDeclarationMatcher extends Matcher<t.InterfaceDeclaration> {
    private readonly id?;
    private readonly typeParameters?;
    private readonly _extends?;
    private readonly body?;
    constructor(id?: Matcher<t.Identifier> | undefined, typeParameters?: Matcher<t.TypeParameterDeclaration> | null | undefined, _extends?: Matcher<t.InterfaceExtends[]> | Matcher<t.InterfaceExtends>[] | null | undefined, body?: Matcher<t.ObjectTypeAnnotation> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.InterfaceDeclaration;
}
export declare function interfaceDeclaration(id?: Matcher<t.Identifier>, typeParameters?: Matcher<t.TypeParameterDeclaration> | null, _extends?: Matcher<Array<t.InterfaceExtends>> | Array<Matcher<t.InterfaceExtends>> | null, body?: Matcher<t.ObjectTypeAnnotation>): Matcher<t.InterfaceDeclaration>;
export declare class InterfaceExtendsMatcher extends Matcher<t.InterfaceExtends> {
    private readonly id?;
    private readonly typeParameters?;
    constructor(id?: Matcher<t.Identifier | t.QualifiedTypeIdentifier> | undefined, typeParameters?: Matcher<t.TypeParameterInstantiation> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.InterfaceExtends;
}
export declare function interfaceExtends(id?: Matcher<t.Identifier | t.QualifiedTypeIdentifier>, typeParameters?: Matcher<t.TypeParameterInstantiation> | null): Matcher<t.InterfaceExtends>;
export declare class InterfaceTypeAnnotationMatcher extends Matcher<t.InterfaceTypeAnnotation> {
    private readonly _extends?;
    private readonly body?;
    constructor(_extends?: Matcher<t.InterfaceExtends[]> | Matcher<t.InterfaceExtends>[] | null | undefined, body?: Matcher<t.ObjectTypeAnnotation> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.InterfaceTypeAnnotation;
}
export declare function interfaceTypeAnnotation(_extends?: Matcher<Array<t.InterfaceExtends>> | Array<Matcher<t.InterfaceExtends>> | null, body?: Matcher<t.ObjectTypeAnnotation>): Matcher<t.InterfaceTypeAnnotation>;
export declare class InterpreterDirectiveMatcher extends Matcher<t.InterpreterDirective> {
    private readonly value?;
    constructor(value?: string | Matcher<string> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.InterpreterDirective;
}
export declare function interpreterDirective(value?: Matcher<string> | string): Matcher<t.InterpreterDirective>;
export declare class IntersectionTypeAnnotationMatcher extends Matcher<t.IntersectionTypeAnnotation> {
    private readonly types?;
    constructor(types?: Matcher<t.FlowType[]> | Matcher<t.FlowType>[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.IntersectionTypeAnnotation;
}
export declare function intersectionTypeAnnotation(types?: Matcher<Array<t.FlowType>> | Array<Matcher<t.FlowType>>): Matcher<t.IntersectionTypeAnnotation>;
export declare class JSXAttributeMatcher extends Matcher<t.JSXAttribute> {
    private readonly name?;
    private readonly value?;
    constructor(name?: Matcher<t.JSXIdentifier | t.JSXNamespacedName> | undefined, value?: Matcher<t.JSXElement | t.JSXExpressionContainer | t.JSXFragment | t.StringLiteral> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.JSXAttribute;
}
export declare function jsxAttribute(name?: Matcher<t.JSXIdentifier | t.JSXNamespacedName>, value?: Matcher<t.JSXElement | t.JSXFragment | t.StringLiteral | t.JSXExpressionContainer> | null): Matcher<t.JSXAttribute>;
export declare class JSXClosingElementMatcher extends Matcher<t.JSXClosingElement> {
    private readonly name?;
    constructor(name?: Matcher<t.JSXIdentifier | t.JSXMemberExpression | t.JSXNamespacedName> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.JSXClosingElement;
}
export declare function jsxClosingElement(name?: Matcher<t.JSXIdentifier | t.JSXMemberExpression | t.JSXNamespacedName>): Matcher<t.JSXClosingElement>;
export declare class JSXClosingFragmentMatcher extends Matcher<t.JSXClosingFragment> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.JSXClosingFragment;
}
export declare function jsxClosingFragment(): Matcher<t.JSXClosingFragment>;
export declare class JSXElementMatcher extends Matcher<t.JSXElement> {
    private readonly openingElement?;
    private readonly closingElement?;
    private readonly children?;
    private readonly selfClosing?;
    constructor(openingElement?: Matcher<t.JSXOpeningElement> | undefined, closingElement?: Matcher<t.JSXClosingElement> | null | undefined, children?: Matcher<(t.JSXElement | t.JSXExpressionContainer | t.JSXFragment | t.JSXSpreadChild | t.JSXText)[]> | (Matcher<t.JSXElement> | Matcher<t.JSXText> | Matcher<t.JSXExpressionContainer> | Matcher<t.JSXSpreadChild> | Matcher<t.JSXFragment>)[] | undefined, selfClosing?: boolean | Matcher<boolean> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.JSXElement;
}
export declare function jsxElement(openingElement?: Matcher<t.JSXOpeningElement>, closingElement?: Matcher<t.JSXClosingElement> | null, children?: Matcher<Array<t.JSXText | t.JSXExpressionContainer | t.JSXSpreadChild | t.JSXElement | t.JSXFragment>> | Array<Matcher<t.JSXText> | Matcher<t.JSXExpressionContainer> | Matcher<t.JSXSpreadChild> | Matcher<t.JSXElement> | Matcher<t.JSXFragment>>, selfClosing?: Matcher<boolean> | boolean | null): Matcher<t.JSXElement>;
export declare class JSXEmptyExpressionMatcher extends Matcher<t.JSXEmptyExpression> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.JSXEmptyExpression;
}
export declare function jsxEmptyExpression(): Matcher<t.JSXEmptyExpression>;
export declare class JSXExpressionContainerMatcher extends Matcher<t.JSXExpressionContainer> {
    private readonly expression?;
    constructor(expression?: Matcher<t.JSXEmptyExpression | t.Expression> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.JSXExpressionContainer;
}
export declare function jsxExpressionContainer(expression?: Matcher<t.Expression | t.JSXEmptyExpression>): Matcher<t.JSXExpressionContainer>;
export declare class JSXFragmentMatcher extends Matcher<t.JSXFragment> {
    private readonly openingFragment?;
    private readonly closingFragment?;
    private readonly children?;
    constructor(openingFragment?: Matcher<t.JSXOpeningFragment> | undefined, closingFragment?: Matcher<t.JSXClosingFragment> | undefined, children?: Matcher<(t.JSXElement | t.JSXExpressionContainer | t.JSXFragment | t.JSXSpreadChild | t.JSXText)[]> | (Matcher<t.JSXElement> | Matcher<t.JSXText> | Matcher<t.JSXExpressionContainer> | Matcher<t.JSXSpreadChild> | Matcher<t.JSXFragment>)[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.JSXFragment;
}
export declare function jsxFragment(openingFragment?: Matcher<t.JSXOpeningFragment>, closingFragment?: Matcher<t.JSXClosingFragment>, children?: Matcher<Array<t.JSXText | t.JSXExpressionContainer | t.JSXSpreadChild | t.JSXElement | t.JSXFragment>> | Array<Matcher<t.JSXText> | Matcher<t.JSXExpressionContainer> | Matcher<t.JSXSpreadChild> | Matcher<t.JSXElement> | Matcher<t.JSXFragment>>): Matcher<t.JSXFragment>;
export declare class JSXIdentifierMatcher extends Matcher<t.JSXIdentifier> {
    private readonly name?;
    constructor(name?: string | Matcher<string> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.JSXIdentifier;
}
export declare function jsxIdentifier(name?: Matcher<string> | string): Matcher<t.JSXIdentifier>;
export declare class JSXMemberExpressionMatcher extends Matcher<t.JSXMemberExpression> {
    private readonly object?;
    private readonly property?;
    constructor(object?: Matcher<t.JSXIdentifier | t.JSXMemberExpression> | undefined, property?: Matcher<t.JSXIdentifier> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.JSXMemberExpression;
}
export declare function jsxMemberExpression(object?: Matcher<t.JSXMemberExpression | t.JSXIdentifier>, property?: Matcher<t.JSXIdentifier>): Matcher<t.JSXMemberExpression>;
export declare class JSXNamespacedNameMatcher extends Matcher<t.JSXNamespacedName> {
    private readonly namespace?;
    private readonly name?;
    constructor(namespace?: Matcher<t.JSXIdentifier> | undefined, name?: Matcher<t.JSXIdentifier> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.JSXNamespacedName;
}
export declare function jsxNamespacedName(namespace?: Matcher<t.JSXIdentifier>, name?: Matcher<t.JSXIdentifier>): Matcher<t.JSXNamespacedName>;
export declare class JSXOpeningElementMatcher extends Matcher<t.JSXOpeningElement> {
    private readonly name?;
    private readonly attributes?;
    private readonly selfClosing?;
    constructor(name?: Matcher<t.JSXIdentifier | t.JSXMemberExpression | t.JSXNamespacedName> | undefined, attributes?: Matcher<(t.JSXAttribute | t.JSXSpreadAttribute)[]> | (Matcher<t.JSXAttribute> | Matcher<t.JSXSpreadAttribute>)[] | undefined, selfClosing?: boolean | Matcher<boolean> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.JSXOpeningElement;
}
export declare function jsxOpeningElement(name?: Matcher<t.JSXIdentifier | t.JSXMemberExpression | t.JSXNamespacedName>, attributes?: Matcher<Array<t.JSXAttribute | t.JSXSpreadAttribute>> | Array<Matcher<t.JSXAttribute> | Matcher<t.JSXSpreadAttribute>>, selfClosing?: Matcher<boolean> | boolean): Matcher<t.JSXOpeningElement>;
export declare class JSXOpeningFragmentMatcher extends Matcher<t.JSXOpeningFragment> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.JSXOpeningFragment;
}
export declare function jsxOpeningFragment(): Matcher<t.JSXOpeningFragment>;
export declare class JSXSpreadAttributeMatcher extends Matcher<t.JSXSpreadAttribute> {
    private readonly argument?;
    constructor(argument?: Matcher<t.Expression> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.JSXSpreadAttribute;
}
export declare function jsxSpreadAttribute(argument?: Matcher<t.Expression>): Matcher<t.JSXSpreadAttribute>;
export declare class JSXSpreadChildMatcher extends Matcher<t.JSXSpreadChild> {
    private readonly expression?;
    constructor(expression?: Matcher<t.Expression> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.JSXSpreadChild;
}
export declare function jsxSpreadChild(expression?: Matcher<t.Expression>): Matcher<t.JSXSpreadChild>;
export declare class JSXTextMatcher extends Matcher<t.JSXText> {
    private readonly value?;
    constructor(value?: string | Matcher<string> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.JSXText;
}
export declare function jsxText(value?: Matcher<string> | string): Matcher<t.JSXText>;
export declare class LabeledStatementMatcher extends Matcher<t.LabeledStatement> {
    private readonly label?;
    private readonly body?;
    constructor(label?: Matcher<t.Identifier> | undefined, body?: Matcher<t.Statement> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.LabeledStatement;
}
export declare function labeledStatement(label?: Matcher<t.Identifier>, body?: Matcher<t.Statement>): Matcher<t.LabeledStatement>;
export declare class LogicalExpressionMatcher extends Matcher<t.LogicalExpression> {
    private readonly operator?;
    private readonly left?;
    private readonly right?;
    constructor(operator?: string | Matcher<"||" | "&&" | "??"> | undefined, left?: Matcher<t.Expression> | undefined, right?: Matcher<t.Expression> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.LogicalExpression;
}
export declare function logicalExpression(operator?: Matcher<'||' | '&&' | '??'> | string, left?: Matcher<t.Expression>, right?: Matcher<t.Expression>): Matcher<t.LogicalExpression>;
export declare class MemberExpressionMatcher extends Matcher<t.MemberExpression> {
    private readonly object?;
    private readonly property?;
    private readonly computed?;
    private readonly optional?;
    constructor(object?: Matcher<t.Expression> | undefined, property?: Matcher<t.PrivateName | t.Expression> | undefined, computed?: boolean | Matcher<boolean> | undefined, optional?: boolean | Matcher<boolean> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.MemberExpression;
}
export declare function memberExpression(object?: Matcher<t.Expression | t.Super>, property?: Matcher<t.Expression | t.Identifier | t.PrivateName>, computed?: Matcher<boolean> | boolean, optional?: Matcher<true | false> | boolean | null): Matcher<t.MemberExpression>;
export declare class MetaPropertyMatcher extends Matcher<t.MetaProperty> {
    private readonly meta?;
    private readonly property?;
    constructor(meta?: Matcher<t.Identifier> | undefined, property?: Matcher<t.Identifier> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.MetaProperty;
}
export declare function metaProperty(meta?: Matcher<t.Identifier>, property?: Matcher<t.Identifier>): Matcher<t.MetaProperty>;
export declare class MixedTypeAnnotationMatcher extends Matcher<t.MixedTypeAnnotation> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.MixedTypeAnnotation;
}
export declare function mixedTypeAnnotation(): Matcher<t.MixedTypeAnnotation>;
export declare class ModuleExpressionMatcher extends Matcher<t.ModuleExpression> {
    private readonly body?;
    constructor(body?: Matcher<t.Program> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ModuleExpression;
}
export declare function moduleExpression(body?: Matcher<t.Program>): Matcher<t.ModuleExpression>;
export declare class NewExpressionMatcher extends Matcher<t.NewExpression> {
    private readonly callee?;
    private readonly _arguments?;
    constructor(callee?: Matcher<t.V8IntrinsicIdentifier | t.Expression> | undefined, _arguments?: Matcher<(t.ArgumentPlaceholder | t.JSXNamespacedName | t.SpreadElement | t.Expression)[]> | (Matcher<t.Expression> | Matcher<t.ArgumentPlaceholder> | Matcher<t.SpreadElement> | Matcher<t.JSXNamespacedName>)[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.NewExpression;
}
export declare function newExpression(callee?: Matcher<t.Expression | t.Super | t.V8IntrinsicIdentifier>, _arguments?: Matcher<Array<t.Expression | t.SpreadElement | t.JSXNamespacedName | t.ArgumentPlaceholder>> | Array<Matcher<t.Expression> | Matcher<t.SpreadElement> | Matcher<t.JSXNamespacedName> | Matcher<t.ArgumentPlaceholder>>): Matcher<t.NewExpression>;
export declare class NoopMatcher extends Matcher<t.Noop> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.Noop;
}
export declare function noop(): Matcher<t.Noop>;
export declare class NullLiteralMatcher extends Matcher<t.NullLiteral> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.NullLiteral;
}
export declare function nullLiteral(): Matcher<t.NullLiteral>;
export declare class NullLiteralTypeAnnotationMatcher extends Matcher<t.NullLiteralTypeAnnotation> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.NullLiteralTypeAnnotation;
}
export declare function nullLiteralTypeAnnotation(): Matcher<t.NullLiteralTypeAnnotation>;
export declare class NullableTypeAnnotationMatcher extends Matcher<t.NullableTypeAnnotation> {
    private readonly typeAnnotation?;
    constructor(typeAnnotation?: Matcher<t.FlowType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.NullableTypeAnnotation;
}
export declare function nullableTypeAnnotation(typeAnnotation?: Matcher<t.FlowType>): Matcher<t.NullableTypeAnnotation>;
export declare class NumberLiteralTypeAnnotationMatcher extends Matcher<t.NumberLiteralTypeAnnotation> {
    private readonly value?;
    constructor(value?: number | Matcher<number> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.NumberLiteralTypeAnnotation;
}
export declare function numberLiteralTypeAnnotation(value?: Matcher<number> | number): Matcher<t.NumberLiteralTypeAnnotation>;
export declare class NumberTypeAnnotationMatcher extends Matcher<t.NumberTypeAnnotation> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.NumberTypeAnnotation;
}
export declare function numberTypeAnnotation(): Matcher<t.NumberTypeAnnotation>;
export declare class NumericLiteralMatcher extends Matcher<t.NumericLiteral> {
    private readonly value?;
    constructor(value?: number | Matcher<number> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.NumericLiteral;
}
export declare function numericLiteral(value?: Matcher<number> | number): Matcher<t.NumericLiteral>;
export declare class ObjectExpressionMatcher extends Matcher<t.ObjectExpression> {
    private readonly properties?;
    constructor(properties?: Matcher<(t.ObjectMethod | t.ObjectProperty | t.SpreadElement)[]> | (Matcher<t.SpreadElement> | Matcher<t.ObjectMethod> | Matcher<t.ObjectProperty>)[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ObjectExpression;
}
export declare function objectExpression(properties?: Matcher<Array<t.ObjectMethod | t.ObjectProperty | t.SpreadElement>> | Array<Matcher<t.ObjectMethod> | Matcher<t.ObjectProperty> | Matcher<t.SpreadElement>>): Matcher<t.ObjectExpression>;
export declare class ObjectMethodMatcher extends Matcher<t.ObjectMethod> {
    private readonly kind?;
    private readonly key?;
    private readonly params?;
    private readonly body?;
    private readonly computed?;
    private readonly generator?;
    private readonly async?;
    constructor(kind?: string | Matcher<"method" | "get" | "set"> | undefined, key?: Matcher<t.Expression> | undefined, params?: Matcher<(t.Identifier | t.RestElement | t.Pattern)[]> | (Matcher<t.Identifier> | Matcher<t.Pattern> | Matcher<t.RestElement>)[] | undefined, body?: Matcher<t.BlockStatement> | undefined, computed?: boolean | Matcher<boolean> | undefined, generator?: boolean | Matcher<boolean> | undefined, async?: boolean | Matcher<boolean> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ObjectMethod;
}
export declare function objectMethod(kind?: Matcher<'method' | 'get' | 'set'> | string, key?: Matcher<t.Expression | t.Identifier | t.StringLiteral | t.NumericLiteral | t.BigIntLiteral>, params?: Matcher<Array<t.Identifier | t.Pattern | t.RestElement>> | Array<Matcher<t.Identifier> | Matcher<t.Pattern> | Matcher<t.RestElement>>, body?: Matcher<t.BlockStatement>, computed?: Matcher<boolean> | boolean, generator?: Matcher<boolean> | boolean, async?: Matcher<boolean> | boolean): Matcher<t.ObjectMethod>;
export declare class ObjectPatternMatcher extends Matcher<t.ObjectPattern> {
    private readonly properties?;
    constructor(properties?: Matcher<(t.ObjectProperty | t.RestElement)[]> | (Matcher<t.RestElement> | Matcher<t.ObjectProperty>)[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ObjectPattern;
}
export declare function objectPattern(properties?: Matcher<Array<t.RestElement | t.ObjectProperty>> | Array<Matcher<t.RestElement> | Matcher<t.ObjectProperty>>): Matcher<t.ObjectPattern>;
export declare class ObjectPropertyMatcher extends Matcher<t.ObjectProperty> {
    private readonly key?;
    private readonly value?;
    private readonly computed?;
    private readonly shorthand?;
    private readonly decorators?;
    constructor(key?: Matcher<t.PrivateName | t.Expression> | undefined, value?: Matcher<t.ArrayExpression | t.ArrayPattern | t.ArrowFunctionExpression | t.AssignmentExpression | t.AssignmentPattern | t.AwaitExpression | t.BigIntLiteral | t.BinaryExpression | t.BindExpression | t.BooleanLiteral | t.CallExpression | t.ClassExpression | t.ConditionalExpression | t.DecimalLiteral | t.DoExpression | t.FunctionExpression | t.Identifier | t.Import | t.JSXElement | t.JSXFragment | t.LogicalExpression | t.MemberExpression | t.MetaProperty | t.ModuleExpression | t.NewExpression | t.NullLiteral | t.NumericLiteral | t.ObjectExpression | t.ObjectPattern | t.OptionalCallExpression | t.OptionalMemberExpression | t.ParenthesizedExpression | t.PipelineBareFunction | t.PipelinePrimaryTopicReference | t.PipelineTopicExpression | t.RecordExpression | t.RegExpLiteral | t.RestElement | t.SequenceExpression | t.StringLiteral | t.Super | t.TSAsExpression | t.TSInstantiationExpression | t.TSNonNullExpression | t.TSSatisfiesExpression | t.TSTypeAssertion | t.TaggedTemplateExpression | t.TemplateLiteral | t.ThisExpression | t.TopicReference | t.TupleExpression | t.TypeCastExpression | t.UnaryExpression | t.UpdateExpression | t.YieldExpression> | undefined, computed?: boolean | Matcher<boolean> | undefined, shorthand?: boolean | Matcher<boolean> | undefined, decorators?: Matcher<t.Decorator[]> | Matcher<t.Decorator>[] | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ObjectProperty;
}
export declare function objectProperty(key?: Matcher<t.Expression | t.Identifier | t.StringLiteral | t.NumericLiteral | t.BigIntLiteral | t.DecimalLiteral | t.PrivateName>, value?: Matcher<t.Expression | t.PatternLike>, computed?: Matcher<boolean> | boolean, shorthand?: Matcher<boolean> | boolean, decorators?: Matcher<Array<t.Decorator>> | Array<Matcher<t.Decorator>> | null): Matcher<t.ObjectProperty>;
export declare class ObjectTypeAnnotationMatcher extends Matcher<t.ObjectTypeAnnotation> {
    private readonly properties?;
    private readonly indexers?;
    private readonly callProperties?;
    private readonly internalSlots?;
    private readonly exact?;
    constructor(properties?: Matcher<(t.ObjectTypeProperty | t.ObjectTypeSpreadProperty)[]> | (Matcher<t.ObjectTypeProperty> | Matcher<t.ObjectTypeSpreadProperty>)[] | undefined, indexers?: Matcher<t.ObjectTypeIndexer[]> | Matcher<t.ObjectTypeIndexer>[] | null | undefined, callProperties?: Matcher<t.ObjectTypeCallProperty[]> | Matcher<t.ObjectTypeCallProperty>[] | null | undefined, internalSlots?: Matcher<t.ObjectTypeInternalSlot[]> | Matcher<t.ObjectTypeInternalSlot>[] | null | undefined, exact?: boolean | Matcher<boolean> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ObjectTypeAnnotation;
}
export declare function objectTypeAnnotation(properties?: Matcher<Array<t.ObjectTypeProperty | t.ObjectTypeSpreadProperty>> | Array<Matcher<t.ObjectTypeProperty> | Matcher<t.ObjectTypeSpreadProperty>>, indexers?: Matcher<Array<t.ObjectTypeIndexer>> | Array<Matcher<t.ObjectTypeIndexer>> | null, callProperties?: Matcher<Array<t.ObjectTypeCallProperty>> | Array<Matcher<t.ObjectTypeCallProperty>> | null, internalSlots?: Matcher<Array<t.ObjectTypeInternalSlot>> | Array<Matcher<t.ObjectTypeInternalSlot>> | null, exact?: Matcher<boolean> | boolean): Matcher<t.ObjectTypeAnnotation>;
export declare class ObjectTypeCallPropertyMatcher extends Matcher<t.ObjectTypeCallProperty> {
    private readonly value?;
    constructor(value?: Matcher<t.FlowType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ObjectTypeCallProperty;
}
export declare function objectTypeCallProperty(value?: Matcher<t.FlowType>): Matcher<t.ObjectTypeCallProperty>;
export declare class ObjectTypeIndexerMatcher extends Matcher<t.ObjectTypeIndexer> {
    private readonly id?;
    private readonly key?;
    private readonly value?;
    private readonly variance?;
    constructor(id?: Matcher<t.Identifier> | null | undefined, key?: Matcher<t.FlowType> | undefined, value?: Matcher<t.FlowType> | undefined, variance?: Matcher<t.Variance> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ObjectTypeIndexer;
}
export declare function objectTypeIndexer(id?: Matcher<t.Identifier> | null, key?: Matcher<t.FlowType>, value?: Matcher<t.FlowType>, variance?: Matcher<t.Variance> | null): Matcher<t.ObjectTypeIndexer>;
export declare class ObjectTypeInternalSlotMatcher extends Matcher<t.ObjectTypeInternalSlot> {
    private readonly id?;
    private readonly value?;
    private readonly optional?;
    private readonly _static?;
    private readonly method?;
    constructor(id?: Matcher<t.Identifier> | undefined, value?: Matcher<t.FlowType> | undefined, optional?: boolean | Matcher<boolean> | undefined, _static?: boolean | Matcher<boolean> | undefined, method?: boolean | Matcher<boolean> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ObjectTypeInternalSlot;
}
export declare function objectTypeInternalSlot(id?: Matcher<t.Identifier>, value?: Matcher<t.FlowType>, optional?: Matcher<boolean> | boolean, _static?: Matcher<boolean> | boolean, method?: Matcher<boolean> | boolean): Matcher<t.ObjectTypeInternalSlot>;
export declare class ObjectTypePropertyMatcher extends Matcher<t.ObjectTypeProperty> {
    private readonly key?;
    private readonly value?;
    private readonly variance?;
    constructor(key?: Matcher<t.Identifier | t.StringLiteral> | undefined, value?: Matcher<t.FlowType> | undefined, variance?: Matcher<t.Variance> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ObjectTypeProperty;
}
export declare function objectTypeProperty(key?: Matcher<t.Identifier | t.StringLiteral>, value?: Matcher<t.FlowType>, variance?: Matcher<t.Variance> | null): Matcher<t.ObjectTypeProperty>;
export declare class ObjectTypeSpreadPropertyMatcher extends Matcher<t.ObjectTypeSpreadProperty> {
    private readonly argument?;
    constructor(argument?: Matcher<t.FlowType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ObjectTypeSpreadProperty;
}
export declare function objectTypeSpreadProperty(argument?: Matcher<t.FlowType>): Matcher<t.ObjectTypeSpreadProperty>;
export declare class OpaqueTypeMatcher extends Matcher<t.OpaqueType> {
    private readonly id?;
    private readonly typeParameters?;
    private readonly supertype?;
    private readonly impltype?;
    constructor(id?: Matcher<t.Identifier> | undefined, typeParameters?: Matcher<t.TypeParameterDeclaration> | null | undefined, supertype?: Matcher<t.FlowType> | null | undefined, impltype?: Matcher<t.FlowType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.OpaqueType;
}
export declare function opaqueType(id?: Matcher<t.Identifier>, typeParameters?: Matcher<t.TypeParameterDeclaration> | null, supertype?: Matcher<t.FlowType> | null, impltype?: Matcher<t.FlowType>): Matcher<t.OpaqueType>;
export declare class OptionalCallExpressionMatcher extends Matcher<t.OptionalCallExpression> {
    private readonly callee?;
    private readonly _arguments?;
    private readonly optional?;
    constructor(callee?: Matcher<t.Expression> | undefined, _arguments?: Matcher<(t.ArgumentPlaceholder | t.JSXNamespacedName | t.SpreadElement | t.Expression)[]> | (Matcher<t.Expression> | Matcher<t.ArgumentPlaceholder> | Matcher<t.SpreadElement> | Matcher<t.JSXNamespacedName>)[] | undefined, optional?: boolean | Matcher<boolean> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.OptionalCallExpression;
}
export declare function optionalCallExpression(callee?: Matcher<t.Expression>, _arguments?: Matcher<Array<t.Expression | t.SpreadElement | t.JSXNamespacedName | t.ArgumentPlaceholder>> | Array<Matcher<t.Expression> | Matcher<t.SpreadElement> | Matcher<t.JSXNamespacedName> | Matcher<t.ArgumentPlaceholder>>, optional?: Matcher<boolean> | boolean): Matcher<t.OptionalCallExpression>;
export declare class OptionalIndexedAccessTypeMatcher extends Matcher<t.OptionalIndexedAccessType> {
    private readonly objectType?;
    private readonly indexType?;
    constructor(objectType?: Matcher<t.FlowType> | undefined, indexType?: Matcher<t.FlowType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.OptionalIndexedAccessType;
}
export declare function optionalIndexedAccessType(objectType?: Matcher<t.FlowType>, indexType?: Matcher<t.FlowType>): Matcher<t.OptionalIndexedAccessType>;
export declare class OptionalMemberExpressionMatcher extends Matcher<t.OptionalMemberExpression> {
    private readonly object?;
    private readonly property?;
    private readonly computed?;
    private readonly optional?;
    constructor(object?: Matcher<t.Expression> | undefined, property?: Matcher<t.Expression> | undefined, computed?: boolean | Matcher<boolean> | undefined, optional?: boolean | Matcher<boolean> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.OptionalMemberExpression;
}
export declare function optionalMemberExpression(object?: Matcher<t.Expression>, property?: Matcher<t.Expression | t.Identifier>, computed?: Matcher<boolean> | boolean, optional?: Matcher<boolean> | boolean): Matcher<t.OptionalMemberExpression>;
export declare class ParenthesizedExpressionMatcher extends Matcher<t.ParenthesizedExpression> {
    private readonly expression?;
    constructor(expression?: Matcher<t.Expression> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ParenthesizedExpression;
}
export declare function parenthesizedExpression(expression?: Matcher<t.Expression>): Matcher<t.ParenthesizedExpression>;
export declare class PipelineBareFunctionMatcher extends Matcher<t.PipelineBareFunction> {
    private readonly callee?;
    constructor(callee?: Matcher<t.Expression> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.PipelineBareFunction;
}
export declare function pipelineBareFunction(callee?: Matcher<t.Expression>): Matcher<t.PipelineBareFunction>;
export declare class PipelinePrimaryTopicReferenceMatcher extends Matcher<t.PipelinePrimaryTopicReference> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.PipelinePrimaryTopicReference;
}
export declare function pipelinePrimaryTopicReference(): Matcher<t.PipelinePrimaryTopicReference>;
export declare class PipelineTopicExpressionMatcher extends Matcher<t.PipelineTopicExpression> {
    private readonly expression?;
    constructor(expression?: Matcher<t.Expression> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.PipelineTopicExpression;
}
export declare function pipelineTopicExpression(expression?: Matcher<t.Expression>): Matcher<t.PipelineTopicExpression>;
export declare class PlaceholderMatcher extends Matcher<t.Placeholder> {
    private readonly expectedNode?;
    private readonly name?;
    constructor(expectedNode?: string | Matcher<"BlockStatement" | "ClassBody" | "Identifier" | "StringLiteral" | "Expression" | "Statement" | "Declaration" | "Pattern"> | undefined, name?: Matcher<t.Identifier> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.Placeholder;
}
export declare function placeholder(expectedNode?: Matcher<'Identifier' | 'StringLiteral' | 'Expression' | 'Statement' | 'Declaration' | 'BlockStatement' | 'ClassBody' | 'Pattern'> | string, name?: Matcher<t.Identifier>): Matcher<t.Placeholder>;
export declare class PrivateNameMatcher extends Matcher<t.PrivateName> {
    private readonly id?;
    constructor(id?: Matcher<t.Identifier> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.PrivateName;
}
export declare function privateName(id?: Matcher<t.Identifier>): Matcher<t.PrivateName>;
export declare class ProgramMatcher extends Matcher<t.Program> {
    private readonly body?;
    private readonly directives?;
    private readonly sourceType?;
    private readonly interpreter?;
    constructor(body?: Matcher<t.Statement[]> | Matcher<t.Statement>[] | undefined, directives?: Matcher<t.Directive[]> | Matcher<t.Directive>[] | undefined, sourceType?: string | Matcher<"script" | "module"> | undefined, interpreter?: Matcher<t.InterpreterDirective> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.Program;
}
export declare function program(body?: Matcher<Array<t.Statement>> | Array<Matcher<t.Statement>>, directives?: Matcher<Array<t.Directive>> | Array<Matcher<t.Directive>>, sourceType?: Matcher<'script' | 'module'> | string, interpreter?: Matcher<t.InterpreterDirective> | null): Matcher<t.Program>;
export declare class QualifiedTypeIdentifierMatcher extends Matcher<t.QualifiedTypeIdentifier> {
    private readonly id?;
    private readonly qualification?;
    constructor(id?: Matcher<t.Identifier> | undefined, qualification?: Matcher<t.Identifier | t.QualifiedTypeIdentifier> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.QualifiedTypeIdentifier;
}
export declare function qualifiedTypeIdentifier(id?: Matcher<t.Identifier>, qualification?: Matcher<t.Identifier | t.QualifiedTypeIdentifier>): Matcher<t.QualifiedTypeIdentifier>;
export declare class RecordExpressionMatcher extends Matcher<t.RecordExpression> {
    private readonly properties?;
    constructor(properties?: Matcher<(t.ObjectProperty | t.SpreadElement)[]> | (Matcher<t.SpreadElement> | Matcher<t.ObjectProperty>)[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.RecordExpression;
}
export declare function recordExpression(properties?: Matcher<Array<t.ObjectProperty | t.SpreadElement>> | Array<Matcher<t.ObjectProperty> | Matcher<t.SpreadElement>>): Matcher<t.RecordExpression>;
export declare class RegExpLiteralMatcher extends Matcher<t.RegExpLiteral> {
    private readonly pattern?;
    private readonly flags?;
    constructor(pattern?: string | Matcher<string> | undefined, flags?: string | Matcher<string> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.RegExpLiteral;
}
export declare function regExpLiteral(pattern?: Matcher<string> | string, flags?: Matcher<string> | string): Matcher<t.RegExpLiteral>;
export declare class RestElementMatcher extends Matcher<t.RestElement> {
    private readonly argument?;
    constructor(argument?: Matcher<t.LVal> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.RestElement;
}
export declare function restElement(argument?: Matcher<t.LVal>): Matcher<t.RestElement>;
export declare class ReturnStatementMatcher extends Matcher<t.ReturnStatement> {
    private readonly argument?;
    constructor(argument?: Matcher<t.Expression> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ReturnStatement;
}
export declare function returnStatement(argument?: Matcher<t.Expression> | null): Matcher<t.ReturnStatement>;
export declare class SequenceExpressionMatcher extends Matcher<t.SequenceExpression> {
    private readonly expressions?;
    constructor(expressions?: Matcher<t.Expression[]> | Matcher<t.Expression>[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.SequenceExpression;
}
export declare function sequenceExpression(expressions?: Matcher<Array<t.Expression>> | Array<Matcher<t.Expression>>): Matcher<t.SequenceExpression>;
export declare class SpreadElementMatcher extends Matcher<t.SpreadElement> {
    private readonly argument?;
    constructor(argument?: Matcher<t.Expression> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.SpreadElement;
}
export declare function spreadElement(argument?: Matcher<t.Expression>): Matcher<t.SpreadElement>;
export declare class StaticBlockMatcher extends Matcher<t.StaticBlock> {
    private readonly body?;
    constructor(body?: Matcher<t.Statement[]> | Matcher<t.Statement>[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.StaticBlock;
}
export declare function staticBlock(body?: Matcher<Array<t.Statement>> | Array<Matcher<t.Statement>>): Matcher<t.StaticBlock>;
export declare class StringLiteralMatcher extends Matcher<t.StringLiteral> {
    private readonly value?;
    constructor(value?: string | Matcher<string> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.StringLiteral;
}
export declare function stringLiteral(value?: Matcher<string> | string): Matcher<t.StringLiteral>;
export declare class StringLiteralTypeAnnotationMatcher extends Matcher<t.StringLiteralTypeAnnotation> {
    private readonly value?;
    constructor(value?: string | Matcher<string> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.StringLiteralTypeAnnotation;
}
export declare function stringLiteralTypeAnnotation(value?: Matcher<string> | string): Matcher<t.StringLiteralTypeAnnotation>;
export declare class StringTypeAnnotationMatcher extends Matcher<t.StringTypeAnnotation> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.StringTypeAnnotation;
}
export declare function stringTypeAnnotation(): Matcher<t.StringTypeAnnotation>;
export declare class SuperMatcher extends Matcher<t.Super> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.Super;
}
export declare function Super(): Matcher<t.Super>;
export declare class SwitchCaseMatcher extends Matcher<t.SwitchCase> {
    private readonly test?;
    private readonly consequent?;
    constructor(test?: Matcher<t.Expression> | null | undefined, consequent?: Matcher<t.Statement[]> | Matcher<t.Statement>[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.SwitchCase;
}
export declare function switchCase(test?: Matcher<t.Expression> | null, consequent?: Matcher<Array<t.Statement>> | Array<Matcher<t.Statement>>): Matcher<t.SwitchCase>;
export declare class SwitchStatementMatcher extends Matcher<t.SwitchStatement> {
    private readonly discriminant?;
    private readonly cases?;
    constructor(discriminant?: Matcher<t.Expression> | undefined, cases?: Matcher<t.SwitchCase[]> | Matcher<t.SwitchCase>[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.SwitchStatement;
}
export declare function switchStatement(discriminant?: Matcher<t.Expression>, cases?: Matcher<Array<t.SwitchCase>> | Array<Matcher<t.SwitchCase>>): Matcher<t.SwitchStatement>;
export declare class SymbolTypeAnnotationMatcher extends Matcher<t.SymbolTypeAnnotation> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.SymbolTypeAnnotation;
}
export declare function symbolTypeAnnotation(): Matcher<t.SymbolTypeAnnotation>;
export declare class TSAnyKeywordMatcher extends Matcher<t.TSAnyKeyword> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSAnyKeyword;
}
export declare function tsAnyKeyword(): Matcher<t.TSAnyKeyword>;
export declare class TSArrayTypeMatcher extends Matcher<t.TSArrayType> {
    private readonly elementType?;
    constructor(elementType?: Matcher<t.TSType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSArrayType;
}
export declare function tsArrayType(elementType?: Matcher<t.TSType>): Matcher<t.TSArrayType>;
export declare class TSAsExpressionMatcher extends Matcher<t.TSAsExpression> {
    private readonly expression?;
    private readonly typeAnnotation?;
    constructor(expression?: Matcher<t.Expression> | undefined, typeAnnotation?: Matcher<t.TSType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSAsExpression;
}
export declare function tsAsExpression(expression?: Matcher<t.Expression>, typeAnnotation?: Matcher<t.TSType>): Matcher<t.TSAsExpression>;
export declare class TSBigIntKeywordMatcher extends Matcher<t.TSBigIntKeyword> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSBigIntKeyword;
}
export declare function tsBigIntKeyword(): Matcher<t.TSBigIntKeyword>;
export declare class TSBooleanKeywordMatcher extends Matcher<t.TSBooleanKeyword> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSBooleanKeyword;
}
export declare function tsBooleanKeyword(): Matcher<t.TSBooleanKeyword>;
export declare class TSCallSignatureDeclarationMatcher extends Matcher<t.TSCallSignatureDeclaration> {
    private readonly typeParameters?;
    private readonly parameters?;
    private readonly typeAnnotation?;
    constructor(typeParameters?: Matcher<t.TSTypeParameterDeclaration> | null | undefined, parameters?: Matcher<(t.Identifier | t.RestElement)[]> | (Matcher<t.Identifier> | Matcher<t.RestElement>)[] | undefined, typeAnnotation?: Matcher<t.TSTypeAnnotation> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSCallSignatureDeclaration;
}
export declare function tsCallSignatureDeclaration(typeParameters?: Matcher<t.TSTypeParameterDeclaration> | null, parameters?: Matcher<Array<t.Identifier | t.RestElement>> | Array<Matcher<t.Identifier> | Matcher<t.RestElement>>, typeAnnotation?: Matcher<t.TSTypeAnnotation> | null): Matcher<t.TSCallSignatureDeclaration>;
export declare class TSConditionalTypeMatcher extends Matcher<t.TSConditionalType> {
    private readonly checkType?;
    private readonly extendsType?;
    private readonly trueType?;
    private readonly falseType?;
    constructor(checkType?: Matcher<t.TSType> | undefined, extendsType?: Matcher<t.TSType> | undefined, trueType?: Matcher<t.TSType> | undefined, falseType?: Matcher<t.TSType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSConditionalType;
}
export declare function tsConditionalType(checkType?: Matcher<t.TSType>, extendsType?: Matcher<t.TSType>, trueType?: Matcher<t.TSType>, falseType?: Matcher<t.TSType>): Matcher<t.TSConditionalType>;
export declare class TSConstructSignatureDeclarationMatcher extends Matcher<t.TSConstructSignatureDeclaration> {
    private readonly typeParameters?;
    private readonly parameters?;
    private readonly typeAnnotation?;
    constructor(typeParameters?: Matcher<t.TSTypeParameterDeclaration> | null | undefined, parameters?: Matcher<(t.Identifier | t.RestElement)[]> | (Matcher<t.Identifier> | Matcher<t.RestElement>)[] | undefined, typeAnnotation?: Matcher<t.TSTypeAnnotation> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSConstructSignatureDeclaration;
}
export declare function tsConstructSignatureDeclaration(typeParameters?: Matcher<t.TSTypeParameterDeclaration> | null, parameters?: Matcher<Array<t.Identifier | t.RestElement>> | Array<Matcher<t.Identifier> | Matcher<t.RestElement>>, typeAnnotation?: Matcher<t.TSTypeAnnotation> | null): Matcher<t.TSConstructSignatureDeclaration>;
export declare class TSConstructorTypeMatcher extends Matcher<t.TSConstructorType> {
    private readonly typeParameters?;
    private readonly parameters?;
    private readonly typeAnnotation?;
    constructor(typeParameters?: Matcher<t.TSTypeParameterDeclaration> | null | undefined, parameters?: Matcher<(t.Identifier | t.RestElement)[]> | (Matcher<t.Identifier> | Matcher<t.RestElement>)[] | undefined, typeAnnotation?: Matcher<t.TSTypeAnnotation> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSConstructorType;
}
export declare function tsConstructorType(typeParameters?: Matcher<t.TSTypeParameterDeclaration> | null, parameters?: Matcher<Array<t.Identifier | t.RestElement>> | Array<Matcher<t.Identifier> | Matcher<t.RestElement>>, typeAnnotation?: Matcher<t.TSTypeAnnotation> | null): Matcher<t.TSConstructorType>;
export declare class TSDeclareFunctionMatcher extends Matcher<t.TSDeclareFunction> {
    private readonly id?;
    private readonly typeParameters?;
    private readonly params?;
    private readonly returnType?;
    constructor(id?: Matcher<t.Identifier> | null | undefined, typeParameters?: Matcher<t.Noop | t.TSTypeParameterDeclaration> | null | undefined, params?: Matcher<(t.Identifier | t.RestElement | t.Pattern)[]> | (Matcher<t.Identifier> | Matcher<t.Pattern> | Matcher<t.RestElement>)[] | undefined, returnType?: Matcher<t.Noop | t.TSTypeAnnotation> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSDeclareFunction;
}
export declare function tsDeclareFunction(id?: Matcher<t.Identifier> | null, typeParameters?: Matcher<t.TSTypeParameterDeclaration | t.Noop> | null, params?: Matcher<Array<t.Identifier | t.Pattern | t.RestElement>> | Array<Matcher<t.Identifier> | Matcher<t.Pattern> | Matcher<t.RestElement>>, returnType?: Matcher<t.TSTypeAnnotation | t.Noop> | null): Matcher<t.TSDeclareFunction>;
export declare class TSDeclareMethodMatcher extends Matcher<t.TSDeclareMethod> {
    private readonly decorators?;
    private readonly key?;
    private readonly typeParameters?;
    private readonly params?;
    private readonly returnType?;
    constructor(decorators?: Matcher<t.Decorator[]> | Matcher<t.Decorator>[] | null | undefined, key?: Matcher<t.Expression> | undefined, typeParameters?: Matcher<t.Noop | t.TSTypeParameterDeclaration> | null | undefined, params?: Matcher<(t.Identifier | t.RestElement | t.TSParameterProperty | t.Pattern)[]> | (Matcher<t.Identifier> | Matcher<t.Pattern> | Matcher<t.RestElement> | Matcher<t.TSParameterProperty>)[] | undefined, returnType?: Matcher<t.Noop | t.TSTypeAnnotation> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSDeclareMethod;
}
export declare function tsDeclareMethod(decorators?: Matcher<Array<t.Decorator>> | Array<Matcher<t.Decorator>> | null, key?: Matcher<t.Identifier | t.StringLiteral | t.NumericLiteral | t.BigIntLiteral | t.Expression>, typeParameters?: Matcher<t.TSTypeParameterDeclaration | t.Noop> | null, params?: Matcher<Array<t.Identifier | t.Pattern | t.RestElement | t.TSParameterProperty>> | Array<Matcher<t.Identifier> | Matcher<t.Pattern> | Matcher<t.RestElement> | Matcher<t.TSParameterProperty>>, returnType?: Matcher<t.TSTypeAnnotation | t.Noop> | null): Matcher<t.TSDeclareMethod>;
export declare class TSEnumDeclarationMatcher extends Matcher<t.TSEnumDeclaration> {
    private readonly id?;
    private readonly members?;
    constructor(id?: Matcher<t.Identifier> | undefined, members?: Matcher<t.TSEnumMember[]> | Matcher<t.TSEnumMember>[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSEnumDeclaration;
}
export declare function tsEnumDeclaration(id?: Matcher<t.Identifier>, members?: Matcher<Array<t.TSEnumMember>> | Array<Matcher<t.TSEnumMember>>): Matcher<t.TSEnumDeclaration>;
export declare class TSEnumMemberMatcher extends Matcher<t.TSEnumMember> {
    private readonly id?;
    private readonly initializer?;
    constructor(id?: Matcher<t.Identifier | t.StringLiteral> | undefined, initializer?: Matcher<t.Expression> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSEnumMember;
}
export declare function tsEnumMember(id?: Matcher<t.Identifier | t.StringLiteral>, initializer?: Matcher<t.Expression> | null): Matcher<t.TSEnumMember>;
export declare class TSExportAssignmentMatcher extends Matcher<t.TSExportAssignment> {
    private readonly expression?;
    constructor(expression?: Matcher<t.Expression> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSExportAssignment;
}
export declare function tsExportAssignment(expression?: Matcher<t.Expression>): Matcher<t.TSExportAssignment>;
export declare class TSExpressionWithTypeArgumentsMatcher extends Matcher<t.TSExpressionWithTypeArguments> {
    private readonly expression?;
    private readonly typeParameters?;
    constructor(expression?: Matcher<t.TSEntityName> | undefined, typeParameters?: Matcher<t.TSTypeParameterInstantiation> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSExpressionWithTypeArguments;
}
export declare function tsExpressionWithTypeArguments(expression?: Matcher<t.TSEntityName>, typeParameters?: Matcher<t.TSTypeParameterInstantiation> | null): Matcher<t.TSExpressionWithTypeArguments>;
export declare class TSExternalModuleReferenceMatcher extends Matcher<t.TSExternalModuleReference> {
    private readonly expression?;
    constructor(expression?: Matcher<t.StringLiteral> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSExternalModuleReference;
}
export declare function tsExternalModuleReference(expression?: Matcher<t.StringLiteral>): Matcher<t.TSExternalModuleReference>;
export declare class TSFunctionTypeMatcher extends Matcher<t.TSFunctionType> {
    private readonly typeParameters?;
    private readonly parameters?;
    private readonly typeAnnotation?;
    constructor(typeParameters?: Matcher<t.TSTypeParameterDeclaration> | null | undefined, parameters?: Matcher<(t.Identifier | t.RestElement)[]> | (Matcher<t.Identifier> | Matcher<t.RestElement>)[] | undefined, typeAnnotation?: Matcher<t.TSTypeAnnotation> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSFunctionType;
}
export declare function tsFunctionType(typeParameters?: Matcher<t.TSTypeParameterDeclaration> | null, parameters?: Matcher<Array<t.Identifier | t.RestElement>> | Array<Matcher<t.Identifier> | Matcher<t.RestElement>>, typeAnnotation?: Matcher<t.TSTypeAnnotation> | null): Matcher<t.TSFunctionType>;
export declare class TSImportEqualsDeclarationMatcher extends Matcher<t.TSImportEqualsDeclaration> {
    private readonly id?;
    private readonly moduleReference?;
    constructor(id?: Matcher<t.Identifier> | undefined, moduleReference?: Matcher<t.TSExternalModuleReference | t.TSEntityName> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSImportEqualsDeclaration;
}
export declare function tsImportEqualsDeclaration(id?: Matcher<t.Identifier>, moduleReference?: Matcher<t.TSEntityName | t.TSExternalModuleReference>): Matcher<t.TSImportEqualsDeclaration>;
export declare class TSImportTypeMatcher extends Matcher<t.TSImportType> {
    private readonly argument?;
    private readonly qualifier?;
    private readonly typeParameters?;
    constructor(argument?: Matcher<t.StringLiteral> | undefined, qualifier?: Matcher<t.TSEntityName> | null | undefined, typeParameters?: Matcher<t.TSTypeParameterInstantiation> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSImportType;
}
export declare function tsImportType(argument?: Matcher<t.StringLiteral>, qualifier?: Matcher<t.TSEntityName> | null, typeParameters?: Matcher<t.TSTypeParameterInstantiation> | null): Matcher<t.TSImportType>;
export declare class TSIndexSignatureMatcher extends Matcher<t.TSIndexSignature> {
    private readonly parameters?;
    private readonly typeAnnotation?;
    constructor(parameters?: Matcher<t.Identifier[]> | Matcher<t.Identifier>[] | undefined, typeAnnotation?: Matcher<t.TSTypeAnnotation> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSIndexSignature;
}
export declare function tsIndexSignature(parameters?: Matcher<Array<t.Identifier>> | Array<Matcher<t.Identifier>>, typeAnnotation?: Matcher<t.TSTypeAnnotation> | null): Matcher<t.TSIndexSignature>;
export declare class TSIndexedAccessTypeMatcher extends Matcher<t.TSIndexedAccessType> {
    private readonly objectType?;
    private readonly indexType?;
    constructor(objectType?: Matcher<t.TSType> | undefined, indexType?: Matcher<t.TSType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSIndexedAccessType;
}
export declare function tsIndexedAccessType(objectType?: Matcher<t.TSType>, indexType?: Matcher<t.TSType>): Matcher<t.TSIndexedAccessType>;
export declare class TSInferTypeMatcher extends Matcher<t.TSInferType> {
    private readonly typeParameter?;
    constructor(typeParameter?: Matcher<t.TSTypeParameter> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSInferType;
}
export declare function tsInferType(typeParameter?: Matcher<t.TSTypeParameter>): Matcher<t.TSInferType>;
export declare class TSInstantiationExpressionMatcher extends Matcher<t.TSInstantiationExpression> {
    private readonly expression?;
    private readonly typeParameters?;
    constructor(expression?: Matcher<t.Expression> | undefined, typeParameters?: Matcher<t.TSTypeParameterInstantiation> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSInstantiationExpression;
}
export declare function tsInstantiationExpression(expression?: Matcher<t.Expression>, typeParameters?: Matcher<t.TSTypeParameterInstantiation> | null): Matcher<t.TSInstantiationExpression>;
export declare class TSInterfaceBodyMatcher extends Matcher<t.TSInterfaceBody> {
    private readonly body?;
    constructor(body?: Matcher<t.TSTypeElement[]> | Matcher<t.TSTypeElement>[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSInterfaceBody;
}
export declare function tsInterfaceBody(body?: Matcher<Array<t.TSTypeElement>> | Array<Matcher<t.TSTypeElement>>): Matcher<t.TSInterfaceBody>;
export declare class TSInterfaceDeclarationMatcher extends Matcher<t.TSInterfaceDeclaration> {
    private readonly id?;
    private readonly typeParameters?;
    private readonly _extends?;
    private readonly body?;
    constructor(id?: Matcher<t.Identifier> | undefined, typeParameters?: Matcher<t.TSTypeParameterDeclaration> | null | undefined, _extends?: Matcher<t.TSExpressionWithTypeArguments[]> | Matcher<t.TSExpressionWithTypeArguments>[] | null | undefined, body?: Matcher<t.TSInterfaceBody> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSInterfaceDeclaration;
}
export declare function tsInterfaceDeclaration(id?: Matcher<t.Identifier>, typeParameters?: Matcher<t.TSTypeParameterDeclaration> | null, _extends?: Matcher<Array<t.TSExpressionWithTypeArguments>> | Array<Matcher<t.TSExpressionWithTypeArguments>> | null, body?: Matcher<t.TSInterfaceBody>): Matcher<t.TSInterfaceDeclaration>;
export declare class TSIntersectionTypeMatcher extends Matcher<t.TSIntersectionType> {
    private readonly types?;
    constructor(types?: Matcher<t.TSType[]> | Matcher<t.TSType>[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSIntersectionType;
}
export declare function tsIntersectionType(types?: Matcher<Array<t.TSType>> | Array<Matcher<t.TSType>>): Matcher<t.TSIntersectionType>;
export declare class TSIntrinsicKeywordMatcher extends Matcher<t.TSIntrinsicKeyword> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSIntrinsicKeyword;
}
export declare function tsIntrinsicKeyword(): Matcher<t.TSIntrinsicKeyword>;
export declare class TSLiteralTypeMatcher extends Matcher<t.TSLiteralType> {
    private readonly literal?;
    constructor(literal?: Matcher<t.BigIntLiteral | t.BooleanLiteral | t.NumericLiteral | t.StringLiteral | t.TemplateLiteral | t.UnaryExpression> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSLiteralType;
}
export declare function tsLiteralType(literal?: Matcher<t.NumericLiteral | t.StringLiteral | t.BooleanLiteral | t.BigIntLiteral | t.TemplateLiteral | t.UnaryExpression>): Matcher<t.TSLiteralType>;
export declare class TSMappedTypeMatcher extends Matcher<t.TSMappedType> {
    private readonly typeParameter?;
    private readonly typeAnnotation?;
    private readonly nameType?;
    constructor(typeParameter?: Matcher<t.TSTypeParameter> | undefined, typeAnnotation?: Matcher<t.TSType> | null | undefined, nameType?: Matcher<t.TSType> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSMappedType;
}
export declare function tsMappedType(typeParameter?: Matcher<t.TSTypeParameter>, typeAnnotation?: Matcher<t.TSType> | null, nameType?: Matcher<t.TSType> | null): Matcher<t.TSMappedType>;
export declare class TSMethodSignatureMatcher extends Matcher<t.TSMethodSignature> {
    private readonly key?;
    private readonly typeParameters?;
    private readonly parameters?;
    private readonly typeAnnotation?;
    constructor(key?: Matcher<t.Expression> | undefined, typeParameters?: Matcher<t.TSTypeParameterDeclaration> | null | undefined, parameters?: Matcher<(t.Identifier | t.RestElement)[]> | (Matcher<t.Identifier> | Matcher<t.RestElement>)[] | undefined, typeAnnotation?: Matcher<t.TSTypeAnnotation> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSMethodSignature;
}
export declare function tsMethodSignature(key?: Matcher<t.Expression>, typeParameters?: Matcher<t.TSTypeParameterDeclaration> | null, parameters?: Matcher<Array<t.Identifier | t.RestElement>> | Array<Matcher<t.Identifier> | Matcher<t.RestElement>>, typeAnnotation?: Matcher<t.TSTypeAnnotation> | null): Matcher<t.TSMethodSignature>;
export declare class TSModuleBlockMatcher extends Matcher<t.TSModuleBlock> {
    private readonly body?;
    constructor(body?: Matcher<t.Statement[]> | Matcher<t.Statement>[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSModuleBlock;
}
export declare function tsModuleBlock(body?: Matcher<Array<t.Statement>> | Array<Matcher<t.Statement>>): Matcher<t.TSModuleBlock>;
export declare class TSModuleDeclarationMatcher extends Matcher<t.TSModuleDeclaration> {
    private readonly id?;
    private readonly body?;
    constructor(id?: Matcher<t.Identifier | t.StringLiteral> | undefined, body?: Matcher<t.TSModuleBlock | t.TSModuleDeclaration> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSModuleDeclaration;
}
export declare function tsModuleDeclaration(id?: Matcher<t.Identifier | t.StringLiteral>, body?: Matcher<t.TSModuleBlock | t.TSModuleDeclaration>): Matcher<t.TSModuleDeclaration>;
export declare class TSNamedTupleMemberMatcher extends Matcher<t.TSNamedTupleMember> {
    private readonly label?;
    private readonly elementType?;
    private readonly optional?;
    constructor(label?: Matcher<t.Identifier> | undefined, elementType?: Matcher<t.TSType> | undefined, optional?: boolean | Matcher<boolean> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSNamedTupleMember;
}
export declare function tsNamedTupleMember(label?: Matcher<t.Identifier>, elementType?: Matcher<t.TSType>, optional?: Matcher<boolean> | boolean): Matcher<t.TSNamedTupleMember>;
export declare class TSNamespaceExportDeclarationMatcher extends Matcher<t.TSNamespaceExportDeclaration> {
    private readonly id?;
    constructor(id?: Matcher<t.Identifier> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSNamespaceExportDeclaration;
}
export declare function tsNamespaceExportDeclaration(id?: Matcher<t.Identifier>): Matcher<t.TSNamespaceExportDeclaration>;
export declare class TSNeverKeywordMatcher extends Matcher<t.TSNeverKeyword> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSNeverKeyword;
}
export declare function tsNeverKeyword(): Matcher<t.TSNeverKeyword>;
export declare class TSNonNullExpressionMatcher extends Matcher<t.TSNonNullExpression> {
    private readonly expression?;
    constructor(expression?: Matcher<t.Expression> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSNonNullExpression;
}
export declare function tsNonNullExpression(expression?: Matcher<t.Expression>): Matcher<t.TSNonNullExpression>;
export declare class TSNullKeywordMatcher extends Matcher<t.TSNullKeyword> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSNullKeyword;
}
export declare function tsNullKeyword(): Matcher<t.TSNullKeyword>;
export declare class TSNumberKeywordMatcher extends Matcher<t.TSNumberKeyword> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSNumberKeyword;
}
export declare function tsNumberKeyword(): Matcher<t.TSNumberKeyword>;
export declare class TSObjectKeywordMatcher extends Matcher<t.TSObjectKeyword> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSObjectKeyword;
}
export declare function tsObjectKeyword(): Matcher<t.TSObjectKeyword>;
export declare class TSOptionalTypeMatcher extends Matcher<t.TSOptionalType> {
    private readonly typeAnnotation?;
    constructor(typeAnnotation?: Matcher<t.TSType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSOptionalType;
}
export declare function tsOptionalType(typeAnnotation?: Matcher<t.TSType>): Matcher<t.TSOptionalType>;
export declare class TSParameterPropertyMatcher extends Matcher<t.TSParameterProperty> {
    private readonly parameter?;
    constructor(parameter?: Matcher<t.AssignmentPattern | t.Identifier> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSParameterProperty;
}
export declare function tsParameterProperty(parameter?: Matcher<t.Identifier | t.AssignmentPattern>): Matcher<t.TSParameterProperty>;
export declare class TSParenthesizedTypeMatcher extends Matcher<t.TSParenthesizedType> {
    private readonly typeAnnotation?;
    constructor(typeAnnotation?: Matcher<t.TSType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSParenthesizedType;
}
export declare function tsParenthesizedType(typeAnnotation?: Matcher<t.TSType>): Matcher<t.TSParenthesizedType>;
export declare class TSPropertySignatureMatcher extends Matcher<t.TSPropertySignature> {
    private readonly key?;
    private readonly typeAnnotation?;
    private readonly initializer?;
    constructor(key?: Matcher<t.Expression> | undefined, typeAnnotation?: Matcher<t.TSTypeAnnotation> | null | undefined, initializer?: Matcher<t.Expression> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSPropertySignature;
}
export declare function tsPropertySignature(key?: Matcher<t.Expression>, typeAnnotation?: Matcher<t.TSTypeAnnotation> | null, initializer?: Matcher<t.Expression> | null): Matcher<t.TSPropertySignature>;
export declare class TSQualifiedNameMatcher extends Matcher<t.TSQualifiedName> {
    private readonly left?;
    private readonly right?;
    constructor(left?: Matcher<t.TSEntityName> | undefined, right?: Matcher<t.Identifier> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSQualifiedName;
}
export declare function tsQualifiedName(left?: Matcher<t.TSEntityName>, right?: Matcher<t.Identifier>): Matcher<t.TSQualifiedName>;
export declare class TSRestTypeMatcher extends Matcher<t.TSRestType> {
    private readonly typeAnnotation?;
    constructor(typeAnnotation?: Matcher<t.TSType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSRestType;
}
export declare function tsRestType(typeAnnotation?: Matcher<t.TSType>): Matcher<t.TSRestType>;
export declare class TSSatisfiesExpressionMatcher extends Matcher<t.TSSatisfiesExpression> {
    private readonly expression?;
    private readonly typeAnnotation?;
    constructor(expression?: Matcher<t.Expression> | undefined, typeAnnotation?: Matcher<t.TSType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSSatisfiesExpression;
}
export declare function tsSatisfiesExpression(expression?: Matcher<t.Expression>, typeAnnotation?: Matcher<t.TSType>): Matcher<t.TSSatisfiesExpression>;
export declare class TSStringKeywordMatcher extends Matcher<t.TSStringKeyword> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSStringKeyword;
}
export declare function tsStringKeyword(): Matcher<t.TSStringKeyword>;
export declare class TSSymbolKeywordMatcher extends Matcher<t.TSSymbolKeyword> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSSymbolKeyword;
}
export declare function tsSymbolKeyword(): Matcher<t.TSSymbolKeyword>;
export declare class TSThisTypeMatcher extends Matcher<t.TSThisType> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSThisType;
}
export declare function tsThisType(): Matcher<t.TSThisType>;
export declare class TSTupleTypeMatcher extends Matcher<t.TSTupleType> {
    private readonly elementTypes?;
    constructor(elementTypes?: Matcher<(t.TSNamedTupleMember | t.TSType)[]> | (Matcher<t.TSType> | Matcher<t.TSNamedTupleMember>)[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSTupleType;
}
export declare function tsTupleType(elementTypes?: Matcher<Array<t.TSType | t.TSNamedTupleMember>> | Array<Matcher<t.TSType> | Matcher<t.TSNamedTupleMember>>): Matcher<t.TSTupleType>;
export declare class TSTypeAliasDeclarationMatcher extends Matcher<t.TSTypeAliasDeclaration> {
    private readonly id?;
    private readonly typeParameters?;
    private readonly typeAnnotation?;
    constructor(id?: Matcher<t.Identifier> | undefined, typeParameters?: Matcher<t.TSTypeParameterDeclaration> | null | undefined, typeAnnotation?: Matcher<t.TSType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSTypeAliasDeclaration;
}
export declare function tsTypeAliasDeclaration(id?: Matcher<t.Identifier>, typeParameters?: Matcher<t.TSTypeParameterDeclaration> | null, typeAnnotation?: Matcher<t.TSType>): Matcher<t.TSTypeAliasDeclaration>;
export declare class TSTypeAnnotationMatcher extends Matcher<t.TSTypeAnnotation> {
    private readonly typeAnnotation?;
    constructor(typeAnnotation?: Matcher<t.TSType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSTypeAnnotation;
}
export declare function tsTypeAnnotation(typeAnnotation?: Matcher<t.TSType>): Matcher<t.TSTypeAnnotation>;
export declare class TSTypeAssertionMatcher extends Matcher<t.TSTypeAssertion> {
    private readonly typeAnnotation?;
    private readonly expression?;
    constructor(typeAnnotation?: Matcher<t.TSType> | undefined, expression?: Matcher<t.Expression> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSTypeAssertion;
}
export declare function tsTypeAssertion(typeAnnotation?: Matcher<t.TSType>, expression?: Matcher<t.Expression>): Matcher<t.TSTypeAssertion>;
export declare class TSTypeLiteralMatcher extends Matcher<t.TSTypeLiteral> {
    private readonly members?;
    constructor(members?: Matcher<t.TSTypeElement[]> | Matcher<t.TSTypeElement>[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSTypeLiteral;
}
export declare function tsTypeLiteral(members?: Matcher<Array<t.TSTypeElement>> | Array<Matcher<t.TSTypeElement>>): Matcher<t.TSTypeLiteral>;
export declare class TSTypeOperatorMatcher extends Matcher<t.TSTypeOperator> {
    private readonly typeAnnotation?;
    constructor(typeAnnotation?: Matcher<t.TSType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSTypeOperator;
}
export declare function tsTypeOperator(typeAnnotation?: Matcher<t.TSType>): Matcher<t.TSTypeOperator>;
export declare class TSTypeParameterMatcher extends Matcher<t.TSTypeParameter> {
    private readonly constraint?;
    private readonly _default?;
    private readonly name?;
    constructor(constraint?: Matcher<t.TSType> | null | undefined, _default?: Matcher<t.TSType> | null | undefined, name?: string | Matcher<string> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSTypeParameter;
}
export declare function tsTypeParameter(constraint?: Matcher<t.TSType> | null, _default?: Matcher<t.TSType> | null, name?: Matcher<string> | string): Matcher<t.TSTypeParameter>;
export declare class TSTypeParameterDeclarationMatcher extends Matcher<t.TSTypeParameterDeclaration> {
    private readonly params?;
    constructor(params?: Matcher<t.TSTypeParameter[]> | Matcher<t.TSTypeParameter>[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSTypeParameterDeclaration;
}
export declare function tsTypeParameterDeclaration(params?: Matcher<Array<t.TSTypeParameter>> | Array<Matcher<t.TSTypeParameter>>): Matcher<t.TSTypeParameterDeclaration>;
export declare class TSTypeParameterInstantiationMatcher extends Matcher<t.TSTypeParameterInstantiation> {
    private readonly params?;
    constructor(params?: Matcher<t.TSType[]> | Matcher<t.TSType>[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSTypeParameterInstantiation;
}
export declare function tsTypeParameterInstantiation(params?: Matcher<Array<t.TSType>> | Array<Matcher<t.TSType>>): Matcher<t.TSTypeParameterInstantiation>;
export declare class TSTypePredicateMatcher extends Matcher<t.TSTypePredicate> {
    private readonly parameterName?;
    private readonly typeAnnotation?;
    private readonly asserts?;
    constructor(parameterName?: Matcher<t.Identifier | t.TSThisType> | undefined, typeAnnotation?: Matcher<t.TSTypeAnnotation> | null | undefined, asserts?: boolean | Matcher<boolean> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSTypePredicate;
}
export declare function tsTypePredicate(parameterName?: Matcher<t.Identifier | t.TSThisType>, typeAnnotation?: Matcher<t.TSTypeAnnotation> | null, asserts?: Matcher<boolean> | boolean | null): Matcher<t.TSTypePredicate>;
export declare class TSTypeQueryMatcher extends Matcher<t.TSTypeQuery> {
    private readonly exprName?;
    private readonly typeParameters?;
    constructor(exprName?: Matcher<t.TSImportType | t.TSEntityName> | undefined, typeParameters?: Matcher<t.TSTypeParameterInstantiation> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSTypeQuery;
}
export declare function tsTypeQuery(exprName?: Matcher<t.TSEntityName | t.TSImportType>, typeParameters?: Matcher<t.TSTypeParameterInstantiation> | null): Matcher<t.TSTypeQuery>;
export declare class TSTypeReferenceMatcher extends Matcher<t.TSTypeReference> {
    private readonly typeName?;
    private readonly typeParameters?;
    constructor(typeName?: Matcher<t.TSEntityName> | undefined, typeParameters?: Matcher<t.TSTypeParameterInstantiation> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSTypeReference;
}
export declare function tsTypeReference(typeName?: Matcher<t.TSEntityName>, typeParameters?: Matcher<t.TSTypeParameterInstantiation> | null): Matcher<t.TSTypeReference>;
export declare class TSUndefinedKeywordMatcher extends Matcher<t.TSUndefinedKeyword> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSUndefinedKeyword;
}
export declare function tsUndefinedKeyword(): Matcher<t.TSUndefinedKeyword>;
export declare class TSUnionTypeMatcher extends Matcher<t.TSUnionType> {
    private readonly types?;
    constructor(types?: Matcher<t.TSType[]> | Matcher<t.TSType>[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSUnionType;
}
export declare function tsUnionType(types?: Matcher<Array<t.TSType>> | Array<Matcher<t.TSType>>): Matcher<t.TSUnionType>;
export declare class TSUnknownKeywordMatcher extends Matcher<t.TSUnknownKeyword> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSUnknownKeyword;
}
export declare function tsUnknownKeyword(): Matcher<t.TSUnknownKeyword>;
export declare class TSVoidKeywordMatcher extends Matcher<t.TSVoidKeyword> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TSVoidKeyword;
}
export declare function tsVoidKeyword(): Matcher<t.TSVoidKeyword>;
export declare class TaggedTemplateExpressionMatcher extends Matcher<t.TaggedTemplateExpression> {
    private readonly tag?;
    private readonly quasi?;
    constructor(tag?: Matcher<t.Expression> | undefined, quasi?: Matcher<t.TemplateLiteral> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TaggedTemplateExpression;
}
export declare function taggedTemplateExpression(tag?: Matcher<t.Expression>, quasi?: Matcher<t.TemplateLiteral>): Matcher<t.TaggedTemplateExpression>;
export declare class TemplateElementMatcher extends Matcher<t.TemplateElement> {
    private readonly value?;
    private readonly tail?;
    constructor(value?: Matcher<any> | undefined, tail?: boolean | Matcher<boolean> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TemplateElement;
}
export declare function templateElement(value?: Matcher<any>, tail?: Matcher<boolean> | boolean): Matcher<t.TemplateElement>;
export declare class TemplateLiteralMatcher extends Matcher<t.TemplateLiteral> {
    private readonly quasis?;
    private readonly expressions?;
    constructor(quasis?: Matcher<t.TemplateElement[]> | Matcher<t.TemplateElement>[] | undefined, expressions?: Matcher<(t.Expression | t.TSType)[]> | (Matcher<t.Expression> | Matcher<t.TSType>)[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TemplateLiteral;
}
export declare function templateLiteral(quasis?: Matcher<Array<t.TemplateElement>> | Array<Matcher<t.TemplateElement>>, expressions?: Matcher<Array<t.Expression | t.TSType>> | Array<Matcher<t.Expression> | Matcher<t.TSType>>): Matcher<t.TemplateLiteral>;
export declare class ThisExpressionMatcher extends Matcher<t.ThisExpression> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ThisExpression;
}
export declare function thisExpression(): Matcher<t.ThisExpression>;
export declare class ThisTypeAnnotationMatcher extends Matcher<t.ThisTypeAnnotation> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ThisTypeAnnotation;
}
export declare function thisTypeAnnotation(): Matcher<t.ThisTypeAnnotation>;
export declare class ThrowStatementMatcher extends Matcher<t.ThrowStatement> {
    private readonly argument?;
    constructor(argument?: Matcher<t.Expression> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.ThrowStatement;
}
export declare function throwStatement(argument?: Matcher<t.Expression>): Matcher<t.ThrowStatement>;
export declare class TopicReferenceMatcher extends Matcher<t.TopicReference> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TopicReference;
}
export declare function topicReference(): Matcher<t.TopicReference>;
export declare class TryStatementMatcher extends Matcher<t.TryStatement> {
    private readonly block?;
    private readonly handler?;
    private readonly finalizer?;
    constructor(block?: Matcher<t.BlockStatement> | undefined, handler?: Matcher<t.CatchClause> | null | undefined, finalizer?: Matcher<t.BlockStatement> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TryStatement;
}
export declare function tryStatement(block?: Matcher<t.BlockStatement>, handler?: Matcher<t.CatchClause> | null, finalizer?: Matcher<t.BlockStatement> | null): Matcher<t.TryStatement>;
export declare class TupleExpressionMatcher extends Matcher<t.TupleExpression> {
    private readonly elements?;
    constructor(elements?: Matcher<(t.SpreadElement | t.Expression)[]> | (Matcher<t.Expression> | Matcher<t.SpreadElement>)[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TupleExpression;
}
export declare function tupleExpression(elements?: Matcher<Array<t.Expression | t.SpreadElement>> | Array<Matcher<t.Expression> | Matcher<t.SpreadElement>>): Matcher<t.TupleExpression>;
export declare class TupleTypeAnnotationMatcher extends Matcher<t.TupleTypeAnnotation> {
    private readonly types?;
    constructor(types?: Matcher<t.FlowType[]> | Matcher<t.FlowType>[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TupleTypeAnnotation;
}
export declare function tupleTypeAnnotation(types?: Matcher<Array<t.FlowType>> | Array<Matcher<t.FlowType>>): Matcher<t.TupleTypeAnnotation>;
export declare class TypeAliasMatcher extends Matcher<t.TypeAlias> {
    private readonly id?;
    private readonly typeParameters?;
    private readonly right?;
    constructor(id?: Matcher<t.Identifier> | undefined, typeParameters?: Matcher<t.TypeParameterDeclaration> | null | undefined, right?: Matcher<t.FlowType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TypeAlias;
}
export declare function typeAlias(id?: Matcher<t.Identifier>, typeParameters?: Matcher<t.TypeParameterDeclaration> | null, right?: Matcher<t.FlowType>): Matcher<t.TypeAlias>;
export declare class TypeAnnotationMatcher extends Matcher<t.TypeAnnotation> {
    private readonly typeAnnotation?;
    constructor(typeAnnotation?: Matcher<t.FlowType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TypeAnnotation;
}
export declare function typeAnnotation(typeAnnotation?: Matcher<t.FlowType>): Matcher<t.TypeAnnotation>;
export declare class TypeCastExpressionMatcher extends Matcher<t.TypeCastExpression> {
    private readonly expression?;
    private readonly typeAnnotation?;
    constructor(expression?: Matcher<t.Expression> | undefined, typeAnnotation?: Matcher<t.TypeAnnotation> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TypeCastExpression;
}
export declare function typeCastExpression(expression?: Matcher<t.Expression>, typeAnnotation?: Matcher<t.TypeAnnotation>): Matcher<t.TypeCastExpression>;
export declare class TypeParameterMatcher extends Matcher<t.TypeParameter> {
    private readonly bound?;
    private readonly _default?;
    private readonly variance?;
    constructor(bound?: Matcher<t.TypeAnnotation> | null | undefined, _default?: Matcher<t.FlowType> | null | undefined, variance?: Matcher<t.Variance> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TypeParameter;
}
export declare function typeParameter(bound?: Matcher<t.TypeAnnotation> | null, _default?: Matcher<t.FlowType> | null, variance?: Matcher<t.Variance> | null): Matcher<t.TypeParameter>;
export declare class TypeParameterDeclarationMatcher extends Matcher<t.TypeParameterDeclaration> {
    private readonly params?;
    constructor(params?: Matcher<t.TypeParameter[]> | Matcher<t.TypeParameter>[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TypeParameterDeclaration;
}
export declare function typeParameterDeclaration(params?: Matcher<Array<t.TypeParameter>> | Array<Matcher<t.TypeParameter>>): Matcher<t.TypeParameterDeclaration>;
export declare class TypeParameterInstantiationMatcher extends Matcher<t.TypeParameterInstantiation> {
    private readonly params?;
    constructor(params?: Matcher<t.FlowType[]> | Matcher<t.FlowType>[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TypeParameterInstantiation;
}
export declare function typeParameterInstantiation(params?: Matcher<Array<t.FlowType>> | Array<Matcher<t.FlowType>>): Matcher<t.TypeParameterInstantiation>;
export declare class TypeofTypeAnnotationMatcher extends Matcher<t.TypeofTypeAnnotation> {
    private readonly argument?;
    constructor(argument?: Matcher<t.FlowType> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.TypeofTypeAnnotation;
}
export declare function typeofTypeAnnotation(argument?: Matcher<t.FlowType>): Matcher<t.TypeofTypeAnnotation>;
export declare class UnaryExpressionMatcher extends Matcher<t.UnaryExpression> {
    private readonly operator?;
    private readonly argument?;
    private readonly prefix?;
    constructor(operator?: string | Matcher<"+" | "-" | "void" | "throw" | "delete" | "!" | "~" | "typeof"> | undefined, argument?: Matcher<t.Expression> | undefined, prefix?: boolean | Matcher<boolean> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.UnaryExpression;
}
export declare function unaryExpression(operator?: Matcher<'void' | 'throw' | 'delete' | '!' | '+' | '-' | '~' | 'typeof'> | string, argument?: Matcher<t.Expression>, prefix?: Matcher<boolean> | boolean): Matcher<t.UnaryExpression>;
export declare class UnionTypeAnnotationMatcher extends Matcher<t.UnionTypeAnnotation> {
    private readonly types?;
    constructor(types?: Matcher<t.FlowType[]> | Matcher<t.FlowType>[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.UnionTypeAnnotation;
}
export declare function unionTypeAnnotation(types?: Matcher<Array<t.FlowType>> | Array<Matcher<t.FlowType>>): Matcher<t.UnionTypeAnnotation>;
export declare class UpdateExpressionMatcher extends Matcher<t.UpdateExpression> {
    private readonly operator?;
    private readonly argument?;
    private readonly prefix?;
    constructor(operator?: string | Matcher<"++" | "--"> | undefined, argument?: Matcher<t.Expression> | undefined, prefix?: boolean | Matcher<boolean> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.UpdateExpression;
}
export declare function updateExpression(operator?: Matcher<'++' | '--'> | string, argument?: Matcher<t.Expression>, prefix?: Matcher<boolean> | boolean): Matcher<t.UpdateExpression>;
export declare class V8IntrinsicIdentifierMatcher extends Matcher<t.V8IntrinsicIdentifier> {
    private readonly name?;
    constructor(name?: string | Matcher<string> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.V8IntrinsicIdentifier;
}
export declare function v8IntrinsicIdentifier(name?: Matcher<string> | string): Matcher<t.V8IntrinsicIdentifier>;
export declare class VariableDeclarationMatcher extends Matcher<t.VariableDeclaration> {
    private readonly kind?;
    private readonly declarations?;
    constructor(kind?: string | Matcher<"var" | "let" | "const" | "using"> | undefined, declarations?: Matcher<t.VariableDeclarator[]> | Matcher<t.VariableDeclarator>[] | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.VariableDeclaration;
}
export declare function variableDeclaration(kind?: Matcher<'var' | 'let' | 'const' | 'using'> | string, declarations?: Matcher<Array<t.VariableDeclarator>> | Array<Matcher<t.VariableDeclarator>>): Matcher<t.VariableDeclaration>;
export declare class VariableDeclaratorMatcher extends Matcher<t.VariableDeclarator> {
    private readonly id?;
    private readonly init?;
    constructor(id?: Matcher<t.LVal> | undefined, init?: Matcher<t.Expression> | null | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.VariableDeclarator;
}
export declare function variableDeclarator(id?: Matcher<t.LVal>, init?: Matcher<t.Expression> | null): Matcher<t.VariableDeclarator>;
export declare class VarianceMatcher extends Matcher<t.Variance> {
    private readonly kind?;
    constructor(kind?: string | Matcher<"minus" | "plus"> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.Variance;
}
export declare function variance(kind?: Matcher<'minus' | 'plus'> | string): Matcher<t.Variance>;
export declare class VoidTypeAnnotationMatcher extends Matcher<t.VoidTypeAnnotation> {
    constructor();
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.VoidTypeAnnotation;
}
export declare function voidTypeAnnotation(): Matcher<t.VoidTypeAnnotation>;
export declare class WhileStatementMatcher extends Matcher<t.WhileStatement> {
    private readonly test?;
    private readonly body?;
    constructor(test?: Matcher<t.Expression> | undefined, body?: Matcher<t.Statement> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.WhileStatement;
}
export declare function whileStatement(test?: Matcher<t.Expression>, body?: Matcher<t.Statement>): Matcher<t.WhileStatement>;
export declare class WithStatementMatcher extends Matcher<t.WithStatement> {
    private readonly object?;
    private readonly body?;
    constructor(object?: Matcher<t.Expression> | undefined, body?: Matcher<t.Statement> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.WithStatement;
}
export declare function withStatement(object?: Matcher<t.Expression>, body?: Matcher<t.Statement>): Matcher<t.WithStatement>;
export declare class YieldExpressionMatcher extends Matcher<t.YieldExpression> {
    private readonly argument?;
    private readonly delegate?;
    constructor(argument?: Matcher<t.Expression> | null | undefined, delegate?: boolean | Matcher<boolean> | undefined);
    matchValue(node: unknown, keys: ReadonlyArray<PropertyKey>): node is t.YieldExpression;
}
export declare function yieldExpression(argument?: Matcher<t.Expression> | null, delegate?: Matcher<boolean> | boolean): Matcher<t.YieldExpression>;
