"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = require("path");
const fs_1 = require("fs");
function findAndReplaceProps(j, root, tagName) {
    const layoutToStyle = {
        intrinsic: { maxWidth: '100%', height: 'auto' },
        responsive: { width: '100%', height: 'auto' },
        fill: null,
        fixed: null,
    };
    const layoutToSizes = {
        intrinsic: null,
        responsive: '100vw',
        fill: '100vw',
        fixed: null,
    };
    root
        .find(j.JSXElement)
        .filter((el) => el.value.openingElement.name &&
        el.value.openingElement.name.type === 'JSXIdentifier' &&
        el.value.openingElement.name.name === tagName)
        .forEach((el) => {
        var _a;
        let layout = 'intrinsic';
        let objectFit = null;
        let objectPosition = null;
        let styleExpProps = [];
        let sizesAttr = null;
        const attributes = (_a = el.node.openingElement.attributes) === null || _a === void 0 ? void 0 : _a.filter((a) => {
            var _a, _b;
            if (a.type !== 'JSXAttribute') {
                return true;
            }
            if (a.name.name === 'layout' && 'value' in a.value) {
                layout = String(a.value.value);
                return false;
            }
            if (a.name.name === 'objectFit' && 'value' in a.value) {
                objectFit = String(a.value.value);
                return false;
            }
            if (a.name.name === 'objectPosition' && 'value' in a.value) {
                objectPosition = String(a.value.value);
                return false;
            }
            if (a.name.name === 'lazyBoundary') {
                return false;
            }
            if (a.name.name === 'lazyRoot') {
                return false;
            }
            if (a.name.name === 'style') {
                if (((_a = a.value) === null || _a === void 0 ? void 0 : _a.type) === 'JSXExpressionContainer' &&
                    a.value.expression.type === 'ObjectExpression') {
                    styleExpProps = a.value.expression.properties;
                }
                else if (((_b = a.value) === null || _b === void 0 ? void 0 : _b.type) === 'JSXExpressionContainer' &&
                    a.value.expression.type === 'Identifier') {
                    styleExpProps = [
                        j.spreadElement(j.identifier(a.value.expression.name)),
                    ];
                }
                else {
                    console.warn('Unknown style attribute value detected', a.value);
                }
                return false;
            }
            if (a.name.name === 'sizes') {
                sizesAttr = a;
                return false;
            }
            if (a.name.name === 'lazyBoundary') {
                return false;
            }
            if (a.name.name === 'lazyRoot') {
                return false;
            }
            return true;
        });
        if (layout === 'fill') {
            attributes.push(j.jsxAttribute(j.jsxIdentifier('fill')));
        }
        const sizes = layoutToSizes[layout];
        if (sizes && !sizesAttr) {
            sizesAttr = j.jsxAttribute(j.jsxIdentifier('sizes'), j.literal(sizes));
        }
        if (sizesAttr) {
            attributes.push(sizesAttr);
        }
        let style = layoutToStyle[layout];
        if (style || objectFit || objectPosition) {
            if (!style) {
                style = {};
            }
            if (objectFit) {
                style.objectFit = objectFit;
            }
            if (objectPosition) {
                style.objectPosition = objectPosition;
            }
            Object.entries(style).forEach(([key, value]) => {
                styleExpProps.push(j.objectProperty(j.identifier(key), j.stringLiteral(value)));
            });
            const styleAttribute = j.jsxAttribute(j.jsxIdentifier('style'), j.jsxExpressionContainer(j.objectExpression(styleExpProps)));
            attributes.push(styleAttribute);
        }
        // TODO: should we add `alt=""` attribute?
        // We should probably let the use it manually.
        j(el).replaceWith(j.jsxElement(j.jsxOpeningElement(el.node.openingElement.name, attributes, el.node.openingElement.selfClosing), el.node.closingElement, el.node.children));
    });
}
function nextConfigTransformer(j, root, appDir) {
    let pathPrefix = '';
    let loaderType = '';
    root.find(j.ObjectExpression).forEach((o) => {
        ;
        (o.value.properties || []).forEach((images) => {
            if (images.type === 'ObjectProperty' &&
                images.key.type === 'Identifier' &&
                images.key.name === 'images' &&
                images.value.type === 'ObjectExpression' &&
                images.value.properties) {
                const properties = images.value.properties.filter((p) => {
                    if (p.type === 'ObjectProperty' &&
                        p.key.type === 'Identifier' &&
                        p.key.name === 'loader' &&
                        'value' in p.value) {
                        if (p.value.value === 'imgix' ||
                            p.value.value === 'cloudinary' ||
                            p.value.value === 'akamai') {
                            loaderType = p.value.value;
                            p.value.value = 'custom';
                        }
                    }
                    if (p.type === 'ObjectProperty' &&
                        p.key.type === 'Identifier' &&
                        p.key.name === 'path' &&
                        'value' in p.value) {
                        pathPrefix = String(p.value.value);
                        return false;
                    }
                    return true;
                });
                if (loaderType && pathPrefix) {
                    const importSpecifier = `./${loaderType}-loader.js`;
                    const filePath = (0, path_1.join)(appDir, importSpecifier);
                    properties.push(j.property('init', j.identifier('loaderFile'), j.literal(importSpecifier)));
                    images.value.properties = properties;
                    const normalizeSrc = `const normalizeSrc = (src) => src[0] === '/' ? src.slice(1) : src`;
                    if (loaderType === 'imgix') {
                        (0, fs_1.writeFileSync)(filePath, `${normalizeSrc}
            export default function imgixLoader({ src, width, quality }) {
              const url = new URL('${pathPrefix}' + normalizeSrc(src))
              const params = url.searchParams
              params.set('auto', params.getAll('auto').join(',') || 'format')
              params.set('fit', params.get('fit') || 'max')
              params.set('w', params.get('w') || width.toString())
              if (quality) { params.set('q', quality.toString()) }
              return url.href
            }`
                            .split('\n')
                            .map((l) => l.trim())
                            .join('\n'));
                    }
                    else if (loaderType === 'cloudinary') {
                        (0, fs_1.writeFileSync)(filePath, `${normalizeSrc}
            export default function cloudinaryLoader({ src, width, quality }) {
              const params = ['f_auto', 'c_limit', 'w_' + width, 'q_' + (quality || 'auto')]
              const paramsString = params.join(',') + '/'
              return '${pathPrefix}' + paramsString + normalizeSrc(src)
            }`
                            .split('\n')
                            .map((l) => l.trim())
                            .join('\n'));
                    }
                    else if (loaderType === 'akamai') {
                        (0, fs_1.writeFileSync)(filePath, `${normalizeSrc}
            export default function akamaiLoader({ src, width, quality }) {
              return '${pathPrefix}' + normalizeSrc(src) + '?imwidth=' + width
            }`
                            .split('\n')
                            .map((l) => l.trim())
                            .join('\n'));
                    }
                }
            }
        });
    });
    return root;
}
function transformer(file, api, options) {
    const j = api.jscodeshift.withParser('tsx');
    const root = j(file.source);
    const parsed = (0, path_1.parse)(file.path || '/');
    const isConfig = parsed.base === 'next.config.js' ||
        parsed.base === 'next.config.ts' ||
        parsed.base === 'next.config.mjs' ||
        parsed.base === 'next.config.cjs';
    if (isConfig) {
        const result = nextConfigTransformer(j, root, parsed.dir);
        return result.toSource();
    }
    // Before: import Image from "next/legacy/image"
    //  After: import Image from "next/image"
    root
        .find(j.ImportDeclaration, {
        source: { value: 'next/legacy/image' },
    })
        .forEach((imageImport) => {
        var _a, _b;
        const defaultSpecifier = (_a = imageImport.node.specifiers) === null || _a === void 0 ? void 0 : _a.find((node) => node.type === 'ImportDefaultSpecifier');
        const tagName = (_b = defaultSpecifier === null || defaultSpecifier === void 0 ? void 0 : defaultSpecifier.local) === null || _b === void 0 ? void 0 : _b.name;
        imageImport.node.source = j.stringLiteral('next/image');
        if (tagName) {
            findAndReplaceProps(j, root, tagName);
        }
    });
    // Before: const Image = await import("next/legacy/image")
    //  After: const Image = await import("next/image")
    root.find(j.AwaitExpression).forEach((awaitExp) => {
        const arg = awaitExp.value.argument;
        if ((arg === null || arg === void 0 ? void 0 : arg.type) === 'CallExpression' && arg.callee.type === 'Import') {
            if (arg.arguments[0].type === 'StringLiteral' &&
                arg.arguments[0].value === 'next/legacy/image') {
                arg.arguments[0] = j.stringLiteral('next/image');
            }
        }
    });
    // Before: const Image = require("next/legacy/image")
    //  After: const Image = require("next/image")
    root.find(j.CallExpression).forEach((requireExp) => {
        var _a, _b, _c, _d, _e;
        if (((_b = (_a = requireExp === null || requireExp === void 0 ? void 0 : requireExp.value) === null || _a === void 0 ? void 0 : _a.callee) === null || _b === void 0 ? void 0 : _b.type) === 'Identifier' &&
            requireExp.value.callee.name === 'require') {
            let firstArg = requireExp.value.arguments[0];
            if (firstArg &&
                firstArg.type === 'StringLiteral' &&
                firstArg.value === 'next/legacy/image') {
                const tagName = (_e = (_d = (_c = requireExp === null || requireExp === void 0 ? void 0 : requireExp.parentPath) === null || _c === void 0 ? void 0 : _c.value) === null || _d === void 0 ? void 0 : _d.id) === null || _e === void 0 ? void 0 : _e.name;
                if (tagName) {
                    requireExp.value.arguments[0] = j.stringLiteral('next/image');
                    findAndReplaceProps(j, root, tagName);
                }
            }
        }
    });
    // TODO: do the same transforms for dynamic imports
    return root.toSource(options);
}
exports.default = transformer;
//# sourceMappingURL=next-image-experimental.js.map