// NOTE: This file is autogenerated. Do not modify.
// See packages/babel-types/scripts/generators/typescript-legacy.js for script used.

interface BaseComment {
  value: string;
  start: number;
  end: number;
  loc: SourceLocation;
  type: "CommentBlock" | "CommentLine";
}

interface CommentBlock extends BaseComment {
  type: "CommentBlock";
}

interface CommentLine extends BaseComment {
  type: "CommentLine";
}

type Comment = CommentBlock | CommentLine;

interface SourceLocation {
  start: {
    line: number;
    column: number;
  };

  end: {
    line: number;
    column: number;
  };
}

interface BaseNode {
  leadingComments: ReadonlyArray<Comment> | null;
  innerComments: ReadonlyArray<Comment> | null;
  trailingComments: ReadonlyArray<Comment> | null;
  start: number | null;
  end: number | null;
  loc: SourceLocation | null;
  type: Node["type"];
  extra?: Record<string, unknown>;
}

type Node = Accessor | AnyTypeAnnotation | ArgumentPlaceholder | ArrayExpression | ArrayPattern | ArrayTypeAnnotation | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BigIntLiteral | Binary | BinaryExpression | BindExpression | Block | BlockParent | BlockStatement | BooleanLiteral | BooleanLiteralTypeAnnotation | BooleanTypeAnnotation | BreakStatement | CallExpression | CatchClause | Class | ClassAccessorProperty | ClassBody | ClassDeclaration | ClassExpression | ClassImplements | ClassMethod | ClassPrivateMethod | ClassPrivateProperty | ClassProperty | CompletionStatement | Conditional | ConditionalExpression | ContinueStatement | DebuggerStatement | DecimalLiteral | Declaration | DeclareClass | DeclareExportAllDeclaration | DeclareExportDeclaration | DeclareFunction | DeclareInterface | DeclareModule | DeclareModuleExports | DeclareOpaqueType | DeclareTypeAlias | DeclareVariable | DeclaredPredicate | Decorator | Directive | DirectiveLiteral | DoExpression | DoWhileStatement | EmptyStatement | EmptyTypeAnnotation | EnumBody | EnumBooleanBody | EnumBooleanMember | EnumDeclaration | EnumDefaultedMember | EnumMember | EnumNumberBody | EnumNumberMember | EnumStringBody | EnumStringMember | EnumSymbolBody | ExistsTypeAnnotation | ExportAllDeclaration | ExportDeclaration | ExportDefaultDeclaration | ExportDefaultSpecifier | ExportNamedDeclaration | ExportNamespaceSpecifier | ExportSpecifier | Expression | ExpressionStatement | ExpressionWrapper | File | Flow | FlowBaseAnnotation | FlowDeclaration | FlowPredicate | FlowType | For | ForInStatement | ForOfStatement | ForStatement | ForXStatement | Function | FunctionDeclaration | FunctionExpression | FunctionParent | FunctionTypeAnnotation | FunctionTypeParam | GenericTypeAnnotation | Identifier | IfStatement | Immutable | Import | ImportAttribute | ImportDeclaration | ImportDefaultSpecifier | ImportExpression | ImportNamespaceSpecifier | ImportOrExportDeclaration | ImportSpecifier | IndexedAccessType | InferredPredicate | InterfaceDeclaration | InterfaceExtends | InterfaceTypeAnnotation | InterpreterDirective | IntersectionTypeAnnotation | JSX | JSXAttribute | JSXClosingElement | JSXClosingFragment | JSXElement | JSXEmptyExpression | JSXExpressionContainer | JSXFragment | JSXIdentifier | JSXMemberExpression | JSXNamespacedName | JSXOpeningElement | JSXOpeningFragment | JSXSpreadAttribute | JSXSpreadChild | JSXText | LVal | LabeledStatement | Literal | LogicalExpression | Loop | MemberExpression | MetaProperty | Method | Miscellaneous | MixedTypeAnnotation | ModuleDeclaration | ModuleExpression | ModuleSpecifier | NewExpression | NullLiteral | NullLiteralTypeAnnotation | NullableTypeAnnotation | NumberLiteral | NumberLiteralTypeAnnotation | NumberTypeAnnotation | NumericLiteral | ObjectExpression | ObjectMember | ObjectMethod | ObjectPattern | ObjectProperty | ObjectTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalCallExpression | OptionalIndexedAccessType | OptionalMemberExpression | ParenthesizedExpression | Pattern | PatternLike | PipelineBareFunction | PipelinePrimaryTopicReference | PipelineTopicExpression | Placeholder | Private | PrivateName | Program | Property | Pureish | QualifiedTypeIdentifier | RecordExpression | RegExpLiteral | RegexLiteral | RestElement | RestProperty | ReturnStatement | Scopable | SequenceExpression | SpreadElement | SpreadProperty | Standardized | Statement | StaticBlock | StringLiteral | StringLiteralTypeAnnotation | StringTypeAnnotation | Super | SwitchCase | SwitchStatement | SymbolTypeAnnotation | TSAnyKeyword | TSArrayType | TSAsExpression | TSBaseType | TSBigIntKeyword | TSBooleanKeyword | TSCallSignatureDeclaration | TSConditionalType | TSConstructSignatureDeclaration | TSConstructorType | TSDeclareFunction | TSDeclareMethod | TSEntityName | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSExpressionWithTypeArguments | TSExternalModuleReference | TSFunctionType | TSImportEqualsDeclaration | TSImportType | TSIndexSignature | TSIndexedAccessType | TSInferType | TSInstantiationExpression | TSInterfaceBody | TSInterfaceDeclaration | TSIntersectionType | TSIntrinsicKeyword | TSLiteralType | TSMappedType | TSMethodSignature | TSModuleBlock | TSModuleDeclaration | TSNamedTupleMember | TSNamespaceExportDeclaration | TSNeverKeyword | TSNonNullExpression | TSNullKeyword | TSNumberKeyword | TSObjectKeyword | TSOptionalType | TSParameterProperty | TSParenthesizedType | TSPropertySignature | TSQualifiedName | TSRestType | TSSatisfiesExpression | TSStringKeyword | TSSymbolKeyword | TSThisType | TSTupleType | TSType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeElement | TSTypeLiteral | TSTypeOperator | TSTypeParameter | TSTypeParameterDeclaration | TSTypeParameterInstantiation | TSTypePredicate | TSTypeQuery | TSTypeReference | TSUndefinedKeyword | TSUnionType | TSUnknownKeyword | TSVoidKeyword | TaggedTemplateExpression | TemplateElement | TemplateLiteral | Terminatorless | ThisExpression | ThisTypeAnnotation | ThrowStatement | TopicReference | TryStatement | TupleExpression | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeCastExpression | TypeParameter | TypeParameterDeclaration | TypeParameterInstantiation | TypeScript | TypeofTypeAnnotation | UnaryExpression | UnaryLike | UnionTypeAnnotation | UpdateExpression | UserWhitespacable | V8IntrinsicIdentifier | VariableDeclaration | VariableDeclarator | Variance | VoidTypeAnnotation | While | WhileStatement | WithStatement | YieldExpression;

interface ArrayExpression extends BaseNode {
  type: "ArrayExpression";
  elements: Array<null | Expression | SpreadElement>;
}

interface AssignmentExpression extends BaseNode {
  type: "AssignmentExpression";
  operator: string;
  left: LVal | OptionalMemberExpression;
  right: Expression;
}

interface BinaryExpression extends BaseNode {
  type: "BinaryExpression";
  operator: "+" | "-" | "/" | "%" | "*" | "**" | "&" | "|" | ">>" | ">>>" | "<<" | "^" | "==" | "===" | "!=" | "!==" | "in" | "instanceof" | ">" | "<" | ">=" | "<=" | "|>";
  left: Expression | PrivateName;
  right: Expression;
}

interface InterpreterDirective extends BaseNode {
  type: "InterpreterDirective";
  value: string;
}

interface Directive extends BaseNode {
  type: "Directive";
  value: DirectiveLiteral;
}

interface DirectiveLiteral extends BaseNode {
  type: "DirectiveLiteral";
  value: string;
}

interface BlockStatement extends BaseNode {
  type: "BlockStatement";
  body: Array<Statement>;
  directives: Array<Directive>;
}

interface BreakStatement extends BaseNode {
  type: "BreakStatement";
  label: Identifier | null;
}

interface CallExpression extends BaseNode {
  type: "CallExpression";
  callee: Expression | Super | V8IntrinsicIdentifier;
  arguments: Array<Expression | SpreadElement | JSXNamespacedName | ArgumentPlaceholder>;
  optional: true | false | null;
  typeArguments: TypeParameterInstantiation | null;
  typeParameters: TSTypeParameterInstantiation | null;
}

interface CatchClause extends BaseNode {
  type: "CatchClause";
  param: Identifier | ArrayPattern | ObjectPattern | null;
  body: BlockStatement;
}

interface ConditionalExpression extends BaseNode {
  type: "ConditionalExpression";
  test: Expression;
  consequent: Expression;
  alternate: Expression;
}

interface ContinueStatement extends BaseNode {
  type: "ContinueStatement";
  label: Identifier | null;
}

interface DebuggerStatement extends BaseNode {
  type: "DebuggerStatement";
}

interface DoWhileStatement extends BaseNode {
  type: "DoWhileStatement";
  test: Expression;
  body: Statement;
}

interface EmptyStatement extends BaseNode {
  type: "EmptyStatement";
}

interface ExpressionStatement extends BaseNode {
  type: "ExpressionStatement";
  expression: Expression;
}

interface File extends BaseNode {
  type: "File";
  program: Program;
  comments: Array<CommentBlock | CommentLine> | null;
  tokens: Array<any> | null;
}

interface ForInStatement extends BaseNode {
  type: "ForInStatement";
  left: VariableDeclaration | LVal;
  right: Expression;
  body: Statement;
}

interface ForStatement extends BaseNode {
  type: "ForStatement";
  init: VariableDeclaration | Expression | null;
  test: Expression | null;
  update: Expression | null;
  body: Statement;
}

interface FunctionDeclaration extends BaseNode {
  type: "FunctionDeclaration";
  id: Identifier | null;
  params: Array<Identifier | Pattern | RestElement>;
  body: BlockStatement;
  generator: boolean;
  async: boolean;
  declare: boolean | null;
  predicate: DeclaredPredicate | InferredPredicate | null;
  returnType: TypeAnnotation | TSTypeAnnotation | null;
  typeParameters: TypeParameterDeclaration | TSTypeParameterDeclaration | null;
}

interface FunctionExpression extends BaseNode {
  type: "FunctionExpression";
  id: Identifier | null;
  params: Array<Identifier | Pattern | RestElement>;
  body: BlockStatement;
  generator: boolean;
  async: boolean;
  predicate: DeclaredPredicate | InferredPredicate | null;
  returnType: TypeAnnotation | TSTypeAnnotation | null;
  typeParameters: TypeParameterDeclaration | TSTypeParameterDeclaration | null;
}

interface Identifier extends BaseNode {
  type: "Identifier";
  name: string;
  decorators: Array<Decorator> | null;
  optional: boolean | null;
  typeAnnotation: TypeAnnotation | TSTypeAnnotation | null;
}

interface IfStatement extends BaseNode {
  type: "IfStatement";
  test: Expression;
  consequent: Statement;
  alternate: Statement | null;
}

interface LabeledStatement extends BaseNode {
  type: "LabeledStatement";
  label: Identifier;
  body: Statement;
}

interface StringLiteral extends BaseNode {
  type: "StringLiteral";
  value: string;
}

interface NumericLiteral extends BaseNode {
  type: "NumericLiteral";
  value: number;
}

interface NullLiteral extends BaseNode {
  type: "NullLiteral";
}

interface BooleanLiteral extends BaseNode {
  type: "BooleanLiteral";
  value: boolean;
}

interface RegExpLiteral extends BaseNode {
  type: "RegExpLiteral";
  pattern: string;
  flags: string;
}

interface LogicalExpression extends BaseNode {
  type: "LogicalExpression";
  operator: "||" | "&&" | "??";
  left: Expression;
  right: Expression;
}

interface MemberExpression extends BaseNode {
  type: "MemberExpression";
  object: Expression | Super;
  property: Expression | Identifier | PrivateName;
  computed: boolean;
  optional: true | false | null;
}

interface NewExpression extends BaseNode {
  type: "NewExpression";
  callee: Expression | Super | V8IntrinsicIdentifier;
  arguments: Array<Expression | SpreadElement | JSXNamespacedName | ArgumentPlaceholder>;
  optional: true | false | null;
  typeArguments: TypeParameterInstantiation | null;
  typeParameters: TSTypeParameterInstantiation | null;
}

interface Program extends BaseNode {
  type: "Program";
  body: Array<Statement>;
  directives: Array<Directive>;
  sourceType: "script" | "module";
  interpreter: InterpreterDirective | null;
}

interface ObjectExpression extends BaseNode {
  type: "ObjectExpression";
  properties: Array<ObjectMethod | ObjectProperty | SpreadElement>;
}

interface ObjectMethod extends BaseNode {
  type: "ObjectMethod";
  kind: "method" | "get" | "set";
  key: Expression | Identifier | StringLiteral | NumericLiteral | BigIntLiteral;
  params: Array<Identifier | Pattern | RestElement>;
  body: BlockStatement;
  computed: boolean;
  generator: boolean;
  async: boolean;
  decorators: Array<Decorator> | null;
  returnType: TypeAnnotation | TSTypeAnnotation | null;
  typeParameters: TypeParameterDeclaration | TSTypeParameterDeclaration | null;
}

interface ObjectProperty extends BaseNode {
  type: "ObjectProperty";
  key: Expression | Identifier | StringLiteral | NumericLiteral | BigIntLiteral | DecimalLiteral | PrivateName;
  value: Expression | PatternLike;
  computed: boolean;
  shorthand: boolean;
  decorators: Array<Decorator> | null;
}

interface RestElement extends BaseNode {
  type: "RestElement";
  argument: LVal;
  decorators: Array<Decorator> | null;
  optional: boolean | null;
  typeAnnotation: TypeAnnotation | TSTypeAnnotation | null;
}

interface ReturnStatement extends BaseNode {
  type: "ReturnStatement";
  argument: Expression | null;
}

interface SequenceExpression extends BaseNode {
  type: "SequenceExpression";
  expressions: Array<Expression>;
}

interface ParenthesizedExpression extends BaseNode {
  type: "ParenthesizedExpression";
  expression: Expression;
}

interface SwitchCase extends BaseNode {
  type: "SwitchCase";
  test: Expression | null;
  consequent: Array<Statement>;
}

interface SwitchStatement extends BaseNode {
  type: "SwitchStatement";
  discriminant: Expression;
  cases: Array<SwitchCase>;
}

interface ThisExpression extends BaseNode {
  type: "ThisExpression";
}

interface ThrowStatement extends BaseNode {
  type: "ThrowStatement";
  argument: Expression;
}

interface TryStatement extends BaseNode {
  type: "TryStatement";
  block: BlockStatement;
  handler: CatchClause | null;
  finalizer: BlockStatement | null;
}

interface UnaryExpression extends BaseNode {
  type: "UnaryExpression";
  operator: "void" | "throw" | "delete" | "!" | "+" | "-" | "~" | "typeof";
  argument: Expression;
  prefix: boolean;
}

interface UpdateExpression extends BaseNode {
  type: "UpdateExpression";
  operator: "++" | "--";
  argument: Expression;
  prefix: boolean;
}

interface VariableDeclaration extends BaseNode {
  type: "VariableDeclaration";
  kind: "var" | "let" | "const" | "using" | "await using";
  declarations: Array<VariableDeclarator>;
  declare: boolean | null;
}

interface VariableDeclarator extends BaseNode {
  type: "VariableDeclarator";
  id: LVal;
  init: Expression | null;
  definite: boolean | null;
}

interface WhileStatement extends BaseNode {
  type: "WhileStatement";
  test: Expression;
  body: Statement;
}

interface WithStatement extends BaseNode {
  type: "WithStatement";
  object: Expression;
  body: Statement;
}

interface AssignmentPattern extends BaseNode {
  type: "AssignmentPattern";
  left: Identifier | ObjectPattern | ArrayPattern | MemberExpression | TSAsExpression | TSSatisfiesExpression | TSTypeAssertion | TSNonNullExpression;
  right: Expression;
  decorators: Array<Decorator> | null;
  optional: boolean | null;
  typeAnnotation: TypeAnnotation | TSTypeAnnotation | null;
}

interface ArrayPattern extends BaseNode {
  type: "ArrayPattern";
  elements: Array<null | PatternLike | LVal>;
  decorators: Array<Decorator> | null;
  optional: boolean | null;
  typeAnnotation: TypeAnnotation | TSTypeAnnotation | null;
}

interface ArrowFunctionExpression extends BaseNode {
  type: "ArrowFunctionExpression";
  params: Array<Identifier | Pattern | RestElement>;
  body: BlockStatement | Expression;
  async: boolean;
  expression: boolean;
  generator: boolean;
  predicate: DeclaredPredicate | InferredPredicate | null;
  returnType: TypeAnnotation | TSTypeAnnotation | null;
  typeParameters: TypeParameterDeclaration | TSTypeParameterDeclaration | null;
}

interface ClassBody extends BaseNode {
  type: "ClassBody";
  body: Array<ClassMethod | ClassPrivateMethod | ClassProperty | ClassPrivateProperty | ClassAccessorProperty | TSDeclareMethod | TSIndexSignature | StaticBlock>;
}

interface ClassExpression extends BaseNode {
  type: "ClassExpression";
  id: Identifier | null;
  superClass: Expression | null;
  body: ClassBody;
  decorators: Array<Decorator> | null;
  implements: Array<TSExpressionWithTypeArguments | ClassImplements> | null;
  mixins: InterfaceExtends | null;
  superTypeParameters: TypeParameterInstantiation | TSTypeParameterInstantiation | null;
  typeParameters: TypeParameterDeclaration | TSTypeParameterDeclaration | null;
}

interface ClassDeclaration extends BaseNode {
  type: "ClassDeclaration";
  id: Identifier | null;
  superClass: Expression | null;
  body: ClassBody;
  decorators: Array<Decorator> | null;
  abstract: boolean | null;
  declare: boolean | null;
  implements: Array<TSExpressionWithTypeArguments | ClassImplements> | null;
  mixins: InterfaceExtends | null;
  superTypeParameters: TypeParameterInstantiation | TSTypeParameterInstantiation | null;
  typeParameters: TypeParameterDeclaration | TSTypeParameterDeclaration | null;
}

interface ExportAllDeclaration extends BaseNode {
  type: "ExportAllDeclaration";
  source: StringLiteral;
  assertions: Array<ImportAttribute> | null;
  attributes: Array<ImportAttribute> | null;
  exportKind: "type" | "value" | null;
}

interface ExportDefaultDeclaration extends BaseNode {
  type: "ExportDefaultDeclaration";
  declaration: TSDeclareFunction | FunctionDeclaration | ClassDeclaration | Expression;
  exportKind: "value" | null;
}

interface ExportNamedDeclaration extends BaseNode {
  type: "ExportNamedDeclaration";
  declaration: Declaration | null;
  specifiers: Array<ExportSpecifier | ExportDefaultSpecifier | ExportNamespaceSpecifier>;
  source: StringLiteral | null;
  assertions: Array<ImportAttribute> | null;
  attributes: Array<ImportAttribute> | null;
  exportKind: "type" | "value" | null;
}

interface ExportSpecifier extends BaseNode {
  type: "ExportSpecifier";
  local: Identifier;
  exported: Identifier | StringLiteral;
  exportKind: "type" | "value" | null;
}

interface ForOfStatement extends BaseNode {
  type: "ForOfStatement";
  left: VariableDeclaration | LVal;
  right: Expression;
  body: Statement;
  await: boolean;
}

interface ImportDeclaration extends BaseNode {
  type: "ImportDeclaration";
  specifiers: Array<ImportSpecifier | ImportDefaultSpecifier | ImportNamespaceSpecifier>;
  source: StringLiteral;
  assertions: Array<ImportAttribute> | null;
  attributes: Array<ImportAttribute> | null;
  importKind: "type" | "typeof" | "value" | null;
  module: boolean | null;
  phase: "source" | "defer" | null;
}

interface ImportDefaultSpecifier extends BaseNode {
  type: "ImportDefaultSpecifier";
  local: Identifier;
}

interface ImportNamespaceSpecifier extends BaseNode {
  type: "ImportNamespaceSpecifier";
  local: Identifier;
}

interface ImportSpecifier extends BaseNode {
  type: "ImportSpecifier";
  local: Identifier;
  imported: Identifier | StringLiteral;
  importKind: "type" | "typeof" | "value" | null;
}

interface ImportExpression extends BaseNode {
  type: "ImportExpression";
  source: Expression;
  options: Expression | null;
  phase: "source" | "defer" | null;
}

interface MetaProperty extends BaseNode {
  type: "MetaProperty";
  meta: Identifier;
  property: Identifier;
}

interface ClassMethod extends BaseNode {
  type: "ClassMethod";
  kind: "get" | "set" | "method" | "constructor";
  key: Identifier | StringLiteral | NumericLiteral | BigIntLiteral | Expression;
  params: Array<Identifier | Pattern | RestElement | TSParameterProperty>;
  body: BlockStatement;
  computed: boolean;
  static: boolean;
  generator: boolean;
  async: boolean;
  abstract: boolean | null;
  access: "public" | "private" | "protected" | null;
  accessibility: "public" | "private" | "protected" | null;
  decorators: Array<Decorator> | null;
  optional: boolean | null;
  override: boolean;
  returnType: TypeAnnotation | TSTypeAnnotation | null;
  typeParameters: TypeParameterDeclaration | TSTypeParameterDeclaration | null;
}

interface ObjectPattern extends BaseNode {
  type: "ObjectPattern";
  properties: Array<RestElement | ObjectProperty>;
  decorators: Array<Decorator> | null;
  optional: boolean | null;
  typeAnnotation: TypeAnnotation | TSTypeAnnotation | null;
}

interface SpreadElement extends BaseNode {
  type: "SpreadElement";
  argument: Expression;
}

interface Super extends BaseNode {
  type: "Super";
}

interface TaggedTemplateExpression extends BaseNode {
  type: "TaggedTemplateExpression";
  tag: Expression;
  quasi: TemplateLiteral;
  typeParameters: TypeParameterInstantiation | TSTypeParameterInstantiation | null;
}

interface TemplateElement extends BaseNode {
  type: "TemplateElement";
  value: { raw: string, cooked?: string };
  tail: boolean;
}

interface TemplateLiteral extends BaseNode {
  type: "TemplateLiteral";
  quasis: Array<TemplateElement>;
  expressions: Array<Expression | TSType>;
}

interface YieldExpression extends BaseNode {
  type: "YieldExpression";
  argument: Expression | null;
  delegate: boolean;
}

interface AwaitExpression extends BaseNode {
  type: "AwaitExpression";
  argument: Expression;
}

interface Import extends BaseNode {
  type: "Import";
}

interface BigIntLiteral extends BaseNode {
  type: "BigIntLiteral";
  value: string;
}

interface ExportNamespaceSpecifier extends BaseNode {
  type: "ExportNamespaceSpecifier";
  exported: Identifier;
}

interface OptionalMemberExpression extends BaseNode {
  type: "OptionalMemberExpression";
  object: Expression;
  property: Expression | Identifier;
  computed: boolean;
  optional: boolean;
}

interface OptionalCallExpression extends BaseNode {
  type: "OptionalCallExpression";
  callee: Expression;
  arguments: Array<Expression | SpreadElement | JSXNamespacedName | ArgumentPlaceholder>;
  optional: boolean;
  typeArguments: TypeParameterInstantiation | null;
  typeParameters: TSTypeParameterInstantiation | null;
}

interface ClassProperty extends BaseNode {
  type: "ClassProperty";
  key: Identifier | StringLiteral | NumericLiteral | BigIntLiteral | Expression;
  value: Expression | null;
  typeAnnotation: TypeAnnotation | TSTypeAnnotation | null;
  decorators: Array<Decorator> | null;
  computed: boolean;
  static: boolean;
  abstract: boolean | null;
  accessibility: "public" | "private" | "protected" | null;
  declare: boolean | null;
  definite: boolean | null;
  optional: boolean | null;
  override: boolean;
  readonly: boolean | null;
  variance: Variance | null;
}

interface ClassAccessorProperty extends BaseNode {
  type: "ClassAccessorProperty";
  key: Identifier | StringLiteral | NumericLiteral | BigIntLiteral | Expression | PrivateName;
  value: Expression | null;
  typeAnnotation: TypeAnnotation | TSTypeAnnotation | null;
  decorators: Array<Decorator> | null;
  computed: boolean;
  static: boolean;
  abstract: boolean | null;
  accessibility: "public" | "private" | "protected" | null;
  declare: boolean | null;
  definite: boolean | null;
  optional: boolean | null;
  override: boolean;
  readonly: boolean | null;
  variance: Variance | null;
}

interface ClassPrivateProperty extends BaseNode {
  type: "ClassPrivateProperty";
  key: PrivateName;
  value: Expression | null;
  decorators: Array<Decorator> | null;
  static: boolean;
  definite: boolean | null;
  readonly: boolean | null;
  typeAnnotation: TypeAnnotation | TSTypeAnnotation | null;
  variance: Variance | null;
}

interface ClassPrivateMethod extends BaseNode {
  type: "ClassPrivateMethod";
  kind: "get" | "set" | "method";
  key: PrivateName;
  params: Array<Identifier | Pattern | RestElement | TSParameterProperty>;
  body: BlockStatement;
  static: boolean;
  abstract: boolean | null;
  access: "public" | "private" | "protected" | null;
  accessibility: "public" | "private" | "protected" | null;
  async: boolean;
  computed: boolean;
  decorators: Array<Decorator> | null;
  generator: boolean;
  optional: boolean | null;
  override: boolean;
  returnType: TypeAnnotation | TSTypeAnnotation | null;
  typeParameters: TypeParameterDeclaration | TSTypeParameterDeclaration | null;
}

interface PrivateName extends BaseNode {
  type: "PrivateName";
  id: Identifier;
}

interface StaticBlock extends BaseNode {
  type: "StaticBlock";
  body: Array<Statement>;
}

interface AnyTypeAnnotation extends BaseNode {
  type: "AnyTypeAnnotation";
}

interface ArrayTypeAnnotation extends BaseNode {
  type: "ArrayTypeAnnotation";
  elementType: FlowType;
}

interface BooleanTypeAnnotation extends BaseNode {
  type: "BooleanTypeAnnotation";
}

interface BooleanLiteralTypeAnnotation extends BaseNode {
  type: "BooleanLiteralTypeAnnotation";
  value: boolean;
}

interface NullLiteralTypeAnnotation extends BaseNode {
  type: "NullLiteralTypeAnnotation";
}

interface ClassImplements extends BaseNode {
  type: "ClassImplements";
  id: Identifier;
  typeParameters: TypeParameterInstantiation | null;
}

interface DeclareClass extends BaseNode {
  type: "DeclareClass";
  id: Identifier;
  typeParameters: TypeParameterDeclaration | null;
  extends: Array<InterfaceExtends> | null;
  body: ObjectTypeAnnotation;
  implements: Array<ClassImplements> | null;
  mixins: Array<InterfaceExtends> | null;
}

interface DeclareFunction extends BaseNode {
  type: "DeclareFunction";
  id: Identifier;
  predicate: DeclaredPredicate | null;
}

interface DeclareInterface extends BaseNode {
  type: "DeclareInterface";
  id: Identifier;
  typeParameters: TypeParameterDeclaration | null;
  extends: Array<InterfaceExtends> | null;
  body: ObjectTypeAnnotation;
}

interface DeclareModule extends BaseNode {
  type: "DeclareModule";
  id: Identifier | StringLiteral;
  body: BlockStatement;
  kind: "CommonJS" | "ES" | null;
}

interface DeclareModuleExports extends BaseNode {
  type: "DeclareModuleExports";
  typeAnnotation: TypeAnnotation;
}

interface DeclareTypeAlias extends BaseNode {
  type: "DeclareTypeAlias";
  id: Identifier;
  typeParameters: TypeParameterDeclaration | null;
  right: FlowType;
}

interface DeclareOpaqueType extends BaseNode {
  type: "DeclareOpaqueType";
  id: Identifier;
  typeParameters: TypeParameterDeclaration | null;
  supertype: FlowType | null;
  impltype: FlowType | null;
}

interface DeclareVariable extends BaseNode {
  type: "DeclareVariable";
  id: Identifier;
}

interface DeclareExportDeclaration extends BaseNode {
  type: "DeclareExportDeclaration";
  declaration: Flow | null;
  specifiers: Array<ExportSpecifier | ExportNamespaceSpecifier> | null;
  source: StringLiteral | null;
  default: boolean | null;
}

interface DeclareExportAllDeclaration extends BaseNode {
  type: "DeclareExportAllDeclaration";
  source: StringLiteral;
  exportKind: "type" | "value" | null;
}

interface DeclaredPredicate extends BaseNode {
  type: "DeclaredPredicate";
  value: Flow;
}

interface ExistsTypeAnnotation extends BaseNode {
  type: "ExistsTypeAnnotation";
}

interface FunctionTypeAnnotation extends BaseNode {
  type: "FunctionTypeAnnotation";
  typeParameters: TypeParameterDeclaration | null;
  params: Array<FunctionTypeParam>;
  rest: FunctionTypeParam | null;
  returnType: FlowType;
  this: FunctionTypeParam | null;
}

interface FunctionTypeParam extends BaseNode {
  type: "FunctionTypeParam";
  name: Identifier | null;
  typeAnnotation: FlowType;
  optional: boolean | null;
}

interface GenericTypeAnnotation extends BaseNode {
  type: "GenericTypeAnnotation";
  id: Identifier | QualifiedTypeIdentifier;
  typeParameters: TypeParameterInstantiation | null;
}

interface InferredPredicate extends BaseNode {
  type: "InferredPredicate";
}

interface InterfaceExtends extends BaseNode {
  type: "InterfaceExtends";
  id: Identifier | QualifiedTypeIdentifier;
  typeParameters: TypeParameterInstantiation | null;
}

interface InterfaceDeclaration extends BaseNode {
  type: "InterfaceDeclaration";
  id: Identifier;
  typeParameters: TypeParameterDeclaration | null;
  extends: Array<InterfaceExtends> | null;
  body: ObjectTypeAnnotation;
}

interface InterfaceTypeAnnotation extends BaseNode {
  type: "InterfaceTypeAnnotation";
  extends: Array<InterfaceExtends> | null;
  body: ObjectTypeAnnotation;
}

interface IntersectionTypeAnnotation extends BaseNode {
  type: "IntersectionTypeAnnotation";
  types: Array<FlowType>;
}

interface MixedTypeAnnotation extends BaseNode {
  type: "MixedTypeAnnotation";
}

interface EmptyTypeAnnotation extends BaseNode {
  type: "EmptyTypeAnnotation";
}

interface NullableTypeAnnotation extends BaseNode {
  type: "NullableTypeAnnotation";
  typeAnnotation: FlowType;
}

interface NumberLiteralTypeAnnotation extends BaseNode {
  type: "NumberLiteralTypeAnnotation";
  value: number;
}

interface NumberTypeAnnotation extends BaseNode {
  type: "NumberTypeAnnotation";
}

interface ObjectTypeAnnotation extends BaseNode {
  type: "ObjectTypeAnnotation";
  properties: Array<ObjectTypeProperty | ObjectTypeSpreadProperty>;
  indexers: Array<ObjectTypeIndexer>;
  callProperties: Array<ObjectTypeCallProperty>;
  internalSlots: Array<ObjectTypeInternalSlot>;
  exact: boolean;
  inexact: boolean | null;
}

interface ObjectTypeInternalSlot extends BaseNode {
  type: "ObjectTypeInternalSlot";
  id: Identifier;
  value: FlowType;
  optional: boolean;
  static: boolean;
  method: boolean;
}

interface ObjectTypeCallProperty extends BaseNode {
  type: "ObjectTypeCallProperty";
  value: FlowType;
  static: boolean;
}

interface ObjectTypeIndexer extends BaseNode {
  type: "ObjectTypeIndexer";
  id: Identifier | null;
  key: FlowType;
  value: FlowType;
  variance: Variance | null;
  static: boolean;
}

interface ObjectTypeProperty extends BaseNode {
  type: "ObjectTypeProperty";
  key: Identifier | StringLiteral;
  value: FlowType;
  variance: Variance | null;
  kind: "init" | "get" | "set";
  method: boolean;
  optional: boolean;
  proto: boolean;
  static: boolean;
}

interface ObjectTypeSpreadProperty extends BaseNode {
  type: "ObjectTypeSpreadProperty";
  argument: FlowType;
}

interface OpaqueType extends BaseNode {
  type: "OpaqueType";
  id: Identifier;
  typeParameters: TypeParameterDeclaration | null;
  supertype: FlowType | null;
  impltype: FlowType;
}

interface QualifiedTypeIdentifier extends BaseNode {
  type: "QualifiedTypeIdentifier";
  id: Identifier;
  qualification: Identifier | QualifiedTypeIdentifier;
}

interface StringLiteralTypeAnnotation extends BaseNode {
  type: "StringLiteralTypeAnnotation";
  value: string;
}

interface StringTypeAnnotation extends BaseNode {
  type: "StringTypeAnnotation";
}

interface SymbolTypeAnnotation extends BaseNode {
  type: "SymbolTypeAnnotation";
}

interface ThisTypeAnnotation extends BaseNode {
  type: "ThisTypeAnnotation";
}

interface TupleTypeAnnotation extends BaseNode {
  type: "TupleTypeAnnotation";
  types: Array<FlowType>;
}

interface TypeofTypeAnnotation extends BaseNode {
  type: "TypeofTypeAnnotation";
  argument: FlowType;
}

interface TypeAlias extends BaseNode {
  type: "TypeAlias";
  id: Identifier;
  typeParameters: TypeParameterDeclaration | null;
  right: FlowType;
}

interface TypeAnnotation extends BaseNode {
  type: "TypeAnnotation";
  typeAnnotation: FlowType;
}

interface TypeCastExpression extends BaseNode {
  type: "TypeCastExpression";
  expression: Expression;
  typeAnnotation: TypeAnnotation;
}

interface TypeParameter extends BaseNode {
  type: "TypeParameter";
  bound: TypeAnnotation | null;
  default: FlowType | null;
  variance: Variance | null;
  name: string;
}

interface TypeParameterDeclaration extends BaseNode {
  type: "TypeParameterDeclaration";
  params: Array<TypeParameter>;
}

interface TypeParameterInstantiation extends BaseNode {
  type: "TypeParameterInstantiation";
  params: Array<FlowType>;
}

interface UnionTypeAnnotation extends BaseNode {
  type: "UnionTypeAnnotation";
  types: Array<FlowType>;
}

interface Variance extends BaseNode {
  type: "Variance";
  kind: "minus" | "plus";
}

interface VoidTypeAnnotation extends BaseNode {
  type: "VoidTypeAnnotation";
}

interface EnumDeclaration extends BaseNode {
  type: "EnumDeclaration";
  id: Identifier;
  body: EnumBooleanBody | EnumNumberBody | EnumStringBody | EnumSymbolBody;
}

interface EnumBooleanBody extends BaseNode {
  type: "EnumBooleanBody";
  members: Array<EnumBooleanMember>;
  explicitType: boolean;
  hasUnknownMembers: boolean;
}

interface EnumNumberBody extends BaseNode {
  type: "EnumNumberBody";
  members: Array<EnumNumberMember>;
  explicitType: boolean;
  hasUnknownMembers: boolean;
}

interface EnumStringBody extends BaseNode {
  type: "EnumStringBody";
  members: Array<EnumStringMember | EnumDefaultedMember>;
  explicitType: boolean;
  hasUnknownMembers: boolean;
}

interface EnumSymbolBody extends BaseNode {
  type: "EnumSymbolBody";
  members: Array<EnumDefaultedMember>;
  hasUnknownMembers: boolean;
}

interface EnumBooleanMember extends BaseNode {
  type: "EnumBooleanMember";
  id: Identifier;
  init: BooleanLiteral;
}

interface EnumNumberMember extends BaseNode {
  type: "EnumNumberMember";
  id: Identifier;
  init: NumericLiteral;
}

interface EnumStringMember extends BaseNode {
  type: "EnumStringMember";
  id: Identifier;
  init: StringLiteral;
}

interface EnumDefaultedMember extends BaseNode {
  type: "EnumDefaultedMember";
  id: Identifier;
}

interface IndexedAccessType extends BaseNode {
  type: "IndexedAccessType";
  objectType: FlowType;
  indexType: FlowType;
}

interface OptionalIndexedAccessType extends BaseNode {
  type: "OptionalIndexedAccessType";
  objectType: FlowType;
  indexType: FlowType;
  optional: boolean;
}

interface JSXAttribute extends BaseNode {
  type: "JSXAttribute";
  name: JSXIdentifier | JSXNamespacedName;
  value: JSXElement | JSXFragment | StringLiteral | JSXExpressionContainer | null;
}

interface JSXClosingElement extends BaseNode {
  type: "JSXClosingElement";
  name: JSXIdentifier | JSXMemberExpression | JSXNamespacedName;
}

interface JSXElement extends BaseNode {
  type: "JSXElement";
  openingElement: JSXOpeningElement;
  closingElement: JSXClosingElement | null;
  children: Array<JSXText | JSXExpressionContainer | JSXSpreadChild | JSXElement | JSXFragment>;
}

interface JSXEmptyExpression extends BaseNode {
  type: "JSXEmptyExpression";
}

interface JSXExpressionContainer extends BaseNode {
  type: "JSXExpressionContainer";
  expression: Expression | JSXEmptyExpression;
}

interface JSXSpreadChild extends BaseNode {
  type: "JSXSpreadChild";
  expression: Expression;
}

interface JSXIdentifier extends BaseNode {
  type: "JSXIdentifier";
  name: string;
}

interface JSXMemberExpression extends BaseNode {
  type: "JSXMemberExpression";
  object: JSXMemberExpression | JSXIdentifier;
  property: JSXIdentifier;
}

interface JSXNamespacedName extends BaseNode {
  type: "JSXNamespacedName";
  namespace: JSXIdentifier;
  name: JSXIdentifier;
}

interface JSXOpeningElement extends BaseNode {
  type: "JSXOpeningElement";
  name: JSXIdentifier | JSXMemberExpression | JSXNamespacedName;
  attributes: Array<JSXAttribute | JSXSpreadAttribute>;
  selfClosing: boolean;
  typeParameters: TypeParameterInstantiation | TSTypeParameterInstantiation | null;
}

interface JSXSpreadAttribute extends BaseNode {
  type: "JSXSpreadAttribute";
  argument: Expression;
}

interface JSXText extends BaseNode {
  type: "JSXText";
  value: string;
}

interface JSXFragment extends BaseNode {
  type: "JSXFragment";
  openingFragment: JSXOpeningFragment;
  closingFragment: JSXClosingFragment;
  children: Array<JSXText | JSXExpressionContainer | JSXSpreadChild | JSXElement | JSXFragment>;
}

interface JSXOpeningFragment extends BaseNode {
  type: "JSXOpeningFragment";
}

interface JSXClosingFragment extends BaseNode {
  type: "JSXClosingFragment";
}

interface Placeholder extends BaseNode {
  type: "Placeholder";
  expectedNode: "Identifier" | "StringLiteral" | "Expression" | "Statement" | "Declaration" | "BlockStatement" | "ClassBody" | "Pattern";
  name: Identifier;
}

interface V8IntrinsicIdentifier extends BaseNode {
  type: "V8IntrinsicIdentifier";
  name: string;
}

interface ArgumentPlaceholder extends BaseNode {
  type: "ArgumentPlaceholder";
}

interface BindExpression extends BaseNode {
  type: "BindExpression";
  object: Expression;
  callee: Expression;
}

interface ImportAttribute extends BaseNode {
  type: "ImportAttribute";
  key: Identifier | StringLiteral;
  value: StringLiteral;
}

interface Decorator extends BaseNode {
  type: "Decorator";
  expression: Expression;
}

interface DoExpression extends BaseNode {
  type: "DoExpression";
  body: BlockStatement;
  async: boolean;
}

interface ExportDefaultSpecifier extends BaseNode {
  type: "ExportDefaultSpecifier";
  exported: Identifier;
}

interface RecordExpression extends BaseNode {
  type: "RecordExpression";
  properties: Array<ObjectProperty | SpreadElement>;
}

interface TupleExpression extends BaseNode {
  type: "TupleExpression";
  elements: Array<Expression | SpreadElement>;
}

interface DecimalLiteral extends BaseNode {
  type: "DecimalLiteral";
  value: string;
}

interface ModuleExpression extends BaseNode {
  type: "ModuleExpression";
  body: Program;
}

interface TopicReference extends BaseNode {
  type: "TopicReference";
}

interface PipelineTopicExpression extends BaseNode {
  type: "PipelineTopicExpression";
  expression: Expression;
}

interface PipelineBareFunction extends BaseNode {
  type: "PipelineBareFunction";
  callee: Expression;
}

interface PipelinePrimaryTopicReference extends BaseNode {
  type: "PipelinePrimaryTopicReference";
}

interface TSParameterProperty extends BaseNode {
  type: "TSParameterProperty";
  parameter: Identifier | AssignmentPattern;
  accessibility: "public" | "private" | "protected" | null;
  decorators: Array<Decorator> | null;
  override: boolean | null;
  readonly: boolean | null;
}

interface TSDeclareFunction extends BaseNode {
  type: "TSDeclareFunction";
  id: Identifier | null;
  typeParameters: TSTypeParameterDeclaration | null;
  params: Array<Identifier | Pattern | RestElement>;
  returnType: TSTypeAnnotation | null;
  async: boolean;
  declare: boolean | null;
  generator: boolean;
}

interface TSDeclareMethod extends BaseNode {
  type: "TSDeclareMethod";
  decorators: Array<Decorator> | null;
  key: Identifier | StringLiteral | NumericLiteral | BigIntLiteral | Expression;
  typeParameters: TSTypeParameterDeclaration | null;
  params: Array<Identifier | Pattern | RestElement | TSParameterProperty>;
  returnType: TSTypeAnnotation | null;
  abstract: boolean | null;
  access: "public" | "private" | "protected" | null;
  accessibility: "public" | "private" | "protected" | null;
  async: boolean;
  computed: boolean;
  generator: boolean;
  kind: "get" | "set" | "method" | "constructor";
  optional: boolean | null;
  override: boolean;
  static: boolean;
}

interface TSQualifiedName extends BaseNode {
  type: "TSQualifiedName";
  left: TSEntityName;
  right: Identifier;
}

interface TSCallSignatureDeclaration extends BaseNode {
  type: "TSCallSignatureDeclaration";
  typeParameters: TSTypeParameterDeclaration | null;
  params: Array<ArrayPattern | Identifier | ObjectPattern | RestElement>;
  returnType: TSTypeAnnotation | null;
}

interface TSConstructSignatureDeclaration extends BaseNode {
  type: "TSConstructSignatureDeclaration";
  typeParameters: TSTypeParameterDeclaration | null;
  params: Array<ArrayPattern | Identifier | ObjectPattern | RestElement>;
  returnType: TSTypeAnnotation | null;
}

interface TSPropertySignature extends BaseNode {
  type: "TSPropertySignature";
  key: Expression;
  typeAnnotation: TSTypeAnnotation | null;
  computed: boolean;
  kind: "get" | "set";
  optional: boolean | null;
  readonly: boolean | null;
}

interface TSMethodSignature extends BaseNode {
  type: "TSMethodSignature";
  key: Expression;
  typeParameters: TSTypeParameterDeclaration | null;
  params: Array<ArrayPattern | Identifier | ObjectPattern | RestElement>;
  returnType: TSTypeAnnotation | null;
  computed: boolean;
  kind: "method" | "get" | "set";
  optional: boolean | null;
}

interface TSIndexSignature extends BaseNode {
  type: "TSIndexSignature";
  parameters: Array<Identifier>;
  typeAnnotation: TSTypeAnnotation | null;
  readonly: boolean | null;
  static: boolean | null;
}

interface TSAnyKeyword extends BaseNode {
  type: "TSAnyKeyword";
}

interface TSBooleanKeyword extends BaseNode {
  type: "TSBooleanKeyword";
}

interface TSBigIntKeyword extends BaseNode {
  type: "TSBigIntKeyword";
}

interface TSIntrinsicKeyword extends BaseNode {
  type: "TSIntrinsicKeyword";
}

interface TSNeverKeyword extends BaseNode {
  type: "TSNeverKeyword";
}

interface TSNullKeyword extends BaseNode {
  type: "TSNullKeyword";
}

interface TSNumberKeyword extends BaseNode {
  type: "TSNumberKeyword";
}

interface TSObjectKeyword extends BaseNode {
  type: "TSObjectKeyword";
}

interface TSStringKeyword extends BaseNode {
  type: "TSStringKeyword";
}

interface TSSymbolKeyword extends BaseNode {
  type: "TSSymbolKeyword";
}

interface TSUndefinedKeyword extends BaseNode {
  type: "TSUndefinedKeyword";
}

interface TSUnknownKeyword extends BaseNode {
  type: "TSUnknownKeyword";
}

interface TSVoidKeyword extends BaseNode {
  type: "TSVoidKeyword";
}

interface TSThisType extends BaseNode {
  type: "TSThisType";
}

interface TSFunctionType extends BaseNode {
  type: "TSFunctionType";
  typeParameters: TSTypeParameterDeclaration | null;
  params: Array<ArrayPattern | Identifier | ObjectPattern | RestElement>;
  returnType: TSTypeAnnotation | null;
}

interface TSConstructorType extends BaseNode {
  type: "TSConstructorType";
  typeParameters: TSTypeParameterDeclaration | null;
  params: Array<ArrayPattern | Identifier | ObjectPattern | RestElement>;
  returnType: TSTypeAnnotation | null;
  abstract: boolean | null;
}

interface TSTypeReference extends BaseNode {
  type: "TSTypeReference";
  typeName: TSEntityName;
  typeParameters: TSTypeParameterInstantiation | null;
}

interface TSTypePredicate extends BaseNode {
  type: "TSTypePredicate";
  parameterName: Identifier | TSThisType;
  typeAnnotation: TSTypeAnnotation | null;
  asserts: boolean | null;
}

interface TSTypeQuery extends BaseNode {
  type: "TSTypeQuery";
  exprName: TSEntityName | TSImportType;
  typeParameters: TSTypeParameterInstantiation | null;
}

interface TSTypeLiteral extends BaseNode {
  type: "TSTypeLiteral";
  members: Array<TSTypeElement>;
}

interface TSArrayType extends BaseNode {
  type: "TSArrayType";
  elementType: TSType;
}

interface TSTupleType extends BaseNode {
  type: "TSTupleType";
  elementTypes: Array<TSType | TSNamedTupleMember>;
}

interface TSOptionalType extends BaseNode {
  type: "TSOptionalType";
  typeAnnotation: TSType;
}

interface TSRestType extends BaseNode {
  type: "TSRestType";
  typeAnnotation: TSType;
}

interface TSNamedTupleMember extends BaseNode {
  type: "TSNamedTupleMember";
  label: Identifier;
  elementType: TSType;
  optional: boolean;
}

interface TSUnionType extends BaseNode {
  type: "TSUnionType";
  types: Array<TSType>;
}

interface TSIntersectionType extends BaseNode {
  type: "TSIntersectionType";
  types: Array<TSType>;
}

interface TSConditionalType extends BaseNode {
  type: "TSConditionalType";
  checkType: TSType;
  extendsType: TSType;
  trueType: TSType;
  falseType: TSType;
}

interface TSInferType extends BaseNode {
  type: "TSInferType";
  typeParameter: TSTypeParameter;
}

interface TSParenthesizedType extends BaseNode {
  type: "TSParenthesizedType";
  typeAnnotation: TSType;
}

interface TSTypeOperator extends BaseNode {
  type: "TSTypeOperator";
  typeAnnotation: TSType;
  operator: string;
}

interface TSIndexedAccessType extends BaseNode {
  type: "TSIndexedAccessType";
  objectType: TSType;
  indexType: TSType;
}

interface TSMappedType extends BaseNode {
  type: "TSMappedType";
  typeParameter: TSTypeParameter;
  typeAnnotation: TSType | null;
  nameType: TSType | null;
  optional: true | false | "+" | "-" | null;
  readonly: true | false | "+" | "-" | null;
}

interface TSLiteralType extends BaseNode {
  type: "TSLiteralType";
  literal: NumericLiteral | StringLiteral | BooleanLiteral | BigIntLiteral | TemplateLiteral | UnaryExpression;
}

interface TSExpressionWithTypeArguments extends BaseNode {
  type: "TSExpressionWithTypeArguments";
  expression: TSEntityName;
  typeParameters: TSTypeParameterInstantiation | null;
}

interface TSInterfaceDeclaration extends BaseNode {
  type: "TSInterfaceDeclaration";
  id: Identifier;
  typeParameters: TSTypeParameterDeclaration | null;
  extends: Array<TSExpressionWithTypeArguments> | null;
  body: TSInterfaceBody;
  declare: boolean | null;
}

interface TSInterfaceBody extends BaseNode {
  type: "TSInterfaceBody";
  body: Array<TSTypeElement>;
}

interface TSTypeAliasDeclaration extends BaseNode {
  type: "TSTypeAliasDeclaration";
  id: Identifier;
  typeParameters: TSTypeParameterDeclaration | null;
  typeAnnotation: TSType;
  declare: boolean | null;
}

interface TSInstantiationExpression extends BaseNode {
  type: "TSInstantiationExpression";
  expression: Expression;
  typeParameters: TSTypeParameterInstantiation | null;
}

interface TSAsExpression extends BaseNode {
  type: "TSAsExpression";
  expression: Expression;
  typeAnnotation: TSType;
}

interface TSSatisfiesExpression extends BaseNode {
  type: "TSSatisfiesExpression";
  expression: Expression;
  typeAnnotation: TSType;
}

interface TSTypeAssertion extends BaseNode {
  type: "TSTypeAssertion";
  typeAnnotation: TSType;
  expression: Expression;
}

interface TSEnumDeclaration extends BaseNode {
  type: "TSEnumDeclaration";
  id: Identifier;
  members: Array<TSEnumMember>;
  const: boolean | null;
  declare: boolean | null;
  initializer: Expression | null;
}

interface TSEnumMember extends BaseNode {
  type: "TSEnumMember";
  id: Identifier | StringLiteral;
  initializer: Expression | null;
}

interface TSModuleDeclaration extends BaseNode {
  type: "TSModuleDeclaration";
  id: Identifier | StringLiteral;
  body: TSModuleBlock | TSModuleDeclaration;
  declare: boolean | null;
  global: boolean | null;
}

interface TSModuleBlock extends BaseNode {
  type: "TSModuleBlock";
  body: Array<Statement>;
}

interface TSImportType extends BaseNode {
  type: "TSImportType";
  argument: StringLiteral;
  qualifier: TSEntityName | null;
  typeParameters: TSTypeParameterInstantiation | null;
  options: Expression | null;
}

interface TSImportEqualsDeclaration extends BaseNode {
  type: "TSImportEqualsDeclaration";
  id: Identifier;
  moduleReference: TSEntityName | TSExternalModuleReference;
  importKind: "type" | "value" | null;
  isExport: boolean;
}

interface TSExternalModuleReference extends BaseNode {
  type: "TSExternalModuleReference";
  expression: StringLiteral;
}

interface TSNonNullExpression extends BaseNode {
  type: "TSNonNullExpression";
  expression: Expression;
}

interface TSExportAssignment extends BaseNode {
  type: "TSExportAssignment";
  expression: Expression;
}

interface TSNamespaceExportDeclaration extends BaseNode {
  type: "TSNamespaceExportDeclaration";
  id: Identifier;
}

interface TSTypeAnnotation extends BaseNode {
  type: "TSTypeAnnotation";
  typeAnnotation: TSType;
}

interface TSTypeParameterInstantiation extends BaseNode {
  type: "TSTypeParameterInstantiation";
  params: Array<TSType>;
}

interface TSTypeParameterDeclaration extends BaseNode {
  type: "TSTypeParameterDeclaration";
  params: Array<TSTypeParameter>;
}

interface TSTypeParameter extends BaseNode {
  type: "TSTypeParameter";
  constraint: TSType | null;
  default: TSType | null;
  name: Identifier;
  const: boolean | null;
  in: boolean | null;
  out: boolean | null;
}

/**
 * @deprecated Use `NumericLiteral`
 */
type NumberLiteral = NumericLiteral;

/**
 * @deprecated Use `RegExpLiteral`
 */
type RegexLiteral = RegExpLiteral;

/**
 * @deprecated Use `RestElement`
 */
type RestProperty = RestElement;

/**
 * @deprecated Use `SpreadElement`
 */
type SpreadProperty = SpreadElement;

type Standardized = ArrayExpression | AssignmentExpression | BinaryExpression | InterpreterDirective | Directive | DirectiveLiteral | BlockStatement | BreakStatement | CallExpression | CatchClause | ConditionalExpression | ContinueStatement | DebuggerStatement | DoWhileStatement | EmptyStatement | ExpressionStatement | File | ForInStatement | ForStatement | FunctionDeclaration | FunctionExpression | Identifier | IfStatement | LabeledStatement | StringLiteral | NumericLiteral | NullLiteral | BooleanLiteral | RegExpLiteral | LogicalExpression | MemberExpression | NewExpression | Program | ObjectExpression | ObjectMethod | ObjectProperty | RestElement | ReturnStatement | SequenceExpression | ParenthesizedExpression | SwitchCase | SwitchStatement | ThisExpression | ThrowStatement | TryStatement | UnaryExpression | UpdateExpression | VariableDeclaration | VariableDeclarator | WhileStatement | WithStatement | AssignmentPattern | ArrayPattern | ArrowFunctionExpression | ClassBody | ClassExpression | ClassDeclaration | ExportAllDeclaration | ExportDefaultDeclaration | ExportNamedDeclaration | ExportSpecifier | ForOfStatement | ImportDeclaration | ImportDefaultSpecifier | ImportNamespaceSpecifier | ImportSpecifier | ImportExpression | MetaProperty | ClassMethod | ObjectPattern | SpreadElement | Super | TaggedTemplateExpression | TemplateElement | TemplateLiteral | YieldExpression | AwaitExpression | Import | BigIntLiteral | ExportNamespaceSpecifier | OptionalMemberExpression | OptionalCallExpression | ClassProperty | ClassAccessorProperty | ClassPrivateProperty | ClassPrivateMethod | PrivateName | StaticBlock;
type Expression = ArrayExpression | AssignmentExpression | BinaryExpression | CallExpression | ConditionalExpression | FunctionExpression | Identifier | StringLiteral | NumericLiteral | NullLiteral | BooleanLiteral | RegExpLiteral | LogicalExpression | MemberExpression | NewExpression | ObjectExpression | SequenceExpression | ParenthesizedExpression | ThisExpression | UnaryExpression | UpdateExpression | ArrowFunctionExpression | ClassExpression | ImportExpression | MetaProperty | TaggedTemplateExpression | TemplateLiteral | YieldExpression | AwaitExpression | Import | BigIntLiteral | OptionalMemberExpression | OptionalCallExpression | TypeCastExpression | JSXElement | JSXFragment | BindExpression | DoExpression | RecordExpression | TupleExpression | DecimalLiteral | ModuleExpression | TopicReference | PipelineTopicExpression | PipelineBareFunction | PipelinePrimaryTopicReference | TSInstantiationExpression | TSAsExpression | TSSatisfiesExpression | TSTypeAssertion | TSNonNullExpression;
type Binary = BinaryExpression | LogicalExpression;
type Scopable = BlockStatement | CatchClause | DoWhileStatement | ForInStatement | ForStatement | FunctionDeclaration | FunctionExpression | Program | ObjectMethod | SwitchStatement | WhileStatement | ArrowFunctionExpression | ClassExpression | ClassDeclaration | ForOfStatement | ClassMethod | ClassPrivateMethod | StaticBlock | TSModuleBlock;
type BlockParent = BlockStatement | CatchClause | DoWhileStatement | ForInStatement | ForStatement | FunctionDeclaration | FunctionExpression | Program | ObjectMethod | SwitchStatement | WhileStatement | ArrowFunctionExpression | ForOfStatement | ClassMethod | ClassPrivateMethod | StaticBlock | TSModuleBlock;
type Block = BlockStatement | Program | TSModuleBlock;
type Statement = BlockStatement | BreakStatement | ContinueStatement | DebuggerStatement | DoWhileStatement | EmptyStatement | ExpressionStatement | ForInStatement | ForStatement | FunctionDeclaration | IfStatement | LabeledStatement | ReturnStatement | SwitchStatement | ThrowStatement | TryStatement | VariableDeclaration | WhileStatement | WithStatement | ClassDeclaration | ExportAllDeclaration | ExportDefaultDeclaration | ExportNamedDeclaration | ForOfStatement | ImportDeclaration | DeclareClass | DeclareFunction | DeclareInterface | DeclareModule | DeclareModuleExports | DeclareTypeAlias | DeclareOpaqueType | DeclareVariable | DeclareExportDeclaration | DeclareExportAllDeclaration | InterfaceDeclaration | OpaqueType | TypeAlias | EnumDeclaration | TSDeclareFunction | TSInterfaceDeclaration | TSTypeAliasDeclaration | TSEnumDeclaration | TSModuleDeclaration | TSImportEqualsDeclaration | TSExportAssignment | TSNamespaceExportDeclaration;
type Terminatorless = BreakStatement | ContinueStatement | ReturnStatement | ThrowStatement | YieldExpression | AwaitExpression;
type CompletionStatement = BreakStatement | ContinueStatement | ReturnStatement | ThrowStatement;
type Conditional = ConditionalExpression | IfStatement;
type Loop = DoWhileStatement | ForInStatement | ForStatement | WhileStatement | ForOfStatement;
type While = DoWhileStatement | WhileStatement;
type ExpressionWrapper = ExpressionStatement | ParenthesizedExpression | TypeCastExpression;
type For = ForInStatement | ForStatement | ForOfStatement;
type ForXStatement = ForInStatement | ForOfStatement;
type Function = FunctionDeclaration | FunctionExpression | ObjectMethod | ArrowFunctionExpression | ClassMethod | ClassPrivateMethod;
type FunctionParent = FunctionDeclaration | FunctionExpression | ObjectMethod | ArrowFunctionExpression | ClassMethod | ClassPrivateMethod | StaticBlock | TSModuleBlock;
type Pureish = FunctionDeclaration | FunctionExpression | StringLiteral | NumericLiteral | NullLiteral | BooleanLiteral | RegExpLiteral | ArrowFunctionExpression | BigIntLiteral | DecimalLiteral;
type Declaration = FunctionDeclaration | VariableDeclaration | ClassDeclaration | ExportAllDeclaration | ExportDefaultDeclaration | ExportNamedDeclaration | ImportDeclaration | DeclareClass | DeclareFunction | DeclareInterface | DeclareModule | DeclareModuleExports | DeclareTypeAlias | DeclareOpaqueType | DeclareVariable | DeclareExportDeclaration | DeclareExportAllDeclaration | InterfaceDeclaration | OpaqueType | TypeAlias | EnumDeclaration | TSDeclareFunction | TSInterfaceDeclaration | TSTypeAliasDeclaration | TSEnumDeclaration | TSModuleDeclaration;
type PatternLike = Identifier | RestElement | AssignmentPattern | ArrayPattern | ObjectPattern | TSAsExpression | TSSatisfiesExpression | TSTypeAssertion | TSNonNullExpression;
type LVal = Identifier | MemberExpression | RestElement | AssignmentPattern | ArrayPattern | ObjectPattern | TSParameterProperty | TSAsExpression | TSSatisfiesExpression | TSTypeAssertion | TSNonNullExpression;
type TSEntityName = Identifier | TSQualifiedName;
type Literal = StringLiteral | NumericLiteral | NullLiteral | BooleanLiteral | RegExpLiteral | TemplateLiteral | BigIntLiteral | DecimalLiteral;
type Immutable = StringLiteral | NumericLiteral | NullLiteral | BooleanLiteral | BigIntLiteral | JSXAttribute | JSXClosingElement | JSXElement | JSXExpressionContainer | JSXSpreadChild | JSXOpeningElement | JSXText | JSXFragment | JSXOpeningFragment | JSXClosingFragment | DecimalLiteral;
type UserWhitespacable = ObjectMethod | ObjectProperty | ObjectTypeInternalSlot | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeProperty | ObjectTypeSpreadProperty;
type Method = ObjectMethod | ClassMethod | ClassPrivateMethod;
type ObjectMember = ObjectMethod | ObjectProperty;
type Property = ObjectProperty | ClassProperty | ClassAccessorProperty | ClassPrivateProperty;
type UnaryLike = UnaryExpression | SpreadElement;
type Pattern = AssignmentPattern | ArrayPattern | ObjectPattern;
type Class = ClassExpression | ClassDeclaration;
type ImportOrExportDeclaration = ExportAllDeclaration | ExportDefaultDeclaration | ExportNamedDeclaration | ImportDeclaration;
type ExportDeclaration = ExportAllDeclaration | ExportDefaultDeclaration | ExportNamedDeclaration;
type ModuleSpecifier = ExportSpecifier | ImportDefaultSpecifier | ImportNamespaceSpecifier | ImportSpecifier | ExportNamespaceSpecifier | ExportDefaultSpecifier;
type Accessor = ClassAccessorProperty;
type Private = ClassPrivateProperty | ClassPrivateMethod | PrivateName;
type Flow = AnyTypeAnnotation | ArrayTypeAnnotation | BooleanTypeAnnotation | BooleanLiteralTypeAnnotation | NullLiteralTypeAnnotation | ClassImplements | DeclareClass | DeclareFunction | DeclareInterface | DeclareModule | DeclareModuleExports | DeclareTypeAlias | DeclareOpaqueType | DeclareVariable | DeclareExportDeclaration | DeclareExportAllDeclaration | DeclaredPredicate | ExistsTypeAnnotation | FunctionTypeAnnotation | FunctionTypeParam | GenericTypeAnnotation | InferredPredicate | InterfaceExtends | InterfaceDeclaration | InterfaceTypeAnnotation | IntersectionTypeAnnotation | MixedTypeAnnotation | EmptyTypeAnnotation | NullableTypeAnnotation | NumberLiteralTypeAnnotation | NumberTypeAnnotation | ObjectTypeAnnotation | ObjectTypeInternalSlot | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | QualifiedTypeIdentifier | StringLiteralTypeAnnotation | StringTypeAnnotation | SymbolTypeAnnotation | ThisTypeAnnotation | TupleTypeAnnotation | TypeofTypeAnnotation | TypeAlias | TypeAnnotation | TypeCastExpression | TypeParameter | TypeParameterDeclaration | TypeParameterInstantiation | UnionTypeAnnotation | Variance | VoidTypeAnnotation | EnumDeclaration | EnumBooleanBody | EnumNumberBody | EnumStringBody | EnumSymbolBody | EnumBooleanMember | EnumNumberMember | EnumStringMember | EnumDefaultedMember | IndexedAccessType | OptionalIndexedAccessType;
type FlowType = AnyTypeAnnotation | ArrayTypeAnnotation | BooleanTypeAnnotation | BooleanLiteralTypeAnnotation | NullLiteralTypeAnnotation | ExistsTypeAnnotation | FunctionTypeAnnotation | GenericTypeAnnotation | InterfaceTypeAnnotation | IntersectionTypeAnnotation | MixedTypeAnnotation | EmptyTypeAnnotation | NullableTypeAnnotation | NumberLiteralTypeAnnotation | NumberTypeAnnotation | ObjectTypeAnnotation | StringLiteralTypeAnnotation | StringTypeAnnotation | SymbolTypeAnnotation | ThisTypeAnnotation | TupleTypeAnnotation | TypeofTypeAnnotation | UnionTypeAnnotation | VoidTypeAnnotation | IndexedAccessType | OptionalIndexedAccessType;
type FlowBaseAnnotation = AnyTypeAnnotation | BooleanTypeAnnotation | NullLiteralTypeAnnotation | MixedTypeAnnotation | EmptyTypeAnnotation | NumberTypeAnnotation | StringTypeAnnotation | SymbolTypeAnnotation | ThisTypeAnnotation | VoidTypeAnnotation;
type FlowDeclaration = DeclareClass | DeclareFunction | DeclareInterface | DeclareModule | DeclareModuleExports | DeclareTypeAlias | DeclareOpaqueType | DeclareVariable | DeclareExportDeclaration | DeclareExportAllDeclaration | InterfaceDeclaration | OpaqueType | TypeAlias;
type FlowPredicate = DeclaredPredicate | InferredPredicate;
type EnumBody = EnumBooleanBody | EnumNumberBody | EnumStringBody | EnumSymbolBody;
type EnumMember = EnumBooleanMember | EnumNumberMember | EnumStringMember | EnumDefaultedMember;
type JSX = JSXAttribute | JSXClosingElement | JSXElement | JSXEmptyExpression | JSXExpressionContainer | JSXSpreadChild | JSXIdentifier | JSXMemberExpression | JSXNamespacedName | JSXOpeningElement | JSXSpreadAttribute | JSXText | JSXFragment | JSXOpeningFragment | JSXClosingFragment;
type Miscellaneous = Placeholder | V8IntrinsicIdentifier;
type TypeScript = TSParameterProperty | TSDeclareFunction | TSDeclareMethod | TSQualifiedName | TSCallSignatureDeclaration | TSConstructSignatureDeclaration | TSPropertySignature | TSMethodSignature | TSIndexSignature | TSAnyKeyword | TSBooleanKeyword | TSBigIntKeyword | TSIntrinsicKeyword | TSNeverKeyword | TSNullKeyword | TSNumberKeyword | TSObjectKeyword | TSStringKeyword | TSSymbolKeyword | TSUndefinedKeyword | TSUnknownKeyword | TSVoidKeyword | TSThisType | TSFunctionType | TSConstructorType | TSTypeReference | TSTypePredicate | TSTypeQuery | TSTypeLiteral | TSArrayType | TSTupleType | TSOptionalType | TSRestType | TSNamedTupleMember | TSUnionType | TSIntersectionType | TSConditionalType | TSInferType | TSParenthesizedType | TSTypeOperator | TSIndexedAccessType | TSMappedType | TSLiteralType | TSExpressionWithTypeArguments | TSInterfaceDeclaration | TSInterfaceBody | TSTypeAliasDeclaration | TSInstantiationExpression | TSAsExpression | TSSatisfiesExpression | TSTypeAssertion | TSEnumDeclaration | TSEnumMember | TSModuleDeclaration | TSModuleBlock | TSImportType | TSImportEqualsDeclaration | TSExternalModuleReference | TSNonNullExpression | TSExportAssignment | TSNamespaceExportDeclaration | TSTypeAnnotation | TSTypeParameterInstantiation | TSTypeParameterDeclaration | TSTypeParameter;
type TSTypeElement = TSCallSignatureDeclaration | TSConstructSignatureDeclaration | TSPropertySignature | TSMethodSignature | TSIndexSignature;
type TSType = TSAnyKeyword | TSBooleanKeyword | TSBigIntKeyword | TSIntrinsicKeyword | TSNeverKeyword | TSNullKeyword | TSNumberKeyword | TSObjectKeyword | TSStringKeyword | TSSymbolKeyword | TSUndefinedKeyword | TSUnknownKeyword | TSVoidKeyword | TSThisType | TSFunctionType | TSConstructorType | TSTypeReference | TSTypePredicate | TSTypeQuery | TSTypeLiteral | TSArrayType | TSTupleType | TSOptionalType | TSRestType | TSUnionType | TSIntersectionType | TSConditionalType | TSInferType | TSParenthesizedType | TSTypeOperator | TSIndexedAccessType | TSMappedType | TSLiteralType | TSExpressionWithTypeArguments | TSImportType;
type TSBaseType = TSAnyKeyword | TSBooleanKeyword | TSBigIntKeyword | TSIntrinsicKeyword | TSNeverKeyword | TSNullKeyword | TSNumberKeyword | TSObjectKeyword | TSStringKeyword | TSSymbolKeyword | TSUndefinedKeyword | TSUnknownKeyword | TSVoidKeyword | TSThisType | TSLiteralType;
type ModuleDeclaration = ExportAllDeclaration | ExportDefaultDeclaration | ExportNamedDeclaration | ImportDeclaration;

interface Aliases {
  Standardized: Standardized;
  Expression: Expression;
  Binary: Binary;
  Scopable: Scopable;
  BlockParent: BlockParent;
  Block: Block;
  Statement: Statement;
  Terminatorless: Terminatorless;
  CompletionStatement: CompletionStatement;
  Conditional: Conditional;
  Loop: Loop;
  While: While;
  ExpressionWrapper: ExpressionWrapper;
  For: For;
  ForXStatement: ForXStatement;
  Function: Function;
  FunctionParent: FunctionParent;
  Pureish: Pureish;
  Declaration: Declaration;
  PatternLike: PatternLike;
  LVal: LVal;
  TSEntityName: TSEntityName;
  Literal: Literal;
  Immutable: Immutable;
  UserWhitespacable: UserWhitespacable;
  Method: Method;
  ObjectMember: ObjectMember;
  Property: Property;
  UnaryLike: UnaryLike;
  Pattern: Pattern;
  Class: Class;
  ImportOrExportDeclaration: ImportOrExportDeclaration;
  ExportDeclaration: ExportDeclaration;
  ModuleSpecifier: ModuleSpecifier;
  Accessor: Accessor;
  Private: Private;
  Flow: Flow;
  FlowType: FlowType;
  FlowBaseAnnotation: FlowBaseAnnotation;
  FlowDeclaration: FlowDeclaration;
  FlowPredicate: FlowPredicate;
  EnumBody: EnumBody;
  EnumMember: EnumMember;
  JSX: JSX;
  Miscellaneous: Miscellaneous;
  TypeScript: TypeScript;
  TSTypeElement: TSTypeElement;
  TSType: TSType;
  TSBaseType: TSBaseType;
  ModuleDeclaration: ModuleDeclaration;
}

declare function arrayExpression(elements?: Array<null | Expression | SpreadElement>): ArrayExpression;
declare function assignmentExpression(operator: string, left: LVal | OptionalMemberExpression, right: Expression): AssignmentExpression;
declare function binaryExpression(operator: "+" | "-" | "/" | "%" | "*" | "**" | "&" | "|" | ">>" | ">>>" | "<<" | "^" | "==" | "===" | "!=" | "!==" | "in" | "instanceof" | ">" | "<" | ">=" | "<=" | "|>", left: Expression | PrivateName, right: Expression): BinaryExpression;
declare function interpreterDirective(value: string): InterpreterDirective;
declare function directive(value: DirectiveLiteral): Directive;
declare function directiveLiteral(value: string): DirectiveLiteral;
declare function blockStatement(body: Array<Statement>, directives?: Array<Directive>): BlockStatement;
declare function breakStatement(label?: Identifier | null): BreakStatement;
declare function callExpression(callee: Expression | Super | V8IntrinsicIdentifier, _arguments: Array<Expression | SpreadElement | JSXNamespacedName | ArgumentPlaceholder>): CallExpression;
declare function catchClause(param: Identifier | ArrayPattern | ObjectPattern | null | undefined, body: BlockStatement): CatchClause;
declare function conditionalExpression(test: Expression, consequent: Expression, alternate: Expression): ConditionalExpression;
declare function continueStatement(label?: Identifier | null): ContinueStatement;
declare function debuggerStatement(): DebuggerStatement;
declare function doWhileStatement(test: Expression, body: Statement): DoWhileStatement;
declare function emptyStatement(): EmptyStatement;
declare function expressionStatement(expression: Expression): ExpressionStatement;
declare function file(program: Program, comments?: Array<CommentBlock | CommentLine> | null, tokens?: Array<any> | null): File;
declare function forInStatement(left: VariableDeclaration | LVal, right: Expression, body: Statement): ForInStatement;
declare function forStatement(init: VariableDeclaration | Expression | null | undefined, test: Expression | null | undefined, update: Expression | null | undefined, body: Statement): ForStatement;
declare function functionDeclaration(id: Identifier | null | undefined, params: Array<Identifier | Pattern | RestElement>, body: BlockStatement, generator?: boolean, async?: boolean): FunctionDeclaration;
declare function functionExpression(id: Identifier | null | undefined, params: Array<Identifier | Pattern | RestElement>, body: BlockStatement, generator?: boolean, async?: boolean): FunctionExpression;
declare function identifier(name: string): Identifier;
declare function ifStatement(test: Expression, consequent: Statement, alternate?: Statement | null): IfStatement;
declare function labeledStatement(label: Identifier, body: Statement): LabeledStatement;
declare function stringLiteral(value: string): StringLiteral;
declare function numericLiteral(value: number): NumericLiteral;
declare function nullLiteral(): NullLiteral;
declare function booleanLiteral(value: boolean): BooleanLiteral;
declare function regExpLiteral(pattern: string, flags?: string): RegExpLiteral;
declare function logicalExpression(operator: "||" | "&&" | "??", left: Expression, right: Expression): LogicalExpression;
declare function memberExpression(object: Expression | Super, property: Expression | Identifier | PrivateName, computed?: boolean, optional?: true | false | null): MemberExpression;
declare function newExpression(callee: Expression | Super | V8IntrinsicIdentifier, _arguments: Array<Expression | SpreadElement | JSXNamespacedName | ArgumentPlaceholder>): NewExpression;
declare function program(body: Array<Statement>, directives?: Array<Directive>, sourceType?: "script" | "module", interpreter?: InterpreterDirective | null): Program;
declare function objectExpression(properties: Array<ObjectMethod | ObjectProperty | SpreadElement>): ObjectExpression;
declare function objectMethod(kind: "method" | "get" | "set" | undefined, key: Expression | Identifier | StringLiteral | NumericLiteral | BigIntLiteral, params: Array<Identifier | Pattern | RestElement>, body: BlockStatement, computed?: boolean, generator?: boolean, async?: boolean): ObjectMethod;
declare function objectProperty(key: Expression | Identifier | StringLiteral | NumericLiteral | BigIntLiteral | DecimalLiteral | PrivateName, value: Expression | PatternLike, computed?: boolean, shorthand?: boolean, decorators?: Array<Decorator> | null): ObjectProperty;
declare function restElement(argument: LVal): RestElement;
declare function returnStatement(argument?: Expression | null): ReturnStatement;
declare function sequenceExpression(expressions: Array<Expression>): SequenceExpression;
declare function parenthesizedExpression(expression: Expression): ParenthesizedExpression;
declare function switchCase(test: Expression | null | undefined, consequent: Array<Statement>): SwitchCase;
declare function switchStatement(discriminant: Expression, cases: Array<SwitchCase>): SwitchStatement;
declare function thisExpression(): ThisExpression;
declare function throwStatement(argument: Expression): ThrowStatement;
declare function tryStatement(block: BlockStatement, handler?: CatchClause | null, finalizer?: BlockStatement | null): TryStatement;
declare function unaryExpression(operator: "void" | "throw" | "delete" | "!" | "+" | "-" | "~" | "typeof", argument: Expression, prefix?: boolean): UnaryExpression;
declare function updateExpression(operator: "++" | "--", argument: Expression, prefix?: boolean): UpdateExpression;
declare function variableDeclaration(kind: "var" | "let" | "const" | "using" | "await using", declarations: Array<VariableDeclarator>): VariableDeclaration;
declare function variableDeclarator(id: LVal, init?: Expression | null): VariableDeclarator;
declare function whileStatement(test: Expression, body: Statement): WhileStatement;
declare function withStatement(object: Expression, body: Statement): WithStatement;
declare function assignmentPattern(left: Identifier | ObjectPattern | ArrayPattern | MemberExpression | TSAsExpression | TSSatisfiesExpression | TSTypeAssertion | TSNonNullExpression, right: Expression): AssignmentPattern;
declare function arrayPattern(elements: Array<null | PatternLike | LVal>): ArrayPattern;
declare function arrowFunctionExpression(params: Array<Identifier | Pattern | RestElement>, body: BlockStatement | Expression, async?: boolean): ArrowFunctionExpression;
declare function classBody(body: Array<ClassMethod | ClassPrivateMethod | ClassProperty | ClassPrivateProperty | ClassAccessorProperty | TSDeclareMethod | TSIndexSignature | StaticBlock>): ClassBody;
declare function classExpression(id: Identifier | null | undefined, superClass: Expression | null | undefined, body: ClassBody, decorators?: Array<Decorator> | null): ClassExpression;
declare function classDeclaration(id: Identifier | null | undefined, superClass: Expression | null | undefined, body: ClassBody, decorators?: Array<Decorator> | null): ClassDeclaration;
declare function exportAllDeclaration(source: StringLiteral): ExportAllDeclaration;
declare function exportDefaultDeclaration(declaration: TSDeclareFunction | FunctionDeclaration | ClassDeclaration | Expression): ExportDefaultDeclaration;
declare function exportNamedDeclaration(declaration?: Declaration | null, specifiers?: Array<ExportSpecifier | ExportDefaultSpecifier | ExportNamespaceSpecifier>, source?: StringLiteral | null): ExportNamedDeclaration;
declare function exportSpecifier(local: Identifier, exported: Identifier | StringLiteral): ExportSpecifier;
declare function forOfStatement(left: VariableDeclaration | LVal, right: Expression, body: Statement, _await?: boolean): ForOfStatement;
declare function importDeclaration(specifiers: Array<ImportSpecifier | ImportDefaultSpecifier | ImportNamespaceSpecifier>, source: StringLiteral): ImportDeclaration;
declare function importDefaultSpecifier(local: Identifier): ImportDefaultSpecifier;
declare function importNamespaceSpecifier(local: Identifier): ImportNamespaceSpecifier;
declare function importSpecifier(local: Identifier, imported: Identifier | StringLiteral): ImportSpecifier;
declare function importExpression(source: Expression, options?: Expression | null): ImportExpression;
declare function metaProperty(meta: Identifier, property: Identifier): MetaProperty;
declare function classMethod(kind: "get" | "set" | "method" | "constructor" | undefined, key: Identifier | StringLiteral | NumericLiteral | BigIntLiteral | Expression, params: Array<Identifier | Pattern | RestElement | TSParameterProperty>, body: BlockStatement, computed?: boolean, _static?: boolean, generator?: boolean, async?: boolean): ClassMethod;
declare function objectPattern(properties: Array<RestElement | ObjectProperty>): ObjectPattern;
declare function spreadElement(argument: Expression): SpreadElement;
declare function _super(): Super;

declare function taggedTemplateExpression(tag: Expression, quasi: TemplateLiteral): TaggedTemplateExpression;
declare function templateElement(value: { raw: string, cooked?: string }, tail?: boolean): TemplateElement;
declare function templateLiteral(quasis: Array<TemplateElement>, expressions: Array<Expression | TSType>): TemplateLiteral;
declare function yieldExpression(argument?: Expression | null, delegate?: boolean): YieldExpression;
declare function awaitExpression(argument: Expression): AwaitExpression;
declare function _import(): Import;

declare function bigIntLiteral(value: string): BigIntLiteral;
declare function exportNamespaceSpecifier(exported: Identifier): ExportNamespaceSpecifier;
declare function optionalMemberExpression(object: Expression, property: Expression | Identifier, computed: boolean | undefined, optional: boolean): OptionalMemberExpression;
declare function optionalCallExpression(callee: Expression, _arguments: Array<Expression | SpreadElement | JSXNamespacedName | ArgumentPlaceholder>, optional: boolean): OptionalCallExpression;
declare function classProperty(key: Identifier | StringLiteral | NumericLiteral | BigIntLiteral | Expression, value?: Expression | null, typeAnnotation?: TypeAnnotation | TSTypeAnnotation | null, decorators?: Array<Decorator> | null, computed?: boolean, _static?: boolean): ClassProperty;
declare function classAccessorProperty(key: Identifier | StringLiteral | NumericLiteral | BigIntLiteral | Expression | PrivateName, value?: Expression | null, typeAnnotation?: TypeAnnotation | TSTypeAnnotation | null, decorators?: Array<Decorator> | null, computed?: boolean, _static?: boolean): ClassAccessorProperty;
declare function classPrivateProperty(key: PrivateName, value?: Expression | null, decorators?: Array<Decorator> | null, _static?: boolean): ClassPrivateProperty;
declare function classPrivateMethod(kind: "get" | "set" | "method" | undefined, key: PrivateName, params: Array<Identifier | Pattern | RestElement | TSParameterProperty>, body: BlockStatement, _static?: boolean): ClassPrivateMethod;
declare function privateName(id: Identifier): PrivateName;
declare function staticBlock(body: Array<Statement>): StaticBlock;
declare function anyTypeAnnotation(): AnyTypeAnnotation;
declare function arrayTypeAnnotation(elementType: FlowType): ArrayTypeAnnotation;
declare function booleanTypeAnnotation(): BooleanTypeAnnotation;
declare function booleanLiteralTypeAnnotation(value: boolean): BooleanLiteralTypeAnnotation;
declare function nullLiteralTypeAnnotation(): NullLiteralTypeAnnotation;
declare function classImplements(id: Identifier, typeParameters?: TypeParameterInstantiation | null): ClassImplements;
declare function declareClass(id: Identifier, typeParameters: TypeParameterDeclaration | null | undefined, _extends: Array<InterfaceExtends> | null | undefined, body: ObjectTypeAnnotation): DeclareClass;
declare function declareFunction(id: Identifier): DeclareFunction;
declare function declareInterface(id: Identifier, typeParameters: TypeParameterDeclaration | null | undefined, _extends: Array<InterfaceExtends> | null | undefined, body: ObjectTypeAnnotation): DeclareInterface;
declare function declareModule(id: Identifier | StringLiteral, body: BlockStatement, kind?: "CommonJS" | "ES" | null): DeclareModule;
declare function declareModuleExports(typeAnnotation: TypeAnnotation): DeclareModuleExports;
declare function declareTypeAlias(id: Identifier, typeParameters: TypeParameterDeclaration | null | undefined, right: FlowType): DeclareTypeAlias;
declare function declareOpaqueType(id: Identifier, typeParameters?: TypeParameterDeclaration | null, supertype?: FlowType | null): DeclareOpaqueType;
declare function declareVariable(id: Identifier): DeclareVariable;
declare function declareExportDeclaration(declaration?: Flow | null, specifiers?: Array<ExportSpecifier | ExportNamespaceSpecifier> | null, source?: StringLiteral | null): DeclareExportDeclaration;
declare function declareExportAllDeclaration(source: StringLiteral): DeclareExportAllDeclaration;
declare function declaredPredicate(value: Flow): DeclaredPredicate;
declare function existsTypeAnnotation(): ExistsTypeAnnotation;
declare function functionTypeAnnotation(typeParameters: TypeParameterDeclaration | null | undefined, params: Array<FunctionTypeParam>, rest: FunctionTypeParam | null | undefined, returnType: FlowType): FunctionTypeAnnotation;
declare function functionTypeParam(name: Identifier | null | undefined, typeAnnotation: FlowType): FunctionTypeParam;
declare function genericTypeAnnotation(id: Identifier | QualifiedTypeIdentifier, typeParameters?: TypeParameterInstantiation | null): GenericTypeAnnotation;
declare function inferredPredicate(): InferredPredicate;
declare function interfaceExtends(id: Identifier | QualifiedTypeIdentifier, typeParameters?: TypeParameterInstantiation | null): InterfaceExtends;
declare function interfaceDeclaration(id: Identifier, typeParameters: TypeParameterDeclaration | null | undefined, _extends: Array<InterfaceExtends> | null | undefined, body: ObjectTypeAnnotation): InterfaceDeclaration;
declare function interfaceTypeAnnotation(_extends: Array<InterfaceExtends> | null | undefined, body: ObjectTypeAnnotation): InterfaceTypeAnnotation;
declare function intersectionTypeAnnotation(types: Array<FlowType>): IntersectionTypeAnnotation;
declare function mixedTypeAnnotation(): MixedTypeAnnotation;
declare function emptyTypeAnnotation(): EmptyTypeAnnotation;
declare function nullableTypeAnnotation(typeAnnotation: FlowType): NullableTypeAnnotation;
declare function numberLiteralTypeAnnotation(value: number): NumberLiteralTypeAnnotation;
declare function numberTypeAnnotation(): NumberTypeAnnotation;
declare function objectTypeAnnotation(properties: Array<ObjectTypeProperty | ObjectTypeSpreadProperty>, indexers?: Array<ObjectTypeIndexer>, callProperties?: Array<ObjectTypeCallProperty>, internalSlots?: Array<ObjectTypeInternalSlot>, exact?: boolean): ObjectTypeAnnotation;
declare function objectTypeInternalSlot(id: Identifier, value: FlowType, optional: boolean, _static: boolean, method: boolean): ObjectTypeInternalSlot;
declare function objectTypeCallProperty(value: FlowType): ObjectTypeCallProperty;
declare function objectTypeIndexer(id: Identifier | null | undefined, key: FlowType, value: FlowType, variance?: Variance | null): ObjectTypeIndexer;
declare function objectTypeProperty(key: Identifier | StringLiteral, value: FlowType, variance?: Variance | null): ObjectTypeProperty;
declare function objectTypeSpreadProperty(argument: FlowType): ObjectTypeSpreadProperty;
declare function opaqueType(id: Identifier, typeParameters: TypeParameterDeclaration | null | undefined, supertype: FlowType | null | undefined, impltype: FlowType): OpaqueType;
declare function qualifiedTypeIdentifier(id: Identifier, qualification: Identifier | QualifiedTypeIdentifier): QualifiedTypeIdentifier;
declare function stringLiteralTypeAnnotation(value: string): StringLiteralTypeAnnotation;
declare function stringTypeAnnotation(): StringTypeAnnotation;
declare function symbolTypeAnnotation(): SymbolTypeAnnotation;
declare function thisTypeAnnotation(): ThisTypeAnnotation;
declare function tupleTypeAnnotation(types: Array<FlowType>): TupleTypeAnnotation;
declare function typeofTypeAnnotation(argument: FlowType): TypeofTypeAnnotation;
declare function typeAlias(id: Identifier, typeParameters: TypeParameterDeclaration | null | undefined, right: FlowType): TypeAlias;
declare function typeAnnotation(typeAnnotation: FlowType): TypeAnnotation;
declare function typeCastExpression(expression: Expression, typeAnnotation: TypeAnnotation): TypeCastExpression;
declare function typeParameter(bound?: TypeAnnotation | null, _default?: FlowType | null, variance?: Variance | null): TypeParameter;
declare function typeParameterDeclaration(params: Array<TypeParameter>): TypeParameterDeclaration;
declare function typeParameterInstantiation(params: Array<FlowType>): TypeParameterInstantiation;
declare function unionTypeAnnotation(types: Array<FlowType>): UnionTypeAnnotation;
declare function variance(kind: "minus" | "plus"): Variance;
declare function voidTypeAnnotation(): VoidTypeAnnotation;
declare function enumDeclaration(id: Identifier, body: EnumBooleanBody | EnumNumberBody | EnumStringBody | EnumSymbolBody): EnumDeclaration;
declare function enumBooleanBody(members: Array<EnumBooleanMember>): EnumBooleanBody;
declare function enumNumberBody(members: Array<EnumNumberMember>): EnumNumberBody;
declare function enumStringBody(members: Array<EnumStringMember | EnumDefaultedMember>): EnumStringBody;
declare function enumSymbolBody(members: Array<EnumDefaultedMember>): EnumSymbolBody;
declare function enumBooleanMember(id: Identifier): EnumBooleanMember;
declare function enumNumberMember(id: Identifier, init: NumericLiteral): EnumNumberMember;
declare function enumStringMember(id: Identifier, init: StringLiteral): EnumStringMember;
declare function enumDefaultedMember(id: Identifier): EnumDefaultedMember;
declare function indexedAccessType(objectType: FlowType, indexType: FlowType): IndexedAccessType;
declare function optionalIndexedAccessType(objectType: FlowType, indexType: FlowType): OptionalIndexedAccessType;
declare function jsxAttribute(name: JSXIdentifier | JSXNamespacedName, value?: JSXElement | JSXFragment | StringLiteral | JSXExpressionContainer | null): JSXAttribute;
declare function jsxClosingElement(name: JSXIdentifier | JSXMemberExpression | JSXNamespacedName): JSXClosingElement;
declare function jsxElement(openingElement: JSXOpeningElement, closingElement: JSXClosingElement | null | undefined, children: Array<JSXText | JSXExpressionContainer | JSXSpreadChild | JSXElement | JSXFragment>): JSXElement;
declare function jsxEmptyExpression(): JSXEmptyExpression;
declare function jsxExpressionContainer(expression: Expression | JSXEmptyExpression): JSXExpressionContainer;
declare function jsxSpreadChild(expression: Expression): JSXSpreadChild;
declare function jsxIdentifier(name: string): JSXIdentifier;
declare function jsxMemberExpression(object: JSXMemberExpression | JSXIdentifier, property: JSXIdentifier): JSXMemberExpression;
declare function jsxNamespacedName(namespace: JSXIdentifier, name: JSXIdentifier): JSXNamespacedName;
declare function jsxOpeningElement(name: JSXIdentifier | JSXMemberExpression | JSXNamespacedName, attributes: Array<JSXAttribute | JSXSpreadAttribute>, selfClosing?: boolean): JSXOpeningElement;
declare function jsxSpreadAttribute(argument: Expression): JSXSpreadAttribute;
declare function jsxText(value: string): JSXText;
declare function jsxFragment(openingFragment: JSXOpeningFragment, closingFragment: JSXClosingFragment, children: Array<JSXText | JSXExpressionContainer | JSXSpreadChild | JSXElement | JSXFragment>): JSXFragment;
declare function jsxOpeningFragment(): JSXOpeningFragment;
declare function jsxClosingFragment(): JSXClosingFragment;
declare function placeholder(expectedNode: "Identifier" | "StringLiteral" | "Expression" | "Statement" | "Declaration" | "BlockStatement" | "ClassBody" | "Pattern", name: Identifier): Placeholder;
declare function v8IntrinsicIdentifier(name: string): V8IntrinsicIdentifier;
declare function argumentPlaceholder(): ArgumentPlaceholder;
declare function bindExpression(object: Expression, callee: Expression): BindExpression;
declare function importAttribute(key: Identifier | StringLiteral, value: StringLiteral): ImportAttribute;
declare function decorator(expression: Expression): Decorator;
declare function doExpression(body: BlockStatement, async?: boolean): DoExpression;
declare function exportDefaultSpecifier(exported: Identifier): ExportDefaultSpecifier;
declare function recordExpression(properties: Array<ObjectProperty | SpreadElement>): RecordExpression;
declare function tupleExpression(elements?: Array<Expression | SpreadElement>): TupleExpression;
declare function decimalLiteral(value: string): DecimalLiteral;
declare function moduleExpression(body: Program): ModuleExpression;
declare function topicReference(): TopicReference;
declare function pipelineTopicExpression(expression: Expression): PipelineTopicExpression;
declare function pipelineBareFunction(callee: Expression): PipelineBareFunction;
declare function pipelinePrimaryTopicReference(): PipelinePrimaryTopicReference;
declare function tsParameterProperty(parameter: Identifier | AssignmentPattern): TSParameterProperty;
declare function tsDeclareFunction(id: Identifier | null | undefined, typeParameters: TSTypeParameterDeclaration | null | undefined, params: Array<Identifier | Pattern | RestElement>, returnType?: TSTypeAnnotation | null): TSDeclareFunction;
declare function tsDeclareMethod(decorators: Array<Decorator> | null | undefined, key: Identifier | StringLiteral | NumericLiteral | BigIntLiteral | Expression, typeParameters: TSTypeParameterDeclaration | null | undefined, params: Array<Identifier | Pattern | RestElement | TSParameterProperty>, returnType?: TSTypeAnnotation | null): TSDeclareMethod;
declare function tsQualifiedName(left: TSEntityName, right: Identifier): TSQualifiedName;
declare function tsCallSignatureDeclaration(typeParameters: TSTypeParameterDeclaration | null | undefined, params: Array<ArrayPattern | Identifier | ObjectPattern | RestElement>, returnType?: TSTypeAnnotation | null): TSCallSignatureDeclaration;
declare function tsConstructSignatureDeclaration(typeParameters: TSTypeParameterDeclaration | null | undefined, params: Array<ArrayPattern | Identifier | ObjectPattern | RestElement>, returnType?: TSTypeAnnotation | null): TSConstructSignatureDeclaration;
declare function tsPropertySignature(key: Expression, typeAnnotation?: TSTypeAnnotation | null): TSPropertySignature;
declare function tsMethodSignature(key: Expression, typeParameters: TSTypeParameterDeclaration | null | undefined, params: Array<ArrayPattern | Identifier | ObjectPattern | RestElement>, returnType?: TSTypeAnnotation | null): TSMethodSignature;
declare function tsIndexSignature(parameters: Array<Identifier>, typeAnnotation?: TSTypeAnnotation | null): TSIndexSignature;
declare function tsAnyKeyword(): TSAnyKeyword;
declare function tsBooleanKeyword(): TSBooleanKeyword;
declare function tsBigIntKeyword(): TSBigIntKeyword;
declare function tsIntrinsicKeyword(): TSIntrinsicKeyword;
declare function tsNeverKeyword(): TSNeverKeyword;
declare function tsNullKeyword(): TSNullKeyword;
declare function tsNumberKeyword(): TSNumberKeyword;
declare function tsObjectKeyword(): TSObjectKeyword;
declare function tsStringKeyword(): TSStringKeyword;
declare function tsSymbolKeyword(): TSSymbolKeyword;
declare function tsUndefinedKeyword(): TSUndefinedKeyword;
declare function tsUnknownKeyword(): TSUnknownKeyword;
declare function tsVoidKeyword(): TSVoidKeyword;
declare function tsThisType(): TSThisType;
declare function tsFunctionType(typeParameters: TSTypeParameterDeclaration | null | undefined, params: Array<ArrayPattern | Identifier | ObjectPattern | RestElement>, returnType?: TSTypeAnnotation | null): TSFunctionType;
declare function tsConstructorType(typeParameters: TSTypeParameterDeclaration | null | undefined, params: Array<ArrayPattern | Identifier | ObjectPattern | RestElement>, returnType?: TSTypeAnnotation | null): TSConstructorType;
declare function tsTypeReference(typeName: TSEntityName, typeParameters?: TSTypeParameterInstantiation | null): TSTypeReference;
declare function tsTypePredicate(parameterName: Identifier | TSThisType, typeAnnotation?: TSTypeAnnotation | null, asserts?: boolean | null): TSTypePredicate;
declare function tsTypeQuery(exprName: TSEntityName | TSImportType, typeParameters?: TSTypeParameterInstantiation | null): TSTypeQuery;
declare function tsTypeLiteral(members: Array<TSTypeElement>): TSTypeLiteral;
declare function tsArrayType(elementType: TSType): TSArrayType;
declare function tsTupleType(elementTypes: Array<TSType | TSNamedTupleMember>): TSTupleType;
declare function tsOptionalType(typeAnnotation: TSType): TSOptionalType;
declare function tsRestType(typeAnnotation: TSType): TSRestType;
declare function tsNamedTupleMember(label: Identifier, elementType: TSType, optional?: boolean): TSNamedTupleMember;
declare function tsUnionType(types: Array<TSType>): TSUnionType;
declare function tsIntersectionType(types: Array<TSType>): TSIntersectionType;
declare function tsConditionalType(checkType: TSType, extendsType: TSType, trueType: TSType, falseType: TSType): TSConditionalType;
declare function tsInferType(typeParameter: TSTypeParameter): TSInferType;
declare function tsParenthesizedType(typeAnnotation: TSType): TSParenthesizedType;
declare function tsTypeOperator(typeAnnotation: TSType): TSTypeOperator;
declare function tsIndexedAccessType(objectType: TSType, indexType: TSType): TSIndexedAccessType;
declare function tsMappedType(typeParameter: TSTypeParameter, typeAnnotation?: TSType | null, nameType?: TSType | null): TSMappedType;
declare function tsLiteralType(literal: NumericLiteral | StringLiteral | BooleanLiteral | BigIntLiteral | TemplateLiteral | UnaryExpression): TSLiteralType;
declare function tsExpressionWithTypeArguments(expression: TSEntityName, typeParameters?: TSTypeParameterInstantiation | null): TSExpressionWithTypeArguments;
declare function tsInterfaceDeclaration(id: Identifier, typeParameters: TSTypeParameterDeclaration | null | undefined, _extends: Array<TSExpressionWithTypeArguments> | null | undefined, body: TSInterfaceBody): TSInterfaceDeclaration;
declare function tsInterfaceBody(body: Array<TSTypeElement>): TSInterfaceBody;
declare function tsTypeAliasDeclaration(id: Identifier, typeParameters: TSTypeParameterDeclaration | null | undefined, typeAnnotation: TSType): TSTypeAliasDeclaration;
declare function tsInstantiationExpression(expression: Expression, typeParameters?: TSTypeParameterInstantiation | null): TSInstantiationExpression;
declare function tsAsExpression(expression: Expression, typeAnnotation: TSType): TSAsExpression;
declare function tsSatisfiesExpression(expression: Expression, typeAnnotation: TSType): TSSatisfiesExpression;
declare function tsTypeAssertion(typeAnnotation: TSType, expression: Expression): TSTypeAssertion;
declare function tsEnumDeclaration(id: Identifier, members: Array<TSEnumMember>): TSEnumDeclaration;
declare function tsEnumMember(id: Identifier | StringLiteral, initializer?: Expression | null): TSEnumMember;
declare function tsModuleDeclaration(id: Identifier | StringLiteral, body: TSModuleBlock | TSModuleDeclaration): TSModuleDeclaration;
declare function tsModuleBlock(body: Array<Statement>): TSModuleBlock;
declare function tsImportType(argument: StringLiteral, qualifier?: TSEntityName | null, typeParameters?: TSTypeParameterInstantiation | null): TSImportType;
declare function tsImportEqualsDeclaration(id: Identifier, moduleReference: TSEntityName | TSExternalModuleReference): TSImportEqualsDeclaration;
declare function tsExternalModuleReference(expression: StringLiteral): TSExternalModuleReference;
declare function tsNonNullExpression(expression: Expression): TSNonNullExpression;
declare function tsExportAssignment(expression: Expression): TSExportAssignment;
declare function tsNamespaceExportDeclaration(id: Identifier): TSNamespaceExportDeclaration;
declare function tsTypeAnnotation(typeAnnotation: TSType): TSTypeAnnotation;
declare function tsTypeParameterInstantiation(params: Array<TSType>): TSTypeParameterInstantiation;
declare function tsTypeParameterDeclaration(params: Array<TSTypeParameter>): TSTypeParameterDeclaration;
declare function tsTypeParameter(constraint: TSType | null | undefined, _default: TSType | null | undefined, name: Identifier): TSTypeParameter;
declare function isAccessor(node: object | null | undefined, opts?: object | null): node is Accessor;
declare function assertAccessor(node: object | null | undefined, opts?: object | null): void;
declare function isAnyTypeAnnotation(node: object | null | undefined, opts?: object | null): node is AnyTypeAnnotation;
declare function assertAnyTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isArgumentPlaceholder(node: object | null | undefined, opts?: object | null): node is ArgumentPlaceholder;
declare function assertArgumentPlaceholder(node: object | null | undefined, opts?: object | null): void;
declare function isArrayExpression(node: object | null | undefined, opts?: object | null): node is ArrayExpression;
declare function assertArrayExpression(node: object | null | undefined, opts?: object | null): void;
declare function isArrayPattern(node: object | null | undefined, opts?: object | null): node is ArrayPattern;
declare function assertArrayPattern(node: object | null | undefined, opts?: object | null): void;
declare function isArrayTypeAnnotation(node: object | null | undefined, opts?: object | null): node is ArrayTypeAnnotation;
declare function assertArrayTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isArrowFunctionExpression(node: object | null | undefined, opts?: object | null): node is ArrowFunctionExpression;
declare function assertArrowFunctionExpression(node: object | null | undefined, opts?: object | null): void;
declare function isAssignmentExpression(node: object | null | undefined, opts?: object | null): node is AssignmentExpression;
declare function assertAssignmentExpression(node: object | null | undefined, opts?: object | null): void;
declare function isAssignmentPattern(node: object | null | undefined, opts?: object | null): node is AssignmentPattern;
declare function assertAssignmentPattern(node: object | null | undefined, opts?: object | null): void;
declare function isAwaitExpression(node: object | null | undefined, opts?: object | null): node is AwaitExpression;
declare function assertAwaitExpression(node: object | null | undefined, opts?: object | null): void;
declare function isBigIntLiteral(node: object | null | undefined, opts?: object | null): node is BigIntLiteral;
declare function assertBigIntLiteral(node: object | null | undefined, opts?: object | null): void;
declare function isBinary(node: object | null | undefined, opts?: object | null): node is Binary;
declare function assertBinary(node: object | null | undefined, opts?: object | null): void;
declare function isBinaryExpression(node: object | null | undefined, opts?: object | null): node is BinaryExpression;
declare function assertBinaryExpression(node: object | null | undefined, opts?: object | null): void;
declare function isBindExpression(node: object | null | undefined, opts?: object | null): node is BindExpression;
declare function assertBindExpression(node: object | null | undefined, opts?: object | null): void;
declare function isBlock(node: object | null | undefined, opts?: object | null): node is Block;
declare function assertBlock(node: object | null | undefined, opts?: object | null): void;
declare function isBlockParent(node: object | null | undefined, opts?: object | null): node is BlockParent;
declare function assertBlockParent(node: object | null | undefined, opts?: object | null): void;
declare function isBlockStatement(node: object | null | undefined, opts?: object | null): node is BlockStatement;
declare function assertBlockStatement(node: object | null | undefined, opts?: object | null): void;
declare function isBooleanLiteral(node: object | null | undefined, opts?: object | null): node is BooleanLiteral;
declare function assertBooleanLiteral(node: object | null | undefined, opts?: object | null): void;
declare function isBooleanLiteralTypeAnnotation(node: object | null | undefined, opts?: object | null): node is BooleanLiteralTypeAnnotation;
declare function assertBooleanLiteralTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isBooleanTypeAnnotation(node: object | null | undefined, opts?: object | null): node is BooleanTypeAnnotation;
declare function assertBooleanTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isBreakStatement(node: object | null | undefined, opts?: object | null): node is BreakStatement;
declare function assertBreakStatement(node: object | null | undefined, opts?: object | null): void;
declare function isCallExpression(node: object | null | undefined, opts?: object | null): node is CallExpression;
declare function assertCallExpression(node: object | null | undefined, opts?: object | null): void;
declare function isCatchClause(node: object | null | undefined, opts?: object | null): node is CatchClause;
declare function assertCatchClause(node: object | null | undefined, opts?: object | null): void;
declare function isClass(node: object | null | undefined, opts?: object | null): node is Class;
declare function assertClass(node: object | null | undefined, opts?: object | null): void;
declare function isClassAccessorProperty(node: object | null | undefined, opts?: object | null): node is ClassAccessorProperty;
declare function assertClassAccessorProperty(node: object | null | undefined, opts?: object | null): void;
declare function isClassBody(node: object | null | undefined, opts?: object | null): node is ClassBody;
declare function assertClassBody(node: object | null | undefined, opts?: object | null): void;
declare function isClassDeclaration(node: object | null | undefined, opts?: object | null): node is ClassDeclaration;
declare function assertClassDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isClassExpression(node: object | null | undefined, opts?: object | null): node is ClassExpression;
declare function assertClassExpression(node: object | null | undefined, opts?: object | null): void;
declare function isClassImplements(node: object | null | undefined, opts?: object | null): node is ClassImplements;
declare function assertClassImplements(node: object | null | undefined, opts?: object | null): void;
declare function isClassMethod(node: object | null | undefined, opts?: object | null): node is ClassMethod;
declare function assertClassMethod(node: object | null | undefined, opts?: object | null): void;
declare function isClassPrivateMethod(node: object | null | undefined, opts?: object | null): node is ClassPrivateMethod;
declare function assertClassPrivateMethod(node: object | null | undefined, opts?: object | null): void;
declare function isClassPrivateProperty(node: object | null | undefined, opts?: object | null): node is ClassPrivateProperty;
declare function assertClassPrivateProperty(node: object | null | undefined, opts?: object | null): void;
declare function isClassProperty(node: object | null | undefined, opts?: object | null): node is ClassProperty;
declare function assertClassProperty(node: object | null | undefined, opts?: object | null): void;
declare function isCompletionStatement(node: object | null | undefined, opts?: object | null): node is CompletionStatement;
declare function assertCompletionStatement(node: object | null | undefined, opts?: object | null): void;
declare function isConditional(node: object | null | undefined, opts?: object | null): node is Conditional;
declare function assertConditional(node: object | null | undefined, opts?: object | null): void;
declare function isConditionalExpression(node: object | null | undefined, opts?: object | null): node is ConditionalExpression;
declare function assertConditionalExpression(node: object | null | undefined, opts?: object | null): void;
declare function isContinueStatement(node: object | null | undefined, opts?: object | null): node is ContinueStatement;
declare function assertContinueStatement(node: object | null | undefined, opts?: object | null): void;
declare function isDebuggerStatement(node: object | null | undefined, opts?: object | null): node is DebuggerStatement;
declare function assertDebuggerStatement(node: object | null | undefined, opts?: object | null): void;
declare function isDecimalLiteral(node: object | null | undefined, opts?: object | null): node is DecimalLiteral;
declare function assertDecimalLiteral(node: object | null | undefined, opts?: object | null): void;
declare function isDeclaration(node: object | null | undefined, opts?: object | null): node is Declaration;
declare function assertDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isDeclareClass(node: object | null | undefined, opts?: object | null): node is DeclareClass;
declare function assertDeclareClass(node: object | null | undefined, opts?: object | null): void;
declare function isDeclareExportAllDeclaration(node: object | null | undefined, opts?: object | null): node is DeclareExportAllDeclaration;
declare function assertDeclareExportAllDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isDeclareExportDeclaration(node: object | null | undefined, opts?: object | null): node is DeclareExportDeclaration;
declare function assertDeclareExportDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isDeclareFunction(node: object | null | undefined, opts?: object | null): node is DeclareFunction;
declare function assertDeclareFunction(node: object | null | undefined, opts?: object | null): void;
declare function isDeclareInterface(node: object | null | undefined, opts?: object | null): node is DeclareInterface;
declare function assertDeclareInterface(node: object | null | undefined, opts?: object | null): void;
declare function isDeclareModule(node: object | null | undefined, opts?: object | null): node is DeclareModule;
declare function assertDeclareModule(node: object | null | undefined, opts?: object | null): void;
declare function isDeclareModuleExports(node: object | null | undefined, opts?: object | null): node is DeclareModuleExports;
declare function assertDeclareModuleExports(node: object | null | undefined, opts?: object | null): void;
declare function isDeclareOpaqueType(node: object | null | undefined, opts?: object | null): node is DeclareOpaqueType;
declare function assertDeclareOpaqueType(node: object | null | undefined, opts?: object | null): void;
declare function isDeclareTypeAlias(node: object | null | undefined, opts?: object | null): node is DeclareTypeAlias;
declare function assertDeclareTypeAlias(node: object | null | undefined, opts?: object | null): void;
declare function isDeclareVariable(node: object | null | undefined, opts?: object | null): node is DeclareVariable;
declare function assertDeclareVariable(node: object | null | undefined, opts?: object | null): void;
declare function isDeclaredPredicate(node: object | null | undefined, opts?: object | null): node is DeclaredPredicate;
declare function assertDeclaredPredicate(node: object | null | undefined, opts?: object | null): void;
declare function isDecorator(node: object | null | undefined, opts?: object | null): node is Decorator;
declare function assertDecorator(node: object | null | undefined, opts?: object | null): void;
declare function isDirective(node: object | null | undefined, opts?: object | null): node is Directive;
declare function assertDirective(node: object | null | undefined, opts?: object | null): void;
declare function isDirectiveLiteral(node: object | null | undefined, opts?: object | null): node is DirectiveLiteral;
declare function assertDirectiveLiteral(node: object | null | undefined, opts?: object | null): void;
declare function isDoExpression(node: object | null | undefined, opts?: object | null): node is DoExpression;
declare function assertDoExpression(node: object | null | undefined, opts?: object | null): void;
declare function isDoWhileStatement(node: object | null | undefined, opts?: object | null): node is DoWhileStatement;
declare function assertDoWhileStatement(node: object | null | undefined, opts?: object | null): void;
declare function isEmptyStatement(node: object | null | undefined, opts?: object | null): node is EmptyStatement;
declare function assertEmptyStatement(node: object | null | undefined, opts?: object | null): void;
declare function isEmptyTypeAnnotation(node: object | null | undefined, opts?: object | null): node is EmptyTypeAnnotation;
declare function assertEmptyTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isEnumBody(node: object | null | undefined, opts?: object | null): node is EnumBody;
declare function assertEnumBody(node: object | null | undefined, opts?: object | null): void;
declare function isEnumBooleanBody(node: object | null | undefined, opts?: object | null): node is EnumBooleanBody;
declare function assertEnumBooleanBody(node: object | null | undefined, opts?: object | null): void;
declare function isEnumBooleanMember(node: object | null | undefined, opts?: object | null): node is EnumBooleanMember;
declare function assertEnumBooleanMember(node: object | null | undefined, opts?: object | null): void;
declare function isEnumDeclaration(node: object | null | undefined, opts?: object | null): node is EnumDeclaration;
declare function assertEnumDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isEnumDefaultedMember(node: object | null | undefined, opts?: object | null): node is EnumDefaultedMember;
declare function assertEnumDefaultedMember(node: object | null | undefined, opts?: object | null): void;
declare function isEnumMember(node: object | null | undefined, opts?: object | null): node is EnumMember;
declare function assertEnumMember(node: object | null | undefined, opts?: object | null): void;
declare function isEnumNumberBody(node: object | null | undefined, opts?: object | null): node is EnumNumberBody;
declare function assertEnumNumberBody(node: object | null | undefined, opts?: object | null): void;
declare function isEnumNumberMember(node: object | null | undefined, opts?: object | null): node is EnumNumberMember;
declare function assertEnumNumberMember(node: object | null | undefined, opts?: object | null): void;
declare function isEnumStringBody(node: object | null | undefined, opts?: object | null): node is EnumStringBody;
declare function assertEnumStringBody(node: object | null | undefined, opts?: object | null): void;
declare function isEnumStringMember(node: object | null | undefined, opts?: object | null): node is EnumStringMember;
declare function assertEnumStringMember(node: object | null | undefined, opts?: object | null): void;
declare function isEnumSymbolBody(node: object | null | undefined, opts?: object | null): node is EnumSymbolBody;
declare function assertEnumSymbolBody(node: object | null | undefined, opts?: object | null): void;
declare function isExistsTypeAnnotation(node: object | null | undefined, opts?: object | null): node is ExistsTypeAnnotation;
declare function assertExistsTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isExportAllDeclaration(node: object | null | undefined, opts?: object | null): node is ExportAllDeclaration;
declare function assertExportAllDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isExportDeclaration(node: object | null | undefined, opts?: object | null): node is ExportDeclaration;
declare function assertExportDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isExportDefaultDeclaration(node: object | null | undefined, opts?: object | null): node is ExportDefaultDeclaration;
declare function assertExportDefaultDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isExportDefaultSpecifier(node: object | null | undefined, opts?: object | null): node is ExportDefaultSpecifier;
declare function assertExportDefaultSpecifier(node: object | null | undefined, opts?: object | null): void;
declare function isExportNamedDeclaration(node: object | null | undefined, opts?: object | null): node is ExportNamedDeclaration;
declare function assertExportNamedDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isExportNamespaceSpecifier(node: object | null | undefined, opts?: object | null): node is ExportNamespaceSpecifier;
declare function assertExportNamespaceSpecifier(node: object | null | undefined, opts?: object | null): void;
declare function isExportSpecifier(node: object | null | undefined, opts?: object | null): node is ExportSpecifier;
declare function assertExportSpecifier(node: object | null | undefined, opts?: object | null): void;
declare function isExpression(node: object | null | undefined, opts?: object | null): node is Expression;
declare function assertExpression(node: object | null | undefined, opts?: object | null): void;
declare function isExpressionStatement(node: object | null | undefined, opts?: object | null): node is ExpressionStatement;
declare function assertExpressionStatement(node: object | null | undefined, opts?: object | null): void;
declare function isExpressionWrapper(node: object | null | undefined, opts?: object | null): node is ExpressionWrapper;
declare function assertExpressionWrapper(node: object | null | undefined, opts?: object | null): void;
declare function isFile(node: object | null | undefined, opts?: object | null): node is File;
declare function assertFile(node: object | null | undefined, opts?: object | null): void;
declare function isFlow(node: object | null | undefined, opts?: object | null): node is Flow;
declare function assertFlow(node: object | null | undefined, opts?: object | null): void;
declare function isFlowBaseAnnotation(node: object | null | undefined, opts?: object | null): node is FlowBaseAnnotation;
declare function assertFlowBaseAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isFlowDeclaration(node: object | null | undefined, opts?: object | null): node is FlowDeclaration;
declare function assertFlowDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isFlowPredicate(node: object | null | undefined, opts?: object | null): node is FlowPredicate;
declare function assertFlowPredicate(node: object | null | undefined, opts?: object | null): void;
declare function isFlowType(node: object | null | undefined, opts?: object | null): node is FlowType;
declare function assertFlowType(node: object | null | undefined, opts?: object | null): void;
declare function isFor(node: object | null | undefined, opts?: object | null): node is For;
declare function assertFor(node: object | null | undefined, opts?: object | null): void;
declare function isForInStatement(node: object | null | undefined, opts?: object | null): node is ForInStatement;
declare function assertForInStatement(node: object | null | undefined, opts?: object | null): void;
declare function isForOfStatement(node: object | null | undefined, opts?: object | null): node is ForOfStatement;
declare function assertForOfStatement(node: object | null | undefined, opts?: object | null): void;
declare function isForStatement(node: object | null | undefined, opts?: object | null): node is ForStatement;
declare function assertForStatement(node: object | null | undefined, opts?: object | null): void;
declare function isForXStatement(node: object | null | undefined, opts?: object | null): node is ForXStatement;
declare function assertForXStatement(node: object | null | undefined, opts?: object | null): void;
declare function isFunction(node: object | null | undefined, opts?: object | null): node is Function;
declare function assertFunction(node: object | null | undefined, opts?: object | null): void;
declare function isFunctionDeclaration(node: object | null | undefined, opts?: object | null): node is FunctionDeclaration;
declare function assertFunctionDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isFunctionExpression(node: object | null | undefined, opts?: object | null): node is FunctionExpression;
declare function assertFunctionExpression(node: object | null | undefined, opts?: object | null): void;
declare function isFunctionParent(node: object | null | undefined, opts?: object | null): node is FunctionParent;
declare function assertFunctionParent(node: object | null | undefined, opts?: object | null): void;
declare function isFunctionTypeAnnotation(node: object | null | undefined, opts?: object | null): node is FunctionTypeAnnotation;
declare function assertFunctionTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isFunctionTypeParam(node: object | null | undefined, opts?: object | null): node is FunctionTypeParam;
declare function assertFunctionTypeParam(node: object | null | undefined, opts?: object | null): void;
declare function isGenericTypeAnnotation(node: object | null | undefined, opts?: object | null): node is GenericTypeAnnotation;
declare function assertGenericTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isIdentifier(node: object | null | undefined, opts?: object | null): node is Identifier;
declare function assertIdentifier(node: object | null | undefined, opts?: object | null): void;
declare function isIfStatement(node: object | null | undefined, opts?: object | null): node is IfStatement;
declare function assertIfStatement(node: object | null | undefined, opts?: object | null): void;
declare function assertImmutable(node: object | null | undefined, opts?: object | null): void;
declare function isImport(node: object | null | undefined, opts?: object | null): node is Import;
declare function assertImport(node: object | null | undefined, opts?: object | null): void;
declare function isImportAttribute(node: object | null | undefined, opts?: object | null): node is ImportAttribute;
declare function assertImportAttribute(node: object | null | undefined, opts?: object | null): void;
declare function isImportDeclaration(node: object | null | undefined, opts?: object | null): node is ImportDeclaration;
declare function assertImportDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isImportDefaultSpecifier(node: object | null | undefined, opts?: object | null): node is ImportDefaultSpecifier;
declare function assertImportDefaultSpecifier(node: object | null | undefined, opts?: object | null): void;
declare function isImportExpression(node: object | null | undefined, opts?: object | null): node is ImportExpression;
declare function assertImportExpression(node: object | null | undefined, opts?: object | null): void;
declare function isImportNamespaceSpecifier(node: object | null | undefined, opts?: object | null): node is ImportNamespaceSpecifier;
declare function assertImportNamespaceSpecifier(node: object | null | undefined, opts?: object | null): void;
declare function isImportOrExportDeclaration(node: object | null | undefined, opts?: object | null): node is ImportOrExportDeclaration;
declare function assertImportOrExportDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isImportSpecifier(node: object | null | undefined, opts?: object | null): node is ImportSpecifier;
declare function assertImportSpecifier(node: object | null | undefined, opts?: object | null): void;
declare function isIndexedAccessType(node: object | null | undefined, opts?: object | null): node is IndexedAccessType;
declare function assertIndexedAccessType(node: object | null | undefined, opts?: object | null): void;
declare function isInferredPredicate(node: object | null | undefined, opts?: object | null): node is InferredPredicate;
declare function assertInferredPredicate(node: object | null | undefined, opts?: object | null): void;
declare function isInterfaceDeclaration(node: object | null | undefined, opts?: object | null): node is InterfaceDeclaration;
declare function assertInterfaceDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isInterfaceExtends(node: object | null | undefined, opts?: object | null): node is InterfaceExtends;
declare function assertInterfaceExtends(node: object | null | undefined, opts?: object | null): void;
declare function isInterfaceTypeAnnotation(node: object | null | undefined, opts?: object | null): node is InterfaceTypeAnnotation;
declare function assertInterfaceTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isInterpreterDirective(node: object | null | undefined, opts?: object | null): node is InterpreterDirective;
declare function assertInterpreterDirective(node: object | null | undefined, opts?: object | null): void;
declare function isIntersectionTypeAnnotation(node: object | null | undefined, opts?: object | null): node is IntersectionTypeAnnotation;
declare function assertIntersectionTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isJSX(node: object | null | undefined, opts?: object | null): node is JSX;
declare function assertJSX(node: object | null | undefined, opts?: object | null): void;
declare function isJSXAttribute(node: object | null | undefined, opts?: object | null): node is JSXAttribute;
declare function assertJSXAttribute(node: object | null | undefined, opts?: object | null): void;
declare function isJSXClosingElement(node: object | null | undefined, opts?: object | null): node is JSXClosingElement;
declare function assertJSXClosingElement(node: object | null | undefined, opts?: object | null): void;
declare function isJSXClosingFragment(node: object | null | undefined, opts?: object | null): node is JSXClosingFragment;
declare function assertJSXClosingFragment(node: object | null | undefined, opts?: object | null): void;
declare function isJSXElement(node: object | null | undefined, opts?: object | null): node is JSXElement;
declare function assertJSXElement(node: object | null | undefined, opts?: object | null): void;
declare function isJSXEmptyExpression(node: object | null | undefined, opts?: object | null): node is JSXEmptyExpression;
declare function assertJSXEmptyExpression(node: object | null | undefined, opts?: object | null): void;
declare function isJSXExpressionContainer(node: object | null | undefined, opts?: object | null): node is JSXExpressionContainer;
declare function assertJSXExpressionContainer(node: object | null | undefined, opts?: object | null): void;
declare function isJSXFragment(node: object | null | undefined, opts?: object | null): node is JSXFragment;
declare function assertJSXFragment(node: object | null | undefined, opts?: object | null): void;
declare function isJSXIdentifier(node: object | null | undefined, opts?: object | null): node is JSXIdentifier;
declare function assertJSXIdentifier(node: object | null | undefined, opts?: object | null): void;
declare function isJSXMemberExpression(node: object | null | undefined, opts?: object | null): node is JSXMemberExpression;
declare function assertJSXMemberExpression(node: object | null | undefined, opts?: object | null): void;
declare function isJSXNamespacedName(node: object | null | undefined, opts?: object | null): node is JSXNamespacedName;
declare function assertJSXNamespacedName(node: object | null | undefined, opts?: object | null): void;
declare function isJSXOpeningElement(node: object | null | undefined, opts?: object | null): node is JSXOpeningElement;
declare function assertJSXOpeningElement(node: object | null | undefined, opts?: object | null): void;
declare function isJSXOpeningFragment(node: object | null | undefined, opts?: object | null): node is JSXOpeningFragment;
declare function assertJSXOpeningFragment(node: object | null | undefined, opts?: object | null): void;
declare function isJSXSpreadAttribute(node: object | null | undefined, opts?: object | null): node is JSXSpreadAttribute;
declare function assertJSXSpreadAttribute(node: object | null | undefined, opts?: object | null): void;
declare function isJSXSpreadChild(node: object | null | undefined, opts?: object | null): node is JSXSpreadChild;
declare function assertJSXSpreadChild(node: object | null | undefined, opts?: object | null): void;
declare function isJSXText(node: object | null | undefined, opts?: object | null): node is JSXText;
declare function assertJSXText(node: object | null | undefined, opts?: object | null): void;
declare function isLVal(node: object | null | undefined, opts?: object | null): node is LVal;
declare function assertLVal(node: object | null | undefined, opts?: object | null): void;
declare function isLabeledStatement(node: object | null | undefined, opts?: object | null): node is LabeledStatement;
declare function assertLabeledStatement(node: object | null | undefined, opts?: object | null): void;
declare function isLiteral(node: object | null | undefined, opts?: object | null): node is Literal;
declare function assertLiteral(node: object | null | undefined, opts?: object | null): void;
declare function isLogicalExpression(node: object | null | undefined, opts?: object | null): node is LogicalExpression;
declare function assertLogicalExpression(node: object | null | undefined, opts?: object | null): void;
declare function isLoop(node: object | null | undefined, opts?: object | null): node is Loop;
declare function assertLoop(node: object | null | undefined, opts?: object | null): void;
declare function isMemberExpression(node: object | null | undefined, opts?: object | null): node is MemberExpression;
declare function assertMemberExpression(node: object | null | undefined, opts?: object | null): void;
declare function isMetaProperty(node: object | null | undefined, opts?: object | null): node is MetaProperty;
declare function assertMetaProperty(node: object | null | undefined, opts?: object | null): void;
declare function isMethod(node: object | null | undefined, opts?: object | null): node is Method;
declare function assertMethod(node: object | null | undefined, opts?: object | null): void;
declare function isMiscellaneous(node: object | null | undefined, opts?: object | null): node is Miscellaneous;
declare function assertMiscellaneous(node: object | null | undefined, opts?: object | null): void;
declare function isMixedTypeAnnotation(node: object | null | undefined, opts?: object | null): node is MixedTypeAnnotation;
declare function assertMixedTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isModuleDeclaration(node: object | null | undefined, opts?: object | null): node is ModuleDeclaration;
declare function assertModuleDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isModuleExpression(node: object | null | undefined, opts?: object | null): node is ModuleExpression;
declare function assertModuleExpression(node: object | null | undefined, opts?: object | null): void;
declare function isModuleSpecifier(node: object | null | undefined, opts?: object | null): node is ModuleSpecifier;
declare function assertModuleSpecifier(node: object | null | undefined, opts?: object | null): void;
declare function isNewExpression(node: object | null | undefined, opts?: object | null): node is NewExpression;
declare function assertNewExpression(node: object | null | undefined, opts?: object | null): void;
declare function isNullLiteral(node: object | null | undefined, opts?: object | null): node is NullLiteral;
declare function assertNullLiteral(node: object | null | undefined, opts?: object | null): void;
declare function isNullLiteralTypeAnnotation(node: object | null | undefined, opts?: object | null): node is NullLiteralTypeAnnotation;
declare function assertNullLiteralTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isNullableTypeAnnotation(node: object | null | undefined, opts?: object | null): node is NullableTypeAnnotation;
declare function assertNullableTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
/** @deprecated Use `isNumericLiteral` */
declare function isNumberLiteral(node: object | null | undefined, opts?: object | null): node is NumericLiteral;
/** @deprecated Use `assertNumericLiteral` */
declare function assertNumberLiteral(node: object | null | undefined, opts?: object | null): void;
declare function isNumberLiteralTypeAnnotation(node: object | null | undefined, opts?: object | null): node is NumberLiteralTypeAnnotation;
declare function assertNumberLiteralTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isNumberTypeAnnotation(node: object | null | undefined, opts?: object | null): node is NumberTypeAnnotation;
declare function assertNumberTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isNumericLiteral(node: object | null | undefined, opts?: object | null): node is NumericLiteral;
declare function assertNumericLiteral(node: object | null | undefined, opts?: object | null): void;
declare function isObjectExpression(node: object | null | undefined, opts?: object | null): node is ObjectExpression;
declare function assertObjectExpression(node: object | null | undefined, opts?: object | null): void;
declare function isObjectMember(node: object | null | undefined, opts?: object | null): node is ObjectMember;
declare function assertObjectMember(node: object | null | undefined, opts?: object | null): void;
declare function isObjectMethod(node: object | null | undefined, opts?: object | null): node is ObjectMethod;
declare function assertObjectMethod(node: object | null | undefined, opts?: object | null): void;
declare function isObjectPattern(node: object | null | undefined, opts?: object | null): node is ObjectPattern;
declare function assertObjectPattern(node: object | null | undefined, opts?: object | null): void;
declare function isObjectProperty(node: object | null | undefined, opts?: object | null): node is ObjectProperty;
declare function assertObjectProperty(node: object | null | undefined, opts?: object | null): void;
declare function isObjectTypeAnnotation(node: object | null | undefined, opts?: object | null): node is ObjectTypeAnnotation;
declare function assertObjectTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isObjectTypeCallProperty(node: object | null | undefined, opts?: object | null): node is ObjectTypeCallProperty;
declare function assertObjectTypeCallProperty(node: object | null | undefined, opts?: object | null): void;
declare function isObjectTypeIndexer(node: object | null | undefined, opts?: object | null): node is ObjectTypeIndexer;
declare function assertObjectTypeIndexer(node: object | null | undefined, opts?: object | null): void;
declare function isObjectTypeInternalSlot(node: object | null | undefined, opts?: object | null): node is ObjectTypeInternalSlot;
declare function assertObjectTypeInternalSlot(node: object | null | undefined, opts?: object | null): void;
declare function isObjectTypeProperty(node: object | null | undefined, opts?: object | null): node is ObjectTypeProperty;
declare function assertObjectTypeProperty(node: object | null | undefined, opts?: object | null): void;
declare function isObjectTypeSpreadProperty(node: object | null | undefined, opts?: object | null): node is ObjectTypeSpreadProperty;
declare function assertObjectTypeSpreadProperty(node: object | null | undefined, opts?: object | null): void;
declare function isOpaqueType(node: object | null | undefined, opts?: object | null): node is OpaqueType;
declare function assertOpaqueType(node: object | null | undefined, opts?: object | null): void;
declare function isOptionalCallExpression(node: object | null | undefined, opts?: object | null): node is OptionalCallExpression;
declare function assertOptionalCallExpression(node: object | null | undefined, opts?: object | null): void;
declare function isOptionalIndexedAccessType(node: object | null | undefined, opts?: object | null): node is OptionalIndexedAccessType;
declare function assertOptionalIndexedAccessType(node: object | null | undefined, opts?: object | null): void;
declare function isOptionalMemberExpression(node: object | null | undefined, opts?: object | null): node is OptionalMemberExpression;
declare function assertOptionalMemberExpression(node: object | null | undefined, opts?: object | null): void;
declare function isParenthesizedExpression(node: object | null | undefined, opts?: object | null): node is ParenthesizedExpression;
declare function assertParenthesizedExpression(node: object | null | undefined, opts?: object | null): void;
declare function isPattern(node: object | null | undefined, opts?: object | null): node is Pattern;
declare function assertPattern(node: object | null | undefined, opts?: object | null): void;
declare function isPatternLike(node: object | null | undefined, opts?: object | null): node is PatternLike;
declare function assertPatternLike(node: object | null | undefined, opts?: object | null): void;
declare function isPipelineBareFunction(node: object | null | undefined, opts?: object | null): node is PipelineBareFunction;
declare function assertPipelineBareFunction(node: object | null | undefined, opts?: object | null): void;
declare function isPipelinePrimaryTopicReference(node: object | null | undefined, opts?: object | null): node is PipelinePrimaryTopicReference;
declare function assertPipelinePrimaryTopicReference(node: object | null | undefined, opts?: object | null): void;
declare function isPipelineTopicExpression(node: object | null | undefined, opts?: object | null): node is PipelineTopicExpression;
declare function assertPipelineTopicExpression(node: object | null | undefined, opts?: object | null): void;
declare function isPlaceholder(node: object | null | undefined, opts?: object | null): node is Placeholder;
declare function assertPlaceholder(node: object | null | undefined, opts?: object | null): void;
declare function isPrivate(node: object | null | undefined, opts?: object | null): node is Private;
declare function assertPrivate(node: object | null | undefined, opts?: object | null): void;
declare function isPrivateName(node: object | null | undefined, opts?: object | null): node is PrivateName;
declare function assertPrivateName(node: object | null | undefined, opts?: object | null): void;
declare function isProgram(node: object | null | undefined, opts?: object | null): node is Program;
declare function assertProgram(node: object | null | undefined, opts?: object | null): void;
declare function isProperty(node: object | null | undefined, opts?: object | null): node is Property;
declare function assertProperty(node: object | null | undefined, opts?: object | null): void;
declare function isPureish(node: object | null | undefined, opts?: object | null): node is Pureish;
declare function assertPureish(node: object | null | undefined, opts?: object | null): void;
declare function isQualifiedTypeIdentifier(node: object | null | undefined, opts?: object | null): node is QualifiedTypeIdentifier;
declare function assertQualifiedTypeIdentifier(node: object | null | undefined, opts?: object | null): void;
declare function isRecordExpression(node: object | null | undefined, opts?: object | null): node is RecordExpression;
declare function assertRecordExpression(node: object | null | undefined, opts?: object | null): void;
declare function isRegExpLiteral(node: object | null | undefined, opts?: object | null): node is RegExpLiteral;
declare function assertRegExpLiteral(node: object | null | undefined, opts?: object | null): void;
/** @deprecated Use `isRegExpLiteral` */
declare function isRegexLiteral(node: object | null | undefined, opts?: object | null): node is RegExpLiteral;
/** @deprecated Use `assertRegExpLiteral` */
declare function assertRegexLiteral(node: object | null | undefined, opts?: object | null): void;
declare function isRestElement(node: object | null | undefined, opts?: object | null): node is RestElement;
declare function assertRestElement(node: object | null | undefined, opts?: object | null): void;
/** @deprecated Use `isRestElement` */
declare function isRestProperty(node: object | null | undefined, opts?: object | null): node is RestElement;
/** @deprecated Use `assertRestElement` */
declare function assertRestProperty(node: object | null | undefined, opts?: object | null): void;
declare function isReturnStatement(node: object | null | undefined, opts?: object | null): node is ReturnStatement;
declare function assertReturnStatement(node: object | null | undefined, opts?: object | null): void;
declare function isScopable(node: object | null | undefined, opts?: object | null): node is Scopable;
declare function assertScopable(node: object | null | undefined, opts?: object | null): void;
declare function isSequenceExpression(node: object | null | undefined, opts?: object | null): node is SequenceExpression;
declare function assertSequenceExpression(node: object | null | undefined, opts?: object | null): void;
declare function isSpreadElement(node: object | null | undefined, opts?: object | null): node is SpreadElement;
declare function assertSpreadElement(node: object | null | undefined, opts?: object | null): void;
/** @deprecated Use `isSpreadElement` */
declare function isSpreadProperty(node: object | null | undefined, opts?: object | null): node is SpreadElement;
/** @deprecated Use `assertSpreadElement` */
declare function assertSpreadProperty(node: object | null | undefined, opts?: object | null): void;
declare function isStandardized(node: object | null | undefined, opts?: object | null): node is Standardized;
declare function assertStandardized(node: object | null | undefined, opts?: object | null): void;
declare function isStatement(node: object | null | undefined, opts?: object | null): node is Statement;
declare function assertStatement(node: object | null | undefined, opts?: object | null): void;
declare function isStaticBlock(node: object | null | undefined, opts?: object | null): node is StaticBlock;
declare function assertStaticBlock(node: object | null | undefined, opts?: object | null): void;
declare function isStringLiteral(node: object | null | undefined, opts?: object | null): node is StringLiteral;
declare function assertStringLiteral(node: object | null | undefined, opts?: object | null): void;
declare function isStringLiteralTypeAnnotation(node: object | null | undefined, opts?: object | null): node is StringLiteralTypeAnnotation;
declare function assertStringLiteralTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isStringTypeAnnotation(node: object | null | undefined, opts?: object | null): node is StringTypeAnnotation;
declare function assertStringTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isSuper(node: object | null | undefined, opts?: object | null): node is Super;
declare function assertSuper(node: object | null | undefined, opts?: object | null): void;
declare function isSwitchCase(node: object | null | undefined, opts?: object | null): node is SwitchCase;
declare function assertSwitchCase(node: object | null | undefined, opts?: object | null): void;
declare function isSwitchStatement(node: object | null | undefined, opts?: object | null): node is SwitchStatement;
declare function assertSwitchStatement(node: object | null | undefined, opts?: object | null): void;
declare function isSymbolTypeAnnotation(node: object | null | undefined, opts?: object | null): node is SymbolTypeAnnotation;
declare function assertSymbolTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isTSAnyKeyword(node: object | null | undefined, opts?: object | null): node is TSAnyKeyword;
declare function assertTSAnyKeyword(node: object | null | undefined, opts?: object | null): void;
declare function isTSArrayType(node: object | null | undefined, opts?: object | null): node is TSArrayType;
declare function assertTSArrayType(node: object | null | undefined, opts?: object | null): void;
declare function isTSAsExpression(node: object | null | undefined, opts?: object | null): node is TSAsExpression;
declare function assertTSAsExpression(node: object | null | undefined, opts?: object | null): void;
declare function isTSBaseType(node: object | null | undefined, opts?: object | null): node is TSBaseType;
declare function assertTSBaseType(node: object | null | undefined, opts?: object | null): void;
declare function isTSBigIntKeyword(node: object | null | undefined, opts?: object | null): node is TSBigIntKeyword;
declare function assertTSBigIntKeyword(node: object | null | undefined, opts?: object | null): void;
declare function isTSBooleanKeyword(node: object | null | undefined, opts?: object | null): node is TSBooleanKeyword;
declare function assertTSBooleanKeyword(node: object | null | undefined, opts?: object | null): void;
declare function isTSCallSignatureDeclaration(node: object | null | undefined, opts?: object | null): node is TSCallSignatureDeclaration;
declare function assertTSCallSignatureDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isTSConditionalType(node: object | null | undefined, opts?: object | null): node is TSConditionalType;
declare function assertTSConditionalType(node: object | null | undefined, opts?: object | null): void;
declare function isTSConstructSignatureDeclaration(node: object | null | undefined, opts?: object | null): node is TSConstructSignatureDeclaration;
declare function assertTSConstructSignatureDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isTSConstructorType(node: object | null | undefined, opts?: object | null): node is TSConstructorType;
declare function assertTSConstructorType(node: object | null | undefined, opts?: object | null): void;
declare function isTSDeclareFunction(node: object | null | undefined, opts?: object | null): node is TSDeclareFunction;
declare function assertTSDeclareFunction(node: object | null | undefined, opts?: object | null): void;
declare function isTSDeclareMethod(node: object | null | undefined, opts?: object | null): node is TSDeclareMethod;
declare function assertTSDeclareMethod(node: object | null | undefined, opts?: object | null): void;
declare function isTSEntityName(node: object | null | undefined, opts?: object | null): node is TSEntityName;
declare function assertTSEntityName(node: object | null | undefined, opts?: object | null): void;
declare function isTSEnumDeclaration(node: object | null | undefined, opts?: object | null): node is TSEnumDeclaration;
declare function assertTSEnumDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isTSEnumMember(node: object | null | undefined, opts?: object | null): node is TSEnumMember;
declare function assertTSEnumMember(node: object | null | undefined, opts?: object | null): void;
declare function isTSExportAssignment(node: object | null | undefined, opts?: object | null): node is TSExportAssignment;
declare function assertTSExportAssignment(node: object | null | undefined, opts?: object | null): void;
declare function isTSExpressionWithTypeArguments(node: object | null | undefined, opts?: object | null): node is TSExpressionWithTypeArguments;
declare function assertTSExpressionWithTypeArguments(node: object | null | undefined, opts?: object | null): void;
declare function isTSExternalModuleReference(node: object | null | undefined, opts?: object | null): node is TSExternalModuleReference;
declare function assertTSExternalModuleReference(node: object | null | undefined, opts?: object | null): void;
declare function isTSFunctionType(node: object | null | undefined, opts?: object | null): node is TSFunctionType;
declare function assertTSFunctionType(node: object | null | undefined, opts?: object | null): void;
declare function isTSImportEqualsDeclaration(node: object | null | undefined, opts?: object | null): node is TSImportEqualsDeclaration;
declare function assertTSImportEqualsDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isTSImportType(node: object | null | undefined, opts?: object | null): node is TSImportType;
declare function assertTSImportType(node: object | null | undefined, opts?: object | null): void;
declare function isTSIndexSignature(node: object | null | undefined, opts?: object | null): node is TSIndexSignature;
declare function assertTSIndexSignature(node: object | null | undefined, opts?: object | null): void;
declare function isTSIndexedAccessType(node: object | null | undefined, opts?: object | null): node is TSIndexedAccessType;
declare function assertTSIndexedAccessType(node: object | null | undefined, opts?: object | null): void;
declare function isTSInferType(node: object | null | undefined, opts?: object | null): node is TSInferType;
declare function assertTSInferType(node: object | null | undefined, opts?: object | null): void;
declare function isTSInstantiationExpression(node: object | null | undefined, opts?: object | null): node is TSInstantiationExpression;
declare function assertTSInstantiationExpression(node: object | null | undefined, opts?: object | null): void;
declare function isTSInterfaceBody(node: object | null | undefined, opts?: object | null): node is TSInterfaceBody;
declare function assertTSInterfaceBody(node: object | null | undefined, opts?: object | null): void;
declare function isTSInterfaceDeclaration(node: object | null | undefined, opts?: object | null): node is TSInterfaceDeclaration;
declare function assertTSInterfaceDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isTSIntersectionType(node: object | null | undefined, opts?: object | null): node is TSIntersectionType;
declare function assertTSIntersectionType(node: object | null | undefined, opts?: object | null): void;
declare function isTSIntrinsicKeyword(node: object | null | undefined, opts?: object | null): node is TSIntrinsicKeyword;
declare function assertTSIntrinsicKeyword(node: object | null | undefined, opts?: object | null): void;
declare function isTSLiteralType(node: object | null | undefined, opts?: object | null): node is TSLiteralType;
declare function assertTSLiteralType(node: object | null | undefined, opts?: object | null): void;
declare function isTSMappedType(node: object | null | undefined, opts?: object | null): node is TSMappedType;
declare function assertTSMappedType(node: object | null | undefined, opts?: object | null): void;
declare function isTSMethodSignature(node: object | null | undefined, opts?: object | null): node is TSMethodSignature;
declare function assertTSMethodSignature(node: object | null | undefined, opts?: object | null): void;
declare function isTSModuleBlock(node: object | null | undefined, opts?: object | null): node is TSModuleBlock;
declare function assertTSModuleBlock(node: object | null | undefined, opts?: object | null): void;
declare function isTSModuleDeclaration(node: object | null | undefined, opts?: object | null): node is TSModuleDeclaration;
declare function assertTSModuleDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isTSNamedTupleMember(node: object | null | undefined, opts?: object | null): node is TSNamedTupleMember;
declare function assertTSNamedTupleMember(node: object | null | undefined, opts?: object | null): void;
declare function isTSNamespaceExportDeclaration(node: object | null | undefined, opts?: object | null): node is TSNamespaceExportDeclaration;
declare function assertTSNamespaceExportDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isTSNeverKeyword(node: object | null | undefined, opts?: object | null): node is TSNeverKeyword;
declare function assertTSNeverKeyword(node: object | null | undefined, opts?: object | null): void;
declare function isTSNonNullExpression(node: object | null | undefined, opts?: object | null): node is TSNonNullExpression;
declare function assertTSNonNullExpression(node: object | null | undefined, opts?: object | null): void;
declare function isTSNullKeyword(node: object | null | undefined, opts?: object | null): node is TSNullKeyword;
declare function assertTSNullKeyword(node: object | null | undefined, opts?: object | null): void;
declare function isTSNumberKeyword(node: object | null | undefined, opts?: object | null): node is TSNumberKeyword;
declare function assertTSNumberKeyword(node: object | null | undefined, opts?: object | null): void;
declare function isTSObjectKeyword(node: object | null | undefined, opts?: object | null): node is TSObjectKeyword;
declare function assertTSObjectKeyword(node: object | null | undefined, opts?: object | null): void;
declare function isTSOptionalType(node: object | null | undefined, opts?: object | null): node is TSOptionalType;
declare function assertTSOptionalType(node: object | null | undefined, opts?: object | null): void;
declare function isTSParameterProperty(node: object | null | undefined, opts?: object | null): node is TSParameterProperty;
declare function assertTSParameterProperty(node: object | null | undefined, opts?: object | null): void;
declare function isTSParenthesizedType(node: object | null | undefined, opts?: object | null): node is TSParenthesizedType;
declare function assertTSParenthesizedType(node: object | null | undefined, opts?: object | null): void;
declare function isTSPropertySignature(node: object | null | undefined, opts?: object | null): node is TSPropertySignature;
declare function assertTSPropertySignature(node: object | null | undefined, opts?: object | null): void;
declare function isTSQualifiedName(node: object | null | undefined, opts?: object | null): node is TSQualifiedName;
declare function assertTSQualifiedName(node: object | null | undefined, opts?: object | null): void;
declare function isTSRestType(node: object | null | undefined, opts?: object | null): node is TSRestType;
declare function assertTSRestType(node: object | null | undefined, opts?: object | null): void;
declare function isTSSatisfiesExpression(node: object | null | undefined, opts?: object | null): node is TSSatisfiesExpression;
declare function assertTSSatisfiesExpression(node: object | null | undefined, opts?: object | null): void;
declare function isTSStringKeyword(node: object | null | undefined, opts?: object | null): node is TSStringKeyword;
declare function assertTSStringKeyword(node: object | null | undefined, opts?: object | null): void;
declare function isTSSymbolKeyword(node: object | null | undefined, opts?: object | null): node is TSSymbolKeyword;
declare function assertTSSymbolKeyword(node: object | null | undefined, opts?: object | null): void;
declare function isTSThisType(node: object | null | undefined, opts?: object | null): node is TSThisType;
declare function assertTSThisType(node: object | null | undefined, opts?: object | null): void;
declare function isTSTupleType(node: object | null | undefined, opts?: object | null): node is TSTupleType;
declare function assertTSTupleType(node: object | null | undefined, opts?: object | null): void;
declare function isTSType(node: object | null | undefined, opts?: object | null): node is TSType;
declare function assertTSType(node: object | null | undefined, opts?: object | null): void;
declare function isTSTypeAliasDeclaration(node: object | null | undefined, opts?: object | null): node is TSTypeAliasDeclaration;
declare function assertTSTypeAliasDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isTSTypeAnnotation(node: object | null | undefined, opts?: object | null): node is TSTypeAnnotation;
declare function assertTSTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isTSTypeAssertion(node: object | null | undefined, opts?: object | null): node is TSTypeAssertion;
declare function assertTSTypeAssertion(node: object | null | undefined, opts?: object | null): void;
declare function isTSTypeElement(node: object | null | undefined, opts?: object | null): node is TSTypeElement;
declare function assertTSTypeElement(node: object | null | undefined, opts?: object | null): void;
declare function isTSTypeLiteral(node: object | null | undefined, opts?: object | null): node is TSTypeLiteral;
declare function assertTSTypeLiteral(node: object | null | undefined, opts?: object | null): void;
declare function isTSTypeOperator(node: object | null | undefined, opts?: object | null): node is TSTypeOperator;
declare function assertTSTypeOperator(node: object | null | undefined, opts?: object | null): void;
declare function isTSTypeParameter(node: object | null | undefined, opts?: object | null): node is TSTypeParameter;
declare function assertTSTypeParameter(node: object | null | undefined, opts?: object | null): void;
declare function isTSTypeParameterDeclaration(node: object | null | undefined, opts?: object | null): node is TSTypeParameterDeclaration;
declare function assertTSTypeParameterDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isTSTypeParameterInstantiation(node: object | null | undefined, opts?: object | null): node is TSTypeParameterInstantiation;
declare function assertTSTypeParameterInstantiation(node: object | null | undefined, opts?: object | null): void;
declare function isTSTypePredicate(node: object | null | undefined, opts?: object | null): node is TSTypePredicate;
declare function assertTSTypePredicate(node: object | null | undefined, opts?: object | null): void;
declare function isTSTypeQuery(node: object | null | undefined, opts?: object | null): node is TSTypeQuery;
declare function assertTSTypeQuery(node: object | null | undefined, opts?: object | null): void;
declare function isTSTypeReference(node: object | null | undefined, opts?: object | null): node is TSTypeReference;
declare function assertTSTypeReference(node: object | null | undefined, opts?: object | null): void;
declare function isTSUndefinedKeyword(node: object | null | undefined, opts?: object | null): node is TSUndefinedKeyword;
declare function assertTSUndefinedKeyword(node: object | null | undefined, opts?: object | null): void;
declare function isTSUnionType(node: object | null | undefined, opts?: object | null): node is TSUnionType;
declare function assertTSUnionType(node: object | null | undefined, opts?: object | null): void;
declare function isTSUnknownKeyword(node: object | null | undefined, opts?: object | null): node is TSUnknownKeyword;
declare function assertTSUnknownKeyword(node: object | null | undefined, opts?: object | null): void;
declare function isTSVoidKeyword(node: object | null | undefined, opts?: object | null): node is TSVoidKeyword;
declare function assertTSVoidKeyword(node: object | null | undefined, opts?: object | null): void;
declare function isTaggedTemplateExpression(node: object | null | undefined, opts?: object | null): node is TaggedTemplateExpression;
declare function assertTaggedTemplateExpression(node: object | null | undefined, opts?: object | null): void;
declare function isTemplateElement(node: object | null | undefined, opts?: object | null): node is TemplateElement;
declare function assertTemplateElement(node: object | null | undefined, opts?: object | null): void;
declare function isTemplateLiteral(node: object | null | undefined, opts?: object | null): node is TemplateLiteral;
declare function assertTemplateLiteral(node: object | null | undefined, opts?: object | null): void;
declare function isTerminatorless(node: object | null | undefined, opts?: object | null): node is Terminatorless;
declare function assertTerminatorless(node: object | null | undefined, opts?: object | null): void;
declare function isThisExpression(node: object | null | undefined, opts?: object | null): node is ThisExpression;
declare function assertThisExpression(node: object | null | undefined, opts?: object | null): void;
declare function isThisTypeAnnotation(node: object | null | undefined, opts?: object | null): node is ThisTypeAnnotation;
declare function assertThisTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isThrowStatement(node: object | null | undefined, opts?: object | null): node is ThrowStatement;
declare function assertThrowStatement(node: object | null | undefined, opts?: object | null): void;
declare function isTopicReference(node: object | null | undefined, opts?: object | null): node is TopicReference;
declare function assertTopicReference(node: object | null | undefined, opts?: object | null): void;
declare function isTryStatement(node: object | null | undefined, opts?: object | null): node is TryStatement;
declare function assertTryStatement(node: object | null | undefined, opts?: object | null): void;
declare function isTupleExpression(node: object | null | undefined, opts?: object | null): node is TupleExpression;
declare function assertTupleExpression(node: object | null | undefined, opts?: object | null): void;
declare function isTupleTypeAnnotation(node: object | null | undefined, opts?: object | null): node is TupleTypeAnnotation;
declare function assertTupleTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isTypeAlias(node: object | null | undefined, opts?: object | null): node is TypeAlias;
declare function assertTypeAlias(node: object | null | undefined, opts?: object | null): void;
declare function isTypeAnnotation(node: object | null | undefined, opts?: object | null): node is TypeAnnotation;
declare function assertTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isTypeCastExpression(node: object | null | undefined, opts?: object | null): node is TypeCastExpression;
declare function assertTypeCastExpression(node: object | null | undefined, opts?: object | null): void;
declare function isTypeParameter(node: object | null | undefined, opts?: object | null): node is TypeParameter;
declare function assertTypeParameter(node: object | null | undefined, opts?: object | null): void;
declare function isTypeParameterDeclaration(node: object | null | undefined, opts?: object | null): node is TypeParameterDeclaration;
declare function assertTypeParameterDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isTypeParameterInstantiation(node: object | null | undefined, opts?: object | null): node is TypeParameterInstantiation;
declare function assertTypeParameterInstantiation(node: object | null | undefined, opts?: object | null): void;
declare function isTypeScript(node: object | null | undefined, opts?: object | null): node is TypeScript;
declare function assertTypeScript(node: object | null | undefined, opts?: object | null): void;
declare function isTypeofTypeAnnotation(node: object | null | undefined, opts?: object | null): node is TypeofTypeAnnotation;
declare function assertTypeofTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isUnaryExpression(node: object | null | undefined, opts?: object | null): node is UnaryExpression;
declare function assertUnaryExpression(node: object | null | undefined, opts?: object | null): void;
declare function isUnaryLike(node: object | null | undefined, opts?: object | null): node is UnaryLike;
declare function assertUnaryLike(node: object | null | undefined, opts?: object | null): void;
declare function isUnionTypeAnnotation(node: object | null | undefined, opts?: object | null): node is UnionTypeAnnotation;
declare function assertUnionTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isUpdateExpression(node: object | null | undefined, opts?: object | null): node is UpdateExpression;
declare function assertUpdateExpression(node: object | null | undefined, opts?: object | null): void;
declare function isUserWhitespacable(node: object | null | undefined, opts?: object | null): node is UserWhitespacable;
declare function assertUserWhitespacable(node: object | null | undefined, opts?: object | null): void;
declare function isV8IntrinsicIdentifier(node: object | null | undefined, opts?: object | null): node is V8IntrinsicIdentifier;
declare function assertV8IntrinsicIdentifier(node: object | null | undefined, opts?: object | null): void;
declare function isVariableDeclaration(node: object | null | undefined, opts?: object | null): node is VariableDeclaration;
declare function assertVariableDeclaration(node: object | null | undefined, opts?: object | null): void;
declare function isVariableDeclarator(node: object | null | undefined, opts?: object | null): node is VariableDeclarator;
declare function assertVariableDeclarator(node: object | null | undefined, opts?: object | null): void;
declare function isVariance(node: object | null | undefined, opts?: object | null): node is Variance;
declare function assertVariance(node: object | null | undefined, opts?: object | null): void;
declare function isVoidTypeAnnotation(node: object | null | undefined, opts?: object | null): node is VoidTypeAnnotation;
declare function assertVoidTypeAnnotation(node: object | null | undefined, opts?: object | null): void;
declare function isWhile(node: object | null | undefined, opts?: object | null): node is While;
declare function assertWhile(node: object | null | undefined, opts?: object | null): void;
declare function isWhileStatement(node: object | null | undefined, opts?: object | null): node is WhileStatement;
declare function assertWhileStatement(node: object | null | undefined, opts?: object | null): void;
declare function isWithStatement(node: object | null | undefined, opts?: object | null): node is WithStatement;
declare function assertWithStatement(node: object | null | undefined, opts?: object | null): void;
declare function isYieldExpression(node: object | null | undefined, opts?: object | null): node is YieldExpression;
declare function assertYieldExpression(node: object | null | undefined, opts?: object | null): void;
declare function assertNode(obj: any): void
declare function createTypeAnnotationBasedOnTypeof(type: 'string' | 'number' | 'undefined' | 'boolean' | 'function' | 'object' | 'symbol'): StringTypeAnnotation | VoidTypeAnnotation | NumberTypeAnnotation | BooleanTypeAnnotation | GenericTypeAnnotation
declare function createUnionTypeAnnotation<T extends FlowType>(types: [T]): T
declare function createUnionTypeAnnotation(types: ReadonlyArray<FlowType>): UnionTypeAnnotation
declare function createFlowUnionType<T extends FlowType>(types: [T]): T
declare function createFlowUnionType(types: ReadonlyArray<FlowType>): UnionTypeAnnotation
declare function buildChildren(node: { children: ReadonlyArray<JSXText | JSXExpressionContainer | JSXSpreadChild | JSXElement | JSXFragment | JSXEmptyExpression> }): JSXElement['children']
declare function clone<T extends Node>(n: T): T;
declare function cloneDeep<T extends Node>(n: T): T;
declare function cloneDeepWithoutLoc<T extends Node>(n: T): T;
declare function cloneNode<T extends Node>(n: T, deep?: boolean, withoutLoc?: boolean): T;
declare function cloneWithoutLoc<T extends Node>(n: T): T;
type CommentTypeShorthand = 'leading' | 'inner' | 'trailing'
declare function addComment<T extends Node>(node: T, type: CommentTypeShorthand, content: string, line?: boolean): T
declare function addComments<T extends Node>(node: T, type: CommentTypeShorthand, comments: ReadonlyArray<Comment>): T
declare function inheritInnerComments(node: Node, parent: Node): void
declare function inheritLeadingComments(node: Node, parent: Node): void
declare function inheritsComments<T extends Node>(node: T, parent: Node): void
declare function inheritTrailingComments(node: Node, parent: Node): void
declare function removeComments<T extends Node>(node: T): T
declare function ensureBlock(node: Extract<Node, { body: BlockStatement | Statement | Expression }>): BlockStatement
declare function ensureBlock<K extends keyof Extract<Node, { body: BlockStatement | Statement | Expression }> = 'body'>(node: Extract<Node, Record<K, BlockStatement | Statement | Expression>>, key: K): BlockStatement
declare function toBindingIdentifierName(name: { toString(): string } | null | undefined): string
declare function toBlock(node: Statement | Expression, parent?: Function | null): BlockStatement
declare function toComputedKey<T extends Extract<Node, { computed: boolean | null }>>(node: T, key?: Expression | Identifier): Expression
declare function toExpression(node: Function): FunctionExpression
declare function toExpression(node: Class): ClassExpression
declare function toExpression(node: ExpressionStatement | Expression | Class | Function): Expression
declare function toIdentifier(name: { toString(): string } | null | undefined): string
declare function toKeyAlias(node: Method | Property, key?: Node): string
declare function toSequenceExpression(nodes: ReadonlyArray<Node>, scope: { push(value: { id: LVal; kind: 'var'; init?: Expression}): void; buildUndefinedNode(): Node }): SequenceExpression | undefined
declare function toStatement(node: AssignmentExpression, ignore?: boolean): ExpressionStatement
declare function toStatement(node: Statement | AssignmentExpression, ignore?: boolean): Statement
declare function toStatement(node: Class, ignore: true): ClassDeclaration | undefined
declare function toStatement(node: Class, ignore?: boolean): ClassDeclaration
declare function toStatement(node: Function, ignore: true): FunctionDeclaration | undefined
declare function toStatement(node: Function, ignore?: boolean): FunctionDeclaration
declare function toStatement(node: Statement | Class | Function | AssignmentExpression, ignore: true): Statement | undefined
declare function toStatement(node: Statement | Class | Function | AssignmentExpression, ignore?: boolean): Statement
declare function valueToNode(value: undefined): Identifier
declare function valueToNode(value: boolean): BooleanLiteral
declare function valueToNode(value: null): NullLiteral
declare function valueToNode(value: string): StringLiteral
declare function valueToNode(value: number): NumericLiteral | BinaryExpression | UnaryExpression
declare function valueToNode(value: RegExp): RegExpLiteral
declare function valueToNode(value: ReadonlyArray<undefined | boolean | null | string | number | RegExp | object>): ArrayExpression
declare function valueToNode(value: object): ObjectExpression
declare function valueToNode(value: undefined | boolean | null | string | number | RegExp | object): Expression
declare function removeTypeDuplicates(types: ReadonlyArray<FlowType | false | null | undefined>): FlowType[]
declare function appendToMemberExpression<T extends Pick<MemberExpression, 'object' | 'property'>>(member: T, append: MemberExpression['property'], computed?: boolean): T
declare function inherits<T extends Node | null | undefined>(child: T, parent: Node | null | undefined): T
declare function prependToMemberExpression<T extends Pick<MemberExpression, 'object' | 'property'>>(member: T, prepend: MemberExpression['object']): T
declare function removeProperties(
  n: Node,
  opts?: { preserveComments: boolean } | null
): void;
declare function removePropertiesDeep<T extends Node>(
  n: T,
  opts?: { preserveComments: boolean } | null
): T;
declare function getBindingIdentifiers(node: Node, duplicates: true, outerOnly?: boolean): Record<string, Array<Identifier>>
declare function getBindingIdentifiers(node: Node, duplicates?: false, outerOnly?: boolean): Record<string, Identifier>
declare function getBindingIdentifiers(node: Node, duplicates: boolean, outerOnly?: boolean): Record<string, Identifier | Array<Identifier>>
declare function getOuterBindingIdentifiers(node: Node, duplicates: true): Record<string, Array<Identifier>>
declare function getOuterBindingIdentifiers(node: Node, duplicates?: false): Record<string, Identifier>
declare function getOuterBindingIdentifiers(node: Node, duplicates: boolean): Record<string, Identifier | Array<Identifier>>
type TraversalAncestors = ReadonlyArray<{
  node: Node,
  key: string,
  index?: number,
}>;
type TraversalHandler<T> = (
  this: undefined, node: Node, parent: TraversalAncestors, type: T
) => void;
type TraversalHandlers<T> = {
  enter?: TraversalHandler<T>,
  exit?: TraversalHandler<T>,
};
declare function traverse<T>(n: Node, h: TraversalHandler<T> | TraversalHandlers<T>, state?: T): void;
declare function traverseFast<T>(n: Node, h: TraversalHandler<T>, state?: T): void;
declare function shallowEqual<T extends object>(actual: object, expected: T): actual is T
declare function buildMatchMemberExpression(match: string, allowPartial?: boolean): (node: Node | null | undefined) => node is MemberExpression
declare function is<T extends Node['type']>(type: T, n: Node | null | undefined, required?: undefined): n is Extract<Node, { type: T }>
declare function is<T extends Node['type'], P extends Extract<Node, { type: T }>>(type: T, n: Node | null | undefined, required: Partial<P>): n is P
declare function is<P extends Node>(type: string, n: Node | null | undefined, required: Partial<P>): n is P
declare function is(type: string, n: Node | null | undefined, required?: Partial<Node>): n is Node
declare function isBinding(node: Node, parent: Node, grandparent?: Node): boolean
declare function isBlockScoped(node: Node): node is FunctionDeclaration | ClassDeclaration | VariableDeclaration
declare function isImmutable(node: object | null | undefined, opts?: object | null): node is Immutable;
declare function isImmutable(node: Node): node is Immutable
declare function isLet(node: Node): node is VariableDeclaration
declare function isNode(node: object | null | undefined): node is Node
declare function isNodesEquivalent<T extends Partial<Node>>(a: T, b: any): b is T
declare function isNodesEquivalent(a: any, b: any): boolean
declare function isPlaceholderType(placeholderType: Node['type'], targetType: Node['type']): boolean
declare function isReferenced(node: Node, parent: Node, grandparent?: Node): boolean
declare function isScope(node: Node, parent: Node): node is Scopable
declare function isSpecifierDefault(specifier: ModuleSpecifier): boolean
declare function isType<T extends Node['type']>(nodetype: string, targetType: T): nodetype is T
declare function isType(nodetype: string | null | undefined, targetType: string): boolean
declare function isValidES3Identifier(name: string): boolean
declare function isValidIdentifier(name: string): boolean
declare function isVar(node: Node): node is VariableDeclaration
declare function matchesPattern(node: Node | null | undefined, match: string | ReadonlyArray<string>, allowPartial?: boolean): node is MemberExpression
declare function validate<T extends Node, K extends keyof T>(n: Node | null | undefined, key: K, value: T[K]): void;
declare function validate(n: Node, key: string, value: any): void;

type indexLegacy_d_Accessor = Accessor;
type indexLegacy_d_Aliases = Aliases;
type indexLegacy_d_AnyTypeAnnotation = AnyTypeAnnotation;
type indexLegacy_d_ArgumentPlaceholder = ArgumentPlaceholder;
type indexLegacy_d_ArrayExpression = ArrayExpression;
type indexLegacy_d_ArrayPattern = ArrayPattern;
type indexLegacy_d_ArrayTypeAnnotation = ArrayTypeAnnotation;
type indexLegacy_d_ArrowFunctionExpression = ArrowFunctionExpression;
type indexLegacy_d_AssignmentExpression = AssignmentExpression;
type indexLegacy_d_AssignmentPattern = AssignmentPattern;
type indexLegacy_d_AwaitExpression = AwaitExpression;
type indexLegacy_d_BigIntLiteral = BigIntLiteral;
type indexLegacy_d_Binary = Binary;
type indexLegacy_d_BinaryExpression = BinaryExpression;
type indexLegacy_d_BindExpression = BindExpression;
type indexLegacy_d_Block = Block;
type indexLegacy_d_BlockParent = BlockParent;
type indexLegacy_d_BlockStatement = BlockStatement;
type indexLegacy_d_BooleanLiteral = BooleanLiteral;
type indexLegacy_d_BooleanLiteralTypeAnnotation = BooleanLiteralTypeAnnotation;
type indexLegacy_d_BooleanTypeAnnotation = BooleanTypeAnnotation;
type indexLegacy_d_BreakStatement = BreakStatement;
type indexLegacy_d_CallExpression = CallExpression;
type indexLegacy_d_CatchClause = CatchClause;
type indexLegacy_d_Class = Class;
type indexLegacy_d_ClassAccessorProperty = ClassAccessorProperty;
type indexLegacy_d_ClassBody = ClassBody;
type indexLegacy_d_ClassDeclaration = ClassDeclaration;
type indexLegacy_d_ClassExpression = ClassExpression;
type indexLegacy_d_ClassImplements = ClassImplements;
type indexLegacy_d_ClassMethod = ClassMethod;
type indexLegacy_d_ClassPrivateMethod = ClassPrivateMethod;
type indexLegacy_d_ClassPrivateProperty = ClassPrivateProperty;
type indexLegacy_d_ClassProperty = ClassProperty;
type indexLegacy_d_Comment = Comment;
type indexLegacy_d_CommentBlock = CommentBlock;
type indexLegacy_d_CommentLine = CommentLine;
type indexLegacy_d_CommentTypeShorthand = CommentTypeShorthand;
type indexLegacy_d_CompletionStatement = CompletionStatement;
type indexLegacy_d_Conditional = Conditional;
type indexLegacy_d_ConditionalExpression = ConditionalExpression;
type indexLegacy_d_ContinueStatement = ContinueStatement;
type indexLegacy_d_DebuggerStatement = DebuggerStatement;
type indexLegacy_d_DecimalLiteral = DecimalLiteral;
type indexLegacy_d_Declaration = Declaration;
type indexLegacy_d_DeclareClass = DeclareClass;
type indexLegacy_d_DeclareExportAllDeclaration = DeclareExportAllDeclaration;
type indexLegacy_d_DeclareExportDeclaration = DeclareExportDeclaration;
type indexLegacy_d_DeclareFunction = DeclareFunction;
type indexLegacy_d_DeclareInterface = DeclareInterface;
type indexLegacy_d_DeclareModule = DeclareModule;
type indexLegacy_d_DeclareModuleExports = DeclareModuleExports;
type indexLegacy_d_DeclareOpaqueType = DeclareOpaqueType;
type indexLegacy_d_DeclareTypeAlias = DeclareTypeAlias;
type indexLegacy_d_DeclareVariable = DeclareVariable;
type indexLegacy_d_DeclaredPredicate = DeclaredPredicate;
type indexLegacy_d_Decorator = Decorator;
type indexLegacy_d_Directive = Directive;
type indexLegacy_d_DirectiveLiteral = DirectiveLiteral;
type indexLegacy_d_DoExpression = DoExpression;
type indexLegacy_d_DoWhileStatement = DoWhileStatement;
type indexLegacy_d_EmptyStatement = EmptyStatement;
type indexLegacy_d_EmptyTypeAnnotation = EmptyTypeAnnotation;
type indexLegacy_d_EnumBody = EnumBody;
type indexLegacy_d_EnumBooleanBody = EnumBooleanBody;
type indexLegacy_d_EnumBooleanMember = EnumBooleanMember;
type indexLegacy_d_EnumDeclaration = EnumDeclaration;
type indexLegacy_d_EnumDefaultedMember = EnumDefaultedMember;
type indexLegacy_d_EnumMember = EnumMember;
type indexLegacy_d_EnumNumberBody = EnumNumberBody;
type indexLegacy_d_EnumNumberMember = EnumNumberMember;
type indexLegacy_d_EnumStringBody = EnumStringBody;
type indexLegacy_d_EnumStringMember = EnumStringMember;
type indexLegacy_d_EnumSymbolBody = EnumSymbolBody;
type indexLegacy_d_ExistsTypeAnnotation = ExistsTypeAnnotation;
type indexLegacy_d_ExportAllDeclaration = ExportAllDeclaration;
type indexLegacy_d_ExportDeclaration = ExportDeclaration;
type indexLegacy_d_ExportDefaultDeclaration = ExportDefaultDeclaration;
type indexLegacy_d_ExportDefaultSpecifier = ExportDefaultSpecifier;
type indexLegacy_d_ExportNamedDeclaration = ExportNamedDeclaration;
type indexLegacy_d_ExportNamespaceSpecifier = ExportNamespaceSpecifier;
type indexLegacy_d_ExportSpecifier = ExportSpecifier;
type indexLegacy_d_Expression = Expression;
type indexLegacy_d_ExpressionStatement = ExpressionStatement;
type indexLegacy_d_ExpressionWrapper = ExpressionWrapper;
type indexLegacy_d_File = File;
type indexLegacy_d_Flow = Flow;
type indexLegacy_d_FlowBaseAnnotation = FlowBaseAnnotation;
type indexLegacy_d_FlowDeclaration = FlowDeclaration;
type indexLegacy_d_FlowPredicate = FlowPredicate;
type indexLegacy_d_FlowType = FlowType;
type indexLegacy_d_For = For;
type indexLegacy_d_ForInStatement = ForInStatement;
type indexLegacy_d_ForOfStatement = ForOfStatement;
type indexLegacy_d_ForStatement = ForStatement;
type indexLegacy_d_ForXStatement = ForXStatement;
type indexLegacy_d_Function = Function;
type indexLegacy_d_FunctionDeclaration = FunctionDeclaration;
type indexLegacy_d_FunctionExpression = FunctionExpression;
type indexLegacy_d_FunctionParent = FunctionParent;
type indexLegacy_d_FunctionTypeAnnotation = FunctionTypeAnnotation;
type indexLegacy_d_FunctionTypeParam = FunctionTypeParam;
type indexLegacy_d_GenericTypeAnnotation = GenericTypeAnnotation;
type indexLegacy_d_Identifier = Identifier;
type indexLegacy_d_IfStatement = IfStatement;
type indexLegacy_d_Immutable = Immutable;
type indexLegacy_d_Import = Import;
type indexLegacy_d_ImportAttribute = ImportAttribute;
type indexLegacy_d_ImportDeclaration = ImportDeclaration;
type indexLegacy_d_ImportDefaultSpecifier = ImportDefaultSpecifier;
type indexLegacy_d_ImportExpression = ImportExpression;
type indexLegacy_d_ImportNamespaceSpecifier = ImportNamespaceSpecifier;
type indexLegacy_d_ImportOrExportDeclaration = ImportOrExportDeclaration;
type indexLegacy_d_ImportSpecifier = ImportSpecifier;
type indexLegacy_d_IndexedAccessType = IndexedAccessType;
type indexLegacy_d_InferredPredicate = InferredPredicate;
type indexLegacy_d_InterfaceDeclaration = InterfaceDeclaration;
type indexLegacy_d_InterfaceExtends = InterfaceExtends;
type indexLegacy_d_InterfaceTypeAnnotation = InterfaceTypeAnnotation;
type indexLegacy_d_InterpreterDirective = InterpreterDirective;
type indexLegacy_d_IntersectionTypeAnnotation = IntersectionTypeAnnotation;
type indexLegacy_d_JSX = JSX;
type indexLegacy_d_JSXAttribute = JSXAttribute;
type indexLegacy_d_JSXClosingElement = JSXClosingElement;
type indexLegacy_d_JSXClosingFragment = JSXClosingFragment;
type indexLegacy_d_JSXElement = JSXElement;
type indexLegacy_d_JSXEmptyExpression = JSXEmptyExpression;
type indexLegacy_d_JSXExpressionContainer = JSXExpressionContainer;
type indexLegacy_d_JSXFragment = JSXFragment;
type indexLegacy_d_JSXIdentifier = JSXIdentifier;
type indexLegacy_d_JSXMemberExpression = JSXMemberExpression;
type indexLegacy_d_JSXNamespacedName = JSXNamespacedName;
type indexLegacy_d_JSXOpeningElement = JSXOpeningElement;
type indexLegacy_d_JSXOpeningFragment = JSXOpeningFragment;
type indexLegacy_d_JSXSpreadAttribute = JSXSpreadAttribute;
type indexLegacy_d_JSXSpreadChild = JSXSpreadChild;
type indexLegacy_d_JSXText = JSXText;
type indexLegacy_d_LVal = LVal;
type indexLegacy_d_LabeledStatement = LabeledStatement;
type indexLegacy_d_Literal = Literal;
type indexLegacy_d_LogicalExpression = LogicalExpression;
type indexLegacy_d_Loop = Loop;
type indexLegacy_d_MemberExpression = MemberExpression;
type indexLegacy_d_MetaProperty = MetaProperty;
type indexLegacy_d_Method = Method;
type indexLegacy_d_Miscellaneous = Miscellaneous;
type indexLegacy_d_MixedTypeAnnotation = MixedTypeAnnotation;
type indexLegacy_d_ModuleDeclaration = ModuleDeclaration;
type indexLegacy_d_ModuleExpression = ModuleExpression;
type indexLegacy_d_ModuleSpecifier = ModuleSpecifier;
type indexLegacy_d_NewExpression = NewExpression;
type indexLegacy_d_Node = Node;
type indexLegacy_d_NullLiteral = NullLiteral;
type indexLegacy_d_NullLiteralTypeAnnotation = NullLiteralTypeAnnotation;
type indexLegacy_d_NullableTypeAnnotation = NullableTypeAnnotation;
type indexLegacy_d_NumberLiteral = NumberLiteral;
type indexLegacy_d_NumberLiteralTypeAnnotation = NumberLiteralTypeAnnotation;
type indexLegacy_d_NumberTypeAnnotation = NumberTypeAnnotation;
type indexLegacy_d_NumericLiteral = NumericLiteral;
type indexLegacy_d_ObjectExpression = ObjectExpression;
type indexLegacy_d_ObjectMember = ObjectMember;
type indexLegacy_d_ObjectMethod = ObjectMethod;
type indexLegacy_d_ObjectPattern = ObjectPattern;
type indexLegacy_d_ObjectProperty = ObjectProperty;
type indexLegacy_d_ObjectTypeAnnotation = ObjectTypeAnnotation;
type indexLegacy_d_ObjectTypeCallProperty = ObjectTypeCallProperty;
type indexLegacy_d_ObjectTypeIndexer = ObjectTypeIndexer;
type indexLegacy_d_ObjectTypeInternalSlot = ObjectTypeInternalSlot;
type indexLegacy_d_ObjectTypeProperty = ObjectTypeProperty;
type indexLegacy_d_ObjectTypeSpreadProperty = ObjectTypeSpreadProperty;
type indexLegacy_d_OpaqueType = OpaqueType;
type indexLegacy_d_OptionalCallExpression = OptionalCallExpression;
type indexLegacy_d_OptionalIndexedAccessType = OptionalIndexedAccessType;
type indexLegacy_d_OptionalMemberExpression = OptionalMemberExpression;
type indexLegacy_d_ParenthesizedExpression = ParenthesizedExpression;
type indexLegacy_d_Pattern = Pattern;
type indexLegacy_d_PatternLike = PatternLike;
type indexLegacy_d_PipelineBareFunction = PipelineBareFunction;
type indexLegacy_d_PipelinePrimaryTopicReference = PipelinePrimaryTopicReference;
type indexLegacy_d_PipelineTopicExpression = PipelineTopicExpression;
type indexLegacy_d_Placeholder = Placeholder;
type indexLegacy_d_Private = Private;
type indexLegacy_d_PrivateName = PrivateName;
type indexLegacy_d_Program = Program;
type indexLegacy_d_Property = Property;
type indexLegacy_d_Pureish = Pureish;
type indexLegacy_d_QualifiedTypeIdentifier = QualifiedTypeIdentifier;
type indexLegacy_d_RecordExpression = RecordExpression;
type indexLegacy_d_RegExpLiteral = RegExpLiteral;
type indexLegacy_d_RegexLiteral = RegexLiteral;
type indexLegacy_d_RestElement = RestElement;
type indexLegacy_d_RestProperty = RestProperty;
type indexLegacy_d_ReturnStatement = ReturnStatement;
type indexLegacy_d_Scopable = Scopable;
type indexLegacy_d_SequenceExpression = SequenceExpression;
type indexLegacy_d_SourceLocation = SourceLocation;
type indexLegacy_d_SpreadElement = SpreadElement;
type indexLegacy_d_SpreadProperty = SpreadProperty;
type indexLegacy_d_Standardized = Standardized;
type indexLegacy_d_Statement = Statement;
type indexLegacy_d_StaticBlock = StaticBlock;
type indexLegacy_d_StringLiteral = StringLiteral;
type indexLegacy_d_StringLiteralTypeAnnotation = StringLiteralTypeAnnotation;
type indexLegacy_d_StringTypeAnnotation = StringTypeAnnotation;
type indexLegacy_d_Super = Super;
type indexLegacy_d_SwitchCase = SwitchCase;
type indexLegacy_d_SwitchStatement = SwitchStatement;
type indexLegacy_d_SymbolTypeAnnotation = SymbolTypeAnnotation;
type indexLegacy_d_TSAnyKeyword = TSAnyKeyword;
type indexLegacy_d_TSArrayType = TSArrayType;
type indexLegacy_d_TSAsExpression = TSAsExpression;
type indexLegacy_d_TSBaseType = TSBaseType;
type indexLegacy_d_TSBigIntKeyword = TSBigIntKeyword;
type indexLegacy_d_TSBooleanKeyword = TSBooleanKeyword;
type indexLegacy_d_TSCallSignatureDeclaration = TSCallSignatureDeclaration;
type indexLegacy_d_TSConditionalType = TSConditionalType;
type indexLegacy_d_TSConstructSignatureDeclaration = TSConstructSignatureDeclaration;
type indexLegacy_d_TSConstructorType = TSConstructorType;
type indexLegacy_d_TSDeclareFunction = TSDeclareFunction;
type indexLegacy_d_TSDeclareMethod = TSDeclareMethod;
type indexLegacy_d_TSEntityName = TSEntityName;
type indexLegacy_d_TSEnumDeclaration = TSEnumDeclaration;
type indexLegacy_d_TSEnumMember = TSEnumMember;
type indexLegacy_d_TSExportAssignment = TSExportAssignment;
type indexLegacy_d_TSExpressionWithTypeArguments = TSExpressionWithTypeArguments;
type indexLegacy_d_TSExternalModuleReference = TSExternalModuleReference;
type indexLegacy_d_TSFunctionType = TSFunctionType;
type indexLegacy_d_TSImportEqualsDeclaration = TSImportEqualsDeclaration;
type indexLegacy_d_TSImportType = TSImportType;
type indexLegacy_d_TSIndexSignature = TSIndexSignature;
type indexLegacy_d_TSIndexedAccessType = TSIndexedAccessType;
type indexLegacy_d_TSInferType = TSInferType;
type indexLegacy_d_TSInstantiationExpression = TSInstantiationExpression;
type indexLegacy_d_TSInterfaceBody = TSInterfaceBody;
type indexLegacy_d_TSInterfaceDeclaration = TSInterfaceDeclaration;
type indexLegacy_d_TSIntersectionType = TSIntersectionType;
type indexLegacy_d_TSIntrinsicKeyword = TSIntrinsicKeyword;
type indexLegacy_d_TSLiteralType = TSLiteralType;
type indexLegacy_d_TSMappedType = TSMappedType;
type indexLegacy_d_TSMethodSignature = TSMethodSignature;
type indexLegacy_d_TSModuleBlock = TSModuleBlock;
type indexLegacy_d_TSModuleDeclaration = TSModuleDeclaration;
type indexLegacy_d_TSNamedTupleMember = TSNamedTupleMember;
type indexLegacy_d_TSNamespaceExportDeclaration = TSNamespaceExportDeclaration;
type indexLegacy_d_TSNeverKeyword = TSNeverKeyword;
type indexLegacy_d_TSNonNullExpression = TSNonNullExpression;
type indexLegacy_d_TSNullKeyword = TSNullKeyword;
type indexLegacy_d_TSNumberKeyword = TSNumberKeyword;
type indexLegacy_d_TSObjectKeyword = TSObjectKeyword;
type indexLegacy_d_TSOptionalType = TSOptionalType;
type indexLegacy_d_TSParameterProperty = TSParameterProperty;
type indexLegacy_d_TSParenthesizedType = TSParenthesizedType;
type indexLegacy_d_TSPropertySignature = TSPropertySignature;
type indexLegacy_d_TSQualifiedName = TSQualifiedName;
type indexLegacy_d_TSRestType = TSRestType;
type indexLegacy_d_TSSatisfiesExpression = TSSatisfiesExpression;
type indexLegacy_d_TSStringKeyword = TSStringKeyword;
type indexLegacy_d_TSSymbolKeyword = TSSymbolKeyword;
type indexLegacy_d_TSThisType = TSThisType;
type indexLegacy_d_TSTupleType = TSTupleType;
type indexLegacy_d_TSType = TSType;
type indexLegacy_d_TSTypeAliasDeclaration = TSTypeAliasDeclaration;
type indexLegacy_d_TSTypeAnnotation = TSTypeAnnotation;
type indexLegacy_d_TSTypeAssertion = TSTypeAssertion;
type indexLegacy_d_TSTypeElement = TSTypeElement;
type indexLegacy_d_TSTypeLiteral = TSTypeLiteral;
type indexLegacy_d_TSTypeOperator = TSTypeOperator;
type indexLegacy_d_TSTypeParameter = TSTypeParameter;
type indexLegacy_d_TSTypeParameterDeclaration = TSTypeParameterDeclaration;
type indexLegacy_d_TSTypeParameterInstantiation = TSTypeParameterInstantiation;
type indexLegacy_d_TSTypePredicate = TSTypePredicate;
type indexLegacy_d_TSTypeQuery = TSTypeQuery;
type indexLegacy_d_TSTypeReference = TSTypeReference;
type indexLegacy_d_TSUndefinedKeyword = TSUndefinedKeyword;
type indexLegacy_d_TSUnionType = TSUnionType;
type indexLegacy_d_TSUnknownKeyword = TSUnknownKeyword;
type indexLegacy_d_TSVoidKeyword = TSVoidKeyword;
type indexLegacy_d_TaggedTemplateExpression = TaggedTemplateExpression;
type indexLegacy_d_TemplateElement = TemplateElement;
type indexLegacy_d_TemplateLiteral = TemplateLiteral;
type indexLegacy_d_Terminatorless = Terminatorless;
type indexLegacy_d_ThisExpression = ThisExpression;
type indexLegacy_d_ThisTypeAnnotation = ThisTypeAnnotation;
type indexLegacy_d_ThrowStatement = ThrowStatement;
type indexLegacy_d_TopicReference = TopicReference;
type indexLegacy_d_TraversalAncestors = TraversalAncestors;
type indexLegacy_d_TraversalHandler<T> = TraversalHandler<T>;
type indexLegacy_d_TraversalHandlers<T> = TraversalHandlers<T>;
type indexLegacy_d_TryStatement = TryStatement;
type indexLegacy_d_TupleExpression = TupleExpression;
type indexLegacy_d_TupleTypeAnnotation = TupleTypeAnnotation;
type indexLegacy_d_TypeAlias = TypeAlias;
type indexLegacy_d_TypeAnnotation = TypeAnnotation;
type indexLegacy_d_TypeCastExpression = TypeCastExpression;
type indexLegacy_d_TypeParameter = TypeParameter;
type indexLegacy_d_TypeParameterDeclaration = TypeParameterDeclaration;
type indexLegacy_d_TypeParameterInstantiation = TypeParameterInstantiation;
type indexLegacy_d_TypeScript = TypeScript;
type indexLegacy_d_TypeofTypeAnnotation = TypeofTypeAnnotation;
type indexLegacy_d_UnaryExpression = UnaryExpression;
type indexLegacy_d_UnaryLike = UnaryLike;
type indexLegacy_d_UnionTypeAnnotation = UnionTypeAnnotation;
type indexLegacy_d_UpdateExpression = UpdateExpression;
type indexLegacy_d_UserWhitespacable = UserWhitespacable;
type indexLegacy_d_V8IntrinsicIdentifier = V8IntrinsicIdentifier;
type indexLegacy_d_VariableDeclaration = VariableDeclaration;
type indexLegacy_d_VariableDeclarator = VariableDeclarator;
type indexLegacy_d_Variance = Variance;
type indexLegacy_d_VoidTypeAnnotation = VoidTypeAnnotation;
type indexLegacy_d_While = While;
type indexLegacy_d_WhileStatement = WhileStatement;
type indexLegacy_d_WithStatement = WithStatement;
type indexLegacy_d_YieldExpression = YieldExpression;
declare const indexLegacy_d_addComment: typeof addComment;
declare const indexLegacy_d_addComments: typeof addComments;
declare const indexLegacy_d_anyTypeAnnotation: typeof anyTypeAnnotation;
declare const indexLegacy_d_appendToMemberExpression: typeof appendToMemberExpression;
declare const indexLegacy_d_argumentPlaceholder: typeof argumentPlaceholder;
declare const indexLegacy_d_arrayExpression: typeof arrayExpression;
declare const indexLegacy_d_arrayPattern: typeof arrayPattern;
declare const indexLegacy_d_arrayTypeAnnotation: typeof arrayTypeAnnotation;
declare const indexLegacy_d_arrowFunctionExpression: typeof arrowFunctionExpression;
declare const indexLegacy_d_assertAccessor: typeof assertAccessor;
declare const indexLegacy_d_assertAnyTypeAnnotation: typeof assertAnyTypeAnnotation;
declare const indexLegacy_d_assertArgumentPlaceholder: typeof assertArgumentPlaceholder;
declare const indexLegacy_d_assertArrayExpression: typeof assertArrayExpression;
declare const indexLegacy_d_assertArrayPattern: typeof assertArrayPattern;
declare const indexLegacy_d_assertArrayTypeAnnotation: typeof assertArrayTypeAnnotation;
declare const indexLegacy_d_assertArrowFunctionExpression: typeof assertArrowFunctionExpression;
declare const indexLegacy_d_assertAssignmentExpression: typeof assertAssignmentExpression;
declare const indexLegacy_d_assertAssignmentPattern: typeof assertAssignmentPattern;
declare const indexLegacy_d_assertAwaitExpression: typeof assertAwaitExpression;
declare const indexLegacy_d_assertBigIntLiteral: typeof assertBigIntLiteral;
declare const indexLegacy_d_assertBinary: typeof assertBinary;
declare const indexLegacy_d_assertBinaryExpression: typeof assertBinaryExpression;
declare const indexLegacy_d_assertBindExpression: typeof assertBindExpression;
declare const indexLegacy_d_assertBlock: typeof assertBlock;
declare const indexLegacy_d_assertBlockParent: typeof assertBlockParent;
declare const indexLegacy_d_assertBlockStatement: typeof assertBlockStatement;
declare const indexLegacy_d_assertBooleanLiteral: typeof assertBooleanLiteral;
declare const indexLegacy_d_assertBooleanLiteralTypeAnnotation: typeof assertBooleanLiteralTypeAnnotation;
declare const indexLegacy_d_assertBooleanTypeAnnotation: typeof assertBooleanTypeAnnotation;
declare const indexLegacy_d_assertBreakStatement: typeof assertBreakStatement;
declare const indexLegacy_d_assertCallExpression: typeof assertCallExpression;
declare const indexLegacy_d_assertCatchClause: typeof assertCatchClause;
declare const indexLegacy_d_assertClass: typeof assertClass;
declare const indexLegacy_d_assertClassAccessorProperty: typeof assertClassAccessorProperty;
declare const indexLegacy_d_assertClassBody: typeof assertClassBody;
declare const indexLegacy_d_assertClassDeclaration: typeof assertClassDeclaration;
declare const indexLegacy_d_assertClassExpression: typeof assertClassExpression;
declare const indexLegacy_d_assertClassImplements: typeof assertClassImplements;
declare const indexLegacy_d_assertClassMethod: typeof assertClassMethod;
declare const indexLegacy_d_assertClassPrivateMethod: typeof assertClassPrivateMethod;
declare const indexLegacy_d_assertClassPrivateProperty: typeof assertClassPrivateProperty;
declare const indexLegacy_d_assertClassProperty: typeof assertClassProperty;
declare const indexLegacy_d_assertCompletionStatement: typeof assertCompletionStatement;
declare const indexLegacy_d_assertConditional: typeof assertConditional;
declare const indexLegacy_d_assertConditionalExpression: typeof assertConditionalExpression;
declare const indexLegacy_d_assertContinueStatement: typeof assertContinueStatement;
declare const indexLegacy_d_assertDebuggerStatement: typeof assertDebuggerStatement;
declare const indexLegacy_d_assertDecimalLiteral: typeof assertDecimalLiteral;
declare const indexLegacy_d_assertDeclaration: typeof assertDeclaration;
declare const indexLegacy_d_assertDeclareClass: typeof assertDeclareClass;
declare const indexLegacy_d_assertDeclareExportAllDeclaration: typeof assertDeclareExportAllDeclaration;
declare const indexLegacy_d_assertDeclareExportDeclaration: typeof assertDeclareExportDeclaration;
declare const indexLegacy_d_assertDeclareFunction: typeof assertDeclareFunction;
declare const indexLegacy_d_assertDeclareInterface: typeof assertDeclareInterface;
declare const indexLegacy_d_assertDeclareModule: typeof assertDeclareModule;
declare const indexLegacy_d_assertDeclareModuleExports: typeof assertDeclareModuleExports;
declare const indexLegacy_d_assertDeclareOpaqueType: typeof assertDeclareOpaqueType;
declare const indexLegacy_d_assertDeclareTypeAlias: typeof assertDeclareTypeAlias;
declare const indexLegacy_d_assertDeclareVariable: typeof assertDeclareVariable;
declare const indexLegacy_d_assertDeclaredPredicate: typeof assertDeclaredPredicate;
declare const indexLegacy_d_assertDecorator: typeof assertDecorator;
declare const indexLegacy_d_assertDirective: typeof assertDirective;
declare const indexLegacy_d_assertDirectiveLiteral: typeof assertDirectiveLiteral;
declare const indexLegacy_d_assertDoExpression: typeof assertDoExpression;
declare const indexLegacy_d_assertDoWhileStatement: typeof assertDoWhileStatement;
declare const indexLegacy_d_assertEmptyStatement: typeof assertEmptyStatement;
declare const indexLegacy_d_assertEmptyTypeAnnotation: typeof assertEmptyTypeAnnotation;
declare const indexLegacy_d_assertEnumBody: typeof assertEnumBody;
declare const indexLegacy_d_assertEnumBooleanBody: typeof assertEnumBooleanBody;
declare const indexLegacy_d_assertEnumBooleanMember: typeof assertEnumBooleanMember;
declare const indexLegacy_d_assertEnumDeclaration: typeof assertEnumDeclaration;
declare const indexLegacy_d_assertEnumDefaultedMember: typeof assertEnumDefaultedMember;
declare const indexLegacy_d_assertEnumMember: typeof assertEnumMember;
declare const indexLegacy_d_assertEnumNumberBody: typeof assertEnumNumberBody;
declare const indexLegacy_d_assertEnumNumberMember: typeof assertEnumNumberMember;
declare const indexLegacy_d_assertEnumStringBody: typeof assertEnumStringBody;
declare const indexLegacy_d_assertEnumStringMember: typeof assertEnumStringMember;
declare const indexLegacy_d_assertEnumSymbolBody: typeof assertEnumSymbolBody;
declare const indexLegacy_d_assertExistsTypeAnnotation: typeof assertExistsTypeAnnotation;
declare const indexLegacy_d_assertExportAllDeclaration: typeof assertExportAllDeclaration;
declare const indexLegacy_d_assertExportDeclaration: typeof assertExportDeclaration;
declare const indexLegacy_d_assertExportDefaultDeclaration: typeof assertExportDefaultDeclaration;
declare const indexLegacy_d_assertExportDefaultSpecifier: typeof assertExportDefaultSpecifier;
declare const indexLegacy_d_assertExportNamedDeclaration: typeof assertExportNamedDeclaration;
declare const indexLegacy_d_assertExportNamespaceSpecifier: typeof assertExportNamespaceSpecifier;
declare const indexLegacy_d_assertExportSpecifier: typeof assertExportSpecifier;
declare const indexLegacy_d_assertExpression: typeof assertExpression;
declare const indexLegacy_d_assertExpressionStatement: typeof assertExpressionStatement;
declare const indexLegacy_d_assertExpressionWrapper: typeof assertExpressionWrapper;
declare const indexLegacy_d_assertFile: typeof assertFile;
declare const indexLegacy_d_assertFlow: typeof assertFlow;
declare const indexLegacy_d_assertFlowBaseAnnotation: typeof assertFlowBaseAnnotation;
declare const indexLegacy_d_assertFlowDeclaration: typeof assertFlowDeclaration;
declare const indexLegacy_d_assertFlowPredicate: typeof assertFlowPredicate;
declare const indexLegacy_d_assertFlowType: typeof assertFlowType;
declare const indexLegacy_d_assertFor: typeof assertFor;
declare const indexLegacy_d_assertForInStatement: typeof assertForInStatement;
declare const indexLegacy_d_assertForOfStatement: typeof assertForOfStatement;
declare const indexLegacy_d_assertForStatement: typeof assertForStatement;
declare const indexLegacy_d_assertForXStatement: typeof assertForXStatement;
declare const indexLegacy_d_assertFunction: typeof assertFunction;
declare const indexLegacy_d_assertFunctionDeclaration: typeof assertFunctionDeclaration;
declare const indexLegacy_d_assertFunctionExpression: typeof assertFunctionExpression;
declare const indexLegacy_d_assertFunctionParent: typeof assertFunctionParent;
declare const indexLegacy_d_assertFunctionTypeAnnotation: typeof assertFunctionTypeAnnotation;
declare const indexLegacy_d_assertFunctionTypeParam: typeof assertFunctionTypeParam;
declare const indexLegacy_d_assertGenericTypeAnnotation: typeof assertGenericTypeAnnotation;
declare const indexLegacy_d_assertIdentifier: typeof assertIdentifier;
declare const indexLegacy_d_assertIfStatement: typeof assertIfStatement;
declare const indexLegacy_d_assertImmutable: typeof assertImmutable;
declare const indexLegacy_d_assertImport: typeof assertImport;
declare const indexLegacy_d_assertImportAttribute: typeof assertImportAttribute;
declare const indexLegacy_d_assertImportDeclaration: typeof assertImportDeclaration;
declare const indexLegacy_d_assertImportDefaultSpecifier: typeof assertImportDefaultSpecifier;
declare const indexLegacy_d_assertImportExpression: typeof assertImportExpression;
declare const indexLegacy_d_assertImportNamespaceSpecifier: typeof assertImportNamespaceSpecifier;
declare const indexLegacy_d_assertImportOrExportDeclaration: typeof assertImportOrExportDeclaration;
declare const indexLegacy_d_assertImportSpecifier: typeof assertImportSpecifier;
declare const indexLegacy_d_assertIndexedAccessType: typeof assertIndexedAccessType;
declare const indexLegacy_d_assertInferredPredicate: typeof assertInferredPredicate;
declare const indexLegacy_d_assertInterfaceDeclaration: typeof assertInterfaceDeclaration;
declare const indexLegacy_d_assertInterfaceExtends: typeof assertInterfaceExtends;
declare const indexLegacy_d_assertInterfaceTypeAnnotation: typeof assertInterfaceTypeAnnotation;
declare const indexLegacy_d_assertInterpreterDirective: typeof assertInterpreterDirective;
declare const indexLegacy_d_assertIntersectionTypeAnnotation: typeof assertIntersectionTypeAnnotation;
declare const indexLegacy_d_assertJSX: typeof assertJSX;
declare const indexLegacy_d_assertJSXAttribute: typeof assertJSXAttribute;
declare const indexLegacy_d_assertJSXClosingElement: typeof assertJSXClosingElement;
declare const indexLegacy_d_assertJSXClosingFragment: typeof assertJSXClosingFragment;
declare const indexLegacy_d_assertJSXElement: typeof assertJSXElement;
declare const indexLegacy_d_assertJSXEmptyExpression: typeof assertJSXEmptyExpression;
declare const indexLegacy_d_assertJSXExpressionContainer: typeof assertJSXExpressionContainer;
declare const indexLegacy_d_assertJSXFragment: typeof assertJSXFragment;
declare const indexLegacy_d_assertJSXIdentifier: typeof assertJSXIdentifier;
declare const indexLegacy_d_assertJSXMemberExpression: typeof assertJSXMemberExpression;
declare const indexLegacy_d_assertJSXNamespacedName: typeof assertJSXNamespacedName;
declare const indexLegacy_d_assertJSXOpeningElement: typeof assertJSXOpeningElement;
declare const indexLegacy_d_assertJSXOpeningFragment: typeof assertJSXOpeningFragment;
declare const indexLegacy_d_assertJSXSpreadAttribute: typeof assertJSXSpreadAttribute;
declare const indexLegacy_d_assertJSXSpreadChild: typeof assertJSXSpreadChild;
declare const indexLegacy_d_assertJSXText: typeof assertJSXText;
declare const indexLegacy_d_assertLVal: typeof assertLVal;
declare const indexLegacy_d_assertLabeledStatement: typeof assertLabeledStatement;
declare const indexLegacy_d_assertLiteral: typeof assertLiteral;
declare const indexLegacy_d_assertLogicalExpression: typeof assertLogicalExpression;
declare const indexLegacy_d_assertLoop: typeof assertLoop;
declare const indexLegacy_d_assertMemberExpression: typeof assertMemberExpression;
declare const indexLegacy_d_assertMetaProperty: typeof assertMetaProperty;
declare const indexLegacy_d_assertMethod: typeof assertMethod;
declare const indexLegacy_d_assertMiscellaneous: typeof assertMiscellaneous;
declare const indexLegacy_d_assertMixedTypeAnnotation: typeof assertMixedTypeAnnotation;
declare const indexLegacy_d_assertModuleDeclaration: typeof assertModuleDeclaration;
declare const indexLegacy_d_assertModuleExpression: typeof assertModuleExpression;
declare const indexLegacy_d_assertModuleSpecifier: typeof assertModuleSpecifier;
declare const indexLegacy_d_assertNewExpression: typeof assertNewExpression;
declare const indexLegacy_d_assertNode: typeof assertNode;
declare const indexLegacy_d_assertNullLiteral: typeof assertNullLiteral;
declare const indexLegacy_d_assertNullLiteralTypeAnnotation: typeof assertNullLiteralTypeAnnotation;
declare const indexLegacy_d_assertNullableTypeAnnotation: typeof assertNullableTypeAnnotation;
declare const indexLegacy_d_assertNumberLiteral: typeof assertNumberLiteral;
declare const indexLegacy_d_assertNumberLiteralTypeAnnotation: typeof assertNumberLiteralTypeAnnotation;
declare const indexLegacy_d_assertNumberTypeAnnotation: typeof assertNumberTypeAnnotation;
declare const indexLegacy_d_assertNumericLiteral: typeof assertNumericLiteral;
declare const indexLegacy_d_assertObjectExpression: typeof assertObjectExpression;
declare const indexLegacy_d_assertObjectMember: typeof assertObjectMember;
declare const indexLegacy_d_assertObjectMethod: typeof assertObjectMethod;
declare const indexLegacy_d_assertObjectPattern: typeof assertObjectPattern;
declare const indexLegacy_d_assertObjectProperty: typeof assertObjectProperty;
declare const indexLegacy_d_assertObjectTypeAnnotation: typeof assertObjectTypeAnnotation;
declare const indexLegacy_d_assertObjectTypeCallProperty: typeof assertObjectTypeCallProperty;
declare const indexLegacy_d_assertObjectTypeIndexer: typeof assertObjectTypeIndexer;
declare const indexLegacy_d_assertObjectTypeInternalSlot: typeof assertObjectTypeInternalSlot;
declare const indexLegacy_d_assertObjectTypeProperty: typeof assertObjectTypeProperty;
declare const indexLegacy_d_assertObjectTypeSpreadProperty: typeof assertObjectTypeSpreadProperty;
declare const indexLegacy_d_assertOpaqueType: typeof assertOpaqueType;
declare const indexLegacy_d_assertOptionalCallExpression: typeof assertOptionalCallExpression;
declare const indexLegacy_d_assertOptionalIndexedAccessType: typeof assertOptionalIndexedAccessType;
declare const indexLegacy_d_assertOptionalMemberExpression: typeof assertOptionalMemberExpression;
declare const indexLegacy_d_assertParenthesizedExpression: typeof assertParenthesizedExpression;
declare const indexLegacy_d_assertPattern: typeof assertPattern;
declare const indexLegacy_d_assertPatternLike: typeof assertPatternLike;
declare const indexLegacy_d_assertPipelineBareFunction: typeof assertPipelineBareFunction;
declare const indexLegacy_d_assertPipelinePrimaryTopicReference: typeof assertPipelinePrimaryTopicReference;
declare const indexLegacy_d_assertPipelineTopicExpression: typeof assertPipelineTopicExpression;
declare const indexLegacy_d_assertPlaceholder: typeof assertPlaceholder;
declare const indexLegacy_d_assertPrivate: typeof assertPrivate;
declare const indexLegacy_d_assertPrivateName: typeof assertPrivateName;
declare const indexLegacy_d_assertProgram: typeof assertProgram;
declare const indexLegacy_d_assertProperty: typeof assertProperty;
declare const indexLegacy_d_assertPureish: typeof assertPureish;
declare const indexLegacy_d_assertQualifiedTypeIdentifier: typeof assertQualifiedTypeIdentifier;
declare const indexLegacy_d_assertRecordExpression: typeof assertRecordExpression;
declare const indexLegacy_d_assertRegExpLiteral: typeof assertRegExpLiteral;
declare const indexLegacy_d_assertRegexLiteral: typeof assertRegexLiteral;
declare const indexLegacy_d_assertRestElement: typeof assertRestElement;
declare const indexLegacy_d_assertRestProperty: typeof assertRestProperty;
declare const indexLegacy_d_assertReturnStatement: typeof assertReturnStatement;
declare const indexLegacy_d_assertScopable: typeof assertScopable;
declare const indexLegacy_d_assertSequenceExpression: typeof assertSequenceExpression;
declare const indexLegacy_d_assertSpreadElement: typeof assertSpreadElement;
declare const indexLegacy_d_assertSpreadProperty: typeof assertSpreadProperty;
declare const indexLegacy_d_assertStandardized: typeof assertStandardized;
declare const indexLegacy_d_assertStatement: typeof assertStatement;
declare const indexLegacy_d_assertStaticBlock: typeof assertStaticBlock;
declare const indexLegacy_d_assertStringLiteral: typeof assertStringLiteral;
declare const indexLegacy_d_assertStringLiteralTypeAnnotation: typeof assertStringLiteralTypeAnnotation;
declare const indexLegacy_d_assertStringTypeAnnotation: typeof assertStringTypeAnnotation;
declare const indexLegacy_d_assertSuper: typeof assertSuper;
declare const indexLegacy_d_assertSwitchCase: typeof assertSwitchCase;
declare const indexLegacy_d_assertSwitchStatement: typeof assertSwitchStatement;
declare const indexLegacy_d_assertSymbolTypeAnnotation: typeof assertSymbolTypeAnnotation;
declare const indexLegacy_d_assertTSAnyKeyword: typeof assertTSAnyKeyword;
declare const indexLegacy_d_assertTSArrayType: typeof assertTSArrayType;
declare const indexLegacy_d_assertTSAsExpression: typeof assertTSAsExpression;
declare const indexLegacy_d_assertTSBaseType: typeof assertTSBaseType;
declare const indexLegacy_d_assertTSBigIntKeyword: typeof assertTSBigIntKeyword;
declare const indexLegacy_d_assertTSBooleanKeyword: typeof assertTSBooleanKeyword;
declare const indexLegacy_d_assertTSCallSignatureDeclaration: typeof assertTSCallSignatureDeclaration;
declare const indexLegacy_d_assertTSConditionalType: typeof assertTSConditionalType;
declare const indexLegacy_d_assertTSConstructSignatureDeclaration: typeof assertTSConstructSignatureDeclaration;
declare const indexLegacy_d_assertTSConstructorType: typeof assertTSConstructorType;
declare const indexLegacy_d_assertTSDeclareFunction: typeof assertTSDeclareFunction;
declare const indexLegacy_d_assertTSDeclareMethod: typeof assertTSDeclareMethod;
declare const indexLegacy_d_assertTSEntityName: typeof assertTSEntityName;
declare const indexLegacy_d_assertTSEnumDeclaration: typeof assertTSEnumDeclaration;
declare const indexLegacy_d_assertTSEnumMember: typeof assertTSEnumMember;
declare const indexLegacy_d_assertTSExportAssignment: typeof assertTSExportAssignment;
declare const indexLegacy_d_assertTSExpressionWithTypeArguments: typeof assertTSExpressionWithTypeArguments;
declare const indexLegacy_d_assertTSExternalModuleReference: typeof assertTSExternalModuleReference;
declare const indexLegacy_d_assertTSFunctionType: typeof assertTSFunctionType;
declare const indexLegacy_d_assertTSImportEqualsDeclaration: typeof assertTSImportEqualsDeclaration;
declare const indexLegacy_d_assertTSImportType: typeof assertTSImportType;
declare const indexLegacy_d_assertTSIndexSignature: typeof assertTSIndexSignature;
declare const indexLegacy_d_assertTSIndexedAccessType: typeof assertTSIndexedAccessType;
declare const indexLegacy_d_assertTSInferType: typeof assertTSInferType;
declare const indexLegacy_d_assertTSInstantiationExpression: typeof assertTSInstantiationExpression;
declare const indexLegacy_d_assertTSInterfaceBody: typeof assertTSInterfaceBody;
declare const indexLegacy_d_assertTSInterfaceDeclaration: typeof assertTSInterfaceDeclaration;
declare const indexLegacy_d_assertTSIntersectionType: typeof assertTSIntersectionType;
declare const indexLegacy_d_assertTSIntrinsicKeyword: typeof assertTSIntrinsicKeyword;
declare const indexLegacy_d_assertTSLiteralType: typeof assertTSLiteralType;
declare const indexLegacy_d_assertTSMappedType: typeof assertTSMappedType;
declare const indexLegacy_d_assertTSMethodSignature: typeof assertTSMethodSignature;
declare const indexLegacy_d_assertTSModuleBlock: typeof assertTSModuleBlock;
declare const indexLegacy_d_assertTSModuleDeclaration: typeof assertTSModuleDeclaration;
declare const indexLegacy_d_assertTSNamedTupleMember: typeof assertTSNamedTupleMember;
declare const indexLegacy_d_assertTSNamespaceExportDeclaration: typeof assertTSNamespaceExportDeclaration;
declare const indexLegacy_d_assertTSNeverKeyword: typeof assertTSNeverKeyword;
declare const indexLegacy_d_assertTSNonNullExpression: typeof assertTSNonNullExpression;
declare const indexLegacy_d_assertTSNullKeyword: typeof assertTSNullKeyword;
declare const indexLegacy_d_assertTSNumberKeyword: typeof assertTSNumberKeyword;
declare const indexLegacy_d_assertTSObjectKeyword: typeof assertTSObjectKeyword;
declare const indexLegacy_d_assertTSOptionalType: typeof assertTSOptionalType;
declare const indexLegacy_d_assertTSParameterProperty: typeof assertTSParameterProperty;
declare const indexLegacy_d_assertTSParenthesizedType: typeof assertTSParenthesizedType;
declare const indexLegacy_d_assertTSPropertySignature: typeof assertTSPropertySignature;
declare const indexLegacy_d_assertTSQualifiedName: typeof assertTSQualifiedName;
declare const indexLegacy_d_assertTSRestType: typeof assertTSRestType;
declare const indexLegacy_d_assertTSSatisfiesExpression: typeof assertTSSatisfiesExpression;
declare const indexLegacy_d_assertTSStringKeyword: typeof assertTSStringKeyword;
declare const indexLegacy_d_assertTSSymbolKeyword: typeof assertTSSymbolKeyword;
declare const indexLegacy_d_assertTSThisType: typeof assertTSThisType;
declare const indexLegacy_d_assertTSTupleType: typeof assertTSTupleType;
declare const indexLegacy_d_assertTSType: typeof assertTSType;
declare const indexLegacy_d_assertTSTypeAliasDeclaration: typeof assertTSTypeAliasDeclaration;
declare const indexLegacy_d_assertTSTypeAnnotation: typeof assertTSTypeAnnotation;
declare const indexLegacy_d_assertTSTypeAssertion: typeof assertTSTypeAssertion;
declare const indexLegacy_d_assertTSTypeElement: typeof assertTSTypeElement;
declare const indexLegacy_d_assertTSTypeLiteral: typeof assertTSTypeLiteral;
declare const indexLegacy_d_assertTSTypeOperator: typeof assertTSTypeOperator;
declare const indexLegacy_d_assertTSTypeParameter: typeof assertTSTypeParameter;
declare const indexLegacy_d_assertTSTypeParameterDeclaration: typeof assertTSTypeParameterDeclaration;
declare const indexLegacy_d_assertTSTypeParameterInstantiation: typeof assertTSTypeParameterInstantiation;
declare const indexLegacy_d_assertTSTypePredicate: typeof assertTSTypePredicate;
declare const indexLegacy_d_assertTSTypeQuery: typeof assertTSTypeQuery;
declare const indexLegacy_d_assertTSTypeReference: typeof assertTSTypeReference;
declare const indexLegacy_d_assertTSUndefinedKeyword: typeof assertTSUndefinedKeyword;
declare const indexLegacy_d_assertTSUnionType: typeof assertTSUnionType;
declare const indexLegacy_d_assertTSUnknownKeyword: typeof assertTSUnknownKeyword;
declare const indexLegacy_d_assertTSVoidKeyword: typeof assertTSVoidKeyword;
declare const indexLegacy_d_assertTaggedTemplateExpression: typeof assertTaggedTemplateExpression;
declare const indexLegacy_d_assertTemplateElement: typeof assertTemplateElement;
declare const indexLegacy_d_assertTemplateLiteral: typeof assertTemplateLiteral;
declare const indexLegacy_d_assertTerminatorless: typeof assertTerminatorless;
declare const indexLegacy_d_assertThisExpression: typeof assertThisExpression;
declare const indexLegacy_d_assertThisTypeAnnotation: typeof assertThisTypeAnnotation;
declare const indexLegacy_d_assertThrowStatement: typeof assertThrowStatement;
declare const indexLegacy_d_assertTopicReference: typeof assertTopicReference;
declare const indexLegacy_d_assertTryStatement: typeof assertTryStatement;
declare const indexLegacy_d_assertTupleExpression: typeof assertTupleExpression;
declare const indexLegacy_d_assertTupleTypeAnnotation: typeof assertTupleTypeAnnotation;
declare const indexLegacy_d_assertTypeAlias: typeof assertTypeAlias;
declare const indexLegacy_d_assertTypeAnnotation: typeof assertTypeAnnotation;
declare const indexLegacy_d_assertTypeCastExpression: typeof assertTypeCastExpression;
declare const indexLegacy_d_assertTypeParameter: typeof assertTypeParameter;
declare const indexLegacy_d_assertTypeParameterDeclaration: typeof assertTypeParameterDeclaration;
declare const indexLegacy_d_assertTypeParameterInstantiation: typeof assertTypeParameterInstantiation;
declare const indexLegacy_d_assertTypeScript: typeof assertTypeScript;
declare const indexLegacy_d_assertTypeofTypeAnnotation: typeof assertTypeofTypeAnnotation;
declare const indexLegacy_d_assertUnaryExpression: typeof assertUnaryExpression;
declare const indexLegacy_d_assertUnaryLike: typeof assertUnaryLike;
declare const indexLegacy_d_assertUnionTypeAnnotation: typeof assertUnionTypeAnnotation;
declare const indexLegacy_d_assertUpdateExpression: typeof assertUpdateExpression;
declare const indexLegacy_d_assertUserWhitespacable: typeof assertUserWhitespacable;
declare const indexLegacy_d_assertV8IntrinsicIdentifier: typeof assertV8IntrinsicIdentifier;
declare const indexLegacy_d_assertVariableDeclaration: typeof assertVariableDeclaration;
declare const indexLegacy_d_assertVariableDeclarator: typeof assertVariableDeclarator;
declare const indexLegacy_d_assertVariance: typeof assertVariance;
declare const indexLegacy_d_assertVoidTypeAnnotation: typeof assertVoidTypeAnnotation;
declare const indexLegacy_d_assertWhile: typeof assertWhile;
declare const indexLegacy_d_assertWhileStatement: typeof assertWhileStatement;
declare const indexLegacy_d_assertWithStatement: typeof assertWithStatement;
declare const indexLegacy_d_assertYieldExpression: typeof assertYieldExpression;
declare const indexLegacy_d_assignmentExpression: typeof assignmentExpression;
declare const indexLegacy_d_assignmentPattern: typeof assignmentPattern;
declare const indexLegacy_d_awaitExpression: typeof awaitExpression;
declare const indexLegacy_d_bigIntLiteral: typeof bigIntLiteral;
declare const indexLegacy_d_binaryExpression: typeof binaryExpression;
declare const indexLegacy_d_bindExpression: typeof bindExpression;
declare const indexLegacy_d_blockStatement: typeof blockStatement;
declare const indexLegacy_d_booleanLiteral: typeof booleanLiteral;
declare const indexLegacy_d_booleanLiteralTypeAnnotation: typeof booleanLiteralTypeAnnotation;
declare const indexLegacy_d_booleanTypeAnnotation: typeof booleanTypeAnnotation;
declare const indexLegacy_d_breakStatement: typeof breakStatement;
declare const indexLegacy_d_buildChildren: typeof buildChildren;
declare const indexLegacy_d_buildMatchMemberExpression: typeof buildMatchMemberExpression;
declare const indexLegacy_d_callExpression: typeof callExpression;
declare const indexLegacy_d_catchClause: typeof catchClause;
declare const indexLegacy_d_classAccessorProperty: typeof classAccessorProperty;
declare const indexLegacy_d_classBody: typeof classBody;
declare const indexLegacy_d_classDeclaration: typeof classDeclaration;
declare const indexLegacy_d_classExpression: typeof classExpression;
declare const indexLegacy_d_classImplements: typeof classImplements;
declare const indexLegacy_d_classMethod: typeof classMethod;
declare const indexLegacy_d_classPrivateMethod: typeof classPrivateMethod;
declare const indexLegacy_d_classPrivateProperty: typeof classPrivateProperty;
declare const indexLegacy_d_classProperty: typeof classProperty;
declare const indexLegacy_d_clone: typeof clone;
declare const indexLegacy_d_cloneDeep: typeof cloneDeep;
declare const indexLegacy_d_cloneDeepWithoutLoc: typeof cloneDeepWithoutLoc;
declare const indexLegacy_d_cloneNode: typeof cloneNode;
declare const indexLegacy_d_cloneWithoutLoc: typeof cloneWithoutLoc;
declare const indexLegacy_d_conditionalExpression: typeof conditionalExpression;
declare const indexLegacy_d_continueStatement: typeof continueStatement;
declare const indexLegacy_d_createFlowUnionType: typeof createFlowUnionType;
declare const indexLegacy_d_createTypeAnnotationBasedOnTypeof: typeof createTypeAnnotationBasedOnTypeof;
declare const indexLegacy_d_createUnionTypeAnnotation: typeof createUnionTypeAnnotation;
declare const indexLegacy_d_debuggerStatement: typeof debuggerStatement;
declare const indexLegacy_d_decimalLiteral: typeof decimalLiteral;
declare const indexLegacy_d_declareClass: typeof declareClass;
declare const indexLegacy_d_declareExportAllDeclaration: typeof declareExportAllDeclaration;
declare const indexLegacy_d_declareExportDeclaration: typeof declareExportDeclaration;
declare const indexLegacy_d_declareFunction: typeof declareFunction;
declare const indexLegacy_d_declareInterface: typeof declareInterface;
declare const indexLegacy_d_declareModule: typeof declareModule;
declare const indexLegacy_d_declareModuleExports: typeof declareModuleExports;
declare const indexLegacy_d_declareOpaqueType: typeof declareOpaqueType;
declare const indexLegacy_d_declareTypeAlias: typeof declareTypeAlias;
declare const indexLegacy_d_declareVariable: typeof declareVariable;
declare const indexLegacy_d_declaredPredicate: typeof declaredPredicate;
declare const indexLegacy_d_decorator: typeof decorator;
declare const indexLegacy_d_directive: typeof directive;
declare const indexLegacy_d_directiveLiteral: typeof directiveLiteral;
declare const indexLegacy_d_doExpression: typeof doExpression;
declare const indexLegacy_d_doWhileStatement: typeof doWhileStatement;
declare const indexLegacy_d_emptyStatement: typeof emptyStatement;
declare const indexLegacy_d_emptyTypeAnnotation: typeof emptyTypeAnnotation;
declare const indexLegacy_d_ensureBlock: typeof ensureBlock;
declare const indexLegacy_d_enumBooleanBody: typeof enumBooleanBody;
declare const indexLegacy_d_enumBooleanMember: typeof enumBooleanMember;
declare const indexLegacy_d_enumDeclaration: typeof enumDeclaration;
declare const indexLegacy_d_enumDefaultedMember: typeof enumDefaultedMember;
declare const indexLegacy_d_enumNumberBody: typeof enumNumberBody;
declare const indexLegacy_d_enumNumberMember: typeof enumNumberMember;
declare const indexLegacy_d_enumStringBody: typeof enumStringBody;
declare const indexLegacy_d_enumStringMember: typeof enumStringMember;
declare const indexLegacy_d_enumSymbolBody: typeof enumSymbolBody;
declare const indexLegacy_d_existsTypeAnnotation: typeof existsTypeAnnotation;
declare const indexLegacy_d_exportAllDeclaration: typeof exportAllDeclaration;
declare const indexLegacy_d_exportDefaultDeclaration: typeof exportDefaultDeclaration;
declare const indexLegacy_d_exportDefaultSpecifier: typeof exportDefaultSpecifier;
declare const indexLegacy_d_exportNamedDeclaration: typeof exportNamedDeclaration;
declare const indexLegacy_d_exportNamespaceSpecifier: typeof exportNamespaceSpecifier;
declare const indexLegacy_d_exportSpecifier: typeof exportSpecifier;
declare const indexLegacy_d_expressionStatement: typeof expressionStatement;
declare const indexLegacy_d_file: typeof file;
declare const indexLegacy_d_forInStatement: typeof forInStatement;
declare const indexLegacy_d_forOfStatement: typeof forOfStatement;
declare const indexLegacy_d_forStatement: typeof forStatement;
declare const indexLegacy_d_functionDeclaration: typeof functionDeclaration;
declare const indexLegacy_d_functionExpression: typeof functionExpression;
declare const indexLegacy_d_functionTypeAnnotation: typeof functionTypeAnnotation;
declare const indexLegacy_d_functionTypeParam: typeof functionTypeParam;
declare const indexLegacy_d_genericTypeAnnotation: typeof genericTypeAnnotation;
declare const indexLegacy_d_getBindingIdentifiers: typeof getBindingIdentifiers;
declare const indexLegacy_d_getOuterBindingIdentifiers: typeof getOuterBindingIdentifiers;
declare const indexLegacy_d_identifier: typeof identifier;
declare const indexLegacy_d_ifStatement: typeof ifStatement;
declare const indexLegacy_d_importAttribute: typeof importAttribute;
declare const indexLegacy_d_importDeclaration: typeof importDeclaration;
declare const indexLegacy_d_importDefaultSpecifier: typeof importDefaultSpecifier;
declare const indexLegacy_d_importExpression: typeof importExpression;
declare const indexLegacy_d_importNamespaceSpecifier: typeof importNamespaceSpecifier;
declare const indexLegacy_d_importSpecifier: typeof importSpecifier;
declare const indexLegacy_d_indexedAccessType: typeof indexedAccessType;
declare const indexLegacy_d_inferredPredicate: typeof inferredPredicate;
declare const indexLegacy_d_inheritInnerComments: typeof inheritInnerComments;
declare const indexLegacy_d_inheritLeadingComments: typeof inheritLeadingComments;
declare const indexLegacy_d_inheritTrailingComments: typeof inheritTrailingComments;
declare const indexLegacy_d_inherits: typeof inherits;
declare const indexLegacy_d_inheritsComments: typeof inheritsComments;
declare const indexLegacy_d_interfaceDeclaration: typeof interfaceDeclaration;
declare const indexLegacy_d_interfaceExtends: typeof interfaceExtends;
declare const indexLegacy_d_interfaceTypeAnnotation: typeof interfaceTypeAnnotation;
declare const indexLegacy_d_interpreterDirective: typeof interpreterDirective;
declare const indexLegacy_d_intersectionTypeAnnotation: typeof intersectionTypeAnnotation;
declare const indexLegacy_d_is: typeof is;
declare const indexLegacy_d_isAccessor: typeof isAccessor;
declare const indexLegacy_d_isAnyTypeAnnotation: typeof isAnyTypeAnnotation;
declare const indexLegacy_d_isArgumentPlaceholder: typeof isArgumentPlaceholder;
declare const indexLegacy_d_isArrayExpression: typeof isArrayExpression;
declare const indexLegacy_d_isArrayPattern: typeof isArrayPattern;
declare const indexLegacy_d_isArrayTypeAnnotation: typeof isArrayTypeAnnotation;
declare const indexLegacy_d_isArrowFunctionExpression: typeof isArrowFunctionExpression;
declare const indexLegacy_d_isAssignmentExpression: typeof isAssignmentExpression;
declare const indexLegacy_d_isAssignmentPattern: typeof isAssignmentPattern;
declare const indexLegacy_d_isAwaitExpression: typeof isAwaitExpression;
declare const indexLegacy_d_isBigIntLiteral: typeof isBigIntLiteral;
declare const indexLegacy_d_isBinary: typeof isBinary;
declare const indexLegacy_d_isBinaryExpression: typeof isBinaryExpression;
declare const indexLegacy_d_isBindExpression: typeof isBindExpression;
declare const indexLegacy_d_isBinding: typeof isBinding;
declare const indexLegacy_d_isBlock: typeof isBlock;
declare const indexLegacy_d_isBlockParent: typeof isBlockParent;
declare const indexLegacy_d_isBlockScoped: typeof isBlockScoped;
declare const indexLegacy_d_isBlockStatement: typeof isBlockStatement;
declare const indexLegacy_d_isBooleanLiteral: typeof isBooleanLiteral;
declare const indexLegacy_d_isBooleanLiteralTypeAnnotation: typeof isBooleanLiteralTypeAnnotation;
declare const indexLegacy_d_isBooleanTypeAnnotation: typeof isBooleanTypeAnnotation;
declare const indexLegacy_d_isBreakStatement: typeof isBreakStatement;
declare const indexLegacy_d_isCallExpression: typeof isCallExpression;
declare const indexLegacy_d_isCatchClause: typeof isCatchClause;
declare const indexLegacy_d_isClass: typeof isClass;
declare const indexLegacy_d_isClassAccessorProperty: typeof isClassAccessorProperty;
declare const indexLegacy_d_isClassBody: typeof isClassBody;
declare const indexLegacy_d_isClassDeclaration: typeof isClassDeclaration;
declare const indexLegacy_d_isClassExpression: typeof isClassExpression;
declare const indexLegacy_d_isClassImplements: typeof isClassImplements;
declare const indexLegacy_d_isClassMethod: typeof isClassMethod;
declare const indexLegacy_d_isClassPrivateMethod: typeof isClassPrivateMethod;
declare const indexLegacy_d_isClassPrivateProperty: typeof isClassPrivateProperty;
declare const indexLegacy_d_isClassProperty: typeof isClassProperty;
declare const indexLegacy_d_isCompletionStatement: typeof isCompletionStatement;
declare const indexLegacy_d_isConditional: typeof isConditional;
declare const indexLegacy_d_isConditionalExpression: typeof isConditionalExpression;
declare const indexLegacy_d_isContinueStatement: typeof isContinueStatement;
declare const indexLegacy_d_isDebuggerStatement: typeof isDebuggerStatement;
declare const indexLegacy_d_isDecimalLiteral: typeof isDecimalLiteral;
declare const indexLegacy_d_isDeclaration: typeof isDeclaration;
declare const indexLegacy_d_isDeclareClass: typeof isDeclareClass;
declare const indexLegacy_d_isDeclareExportAllDeclaration: typeof isDeclareExportAllDeclaration;
declare const indexLegacy_d_isDeclareExportDeclaration: typeof isDeclareExportDeclaration;
declare const indexLegacy_d_isDeclareFunction: typeof isDeclareFunction;
declare const indexLegacy_d_isDeclareInterface: typeof isDeclareInterface;
declare const indexLegacy_d_isDeclareModule: typeof isDeclareModule;
declare const indexLegacy_d_isDeclareModuleExports: typeof isDeclareModuleExports;
declare const indexLegacy_d_isDeclareOpaqueType: typeof isDeclareOpaqueType;
declare const indexLegacy_d_isDeclareTypeAlias: typeof isDeclareTypeAlias;
declare const indexLegacy_d_isDeclareVariable: typeof isDeclareVariable;
declare const indexLegacy_d_isDeclaredPredicate: typeof isDeclaredPredicate;
declare const indexLegacy_d_isDecorator: typeof isDecorator;
declare const indexLegacy_d_isDirective: typeof isDirective;
declare const indexLegacy_d_isDirectiveLiteral: typeof isDirectiveLiteral;
declare const indexLegacy_d_isDoExpression: typeof isDoExpression;
declare const indexLegacy_d_isDoWhileStatement: typeof isDoWhileStatement;
declare const indexLegacy_d_isEmptyStatement: typeof isEmptyStatement;
declare const indexLegacy_d_isEmptyTypeAnnotation: typeof isEmptyTypeAnnotation;
declare const indexLegacy_d_isEnumBody: typeof isEnumBody;
declare const indexLegacy_d_isEnumBooleanBody: typeof isEnumBooleanBody;
declare const indexLegacy_d_isEnumBooleanMember: typeof isEnumBooleanMember;
declare const indexLegacy_d_isEnumDeclaration: typeof isEnumDeclaration;
declare const indexLegacy_d_isEnumDefaultedMember: typeof isEnumDefaultedMember;
declare const indexLegacy_d_isEnumMember: typeof isEnumMember;
declare const indexLegacy_d_isEnumNumberBody: typeof isEnumNumberBody;
declare const indexLegacy_d_isEnumNumberMember: typeof isEnumNumberMember;
declare const indexLegacy_d_isEnumStringBody: typeof isEnumStringBody;
declare const indexLegacy_d_isEnumStringMember: typeof isEnumStringMember;
declare const indexLegacy_d_isEnumSymbolBody: typeof isEnumSymbolBody;
declare const indexLegacy_d_isExistsTypeAnnotation: typeof isExistsTypeAnnotation;
declare const indexLegacy_d_isExportAllDeclaration: typeof isExportAllDeclaration;
declare const indexLegacy_d_isExportDeclaration: typeof isExportDeclaration;
declare const indexLegacy_d_isExportDefaultDeclaration: typeof isExportDefaultDeclaration;
declare const indexLegacy_d_isExportDefaultSpecifier: typeof isExportDefaultSpecifier;
declare const indexLegacy_d_isExportNamedDeclaration: typeof isExportNamedDeclaration;
declare const indexLegacy_d_isExportNamespaceSpecifier: typeof isExportNamespaceSpecifier;
declare const indexLegacy_d_isExportSpecifier: typeof isExportSpecifier;
declare const indexLegacy_d_isExpression: typeof isExpression;
declare const indexLegacy_d_isExpressionStatement: typeof isExpressionStatement;
declare const indexLegacy_d_isExpressionWrapper: typeof isExpressionWrapper;
declare const indexLegacy_d_isFile: typeof isFile;
declare const indexLegacy_d_isFlow: typeof isFlow;
declare const indexLegacy_d_isFlowBaseAnnotation: typeof isFlowBaseAnnotation;
declare const indexLegacy_d_isFlowDeclaration: typeof isFlowDeclaration;
declare const indexLegacy_d_isFlowPredicate: typeof isFlowPredicate;
declare const indexLegacy_d_isFlowType: typeof isFlowType;
declare const indexLegacy_d_isFor: typeof isFor;
declare const indexLegacy_d_isForInStatement: typeof isForInStatement;
declare const indexLegacy_d_isForOfStatement: typeof isForOfStatement;
declare const indexLegacy_d_isForStatement: typeof isForStatement;
declare const indexLegacy_d_isForXStatement: typeof isForXStatement;
declare const indexLegacy_d_isFunction: typeof isFunction;
declare const indexLegacy_d_isFunctionDeclaration: typeof isFunctionDeclaration;
declare const indexLegacy_d_isFunctionExpression: typeof isFunctionExpression;
declare const indexLegacy_d_isFunctionParent: typeof isFunctionParent;
declare const indexLegacy_d_isFunctionTypeAnnotation: typeof isFunctionTypeAnnotation;
declare const indexLegacy_d_isFunctionTypeParam: typeof isFunctionTypeParam;
declare const indexLegacy_d_isGenericTypeAnnotation: typeof isGenericTypeAnnotation;
declare const indexLegacy_d_isIdentifier: typeof isIdentifier;
declare const indexLegacy_d_isIfStatement: typeof isIfStatement;
declare const indexLegacy_d_isImmutable: typeof isImmutable;
declare const indexLegacy_d_isImport: typeof isImport;
declare const indexLegacy_d_isImportAttribute: typeof isImportAttribute;
declare const indexLegacy_d_isImportDeclaration: typeof isImportDeclaration;
declare const indexLegacy_d_isImportDefaultSpecifier: typeof isImportDefaultSpecifier;
declare const indexLegacy_d_isImportExpression: typeof isImportExpression;
declare const indexLegacy_d_isImportNamespaceSpecifier: typeof isImportNamespaceSpecifier;
declare const indexLegacy_d_isImportOrExportDeclaration: typeof isImportOrExportDeclaration;
declare const indexLegacy_d_isImportSpecifier: typeof isImportSpecifier;
declare const indexLegacy_d_isIndexedAccessType: typeof isIndexedAccessType;
declare const indexLegacy_d_isInferredPredicate: typeof isInferredPredicate;
declare const indexLegacy_d_isInterfaceDeclaration: typeof isInterfaceDeclaration;
declare const indexLegacy_d_isInterfaceExtends: typeof isInterfaceExtends;
declare const indexLegacy_d_isInterfaceTypeAnnotation: typeof isInterfaceTypeAnnotation;
declare const indexLegacy_d_isInterpreterDirective: typeof isInterpreterDirective;
declare const indexLegacy_d_isIntersectionTypeAnnotation: typeof isIntersectionTypeAnnotation;
declare const indexLegacy_d_isJSX: typeof isJSX;
declare const indexLegacy_d_isJSXAttribute: typeof isJSXAttribute;
declare const indexLegacy_d_isJSXClosingElement: typeof isJSXClosingElement;
declare const indexLegacy_d_isJSXClosingFragment: typeof isJSXClosingFragment;
declare const indexLegacy_d_isJSXElement: typeof isJSXElement;
declare const indexLegacy_d_isJSXEmptyExpression: typeof isJSXEmptyExpression;
declare const indexLegacy_d_isJSXExpressionContainer: typeof isJSXExpressionContainer;
declare const indexLegacy_d_isJSXFragment: typeof isJSXFragment;
declare const indexLegacy_d_isJSXIdentifier: typeof isJSXIdentifier;
declare const indexLegacy_d_isJSXMemberExpression: typeof isJSXMemberExpression;
declare const indexLegacy_d_isJSXNamespacedName: typeof isJSXNamespacedName;
declare const indexLegacy_d_isJSXOpeningElement: typeof isJSXOpeningElement;
declare const indexLegacy_d_isJSXOpeningFragment: typeof isJSXOpeningFragment;
declare const indexLegacy_d_isJSXSpreadAttribute: typeof isJSXSpreadAttribute;
declare const indexLegacy_d_isJSXSpreadChild: typeof isJSXSpreadChild;
declare const indexLegacy_d_isJSXText: typeof isJSXText;
declare const indexLegacy_d_isLVal: typeof isLVal;
declare const indexLegacy_d_isLabeledStatement: typeof isLabeledStatement;
declare const indexLegacy_d_isLet: typeof isLet;
declare const indexLegacy_d_isLiteral: typeof isLiteral;
declare const indexLegacy_d_isLogicalExpression: typeof isLogicalExpression;
declare const indexLegacy_d_isLoop: typeof isLoop;
declare const indexLegacy_d_isMemberExpression: typeof isMemberExpression;
declare const indexLegacy_d_isMetaProperty: typeof isMetaProperty;
declare const indexLegacy_d_isMethod: typeof isMethod;
declare const indexLegacy_d_isMiscellaneous: typeof isMiscellaneous;
declare const indexLegacy_d_isMixedTypeAnnotation: typeof isMixedTypeAnnotation;
declare const indexLegacy_d_isModuleDeclaration: typeof isModuleDeclaration;
declare const indexLegacy_d_isModuleExpression: typeof isModuleExpression;
declare const indexLegacy_d_isModuleSpecifier: typeof isModuleSpecifier;
declare const indexLegacy_d_isNewExpression: typeof isNewExpression;
declare const indexLegacy_d_isNode: typeof isNode;
declare const indexLegacy_d_isNodesEquivalent: typeof isNodesEquivalent;
declare const indexLegacy_d_isNullLiteral: typeof isNullLiteral;
declare const indexLegacy_d_isNullLiteralTypeAnnotation: typeof isNullLiteralTypeAnnotation;
declare const indexLegacy_d_isNullableTypeAnnotation: typeof isNullableTypeAnnotation;
declare const indexLegacy_d_isNumberLiteral: typeof isNumberLiteral;
declare const indexLegacy_d_isNumberLiteralTypeAnnotation: typeof isNumberLiteralTypeAnnotation;
declare const indexLegacy_d_isNumberTypeAnnotation: typeof isNumberTypeAnnotation;
declare const indexLegacy_d_isNumericLiteral: typeof isNumericLiteral;
declare const indexLegacy_d_isObjectExpression: typeof isObjectExpression;
declare const indexLegacy_d_isObjectMember: typeof isObjectMember;
declare const indexLegacy_d_isObjectMethod: typeof isObjectMethod;
declare const indexLegacy_d_isObjectPattern: typeof isObjectPattern;
declare const indexLegacy_d_isObjectProperty: typeof isObjectProperty;
declare const indexLegacy_d_isObjectTypeAnnotation: typeof isObjectTypeAnnotation;
declare const indexLegacy_d_isObjectTypeCallProperty: typeof isObjectTypeCallProperty;
declare const indexLegacy_d_isObjectTypeIndexer: typeof isObjectTypeIndexer;
declare const indexLegacy_d_isObjectTypeInternalSlot: typeof isObjectTypeInternalSlot;
declare const indexLegacy_d_isObjectTypeProperty: typeof isObjectTypeProperty;
declare const indexLegacy_d_isObjectTypeSpreadProperty: typeof isObjectTypeSpreadProperty;
declare const indexLegacy_d_isOpaqueType: typeof isOpaqueType;
declare const indexLegacy_d_isOptionalCallExpression: typeof isOptionalCallExpression;
declare const indexLegacy_d_isOptionalIndexedAccessType: typeof isOptionalIndexedAccessType;
declare const indexLegacy_d_isOptionalMemberExpression: typeof isOptionalMemberExpression;
declare const indexLegacy_d_isParenthesizedExpression: typeof isParenthesizedExpression;
declare const indexLegacy_d_isPattern: typeof isPattern;
declare const indexLegacy_d_isPatternLike: typeof isPatternLike;
declare const indexLegacy_d_isPipelineBareFunction: typeof isPipelineBareFunction;
declare const indexLegacy_d_isPipelinePrimaryTopicReference: typeof isPipelinePrimaryTopicReference;
declare const indexLegacy_d_isPipelineTopicExpression: typeof isPipelineTopicExpression;
declare const indexLegacy_d_isPlaceholder: typeof isPlaceholder;
declare const indexLegacy_d_isPlaceholderType: typeof isPlaceholderType;
declare const indexLegacy_d_isPrivate: typeof isPrivate;
declare const indexLegacy_d_isPrivateName: typeof isPrivateName;
declare const indexLegacy_d_isProgram: typeof isProgram;
declare const indexLegacy_d_isProperty: typeof isProperty;
declare const indexLegacy_d_isPureish: typeof isPureish;
declare const indexLegacy_d_isQualifiedTypeIdentifier: typeof isQualifiedTypeIdentifier;
declare const indexLegacy_d_isRecordExpression: typeof isRecordExpression;
declare const indexLegacy_d_isReferenced: typeof isReferenced;
declare const indexLegacy_d_isRegExpLiteral: typeof isRegExpLiteral;
declare const indexLegacy_d_isRegexLiteral: typeof isRegexLiteral;
declare const indexLegacy_d_isRestElement: typeof isRestElement;
declare const indexLegacy_d_isRestProperty: typeof isRestProperty;
declare const indexLegacy_d_isReturnStatement: typeof isReturnStatement;
declare const indexLegacy_d_isScopable: typeof isScopable;
declare const indexLegacy_d_isScope: typeof isScope;
declare const indexLegacy_d_isSequenceExpression: typeof isSequenceExpression;
declare const indexLegacy_d_isSpecifierDefault: typeof isSpecifierDefault;
declare const indexLegacy_d_isSpreadElement: typeof isSpreadElement;
declare const indexLegacy_d_isSpreadProperty: typeof isSpreadProperty;
declare const indexLegacy_d_isStandardized: typeof isStandardized;
declare const indexLegacy_d_isStatement: typeof isStatement;
declare const indexLegacy_d_isStaticBlock: typeof isStaticBlock;
declare const indexLegacy_d_isStringLiteral: typeof isStringLiteral;
declare const indexLegacy_d_isStringLiteralTypeAnnotation: typeof isStringLiteralTypeAnnotation;
declare const indexLegacy_d_isStringTypeAnnotation: typeof isStringTypeAnnotation;
declare const indexLegacy_d_isSuper: typeof isSuper;
declare const indexLegacy_d_isSwitchCase: typeof isSwitchCase;
declare const indexLegacy_d_isSwitchStatement: typeof isSwitchStatement;
declare const indexLegacy_d_isSymbolTypeAnnotation: typeof isSymbolTypeAnnotation;
declare const indexLegacy_d_isTSAnyKeyword: typeof isTSAnyKeyword;
declare const indexLegacy_d_isTSArrayType: typeof isTSArrayType;
declare const indexLegacy_d_isTSAsExpression: typeof isTSAsExpression;
declare const indexLegacy_d_isTSBaseType: typeof isTSBaseType;
declare const indexLegacy_d_isTSBigIntKeyword: typeof isTSBigIntKeyword;
declare const indexLegacy_d_isTSBooleanKeyword: typeof isTSBooleanKeyword;
declare const indexLegacy_d_isTSCallSignatureDeclaration: typeof isTSCallSignatureDeclaration;
declare const indexLegacy_d_isTSConditionalType: typeof isTSConditionalType;
declare const indexLegacy_d_isTSConstructSignatureDeclaration: typeof isTSConstructSignatureDeclaration;
declare const indexLegacy_d_isTSConstructorType: typeof isTSConstructorType;
declare const indexLegacy_d_isTSDeclareFunction: typeof isTSDeclareFunction;
declare const indexLegacy_d_isTSDeclareMethod: typeof isTSDeclareMethod;
declare const indexLegacy_d_isTSEntityName: typeof isTSEntityName;
declare const indexLegacy_d_isTSEnumDeclaration: typeof isTSEnumDeclaration;
declare const indexLegacy_d_isTSEnumMember: typeof isTSEnumMember;
declare const indexLegacy_d_isTSExportAssignment: typeof isTSExportAssignment;
declare const indexLegacy_d_isTSExpressionWithTypeArguments: typeof isTSExpressionWithTypeArguments;
declare const indexLegacy_d_isTSExternalModuleReference: typeof isTSExternalModuleReference;
declare const indexLegacy_d_isTSFunctionType: typeof isTSFunctionType;
declare const indexLegacy_d_isTSImportEqualsDeclaration: typeof isTSImportEqualsDeclaration;
declare const indexLegacy_d_isTSImportType: typeof isTSImportType;
declare const indexLegacy_d_isTSIndexSignature: typeof isTSIndexSignature;
declare const indexLegacy_d_isTSIndexedAccessType: typeof isTSIndexedAccessType;
declare const indexLegacy_d_isTSInferType: typeof isTSInferType;
declare const indexLegacy_d_isTSInstantiationExpression: typeof isTSInstantiationExpression;
declare const indexLegacy_d_isTSInterfaceBody: typeof isTSInterfaceBody;
declare const indexLegacy_d_isTSInterfaceDeclaration: typeof isTSInterfaceDeclaration;
declare const indexLegacy_d_isTSIntersectionType: typeof isTSIntersectionType;
declare const indexLegacy_d_isTSIntrinsicKeyword: typeof isTSIntrinsicKeyword;
declare const indexLegacy_d_isTSLiteralType: typeof isTSLiteralType;
declare const indexLegacy_d_isTSMappedType: typeof isTSMappedType;
declare const indexLegacy_d_isTSMethodSignature: typeof isTSMethodSignature;
declare const indexLegacy_d_isTSModuleBlock: typeof isTSModuleBlock;
declare const indexLegacy_d_isTSModuleDeclaration: typeof isTSModuleDeclaration;
declare const indexLegacy_d_isTSNamedTupleMember: typeof isTSNamedTupleMember;
declare const indexLegacy_d_isTSNamespaceExportDeclaration: typeof isTSNamespaceExportDeclaration;
declare const indexLegacy_d_isTSNeverKeyword: typeof isTSNeverKeyword;
declare const indexLegacy_d_isTSNonNullExpression: typeof isTSNonNullExpression;
declare const indexLegacy_d_isTSNullKeyword: typeof isTSNullKeyword;
declare const indexLegacy_d_isTSNumberKeyword: typeof isTSNumberKeyword;
declare const indexLegacy_d_isTSObjectKeyword: typeof isTSObjectKeyword;
declare const indexLegacy_d_isTSOptionalType: typeof isTSOptionalType;
declare const indexLegacy_d_isTSParameterProperty: typeof isTSParameterProperty;
declare const indexLegacy_d_isTSParenthesizedType: typeof isTSParenthesizedType;
declare const indexLegacy_d_isTSPropertySignature: typeof isTSPropertySignature;
declare const indexLegacy_d_isTSQualifiedName: typeof isTSQualifiedName;
declare const indexLegacy_d_isTSRestType: typeof isTSRestType;
declare const indexLegacy_d_isTSSatisfiesExpression: typeof isTSSatisfiesExpression;
declare const indexLegacy_d_isTSStringKeyword: typeof isTSStringKeyword;
declare const indexLegacy_d_isTSSymbolKeyword: typeof isTSSymbolKeyword;
declare const indexLegacy_d_isTSThisType: typeof isTSThisType;
declare const indexLegacy_d_isTSTupleType: typeof isTSTupleType;
declare const indexLegacy_d_isTSType: typeof isTSType;
declare const indexLegacy_d_isTSTypeAliasDeclaration: typeof isTSTypeAliasDeclaration;
declare const indexLegacy_d_isTSTypeAnnotation: typeof isTSTypeAnnotation;
declare const indexLegacy_d_isTSTypeAssertion: typeof isTSTypeAssertion;
declare const indexLegacy_d_isTSTypeElement: typeof isTSTypeElement;
declare const indexLegacy_d_isTSTypeLiteral: typeof isTSTypeLiteral;
declare const indexLegacy_d_isTSTypeOperator: typeof isTSTypeOperator;
declare const indexLegacy_d_isTSTypeParameter: typeof isTSTypeParameter;
declare const indexLegacy_d_isTSTypeParameterDeclaration: typeof isTSTypeParameterDeclaration;
declare const indexLegacy_d_isTSTypeParameterInstantiation: typeof isTSTypeParameterInstantiation;
declare const indexLegacy_d_isTSTypePredicate: typeof isTSTypePredicate;
declare const indexLegacy_d_isTSTypeQuery: typeof isTSTypeQuery;
declare const indexLegacy_d_isTSTypeReference: typeof isTSTypeReference;
declare const indexLegacy_d_isTSUndefinedKeyword: typeof isTSUndefinedKeyword;
declare const indexLegacy_d_isTSUnionType: typeof isTSUnionType;
declare const indexLegacy_d_isTSUnknownKeyword: typeof isTSUnknownKeyword;
declare const indexLegacy_d_isTSVoidKeyword: typeof isTSVoidKeyword;
declare const indexLegacy_d_isTaggedTemplateExpression: typeof isTaggedTemplateExpression;
declare const indexLegacy_d_isTemplateElement: typeof isTemplateElement;
declare const indexLegacy_d_isTemplateLiteral: typeof isTemplateLiteral;
declare const indexLegacy_d_isTerminatorless: typeof isTerminatorless;
declare const indexLegacy_d_isThisExpression: typeof isThisExpression;
declare const indexLegacy_d_isThisTypeAnnotation: typeof isThisTypeAnnotation;
declare const indexLegacy_d_isThrowStatement: typeof isThrowStatement;
declare const indexLegacy_d_isTopicReference: typeof isTopicReference;
declare const indexLegacy_d_isTryStatement: typeof isTryStatement;
declare const indexLegacy_d_isTupleExpression: typeof isTupleExpression;
declare const indexLegacy_d_isTupleTypeAnnotation: typeof isTupleTypeAnnotation;
declare const indexLegacy_d_isType: typeof isType;
declare const indexLegacy_d_isTypeAlias: typeof isTypeAlias;
declare const indexLegacy_d_isTypeAnnotation: typeof isTypeAnnotation;
declare const indexLegacy_d_isTypeCastExpression: typeof isTypeCastExpression;
declare const indexLegacy_d_isTypeParameter: typeof isTypeParameter;
declare const indexLegacy_d_isTypeParameterDeclaration: typeof isTypeParameterDeclaration;
declare const indexLegacy_d_isTypeParameterInstantiation: typeof isTypeParameterInstantiation;
declare const indexLegacy_d_isTypeScript: typeof isTypeScript;
declare const indexLegacy_d_isTypeofTypeAnnotation: typeof isTypeofTypeAnnotation;
declare const indexLegacy_d_isUnaryExpression: typeof isUnaryExpression;
declare const indexLegacy_d_isUnaryLike: typeof isUnaryLike;
declare const indexLegacy_d_isUnionTypeAnnotation: typeof isUnionTypeAnnotation;
declare const indexLegacy_d_isUpdateExpression: typeof isUpdateExpression;
declare const indexLegacy_d_isUserWhitespacable: typeof isUserWhitespacable;
declare const indexLegacy_d_isV8IntrinsicIdentifier: typeof isV8IntrinsicIdentifier;
declare const indexLegacy_d_isValidES3Identifier: typeof isValidES3Identifier;
declare const indexLegacy_d_isValidIdentifier: typeof isValidIdentifier;
declare const indexLegacy_d_isVar: typeof isVar;
declare const indexLegacy_d_isVariableDeclaration: typeof isVariableDeclaration;
declare const indexLegacy_d_isVariableDeclarator: typeof isVariableDeclarator;
declare const indexLegacy_d_isVariance: typeof isVariance;
declare const indexLegacy_d_isVoidTypeAnnotation: typeof isVoidTypeAnnotation;
declare const indexLegacy_d_isWhile: typeof isWhile;
declare const indexLegacy_d_isWhileStatement: typeof isWhileStatement;
declare const indexLegacy_d_isWithStatement: typeof isWithStatement;
declare const indexLegacy_d_isYieldExpression: typeof isYieldExpression;
declare const indexLegacy_d_jsxAttribute: typeof jsxAttribute;
declare const indexLegacy_d_jsxClosingElement: typeof jsxClosingElement;
declare const indexLegacy_d_jsxClosingFragment: typeof jsxClosingFragment;
declare const indexLegacy_d_jsxElement: typeof jsxElement;
declare const indexLegacy_d_jsxEmptyExpression: typeof jsxEmptyExpression;
declare const indexLegacy_d_jsxExpressionContainer: typeof jsxExpressionContainer;
declare const indexLegacy_d_jsxFragment: typeof jsxFragment;
declare const indexLegacy_d_jsxIdentifier: typeof jsxIdentifier;
declare const indexLegacy_d_jsxMemberExpression: typeof jsxMemberExpression;
declare const indexLegacy_d_jsxNamespacedName: typeof jsxNamespacedName;
declare const indexLegacy_d_jsxOpeningElement: typeof jsxOpeningElement;
declare const indexLegacy_d_jsxOpeningFragment: typeof jsxOpeningFragment;
declare const indexLegacy_d_jsxSpreadAttribute: typeof jsxSpreadAttribute;
declare const indexLegacy_d_jsxSpreadChild: typeof jsxSpreadChild;
declare const indexLegacy_d_jsxText: typeof jsxText;
declare const indexLegacy_d_labeledStatement: typeof labeledStatement;
declare const indexLegacy_d_logicalExpression: typeof logicalExpression;
declare const indexLegacy_d_matchesPattern: typeof matchesPattern;
declare const indexLegacy_d_memberExpression: typeof memberExpression;
declare const indexLegacy_d_metaProperty: typeof metaProperty;
declare const indexLegacy_d_mixedTypeAnnotation: typeof mixedTypeAnnotation;
declare const indexLegacy_d_moduleExpression: typeof moduleExpression;
declare const indexLegacy_d_newExpression: typeof newExpression;
declare const indexLegacy_d_nullLiteral: typeof nullLiteral;
declare const indexLegacy_d_nullLiteralTypeAnnotation: typeof nullLiteralTypeAnnotation;
declare const indexLegacy_d_nullableTypeAnnotation: typeof nullableTypeAnnotation;
declare const indexLegacy_d_numberLiteralTypeAnnotation: typeof numberLiteralTypeAnnotation;
declare const indexLegacy_d_numberTypeAnnotation: typeof numberTypeAnnotation;
declare const indexLegacy_d_numericLiteral: typeof numericLiteral;
declare const indexLegacy_d_objectExpression: typeof objectExpression;
declare const indexLegacy_d_objectMethod: typeof objectMethod;
declare const indexLegacy_d_objectPattern: typeof objectPattern;
declare const indexLegacy_d_objectProperty: typeof objectProperty;
declare const indexLegacy_d_objectTypeAnnotation: typeof objectTypeAnnotation;
declare const indexLegacy_d_objectTypeCallProperty: typeof objectTypeCallProperty;
declare const indexLegacy_d_objectTypeIndexer: typeof objectTypeIndexer;
declare const indexLegacy_d_objectTypeInternalSlot: typeof objectTypeInternalSlot;
declare const indexLegacy_d_objectTypeProperty: typeof objectTypeProperty;
declare const indexLegacy_d_objectTypeSpreadProperty: typeof objectTypeSpreadProperty;
declare const indexLegacy_d_opaqueType: typeof opaqueType;
declare const indexLegacy_d_optionalCallExpression: typeof optionalCallExpression;
declare const indexLegacy_d_optionalIndexedAccessType: typeof optionalIndexedAccessType;
declare const indexLegacy_d_optionalMemberExpression: typeof optionalMemberExpression;
declare const indexLegacy_d_parenthesizedExpression: typeof parenthesizedExpression;
declare const indexLegacy_d_pipelineBareFunction: typeof pipelineBareFunction;
declare const indexLegacy_d_pipelinePrimaryTopicReference: typeof pipelinePrimaryTopicReference;
declare const indexLegacy_d_pipelineTopicExpression: typeof pipelineTopicExpression;
declare const indexLegacy_d_placeholder: typeof placeholder;
declare const indexLegacy_d_prependToMemberExpression: typeof prependToMemberExpression;
declare const indexLegacy_d_privateName: typeof privateName;
declare const indexLegacy_d_program: typeof program;
declare const indexLegacy_d_qualifiedTypeIdentifier: typeof qualifiedTypeIdentifier;
declare const indexLegacy_d_recordExpression: typeof recordExpression;
declare const indexLegacy_d_regExpLiteral: typeof regExpLiteral;
declare const indexLegacy_d_removeComments: typeof removeComments;
declare const indexLegacy_d_removeProperties: typeof removeProperties;
declare const indexLegacy_d_removePropertiesDeep: typeof removePropertiesDeep;
declare const indexLegacy_d_removeTypeDuplicates: typeof removeTypeDuplicates;
declare const indexLegacy_d_restElement: typeof restElement;
declare const indexLegacy_d_returnStatement: typeof returnStatement;
declare const indexLegacy_d_sequenceExpression: typeof sequenceExpression;
declare const indexLegacy_d_shallowEqual: typeof shallowEqual;
declare const indexLegacy_d_spreadElement: typeof spreadElement;
declare const indexLegacy_d_staticBlock: typeof staticBlock;
declare const indexLegacy_d_stringLiteral: typeof stringLiteral;
declare const indexLegacy_d_stringLiteralTypeAnnotation: typeof stringLiteralTypeAnnotation;
declare const indexLegacy_d_stringTypeAnnotation: typeof stringTypeAnnotation;
declare const indexLegacy_d_switchCase: typeof switchCase;
declare const indexLegacy_d_switchStatement: typeof switchStatement;
declare const indexLegacy_d_symbolTypeAnnotation: typeof symbolTypeAnnotation;
declare const indexLegacy_d_taggedTemplateExpression: typeof taggedTemplateExpression;
declare const indexLegacy_d_templateElement: typeof templateElement;
declare const indexLegacy_d_templateLiteral: typeof templateLiteral;
declare const indexLegacy_d_thisExpression: typeof thisExpression;
declare const indexLegacy_d_thisTypeAnnotation: typeof thisTypeAnnotation;
declare const indexLegacy_d_throwStatement: typeof throwStatement;
declare const indexLegacy_d_toBindingIdentifierName: typeof toBindingIdentifierName;
declare const indexLegacy_d_toBlock: typeof toBlock;
declare const indexLegacy_d_toComputedKey: typeof toComputedKey;
declare const indexLegacy_d_toExpression: typeof toExpression;
declare const indexLegacy_d_toIdentifier: typeof toIdentifier;
declare const indexLegacy_d_toKeyAlias: typeof toKeyAlias;
declare const indexLegacy_d_toSequenceExpression: typeof toSequenceExpression;
declare const indexLegacy_d_toStatement: typeof toStatement;
declare const indexLegacy_d_topicReference: typeof topicReference;
declare const indexLegacy_d_traverse: typeof traverse;
declare const indexLegacy_d_traverseFast: typeof traverseFast;
declare const indexLegacy_d_tryStatement: typeof tryStatement;
declare const indexLegacy_d_tsAnyKeyword: typeof tsAnyKeyword;
declare const indexLegacy_d_tsArrayType: typeof tsArrayType;
declare const indexLegacy_d_tsAsExpression: typeof tsAsExpression;
declare const indexLegacy_d_tsBigIntKeyword: typeof tsBigIntKeyword;
declare const indexLegacy_d_tsBooleanKeyword: typeof tsBooleanKeyword;
declare const indexLegacy_d_tsCallSignatureDeclaration: typeof tsCallSignatureDeclaration;
declare const indexLegacy_d_tsConditionalType: typeof tsConditionalType;
declare const indexLegacy_d_tsConstructSignatureDeclaration: typeof tsConstructSignatureDeclaration;
declare const indexLegacy_d_tsConstructorType: typeof tsConstructorType;
declare const indexLegacy_d_tsDeclareFunction: typeof tsDeclareFunction;
declare const indexLegacy_d_tsDeclareMethod: typeof tsDeclareMethod;
declare const indexLegacy_d_tsEnumDeclaration: typeof tsEnumDeclaration;
declare const indexLegacy_d_tsEnumMember: typeof tsEnumMember;
declare const indexLegacy_d_tsExportAssignment: typeof tsExportAssignment;
declare const indexLegacy_d_tsExpressionWithTypeArguments: typeof tsExpressionWithTypeArguments;
declare const indexLegacy_d_tsExternalModuleReference: typeof tsExternalModuleReference;
declare const indexLegacy_d_tsFunctionType: typeof tsFunctionType;
declare const indexLegacy_d_tsImportEqualsDeclaration: typeof tsImportEqualsDeclaration;
declare const indexLegacy_d_tsImportType: typeof tsImportType;
declare const indexLegacy_d_tsIndexSignature: typeof tsIndexSignature;
declare const indexLegacy_d_tsIndexedAccessType: typeof tsIndexedAccessType;
declare const indexLegacy_d_tsInferType: typeof tsInferType;
declare const indexLegacy_d_tsInstantiationExpression: typeof tsInstantiationExpression;
declare const indexLegacy_d_tsInterfaceBody: typeof tsInterfaceBody;
declare const indexLegacy_d_tsInterfaceDeclaration: typeof tsInterfaceDeclaration;
declare const indexLegacy_d_tsIntersectionType: typeof tsIntersectionType;
declare const indexLegacy_d_tsIntrinsicKeyword: typeof tsIntrinsicKeyword;
declare const indexLegacy_d_tsLiteralType: typeof tsLiteralType;
declare const indexLegacy_d_tsMappedType: typeof tsMappedType;
declare const indexLegacy_d_tsMethodSignature: typeof tsMethodSignature;
declare const indexLegacy_d_tsModuleBlock: typeof tsModuleBlock;
declare const indexLegacy_d_tsModuleDeclaration: typeof tsModuleDeclaration;
declare const indexLegacy_d_tsNamedTupleMember: typeof tsNamedTupleMember;
declare const indexLegacy_d_tsNamespaceExportDeclaration: typeof tsNamespaceExportDeclaration;
declare const indexLegacy_d_tsNeverKeyword: typeof tsNeverKeyword;
declare const indexLegacy_d_tsNonNullExpression: typeof tsNonNullExpression;
declare const indexLegacy_d_tsNullKeyword: typeof tsNullKeyword;
declare const indexLegacy_d_tsNumberKeyword: typeof tsNumberKeyword;
declare const indexLegacy_d_tsObjectKeyword: typeof tsObjectKeyword;
declare const indexLegacy_d_tsOptionalType: typeof tsOptionalType;
declare const indexLegacy_d_tsParameterProperty: typeof tsParameterProperty;
declare const indexLegacy_d_tsParenthesizedType: typeof tsParenthesizedType;
declare const indexLegacy_d_tsPropertySignature: typeof tsPropertySignature;
declare const indexLegacy_d_tsQualifiedName: typeof tsQualifiedName;
declare const indexLegacy_d_tsRestType: typeof tsRestType;
declare const indexLegacy_d_tsSatisfiesExpression: typeof tsSatisfiesExpression;
declare const indexLegacy_d_tsStringKeyword: typeof tsStringKeyword;
declare const indexLegacy_d_tsSymbolKeyword: typeof tsSymbolKeyword;
declare const indexLegacy_d_tsThisType: typeof tsThisType;
declare const indexLegacy_d_tsTupleType: typeof tsTupleType;
declare const indexLegacy_d_tsTypeAliasDeclaration: typeof tsTypeAliasDeclaration;
declare const indexLegacy_d_tsTypeAnnotation: typeof tsTypeAnnotation;
declare const indexLegacy_d_tsTypeAssertion: typeof tsTypeAssertion;
declare const indexLegacy_d_tsTypeLiteral: typeof tsTypeLiteral;
declare const indexLegacy_d_tsTypeOperator: typeof tsTypeOperator;
declare const indexLegacy_d_tsTypeParameter: typeof tsTypeParameter;
declare const indexLegacy_d_tsTypeParameterDeclaration: typeof tsTypeParameterDeclaration;
declare const indexLegacy_d_tsTypeParameterInstantiation: typeof tsTypeParameterInstantiation;
declare const indexLegacy_d_tsTypePredicate: typeof tsTypePredicate;
declare const indexLegacy_d_tsTypeQuery: typeof tsTypeQuery;
declare const indexLegacy_d_tsTypeReference: typeof tsTypeReference;
declare const indexLegacy_d_tsUndefinedKeyword: typeof tsUndefinedKeyword;
declare const indexLegacy_d_tsUnionType: typeof tsUnionType;
declare const indexLegacy_d_tsUnknownKeyword: typeof tsUnknownKeyword;
declare const indexLegacy_d_tsVoidKeyword: typeof tsVoidKeyword;
declare const indexLegacy_d_tupleExpression: typeof tupleExpression;
declare const indexLegacy_d_tupleTypeAnnotation: typeof tupleTypeAnnotation;
declare const indexLegacy_d_typeAlias: typeof typeAlias;
declare const indexLegacy_d_typeAnnotation: typeof typeAnnotation;
declare const indexLegacy_d_typeCastExpression: typeof typeCastExpression;
declare const indexLegacy_d_typeParameter: typeof typeParameter;
declare const indexLegacy_d_typeParameterDeclaration: typeof typeParameterDeclaration;
declare const indexLegacy_d_typeParameterInstantiation: typeof typeParameterInstantiation;
declare const indexLegacy_d_typeofTypeAnnotation: typeof typeofTypeAnnotation;
declare const indexLegacy_d_unaryExpression: typeof unaryExpression;
declare const indexLegacy_d_unionTypeAnnotation: typeof unionTypeAnnotation;
declare const indexLegacy_d_updateExpression: typeof updateExpression;
declare const indexLegacy_d_v8IntrinsicIdentifier: typeof v8IntrinsicIdentifier;
declare const indexLegacy_d_validate: typeof validate;
declare const indexLegacy_d_valueToNode: typeof valueToNode;
declare const indexLegacy_d_variableDeclaration: typeof variableDeclaration;
declare const indexLegacy_d_variableDeclarator: typeof variableDeclarator;
declare const indexLegacy_d_variance: typeof variance;
declare const indexLegacy_d_voidTypeAnnotation: typeof voidTypeAnnotation;
declare const indexLegacy_d_whileStatement: typeof whileStatement;
declare const indexLegacy_d_withStatement: typeof withStatement;
declare const indexLegacy_d_yieldExpression: typeof yieldExpression;
declare namespace indexLegacy_d {
  export { type indexLegacy_d_Accessor as Accessor, type indexLegacy_d_Aliases as Aliases, type indexLegacy_d_AnyTypeAnnotation as AnyTypeAnnotation, type indexLegacy_d_ArgumentPlaceholder as ArgumentPlaceholder, type indexLegacy_d_ArrayExpression as ArrayExpression, type indexLegacy_d_ArrayPattern as ArrayPattern, type indexLegacy_d_ArrayTypeAnnotation as ArrayTypeAnnotation, type indexLegacy_d_ArrowFunctionExpression as ArrowFunctionExpression, type indexLegacy_d_AssignmentExpression as AssignmentExpression, type indexLegacy_d_AssignmentPattern as AssignmentPattern, type indexLegacy_d_AwaitExpression as AwaitExpression, type indexLegacy_d_BigIntLiteral as BigIntLiteral, type indexLegacy_d_Binary as Binary, type indexLegacy_d_BinaryExpression as BinaryExpression, type indexLegacy_d_BindExpression as BindExpression, type indexLegacy_d_Block as Block, type indexLegacy_d_BlockParent as BlockParent, type indexLegacy_d_BlockStatement as BlockStatement, type indexLegacy_d_BooleanLiteral as BooleanLiteral, type indexLegacy_d_BooleanLiteralTypeAnnotation as BooleanLiteralTypeAnnotation, type indexLegacy_d_BooleanTypeAnnotation as BooleanTypeAnnotation, type indexLegacy_d_BreakStatement as BreakStatement, type indexLegacy_d_CallExpression as CallExpression, type indexLegacy_d_CatchClause as CatchClause, type indexLegacy_d_Class as Class, type indexLegacy_d_ClassAccessorProperty as ClassAccessorProperty, type indexLegacy_d_ClassBody as ClassBody, type indexLegacy_d_ClassDeclaration as ClassDeclaration, type indexLegacy_d_ClassExpression as ClassExpression, type indexLegacy_d_ClassImplements as ClassImplements, type indexLegacy_d_ClassMethod as ClassMethod, type indexLegacy_d_ClassPrivateMethod as ClassPrivateMethod, type indexLegacy_d_ClassPrivateProperty as ClassPrivateProperty, type indexLegacy_d_ClassProperty as ClassProperty, type indexLegacy_d_Comment as Comment, type indexLegacy_d_CommentBlock as CommentBlock, type indexLegacy_d_CommentLine as CommentLine, type indexLegacy_d_CommentTypeShorthand as CommentTypeShorthand, type indexLegacy_d_CompletionStatement as CompletionStatement, type indexLegacy_d_Conditional as Conditional, type indexLegacy_d_ConditionalExpression as ConditionalExpression, type indexLegacy_d_ContinueStatement as ContinueStatement, type indexLegacy_d_DebuggerStatement as DebuggerStatement, type indexLegacy_d_DecimalLiteral as DecimalLiteral, type indexLegacy_d_Declaration as Declaration, type indexLegacy_d_DeclareClass as DeclareClass, type indexLegacy_d_DeclareExportAllDeclaration as DeclareExportAllDeclaration, type indexLegacy_d_DeclareExportDeclaration as DeclareExportDeclaration, type indexLegacy_d_DeclareFunction as DeclareFunction, type indexLegacy_d_DeclareInterface as DeclareInterface, type indexLegacy_d_DeclareModule as DeclareModule, type indexLegacy_d_DeclareModuleExports as DeclareModuleExports, type indexLegacy_d_DeclareOpaqueType as DeclareOpaqueType, type indexLegacy_d_DeclareTypeAlias as DeclareTypeAlias, type indexLegacy_d_DeclareVariable as DeclareVariable, type indexLegacy_d_DeclaredPredicate as DeclaredPredicate, type indexLegacy_d_Decorator as Decorator, type indexLegacy_d_Directive as Directive, type indexLegacy_d_DirectiveLiteral as DirectiveLiteral, type indexLegacy_d_DoExpression as DoExpression, type indexLegacy_d_DoWhileStatement as DoWhileStatement, type indexLegacy_d_EmptyStatement as EmptyStatement, type indexLegacy_d_EmptyTypeAnnotation as EmptyTypeAnnotation, type indexLegacy_d_EnumBody as EnumBody, type indexLegacy_d_EnumBooleanBody as EnumBooleanBody, type indexLegacy_d_EnumBooleanMember as EnumBooleanMember, type indexLegacy_d_EnumDeclaration as EnumDeclaration, type indexLegacy_d_EnumDefaultedMember as EnumDefaultedMember, type indexLegacy_d_EnumMember as EnumMember, type indexLegacy_d_EnumNumberBody as EnumNumberBody, type indexLegacy_d_EnumNumberMember as EnumNumberMember, type indexLegacy_d_EnumStringBody as EnumStringBody, type indexLegacy_d_EnumStringMember as EnumStringMember, type indexLegacy_d_EnumSymbolBody as EnumSymbolBody, type indexLegacy_d_ExistsTypeAnnotation as ExistsTypeAnnotation, type indexLegacy_d_ExportAllDeclaration as ExportAllDeclaration, type indexLegacy_d_ExportDeclaration as ExportDeclaration, type indexLegacy_d_ExportDefaultDeclaration as ExportDefaultDeclaration, type indexLegacy_d_ExportDefaultSpecifier as ExportDefaultSpecifier, type indexLegacy_d_ExportNamedDeclaration as ExportNamedDeclaration, type indexLegacy_d_ExportNamespaceSpecifier as ExportNamespaceSpecifier, type indexLegacy_d_ExportSpecifier as ExportSpecifier, type indexLegacy_d_Expression as Expression, type indexLegacy_d_ExpressionStatement as ExpressionStatement, type indexLegacy_d_ExpressionWrapper as ExpressionWrapper, type indexLegacy_d_File as File, type indexLegacy_d_Flow as Flow, type indexLegacy_d_FlowBaseAnnotation as FlowBaseAnnotation, type indexLegacy_d_FlowDeclaration as FlowDeclaration, type indexLegacy_d_FlowPredicate as FlowPredicate, type indexLegacy_d_FlowType as FlowType, type indexLegacy_d_For as For, type indexLegacy_d_ForInStatement as ForInStatement, type indexLegacy_d_ForOfStatement as ForOfStatement, type indexLegacy_d_ForStatement as ForStatement, type indexLegacy_d_ForXStatement as ForXStatement, type indexLegacy_d_Function as Function, type indexLegacy_d_FunctionDeclaration as FunctionDeclaration, type indexLegacy_d_FunctionExpression as FunctionExpression, type indexLegacy_d_FunctionParent as FunctionParent, type indexLegacy_d_FunctionTypeAnnotation as FunctionTypeAnnotation, type indexLegacy_d_FunctionTypeParam as FunctionTypeParam, type indexLegacy_d_GenericTypeAnnotation as GenericTypeAnnotation, type indexLegacy_d_Identifier as Identifier, type indexLegacy_d_IfStatement as IfStatement, type indexLegacy_d_Immutable as Immutable, type indexLegacy_d_Import as Import, type indexLegacy_d_ImportAttribute as ImportAttribute, type indexLegacy_d_ImportDeclaration as ImportDeclaration, type indexLegacy_d_ImportDefaultSpecifier as ImportDefaultSpecifier, type indexLegacy_d_ImportExpression as ImportExpression, type indexLegacy_d_ImportNamespaceSpecifier as ImportNamespaceSpecifier, type indexLegacy_d_ImportOrExportDeclaration as ImportOrExportDeclaration, type indexLegacy_d_ImportSpecifier as ImportSpecifier, type indexLegacy_d_IndexedAccessType as IndexedAccessType, type indexLegacy_d_InferredPredicate as InferredPredicate, type indexLegacy_d_InterfaceDeclaration as InterfaceDeclaration, type indexLegacy_d_InterfaceExtends as InterfaceExtends, type indexLegacy_d_InterfaceTypeAnnotation as InterfaceTypeAnnotation, type indexLegacy_d_InterpreterDirective as InterpreterDirective, type indexLegacy_d_IntersectionTypeAnnotation as IntersectionTypeAnnotation, type indexLegacy_d_JSX as JSX, type indexLegacy_d_JSXAttribute as JSXAttribute, type indexLegacy_d_JSXClosingElement as JSXClosingElement, type indexLegacy_d_JSXClosingFragment as JSXClosingFragment, type indexLegacy_d_JSXElement as JSXElement, type indexLegacy_d_JSXEmptyExpression as JSXEmptyExpression, type indexLegacy_d_JSXExpressionContainer as JSXExpressionContainer, type indexLegacy_d_JSXFragment as JSXFragment, type indexLegacy_d_JSXIdentifier as JSXIdentifier, type indexLegacy_d_JSXMemberExpression as JSXMemberExpression, type indexLegacy_d_JSXNamespacedName as JSXNamespacedName, type indexLegacy_d_JSXOpeningElement as JSXOpeningElement, type indexLegacy_d_JSXOpeningFragment as JSXOpeningFragment, type indexLegacy_d_JSXSpreadAttribute as JSXSpreadAttribute, type indexLegacy_d_JSXSpreadChild as JSXSpreadChild, type indexLegacy_d_JSXText as JSXText, type indexLegacy_d_LVal as LVal, type indexLegacy_d_LabeledStatement as LabeledStatement, type indexLegacy_d_Literal as Literal, type indexLegacy_d_LogicalExpression as LogicalExpression, type indexLegacy_d_Loop as Loop, type indexLegacy_d_MemberExpression as MemberExpression, type indexLegacy_d_MetaProperty as MetaProperty, type indexLegacy_d_Method as Method, type indexLegacy_d_Miscellaneous as Miscellaneous, type indexLegacy_d_MixedTypeAnnotation as MixedTypeAnnotation, type indexLegacy_d_ModuleDeclaration as ModuleDeclaration, type indexLegacy_d_ModuleExpression as ModuleExpression, type indexLegacy_d_ModuleSpecifier as ModuleSpecifier, type indexLegacy_d_NewExpression as NewExpression, type indexLegacy_d_Node as Node, type indexLegacy_d_NullLiteral as NullLiteral, type indexLegacy_d_NullLiteralTypeAnnotation as NullLiteralTypeAnnotation, type indexLegacy_d_NullableTypeAnnotation as NullableTypeAnnotation, type indexLegacy_d_NumberLiteral as NumberLiteral, type indexLegacy_d_NumberLiteralTypeAnnotation as NumberLiteralTypeAnnotation, type indexLegacy_d_NumberTypeAnnotation as NumberTypeAnnotation, type indexLegacy_d_NumericLiteral as NumericLiteral, type indexLegacy_d_ObjectExpression as ObjectExpression, type indexLegacy_d_ObjectMember as ObjectMember, type indexLegacy_d_ObjectMethod as ObjectMethod, type indexLegacy_d_ObjectPattern as ObjectPattern, type indexLegacy_d_ObjectProperty as ObjectProperty, type indexLegacy_d_ObjectTypeAnnotation as ObjectTypeAnnotation, type indexLegacy_d_ObjectTypeCallProperty as ObjectTypeCallProperty, type indexLegacy_d_ObjectTypeIndexer as ObjectTypeIndexer, type indexLegacy_d_ObjectTypeInternalSlot as ObjectTypeInternalSlot, type indexLegacy_d_ObjectTypeProperty as ObjectTypeProperty, type indexLegacy_d_ObjectTypeSpreadProperty as ObjectTypeSpreadProperty, type indexLegacy_d_OpaqueType as OpaqueType, type indexLegacy_d_OptionalCallExpression as OptionalCallExpression, type indexLegacy_d_OptionalIndexedAccessType as OptionalIndexedAccessType, type indexLegacy_d_OptionalMemberExpression as OptionalMemberExpression, type indexLegacy_d_ParenthesizedExpression as ParenthesizedExpression, type indexLegacy_d_Pattern as Pattern, type indexLegacy_d_PatternLike as PatternLike, type indexLegacy_d_PipelineBareFunction as PipelineBareFunction, type indexLegacy_d_PipelinePrimaryTopicReference as PipelinePrimaryTopicReference, type indexLegacy_d_PipelineTopicExpression as PipelineTopicExpression, type indexLegacy_d_Placeholder as Placeholder, type indexLegacy_d_Private as Private, type indexLegacy_d_PrivateName as PrivateName, type indexLegacy_d_Program as Program, type indexLegacy_d_Property as Property, type indexLegacy_d_Pureish as Pureish, type indexLegacy_d_QualifiedTypeIdentifier as QualifiedTypeIdentifier, type indexLegacy_d_RecordExpression as RecordExpression, type indexLegacy_d_RegExpLiteral as RegExpLiteral, type indexLegacy_d_RegexLiteral as RegexLiteral, type indexLegacy_d_RestElement as RestElement, type indexLegacy_d_RestProperty as RestProperty, type indexLegacy_d_ReturnStatement as ReturnStatement, type indexLegacy_d_Scopable as Scopable, type indexLegacy_d_SequenceExpression as SequenceExpression, type indexLegacy_d_SourceLocation as SourceLocation, type indexLegacy_d_SpreadElement as SpreadElement, type indexLegacy_d_SpreadProperty as SpreadProperty, type indexLegacy_d_Standardized as Standardized, type indexLegacy_d_Statement as Statement, type indexLegacy_d_StaticBlock as StaticBlock, type indexLegacy_d_StringLiteral as StringLiteral, type indexLegacy_d_StringLiteralTypeAnnotation as StringLiteralTypeAnnotation, type indexLegacy_d_StringTypeAnnotation as StringTypeAnnotation, type indexLegacy_d_Super as Super, type indexLegacy_d_SwitchCase as SwitchCase, type indexLegacy_d_SwitchStatement as SwitchStatement, type indexLegacy_d_SymbolTypeAnnotation as SymbolTypeAnnotation, type indexLegacy_d_TSAnyKeyword as TSAnyKeyword, type indexLegacy_d_TSArrayType as TSArrayType, type indexLegacy_d_TSAsExpression as TSAsExpression, type indexLegacy_d_TSBaseType as TSBaseType, type indexLegacy_d_TSBigIntKeyword as TSBigIntKeyword, type indexLegacy_d_TSBooleanKeyword as TSBooleanKeyword, type indexLegacy_d_TSCallSignatureDeclaration as TSCallSignatureDeclaration, type indexLegacy_d_TSConditionalType as TSConditionalType, type indexLegacy_d_TSConstructSignatureDeclaration as TSConstructSignatureDeclaration, type indexLegacy_d_TSConstructorType as TSConstructorType, type indexLegacy_d_TSDeclareFunction as TSDeclareFunction, type indexLegacy_d_TSDeclareMethod as TSDeclareMethod, type indexLegacy_d_TSEntityName as TSEntityName, type indexLegacy_d_TSEnumDeclaration as TSEnumDeclaration, type indexLegacy_d_TSEnumMember as TSEnumMember, type indexLegacy_d_TSExportAssignment as TSExportAssignment, type indexLegacy_d_TSExpressionWithTypeArguments as TSExpressionWithTypeArguments, type indexLegacy_d_TSExternalModuleReference as TSExternalModuleReference, type indexLegacy_d_TSFunctionType as TSFunctionType, type indexLegacy_d_TSImportEqualsDeclaration as TSImportEqualsDeclaration, type indexLegacy_d_TSImportType as TSImportType, type indexLegacy_d_TSIndexSignature as TSIndexSignature, type indexLegacy_d_TSIndexedAccessType as TSIndexedAccessType, type indexLegacy_d_TSInferType as TSInferType, type indexLegacy_d_TSInstantiationExpression as TSInstantiationExpression, type indexLegacy_d_TSInterfaceBody as TSInterfaceBody, type indexLegacy_d_TSInterfaceDeclaration as TSInterfaceDeclaration, type indexLegacy_d_TSIntersectionType as TSIntersectionType, type indexLegacy_d_TSIntrinsicKeyword as TSIntrinsicKeyword, type indexLegacy_d_TSLiteralType as TSLiteralType, type indexLegacy_d_TSMappedType as TSMappedType, type indexLegacy_d_TSMethodSignature as TSMethodSignature, type indexLegacy_d_TSModuleBlock as TSModuleBlock, type indexLegacy_d_TSModuleDeclaration as TSModuleDeclaration, type indexLegacy_d_TSNamedTupleMember as TSNamedTupleMember, type indexLegacy_d_TSNamespaceExportDeclaration as TSNamespaceExportDeclaration, type indexLegacy_d_TSNeverKeyword as TSNeverKeyword, type indexLegacy_d_TSNonNullExpression as TSNonNullExpression, type indexLegacy_d_TSNullKeyword as TSNullKeyword, type indexLegacy_d_TSNumberKeyword as TSNumberKeyword, type indexLegacy_d_TSObjectKeyword as TSObjectKeyword, type indexLegacy_d_TSOptionalType as TSOptionalType, type indexLegacy_d_TSParameterProperty as TSParameterProperty, type indexLegacy_d_TSParenthesizedType as TSParenthesizedType, type indexLegacy_d_TSPropertySignature as TSPropertySignature, type indexLegacy_d_TSQualifiedName as TSQualifiedName, type indexLegacy_d_TSRestType as TSRestType, type indexLegacy_d_TSSatisfiesExpression as TSSatisfiesExpression, type indexLegacy_d_TSStringKeyword as TSStringKeyword, type indexLegacy_d_TSSymbolKeyword as TSSymbolKeyword, type indexLegacy_d_TSThisType as TSThisType, type indexLegacy_d_TSTupleType as TSTupleType, type indexLegacy_d_TSType as TSType, type indexLegacy_d_TSTypeAliasDeclaration as TSTypeAliasDeclaration, type indexLegacy_d_TSTypeAnnotation as TSTypeAnnotation, type indexLegacy_d_TSTypeAssertion as TSTypeAssertion, type indexLegacy_d_TSTypeElement as TSTypeElement, type indexLegacy_d_TSTypeLiteral as TSTypeLiteral, type indexLegacy_d_TSTypeOperator as TSTypeOperator, type indexLegacy_d_TSTypeParameter as TSTypeParameter, type indexLegacy_d_TSTypeParameterDeclaration as TSTypeParameterDeclaration, type indexLegacy_d_TSTypeParameterInstantiation as TSTypeParameterInstantiation, type indexLegacy_d_TSTypePredicate as TSTypePredicate, type indexLegacy_d_TSTypeQuery as TSTypeQuery, type indexLegacy_d_TSTypeReference as TSTypeReference, type indexLegacy_d_TSUndefinedKeyword as TSUndefinedKeyword, type indexLegacy_d_TSUnionType as TSUnionType, type indexLegacy_d_TSUnknownKeyword as TSUnknownKeyword, type indexLegacy_d_TSVoidKeyword as TSVoidKeyword, type indexLegacy_d_TaggedTemplateExpression as TaggedTemplateExpression, type indexLegacy_d_TemplateElement as TemplateElement, type indexLegacy_d_TemplateLiteral as TemplateLiteral, type indexLegacy_d_Terminatorless as Terminatorless, type indexLegacy_d_ThisExpression as ThisExpression, type indexLegacy_d_ThisTypeAnnotation as ThisTypeAnnotation, type indexLegacy_d_ThrowStatement as ThrowStatement, type indexLegacy_d_TopicReference as TopicReference, type indexLegacy_d_TraversalAncestors as TraversalAncestors, type indexLegacy_d_TraversalHandler as TraversalHandler, type indexLegacy_d_TraversalHandlers as TraversalHandlers, type indexLegacy_d_TryStatement as TryStatement, type indexLegacy_d_TupleExpression as TupleExpression, type indexLegacy_d_TupleTypeAnnotation as TupleTypeAnnotation, type indexLegacy_d_TypeAlias as TypeAlias, type indexLegacy_d_TypeAnnotation as TypeAnnotation, type indexLegacy_d_TypeCastExpression as TypeCastExpression, type indexLegacy_d_TypeParameter as TypeParameter, type indexLegacy_d_TypeParameterDeclaration as TypeParameterDeclaration, type indexLegacy_d_TypeParameterInstantiation as TypeParameterInstantiation, type indexLegacy_d_TypeScript as TypeScript, type indexLegacy_d_TypeofTypeAnnotation as TypeofTypeAnnotation, type indexLegacy_d_UnaryExpression as UnaryExpression, type indexLegacy_d_UnaryLike as UnaryLike, type indexLegacy_d_UnionTypeAnnotation as UnionTypeAnnotation, type indexLegacy_d_UpdateExpression as UpdateExpression, type indexLegacy_d_UserWhitespacable as UserWhitespacable, type indexLegacy_d_V8IntrinsicIdentifier as V8IntrinsicIdentifier, type indexLegacy_d_VariableDeclaration as VariableDeclaration, type indexLegacy_d_VariableDeclarator as VariableDeclarator, type indexLegacy_d_Variance as Variance, type indexLegacy_d_VoidTypeAnnotation as VoidTypeAnnotation, type indexLegacy_d_While as While, type indexLegacy_d_WhileStatement as WhileStatement, type indexLegacy_d_WithStatement as WithStatement, type indexLegacy_d_YieldExpression as YieldExpression, indexLegacy_d_addComment as addComment, indexLegacy_d_addComments as addComments, indexLegacy_d_anyTypeAnnotation as anyTypeAnnotation, indexLegacy_d_appendToMemberExpression as appendToMemberExpression, indexLegacy_d_argumentPlaceholder as argumentPlaceholder, indexLegacy_d_arrayExpression as arrayExpression, indexLegacy_d_arrayPattern as arrayPattern, indexLegacy_d_arrayTypeAnnotation as arrayTypeAnnotation, indexLegacy_d_arrowFunctionExpression as arrowFunctionExpression, indexLegacy_d_assertAccessor as assertAccessor, indexLegacy_d_assertAnyTypeAnnotation as assertAnyTypeAnnotation, indexLegacy_d_assertArgumentPlaceholder as assertArgumentPlaceholder, indexLegacy_d_assertArrayExpression as assertArrayExpression, indexLegacy_d_assertArrayPattern as assertArrayPattern, indexLegacy_d_assertArrayTypeAnnotation as assertArrayTypeAnnotation, indexLegacy_d_assertArrowFunctionExpression as assertArrowFunctionExpression, indexLegacy_d_assertAssignmentExpression as assertAssignmentExpression, indexLegacy_d_assertAssignmentPattern as assertAssignmentPattern, indexLegacy_d_assertAwaitExpression as assertAwaitExpression, indexLegacy_d_assertBigIntLiteral as assertBigIntLiteral, indexLegacy_d_assertBinary as assertBinary, indexLegacy_d_assertBinaryExpression as assertBinaryExpression, indexLegacy_d_assertBindExpression as assertBindExpression, indexLegacy_d_assertBlock as assertBlock, indexLegacy_d_assertBlockParent as assertBlockParent, indexLegacy_d_assertBlockStatement as assertBlockStatement, indexLegacy_d_assertBooleanLiteral as assertBooleanLiteral, indexLegacy_d_assertBooleanLiteralTypeAnnotation as assertBooleanLiteralTypeAnnotation, indexLegacy_d_assertBooleanTypeAnnotation as assertBooleanTypeAnnotation, indexLegacy_d_assertBreakStatement as assertBreakStatement, indexLegacy_d_assertCallExpression as assertCallExpression, indexLegacy_d_assertCatchClause as assertCatchClause, indexLegacy_d_assertClass as assertClass, indexLegacy_d_assertClassAccessorProperty as assertClassAccessorProperty, indexLegacy_d_assertClassBody as assertClassBody, indexLegacy_d_assertClassDeclaration as assertClassDeclaration, indexLegacy_d_assertClassExpression as assertClassExpression, indexLegacy_d_assertClassImplements as assertClassImplements, indexLegacy_d_assertClassMethod as assertClassMethod, indexLegacy_d_assertClassPrivateMethod as assertClassPrivateMethod, indexLegacy_d_assertClassPrivateProperty as assertClassPrivateProperty, indexLegacy_d_assertClassProperty as assertClassProperty, indexLegacy_d_assertCompletionStatement as assertCompletionStatement, indexLegacy_d_assertConditional as assertConditional, indexLegacy_d_assertConditionalExpression as assertConditionalExpression, indexLegacy_d_assertContinueStatement as assertContinueStatement, indexLegacy_d_assertDebuggerStatement as assertDebuggerStatement, indexLegacy_d_assertDecimalLiteral as assertDecimalLiteral, indexLegacy_d_assertDeclaration as assertDeclaration, indexLegacy_d_assertDeclareClass as assertDeclareClass, indexLegacy_d_assertDeclareExportAllDeclaration as assertDeclareExportAllDeclaration, indexLegacy_d_assertDeclareExportDeclaration as assertDeclareExportDeclaration, indexLegacy_d_assertDeclareFunction as assertDeclareFunction, indexLegacy_d_assertDeclareInterface as assertDeclareInterface, indexLegacy_d_assertDeclareModule as assertDeclareModule, indexLegacy_d_assertDeclareModuleExports as assertDeclareModuleExports, indexLegacy_d_assertDeclareOpaqueType as assertDeclareOpaqueType, indexLegacy_d_assertDeclareTypeAlias as assertDeclareTypeAlias, indexLegacy_d_assertDeclareVariable as assertDeclareVariable, indexLegacy_d_assertDeclaredPredicate as assertDeclaredPredicate, indexLegacy_d_assertDecorator as assertDecorator, indexLegacy_d_assertDirective as assertDirective, indexLegacy_d_assertDirectiveLiteral as assertDirectiveLiteral, indexLegacy_d_assertDoExpression as assertDoExpression, indexLegacy_d_assertDoWhileStatement as assertDoWhileStatement, indexLegacy_d_assertEmptyStatement as assertEmptyStatement, indexLegacy_d_assertEmptyTypeAnnotation as assertEmptyTypeAnnotation, indexLegacy_d_assertEnumBody as assertEnumBody, indexLegacy_d_assertEnumBooleanBody as assertEnumBooleanBody, indexLegacy_d_assertEnumBooleanMember as assertEnumBooleanMember, indexLegacy_d_assertEnumDeclaration as assertEnumDeclaration, indexLegacy_d_assertEnumDefaultedMember as assertEnumDefaultedMember, indexLegacy_d_assertEnumMember as assertEnumMember, indexLegacy_d_assertEnumNumberBody as assertEnumNumberBody, indexLegacy_d_assertEnumNumberMember as assertEnumNumberMember, indexLegacy_d_assertEnumStringBody as assertEnumStringBody, indexLegacy_d_assertEnumStringMember as assertEnumStringMember, indexLegacy_d_assertEnumSymbolBody as assertEnumSymbolBody, indexLegacy_d_assertExistsTypeAnnotation as assertExistsTypeAnnotation, indexLegacy_d_assertExportAllDeclaration as assertExportAllDeclaration, indexLegacy_d_assertExportDeclaration as assertExportDeclaration, indexLegacy_d_assertExportDefaultDeclaration as assertExportDefaultDeclaration, indexLegacy_d_assertExportDefaultSpecifier as assertExportDefaultSpecifier, indexLegacy_d_assertExportNamedDeclaration as assertExportNamedDeclaration, indexLegacy_d_assertExportNamespaceSpecifier as assertExportNamespaceSpecifier, indexLegacy_d_assertExportSpecifier as assertExportSpecifier, indexLegacy_d_assertExpression as assertExpression, indexLegacy_d_assertExpressionStatement as assertExpressionStatement, indexLegacy_d_assertExpressionWrapper as assertExpressionWrapper, indexLegacy_d_assertFile as assertFile, indexLegacy_d_assertFlow as assertFlow, indexLegacy_d_assertFlowBaseAnnotation as assertFlowBaseAnnotation, indexLegacy_d_assertFlowDeclaration as assertFlowDeclaration, indexLegacy_d_assertFlowPredicate as assertFlowPredicate, indexLegacy_d_assertFlowType as assertFlowType, indexLegacy_d_assertFor as assertFor, indexLegacy_d_assertForInStatement as assertForInStatement, indexLegacy_d_assertForOfStatement as assertForOfStatement, indexLegacy_d_assertForStatement as assertForStatement, indexLegacy_d_assertForXStatement as assertForXStatement, indexLegacy_d_assertFunction as assertFunction, indexLegacy_d_assertFunctionDeclaration as assertFunctionDeclaration, indexLegacy_d_assertFunctionExpression as assertFunctionExpression, indexLegacy_d_assertFunctionParent as assertFunctionParent, indexLegacy_d_assertFunctionTypeAnnotation as assertFunctionTypeAnnotation, indexLegacy_d_assertFunctionTypeParam as assertFunctionTypeParam, indexLegacy_d_assertGenericTypeAnnotation as assertGenericTypeAnnotation, indexLegacy_d_assertIdentifier as assertIdentifier, indexLegacy_d_assertIfStatement as assertIfStatement, indexLegacy_d_assertImmutable as assertImmutable, indexLegacy_d_assertImport as assertImport, indexLegacy_d_assertImportAttribute as assertImportAttribute, indexLegacy_d_assertImportDeclaration as assertImportDeclaration, indexLegacy_d_assertImportDefaultSpecifier as assertImportDefaultSpecifier, indexLegacy_d_assertImportExpression as assertImportExpression, indexLegacy_d_assertImportNamespaceSpecifier as assertImportNamespaceSpecifier, indexLegacy_d_assertImportOrExportDeclaration as assertImportOrExportDeclaration, indexLegacy_d_assertImportSpecifier as assertImportSpecifier, indexLegacy_d_assertIndexedAccessType as assertIndexedAccessType, indexLegacy_d_assertInferredPredicate as assertInferredPredicate, indexLegacy_d_assertInterfaceDeclaration as assertInterfaceDeclaration, indexLegacy_d_assertInterfaceExtends as assertInterfaceExtends, indexLegacy_d_assertInterfaceTypeAnnotation as assertInterfaceTypeAnnotation, indexLegacy_d_assertInterpreterDirective as assertInterpreterDirective, indexLegacy_d_assertIntersectionTypeAnnotation as assertIntersectionTypeAnnotation, indexLegacy_d_assertJSX as assertJSX, indexLegacy_d_assertJSXAttribute as assertJSXAttribute, indexLegacy_d_assertJSXClosingElement as assertJSXClosingElement, indexLegacy_d_assertJSXClosingFragment as assertJSXClosingFragment, indexLegacy_d_assertJSXElement as assertJSXElement, indexLegacy_d_assertJSXEmptyExpression as assertJSXEmptyExpression, indexLegacy_d_assertJSXExpressionContainer as assertJSXExpressionContainer, indexLegacy_d_assertJSXFragment as assertJSXFragment, indexLegacy_d_assertJSXIdentifier as assertJSXIdentifier, indexLegacy_d_assertJSXMemberExpression as assertJSXMemberExpression, indexLegacy_d_assertJSXNamespacedName as assertJSXNamespacedName, indexLegacy_d_assertJSXOpeningElement as assertJSXOpeningElement, indexLegacy_d_assertJSXOpeningFragment as assertJSXOpeningFragment, indexLegacy_d_assertJSXSpreadAttribute as assertJSXSpreadAttribute, indexLegacy_d_assertJSXSpreadChild as assertJSXSpreadChild, indexLegacy_d_assertJSXText as assertJSXText, indexLegacy_d_assertLVal as assertLVal, indexLegacy_d_assertLabeledStatement as assertLabeledStatement, indexLegacy_d_assertLiteral as assertLiteral, indexLegacy_d_assertLogicalExpression as assertLogicalExpression, indexLegacy_d_assertLoop as assertLoop, indexLegacy_d_assertMemberExpression as assertMemberExpression, indexLegacy_d_assertMetaProperty as assertMetaProperty, indexLegacy_d_assertMethod as assertMethod, indexLegacy_d_assertMiscellaneous as assertMiscellaneous, indexLegacy_d_assertMixedTypeAnnotation as assertMixedTypeAnnotation, indexLegacy_d_assertModuleDeclaration as assertModuleDeclaration, indexLegacy_d_assertModuleExpression as assertModuleExpression, indexLegacy_d_assertModuleSpecifier as assertModuleSpecifier, indexLegacy_d_assertNewExpression as assertNewExpression, indexLegacy_d_assertNode as assertNode, indexLegacy_d_assertNullLiteral as assertNullLiteral, indexLegacy_d_assertNullLiteralTypeAnnotation as assertNullLiteralTypeAnnotation, indexLegacy_d_assertNullableTypeAnnotation as assertNullableTypeAnnotation, indexLegacy_d_assertNumberLiteral as assertNumberLiteral, indexLegacy_d_assertNumberLiteralTypeAnnotation as assertNumberLiteralTypeAnnotation, indexLegacy_d_assertNumberTypeAnnotation as assertNumberTypeAnnotation, indexLegacy_d_assertNumericLiteral as assertNumericLiteral, indexLegacy_d_assertObjectExpression as assertObjectExpression, indexLegacy_d_assertObjectMember as assertObjectMember, indexLegacy_d_assertObjectMethod as assertObjectMethod, indexLegacy_d_assertObjectPattern as assertObjectPattern, indexLegacy_d_assertObjectProperty as assertObjectProperty, indexLegacy_d_assertObjectTypeAnnotation as assertObjectTypeAnnotation, indexLegacy_d_assertObjectTypeCallProperty as assertObjectTypeCallProperty, indexLegacy_d_assertObjectTypeIndexer as assertObjectTypeIndexer, indexLegacy_d_assertObjectTypeInternalSlot as assertObjectTypeInternalSlot, indexLegacy_d_assertObjectTypeProperty as assertObjectTypeProperty, indexLegacy_d_assertObjectTypeSpreadProperty as assertObjectTypeSpreadProperty, indexLegacy_d_assertOpaqueType as assertOpaqueType, indexLegacy_d_assertOptionalCallExpression as assertOptionalCallExpression, indexLegacy_d_assertOptionalIndexedAccessType as assertOptionalIndexedAccessType, indexLegacy_d_assertOptionalMemberExpression as assertOptionalMemberExpression, indexLegacy_d_assertParenthesizedExpression as assertParenthesizedExpression, indexLegacy_d_assertPattern as assertPattern, indexLegacy_d_assertPatternLike as assertPatternLike, indexLegacy_d_assertPipelineBareFunction as assertPipelineBareFunction, indexLegacy_d_assertPipelinePrimaryTopicReference as assertPipelinePrimaryTopicReference, indexLegacy_d_assertPipelineTopicExpression as assertPipelineTopicExpression, indexLegacy_d_assertPlaceholder as assertPlaceholder, indexLegacy_d_assertPrivate as assertPrivate, indexLegacy_d_assertPrivateName as assertPrivateName, indexLegacy_d_assertProgram as assertProgram, indexLegacy_d_assertProperty as assertProperty, indexLegacy_d_assertPureish as assertPureish, indexLegacy_d_assertQualifiedTypeIdentifier as assertQualifiedTypeIdentifier, indexLegacy_d_assertRecordExpression as assertRecordExpression, indexLegacy_d_assertRegExpLiteral as assertRegExpLiteral, indexLegacy_d_assertRegexLiteral as assertRegexLiteral, indexLegacy_d_assertRestElement as assertRestElement, indexLegacy_d_assertRestProperty as assertRestProperty, indexLegacy_d_assertReturnStatement as assertReturnStatement, indexLegacy_d_assertScopable as assertScopable, indexLegacy_d_assertSequenceExpression as assertSequenceExpression, indexLegacy_d_assertSpreadElement as assertSpreadElement, indexLegacy_d_assertSpreadProperty as assertSpreadProperty, indexLegacy_d_assertStandardized as assertStandardized, indexLegacy_d_assertStatement as assertStatement, indexLegacy_d_assertStaticBlock as assertStaticBlock, indexLegacy_d_assertStringLiteral as assertStringLiteral, indexLegacy_d_assertStringLiteralTypeAnnotation as assertStringLiteralTypeAnnotation, indexLegacy_d_assertStringTypeAnnotation as assertStringTypeAnnotation, indexLegacy_d_assertSuper as assertSuper, indexLegacy_d_assertSwitchCase as assertSwitchCase, indexLegacy_d_assertSwitchStatement as assertSwitchStatement, indexLegacy_d_assertSymbolTypeAnnotation as assertSymbolTypeAnnotation, indexLegacy_d_assertTSAnyKeyword as assertTSAnyKeyword, indexLegacy_d_assertTSArrayType as assertTSArrayType, indexLegacy_d_assertTSAsExpression as assertTSAsExpression, indexLegacy_d_assertTSBaseType as assertTSBaseType, indexLegacy_d_assertTSBigIntKeyword as assertTSBigIntKeyword, indexLegacy_d_assertTSBooleanKeyword as assertTSBooleanKeyword, indexLegacy_d_assertTSCallSignatureDeclaration as assertTSCallSignatureDeclaration, indexLegacy_d_assertTSConditionalType as assertTSConditionalType, indexLegacy_d_assertTSConstructSignatureDeclaration as assertTSConstructSignatureDeclaration, indexLegacy_d_assertTSConstructorType as assertTSConstructorType, indexLegacy_d_assertTSDeclareFunction as assertTSDeclareFunction, indexLegacy_d_assertTSDeclareMethod as assertTSDeclareMethod, indexLegacy_d_assertTSEntityName as assertTSEntityName, indexLegacy_d_assertTSEnumDeclaration as assertTSEnumDeclaration, indexLegacy_d_assertTSEnumMember as assertTSEnumMember, indexLegacy_d_assertTSExportAssignment as assertTSExportAssignment, indexLegacy_d_assertTSExpressionWithTypeArguments as assertTSExpressionWithTypeArguments, indexLegacy_d_assertTSExternalModuleReference as assertTSExternalModuleReference, indexLegacy_d_assertTSFunctionType as assertTSFunctionType, indexLegacy_d_assertTSImportEqualsDeclaration as assertTSImportEqualsDeclaration, indexLegacy_d_assertTSImportType as assertTSImportType, indexLegacy_d_assertTSIndexSignature as assertTSIndexSignature, indexLegacy_d_assertTSIndexedAccessType as assertTSIndexedAccessType, indexLegacy_d_assertTSInferType as assertTSInferType, indexLegacy_d_assertTSInstantiationExpression as assertTSInstantiationExpression, indexLegacy_d_assertTSInterfaceBody as assertTSInterfaceBody, indexLegacy_d_assertTSInterfaceDeclaration as assertTSInterfaceDeclaration, indexLegacy_d_assertTSIntersectionType as assertTSIntersectionType, indexLegacy_d_assertTSIntrinsicKeyword as assertTSIntrinsicKeyword, indexLegacy_d_assertTSLiteralType as assertTSLiteralType, indexLegacy_d_assertTSMappedType as assertTSMappedType, indexLegacy_d_assertTSMethodSignature as assertTSMethodSignature, indexLegacy_d_assertTSModuleBlock as assertTSModuleBlock, indexLegacy_d_assertTSModuleDeclaration as assertTSModuleDeclaration, indexLegacy_d_assertTSNamedTupleMember as assertTSNamedTupleMember, indexLegacy_d_assertTSNamespaceExportDeclaration as assertTSNamespaceExportDeclaration, indexLegacy_d_assertTSNeverKeyword as assertTSNeverKeyword, indexLegacy_d_assertTSNonNullExpression as assertTSNonNullExpression, indexLegacy_d_assertTSNullKeyword as assertTSNullKeyword, indexLegacy_d_assertTSNumberKeyword as assertTSNumberKeyword, indexLegacy_d_assertTSObjectKeyword as assertTSObjectKeyword, indexLegacy_d_assertTSOptionalType as assertTSOptionalType, indexLegacy_d_assertTSParameterProperty as assertTSParameterProperty, indexLegacy_d_assertTSParenthesizedType as assertTSParenthesizedType, indexLegacy_d_assertTSPropertySignature as assertTSPropertySignature, indexLegacy_d_assertTSQualifiedName as assertTSQualifiedName, indexLegacy_d_assertTSRestType as assertTSRestType, indexLegacy_d_assertTSSatisfiesExpression as assertTSSatisfiesExpression, indexLegacy_d_assertTSStringKeyword as assertTSStringKeyword, indexLegacy_d_assertTSSymbolKeyword as assertTSSymbolKeyword, indexLegacy_d_assertTSThisType as assertTSThisType, indexLegacy_d_assertTSTupleType as assertTSTupleType, indexLegacy_d_assertTSType as assertTSType, indexLegacy_d_assertTSTypeAliasDeclaration as assertTSTypeAliasDeclaration, indexLegacy_d_assertTSTypeAnnotation as assertTSTypeAnnotation, indexLegacy_d_assertTSTypeAssertion as assertTSTypeAssertion, indexLegacy_d_assertTSTypeElement as assertTSTypeElement, indexLegacy_d_assertTSTypeLiteral as assertTSTypeLiteral, indexLegacy_d_assertTSTypeOperator as assertTSTypeOperator, indexLegacy_d_assertTSTypeParameter as assertTSTypeParameter, indexLegacy_d_assertTSTypeParameterDeclaration as assertTSTypeParameterDeclaration, indexLegacy_d_assertTSTypeParameterInstantiation as assertTSTypeParameterInstantiation, indexLegacy_d_assertTSTypePredicate as assertTSTypePredicate, indexLegacy_d_assertTSTypeQuery as assertTSTypeQuery, indexLegacy_d_assertTSTypeReference as assertTSTypeReference, indexLegacy_d_assertTSUndefinedKeyword as assertTSUndefinedKeyword, indexLegacy_d_assertTSUnionType as assertTSUnionType, indexLegacy_d_assertTSUnknownKeyword as assertTSUnknownKeyword, indexLegacy_d_assertTSVoidKeyword as assertTSVoidKeyword, indexLegacy_d_assertTaggedTemplateExpression as assertTaggedTemplateExpression, indexLegacy_d_assertTemplateElement as assertTemplateElement, indexLegacy_d_assertTemplateLiteral as assertTemplateLiteral, indexLegacy_d_assertTerminatorless as assertTerminatorless, indexLegacy_d_assertThisExpression as assertThisExpression, indexLegacy_d_assertThisTypeAnnotation as assertThisTypeAnnotation, indexLegacy_d_assertThrowStatement as assertThrowStatement, indexLegacy_d_assertTopicReference as assertTopicReference, indexLegacy_d_assertTryStatement as assertTryStatement, indexLegacy_d_assertTupleExpression as assertTupleExpression, indexLegacy_d_assertTupleTypeAnnotation as assertTupleTypeAnnotation, indexLegacy_d_assertTypeAlias as assertTypeAlias, indexLegacy_d_assertTypeAnnotation as assertTypeAnnotation, indexLegacy_d_assertTypeCastExpression as assertTypeCastExpression, indexLegacy_d_assertTypeParameter as assertTypeParameter, indexLegacy_d_assertTypeParameterDeclaration as assertTypeParameterDeclaration, indexLegacy_d_assertTypeParameterInstantiation as assertTypeParameterInstantiation, indexLegacy_d_assertTypeScript as assertTypeScript, indexLegacy_d_assertTypeofTypeAnnotation as assertTypeofTypeAnnotation, indexLegacy_d_assertUnaryExpression as assertUnaryExpression, indexLegacy_d_assertUnaryLike as assertUnaryLike, indexLegacy_d_assertUnionTypeAnnotation as assertUnionTypeAnnotation, indexLegacy_d_assertUpdateExpression as assertUpdateExpression, indexLegacy_d_assertUserWhitespacable as assertUserWhitespacable, indexLegacy_d_assertV8IntrinsicIdentifier as assertV8IntrinsicIdentifier, indexLegacy_d_assertVariableDeclaration as assertVariableDeclaration, indexLegacy_d_assertVariableDeclarator as assertVariableDeclarator, indexLegacy_d_assertVariance as assertVariance, indexLegacy_d_assertVoidTypeAnnotation as assertVoidTypeAnnotation, indexLegacy_d_assertWhile as assertWhile, indexLegacy_d_assertWhileStatement as assertWhileStatement, indexLegacy_d_assertWithStatement as assertWithStatement, indexLegacy_d_assertYieldExpression as assertYieldExpression, indexLegacy_d_assignmentExpression as assignmentExpression, indexLegacy_d_assignmentPattern as assignmentPattern, indexLegacy_d_awaitExpression as awaitExpression, indexLegacy_d_bigIntLiteral as bigIntLiteral, indexLegacy_d_binaryExpression as binaryExpression, indexLegacy_d_bindExpression as bindExpression, indexLegacy_d_blockStatement as blockStatement, indexLegacy_d_booleanLiteral as booleanLiteral, indexLegacy_d_booleanLiteralTypeAnnotation as booleanLiteralTypeAnnotation, indexLegacy_d_booleanTypeAnnotation as booleanTypeAnnotation, indexLegacy_d_breakStatement as breakStatement, indexLegacy_d_buildChildren as buildChildren, indexLegacy_d_buildMatchMemberExpression as buildMatchMemberExpression, indexLegacy_d_callExpression as callExpression, indexLegacy_d_catchClause as catchClause, indexLegacy_d_classAccessorProperty as classAccessorProperty, indexLegacy_d_classBody as classBody, indexLegacy_d_classDeclaration as classDeclaration, indexLegacy_d_classExpression as classExpression, indexLegacy_d_classImplements as classImplements, indexLegacy_d_classMethod as classMethod, indexLegacy_d_classPrivateMethod as classPrivateMethod, indexLegacy_d_classPrivateProperty as classPrivateProperty, indexLegacy_d_classProperty as classProperty, indexLegacy_d_clone as clone, indexLegacy_d_cloneDeep as cloneDeep, indexLegacy_d_cloneDeepWithoutLoc as cloneDeepWithoutLoc, indexLegacy_d_cloneNode as cloneNode, indexLegacy_d_cloneWithoutLoc as cloneWithoutLoc, indexLegacy_d_conditionalExpression as conditionalExpression, indexLegacy_d_continueStatement as continueStatement, indexLegacy_d_createFlowUnionType as createFlowUnionType, indexLegacy_d_createTypeAnnotationBasedOnTypeof as createTypeAnnotationBasedOnTypeof, indexLegacy_d_createUnionTypeAnnotation as createUnionTypeAnnotation, indexLegacy_d_debuggerStatement as debuggerStatement, indexLegacy_d_decimalLiteral as decimalLiteral, indexLegacy_d_declareClass as declareClass, indexLegacy_d_declareExportAllDeclaration as declareExportAllDeclaration, indexLegacy_d_declareExportDeclaration as declareExportDeclaration, indexLegacy_d_declareFunction as declareFunction, indexLegacy_d_declareInterface as declareInterface, indexLegacy_d_declareModule as declareModule, indexLegacy_d_declareModuleExports as declareModuleExports, indexLegacy_d_declareOpaqueType as declareOpaqueType, indexLegacy_d_declareTypeAlias as declareTypeAlias, indexLegacy_d_declareVariable as declareVariable, indexLegacy_d_declaredPredicate as declaredPredicate, indexLegacy_d_decorator as decorator, indexLegacy_d_directive as directive, indexLegacy_d_directiveLiteral as directiveLiteral, indexLegacy_d_doExpression as doExpression, indexLegacy_d_doWhileStatement as doWhileStatement, indexLegacy_d_emptyStatement as emptyStatement, indexLegacy_d_emptyTypeAnnotation as emptyTypeAnnotation, indexLegacy_d_ensureBlock as ensureBlock, indexLegacy_d_enumBooleanBody as enumBooleanBody, indexLegacy_d_enumBooleanMember as enumBooleanMember, indexLegacy_d_enumDeclaration as enumDeclaration, indexLegacy_d_enumDefaultedMember as enumDefaultedMember, indexLegacy_d_enumNumberBody as enumNumberBody, indexLegacy_d_enumNumberMember as enumNumberMember, indexLegacy_d_enumStringBody as enumStringBody, indexLegacy_d_enumStringMember as enumStringMember, indexLegacy_d_enumSymbolBody as enumSymbolBody, indexLegacy_d_existsTypeAnnotation as existsTypeAnnotation, indexLegacy_d_exportAllDeclaration as exportAllDeclaration, indexLegacy_d_exportDefaultDeclaration as exportDefaultDeclaration, indexLegacy_d_exportDefaultSpecifier as exportDefaultSpecifier, indexLegacy_d_exportNamedDeclaration as exportNamedDeclaration, indexLegacy_d_exportNamespaceSpecifier as exportNamespaceSpecifier, indexLegacy_d_exportSpecifier as exportSpecifier, indexLegacy_d_expressionStatement as expressionStatement, indexLegacy_d_file as file, indexLegacy_d_forInStatement as forInStatement, indexLegacy_d_forOfStatement as forOfStatement, indexLegacy_d_forStatement as forStatement, indexLegacy_d_functionDeclaration as functionDeclaration, indexLegacy_d_functionExpression as functionExpression, indexLegacy_d_functionTypeAnnotation as functionTypeAnnotation, indexLegacy_d_functionTypeParam as functionTypeParam, indexLegacy_d_genericTypeAnnotation as genericTypeAnnotation, indexLegacy_d_getBindingIdentifiers as getBindingIdentifiers, indexLegacy_d_getOuterBindingIdentifiers as getOuterBindingIdentifiers, indexLegacy_d_identifier as identifier, indexLegacy_d_ifStatement as ifStatement, _import as import, indexLegacy_d_importAttribute as importAttribute, indexLegacy_d_importDeclaration as importDeclaration, indexLegacy_d_importDefaultSpecifier as importDefaultSpecifier, indexLegacy_d_importExpression as importExpression, indexLegacy_d_importNamespaceSpecifier as importNamespaceSpecifier, indexLegacy_d_importSpecifier as importSpecifier, indexLegacy_d_indexedAccessType as indexedAccessType, indexLegacy_d_inferredPredicate as inferredPredicate, indexLegacy_d_inheritInnerComments as inheritInnerComments, indexLegacy_d_inheritLeadingComments as inheritLeadingComments, indexLegacy_d_inheritTrailingComments as inheritTrailingComments, indexLegacy_d_inherits as inherits, indexLegacy_d_inheritsComments as inheritsComments, indexLegacy_d_interfaceDeclaration as interfaceDeclaration, indexLegacy_d_interfaceExtends as interfaceExtends, indexLegacy_d_interfaceTypeAnnotation as interfaceTypeAnnotation, indexLegacy_d_interpreterDirective as interpreterDirective, indexLegacy_d_intersectionTypeAnnotation as intersectionTypeAnnotation, indexLegacy_d_is as is, indexLegacy_d_isAccessor as isAccessor, indexLegacy_d_isAnyTypeAnnotation as isAnyTypeAnnotation, indexLegacy_d_isArgumentPlaceholder as isArgumentPlaceholder, indexLegacy_d_isArrayExpression as isArrayExpression, indexLegacy_d_isArrayPattern as isArrayPattern, indexLegacy_d_isArrayTypeAnnotation as isArrayTypeAnnotation, indexLegacy_d_isArrowFunctionExpression as isArrowFunctionExpression, indexLegacy_d_isAssignmentExpression as isAssignmentExpression, indexLegacy_d_isAssignmentPattern as isAssignmentPattern, indexLegacy_d_isAwaitExpression as isAwaitExpression, indexLegacy_d_isBigIntLiteral as isBigIntLiteral, indexLegacy_d_isBinary as isBinary, indexLegacy_d_isBinaryExpression as isBinaryExpression, indexLegacy_d_isBindExpression as isBindExpression, indexLegacy_d_isBinding as isBinding, indexLegacy_d_isBlock as isBlock, indexLegacy_d_isBlockParent as isBlockParent, indexLegacy_d_isBlockScoped as isBlockScoped, indexLegacy_d_isBlockStatement as isBlockStatement, indexLegacy_d_isBooleanLiteral as isBooleanLiteral, indexLegacy_d_isBooleanLiteralTypeAnnotation as isBooleanLiteralTypeAnnotation, indexLegacy_d_isBooleanTypeAnnotation as isBooleanTypeAnnotation, indexLegacy_d_isBreakStatement as isBreakStatement, indexLegacy_d_isCallExpression as isCallExpression, indexLegacy_d_isCatchClause as isCatchClause, indexLegacy_d_isClass as isClass, indexLegacy_d_isClassAccessorProperty as isClassAccessorProperty, indexLegacy_d_isClassBody as isClassBody, indexLegacy_d_isClassDeclaration as isClassDeclaration, indexLegacy_d_isClassExpression as isClassExpression, indexLegacy_d_isClassImplements as isClassImplements, indexLegacy_d_isClassMethod as isClassMethod, indexLegacy_d_isClassPrivateMethod as isClassPrivateMethod, indexLegacy_d_isClassPrivateProperty as isClassPrivateProperty, indexLegacy_d_isClassProperty as isClassProperty, indexLegacy_d_isCompletionStatement as isCompletionStatement, indexLegacy_d_isConditional as isConditional, indexLegacy_d_isConditionalExpression as isConditionalExpression, indexLegacy_d_isContinueStatement as isContinueStatement, indexLegacy_d_isDebuggerStatement as isDebuggerStatement, indexLegacy_d_isDecimalLiteral as isDecimalLiteral, indexLegacy_d_isDeclaration as isDeclaration, indexLegacy_d_isDeclareClass as isDeclareClass, indexLegacy_d_isDeclareExportAllDeclaration as isDeclareExportAllDeclaration, indexLegacy_d_isDeclareExportDeclaration as isDeclareExportDeclaration, indexLegacy_d_isDeclareFunction as isDeclareFunction, indexLegacy_d_isDeclareInterface as isDeclareInterface, indexLegacy_d_isDeclareModule as isDeclareModule, indexLegacy_d_isDeclareModuleExports as isDeclareModuleExports, indexLegacy_d_isDeclareOpaqueType as isDeclareOpaqueType, indexLegacy_d_isDeclareTypeAlias as isDeclareTypeAlias, indexLegacy_d_isDeclareVariable as isDeclareVariable, indexLegacy_d_isDeclaredPredicate as isDeclaredPredicate, indexLegacy_d_isDecorator as isDecorator, indexLegacy_d_isDirective as isDirective, indexLegacy_d_isDirectiveLiteral as isDirectiveLiteral, indexLegacy_d_isDoExpression as isDoExpression, indexLegacy_d_isDoWhileStatement as isDoWhileStatement, indexLegacy_d_isEmptyStatement as isEmptyStatement, indexLegacy_d_isEmptyTypeAnnotation as isEmptyTypeAnnotation, indexLegacy_d_isEnumBody as isEnumBody, indexLegacy_d_isEnumBooleanBody as isEnumBooleanBody, indexLegacy_d_isEnumBooleanMember as isEnumBooleanMember, indexLegacy_d_isEnumDeclaration as isEnumDeclaration, indexLegacy_d_isEnumDefaultedMember as isEnumDefaultedMember, indexLegacy_d_isEnumMember as isEnumMember, indexLegacy_d_isEnumNumberBody as isEnumNumberBody, indexLegacy_d_isEnumNumberMember as isEnumNumberMember, indexLegacy_d_isEnumStringBody as isEnumStringBody, indexLegacy_d_isEnumStringMember as isEnumStringMember, indexLegacy_d_isEnumSymbolBody as isEnumSymbolBody, indexLegacy_d_isExistsTypeAnnotation as isExistsTypeAnnotation, indexLegacy_d_isExportAllDeclaration as isExportAllDeclaration, indexLegacy_d_isExportDeclaration as isExportDeclaration, indexLegacy_d_isExportDefaultDeclaration as isExportDefaultDeclaration, indexLegacy_d_isExportDefaultSpecifier as isExportDefaultSpecifier, indexLegacy_d_isExportNamedDeclaration as isExportNamedDeclaration, indexLegacy_d_isExportNamespaceSpecifier as isExportNamespaceSpecifier, indexLegacy_d_isExportSpecifier as isExportSpecifier, indexLegacy_d_isExpression as isExpression, indexLegacy_d_isExpressionStatement as isExpressionStatement, indexLegacy_d_isExpressionWrapper as isExpressionWrapper, indexLegacy_d_isFile as isFile, indexLegacy_d_isFlow as isFlow, indexLegacy_d_isFlowBaseAnnotation as isFlowBaseAnnotation, indexLegacy_d_isFlowDeclaration as isFlowDeclaration, indexLegacy_d_isFlowPredicate as isFlowPredicate, indexLegacy_d_isFlowType as isFlowType, indexLegacy_d_isFor as isFor, indexLegacy_d_isForInStatement as isForInStatement, indexLegacy_d_isForOfStatement as isForOfStatement, indexLegacy_d_isForStatement as isForStatement, indexLegacy_d_isForXStatement as isForXStatement, indexLegacy_d_isFunction as isFunction, indexLegacy_d_isFunctionDeclaration as isFunctionDeclaration, indexLegacy_d_isFunctionExpression as isFunctionExpression, indexLegacy_d_isFunctionParent as isFunctionParent, indexLegacy_d_isFunctionTypeAnnotation as isFunctionTypeAnnotation, indexLegacy_d_isFunctionTypeParam as isFunctionTypeParam, indexLegacy_d_isGenericTypeAnnotation as isGenericTypeAnnotation, indexLegacy_d_isIdentifier as isIdentifier, indexLegacy_d_isIfStatement as isIfStatement, indexLegacy_d_isImmutable as isImmutable, indexLegacy_d_isImport as isImport, indexLegacy_d_isImportAttribute as isImportAttribute, indexLegacy_d_isImportDeclaration as isImportDeclaration, indexLegacy_d_isImportDefaultSpecifier as isImportDefaultSpecifier, indexLegacy_d_isImportExpression as isImportExpression, indexLegacy_d_isImportNamespaceSpecifier as isImportNamespaceSpecifier, indexLegacy_d_isImportOrExportDeclaration as isImportOrExportDeclaration, indexLegacy_d_isImportSpecifier as isImportSpecifier, indexLegacy_d_isIndexedAccessType as isIndexedAccessType, indexLegacy_d_isInferredPredicate as isInferredPredicate, indexLegacy_d_isInterfaceDeclaration as isInterfaceDeclaration, indexLegacy_d_isInterfaceExtends as isInterfaceExtends, indexLegacy_d_isInterfaceTypeAnnotation as isInterfaceTypeAnnotation, indexLegacy_d_isInterpreterDirective as isInterpreterDirective, indexLegacy_d_isIntersectionTypeAnnotation as isIntersectionTypeAnnotation, indexLegacy_d_isJSX as isJSX, indexLegacy_d_isJSXAttribute as isJSXAttribute, indexLegacy_d_isJSXClosingElement as isJSXClosingElement, indexLegacy_d_isJSXClosingFragment as isJSXClosingFragment, indexLegacy_d_isJSXElement as isJSXElement, indexLegacy_d_isJSXEmptyExpression as isJSXEmptyExpression, indexLegacy_d_isJSXExpressionContainer as isJSXExpressionContainer, indexLegacy_d_isJSXFragment as isJSXFragment, indexLegacy_d_isJSXIdentifier as isJSXIdentifier, indexLegacy_d_isJSXMemberExpression as isJSXMemberExpression, indexLegacy_d_isJSXNamespacedName as isJSXNamespacedName, indexLegacy_d_isJSXOpeningElement as isJSXOpeningElement, indexLegacy_d_isJSXOpeningFragment as isJSXOpeningFragment, indexLegacy_d_isJSXSpreadAttribute as isJSXSpreadAttribute, indexLegacy_d_isJSXSpreadChild as isJSXSpreadChild, indexLegacy_d_isJSXText as isJSXText, indexLegacy_d_isLVal as isLVal, indexLegacy_d_isLabeledStatement as isLabeledStatement, indexLegacy_d_isLet as isLet, indexLegacy_d_isLiteral as isLiteral, indexLegacy_d_isLogicalExpression as isLogicalExpression, indexLegacy_d_isLoop as isLoop, indexLegacy_d_isMemberExpression as isMemberExpression, indexLegacy_d_isMetaProperty as isMetaProperty, indexLegacy_d_isMethod as isMethod, indexLegacy_d_isMiscellaneous as isMiscellaneous, indexLegacy_d_isMixedTypeAnnotation as isMixedTypeAnnotation, indexLegacy_d_isModuleDeclaration as isModuleDeclaration, indexLegacy_d_isModuleExpression as isModuleExpression, indexLegacy_d_isModuleSpecifier as isModuleSpecifier, indexLegacy_d_isNewExpression as isNewExpression, indexLegacy_d_isNode as isNode, indexLegacy_d_isNodesEquivalent as isNodesEquivalent, indexLegacy_d_isNullLiteral as isNullLiteral, indexLegacy_d_isNullLiteralTypeAnnotation as isNullLiteralTypeAnnotation, indexLegacy_d_isNullableTypeAnnotation as isNullableTypeAnnotation, indexLegacy_d_isNumberLiteral as isNumberLiteral, indexLegacy_d_isNumberLiteralTypeAnnotation as isNumberLiteralTypeAnnotation, indexLegacy_d_isNumberTypeAnnotation as isNumberTypeAnnotation, indexLegacy_d_isNumericLiteral as isNumericLiteral, indexLegacy_d_isObjectExpression as isObjectExpression, indexLegacy_d_isObjectMember as isObjectMember, indexLegacy_d_isObjectMethod as isObjectMethod, indexLegacy_d_isObjectPattern as isObjectPattern, indexLegacy_d_isObjectProperty as isObjectProperty, indexLegacy_d_isObjectTypeAnnotation as isObjectTypeAnnotation, indexLegacy_d_isObjectTypeCallProperty as isObjectTypeCallProperty, indexLegacy_d_isObjectTypeIndexer as isObjectTypeIndexer, indexLegacy_d_isObjectTypeInternalSlot as isObjectTypeInternalSlot, indexLegacy_d_isObjectTypeProperty as isObjectTypeProperty, indexLegacy_d_isObjectTypeSpreadProperty as isObjectTypeSpreadProperty, indexLegacy_d_isOpaqueType as isOpaqueType, indexLegacy_d_isOptionalCallExpression as isOptionalCallExpression, indexLegacy_d_isOptionalIndexedAccessType as isOptionalIndexedAccessType, indexLegacy_d_isOptionalMemberExpression as isOptionalMemberExpression, indexLegacy_d_isParenthesizedExpression as isParenthesizedExpression, indexLegacy_d_isPattern as isPattern, indexLegacy_d_isPatternLike as isPatternLike, indexLegacy_d_isPipelineBareFunction as isPipelineBareFunction, indexLegacy_d_isPipelinePrimaryTopicReference as isPipelinePrimaryTopicReference, indexLegacy_d_isPipelineTopicExpression as isPipelineTopicExpression, indexLegacy_d_isPlaceholder as isPlaceholder, indexLegacy_d_isPlaceholderType as isPlaceholderType, indexLegacy_d_isPrivate as isPrivate, indexLegacy_d_isPrivateName as isPrivateName, indexLegacy_d_isProgram as isProgram, indexLegacy_d_isProperty as isProperty, indexLegacy_d_isPureish as isPureish, indexLegacy_d_isQualifiedTypeIdentifier as isQualifiedTypeIdentifier, indexLegacy_d_isRecordExpression as isRecordExpression, indexLegacy_d_isReferenced as isReferenced, indexLegacy_d_isRegExpLiteral as isRegExpLiteral, indexLegacy_d_isRegexLiteral as isRegexLiteral, indexLegacy_d_isRestElement as isRestElement, indexLegacy_d_isRestProperty as isRestProperty, indexLegacy_d_isReturnStatement as isReturnStatement, indexLegacy_d_isScopable as isScopable, indexLegacy_d_isScope as isScope, indexLegacy_d_isSequenceExpression as isSequenceExpression, indexLegacy_d_isSpecifierDefault as isSpecifierDefault, indexLegacy_d_isSpreadElement as isSpreadElement, indexLegacy_d_isSpreadProperty as isSpreadProperty, indexLegacy_d_isStandardized as isStandardized, indexLegacy_d_isStatement as isStatement, indexLegacy_d_isStaticBlock as isStaticBlock, indexLegacy_d_isStringLiteral as isStringLiteral, indexLegacy_d_isStringLiteralTypeAnnotation as isStringLiteralTypeAnnotation, indexLegacy_d_isStringTypeAnnotation as isStringTypeAnnotation, indexLegacy_d_isSuper as isSuper, indexLegacy_d_isSwitchCase as isSwitchCase, indexLegacy_d_isSwitchStatement as isSwitchStatement, indexLegacy_d_isSymbolTypeAnnotation as isSymbolTypeAnnotation, indexLegacy_d_isTSAnyKeyword as isTSAnyKeyword, indexLegacy_d_isTSArrayType as isTSArrayType, indexLegacy_d_isTSAsExpression as isTSAsExpression, indexLegacy_d_isTSBaseType as isTSBaseType, indexLegacy_d_isTSBigIntKeyword as isTSBigIntKeyword, indexLegacy_d_isTSBooleanKeyword as isTSBooleanKeyword, indexLegacy_d_isTSCallSignatureDeclaration as isTSCallSignatureDeclaration, indexLegacy_d_isTSConditionalType as isTSConditionalType, indexLegacy_d_isTSConstructSignatureDeclaration as isTSConstructSignatureDeclaration, indexLegacy_d_isTSConstructorType as isTSConstructorType, indexLegacy_d_isTSDeclareFunction as isTSDeclareFunction, indexLegacy_d_isTSDeclareMethod as isTSDeclareMethod, indexLegacy_d_isTSEntityName as isTSEntityName, indexLegacy_d_isTSEnumDeclaration as isTSEnumDeclaration, indexLegacy_d_isTSEnumMember as isTSEnumMember, indexLegacy_d_isTSExportAssignment as isTSExportAssignment, indexLegacy_d_isTSExpressionWithTypeArguments as isTSExpressionWithTypeArguments, indexLegacy_d_isTSExternalModuleReference as isTSExternalModuleReference, indexLegacy_d_isTSFunctionType as isTSFunctionType, indexLegacy_d_isTSImportEqualsDeclaration as isTSImportEqualsDeclaration, indexLegacy_d_isTSImportType as isTSImportType, indexLegacy_d_isTSIndexSignature as isTSIndexSignature, indexLegacy_d_isTSIndexedAccessType as isTSIndexedAccessType, indexLegacy_d_isTSInferType as isTSInferType, indexLegacy_d_isTSInstantiationExpression as isTSInstantiationExpression, indexLegacy_d_isTSInterfaceBody as isTSInterfaceBody, indexLegacy_d_isTSInterfaceDeclaration as isTSInterfaceDeclaration, indexLegacy_d_isTSIntersectionType as isTSIntersectionType, indexLegacy_d_isTSIntrinsicKeyword as isTSIntrinsicKeyword, indexLegacy_d_isTSLiteralType as isTSLiteralType, indexLegacy_d_isTSMappedType as isTSMappedType, indexLegacy_d_isTSMethodSignature as isTSMethodSignature, indexLegacy_d_isTSModuleBlock as isTSModuleBlock, indexLegacy_d_isTSModuleDeclaration as isTSModuleDeclaration, indexLegacy_d_isTSNamedTupleMember as isTSNamedTupleMember, indexLegacy_d_isTSNamespaceExportDeclaration as isTSNamespaceExportDeclaration, indexLegacy_d_isTSNeverKeyword as isTSNeverKeyword, indexLegacy_d_isTSNonNullExpression as isTSNonNullExpression, indexLegacy_d_isTSNullKeyword as isTSNullKeyword, indexLegacy_d_isTSNumberKeyword as isTSNumberKeyword, indexLegacy_d_isTSObjectKeyword as isTSObjectKeyword, indexLegacy_d_isTSOptionalType as isTSOptionalType, indexLegacy_d_isTSParameterProperty as isTSParameterProperty, indexLegacy_d_isTSParenthesizedType as isTSParenthesizedType, indexLegacy_d_isTSPropertySignature as isTSPropertySignature, indexLegacy_d_isTSQualifiedName as isTSQualifiedName, indexLegacy_d_isTSRestType as isTSRestType, indexLegacy_d_isTSSatisfiesExpression as isTSSatisfiesExpression, indexLegacy_d_isTSStringKeyword as isTSStringKeyword, indexLegacy_d_isTSSymbolKeyword as isTSSymbolKeyword, indexLegacy_d_isTSThisType as isTSThisType, indexLegacy_d_isTSTupleType as isTSTupleType, indexLegacy_d_isTSType as isTSType, indexLegacy_d_isTSTypeAliasDeclaration as isTSTypeAliasDeclaration, indexLegacy_d_isTSTypeAnnotation as isTSTypeAnnotation, indexLegacy_d_isTSTypeAssertion as isTSTypeAssertion, indexLegacy_d_isTSTypeElement as isTSTypeElement, indexLegacy_d_isTSTypeLiteral as isTSTypeLiteral, indexLegacy_d_isTSTypeOperator as isTSTypeOperator, indexLegacy_d_isTSTypeParameter as isTSTypeParameter, indexLegacy_d_isTSTypeParameterDeclaration as isTSTypeParameterDeclaration, indexLegacy_d_isTSTypeParameterInstantiation as isTSTypeParameterInstantiation, indexLegacy_d_isTSTypePredicate as isTSTypePredicate, indexLegacy_d_isTSTypeQuery as isTSTypeQuery, indexLegacy_d_isTSTypeReference as isTSTypeReference, indexLegacy_d_isTSUndefinedKeyword as isTSUndefinedKeyword, indexLegacy_d_isTSUnionType as isTSUnionType, indexLegacy_d_isTSUnknownKeyword as isTSUnknownKeyword, indexLegacy_d_isTSVoidKeyword as isTSVoidKeyword, indexLegacy_d_isTaggedTemplateExpression as isTaggedTemplateExpression, indexLegacy_d_isTemplateElement as isTemplateElement, indexLegacy_d_isTemplateLiteral as isTemplateLiteral, indexLegacy_d_isTerminatorless as isTerminatorless, indexLegacy_d_isThisExpression as isThisExpression, indexLegacy_d_isThisTypeAnnotation as isThisTypeAnnotation, indexLegacy_d_isThrowStatement as isThrowStatement, indexLegacy_d_isTopicReference as isTopicReference, indexLegacy_d_isTryStatement as isTryStatement, indexLegacy_d_isTupleExpression as isTupleExpression, indexLegacy_d_isTupleTypeAnnotation as isTupleTypeAnnotation, indexLegacy_d_isType as isType, indexLegacy_d_isTypeAlias as isTypeAlias, indexLegacy_d_isTypeAnnotation as isTypeAnnotation, indexLegacy_d_isTypeCastExpression as isTypeCastExpression, indexLegacy_d_isTypeParameter as isTypeParameter, indexLegacy_d_isTypeParameterDeclaration as isTypeParameterDeclaration, indexLegacy_d_isTypeParameterInstantiation as isTypeParameterInstantiation, indexLegacy_d_isTypeScript as isTypeScript, indexLegacy_d_isTypeofTypeAnnotation as isTypeofTypeAnnotation, indexLegacy_d_isUnaryExpression as isUnaryExpression, indexLegacy_d_isUnaryLike as isUnaryLike, indexLegacy_d_isUnionTypeAnnotation as isUnionTypeAnnotation, indexLegacy_d_isUpdateExpression as isUpdateExpression, indexLegacy_d_isUserWhitespacable as isUserWhitespacable, indexLegacy_d_isV8IntrinsicIdentifier as isV8IntrinsicIdentifier, indexLegacy_d_isValidES3Identifier as isValidES3Identifier, indexLegacy_d_isValidIdentifier as isValidIdentifier, indexLegacy_d_isVar as isVar, indexLegacy_d_isVariableDeclaration as isVariableDeclaration, indexLegacy_d_isVariableDeclarator as isVariableDeclarator, indexLegacy_d_isVariance as isVariance, indexLegacy_d_isVoidTypeAnnotation as isVoidTypeAnnotation, indexLegacy_d_isWhile as isWhile, indexLegacy_d_isWhileStatement as isWhileStatement, indexLegacy_d_isWithStatement as isWithStatement, indexLegacy_d_isYieldExpression as isYieldExpression, indexLegacy_d_jsxAttribute as jsxAttribute, indexLegacy_d_jsxClosingElement as jsxClosingElement, indexLegacy_d_jsxClosingFragment as jsxClosingFragment, indexLegacy_d_jsxElement as jsxElement, indexLegacy_d_jsxEmptyExpression as jsxEmptyExpression, indexLegacy_d_jsxExpressionContainer as jsxExpressionContainer, indexLegacy_d_jsxFragment as jsxFragment, indexLegacy_d_jsxIdentifier as jsxIdentifier, indexLegacy_d_jsxMemberExpression as jsxMemberExpression, indexLegacy_d_jsxNamespacedName as jsxNamespacedName, indexLegacy_d_jsxOpeningElement as jsxOpeningElement, indexLegacy_d_jsxOpeningFragment as jsxOpeningFragment, indexLegacy_d_jsxSpreadAttribute as jsxSpreadAttribute, indexLegacy_d_jsxSpreadChild as jsxSpreadChild, indexLegacy_d_jsxText as jsxText, indexLegacy_d_labeledStatement as labeledStatement, indexLegacy_d_logicalExpression as logicalExpression, indexLegacy_d_matchesPattern as matchesPattern, indexLegacy_d_memberExpression as memberExpression, indexLegacy_d_metaProperty as metaProperty, indexLegacy_d_mixedTypeAnnotation as mixedTypeAnnotation, indexLegacy_d_moduleExpression as moduleExpression, indexLegacy_d_newExpression as newExpression, indexLegacy_d_nullLiteral as nullLiteral, indexLegacy_d_nullLiteralTypeAnnotation as nullLiteralTypeAnnotation, indexLegacy_d_nullableTypeAnnotation as nullableTypeAnnotation, indexLegacy_d_numberLiteralTypeAnnotation as numberLiteralTypeAnnotation, indexLegacy_d_numberTypeAnnotation as numberTypeAnnotation, indexLegacy_d_numericLiteral as numericLiteral, indexLegacy_d_objectExpression as objectExpression, indexLegacy_d_objectMethod as objectMethod, indexLegacy_d_objectPattern as objectPattern, indexLegacy_d_objectProperty as objectProperty, indexLegacy_d_objectTypeAnnotation as objectTypeAnnotation, indexLegacy_d_objectTypeCallProperty as objectTypeCallProperty, indexLegacy_d_objectTypeIndexer as objectTypeIndexer, indexLegacy_d_objectTypeInternalSlot as objectTypeInternalSlot, indexLegacy_d_objectTypeProperty as objectTypeProperty, indexLegacy_d_objectTypeSpreadProperty as objectTypeSpreadProperty, indexLegacy_d_opaqueType as opaqueType, indexLegacy_d_optionalCallExpression as optionalCallExpression, indexLegacy_d_optionalIndexedAccessType as optionalIndexedAccessType, indexLegacy_d_optionalMemberExpression as optionalMemberExpression, indexLegacy_d_parenthesizedExpression as parenthesizedExpression, indexLegacy_d_pipelineBareFunction as pipelineBareFunction, indexLegacy_d_pipelinePrimaryTopicReference as pipelinePrimaryTopicReference, indexLegacy_d_pipelineTopicExpression as pipelineTopicExpression, indexLegacy_d_placeholder as placeholder, indexLegacy_d_prependToMemberExpression as prependToMemberExpression, indexLegacy_d_privateName as privateName, indexLegacy_d_program as program, indexLegacy_d_qualifiedTypeIdentifier as qualifiedTypeIdentifier, indexLegacy_d_recordExpression as recordExpression, indexLegacy_d_regExpLiteral as regExpLiteral, indexLegacy_d_removeComments as removeComments, indexLegacy_d_removeProperties as removeProperties, indexLegacy_d_removePropertiesDeep as removePropertiesDeep, indexLegacy_d_removeTypeDuplicates as removeTypeDuplicates, indexLegacy_d_restElement as restElement, indexLegacy_d_returnStatement as returnStatement, indexLegacy_d_sequenceExpression as sequenceExpression, indexLegacy_d_shallowEqual as shallowEqual, indexLegacy_d_spreadElement as spreadElement, indexLegacy_d_staticBlock as staticBlock, indexLegacy_d_stringLiteral as stringLiteral, indexLegacy_d_stringLiteralTypeAnnotation as stringLiteralTypeAnnotation, indexLegacy_d_stringTypeAnnotation as stringTypeAnnotation, _super as super, indexLegacy_d_switchCase as switchCase, indexLegacy_d_switchStatement as switchStatement, indexLegacy_d_symbolTypeAnnotation as symbolTypeAnnotation, indexLegacy_d_taggedTemplateExpression as taggedTemplateExpression, indexLegacy_d_templateElement as templateElement, indexLegacy_d_templateLiteral as templateLiteral, indexLegacy_d_thisExpression as thisExpression, indexLegacy_d_thisTypeAnnotation as thisTypeAnnotation, indexLegacy_d_throwStatement as throwStatement, indexLegacy_d_toBindingIdentifierName as toBindingIdentifierName, indexLegacy_d_toBlock as toBlock, indexLegacy_d_toComputedKey as toComputedKey, indexLegacy_d_toExpression as toExpression, indexLegacy_d_toIdentifier as toIdentifier, indexLegacy_d_toKeyAlias as toKeyAlias, indexLegacy_d_toSequenceExpression as toSequenceExpression, indexLegacy_d_toStatement as toStatement, indexLegacy_d_topicReference as topicReference, indexLegacy_d_traverse as traverse, indexLegacy_d_traverseFast as traverseFast, indexLegacy_d_tryStatement as tryStatement, indexLegacy_d_tsAnyKeyword as tsAnyKeyword, indexLegacy_d_tsArrayType as tsArrayType, indexLegacy_d_tsAsExpression as tsAsExpression, indexLegacy_d_tsBigIntKeyword as tsBigIntKeyword, indexLegacy_d_tsBooleanKeyword as tsBooleanKeyword, indexLegacy_d_tsCallSignatureDeclaration as tsCallSignatureDeclaration, indexLegacy_d_tsConditionalType as tsConditionalType, indexLegacy_d_tsConstructSignatureDeclaration as tsConstructSignatureDeclaration, indexLegacy_d_tsConstructorType as tsConstructorType, indexLegacy_d_tsDeclareFunction as tsDeclareFunction, indexLegacy_d_tsDeclareMethod as tsDeclareMethod, indexLegacy_d_tsEnumDeclaration as tsEnumDeclaration, indexLegacy_d_tsEnumMember as tsEnumMember, indexLegacy_d_tsExportAssignment as tsExportAssignment, indexLegacy_d_tsExpressionWithTypeArguments as tsExpressionWithTypeArguments, indexLegacy_d_tsExternalModuleReference as tsExternalModuleReference, indexLegacy_d_tsFunctionType as tsFunctionType, indexLegacy_d_tsImportEqualsDeclaration as tsImportEqualsDeclaration, indexLegacy_d_tsImportType as tsImportType, indexLegacy_d_tsIndexSignature as tsIndexSignature, indexLegacy_d_tsIndexedAccessType as tsIndexedAccessType, indexLegacy_d_tsInferType as tsInferType, indexLegacy_d_tsInstantiationExpression as tsInstantiationExpression, indexLegacy_d_tsInterfaceBody as tsInterfaceBody, indexLegacy_d_tsInterfaceDeclaration as tsInterfaceDeclaration, indexLegacy_d_tsIntersectionType as tsIntersectionType, indexLegacy_d_tsIntrinsicKeyword as tsIntrinsicKeyword, indexLegacy_d_tsLiteralType as tsLiteralType, indexLegacy_d_tsMappedType as tsMappedType, indexLegacy_d_tsMethodSignature as tsMethodSignature, indexLegacy_d_tsModuleBlock as tsModuleBlock, indexLegacy_d_tsModuleDeclaration as tsModuleDeclaration, indexLegacy_d_tsNamedTupleMember as tsNamedTupleMember, indexLegacy_d_tsNamespaceExportDeclaration as tsNamespaceExportDeclaration, indexLegacy_d_tsNeverKeyword as tsNeverKeyword, indexLegacy_d_tsNonNullExpression as tsNonNullExpression, indexLegacy_d_tsNullKeyword as tsNullKeyword, indexLegacy_d_tsNumberKeyword as tsNumberKeyword, indexLegacy_d_tsObjectKeyword as tsObjectKeyword, indexLegacy_d_tsOptionalType as tsOptionalType, indexLegacy_d_tsParameterProperty as tsParameterProperty, indexLegacy_d_tsParenthesizedType as tsParenthesizedType, indexLegacy_d_tsPropertySignature as tsPropertySignature, indexLegacy_d_tsQualifiedName as tsQualifiedName, indexLegacy_d_tsRestType as tsRestType, indexLegacy_d_tsSatisfiesExpression as tsSatisfiesExpression, indexLegacy_d_tsStringKeyword as tsStringKeyword, indexLegacy_d_tsSymbolKeyword as tsSymbolKeyword, indexLegacy_d_tsThisType as tsThisType, indexLegacy_d_tsTupleType as tsTupleType, indexLegacy_d_tsTypeAliasDeclaration as tsTypeAliasDeclaration, indexLegacy_d_tsTypeAnnotation as tsTypeAnnotation, indexLegacy_d_tsTypeAssertion as tsTypeAssertion, indexLegacy_d_tsTypeLiteral as tsTypeLiteral, indexLegacy_d_tsTypeOperator as tsTypeOperator, indexLegacy_d_tsTypeParameter as tsTypeParameter, indexLegacy_d_tsTypeParameterDeclaration as tsTypeParameterDeclaration, indexLegacy_d_tsTypeParameterInstantiation as tsTypeParameterInstantiation, indexLegacy_d_tsTypePredicate as tsTypePredicate, indexLegacy_d_tsTypeQuery as tsTypeQuery, indexLegacy_d_tsTypeReference as tsTypeReference, indexLegacy_d_tsUndefinedKeyword as tsUndefinedKeyword, indexLegacy_d_tsUnionType as tsUnionType, indexLegacy_d_tsUnknownKeyword as tsUnknownKeyword, indexLegacy_d_tsVoidKeyword as tsVoidKeyword, indexLegacy_d_tupleExpression as tupleExpression, indexLegacy_d_tupleTypeAnnotation as tupleTypeAnnotation, indexLegacy_d_typeAlias as typeAlias, indexLegacy_d_typeAnnotation as typeAnnotation, indexLegacy_d_typeCastExpression as typeCastExpression, indexLegacy_d_typeParameter as typeParameter, indexLegacy_d_typeParameterDeclaration as typeParameterDeclaration, indexLegacy_d_typeParameterInstantiation as typeParameterInstantiation, indexLegacy_d_typeofTypeAnnotation as typeofTypeAnnotation, indexLegacy_d_unaryExpression as unaryExpression, indexLegacy_d_unionTypeAnnotation as unionTypeAnnotation, indexLegacy_d_updateExpression as updateExpression, indexLegacy_d_v8IntrinsicIdentifier as v8IntrinsicIdentifier, indexLegacy_d_validate as validate, indexLegacy_d_valueToNode as valueToNode, indexLegacy_d_variableDeclaration as variableDeclaration, indexLegacy_d_variableDeclarator as variableDeclarator, indexLegacy_d_variance as variance, indexLegacy_d_voidTypeAnnotation as voidTypeAnnotation, indexLegacy_d_whileStatement as whileStatement, indexLegacy_d_withStatement as withStatement, indexLegacy_d_yieldExpression as yieldExpression };
}

// This file is auto-generated! Do not modify it directly.
/* eslint-disable import/no-extraneous-dependencies, @typescript-eslint/consistent-type-imports, prettier/prettier */


type Plugin =
  | "asyncDoExpressions"
  | "asyncGenerators"
  | "bigInt"
  | "classPrivateMethods"
  | "classPrivateProperties"
  | "classProperties"
  | "classStaticBlock" // Enabled by default
  | "decimal"
  | "decorators-legacy"
  | "deferredImportEvaluation"
  | "decoratorAutoAccessors"
  | "destructuringPrivate"
  | "doExpressions"
  | "dynamicImport"
  | "explicitResourceManagement"
  | "exportDefaultFrom"
  | "exportNamespaceFrom" // deprecated
  | "flow"
  | "flowComments"
  | "functionBind"
  | "functionSent"
  | "importMeta"
  | "jsx"
  | "logicalAssignment"
  | "importAssertions" // deprecated
  | "importAttributes"
  | "importReflection"
  | "moduleBlocks"
  | "moduleStringNames"
  | "nullishCoalescingOperator"
  | "numericSeparator"
  | "objectRestSpread"
  | "optionalCatchBinding"
  | "optionalChaining"
  | "partialApplication"
  | "placeholders"
  | "privateIn" // Enabled by default
  | "regexpUnicodeSets" // Enabled by default
  | "sourcePhaseImports"
  | "throwExpressions"
  | "topLevelAwait"
  | "v8intrinsic"
  | ParserPluginWithOptions[0];

type ParserPluginWithOptions =
  | ["decorators", DecoratorsPluginOptions]
  | ["estree", { classFeatures?: boolean }]
  | ["importAttributes", { deprecatedAssertSyntax: boolean }]
  // @deprecated
  | ["moduleAttributes", { version: "may-2020" }]
  | ["optionalChainingAssign", { version: "2023-07" }]
  | ["pipelineOperator", PipelineOperatorPluginOptions]
  | ["recordAndTuple", RecordAndTuplePluginOptions]
  | ["flow", FlowPluginOptions]
  | ["typescript", TypeScriptPluginOptions];

type PluginConfig = Plugin | ParserPluginWithOptions;

interface DecoratorsPluginOptions {
  decoratorsBeforeExport?: boolean;
  allowCallParenthesized?: boolean;
}

interface PipelineOperatorPluginOptions {
  proposal: "minimal" | "fsharp" | "hack" | "smart";
  topicToken?: "%" | "#" | "@@" | "^^" | "^";
}

interface RecordAndTuplePluginOptions {
  syntaxType: "bar" | "hash";
}

interface FlowPluginOptions {
  all?: boolean;
  enums?: boolean;
}

interface TypeScriptPluginOptions {
  dts?: boolean;
  disallowAmbiguousJSXLike?: boolean;
}

// Type definitions for @babel/parser
// Project: https://github.com/babel/babel/tree/main/packages/babel-parser
// Definitions by: Troy Gerwien <https://github.com/yortus>
//                 Marvin Hagemeister <https://github.com/marvinhagemeister>
//                 Avi Vahl <https://github.com/AviVahl>
// TypeScript Version: 2.9

/**
 * Parse the provided code as an entire ECMAScript program.
 */
declare function parse(
  input: string,
  options?: ParserOptions
): ParseResult<File>;

/**
 * Parse the provided code as a single expression.
 */
declare function parseExpression(
  input: string,
  options?: ParserOptions
): ParseResult<Expression>;

interface ParserOptions {
  /**
   * By default, import and export declarations can only appear at a program's top level.
   * Setting this option to true allows them anywhere where a statement is allowed.
   */
  allowImportExportEverywhere?: boolean;

  /**
   * By default, await use is not allowed outside of an async function.
   * Set this to true to accept such code.
   */
  allowAwaitOutsideFunction?: boolean;

  /**
   * By default, a return statement at the top level raises an error.
   * Set this to true to accept such code.
   */
  allowReturnOutsideFunction?: boolean;

  /**
   * By default, new.target use is not allowed outside of a function or class.
   * Set this to true to accept such code.
   */
  allowNewTargetOutsideFunction?: boolean;

  allowSuperOutsideMethod?: boolean;

  /**
   * By default, exported identifiers must refer to a declared variable.
   * Set this to true to allow export statements to reference undeclared variables.
   */
  allowUndeclaredExports?: boolean;

  /**
   * By default, Babel parser JavaScript code according to Annex B syntax.
   * Set this to `false` to disable such behavior.
   */
  annexB?: boolean;

  /**
   * By default, Babel attaches comments to adjacent AST nodes.
   * When this option is set to false, comments are not attached.
   * It can provide up to 30% performance improvement when the input code has many comments.
   * @babel/eslint-parser will set it for you.
   * It is not recommended to use attachComment: false with Babel transform,
   * as doing so removes all the comments in output code, and renders annotations such as
   * /* istanbul ignore next *\/ nonfunctional.
   */
  attachComment?: boolean;

  /**
   * By default, Babel always throws an error when it finds some invalid code.
   * When this option is set to true, it will store the parsing error and
   * try to continue parsing the invalid input file.
   */
  errorRecovery?: boolean;

  /**
   * Indicate the mode the code should be parsed in.
   * Can be one of "script", "module", or "unambiguous". Defaults to "script".
   * "unambiguous" will make @babel/parser attempt to guess, based on the presence
   * of ES6 import or export statements.
   * Files with ES6 imports and exports are considered "module" and are otherwise "script".
   */
  sourceType?: "script" | "module" | "unambiguous";

  /**
   * Correlate output AST nodes with their source filename.
   * Useful when generating code and source maps from the ASTs of multiple input files.
   */
  sourceFilename?: string;

  /**
   * By default, the first line of code parsed is treated as line 1.
   * You can provide a line number to alternatively start with.
   * Useful for integration with other source tools.
   */
  startLine?: number;

  /**
   * By default, the parsed code is treated as if it starts from line 1, column 0.
   * You can provide a column number to alternatively start with.
   * Useful for integration with other source tools.
   */
  startColumn?: number;

  /**
   * Array containing the plugins that you want to enable.
   */
  plugins?: ParserPlugin[];

  /**
   * Should the parser work in strict mode.
   * Defaults to true if sourceType === 'module'. Otherwise, false.
   */
  strictMode?: boolean;

  /**
   * Adds a ranges property to each node: [node.start, node.end]
   */
  ranges?: boolean;

  /**
   * Adds all parsed tokens to a tokens property on the File node.
   */
  tokens?: boolean;

  /**
   * By default, the parser adds information about parentheses by setting
   * `extra.parenthesized` to `true` as needed.
   * When this option is `true` the parser creates `ParenthesizedExpression`
   * AST nodes instead of using the `extra` property.
   */
  createParenthesizedExpressions?: boolean;

  /**
   * The default is false in Babel 7 and true in Babel 8
   * Set this to true to parse it as an `ImportExpression` node.
   * Otherwise `import(foo)` is parsed as `CallExpression(Import, [Identifier(foo)])`.
   */
  createImportExpressions?: boolean;
}

type ParserPlugin = PluginConfig;


declare const tokTypes: {
  // todo(flow->ts) real token type
  [name: string]: any;
};

interface ParseError {
  code: string;
  reasonCode: string;
}

type ParseResult<Result> = Result & {
  errors: ParseError[];
};

interface Location {
    start: {
        line: number;
        column: number;
    };
}

interface CodeFrameOptions {}

interface TemplateOptions {}

declare function codeFrameColumns(rawLines: string, location: Location, options: CodeFrameOptions): string;
declare function ast(source: string): Node;
declare function generate(ast: Node): string;
declare function template(source: string, options?: TemplateOptions): string;
declare namespace template {
    export { ast };
}

export { type DecoratorsPluginOptions, type FlowPluginOptions, type ParseError, type ParseResult, type ParserOptions, type ParserPlugin, type ParserPluginWithOptions, type PipelineOperatorPluginOptions, type RecordAndTuplePluginOptions, type TypeScriptPluginOptions, codeFrameColumns, generate, parse, parseExpression, template, tokTypes, traverse, indexLegacy_d as types };
