"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportsAutofix = exports.postprocess = exports.preprocess = exports.meta = void 0;
const shared_1 = require("../shared");
exports.meta = __importStar(require("../meta"));
/** preprocess */
function preprocess(code, filename) {
    if (filename) {
        (0, shared_1.beginShared)(filename);
    }
    return [code];
}
exports.preprocess = preprocess;
/** postprocess */
function postprocess([messages], filename) {
    const shared = (0, shared_1.terminateShared)(filename);
    if (shared) {
        return filter(messages, shared);
    }
    return messages;
}
exports.postprocess = postprocess;
exports.supportsAutofix = true;
/** Filter  */
function filter(messages, shared) {
    if (shared.commentDirectives.length === 0) {
        return messages;
    }
    let filteredMessages = messages;
    for (const cd of shared.commentDirectives) {
        filteredMessages = cd.filterMessages(filteredMessages);
    }
    return filteredMessages;
}
