"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.anyList = exports.AnyListMatcher = void 0;
const distributeAcrossSlices_1 = require("../utils/distributeAcrossSlices");
const Matcher_1 = require("./Matcher");
const slice_1 = require("./slice");
class AnyListMatcher extends Matcher_1.Matcher {
    constructor(matchers) {
        super();
        this.matchers = matchers;
        this.sliceMatchers = [];
        for (const matcher of matchers) {
            if (matcher instanceof slice_1.SliceMatcher) {
                this.sliceMatchers.push(matcher);
            }
        }
    }
    matchValue(array, keys) {
        if (!Array.isArray(array)) {
            return false;
        }
        if (this.matchers.length === 0 && array.length === 0) {
            return true;
        }
        const spacerAllocations = (0, distributeAcrossSlices_1.distributeAcrossSlices)(this.sliceMatchers, array.length - this.matchers.length + this.sliceMatchers.length);
        for (const allocations of spacerAllocations) {
            const valuesToMatch = array.slice();
            let matchedAll = true;
            let key = 0;
            for (const matcher of this.matchers) {
                if (matcher instanceof slice_1.SliceMatcher) {
                    let sliceValueCount = allocations.shift() || 0;
                    while (sliceValueCount > 0) {
                        const valueToMatch = valuesToMatch.shift();
                        if (!matcher.matchValue(valueToMatch, [...keys, key])) {
                            matchedAll = false;
                            break;
                        }
                        sliceValueCount--;
                        key++;
                    }
                }
                else if (!matcher.matchValue(valuesToMatch.shift(), [...keys, key])) {
                    matchedAll = false;
                    break;
                }
                else {
                    key++;
                }
            }
            if (matchedAll) {
                if (valuesToMatch.length > 0) {
                    throw new Error(`expected to consume all elements to match but ${valuesToMatch.length} remain!`);
                }
                return true;
            }
        }
        return false;
    }
}
exports.AnyListMatcher = AnyListMatcher;
function anyList(...elements) {
    return new AnyListMatcher(elements);
}
exports.anyList = anyList;
//# sourceMappingURL=anyList.js.map