"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.containerOf = exports.ContainerOfMatcher = void 0;
const t = __importStar(require("@babel/types"));
const capture_1 = require("./capture");
/**
 * Matches and captures using another matcher by recursively checking all
 * descendants of a given node. The matched descendant is captured as the
 * current value of this capturing matcher.
 */
class ContainerOfMatcher extends capture_1.CapturedMatcher {
    constructor(containedMatcher) {
        super();
        this.containedMatcher = containedMatcher;
    }
    matchValue(value, keys) {
        if (!t.isNode(value)) {
            return false;
        }
        if (this.containedMatcher.matchValue(value, keys)) {
            this.capture(value, keys);
            return true;
        }
        for (const key in value) {
            const valueAtKey = value[key];
            if (Array.isArray(valueAtKey)) {
                for (const [i, element] of valueAtKey.entries()) {
                    if (this.matchValue(element, [...keys, key, i])) {
                        return true;
                    }
                }
            }
            else if (this.matchValue(valueAtKey, [...keys, key])) {
                return true;
            }
        }
        return false;
    }
}
exports.ContainerOfMatcher = ContainerOfMatcher;
function containerOf(containedMatcher) {
    return new ContainerOfMatcher(containedMatcher);
}
exports.containerOf = containerOf;
//# sourceMappingURL=containerOf.js.map