/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.codemods;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.codemods.NodeBasedRecipe;

public final class ApplyCodemod
extends NodeBasedRecipe {
    @Option(displayName="Codemod transform", description="Transform to be applied using the executable.", example="-t path/to/transform/optimus-prime")
    private final @Nullable String transform;
    @Option(displayName="Codemod executable", description="Path to the codemod executable relative to the NPM directory. Defaults to `jscodeshift/bin/jscodeshift.js`.", example="@next/codemod/bin/next-codemod.js", required=false)
    private final @Nullable String executable;
    @Option(displayName="File filter", description="Optional glob pattern to filter files to apply the codemod to. Defaults to all files. Note: not all codemods support file glob filtering.", example="**/*.(j|t)sx")
    private final @Nullable String fileFilter;
    @Option(displayName="Codemod command arguments", description="Arguments which get passed to the codemod command.", example="--force --jscodeshift='--parser=${parser}'", required=false)
    private final @Nullable List<String> codemodArgs;

    public String getDisplayName() {
        return "Applies a codemod to all source files";
    }

    public String getDescription() {
        return "Applies a codemod represented by an NPM package to all source files.";
    }

    @Override
    protected List<String> getNpmCommand(NodeBasedRecipe.Accumulator acc, ExecutionContext ctx) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("node");
        String exec = this.executable == null ? "${nodeModules}/.bin/jscodeshift -t" : "${nodeModules}/" + this.executable;
        String template = "${exec} ${nodeModules}/${transform} ${repoDir}${fileFilter} ${codemodArgs}";
        template = template.replace("${exec}", exec);
        template = template.replace("${transform}", Objects.requireNonNull(this.transform));
        for (String part : template.split(" ")) {
            part = part.trim();
            int argsIdx = (part = part.replace("${fileFilter}", this.fileFilter != null ? "/" + this.fileFilter : "")).indexOf("${codemodArgs}");
            if (argsIdx != -1) {
                String prefix = part.substring(0, argsIdx);
                if (!prefix.isEmpty()) {
                    command.add(prefix);
                }
                command.addAll(Optional.ofNullable(this.codemodArgs).orElse(Collections.emptyList()));
                String suffix = part.substring(argsIdx + "${codemodArgs}".length());
                if (suffix.isEmpty()) continue;
                command.add(suffix);
                continue;
            }
            command.add(part);
        }
        return command;
    }

    @Generated
    public ApplyCodemod(@Nullable String transform, @Nullable String executable, @Nullable String fileFilter, @Nullable List<String> codemodArgs) {
        this.transform = transform;
        this.executable = executable;
        this.fileFilter = fileFilter;
        this.codemodArgs = codemodArgs;
    }

    @Generated
    public @Nullable String getTransform() {
        return this.transform;
    }

    @Generated
    public @Nullable String getExecutable() {
        return this.executable;
    }

    @Generated
    public @Nullable String getFileFilter() {
        return this.fileFilter;
    }

    @Generated
    public @Nullable List<String> getCodemodArgs() {
        return this.codemodArgs;
    }

    @Generated
    public String toString() {
        return "ApplyCodemod(transform=" + this.getTransform() + ", executable=" + this.getExecutable() + ", fileFilter=" + this.getFileFilter() + ", codemodArgs=" + this.getCodemodArgs() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplyCodemod)) {
            return false;
        }
        ApplyCodemod other = (ApplyCodemod)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$transform = this.getTransform();
        String other$transform = other.getTransform();
        if (this$transform == null ? other$transform != null : !this$transform.equals(other$transform)) {
            return false;
        }
        String this$executable = this.getExecutable();
        String other$executable = other.getExecutable();
        if (this$executable == null ? other$executable != null : !this$executable.equals(other$executable)) {
            return false;
        }
        String this$fileFilter = this.getFileFilter();
        String other$fileFilter = other.getFileFilter();
        if (this$fileFilter == null ? other$fileFilter != null : !this$fileFilter.equals(other$fileFilter)) {
            return false;
        }
        List<String> this$codemodArgs = this.getCodemodArgs();
        List<String> other$codemodArgs = other.getCodemodArgs();
        return !(this$codemodArgs == null ? other$codemodArgs != null : !((Object)this$codemodArgs).equals(other$codemodArgs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApplyCodemod;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $transform = this.getTransform();
        result = result * 59 + ($transform == null ? 43 : $transform.hashCode());
        String $executable = this.getExecutable();
        result = result * 59 + ($executable == null ? 43 : $executable.hashCode());
        String $fileFilter = this.getFileFilter();
        result = result * 59 + ($fileFilter == null ? 43 : $fileFilter.hashCode());
        List<String> $codemodArgs = this.getCodemodArgs();
        result = result * 59 + ($codemodArgs == null ? 43 : ((Object)$codemodArgs).hashCode());
        return result;
    }
}

