"use strict";
var __asyncValues = (this && this.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
var __await = (this && this.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncGenerator = (this && this.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TransformRunner = exports.SourceTransformResultKind = exports.Source = void 0;
class Source {
    constructor(path, content) {
        this.path = path;
        this.content = content;
    }
}
exports.Source = Source;
var SourceTransformResultKind;
(function (SourceTransformResultKind) {
    SourceTransformResultKind["Transformed"] = "Transformed";
    SourceTransformResultKind["Error"] = "Error";
})(SourceTransformResultKind = exports.SourceTransformResultKind || (exports.SourceTransformResultKind = {}));
class TransformRunner {
    constructor(sources, transformer) {
        this.sources = sources;
        this.transformer = transformer;
    }
    run() {
        return __asyncGenerator(this, arguments, function* run_1() {
            var e_1, _a;
            try {
                for (var _b = __asyncValues(this.sources), _c; _c = yield __await(_b.next()), !_c.done;) {
                    const source = _c.value;
                    let result;
                    try {
                        const output = yield __await(this.transformer.transform(source.path, source.content));
                        result = {
                            kind: SourceTransformResultKind.Transformed,
                            source,
                            output,
                        };
                    }
                    catch (error) {
                        result = { kind: SourceTransformResultKind.Error, source, error };
                    }
                    yield yield __await(result);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) yield __await(_a.call(_b));
                }
                finally { if (e_1) throw e_1.error; }
            }
        });
    }
}
exports.TransformRunner = TransformRunner;
//# sourceMappingURL=TransformRunner.js.map