"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.oneOf = exports.OneOfMatcher = void 0;
const Matcher_1 = require("./Matcher");
class OneOfMatcher extends Matcher_1.Matcher {
    constructor(matcher) {
        super();
        this.matcher = matcher;
    }
    matchValue(value, keys) {
        if (!Array.isArray(value)) {
            return false;
        }
        if (value.length !== 1) {
            return false;
        }
        return this.matcher.matchValue(value[0], [...keys, 0]);
    }
}
exports.OneOfMatcher = OneOfMatcher;
function oneOf(matcher) {
    return new OneOfMatcher(matcher);
}
exports.oneOf = oneOf;
//# sourceMappingURL=oneOf.js.map