import * as Babel from '@babel/core';
import { ParserOptions, ParserPluginName } from '@codemod/parser';
export declare class Plugin {
    readonly rawPlugin: (babel: typeof Babel) => Babel.PluginObj;
    readonly inferredName: string;
    readonly source?: string | undefined;
    readonly resolvedPath?: string | undefined;
    readonly declaredName?: string;
    constructor(rawPlugin: (babel: typeof Babel) => Babel.PluginObj, inferredName: string, source?: string | undefined, resolvedPath?: string | undefined);
}
export declare class Config {
    readonly sourcePaths: Array<string>;
    readonly localPlugins: Array<string>;
    readonly remotePlugins: Array<string>;
    readonly pluginOptions: Map<string, object>;
    readonly parserPlugins: Set<ParserPluginName>;
    readonly extensions: Set<string>;
    readonly sourceType: ParserOptions['sourceType'];
    readonly requires: Array<string>;
    readonly transpilePlugins: boolean;
    readonly stdio: boolean;
    readonly dry: boolean;
    constructor(sourcePaths?: Array<string>, localPlugins?: Array<string>, remotePlugins?: Array<string>, pluginOptions?: Map<string, object>, parserPlugins?: Set<ParserPluginName>, extensions?: Set<string>, sourceType?: ParserOptions['sourceType'], requires?: Array<string>, transpilePlugins?: boolean, stdio?: boolean, dry?: boolean);
    private pluginLoader;
    private remotePluginLoader;
    private _pluginCache?;
    getPlugins(): Promise<Array<Plugin>>;
    loadRequires(): void;
    loadBabelTranspile(): Promise<void>;
    getPlugin(name: string): Promise<Plugin | null>;
    getBabelPlugins(): Promise<Array<Babel.PluginItem>>;
    getBabelPlugin(name: string): Promise<Babel.PluginItem | null>;
}
export declare class ConfigBuilder {
    private _sourcePaths?;
    private _localPlugins?;
    private _remotePlugins?;
    private _pluginOptions?;
    private _parserPluginNames;
    private _extensions;
    private _sourceType;
    private _requires?;
    private _transpilePlugins?;
    private _stdio?;
    private _dry?;
    sourcePaths(value: Array<string>): this;
    addSourcePath(value: string): this;
    addSourcePaths(...values: Array<string>): this;
    localPlugins(value: Array<string>): this;
    addLocalPlugin(value: string): this;
    remotePlugins(value: Array<string>): this;
    addRemotePlugin(value: string): this;
    pluginOptions(value: Map<string, object>): this;
    setOptionsForPlugin(options: object, plugin: string): this;
    addParserPlugin(name: ParserPluginName): this;
    extensions(value: Set<string>): this;
    addExtension(value: string): this;
    sourceType(value: ParserOptions['sourceType']): this;
    requires(value: Array<string>): this;
    addRequire(value: string): this;
    transpilePlugins(value: boolean): this;
    stdio(value: boolean): this;
    dry(value: boolean): this;
    build(): Config;
}
