"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.js = void 0;
const parser_1 = require("@codemod/parser");
const NodeTypes_1 = require("./NodeTypes");
function fieldsForNodeType(nodeType) {
    return new Set(['type', ...Object.keys(NodeTypes_1.NODE_FIELDS[nodeType])]);
}
function js(code) {
    return stripExtras((0, parser_1.parse)(code));
}
exports.js = js;
function stripExtras(node) {
    const fieldsToKeep = fieldsForNodeType(node.type);
    const allFields = Object.keys(node);
    for (const field of allFields) {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        const nodeObj = node;
        if (!fieldsToKeep.has(field)) {
            delete nodeObj[field];
        }
        else {
            const children = Array.isArray(nodeObj[field])
                ? nodeObj[field]
                : [nodeObj[field]];
            for (const child of children) {
                if (child &&
                    typeof child === 'object' &&
                    typeof child.type === 'string') {
                    stripExtras(child);
                }
            }
        }
    }
    return node;
}
//# sourceMappingURL=js.js.map