/// <reference types="node" />
import { URL } from 'url';
import { NetworkResolver } from './NetworkResolver';
/**
 * Resolves plugins from AST Explorer transforms.
 *
 * astexplorer.net uses GitHub gists to save and facilitate sharing. This
 * resolver accepts either the editor URL or the gist API URL.
 */
export declare class AstExplorerResolver extends NetworkResolver {
    private readonly baseURL;
    constructor(baseURL?: URL);
    canResolve(source: string): Promise<boolean>;
    resolve(source: string): Promise<string>;
    normalize(source: string): Promise<string>;
    private matchesHost;
}
