"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.expression = exports.statement = exports.program = void 0;
const traverse_1 = __importDefault(require("@babel/traverse"));
const t = __importStar(require("@babel/types"));
const parser_1 = require("@codemod/parser");
function program(template) {
    const ast = (0, parser_1.parse)(template);
    return (replacements = {}) => {
        const unusedReplacements = new Set(Object.keys(replacements));
        (0, traverse_1.default)(ast, {
            Placeholder(path) {
                const name = path.node.name.name;
                const replacement = replacements[name];
                if (!replacement) {
                    throw new Error(`no replacement found for placeholder with name: ${name}`);
                }
                if (Array.isArray(replacement)) {
                    path.replaceWithMultiple(replacement);
                }
                else {
                    path.replaceWith(replacement);
                }
                unusedReplacements.delete(name);
            },
        });
        if (unusedReplacements.size > 0) {
            const names = Array.from(unusedReplacements).join(', ');
            throw new Error(`template replacements were not used: ${names}`);
        }
        return ast;
    };
}
exports.program = program;
function statement(template) {
    const builder = program(template);
    return (replacements) => getSingleStatement(builder(replacements).program.body);
}
exports.statement = statement;
function expression(template) {
    const builder = program(template);
    return (replacements) => getSingleExpression(builder(replacements).program.body);
}
exports.expression = expression;
function getSingleStatement(statements) {
    if (statements.length !== 1) {
        throw new TypeError(`expected a single statement but ${statements.length} statements`);
    }
    return statements[0];
}
function getSingleExpression(statements) {
    if (statements.length !== 1) {
        throw new TypeError(`expected a single expression but ${statements.length} statements`);
    }
    const statement = statements[0];
    if (!t.isExpressionStatement(statement)) {
        throw new TypeError(`expected a single expression but got a single ${statement.type}`);
    }
    return statement.expression;
}
//# sourceMappingURL=builders.js.map