export interface ArrayValidator {
    each: Validator;
}
export interface ChainOfValidator {
    chainOf: Array<Validator>;
}
export interface OneOfValidator {
    oneOf: Array<string | boolean | number>;
}
export interface OneOfNodeTypesValidator {
    oneOfNodeTypes: Array<string>;
}
export interface OneOfNodeOrValueTypesValidator {
    oneOfNodeOrValueTypes: Array<string>;
}
export interface Type {
    type: string;
}
export declare type Validator = ArrayValidator | ChainOfValidator | OneOfValidator | OneOfNodeTypesValidator | OneOfNodeOrValueTypesValidator | Type;
export interface BuilderKeysByType {
    [key: string]: Array<string>;
}
export interface NodeFieldsByType {
    [key: string]: NodeFields;
}
export interface NodeFields {
    [key: string]: NodeField;
}
export interface NodeField<T = unknown> {
    default: T | null;
    optional?: boolean;
    validate: Validator;
}
export declare const BUILDER_KEYS: BuilderKeysByType, NODE_FIELDS: NodeFieldsByType;
