import lintXml from "./xmlTemplate/linter.js";
import lintJson from "./manifestJson/linter.js";
import lintHtml from "./html/linter.js";
import lintUI5Yaml from "./yaml/linter.js";
import lintDotLibrary from "./dotLibrary/linter.js";
import lintFileTypes from "./fileTypes/linter.js";
import { taskStart } from "../utils/perf.js";
import TypeLinter from "./ui5Types/TypeLinter.js";
import LinterContext from "./LinterContext.js";
import { createReader } from "@ui5/fs/resourceFactory";
import { mergeIgnorePatterns, resolveReader } from "./linter.js";
export default async function lintWorkspace(workspace, filePathsWorkspace, options, config, patternsMatch) {
    const done = taskStart("Linting Workspace");
    const { relFsBasePath, virBasePath, relFsBasePathTest, virBasePathTest } = options;
    const context = new LinterContext(options);
    let reader = resolveReader({
        patterns: options.filePatterns ?? config.files ?? [],
        relFsBasePath: relFsBasePath ?? "",
        virBasePath: virBasePath ?? "/",
        relFsBasePathTest, virBasePathTest,
        resourceReader: createReader({
            fsBasePath: options.rootDir,
            virBasePath: "/",
        }),
        inverseResult: true,
        patternsMatch,
    });
    reader = resolveReader({
        patterns: mergeIgnorePatterns(options, config),
        resourceReader: reader,
        patternsMatch,
        relFsBasePath: relFsBasePath ?? "",
        virBasePath: virBasePath ?? "/",
        relFsBasePathTest, virBasePathTest,
    });
    context.setRootReader(reader);
    const params = {
        workspace, filePathsWorkspace, context,
    };
    await Promise.all([
        lintXml(params),
        lintJson(params),
        lintHtml(params),
        lintUI5Yaml(params),
        lintDotLibrary(params),
        lintFileTypes(params),
    ]);
    const typeLinter = new TypeLinter(params);
    await typeLinter.lint();
    done();
    return context.generateLintResults();
}
//# sourceMappingURL=lintWorkspace.js.map